WIM_ButtonsHooked = false;
WIM_TradeSkillIsHooked = false;
WIM_CraftSkillIsHooked = false;
WIM_InspectIsHooked = false;



function WIM_FriendsFrame_SendMessage()
	if(WIM_Data.enableWIM) then
		local name = GetFriendInfo(FriendsFrame.selectedFriend);
		WIM_PostMessage(name, "", 5, "", "");
	else
		WIM_FriendsFrame_SendMessage_orig();
	end
end

function WIM_ChatEdit_ExtractTellTarget(editBox, msg)
	-- Grab the first "word" in the string
	local target = gsub(msg, "(%s*)([^%s]+)(.*)", "%2", 1);
	if ( (strlen(target) <= 0) or (strsub(target, 1, 1) == "|") ) then
		return;
	end
	
	if(WIM_Data.hookWispParse and WIM_Data.enableWIM and WIM_Data.popOnSend and not (WIM_Data.popCombat and UnitAffectingCombat("player"))) then
		target = string.gsub(target, "^%l", string.upper)
		WIM_PostMessage(target, "", 5, "", "");
		editBox:SetText("");
		editBox:Hide();
	else
		WIM_ChatEdit_ExtractTellTarget_orig(editBox, msg);
	end
end


function WIM_HookInspect()
	if(WIM_InspectIsHooked) then
		return;
	end
	
	if(SuperInspectFrame) then
		WIM_SuperInspect_InspectPaperDollItemSlotButton_OnClick_orig = SuperInspect_InspectPaperDollItemSlotButton_OnClick;
		SuperInspect_InspectPaperDollItemSlotButton_OnClick = WIM_SuperInspect_InspectPaperDollItemSlotButton_OnClick;
		WIM_InspectIsHooked = true;
	end
	
	--DEFAULT_CHAT_FRAME:AddMessage("Hooking Complete.");
end

function WIM_AtlasLootItem_OnClick(arg1)
	if ( IsShiftKeyDown() ) then
		if ( WIM_EditBoxInFocus ) then
			local color = strsub(getglobal("AtlasLootItem_"..this:GetID().."_Name"):GetText(), 1, 10);
			local name = strsub(getglobal("AtlasLootItem_"..this:GetID().."_Name"):GetText(), 11);
			WIM_EditBoxInFocus:Insert(color.."|Hitem:"..this.itemID..":0:0:0|h["..name.."]|h|r");
		end
	end
	WIM_AtlasLootItem_OnClick_orig(arg1);
end

function WIM_AllInOneInventoryFrameItemButton_OnClick(button, ignShift)
	if ( IsShiftKeyDown() ) then
		if ( WIM_EditBoxInFocus ) then
			local bag, slot = AllInOneInventory_GetIdAsBagSlot(this:GetID());
			WIM_EditBoxInFocus:Insert(GetContainerItemLink(bag, slot));
		end
	end
	WIM_AllInOneInventoryFrameItemButton_OnClick_orig(button, ignShift);
end

function WIM_SuperInspect_InspectPaperDollItemSlotButton_OnClick(button, ignoreModifiers)
	local itemLink = this.link;
	if ( IsShiftKeyDown() ) then
		if ( WIM_EditBoxInFocus ) then
			local link = "|c"..this.c.."|H"..itemLink.."|h["..GetItemInfo(itemLink).."]|h|r";
			WIM_EditBoxInFocus:Insert(link);
		end
	end
	WIM_SuperInspect_InspectPaperDollItemSlotButton_OnClick_orig(button, ignoreModifiers);
end

-- copy of Lootlink's local function - modified
function WIM_LootLink_GetHyperlink(name)
	local itemLink = ItemLinks[name];
	DEFAULT_CHAT_FRAME:AddMessage("LootLink_GetHyperlink: "..name);
	if( itemLink and itemLink.i ) then
		-- Remove instance-specific data that we captured from the link we return
		local item = string.gsub(itemLink.i, "(%d+):(%d+):(%d+):(%d+)", "%1:0:%3:%4");
		return "item:"..item;
	end
	return nil;
end

-- copy of Lootlink's local function - modified
function WIM_LootLink_GetLink(name)
	local itemLink = ItemLinks[name];
	if( itemLink and itemLink.c and itemLink.i ) then
		local link = "|c"..itemLink.c.."|H"..WIM_LootLink_GetHyperlink(name).."|h["..name.."]|h|r";
		return link;
	end
	return nil;
end



function WIM_EngInventory_ItemButton_OnClick(arg1, arg2)
	if(arg1 == "LeftButton" and IsShiftKeyDown()) then
		if(WIM_EditBoxInFocus) then
			local bar, position, itm, bagnum, slotnum;

			if (EngInventory_buttons[this:GetName()] ~= nil) then
                bar = EngInventory_buttons[this:GetName()]["bar"];
                position = EngInventory_buttons[this:GetName()]["position"];

				bagnum = EngInventory_bar_positions[bar][position]["bagnum"];
				slotnum = EngInventory_bar_positions[bar][position]["slotnum"];

                itm = EngInventory_item_cache[bagnum][slotnum];

				if(itm) then
					WIM_EditBoxInFocus:Insert(GetContainerItemLink(itm["bagnum"], itm["slotnum"]));
					return;
				end
			end
		end
	end
	WIM_EngInventory_ItemButton_OnClick_orig(arg1, arg2);
end


function WIM_FriendsFrame_OnEvent()
  if(event == "WHO_LIST_UPDATE") then
	local numWhos, totalCount = GetNumWhoResults();
	if(numWhos > 0) then
		for i=1, numWhos do 
			local name, guild, level, race, class, zone = GetWhoInfo(i);
			if(WIM_Windows[name] and name ~= "" and name ~= nil) then
				if(WIM_Windows[name].waiting_who) then
					WIM_Windows[name].waiting_who = false;
					WIM_Windows[name].class = class;
					WIM_Windows[name].level = level;
					WIM_Windows[name].race = race;
					WIM_Windows[name].guild = guild;
					WIM_SetWhoInfo(name);
					SetWhoToUI(0);
					return;
				end
			end
		end
	else
		SetWhoToUI(0);
		return;
	end
  end
  WIM_FriendsFrame_OnEvent_orig(event);
end


function WIM_SetItemRef (link, text, button)
	if (WIM_isLinkURL(link)) then
		WIM_DisplayURL(link);
		return;
	end
	if (strsub(link, 1, 6) ~= "player") and ( IsShiftKeyDown() ) and ( not ChatFrameEditBox:IsVisible() ) then
		local itemName = gsub(text, ".*%[(.*)%].*", "%1");
		if(WIM_EditBoxInFocus) then
			WIM_EditBoxInFocus:Insert(text);
		end
	end
end

function WIM_ISync_ButtonClick(button)
	if(button == "LeftButton" and IsShiftKeyDown()) then
		if(WIM_EditBoxInFocus) then
			local name_X, link_X, quality_X, minLevel_X, class_X, subclass_X, maxStack_X = GetItemInfo("item:"..this.storeID);
			if(name_X and link_X and quality_X) then
				WIM_EditBoxInFocus:Insert("|c"..ISync:ReturnHexColor(quality_X).."|H"..link_X.."|h["..name_X.."]|h|r");
			end
		end
	end
end


--Core hooking function. Allows compatibilty across all wow frames.
function WIM_ChatEdit_InsertLink(text)
	if(WIM_EditBoxInFocus) then
		WIM_EditBoxInFocus:Insert(text);
	end
	WIM_ChatEdit_InsertLink_orig(text);
end


function WIM_SetUpHooks()
	if(WIM_ButtonsHooked) then
		return;
	end

	--Hook ChatEdit_InsertLink (If other addons follow this convension all will work the way it should.
	WIM_ChatEdit_InsertLink_orig = ChatEdit_InsertLink;
	ChatEdit_InsertLink = WIM_ChatEdit_InsertLink;
	
	--Hook Friends Frame Send Message Button
	WIM_FriendsFrame_SendMessage_orig = FriendsFrame_SendMessage;
	FriendsFrame_SendMessage = WIM_FriendsFrame_SendMessage;
	
	--Hook Chat Frame Whisper Parse
	WIM_ChatEdit_ExtractTellTarget_orig = ChatEdit_ExtractTellTarget;
	ChatEdit_ExtractTellTarget = WIM_ChatEdit_ExtractTellTarget;
	
	--Hook FriendsFrame_OnEvent
	WIM_FriendsFrame_OnEvent_orig = FriendsFrame_OnEvent;
	FriendsFrame_OnEvent = WIM_FriendsFrame_OnEvent;
	
	--Hook ChatFrame_OnEvent
	WIM_ChatFrame_OnEvent_orig = ChatFrame_OnEvent;
	ChatFrame_OnEvent = function(event) if(WIM_ChatFrameSupressor_OnEvent(event)) then WIM_ChatFrame_OnEvent_orig(event); end; end;
	
	--Hook SetItemRef
	WIM_SetItemRef_orig = SetItemRef;
	SetItemRef = function(link, text, button) if(not WIM_isLinkURL(link)) then WIM_SetItemRef_orig(link, text, button); end; WIM_SetItemRef(link, text, button); end;

	

	--Hook AtlasLoot
	WIM_AtlasLootItem_OnClick_orig = AtlasLootItem_OnClick;
	AtlasLootItem_OnClick = WIM_AtlasLootItem_OnClick;
	
	--Hook AllInOneInventory
	WIM_AllInOneInventoryFrameItemButton_OnClick_orig = AllInOneInventoryFrameItemButton_OnClick;
	AllInOneInventoryFrameItemButton_OnClick = WIM_AllInOneInventoryFrameItemButton_OnClick;
	
	--Hook EngInventory
	WIM_EngInventory_ItemButton_OnClick_orig = EngInventory_ItemButton_OnClick;
	EngInventory_ItemButton_OnClick = WIM_EngInventory_ItemButton_OnClick;
	
	--Hook LootLink
	WIM_LootLinkItemButton_OnClick_orig = LootLinkItemButton_OnClick;
	LootLinkItemButton_OnClick = WIM_LootLinkItemButton_OnClick;
	
	--Hook ItemSync
	if(ISync) then
		for i=1,24 do 
			local button = getglobal("ISyncItem"..i);
			if(button) then
				local origOnClick = button:GetScript("OnClick");
				button:SetScript("OnClick", function() origOnClick(arg1); WIM_ISync_ButtonClick(arg1); end);
			end
		end
	end

	WIM_ButtonsHooked = true;
end


function WIM_AddonDetectToHook(theAddon)
	if(theAddon == "SuperInspect_UI" or theAddon == "Blizzard_InspectUI") then
		WIM_HookInspect();
	end
end
