--[[
	Slash
		This is the slash command handler for Bagnon
--]]

local function DisplayHelp()
	BagnonMsg(BAGNON_HELP_TITLE)
	BagnonMsg(BAGNON_HELP_HELP)
	BagnonMsg(BAGNON_HELP_SHOWBAGS)
	BagnonMsg(BAGNON_HELP_SHOWBANK)
	BagnonMsg(BAGNON_HELP_FIND)
	BagnonMsg(BAGNON_HELP_FINDR)
--[[	
	if( IsAddOnLoaded("Bagnon_Forever") ) then
		BagnonMsg(BAGNON_FOREVER_HELP_DELETE_CHARACTER)
	end
--]]
end

SlashCmdList["BagnonCOMMAND"] = function(msg)
	if not msg or msg == "" then
		local enabled = select(4, GetAddOnInfo("vBagnon_Options"))
		if enabled then
			if not IsAddOnLoaded("vBagnon_Options") then
				LoadAddOn("vBagnon_Options")
			end
			BagnonOptions:Show()
		else
			DisplayHelp()
		end
	else
		local args = strsplit(' ', msg)
		local cmd = select(1, args):lower()
		
		if cmd == BAGNON_COMMAND_HELP then
			DisplayHelp()
		elseif cmd == BAGNON_COMMAND_SHOWBANK then
			Bagnon_ShowBank()
		elseif cmd == BAGNON_COMMAND_SHOWBAGS then
			Bagnon_ShowInventory()
		elseif cmd == BAGNON_COMMAND_DEBUG_ON then
			BagnonSets.noDebug = nil
			BagnonMsg(BAGNON_DEBUG_ENABLED)
		elseif cmd == BAGNON_COMMAND_DEBUG_OFF then
			BagnonSets.noDebug = 1
			BagnonMsg(BAGNON_DEBUG_DISABLED)
--[[
		elseif cmd == BAGNON_FOREVER_COMMAND_DELETE_CHARACTER and IsAddOnLoaded("vBagnon_Forever") then
			BagnonForever_RemovePlayer(args[2], args[3] or GetRealmName())
--]]
		end
	end
end

SLASH_BagnonCOMMAND1 = "/bagnon"
SLASH_BagnonCOMMAND2 = "/bgn"