--[[
	vBagnon\settings.lua
		Loads saved settings and localization data
--]]

--[[ Variable Loading and Updating ]]--

local function LoadDefaults(current)
	BagnonSets = {
		version = current,

		showTooltips = 1,
		showForeverTooltips = 1,
		showBagsAtBank = 1,
		showBagsAtAH = 1,
		showBankAtBank = 1,

		qualityBorders = 1,

		['inventory'] = {
			bags = {0, 1, 2, 3, 4},

			bg = {r = 0, g = 0.2, b = 0, a = 0.5},

			cats = {
				{
					name = 'All',
					rule = 'All',
				},
				{
					name = 'Weapons',
					rule = 'Weapons',
					hide = 1,
				},
				{
					name = 'Armor',
					rule = 'Armor',
					hide = 1,
				},
				{
					name = 'Trinkets',
					rule = 'Trinkets',
					hide = 1,
				},
				{
					name = 'Quest Items',
					rule = 'Quest',
					hide = 1,
				},
				{
					name = 'Trade Goods',
					rule = 'Trade',
					hide = 1,
				},
				{
					name = 'Other',
					rule = 'Miscellaneous',
					hide = 1,
				},
				{
					name = 'Trash',
					rule = 'Trash',
					hide = 1,
				}
			},
		},

		['bank'] = {
			bags = {-1, 5, 6, 7, 8, 9, 10, 11},

			bg = {r = 0, g = 0, b = 0.2, a = 0.5},

			cats = {
				{
					name = 'All',
					rule = 'All',
				},
				{
					name = 'Weapons',
					rule = 'Weapons',
					hide = 1,
				},
				{
					name = 'Armor',
					rule = 'Armor',
					hide = 1,
				},
				{
					name = 'Trinkets',
					rule = 'Trinkets',
					hide = 1,
				},
				{
					name = 'Quest Items',
					rule = 'Quest',
					hide = 1,
				},
				{
					name = 'Trade Goods',
					rule = 'Trade',
					hide = 1,
				},
				{
					name = 'Other',
					rule = 'Miscellaneous',
					hide = 1,
				},
			},
		},
	}
	BagnonMsg(BAGNON_INITIALIZED)
end

local function UpdateSettings(current)
	LoadDefaults(current)
	BagnonSets.version = current
	BagnonMsg(format(BAGNON_UPDATED, current))
end

local function LoadVariables()
	local current = GetAddOnMetadata("vBagnon", "Version")

	if not(BagnonSets and BagnonSets.version) or TLib.VToN(BagnonSets.version) > TLib.VToN(current) then
		LoadDefaults(current)
	elseif TLib.VToN(BagnonSets.version) < TLib.VToN(current) then
		UpdateSettings(current)
	end
end

--[[ Localization Data ]]--

local function HaveLocalizedInfo()
	local locale = GetLocale()
	return (locale == "enUS" or
			locale == "deDE" or
			locale == "frFR" or
			locale == "zhCN" or
			locale == "zhTW" or
			locale == "esES" or
			BagnonSets.noDebug)
end

--try and get localized names, so that its possible to do special bag coloring
local function ObtainLocalizedNames()
	local haveInfo = HaveLocalizedInfo()
	if not haveInfo then
		BagnonMsg("Obtaining localized data.  Please report the following to where you downloaded Bagnon from.")
		BagnonMsg(GetLocale())
	end

	--backpack
	local name, _, _, _, _, iType, subType = GetItemInfo(4500)
	if name then
		if not haveInfo then
			BagnonMsg("Backpack:  " .. (iType or "null") .. ", " .. (subType or "null"))
		end
		if iType then
			BAGNON_ITEMTYPE_CONTAINER = iType
			BAGNON_SUBTYPE_BAG = subType
		end
	end

	--ammo
	name, _, _, _, _, iType, subType = GetItemInfo(8218)
	if name then
		if not haveInfo then
			BagnonMsg("Ammo:  " .. (iType or "null") .. ", " .. (subType or "null"))
		end
		if iType then
			BAGNON_ITEMTYPE_QUIVER = iType
		end
	end

	--soul pouch
	name, _, _, _, _, iType, subType = GetItemInfo(21340)
	if name then
		if not haveInfo then
			BagnonMsg("Soul Bag:  " .. (iType or "null") .. ", " .. (subType or "null"))
		end
		if subType then
			BAGNON_SUBTYPE_SOULBAG = subType
		end
	end
end

--[[ Events ]]--

BEvent:AddAction('PLAYER_LOGIN', function() LoadVariables(); ObtainLocalizedNames() end)