﻿--[[ simpleMinimap ]]--
simpleMinimap = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0", "AceHook-2.1", "AceModuleCore-2.0")
local L = AceLibrary("AceLocale-2.2"):new("simpleMinimap")
L:RegisterTranslations("enUS", function() return({
	alpha = true,
		alpha_desc = "minimap alpha when outdoors",
	bgs = "battlegrounds",
		bgs_desc = "battlegrounds indicator",
	location = "location bar",
		location_desc = "location display bar settings",
			locationShow = "show location bar",
				locationShow_desc = "show / hide location bar",
			locationText = "location bar text",
				locationText_desc = "show zone location text when bar is hidden",
	lock = "lock minimap",
		lock_desc = "lock minimap movement and hide movers",
	map = "map button",
		map_desc = "map frame button",
	mail = "mail indicator",
		mail_desc = "unread mail indicator",
	meet = "LFG indicator",
		meet_desc = "looking for group eyeball",
	modules = true,
	reset = "reset profile",
		reset_desc = "reset current profile to defaults",
	scale = true,
		scale_desc = "set minimap cluster scale",
	show = "show / hide",
		show_desc = "show and hide minimap / UI elements",
	strata = true,
		strata_desc = "changes how the frame is overlayed on others",
	time = "time indicator",
		time_desc = "day / night indicator",
	track = "tracking button",
		track_desc = "hunter / gatherer tracking indicator",
	zoom = "zoom in / out",
		zoom_desc = "zoon in / out buttons",
	reset_popup = "Reset this simpleMinimap profile to defaults?"
}) end)
L:RegisterTranslations("koKR", function() return({
	alpha = "투명도",
		alpha_desc = "minimap alpha when outdoors",
	bgs = "전장",
		bgs_desc = "battlegrounds indicator",
	location = "지역 바",
		location_desc = "지역 표시 바 설정",
			locationShow = "지역 바 표시",
				locationShow_desc = "지역 바 표시 / 숨김",
			locationText = "지역 바 글자",
				locationText_desc = "바를 숨길시 지역 글자를 표시합니다.",
	lock = "미니맵 고정",
		lock_desc = "미니맵 움직임 고정 / 앵커 숨김",
	map = "지도 버튼",
		map_desc = "지도 열기 버튼",
	mail = "우편 인디케이터",
		mail_desc = "읽지 않은 우편 인디케이터",
	meet = "lfg / lfm indicator", -- check
		meet_desc = "looking for group / more indicator", -- check
	modules = "모듈",
	reset = "프로파일 초기화",
		reset_desc = "현재 프로파일을 초기값으로 초기화",
	scale = "크기",
		scale_desc = "미니맵 클러스터 크기 설정",
	show = "표시 / 숨김",
		show_desc = "미니맵 / UI 구성요소 표시와 숨김 ",
	strata = "계층",
		strata_desc = "창의 오버레이 순위 변경",
	time = "시간 인디케이터",
		time_desc = "낮 / 밤 인디케이터",
	track = "추적 버튼",
		track_desc = "사냥꾼 / 채집 추적 인디케이터",
	zoom = "줌 인 / 아웃",
		zoom_desc = "줌 인 / 아웃 버튼",
	reset_popup = "simpleMinimap 프로파일을 초기값으로 초기화 하시겠습니까?"
}) end)
L:RegisterTranslations("deDE", function() return({
	alpha = "helligkeit",
		alpha_desc = "minimap helligkeit wenn außerhalb",
	bgs = "schlachtfelder",
		bgs_desc = "schlachtfeld symbol",
	location = "positionsleiste",
		location_desc = "positionsanzeigeleiste einstellungen",
			locationShow = "zeige positionsleiste",
				locationShow_desc = "zeigt / versteckt die positionsleiste",
			locationText = "positionsleisten text",
				locationText_desc = "zeigt zonen positionstext wenn die leiste versteckt ist",
	lock = "sperre minimap",
		lock_desc = "sperrt die minimap gegen verschieben und versteckt die questfenster",
	map = "kartentaste",
		map_desc = "kartenfenstertaste",
	mail = "postsymbol",
		mail_desc = "entfernt das postsymbol",
	meet = "lfg / lfm symbol",
		meet_desc = "suche nach gruppe / und mehr anzeigen",
	modules = "module",
	reset = "resette profil",
		reset_desc = "resettet das gegenwärige profil auf seine grundeinstellung",
	scale = "skalierung",
		scale_desc = "stellt die minimap skalierung ein",
	show = "zeige / verstecke",
		show_desc = "zeigt oder versteckt die minimap / UI elemente",
	strata = "höhenebene",
		strata_desc = "ändert die höhenebene des fensters im gegensatz zu anderen fenstern (verhindert das 2 fenster die gleiche höhenebene haben und somit ineinander verlaufen)",
	time = "zeitanzeige",
		time_desc = "tag / nachtsymbol",
	track = "suchersymbol",
		track_desc = "jäger / sammler (erze/kräuter) symbol",
	zoom = "zoom rein / raus",
		zoom_desc = "zoon rein / raus tasten",
	reset_popup = "das simpleMinimap profil auf seine grundeinstellung resetten?"
}) end)
BINDING_HEADER_smmTITLE = "simpleMinimap"
BINDING_NAME_smmTOGGLE = "Toggle Minimap"
BINDING_NAME_smmEXPAND = "Expand Minimap"
if(GetLocale() == "koKR") then
	BINDING_NAME_smmTOGGLE = "미니맵 토글"
elseif GetLocale() == "deDE" then
	BINDING_NAME_smmTOGGLE = "Aktiviert Minimap"
end

--[[ setup ]]--
--
function simpleMinimap:OnInitialize()
	self.inside = true
	self.buttons = {
		bgs = MiniMapBattlefieldFrame,
		meet = MiniMapMeetingStoneFrame,
		map = MiniMapWorldMapButton,
		mail = MiniMapMailFrame,
		time = GameTimeFrame,
		track = MiniMapTrackingFrame,
		zoomin = MinimapZoomIn,
		zoomout = MinimapZoomOut
	}
	self.stratas = { "BACKGROUND", "LOW", "MEDIUM", "HIGH", "DIALOG", "FULLSCREEN", "FULLSCREEN_DIALOG", "TOOLTIP" }
	self.defaults = {
		alpha=1, lock=false, mapPosition=false, scale=1, strata=1,
		buttonPos = { bgs=302, map=40, meet=189, mail=169, time=137, track=20, zoomin=209, zoomout=235 },
		locationBar = { show=true, text=true },
		show = { bgs=true, map=true, mail=true, meet=true, time=true, track=true, zoom=true }
	}
	self.options = {
		type="group",
		args={
			title={
				type="header", order=1, name="simpleMinimap |cFFFFFFCCv"..self.version
			},
			spacer1={
				type="header", order=2, name=" "
			},
			alpha={
				type="range", order=3, name=L.alpha, desc=L.alpha_desc,
				min=0, max=1, step=0.05, isPercent=true,
				get=function() return(self.db.profile.alpha) end,
				set=function(x) self.db.profile.alpha=x self:UpdateScreen() end
			},
			scale={
				type="range", order=4, name=L.scale, desc=L.scale_desc,
				min=0.5, max=2, step=0.05,
				get=function() return(self.db.profile.scale) end,
				set=function(x)
					if(self.db.profile.mapPosition) then
						self.db.profile.mapPosition.x = (self.db.profile.scale / x) * self.db.profile.mapPosition.x
						self.db.profile.mapPosition.y = (self.db.profile.scale / x) * self.db.profile.mapPosition.y
					end
					self.db.profile.scale = x
					self:UpdateScreen()
				end
			},
			show={
				type="group", order=5, name=L.show, desc=L.show_desc,
				args={
					location={
						type="group", order=1, name=L.location, desc=L.location,
						args={
							show={
								type="toggle", order=1, name=L.locationShow, desc=L.locationShow_desc,
								get=function() return(self.db.profile.locationBar.show) end,
								set=function(x) self.db.profile.locationBar.show=x self:UpdateScreen() end
							},
							text={
								type="toggle", order=2, name=L.locationText, desc=L.locationText_desc,
								get=function() return(self.db.profile.locationBar.text) end,
								set=function(x) self.db.profile.locationBar.text=x self:UpdateScreen() end
							}
						}
					},
					bgs={
						type="toggle", order=2, name=L.bgs, desc=L.bgs_desc,
						get=function() return(self.db.profile.show.bgs) end,
						set=function(x) self.db.profile.show.bgs=x self:UpdateScreen() end
					},
					map={
						type="toggle", order=3, name=L.map, desc=L.map_desc,
						get=function() return(self.db.profile.show.map) end,
						set=function(x) self.db.profile.show.map=x self:UpdateScreen() end
					},
					mail={
						type="toggle", order=4, name=L.mail, desc=L.mail_desc,
						get=function() return(self.db.profile.show.mail) end,
						set=function(x) self.db.profile.show.mail=x self:UpdateScreen() end
					},
					meet={
						type= "toggle", order=5, name=L.meet, desc=L.meet_desc,
						get=function() return(self.db.profile.show.meet) end,
						set=function(x) self.db.profile.show.meet=x self:UpdateScreen() end
					},
					time={
						type="toggle", order=6, name=L.time, desc=L.time_desc,
						get=function() return(self.db.profile.show.time) end,
						set=function(x) self.db.profile.show.time=x self:UpdateScreen() end
					},
					track={
						type="toggle", order=7, name=L.track, desc=L.track_desc,
						get=function() return(self.db.profile.show.track) end,
						set=function(x) self.db.profile.show.track=x self:UpdateScreen() end
					},
					zoom={
						type="toggle", order=8, name=L.zoom, desc=L.zoom_desc,
						get=function() return(self.db.profile.show.zoom) end,
						set=function(x) self.db.profile.show.zoom=x self:UpdateScreen() end
					}
				}
			},
			strata={
				type="range", order=6, name=L.strata, desc=L.strata_desc,
				min=1, max=8, step=1,
				get=function() return(self.db.profile.strata) end,
				set=function(x) self.db.profile.strata=x self:UpdateScreen() end
			},
			spacer2={
				type="header", order=7, name=" "
			},
			spacer3={
				type="header", order=8, name="   "..L.modules
			},
			spacer4={
				type="header", order=97, name=" "
			},
			lock={
				type="toggle", order=98, name=L.lock, desc=L.lock_desc,
				get=function() return(self.db.profile.lock) end,
				set=function(x) self.db.profile.lock=x self:UpdateScreen() end
			},
			reset={
				type="execute", order=99, name=L.reset, desc=L.reset_desc,
				func=function() StaticPopup_Show("smmRESET") end
			}
		}
	}
	self:RegisterDB("smmConfig")
	self:RegisterDefaults("profile", self.defaults)
	self:RegisterChatCommand({"/simpleminimap", "/smm"}, self.options)
	StaticPopupDialogs["smmRESET"] = {
		text = L.reset_popup, button1 = TEXT(ACCEPT), button2 = TEXT(CANCEL),
		timeout = 30, whileDead = 1, hideOnEscape = 1,
		OnAccept = function() self:ResetDB("profile") self:UpdateScreen() end
	}
	if(self.db.profile.mapPosition) then self:LockFrame(MinimapCluster) self:LockFrame(Minimap) end
end
--
function simpleMinimap:OnEnable()
	if(not self.frame) then
		self.frame = CreateFrame("Frame", nil, Minimap)
		self.frame:SetWidth(112)
		self.frame:SetHeight(112)
		self.frame:SetPoint("CENTER")
		self.frame:SetToplevel(true)
		self.frame:EnableMouseWheel(true)
		self.frame:SetScript("OnMouseWheel", function() if(arg1>0) then Minimap_ZoomIn() else Minimap_ZoomOut() end end)
	end
	MinimapCluster:SetMovable(true)
	Minimap:RegisterForDrag("LeftButton")
	Minimap:SetScript("OnDragStart", function() self:MapDrag(true) end)
	Minimap:SetScript("OnDragStop", function() self:MapDrag(false) end)
	MinimapZoneTextButton:RegisterForDrag("LeftButton")
	MinimapZoneTextButton:SetScript("OnDragStart", function() self:MapDrag(true) end)
	MinimapZoneTextButton:SetScript("OnDragStop", function() self:MapDrag(false) end)
	for _, f in pairs(self.buttons) do
		f:SetMovable(true)
		f:RegisterForDrag("LeftButton")
		f:SetScript("OnDragStart", function() self:ButtonDrag(true) end)
		f:SetScript("OnDragStop", function() self:ButtonDrag(false) end)
	end
	self:RegisterEvent("MINIMAP_UPDATE_ZOOM")
	for n in self:IterateModules() do self:ToggleModuleActive(self:GetModule(n),true) end
	self:UpdateScreen()
end
--
function simpleMinimap:OnDisable()
	for n in self:IterateModules() do self:ToggleModuleActive(self:GetModule(n),false) end
	self:UpdateScreen()
	MinimapCluster:SetMovable(false)
	Minimap:RegisterForDrag(nil)
	MinimapZoneTextButton:RegisterForDrag(nil)
	for _, f in pairs(self.buttons) do
		f:SetMovable(false)
		f:RegisterForDrag(nil)
	end
end
--
function simpleMinimap:Debug(text)
	if(ChatFrame2) then ChatFrame2:AddMessage(text, 0, 0.8, 1.0) end
end


--[[ events ]]--
--
function simpleMinimap:MINIMAP_UPDATE_ZOOM()
	local z = Minimap:GetZoom()
	if (GetCVar("minimapZoom") == GetCVar("minimapInsideZoom")) then
		if (z < 3) then
			Minimap:SetZoom(z + 1)
		else
			Minimap:SetZoom(z - 1)
		end
	else
		z = nil
	end
	if (tonumber(GetCVar("minimapInsideZoom")) == Minimap:GetZoom()) then
		self.inside = true
	else
		self.inside = false
	end
	if(MinimapCluster.smm_SetAlpha) then
		if(self.inside) then
			MinimapCluster:smm_SetAlpha(1)
		else
			MinimapCluster:smm_SetAlpha(self.db.profile.alpha)
		end
	end
	if(z) then Minimap:SetZoom(z) end
end

--[[ frame events ]]--
--
function simpleMinimap:ExpandMinimap(keystate)
	local function swapZoom(frame)
		local z = frame:GetZoom()
		if (z>0) then frame:SetZoom(0) else frame:SetZoom(1) end
		frame:SetZoom(z)
	end
	if (not self.expandedFrame) then
		self.expandedFrame = CreateFrame("Minimap", nil, UIParent)
		self.expandedFrame:SetHeight(UIParent:GetHeight() * 0.6)
		self.expandedFrame:SetWidth(self.expandedFrame:GetHeight())
		self.expandedFrame:SetPoint("CENTER")
		self.expandedFrame:SetFrameStrata("TOOLTIP")
		self.expandedFrame:EnableMouse(false)
		self.expandedFrame:EnableMouseWheel(false)
		self.expandedFrame:EnableKeyboard(false)
	end
	if (keystate == "down") then
		MinimapCluster:Hide()
		self.expandedFrame:Show()
		swapZoom(self.expandedFrame)
	else
		self.expandedFrame:Hide()
		MinimapCluster:Show()
		swapZoom(Minimap)
	end
end
--
function simpleMinimap:MapDrag(kick)
	if(kick and not self.db.profile.lock) then
		MinimapCluster.isMoving = true
		MinimapCluster:StartMoving()
	elseif(MinimapCluster.isMoving) then
		MinimapCluster.isMoving = false
		MinimapCluster:StopMovingOrSizing()
		self:LockFrame(MinimapCluster)
		self.db.profile.mapPosition = {}
		self.db.profile.mapPosition.x, self.db.profile.mapPosition.y = MinimapCluster:GetCenter()
	end
end
--
function simpleMinimap:ButtonDrag(kick)
	local function getPos()
		local cx, cy = GetCursorPosition(UIParent)
		local mx, my = Minimap:GetLeft(), Minimap:GetBottom()
		local z = Minimap:GetEffectiveScale()
		return(math.deg(math.atan2(cy / z - my - 70, mx - cx / z + 70)))
	end
	if(kick and not self.db.profile.lock) then
		this.isMoving = true
		this:SetScript("OnUpdate", function()
			local x, y = self:GetButtonPos(getPos())
      		this:ClearAllPoints()
			this:SetPoint("TOPLEFT", Minimap, "TOPLEFT", x, y)
		end)
		this:StartMoving()
	elseif(this.isMoving) then
		this.isMoving = false
		this:StopMovingOrSizing()
		this:SetScript("OnUpdate", nil)
		for n, f in pairs(self.buttons) do
			if(f == this) then self.db.profile.buttonPos[n] = getPos() break end
		end
	end
end

--[[ screen updates ]]--
--
function simpleMinimap:UpdateScreen()
-- set minimap scale
	if(self:IsActive() and self.db.profile.scale ~= self.defaults.scale) then
		if(not MinimapCluster.smm_SetScale) then
			MinimapCluster.smm_SetScale = MinimapCluster.SetScale
			MinimapCluster.SetScale = function() end
		end
		MinimapCluster:smm_SetScale(self.db.profile.scale)
	elseif(MinimapCluster.smm_SetScale) then
		MinimapCluster.SetScale = MinimapCluster.smm_SetScale
		MinimapCluster.smm_SetScale = nil
		MinimapCluster:SetScale(1)
	end
-- set minimap strata
	if(self:IsActive() and self.db.profile.strata ~= self.defaults.strata) then
		if(not MinimapCluster.smm_SetFrameStrata) then
			MinimapCluster.smm_SetFrameStrata = MinimapCluster.SetFrameStrata
			MinimapCluster.SetFrameStrata = function() end
		end
		MinimapCluster:smm_SetFrameStrata(self.stratas[self.db.profile.strata])
	elseif(MinimapCluster.smm_SetFrameStrata) then
		MinimapCluster.SetFrameStrata = MinimapCluster.smm_SetFrameStrata
		MinimapCluster.smm_SetFrameStrata = nil
		MinimapCluster:SetFrameStrata("BACKGROUND")
	end
-- set minimap alpha
	if(self:IsActive() and self.db.profile.alpha ~= self.defaults.alpha) then
		if(not MinimapCluster.smm_SetAlpha) then
			MinimapCluster.smm_SetAlpha = MinimapCluster.SetAlpha
			MinimapCluster.SetAlpha = function() end
		end
		if(self.inside) then
			MinimapCluster:smm_SetAlpha(1)
		else
			MinimapCluster:smm_SetAlpha(self.db.profile.alpha)
		end
	elseif(MinimapCluster.smm_SetAlpha) then
		MinimapCluster.SetAlpha = MinimapCluster.smm_SetAlpha
		MinimapCluster.smm_SetAlpha = nil
		MinimapCluster:SetAlpha(1)
	end
-- set minimap position
	if(self:IsActive() and self.db.profile.mapPosition) then
		self:LockFrame(MinimapCluster)
		self:LockFrame(Minimap)
		MinimapCluster:smm_ClearAllPoints()
		MinimapCluster:smm_SetPoint("CENTER", UIParent, "BOTTOMLEFT", self.db.profile.mapPosition.x, self.db.profile.mapPosition.y)
	elseif(MinimapCluster.smmTouched) then
		self:UnlockFrame(MinimapCluster)
		self:UnlockFrame(Minimap)
		MinimapCluster:ClearAllPoints()
		MinimapCluster:SetPoint("TOPRIGHT", UIParent)
		MinimapCluster:SetUserPlaced(false)
	end
-- set minimap buttons
	for n, x in pairs(self.db.profile.show) do
		if(n == "zoom") then
			if(self:IsActive() and not x) then
				MinimapZoomIn:Hide()
				MinimapZoomOut:Hide()
			else
				MinimapZoomIn:Show()
				MinimapZoomOut:Show()
			end
		elseif(self.buttons[n]) then
			local f = self.buttons[n]
			if(self:IsActive() and not x) then
				if(not f.smmTouched) then
					f.smmShow = f:IsShown()
					f.smm_Hide = f.Hide
					f.Hide = function() this.smmShow = nil end
					f.smm_Show = f.Show
					f.Show = function() this.smmShow = true end
					f.smmTouched = true
				end
				f:smm_Hide()
			elseif(f.smmTouched) then
				f.Hide = f.smm_Hide
				f.smm_Hide = nil
				f.Show = f.smm_Show
				f.smm_Show = nil
				f.smmTouched = nil
				if(f.smmShow) then f:Show() end
				f:SetUserPlaced(false)
			end
		end
	end
	for n, f in pairs(self.buttons) do
		local x, y
		if(self:IsActive()) then
			x, y = self:GetButtonPos(self.db.profile.buttonPos[n])
		else
			x, y = self:GetButtonPos(self.defaults.buttonPos[n])
		end
		f:ClearAllPoints()
		f:SetPoint("TOPLEFT", Minimap, "TOPLEFT", x, y)
	end
-- set minimap location bar
	if(self:IsActive() and not self.db.profile.locationBar.show) then
		MinimapToggleButton:Hide()
		MinimapBorderTop:Hide()
		if(self.db.profile.locationBar.text) then
			MinimapZoneTextButton:Show()
		else
			MinimapZoneTextButton:Hide()
		end
	else
		MinimapToggleButton:Show()
		MinimapBorderTop:Show()
		MinimapZoneTextButton:Show()
	end
-- let any modules update the screen also
	for n in self:IterateModules() do self:GetModule(n):UpdateScreen() end
end

--[[ internal functions ]]--
--
function simpleMinimap:LockFrame(frame)
	if(frame and not frame.smmTouched) then
		frame.smm_ClearAllPoints = frame.ClearAllPoints
		frame.smm_SetAllPoints = frame.SetAllPoints
		frame.smm_SetPoint = frame.SetPoint
		frame.ClearAllPoints = function() end
		frame.SetAllPoints = function() end
		frame.SetPoint = function() end
		frame.smmTouched = true
	end
end
--
function simpleMinimap:UnlockFrame(frame)
	if(frame and frame.smmTouched) then
		frame.ClearAllPoints = frame.smm_ClearAllPoints
		frame.SetAllPoints = frame.smm_SetAllPoints
		frame.SetPoint = frame.smm_SetPoint
		frame.smm_ClearAllPoints = nil
		frame.smm_SetAllPoints = nil
		frame.smm_SetPoint = nil
		frame.smmTouched = nil
	end
end
--
function simpleMinimap:GetButtonPos(vector)
	if(self:GetModule("skins")) then
		return self:GetModule("skins"):GetButtonPos(vector)
	else
		return 52 - 81 * cos(vector), 81 * sin(vector) - 54
	end
end

--[[ module stuff ]]--
--
function simpleMinimap.modulePrototype:UpdateScreen() end