﻿local mod = simpleMinimap:NewModule("movers", "AceEvent-2.0")
local L = AceLibrary("AceLocale-2.2"):new("simpleMinimap_movers")
L:RegisterTranslations("enUS", function() return({
	enabled = true,
		enabled_desc = "enable / disable mover frames",
	alpha = true,
		alpha_desc = "alpha of the mover frames",
	hide = true,
		hide_desc = "always hide the mover frames",
	movers = true,
		movers_desc = "mover frames",
	drag = "left-click to drag"
}) end)
L:RegisterTranslations("koKR", function() return({
	enabled = "켬",
		enabled_desc = "앵커 프레임 켜기 / 끄기",
	alpha = "투명도",
		alpha_desc = "앵커 프레임의 투명도",
	hide = "숨김",
		hide_desc = "앵커 프레임 항상 숨김",
	movers = "앵커",
		movers_desc = "앵커 프레임",
	drag = "좌클릭 : 드래그"
}) end)
L:RegisterTranslations("deDE", function() return({
	enabled = "aktiviert",
		enabled_desc = "aktiviert / deaktiviert die questfenster",
	alpha = "helligkeit",
		alpha_desc = "helligkeit der questfenster",
	hide = "verstecke",
		hide_desc = "verstecke immer die questfenster",
	movers = "questfenster",
		movers_desc = "optionen für die questfenster",
	drag = "Links-Klick zum ziehen"
}) end)
--
function mod:OnInitialize()
	self.db = simpleMinimap:AcquireDBNamespace("movers")
	self.movers = {
		QuestWatchFrame = { 280, 80 },
		DurabilityFrame = { 60, 65 },
		QuestTimerFrame = { 160, 72 },
		CaptureMover = { 178, 30 }
	}
	self.framesDefault = {
		QuestWatchFrame = { anchor=MinimapCluster, point="TOPRIGHT", rpoint="BOTTOMRIGHT", x=0, y=10 },
		DurabilityFrame = { anchor=MinimapCluster, point="TOPRIGHT", rpoint="BOTTOMRIGHT", x=40, y=15 },
		QuestTimerFrame = { anchor=MinimapCluster, point="TOPRIGHT", rpoint="BOTTOMRIGHT", x=10, y=0 },
		CaptureMover = { anchor=MinimapCluster, point="TOPRIGHT", rpoint="BOTTOMRIGHT", x=10, y=15 }
	}
	self.defaults = { enabled=false, alpha=0.4, hide=false, framePos={} }
	self.options = {
		type="group", order=10, name=L.movers, desc=L.movers_desc,
		args={
			title={
				type="header", order=1, name="simpleMinimap |cFFFFFFCC"..L.movers
			},
			spacer1={
				type="header", order=2
			},
			enabled={
				type="toggle", order=3, name=L.enabled, desc=L.enabled_desc,
				get=function() return(self.db.profile.enabled) end,
				set=function(x) self.db.profile.enabled=x simpleMinimap:ToggleModuleActive(self,x) end
			},
			spacer2={
				type="header", order=4, name="---"
			},
			alpha={
				type="range", order=10, name=L.alpha, desc=L.alpha_desc,
				min=0, max=1, step=0.05, isPercent=true,
				get=function() return(self.db.profile.alpha) end,
				set=function(x) self.db.profile.alpha=x self:UpdateScreen() end
			},
			hide={
				type="toggle", order=11, name=L.hide, desc=L.hide_desc,
				get=function() return(self.db.profile.hide) end,
				set=function(x) self.db.profile.hide=x self:UpdateScreen() end
			}
		}
	}
	simpleMinimap.options.args.movers = self.options
	simpleMinimap:RegisterDefaults("movers", "profile", self.defaults)
end
--
function mod:OnEnable()
	if(self.db.profile.enabled) then
		for n, s in pairs(self.movers) do
			if(not self[n]) then
				self[n] = CreateFrame("Frame", "smm"..n, UIParent)
				self[n]:SetWidth(s[1])
				self[n]:SetHeight(s[2])
				self[n]:ClearAllPoints()
				if(getglobal(n)) then
					self[n].smmMover = getglobal(n)
					self[n]:SetPoint("CENTER", self[n].smmMover) 
				else
					self[n].smmMover = self[n]
					self[n].smmMover:SetPoint(self.framesDefault[n].point, self.framesDefault[n].anchor, self.framesDefault[n].rpoint, self.framesDefault[n].x, self.framesDefault[n].y)
				end
				self[n].smmMover:SetMovable(true)
				self[n]:SetBackdrop({ bgFile="Interface\\Tooltips\\UI-Tooltip-Background" })
				self[n]:EnableMouse(true)
				self[n]:RegisterForDrag("LeftButton")
				self[n]:SetScript("OnDragStart", function() self:MoveFrame(n, true) end)
				self[n]:SetScript("OnDragStop", function() self:MoveFrame(n, false) end)
				self[n]:SetScript("OnEnter", function() GameTooltip:SetOwner(this, "ANCHOR_CURSOR") GameTooltip:SetText(L.drag.." |cFFFFFF99"..n)	end)
				self[n]:SetScript("OnLeave", function() GameTooltip:Hide() end)
			end
		end
		self:RegisterEvent("UPDATE_WORLD_STATES")
		self:UpdateScreen()
	else
		simpleMinimap:ToggleModuleActive(self, false)
	end
end
--
function mod:OnDisable()
	self:UpdateScreen()
end
--
function mod:MoveFrame(frame, startMove)
	if(startMove and not simpleMinimap.db.profile.lock) then
		this.smmMover.isMoving = true
		this.smmMover:StartMoving()
		GameTooltip:Hide()
	elseif(this.smmMover.isMoving) then
		this.smmMover.isMoving = nil
		this.smmMover:StopMovingOrSizing()
		self.db.profile.framePos[frame] = { this.smmMover:GetCenter() }
	end
end
--
function mod:UpdateScreen()
	for n, _ in pairs(self.movers) do
		if(self[n]) then
			if(self.db.profile.enabled and self.db.profile.framePos[n]) then
				simpleMinimap:LockFrame(self[n].smmMover)
				self[n].smmMover:smm_ClearAllPoints()
				self[n].smmMover:smm_SetPoint("CENTER", UIParent, "BOTTOMLEFT", self.db.profile.framePos[n][1], self.db.profile.framePos[n][2])
			elseif(self[n].smmMover.smmTouched) then
				simpleMinimap:UnlockFrame(self[n].smmMover)
				self[n].smmMover:ClearAllPoints()
				self[n].smmMover:SetPoint(self.framesDefault[n].point, self.framesDefault[n].anchor, self.framesDefault[n].rpoint, self.framesDefault[n].x, self.framesDefault[n].y)
				self[n].smmMover:SetUserPlaced(false)
			end
			if(self.db.profile.enabled and not self.db.profile.hide and not simpleMinimap.db.profile.lock) then
				self[n]:Show()
				self[n]:SetAlpha(self.db.profile.alpha)
			else
				self[n]:Hide()
			end
		end
	end
end
--
function mod:UPDATE_WORLD_STATES()
	for i = 1, NUM_EXTENDED_UI_FRAMES do
		local frame = getglobal("WorldStateCaptureBar"..i)
		if(frame) then
			if(self.db.profile.enabled) then
				if(not frame.smmTouched) then
					simpleMinimap:LockFrame(frame)
					frame:smm_ClearAllPoints()
					frame:smm_SetPoint("CENTER", self["CaptureMover"])
				end
			elseif(frame.smmTouched) then
				simpleMinimap:UnlockFrame(frame)
			end
		end
	end
end