﻿-- declard color codes for console messages
local RED     = "|cffff0000";
local GREEN   = "|cff00ff00";
local BLUE    = "|cff0000ff";
local MAGENTA = "|cffff00ff";
local YELLOW  = "|cffffff00";
local CYAN    = "|cff00ffff";
local WHITE   = "|cffffffff";
local ORANGE  = "|cffffba00";

TITAN_ZM_ID = "ZeppelinMaster";
TITAN_ZM_MENU_TEXT = "ZeppelinMaster";
TITAN_ZM_VERSION = "1.92";
TITAN_ZM_TOOLTIP = "ZeppelinMaster";
TITAN_ZM_FREQUENCY = 1;
TITAN_ZM_ARTWORK = "Interface\\AddOns\\ZepShipMaster\\Artwork\\";

activeTransitName = "";
activeSelect = -1;
activeTransit = -1;

-- local variables
local dropdownvalues = {};
local dropdownindexes = {};
--local firstTooltip = true;

function TitanPanelZeppelinMasterButton_OnLoad()

	-- make sure ZeppelinMaster loads first
	LoadAddOn("ZeppelinMaster");

	this.registry = {
		id = TITAN_ZM_ID,
		category = "Information",
		version = TITAN_ZM_VERSION,
		menuText = TITAN_ZM_MENU_TEXT, 
		buttonTextFunction = "TitanPanelZeppelinMasterButton_GetButtonText",
		tooltipTitle = TITAN_ZM_TOOLTIP,
		tooltipTextFunction = "TitanPanelZeppelinMasterButton_GetTooltipText",
		frequency = TITAN_ZM_FREQUENCY,
		icon = TITAN_ZM_ARTWORK.."ZeppelinMasterLogo",
		iconWidth = 16,
		savedVariables = {
			--OptZoneGUI = 1,
			OptFaction = 1,
			OptZone = false,
			OptAlias = 1,
			ShowLabelText = 1,
			ShowIcon = 1,
		}
	};

	this:RegisterEvent("ZONE_CHANGED_NEW_AREA");

	Pre_TitanToggleVar = TitanToggleVar;
	TitanToggleVar = ZM_TitanToggleVar;

end

-- hook toggle button
function ZM_TitanToggleVar(id, var)
	if (id == TITAN_ZM_ID) then
		TitanPanelRightClickMenu_Close();
	end

	return Pre_TitanToggleVar(id, var);
end

function TitanPanelZeppelinMasterButton_OnEvent()

	if (event == "ZONE_CHANGED_NEW_AREA") then
		TitanPanelRightClickMenu_Close();
	end

end

function TitanPanelZeppelinMasterButton_GetButtonText(id)

	if (zsm_tempTextCount > 0) then
		zsm_tempTextCount = zsm_tempTextCount -1;
		return zsm_tempText;
	end

	TitanPanelZeppelinMasterButton.registry.icon = TITAN_ZM_ARTWORK..zsm_Icon;
	return zsm_lowestNameTime;

end

function TitanPanelZeppelinMasterButton_GetTooltipText()

	--[[if (firstTooltip) then
		firstTooltip = false;
		TitanPanelRightClickMenu_PrepareZeppelinMasterMenu();
	end]]

	local OptAlias = TitanGetVar(TITAN_ZM_ID, "OptAlias");
	local toolTipText = "";

	if ((activeTransit ~= -1) and (known_times[activeTransit] ~= nil)) then
		local transit = activeTransit;

		toolTipText = toolTipText..activeTransitName.."\n\n";

		for index, data in pairs(zsm_data[transit..'_plats']) do
			local platname;

			if (OptAlias) then
				platname = data['alias'];
			else
				platname = data['name'];
			end

			toolTipText = toolTipText..WHITE..platname.."\n";

			local the_time = zsm_activeData[index];

			if (the_time <= 0) then
				the_time = -the_time;

				local color;

				if (the_time > 30) then
					color = YELLOW;
				else
					color = RED;
				end

				toolTipText = toolTipText.."Departure:\t"..color;
			else
				toolTipText = toolTipText.."Arrival:\t"..GREEN;
			end

			if (the_time > 59) then
				toolTipText = toolTipText..format("%0.0f", math.floor(the_time/60)).."m "
					..format("%0.0f", the_time-(math.floor(the_time/60)*60)).."s\n\n";
			else
				toolTipText = toolTipText..format("%0.0f", the_time).."s\n\n";
			end

		end

	elseif ((activeTransit ~= -1) and (known_times[activeTransit] == nil)) then
		local transit = activeTransit;

		toolTipText = toolTipText..activeTransitName.."\n\n";

		for index, data in pairs(zsm_data[transit..'_plats']) do
			local platname;

			if (OptAlias) then
				platname = data['alias'];
			else
				platname = data['name'];
			end

			toolTipText = toolTipText..WHITE..platname.."\nNot Available\n\n";
		end
	elseif (activeTransit == -1) then
		toolTipText = toolTipText.."No Transit Selected\n";
	end

	toolTipText = toolTipText..GREEN.."Hint: "..ZSM_STR_HINT;

	return toolTipText;
end

function TitanPanelRightClickMenu_PrepareZeppelinMasterMenu()

	local OptFaction = TitanGetVar(TITAN_ZM_ID, "OptFaction");
	local OptZone = TitanGetVar(TITAN_ZM_ID, "OptZone");
	local OptAlias = TitanGetVar(TITAN_ZM_ID, "OptAlias");

	dropdownvalues = {};
	dropdownindexes = {};

	TitanPanelRightClickMenu_AddTitle(TitanPlugins[TITAN_ZM_ID].menuText);

	TitanPanelRightClickMenu_AddToggleVar(ZSM_STR_OPT_FACTION, TITAN_ZM_ID, "OptFaction");
	TitanPanelRightClickMenu_AddToggleVar(ZSM_STR_OPT_ZONE, TITAN_ZM_ID, "OptZone");
	TitanPanelRightClickMenu_AddToggleVar(ZSM_STR_OPT_ALIAS, TITAN_ZM_ID, "OptAlias");

	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddCommand(YELLOW.."Select None", -1, "TitanPanelZeppelinMasterButton_SetTransport");

	local count = 1;
	for index, data in pairs(zsm_data['transports']) do

		local tmplabel = data['label'];
		dropdownindexes[tmplabel] = index;

		local textdesc;
		if (OptAlias) then
			textdesc = zsm_data['transports'][index]['namealias'];
		else
			textdesc = zsm_data['transports'][index]['name'];
		end

		local addtrans = false;
		if (OptFaction) then
			local faction = UnitFactionGroup("player");
			if ((zsm_data['transports'][index]['faction'] == faction) or (zsm_data['transports'][index]['faction'] == "Neutral")) then
				addtrans = true;
			end
		else
			addtrans = true;
		end

		if (OptZone and (addtrans)) then
			local zonestr = string.lower(zsm_data['transports'][index]['name']);
			local czonestr = string.lower(GetRealZoneText());
			if (not string.find(zonestr, czonestr)) then
				addtrans = false;
			end
		end

		if ((addtrans) and (zsm_data['transports'][index]['faction'] ~= -1)) then
			table.insert(dropdownvalues, zsm_data['transports'][index]['label']);

			label = zsm_data['transports'][index]['label'];

			if (known_times[label] ~= nil) then
				TitanPanelRightClickMenu_AddCommand(GREEN.. textdesc, count, "TitanPanelZeppelinMasterButton_SetTransport");
			else
				TitanPanelRightClickMenu_AddCommand(textdesc, count, "TitanPanelZeppelinMasterButton_SetTransport");
			end

			count = count + 1;
		end
	end

	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, TITAN_ZM_ID, TITAN_PANEL_MENU_FUNC_HIDE);
end

function TitanPanelZeppelinMasterButton_OnClick( event )

	if (event == "LeftButton") then

		if ( #(dropdownvalues) == 0 ) then
			activeSelect = -1;
			activeTransit = -1;
			return;
		elseif (activeSelect == -1) then
			activeSelect = 1;
		else
			activeSelect = activeSelect + 1;
		end

		if (activeSelect > #(dropdownvalues)) then
			activeSelect = 1;
			activeTransit = dropdownvalues[activeSelect];
		else
			activeTransit = dropdownvalues[activeSelect];
		end

		if ( TitanGetVar(TITAN_ZM_ID, "OptAlias") ) then
			activeTransitName = zsm_data['transports'][dropdownindexes[activeTransit] ]['namealias'];
		else
			activeTransitName = zsm_data['transports'][dropdownindexes[activeTransit] ]['name'];
		end

		local color;

		if (known_times[activeTransit] ~= nil) then
			color = GREEN;
		else
			color = RED;
		end

		-- set tempory button text so you know which one is currently selected
		zsm_tempText = color..activeTransitName;
		zsm_tempTextCount = 2;
		TitanPanelButton_SetButtonText(TITAN_ZM_ID);

		if (known_times[activeTransit] == nil) then
			ZSM_TransportRequestData(activeTransit);
		end

		ZSM_TransportSelect_SetNone();
	end
end

function TitanPanelZeppelinMasterButton_SetTransport()

	if (this.value == -1) then
		activeSelect = -1;
		activeTransit = -1;
		activeTransitName = ZSM_STR_NONESELECT;
	else
		activeSelect = this.value;
		activeTransit = dropdownvalues[this.value];

		if ( TitanGetVar(TITAN_ZM_ID, "OptAlias") ) then
			activeTransitName = zsm_data['transports'][dropdownindexes[activeTransit] ]['namealias'];
		else
			activeTransitName = zsm_data['transports'][dropdownindexes[activeTransit] ]['name'];
		end

		if (known_times[activeTransit] == nil) then
			ZSM_TransportRequestData(activeTransit);
		end

		zsm_tempText = activeTransitName;
		zsm_tempTextCount = 2;
	end

	ZSM_TransportSelect_SetNone();

end
