-- Global constants
CASTING_BAR_MAJOR_VERSION = "2";
CASTING_BAR_MINOR_VERSION = "00";
CASTING_BAR_REVISION = "05";
CASTING_BAR_ALPHA_STEP = 0.05;
CASTING_BAR_FLASH_STEP = 0.2;
CASTING_BAR_HOLD_TIME = 1;
CASTING_BAR_WIDTH = 264;
CASTING_BAR_HEIGHT = 30;
CASTING_BAR_SLIDER_WIDTH_MIN = 100;
CASTING_BAR_SLIDER_WIDTH_MAX = 2000;
CASTING_BAR_SLIDER_HEIGHT_MIN = 20;
CASTING_BAR_SLIDER_HEIGHT_MAX = 60;

-- Global variables
eCastingBar_Saved = {};
eCastingBar_Resolution = nil;
eCastingBar_ResolutionWidth = 0;
eCastingBar_ResolutionHeight = 0;
eCastingBar_MENU_SAVEDSETTINGS = nil;
eCastingBar_SETTINGS_INDEX = "";

-- Local Constants
local CASTING_BAR_COLOR_TEXTURE = "Interface\\AddOns\\eCastingBar\\Textures\\RoundedLightSample.tga";
local CASTING_BAR_BACKGROUND_FILE = "Interface\\Tooltips\\UI-Tooltip-Background";
local CASTING_BAR_EDGE_FILE = "Interface\\Tooltips\\UI-Tooltip-Border";

-- Casting Bar Frame Suffixes
local frameSuffixes = { "", "TargetBar" }
local eCB_FMT_Orig_BeginFlight;
local eCB_FMT_Orig_EndFlight;

local CASTING_BAR_DEFAULTS = {
  ["Locked"] = 0,
  ["Enabled"] = 1,
  ["Texture"] = "Perl",
  ["ShowTime"] = 1,
  ["HideBorder"] = 0,
  ["ShowDelay"] = 1,
  ["Width"] = CASTING_BAR_WIDTH,
  ["Height"] = CASTING_BAR_HEIGHT,
  ["Left"] = 380,
  ["Bottom"] = 180,
  ["ShowSpellName"] = 1,
  ["ShowSpellRank"] = 1,
  ["FontSize"] = 12,
  ["IconPosition"] = "HIDDEN",
  ["MirrorLocked"] = 0,
  ["MirrorEnabled"] = 1,
  ["MirrorTexture"] = "Perl",
  ["MirrorShowTime"] = 1,
  ["MirrorHideBorder"] = 0,
  ["MirrorUseFlightTimer"] = 1,
  ["MirrorWidth"] = CASTING_BAR_WIDTH,
  ["MirrorHeight"] = CASTING_BAR_HEIGHT,
  ["MirrorLeft"] = 380,
  ["MirrorBottom"] = 600,
  ["MirrorShowTimerLabel"] = 1,
  ["MirrorFontSize"] = 12,
  ["TargetBarLocked"] = 0,
  ["TargetBarEnabled"] = 1,
  ["TargetBarTexture"] = "Perl",
  ["TargetBarShowTime"] = 1,
  ["TargetBarHideBorder"] = 0,
  ["TargetBarShowDelay"] = 1,
  ["TargetBarWidth"] = CASTING_BAR_WIDTH,
  ["TargetBarHeight"] = CASTING_BAR_HEIGHT,
  ["TargetBarLeft"] = 380,
  ["TargetBarBottom"] = 640,
  ["TargetBarShowSpellName"] = 1,
  ["TargetBarShowSpellRank"] = 1,
  ["TargetBarFontSize"] = 12,
  ["TargetBarIconPosition"] = "HIDDEN"
}

local CASTING_BAR_DEFAULT_COLORS = {
  ["SpellColor"] = {1.0, 0.7, 0.0, 1.0},
  ["ChannelColor"] = {0.3, 0.3, 1.0, 1},
  ["SuccessColor"] = {0.0, 1.0, 0.0, 1},
  ["FailedColor"] = {1.0, 0.0, 0.0, 1},
  ["FlashBorderColor"] = {1.0, 0.88, 0.25, 1},
  ["FeignDeathColor"] = {1.0, 0.7, 0.0, 1},
  ["ExhaustionColor"] = {1.0, 0.9, 0.0, 1},
  ["BreathColor"] = {0.0, 0.5, 1.0, 1},
  ["FlightColor"] = {.26, 0.93, 1.0, 1.0},
  ["TimeColor"] = {1.0, 1.0, 1.0, 1},
  ["DelayColor"] = {1.0, 0.0, 0.0, 1},
  ["MirrorTimeColor"] = {1.0, 1.0, 1.0, 1},
  ["MirrorFlashBorderColor"] = {1.0, 0.88, 0.25, 1},
  ["TargetBarSpellColor"] = {1.0, 0.7, 0.0, 1.0},
  ["TargetBarChannelColor"] = {0.3, 0.3, 1.0, 1},
  ["TargetBarSuccessColor"] = {0.0, 1.0, 0.0, 1},
  ["TargetBarFailedColor"] = {1.0, 0.0, 0.0, 1},
  ["TargetBarFlashBorderColor"] = {1.0, 0.88, 0.25, 1},
  ["TargetBarTimeColor"] = {1.0, 1.0, 1.0, 1},
  ["TargetBarDelayColor"] = {1.0, 0.0, 0.0, 1}
}

-- Local variables

local eCastingBar__FlashBorders = {
	"TOPLEFT",
	"TOP",
	"TOPRIGHT",
	"LEFT",
	"RIGHT",
	"BOTTOMLEFT",
	"BOTTOM",
	"BOTTOMRIGHT"	
}

local eCastingBar__Events = {
	"UNIT_SPELLCAST_START",
	"UNIT_SPELLCAST_STOP",
	"UNIT_SPELLCAST_INTERRUPTED",
	"UNIT_SPELLCAST_FAILED",
	"UNIT_SPELLCAST_DELAYED",
	"UNIT_SPELLCAST_CHANNEL_START",
	"UNIT_SPELLCAST_CHANNEL_UPDATE",
	"UNIT_SPELLCAST_CHANNEL_STOP",
	"MIRROR_TIMER_START"
}

local eCastingBar__CastTimeEvents = {
	"UNIT_SPELLCAST_START",
	"UNIT_SPELLCAST_STOP",
	"UNIT_SPELLCAST_INTERRUPTED",
	"UNIT_SPELLCAST_FAILED"
}

function ECB_addChat(msg)
	DEFAULT_CHAT_FRAME:AddMessage(CASTINGBAR_HEADER.." "..msg)
end

function eCastingBar_Toggle()
	if eCB_OptionFrame:IsVisible() then
		HideUIPanel(eCB_OptionFrame);
	else
		ShowUIPanel(eCB_OptionFrame);
	end
end

function eCB_FMT_BeginFlight(duration, destination)
	if eCastingBar_Saved.MirrorUseFlightTimer == 0 then
  	eCB_FMT_Orig_BeginFlight(duration, destination)
  else
    if not FlightMap.Opts.useTimer then return; end
    local endTime = 0;
    if (duration) then 
    	endTime = (duration * 1000);
    end
    eCastingBarMirror_Show("FLIGHT", endTime, endTime, -1, 0, destination)
	end
end

function eCB_FMT_EndFlight()
	this.started = false;
	for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
		local frame = getglobal("eCastingBarMirror"..index);
		if ( frame.timer == "FLIGHT") then
			getglobal(frame:GetName().."Flash"):SetAlpha( 0.0 )
			getglobal(frame:GetName().."Flash"):Show()
			frame.flash = 1
			frame.fadeOut = 1
			frame.mode = "flash"
		end
	end
end

function eCB_FMTRF_OnShow()
-- Blank function, designed to fix FlightMap
end

function eCastingBar_OnLoad()
  -- load the new castingbar:
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
	tinsert(UISpecialFrames, "eCB_OptionFrame");
	CASTINGBAR_ICON_POSITION = {
		{ text = CASTINGBAR_LEFT_TEXT, value = "LEFT"},
		{ text = CASTINGBAR_RIGHT_TEXT, value = "RIGHT"},
		{ text = CASTINGBAR_HIDDEN_TEXT, value = "HIDDEN"}
	};
end

function eCastingBarMirror_OnLoad()
	this:RegisterEvent("MIRROR_TIMER_PAUSE");
	this:RegisterEvent("MIRROR_TIMER_STOP");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this.timer = nil;
end

function eCastingBarTarget_OnLoad()
	this:RegisterEvent("PLAYER_TARGET_CHANGED");
end


--[[ Registers "frame" (passed as a string) to spellcast events. ]]--

function eCastingBar_Register( frmFrame, strEvent )
	getglobal( frmFrame ):RegisterEvent( strEvent )
end

--[[ Unregisters "frame" (passed as a string) from spellcast events. ]]--

function eCastingBar_Unregister( frmFrame, strEvent )
	getglobal( frmFrame ):UnregisterEvent( strEvent )
end

--[[ Handles all the mods' events. ]]--

function eCastingBar_OnEvent( frame )
	if event == "PLAYER_ENTERING_WORLD" then
    -- inform the user we are starting loading .
		ECB_addChat( CASTINGBAR_LOADED )
		eCastingBar:UnregisterEvent( event )
		eCB_FMT_Orig_BeginFlight = FlightMapTimes_BeginFlight;
		eCB_FMT_Orig_EndFlight = FlightMapTimes_EndFlight;
		FlightMapTimes_BeginFlight = eCB_FMT_BeginFlight;
		FlightMapTimes_EndFlight = eCB_FMT_EndFlight;
		FlightMapTimesRecorderFrame_OnShow = eCB_FMTRF_OnShow;

    -- hide all bars
		for index, option in pairs(frameSuffixes) do
			getglobal("eCastingBar"..option):Hide();
		end
    -- the save empty or broken?
		if not eCastingBar_Saved  or eCastingBar_Saved == 1 then
			eCastingBar_Saved = {}
      -- yes, inform the user we are loading defaults
			ECB_addChat( "	First Load or broken save, Loading defaults." )
      -- set it to defaults
			eCastingBar_ResetSettings()
		end
		eCastingBar_CheckSettings()
		eCastingBar_LoadVariables()
	end
	if arg1 == "target" and eCastingBar_Saved.TargetBarEnabled == 0 then
		return
	end
	if( event == "UNIT_SPELLCAST_START" ) and (arg1 == "player" or arg1 == "target") then
		if arg1 == "target" then frame = "TargetBar" end
		eCastingBar_SpellcastStart( frame, arg1 )
		
	elseif( event == "UNIT_SPELLCAST_STOP" ) and (arg1 == "player" or arg1 == "target")  then
		if arg1 == "target" then frame = "TargetBar" end
		eCastingBar_SpellcastStop( frame )
    
	elseif( event == "UNIT_SPELLCAST_CHANNEL_STOP" ) and (arg1 == "player" or arg1 == "target")  then
		if arg1 == "target" then frame = "TargetBar" end
		eCastingBar_SpellcastFailed( frame )
		
	elseif( event == "UNIT_SPELLCAST_FAILED" or event == "UNIT_SPELLCAST_INTERRUPTED" )  and (arg1 == "player" or arg1 == "target") then
		if arg1 == "target" then frame = "TargetBar" end
		eCastingBar_SpellcastFailed( frame )
    
	elseif( event == "UNIT_SPELLCAST_DELAYED" )  and (arg1 == "player" or arg1 == "target")   then
		if arg1 == "target" then frame = "TargetBar" end
		local spellName, spellRank, displayName, texture, startTime, endTime, isTradeSkill = UnitCastingInfo(arg1)
		local delayTime = (endTime - (getglobal("eCastingBar"..frame).maxValue * 1000))
		eCastingBar_SpellcastDelayed( frame, delayTime )
    
	elseif( event == "UNIT_SPELLCAST_CHANNEL_START" ) and (arg1 == "player" or arg1 == "target")  then
		if arg1 == "target" then frame = "TargetBar" end
		eCastingBar_SpellcastChannelStart( frame, arg1)
		
	elseif( event == "UNIT_SPELLCAST_CHANNEL_UPDATE" )  and (arg1 == "player" or arg1 == "target")  then
		if arg1 == "target" then frame = "TargetBar" end
		local spellName, spellRank, displayName, texture, startTime, endTime = UnitChannelInfo(arg1)
		local remainingTime = (endTime - (GetTime() * 1000))
		eCastingBar_SpellcastChannelUpdate( frame, remainingTime )  
	end
  
  -- check for mirrors
	if( event == "MIRROR_TIMER_START" ) then
		if (eCastingBar_Saved.MirrorEnabled == 1) then 
      -- if we are not using Blizzards timers we should hide it.
			if (eCastingBar_Saved.MirrorEnabled == 1) then
				hideBlizzardMirrorFrame(arg1)
			else
        -- else make sure its shown
				showBlizzardMirrorFrame(arg1)
			end
		eCastingBarMirror_Show(arg1, arg2, arg3, arg4, arg5, arg6)
		end
	end
end

function eCastingBarTarget_OnEvent()
	if( event == "PLAYER_TARGET_CHANGED") then
		eCastingBarTarget_Update()
	end
end

function eCastingBarTarget_Update()
	if ( not UnitExists("target") or eCastingBar_Saved.TargetBarEnabled == 0 ) then
		this:Hide()
	else
		if UnitCastingInfo("target") then
			eCastingBar_SpellcastStart( "TargetBar", "target" )
		elseif UnitChannelInfo("target") then
			eCastingBar_SpellcastChannelStart( "TargetBar", "target" )
		else
			this:Hide()
		end
	end
end

--[[ Hide the Blizzard frame ]]--

function hideBlizzardMirrorFrame(timer)
	for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
		local frame = getglobal("MirrorTimer"..index)
		if (frame.timer == timer) then
			frame:Hide()
		end
	end
end

function showBlizzardMirrorFrame(timer)
	for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
		local frame = getglobal("MirrorTimer"..index)
		if (frame.timer == timer) then
			frame:Show()
		end
	end
end

function hideAllBlizzardMirrorFrames()
	for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
		local frame = getglobal("MirrorTimer"..index)
		local frame2 = getglobal("eCastingBarMirror"..index)
		if (frame2.timer ~= nil) then
			frame:Hide()
			frame2:Show()
		end
	end
end

function showAllBlizzardMirrorFrames()
	for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
		local frame = getglobal("MirrorTimer"..index)
		local frame2 = getglobal("eCastingBarMirror"..index)
		if (frame.timer ~= nil) then
			frame:Show()
			frame2:Hide()
		end
	end
end

function eCastingBar_ResetSettings()
	ECB_addChat("Resetting Default Settings")
	eCastingBar_Saved = {}
  -- reset General Options
	for option in pairs(CASTING_BAR_DEFAULTS) do
		eCastingBar_Saved[option] = CASTING_BAR_DEFAULTS[option]
	end
  -- reset Colors
	for color in pairs(CASTING_BAR_DEFAULT_COLORS) do
		eCastingBar_Saved[color] = CASTING_BAR_DEFAULT_COLORS[color]
	end
	setup()
end

function eCastingBar_CheckSettings()
  -- reset General Options
	for option in pairs(CASTING_BAR_DEFAULTS) do
		if (eCastingBar_Saved[option] == nil) then
			eCastingBar_Saved[option] = CASTING_BAR_DEFAULTS[option]
		end
	end
  -- check for nil colors
	for color in pairs(CASTING_BAR_DEFAULT_COLORS) do
		if (eCastingBar_Saved[color] == nil) then
			eCastingBar_Saved[color] = CASTING_BAR_DEFAULT_COLORS[color]
		end
	end
end

function setup()
	eCastingBar_checkEnabled()
	eCastingBar_checkLocked()
	eCastingBar_checkBorders()
	eCastingBar_checkTimeColors()
	eCastingBar_setDelayColor()
	eCastingBar_SetSize()
	eCastingBar_checkFlashBorderColors()
	eCastingBar_checkTextures()
	eCastingBar_setIcons()
end

--[[ Iniitialization ]]--

function eCastingBar_LoadVariables()	
    setup()
    eCastingBar_SetSavedSettingsMenu()
    
    -- make the casting bar link to the movable button
		eCastingBar:SetPoint("TOPLEFT", "eCastingBar_Outline", "TOPLEFT", 0, 0 )
		eCastingBarTargetBar:SetPoint("TOPLEFT", "eCastingBarTargetBar_Outline", "TOPLEFT", 0, 0 )
    
    -- make the mirror casting bar link to the movable button
		eCastingBarMirror1:SetPoint("TOPLEFT", "eCastingBarMirror_Outline", "TOPLEFT", 0, 0 )
		
    -- reset variables
    for index, option in pairs(frameSuffixes) do
      getglobal("eCastingBar"..option).casting = nil
      getglobal("eCastingBar"..option).holdTime = 0
    end
    
		SlashCmdList["ECASTINGBAR"] = eCastingBar_SlashHandler
		SLASH_ECASTINGBAR1 = "/eCastingBar"
		SLASH_ECASTINGBAR2 = "/eCB"
		SLASH_ECASTINGBAR3 = "/시전바"    
    -- resolution
    SetResolution(GetScreenResolutions())
    --[[
    local i,j = string.find(eCastingBar_Resolution, "x")
    eCastingBar_ResolutionWidth = tonumber(string.sub(eCastingBar_Resolution, 0, i - 1))
    eCastingBar_ResolutionHeight = tonumber(string.sub(eCastingBar_Resolution, i + 1, string.len(eCastingBar_Resolution)))
    ]]
    -- override these for now until I can figure out why blizzard is jacked up
    eCastingBar_ResolutionWidth = 2000
    eCastingBar_ResolutionHeight = 2000
    
    setupConfigFrame()
    setupDefaultConfigFrame()
    setupColorsConfigFrame()
end

function setupConfigFrame()
  -- set all text values
  eCB_Option_DefaultsButton:SetText(CASTINGBAR_DEFAULTS_BUTTON)
  eCB_Option_CloseButton:SetText(CASTINGBAR_CLOSE_BUTTON)
  eCastingBarSaveSettingsButton:SetText(CASTINGBAR_SAVE_BUTTON)
  eCastingBarLoadSettingsButton:SetText(CASTINGBAR_LOAD_BUTTON)
  eCastingBarDeleteSettingsButton:SetText(CASTINGBAR_DELETE_BUTTON)
end

function setupDefaultConfigFrame()
  -- set all text values
  for option in pairs(CASTING_BAR_BUTTONS) do
    local btnText = getglobal("eCastingBar"..option.."Text")
    btnText:SetText(CASTING_BAR_BUTTONS[option])
  end
  
  eCastingBarStatusBarText:SetJustifyH("Center")
  eCastingBarSelectTexture_Label:SetText(CASTINGBAR_CASTINGBAR_TEXTURE_TEXT)
  eCastingBarSelectTexture_Setting:SetText(eCastingBar_Saved.Texture)

  eCastingBarIconPosition_Label:SetText(CASTINGBAR_ICON_POSITION_TEXT)
  eCastingBarIconPosition_Setting:SetText(getglobal("CASTINGBAR_"..eCastingBar_Saved.IconPosition.."_TEXT"))
  
	for index, option in pairs(frameSuffixes) do
		local	Red, Green, Blue, Alpha = unpack(eCastingBar_Saved[option.."SpellColor"])
		getglobal("eCastingBar"..option.."ExampleStatusBar"):SetStatusBarColor( Red, Green, Blue, Alpha )
	end
  local Red, Green, Blue, Alpha = unpack(eCastingBar_Saved.BreathColor)
  eCastingBarMirrorExampleStatusBar:SetStatusBarColor( Red, Green, Blue, Alpha )

  
  eCastingBarTargetBarStatusBarText:SetJustifyH("Center")
  eCastingBarTargetBarSelectTexture_Label:SetText(CASTINGBAR_TARGETBAR_TEXTURE_TEXT)
  eCastingBarTargetBarSelectTexture_Setting:SetText(eCastingBar_Saved.TargetBarTexture)

  eCastingBarTargetBarIconPosition_Label:SetText(CASTINGBAR_ICON_POSITION_TEXT)
  eCastingBarTargetBarIconPosition_Setting:SetText(getglobal("CASTINGBAR_"..eCastingBar_Saved.TargetBarIconPosition.."_TEXT"))
  
  eCastingBarMirrorSelectTexture_Label:SetText(CASTINGBAR_MIRRORBAR_TEXTURE_TEXT)
  eCastingBarMirrorSelectTexture_Setting:SetText(eCastingBar_Saved.MirrorTexture)
  
  for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
    getglobal("eCastingBarMirror"..index.."StatusBarText"):SetJustifyH("Center")
  end

	-- Disable the Load and Delete Buttons on Startup
	eCastingBarLoadSettingsButton:Disable(); 
	eCastingBarDeleteSettingsButton:Disable();

  -- set all checks
  for option in pairs(CASTING_BAR_BUTTONS) do
    local btn = getglobal("eCastingBar"..option)
    btn:SetChecked(eCastingBar_Saved[option])
  end
  
  local slider, sliderText, low, high, width, height
  local optionTabs = { "", "Mirror", "TargetBar" }
  
  for index, option in pairs(optionTabs) do
    -- setup the width slider
    slider = getglobal("eCastingBar"..option.."WidthSlider")
    sliderText = getglobal("eCastingBar"..option.."WidthSliderText")
    low = getglobal("eCastingBar"..option.."WidthSliderLow")
    high = getglobal("eCastingBar"..option.."WidthSliderHigh")
    
    slider:SetMinMaxValues(CASTING_BAR_SLIDER_WIDTH_MIN, eCastingBar_ResolutionWidth)
    slider:SetValueStep(1)
    slider:SetValue(eCastingBar_Saved[option.."Width"])
    sliderText:SetText(CASTINGBAR_SLIDER_WIDTH_TEXT)
    low:SetText(CASTING_BAR_SLIDER_WIDTH_MIN)
    high:SetText(eCastingBar_ResolutionWidth)
    
    -- setup the height slider
    slider = getglobal("eCastingBar"..option.."HeightSlider")
    sliderText = getglobal("eCastingBar"..option.."HeightSliderText")
    low = getglobal("eCastingBar"..option.."HeightSliderLow")
    high = getglobal("eCastingBar"..option.."HeightSliderHigh")
    
    slider:SetMinMaxValues(CASTING_BAR_SLIDER_HEIGHT_MIN, CASTING_BAR_SLIDER_HEIGHT_MAX)
    slider:SetValueStep(1)
    slider:SetValue(eCastingBar_Saved[option.."Height"])
    sliderText:SetText(CASTINGBAR_SLIDER_HEIGHT_TEXT)
    low:SetText(CASTING_BAR_SLIDER_HEIGHT_MIN)
    high:SetText(CASTING_BAR_SLIDER_HEIGHT_MAX)
    
    -- setup the x slider
    slider = getglobal("eCastingBar"..option.."LeftSlider")
    sliderText = getglobal("eCastingBar"..option.."LeftSliderText")
    low = getglobal("eCastingBar"..option.."LeftSliderLow")
    high = getglobal("eCastingBar"..option.."LeftSliderHigh")
    
    if (option == "Mirror") then
      width = tonumber(string.format("%.0f", getglobal("eCastingBarMirror1"):GetWidth()))
      height = tonumber(string.format("%.0f", getglobal("eCastingBarMirror1"):GetHeight()))
    else
      width = tonumber(string.format("%.0f", getglobal("eCastingBar"..option):GetWidth()))
      height = tonumber(string.format("%.0f", getglobal("eCastingBar"..option):GetHeight()))
    end
    
    slider:SetMinMaxValues(-1000, eCastingBar_ResolutionWidth)
    slider:SetValueStep(1)
    slider:SetValue(eCastingBar_Saved[option.."Left"])
    sliderText:SetText(CASTINGBAR_SLIDER_LEFT_TEXT)
    low:SetText(-1000)
    high:SetText(eCastingBar_ResolutionWidth)
    
    -- setup the y slider
    slider = getglobal("eCastingBar"..option.."BottomSlider")
    sliderText = getglobal("eCastingBar"..option.."BottomSliderText")
    low = getglobal("eCastingBar"..option.."BottomSliderLow")
    high = getglobal("eCastingBar"..option.."BottomSliderHigh")
    
    slider:SetMinMaxValues(-1000, eCastingBar_ResolutionHeight)
    slider:SetValueStep(1)
    slider:SetValue(eCastingBar_Saved[option.."Bottom"])
    sliderText:SetText(CASTINGBAR_SLIDER_BOTTOM_TEXT)
    low:SetText(-1000)
    high:SetText(eCastingBar_ResolutionHeight)
    
    -- setup the font slider
    slider = getglobal("eCastingBar"..option.."FontSlider")
    sliderText = getglobal("eCastingBar"..option.."FontSliderText")
    low = getglobal("eCastingBar"..option.."FontSliderLow")
    high = getglobal("eCastingBar"..option.."FontSliderHigh")
    
    slider:SetMinMaxValues(12, 40)
    slider:SetValueStep(1)
    slider:SetValue(eCastingBar_Saved[option.."FontSize"])
    sliderText:SetText(CASTINGBAR_SLIDER_FONT_TEXT)
    low:SetText(12)
    high:SetText(40)
    
  end
end

function setupColorsConfigFrame()
  -- set the textures
  for color in pairs(CASTINGBAR_COLOR_LABEL) do
    local btnColor = getglobal("btn"..color.."Texture")
    
    -- set the texture
    btnColor:SetTexture(CASTING_BAR_COLOR_TEXTURE)
    
    -- set the vertex color
    btnColor:SetVertexColor(unpack(eCastingBar_Saved[color]))
    
    -- set the label
    getglobal("lbl"..color.."Text"):SetText(CASTINGBAR_COLOR_LABEL[color])
  end
end

function SetResolution(...)
  local iRes = GetCurrentResolution()
  for i=1, select("#",...), 1 do
    if (iRes == i) then
    	eCastingBar_Resolution = select(i,...)
    end
  end
end

--[[ Handles all the slash commands if cosmos isn't present. ]]--

function eCastingBar_SlashHandler( strMessage )
  local command, param
  -- make it it all lower case to be sure
	strMessage = string.lower( strMessage )
  
  if(index) then
		command = string.sub(strMessage, 1, (index - 1))
		param = string.sub(strMessage, (index + 1)  )
	else
		command = strMessage
	end
  
	if( command == CASTINGBAR_CHAT_C1 ) then 
    ShowUIPanel(eCB_OptionFrame);
  elseif ( command == CASTINGBAR_CHAT_C2) then
    eCastingBar_ChatHelp()
	else
    ShowUIPanel(eCB_OptionFrame);
	end
	
  setupDefaultConfigFrame()
  setupColorsConfigFrame()
end

--[[ Handles chat help messages. ]]--

function eCastingBar_ChatHelp()
	local intIndex = 0
	local strMessage = ""
	
  -- prints each line in CASTINGBAR_HELP = { }
	for intIndex, strMessage in pairs(CASTINGBAR_HELP) do
		ECB_addChat( strMessage )
	end
end

--[[ Handles the UNIT_SPELLCAST_START event. ]]--

function eCastingBar_SpellcastStart( fraFrame, unit )
	if (fraFrame == "TargetBar" and UnitIsUnit("target", "player") ) then
		return
	end
	local spellName, spellRank, displayName, texture, startTime, endTime = UnitCastingInfo(unit)
	local bar = getglobal("eCastingBar"..fraFrame)
	local barIcon = getglobal("eCastingBar"..fraFrame.."StatusBarIcon");
	local barStatusBar = getglobal("eCastingBar"..fraFrame.."StatusBar");
	local barSpark = getglobal("eCastingBar"..fraFrame.."StatusBarSpark");
	local barText = getglobal("eCastingBar"..fraFrame.."StatusBarText")
	if ( barIcon and eCastingBar_Saved[fraFrame.."IconPosition"] ~= "HIDDEN") then
		barIcon:SetTexture(texture);
		barIcon:Show();
	end

  -- set the bar color
	local Red, Green, Blue, Alpha
	Red, Green, Blue, Alpha = unpack(eCastingBar_Saved.SpellColor)
	barStatusBar:SetStatusBarColor( Red, Green, Blue, Alpha )
	
  -- show the spark
	barSpark:Show()
	
  -- set the start and max time
	bar.startTime = (startTime/1000)
	bar.initStartTime = (startTime/1000)
	bar.maxValue = (endTime/1000)
	
  -- set the bar minimum and maximum accordingly (basicly it will grow as time passes)
	barStatusBar:SetMinMaxValues( bar.startTime, bar.maxValue )
	
  -- set the bar to current size
	barStatusBar:SetValue( GetTime() )
  
  -- set the text to the spell name
  -- [1] Modified by Bitz --
  if ( eCastingBar_Saved[fraFrame.."ShowSpellName"] == 1 and string.len(spellRank) > 0 and eCastingBar_Saved[fraFrame.."ShowSpellRank"] == 1) then
	  barText:SetText( spellName.." ("..spellRank..")" )
  elseif ( eCastingBar_Saved[fraFrame.."ShowSpellName"] == 1 and ( string.len(spellRank) == 0 or eCastingBar_Saved[fraFrame.."ShowSpellRank"] == 0 ) ) then
	  barText:SetText( spellName )
	elseif ( eCastingBar_Saved[fraFrame.."ShowSpellName"] == 0 and eCastingBar_Saved[fraFrame.."ShowSpellRank"] == 1) then
	  barText:SetText( spellRank )
  else
    barText:SetText( "" )
  end
  ------- End of [1] -------

  -- set the bar to fully opaque
	bar:SetAlpha( 1.0 )
	
  -- start the casting state, and make sure everything else is reset
	bar.holdTime = 0
	bar.casting = 1
	bar.fadeOut = nil
  bar.delay = 0
	bar:Show()
	bar.mode = "casting"
end

--[[ Handles the UNIT_SPELLCAST_STOP event. ]]--

function eCastingBar_SpellcastStop( fraFrame )
	if (fraFrame == "TargetBar" and UnitIsUnit("target", "player") ) then
		return
	end
	local bar = getglobal("eCastingBar"..fraFrame)
	local barIcon = getglobal("eCastingBar"..fraFrame.."StatusBarIcon");
	local barFlash = getglobal("eCastingBar"..fraFrame.."Flash")
	local barStatusBar = getglobal("eCastingBar"..fraFrame.."StatusBar");
	local barSpark = getglobal("eCastingBar"..fraFrame.."StatusBarSpark");
	local barText = getglobal("eCastingBar"..fraFrame.."StatusBarText")
  -- make sure we aren't channeling first
	if bar.channeling == nil  then
    
    -- set the bar color
    local Red, Green, Blue, Alpha
    Red, Green, Blue, Alpha = unpack(eCastingBar_Saved[fraFrame.."SuccessColor"])
  	barStatusBar:SetStatusBarColor( Red, Green, Blue, Alpha )
		barSpark:Hide()
	end
  
  -- the bar still visible?
	if ( not bar:IsVisible() ) then
    -- yes, we are done casting, so hide it
		bar:Hide()
	end
  
  -- the bar still shown? ( not sure what the difference between this and :IsVisible, but there is (figure it out!) )
	if bar:IsShown() then
    -- set the bar to max value (visually helps the user see)
		barStatusBar:SetValue( bar.maxValue )
    
    -- start the flash state
		barFlash:SetAlpha( 0.0 )
		barFlash:Show()
		bar.casting = nil
		bar.delay = 0
		bar.flash = 1
		bar.fadeOut = 1
		bar.mode = "flash"
	end
end

--[[ Handles the UNIT_SPELLCAST_FAILED and UNIT_SPELLCAST_INTERRUPTED events. ]]--

function eCastingBar_SpellcastFailed( fraFrame )
	if (fraFrame == "TargetBar" and UnitIsUnit("target", "player") ) then
		return
	end
	local bar = getglobal("eCastingBar"..fraFrame)
	local barIcon = getglobal("eCastingBar"..fraFrame.."StatusBarIcon");
	local barFlash = getglobal("eCastingBar"..fraFrame.."Flash")
	local barStatusBar = getglobal("eCastingBar"..fraFrame.."StatusBar");
	local barSpark = getglobal("eCastingBar"..fraFrame.."StatusBarSpark");
	local barText = getglobal("eCastingBar"..fraFrame.."StatusBarText")
  
  -- the bar still shown? ( not sure what the difference between this and :IsVisiable, but there is (figure it out!) )
	if ( bar:IsShown() ) then
    -- set the bar to max (visually helps the user see)
		barStatusBar:SetValue( bar.maxValue )
    
    -- set the bar color
    local Red, Green, Blue, Alpha
    Red, Green, Blue, Alpha = unpack(eCastingBar_Saved[fraFrame.."FailedColor"])
    barStatusBar:SetStatusBarColor( Red, Green, Blue, Alpha )
		
    -- hide the spark, we dont need it anymore
		barSpark:Hide()
		
    -- the called event:spell failed?
		if ( event == "UNIT_SPELLCAST_FAILED" ) then
      -- yes, set the text accordingly
			barText:SetText( FAILED )
		elseif ( event == "UNIT_SPELLCAST_INTERRUPTED" ) then
      -- no, it must have been interupted instead, set the text accordingly
			barText:SetText( INTERRUPTED )
			
		--[[ [2] Removed by Bitz (Channel spell should not show an interrupted message)
		elseif ( event == "UNIT_SPELLCAST_CHANNEL_STOP" ) and (GetTime() < bar.endTime) then
			barText:SetText( INTERRUPTED )
		]]--
		end
		
    -- end the casting state, start the fadeout state
		bar.casting = nil
		bar.channeling = nil
    bar.delay = 0
		bar.fadeOut = 1
		bar.holdTime = GetTime() + CASTING_BAR_HOLD_TIME
	end
end

--[[ Handles the UNIT_SPELLCAST_DELAYED event. ]]--

function eCastingBar_SpellcastDelayed( fraFrame, intDisruptionTime )
	if (fraFrame == "TargetBar" and UnitIsUnit("target", "player") ) then
		return
	end
	local bar = getglobal("eCastingBar"..fraFrame)
	local barIcon = getglobal("eCastingBar"..fraFrame.."StatusBarIcon");
	local barFlash = getglobal("eCastingBar"..fraFrame.."Flash")
	local barStatusBar = getglobal("eCastingBar"..fraFrame.."StatusBar");
	local barSpark = getglobal("eCastingBar"..fraFrame.."StatusBarSpark");
	local barText = getglobal("eCastingBar"..fraFrame.."StatusBarText")
  
  -- the bar still shown? ( not sure what the difference between this and :IsVisiable, but there is (figure it out!) )
	if( bar:IsShown() ) then
	  
    -- set the start and max time according to how much it was disrupted
		bar.startTime = bar.startTime + ( intDisruptionTime / 1000 )
		bar.maxValue = bar.maxValue + ( intDisruptionTime / 1000 )
		
    -- set the bar accordingly (basicly stricking it according to how much it was disrupted)
		barStatusBar:SetMinMaxValues( bar.startTime, bar.maxValue )
    
    if bar.delay == nil then
    	bar.delay = 0
    end
    bar.delay = bar.delay + (intDisruptionTime / 1000)
	end
end

--[[ Handles the UNIT_SPELLCAST_CHANNEL_START event. ]]--

function eCastingBar_SpellcastChannelStart( fraFrame, unit)
	if (fraFrame == "TargetBar" and UnitIsUnit("target", "player") ) then
		return
	end
  
	local spellName, spellRank, displayName, texture, startTime, endTime = UnitChannelInfo(unit)
	local Red, Green, Blue, Alpha
	local bar = getglobal("eCastingBar"..fraFrame)
	local barIcon = getglobal("eCastingBar"..fraFrame.."StatusBarIcon");
	local barFlash = getglobal("eCastingBar"..fraFrame.."Flash")
	local barStatusBar = getglobal("eCastingBar"..fraFrame.."StatusBar");
	local barSpark = getglobal("eCastingBar"..fraFrame.."StatusBarSpark");
	local barText = getglobal("eCastingBar"..fraFrame.."StatusBarText")

  Red, Green, Blue, Alpha = unpack(eCastingBar_Saved.ChannelColor)
  barStatusBar:SetStatusBarColor( Red, Green, Blue, Alpha )
	if ( barIcon and eCastingBar_Saved[fraFrame.."IconPosition"] ~= "HIDDEN") then
		barIcon:SetTexture(texture);
		barIcon:Show();
	end

  
  -- show the spark
	barSpark:Show()
	
  -- set the bar to max
	bar.maxValue = 1
  
  -- set the delay
  getglobal("eCastingBar"..fraFrame).delay = 0
	
  -- set the start and end times
	bar.startTime = (startTime/1000)
  bar.initStartTime = (startTime/1000)

  
	bar.endTime = (endTime/1000)
	
  -- set the bar minium and maxium values
	barStatusBar:SetMinMaxValues( bar.startTime, bar.endTime )
	
  -- set the bar length visually to reflect the time
	barStatusBar:SetValue( endTime - ( GetTime() - (startTime/1000) ) )
	
  -- set the text to the spell name
  -- [3] Modified by Bitz --
  if ( eCastingBar_Saved[fraFrame.."ShowSpellName"] == 1 and string.len(spellRank) > 0 and eCastingBar_Saved[fraFrame.."ShowSpellRank"] == 1) then
	  barText:SetText( spellName.." ("..spellRank..")" )
  elseif ( eCastingBar_Saved[fraFrame.."ShowSpellName"] == 1 and ( string.len(spellRank) == 0 or eCastingBar_Saved[fraFrame.."ShowSpellRank"] == 0 ) ) then
	  barText:SetText( spellName )
	elseif ( eCastingBar_Saved[fraFrame.."ShowSpellName"] == 0 and eCastingBar_Saved[fraFrame.."ShowSpellRank"] == 1) then
	  barText:SetText( spellRank )
  else
    barText:SetText( "" )
  end
  ------- End of [3] -------
	
  -- set the bar to fully opaque
	bar:SetAlpha( 1.0 )
	
  -- reset various valuses used to hide the bar, also make sure its channeling not casting
	bar.holdTime = 0
	bar.casting = nil
	bar.channeling = 1
	bar.fadeOut = nil
	bar:Show()
	bar.mode = "channeling"
end

--[[ Handles the UNIT_SPELLCAST_CHANNEL_UPDATE event. ]]--

function eCastingBar_SpellcastChannelUpdate( fraFrame, intRemainingDuration )
	if (fraFrame == "TargetBar" and UnitIsUnit("target", "player") ) then
		return
	end
	local bar = getglobal("eCastingBar"..fraFrame)
	local barIcon = getglobal("eCastingBar"..fraFrame.."StatusBarIcon");
	local barFlash = getglobal("eCastingBar"..fraFrame.."Flash")
	local barStatusBar = getglobal("eCastingBar"..fraFrame.."StatusBar");
	local barSpark = getglobal("eCastingBar"..fraFrame.."StatusBarSpark");
	local barText = getglobal("eCastingBar"..fraFrame.."StatusBarText")
  
  -- is the remaining time zero?
	if( intRemainingDuration == 0 ) then
    -- yes, we aren't channeling anymore
    bar.channeling = nil
		
  -- no, the bar still shown? ( not sure what the difference between this and :IsVisiable, but there is (figure it out!) )
	elseif( bar:IsShown() ) then
    -- set the original duration
		local intOriginalDuration = bar.endTime - bar.startTime
    
    -- set the delay
    local elapsedTime = GetTime() - bar.startTime;
    local losttime = intOriginalDuration*1000 - elapsedTime*1000 - intRemainingDuration;
    bar.delay = bar.delay + (losttime / 1000);
    
    -- set the start and end time
		bar.endTime = GetTime() + ( intRemainingDuration / 1000 )
		bar.startTime = bar.endTime - intOriginalDuration
		
    -- set the bar length reflect the new state (basicly decreases the start time as time passes, thus shrinking the bar)
		barStatusBar:SetMinMaxValues( bar.startTime, bar.endTime ) 
		
	end
end

--[[ Handles all updates. ]]--

function eCastingBar_OnUpdate( frame )
	local bar = getglobal("eCastingBar"..frame)
	local barIcon = getglobal("eCastingBar"..frame.."StatusBarIcon");
	local barFlash = getglobal("eCastingBar"..frame.."Flash")
	local barStatusBar = getglobal("eCastingBar"..frame.."StatusBar");
	local barSpark = getglobal("eCastingBar"..frame.."StatusBarSpark");
	local barText = getglobal("eCastingBar"..frame.."StatusBarText");
	local barTime = getglobal("eCastingBar"..frame.."StatusBar_Time");
	local barDelay = getglobal("eCastingBar"..frame.."StatusBar_Delay");
  -- we casting?
  if( bar.casting ) then    
    -- yes:
  	if (frame == "TargetBar") then
  		if (not UnitCastingInfo("target") ) then
  			eCastingBar_SpellcastStop( frame )
  			return
  		end
  	end
    local intCurrentTime = GetTime()
    local intSparkPosition = 0
    
    -- Thanks to wbb at Cursed for the lovely formating
    if ( eCastingBar_Saved[frame.."ShowTime"] == 1) then
      barTime:SetText( string.format( "%.1f", math.max( bar.maxValue - intCurrentTime, 0.0 ) ) )
    else
      barTime:SetText("")
    end
    local bDelay = false
    if ( eCastingBar_Saved[frame.."ShowDelay"] == 1) then  
      if (bar.delay ~= 0) then
        bDelay = true
      end
    end
    if (bDelay) then
      getglobal("eCastingBar"..frame.."StatusBar_Delay"):SetText("+"..string.format( "%.1f", bar.delay ) )
    else
      getglobal("eCastingBar"..frame.."StatusBar_Delay"):SetText("")
    end
    
    -- the status > than the max?
    if( intCurrentTime > bar.maxValue ) then
      -- yes, set it to max (not sure how it would get that way, but again blizzard is safe)
      intCurrentTime = bar.maxValue
    end
    
    -- update the bar length
    barStatusBar:SetValue( intCurrentTime )
    
    --reset the flash to hidden
    barFlash:Hide()
    
    -- updates the spark
    local width = barStatusBar:GetWidth()
    intSparkPosition = ( ( intCurrentTime - bar.startTime ) / ( bar.maxValue - bar.startTime ) ) * width
    if( intSparkPosition < 0 ) then		
      intSparkPosition = 0			
    end
    
    -- set the spark to the end of the current barsize
    barSpark:SetPoint( "CENTER", "eCastingBar"..frame.."StatusBar", "LEFT", intSparkPosition, 0 )
    
  -- no, we channeling?	
  elseif ( bar.channeling ) then
    -- yes
    local intTimeLeft = GetTime()
    local intBarValue = 0
    local intSparkPosition = bar.endTime
    
    -- Thanks to wbb at Cursed for the lovely formating
    if (eCastingBar_Saved[frame.."ShowTime"] == 1) then    	
      -- if we are over 1 minute, do minute:seconds
      local timeLeft = math.max( getglobal("eCastingBar"..frame).endTime - intTimeLeft, 0.0 )
      local timeMsg = nil
      local minutes = 0
      local seconds = 0
      
      if (timeLeft > 60) then
        minutes = math.floor( ( timeLeft / 60 ))
        local seconds = math.ceil( timeLeft - ( 60 * minutes ))
        if (seconds == 60) then
          minutes = minutes + 1
          seconds = 0
        end
        timeMsg = format("%s:%s", minutes, getFormattedNumber(seconds))
      else
        timeMsg = string.format( "%.1f", timeLeft )
      end
      barTime:SetText( timeMsg )
    else
      barTime:SetText("")
    end
    local bDelay = false
    if (eCastingBar_Saved[frame.."ShowDelay"] == 1) then
      if (bar.delay ~= 0) then
        bDelay = true
      end
    end
    if (bDelay) then
      barDelay:SetText("+"..string.format( "%.1f", bar.delay ) )
    else
      barDelay:SetText("")
    end
    -- the time left greater than channeling end time?
    if( intTimeLeft > bar.endTime ) then
      -- yes, set it to the channeling end time (this will happen if you get delayed longer than the time left on channeling)
      intTimeLeft = bar.endTime
    end
    -- the times equal?
    if( intTimeLeft == bar.endTime ) then
      -- yes, we finished channeling, so start the fadeout process and exit
      bar.channeling = nil
      bar.fadeOut = 1
      return
    end
    -- update the bar length
    intBarValue = bar.startTime + ( bar.endTime - intTimeLeft )
    barStatusBar:SetValue( intBarValue )
    -- reset the flash to hidden
    barFlash:Hide()
    -- updates the spark
    local width = getglobal("eCastingBar"..frame.."Background"):GetWidth()
    intSparkPosition = ( ( intBarValue - bar.startTime ) / ( bar.endTime - bar.startTime ) ) * width
    barSpark:SetPoint( "CENTER", "eCastingBar"..frame.."StatusBar", "LEFT", intSparkPosition, 0 )
    -- no, the current time < the hold time?
  elseif( GetTime() < bar.holdTime ) then
    -- yes, exit, we aren't doing anything
    return
    -- no, we in flash mode?
  elseif( bar.flash ) then
    -- yes, sest the flash alpha
    local intAlpha = barFlash:GetAlpha() + CASTING_BAR_FLASH_STEP
    -- reset the text
    barTime:SetText( "" )
    -- the flash alpha < 1?
    if( intAlpha < 1 ) then
      -- yes, step it up
      barFlash:SetAlpha( intAlpha )
    else
      -- no, which means its 1 or greater, and we are at full alpha and done.
      bar.flash = nil
    end
    -- no, we fading out now?
  elseif ( bar.fadeOut ) then
    -- yes, set the CastingBar alpha
    local intAlpha = bar:GetAlpha() - CASTING_BAR_ALPHA_STEP
    -- the bar alpha > 0?
    if( intAlpha > 0 ) then
      -- step it down
      bar:SetAlpha( intAlpha )
    else
      -- no, which means its 0 or larger, and we are at fully transparent so we are done and hide the bar.
      bar.fadeOut = nil
      bar:Hide()
    end
  end
end

function getFormattedNumber(number)
	if (strlen(number) < 2 ) then
		return "0"..number
	else
		return number
	end	
end

--[[ Starts moving the frame. ]]--

function eCastingBar_MouseUp( strButton, frmFrame, frameType )
	if( eCastingBar_Saved[frameType.."Locked"] == 0 ) then
		getglobal( frmFrame ):StopMovingOrSizing()
    eCastingBar_Saved[frameType.."Left"] = getglobal(frmFrame):GetLeft()
    eCastingBar_Saved[frameType.."Bottom"] = getglobal(frmFrame):GetBottom()
    
    getglobal("eCastingBar"..frameType.."LeftSlider"):SetValue(eCastingBar_Saved[frameType.."Left"])
    getglobal("eCastingBar"..frameType.."BottomSlider"):SetValue(eCastingBar_Saved[frameType.."Bottom"])
	end
end

--[[ Stops moving the frame. ]]--

function eCastingBar_MouseDown( strButton, frmFrame, frameType )
	if( strButton == "LeftButton" and (eCastingBar_Saved[frameType.."Locked"] == 0 ) ) then
		getglobal( frmFrame ):StartMoving()
	end
end

function eCastingBarGeneral_MouseUp( strButton, frmFrame )
		getglobal( frmFrame ):StopMovingOrSizing()
end

--[[ Stops moving the frame. ]]--

function eCastingBarGeneral_MouseDown( strButton, frmFrame, frameType )
	if( strButton == "LeftButton") then
		getglobal( frmFrame ):StartMoving()
	end
end

function eCastingBar_getShowDelay()
	return eCastingBar_Saved.ShowDelay
end

function eCastingBar_setShowDelay( intShowDelay )
	eCastingBar_Saved.ShowDelay = intShowDelay
end

function eCastingBar_checkBorders()
  for index, option in pairs(frameSuffixes) do
  	local bar = getglobal("eCastingBar"..option)
    if (eCastingBar_Saved[option.."HideBorder"] == 1) then
      bar:SetBackdrop(nil)
    else
      bar:SetBackdrop({bgFile = CASTING_BAR_BACKGROUND_FILE, edgeFile = CASTING_BAR_EDGE_FILE, tile = true, tileSize = 16, edgeSize = 16, insets = { left = 5, right = 5, top = 5, bottom = 5 }}) 
      bar:SetBackdropColor(0,0,0,0.5)
    end
  end
  for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
  	local bar = getglobal("eCastingBarMirror"..index)
    if (eCastingBar_Saved.MirrorHideBorder == 1) then
      bar:SetBackdrop(nil)
    else
      bar:SetBackdrop({bgFile = CASTING_BAR_BACKGROUND_FILE, edgeFile = CASTING_BAR_EDGE_FILE, tile = true, tileSize = 16, edgeSize = 16, insets = { left = 5, right = 5, top = 5, bottom = 5 }}) 
      bar:SetBackdropColor(0,0,0,0.5)
    end
  end
end

--[[-------------------------------------------
	Functions for Locked State
-------------------------------------------]]--

function eCastingBar_checkLocked()
  for index, option in pairs(frameSuffixes) do
   	local barOutline = getglobal("eCastingBar"..option.."_Outline")
    -- only show the outline if we are enabled
    if (eCastingBar_Saved[option.."Enabled"] == 1 and
          eCastingBar_Saved[option.."Locked"] == 0) then
      barOutline:Show()
    else
      barOutline:Hide()
    end
  end
  

  -- only show the outline if we are enabled
  if (eCastingBar_Saved.MirrorEnabled == 1 and eCastingBar_Saved.MirrorLocked == 0) then
  	eCastingBarMirror_Outline:Show()
  else
    eCastingBarMirror_Outline:Hide()
  end
end

--[[-------------------------------------------
	Functions for Enabled State
-------------------------------------------]]--

--[[ Disables the frame. ]]--

function eCastingBar_Disable( fraFrame )
  eCastingBar_Saved[fraFrame.."Enabled"] = 0
  
	local intIndex = 0
	local strEvent = ""
	local bar = "CastingBarFrame"
	if (BCastBarCastBar) then
		bar = "BCastBarCastBar"
	end
	
  -- for each border in eCastingBar__Events register event.
  if (fraFrame == "") then  	
    for intIndex, strEvent in pairs(eCastingBar__Events) do
      -- make sure old casting bar is registered
      eCastingBar_Register( bar, strEvent )
      -- now unregister our casting bar
      eCastingBar_Unregister( "eCastingBar", strEvent )
    end
    -- CastTime mod exist 
    if( CastTimeFrame ) then
      -- for each event in eCastingBar__CastTimeEvents register event.
      for intIndex, strEvent in pairs(eCastingBar__CastTimeEvents) do
        -- make sure CastTime mod is enabled also bar is registered
        eCastingBar_Register( bar, strEvent )
      end
    end
  end
  -- the frame unlocked?
	if( eCastingBar_Saved[fraFrame.."Locked"] == 0 ) then
    -- yes, lets hide the outline
		getglobal("eCastingBar"..fraFrame.."_Outline"):Hide()
	end
end


--[[ Enables the frame. ]]--

function eCastingBar_Enable( fraFrame )
  eCastingBar_Saved[fraFrame.."Enabled"] = 1
  
	local intIndex = 0
	local strEvent = ""
	local bar = "CastingBarFrame"
	if (BCastBarCastBar) then
		bar = "BCastBarCastBar"
	end

  if (fraFrame == "") then
    -- for each border in eCastingBar__Events register event.
    for intIndex, strEvent in pairs(eCastingBar__Events) do
      -- make sure our bar is registered
      eCastingBar_Register( "eCastingBar", strEvent )
      -- now unregister blizzard bar
      eCastingBar_Unregister( bar, strEvent )
    end
    
    -- CastTime mod exist 
    if( CastTimeFrame ) then
      -- for each event in eCastingBar__CastTimeEvents register event.
      for intIndex, strEvent in pairs(eCastingBar__CastTimeEvents) do
        -- make sure CastTime mod is enabled also bar is registered
        eCastingBar_Unregister( bar, strEvent )
      end
    end
  end
	
  -- the frame unlocked?
	if( eCastingBar_Saved[fraFrame.."Locked"] == 0 ) then
    -- yes, lets show the outline
		getglobal("eCastingBar"..fraFrame.."_Outline"):Show()
	end
end

--[[ Toggle enabled state. ]]--

function eCastingBar_checkEnabled()
  for index, option in pairs(frameSuffixes) do
  	if (eCastingBar_Saved[option.."Enabled"] == 1) then
  		eCastingBar_Enable(option, 1)
    else
      eCastingBar_Disable(option, 0)
  	end
  end
  
  for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
    if (eCastingBar_Saved.MirrorEnabled == 1) then
  		if( eCastingBar_Saved.MirrorLocked == 0 ) then	
        -- yes, lets show the outline
        getglobal("eCastingBarMirror_Outline"):Show()        
      end		
    else
      if( eCastingBar_Saved.MirrorLocked == 0 ) then
        -- yes, lets hide the outline
        getglobal("eCastingBarMirror_Outline"):Hide()
      end
  	end
  end
end

--[[-------------------------------------------
	Functions for using the Texture 
-------------------------------------------]]--

--[[ Toggle enabled state. ]]--

function eCastingBar_checkTextures()
  for index, option in pairs(frameSuffixes) do
  	if eCastingBar_Saved[option.."Texture"] == nil then 
  		eCastingBar_Saved[option.."Texture"] = "Perl"
  	end
  	if eCastingBar_Saved[option.."Texture"] == "Halycon" then
  		eCastingBar_Saved[option.."Texture"] = "Halcyon"
  	end
    getglobal("eCastingBar"..option.."StatusBarTexture"):SetTexture( CASTING_BAR_TEXTURES[eCastingBar_Saved[option.."Texture"]] )
    getglobal("eCastingBar"..option.."StatusBarTexture"):SetWidth(20)
    getglobal("eCastingBar"..option.."StatusBarTexture"):SetHeight(10)
    getglobal("eCastingBar"..option.."ExampleStatusBarTexture"):SetTexture( CASTING_BAR_TEXTURES[eCastingBar_Saved[option.."Texture"]] )
    getglobal("eCastingBar"..option.."ExampleStatusBarText"):SetText( eCastingBar_Saved[option.."Texture"] )
  end
  
  for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
  	if eCastingBar_Saved.MirrorTexture == nil then
  		eCastingBar_Saved.MirrorTexture = "Perl"
  	end
  	if eCastingBar_Saved.MirrorTexture == "Halycon" then
  		eCastingBar_Saved.MirrorTexture = "Halcyon"
  	end
   	getglobal("eCastingBarMirror"..index.."StatusBarTexture"):SetTexture( CASTING_BAR_TEXTURES[eCastingBar_Saved.MirrorTexture] )
    getglobal("eCastingBarMirror"..index.."StatusBarTexture"):SetWidth(20)
    getglobal("eCastingBarMirror"..index.."StatusBarTexture"):SetHeight(10)  
  end
  eCastingBarMirrorExampleStatusBarTexture:SetTexture( CASTING_BAR_TEXTURES[eCastingBar_Saved.MirrorTexture] )
  eCastingBarMirrorExampleStatusBarText:SetText(eCastingBar_Saved.MirrorTexture)
end

function eCastingBar_setColor(colorFrame)
	if colorFrame == "SpellColor" or colorFrame == "ChannelColor" then
		local	Red, Green, Blue, Alpha = unpack(eCastingBar_Saved[colorFrame])
  	eCastingBarExampleStatusBar:SetStatusBarColor( Red, Green, Blue, Alpha )
  	if (eCastingBar.casting) then
  	  local	Red, Green, Blue, Alpha = unpack(eCastingBar_Saved.SpellColor)
		  eCastingBarStatusBar:SetStatusBarColor( Red, Green, Blue, Alpha )
		elseif (eCastingBar.channeling) then
			local	Red, Green, Blue, Alpha = unpack(eCastingBar_Saved.ChannelColor)
  		eCastingBarStatusBar:SetStatusBarColor( Red, Green, Blue, Alpha )
  	end
	elseif colorFrame == "TargetBarSpellColor" or colorFrame == "TargetBarChannelColor" then
		local	Red, Green, Blue, Alpha = unpack(eCastingBar_Saved[colorFrame])
  	eCastingBarTargetBarExampleStatusBar:SetStatusBarColor( Red, Green, Blue, Alpha )
	else
		local	Red, Green, Blue, Alpha = unpack(eCastingBar_Saved[colorFrame])
  	eCastingBarMirrorExampleStatusBar:SetStatusBarColor( Red, Green, Blue, Alpha )
		local timer = strupper(gsub(colorFrame, "Color", ""))
	  for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
			local frame = getglobal("eCastingBarMirror"..index);
			if ( frame:IsVisible() and (frame.timer == timer) ) then
				local	Red, Green, Blue, Alpha = unpack(eCastingBar_Saved[colorFrame])
  			getglobal("eCastingBarMirror"..index.."StatusBar"):SetStatusBarColor( Red, Green, Blue, Alpha )
  		end
  	end
  end
end

function eCastingBar_setIcons()
  for index, option in pairs(frameSuffixes) do
  	if (eCastingBar_Saved[option.."IconPosition"] == nil) then 
  		eCastingBar_Saved[option.."IconPosition"] = "HIDDEN"
  	end
  	if (eCastingBar_Saved[option.."IconPosition"] == "LEFT") then
	  	getglobal("eCastingBar"..option.."StatusBarIcon"):ClearAllPoints()
			getglobal("eCastingBar"..option.."StatusBarIcon"):SetPoint("RIGHT", getglobal("eCastingBar"..option), "LEFT", -5)
			if getglobal("eCastingBar"..option).mode == "casting" or getglobal("eCastingBar"..option).mode == "channelling" then
				getglobal("eCastingBar"..option.."StatusBarIcon"):Show()
			end
		elseif (eCastingBar_Saved[option.."IconPosition"] == "RIGHT") then
	  	getglobal("eCastingBar"..option.."StatusBarIcon"):ClearAllPoints()
			getglobal("eCastingBar"..option.."StatusBarIcon"):SetPoint("LEFT", getglobal("eCastingBar"..option), "RIGHT", 5)
			if getglobal("eCastingBar"..option).mode == "casting" or getglobal("eCastingBar"..option).mode == "channelling" then
				getglobal("eCastingBar"..option.."StatusBarIcon"):Show()
			end
		else
			getglobal("eCastingBar"..option.."StatusBarIcon"):Hide()
		end
  end
end

function eCastingBar_checkTimeColors()
  local Red, Green, Blue, Alpha
  for index, option in pairs(frameSuffixes) do
    Red, Green, Blue, Alpha = unpack(eCastingBar_Saved[option.."TimeColor"])
    getglobal("eCastingBar"..option.."StatusBar_Time"):SetTextColor(Red,Green,Blue, Alpha )
  end
  Red, Green, Blue, Alpha = unpack(eCastingBar_Saved.MirrorTimeColor)
  for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
    getglobal("eCastingBarMirror"..index.."StatusBar_Time"):SetTextColor(Red,Green,Blue, Alpha )
  end
end

function eCastingBar_setDelayColor()
  local Red, Green, Blue, Alpha
  for index, option in pairs(frameSuffixes) do
    Red, Green, Blue, Alpha = unpack(eCastingBar_Saved[option.."DelayColor"])
    getglobal("eCastingBar"..option.."StatusBar_Delay"):SetTextColor(Red,Green,Blue, Alpha )
  end
end

--[[ sets up the flash to look cool ]]--

--(thanks goes to kaitlin for the code used while resting). 

function eCastingBar_checkFlashBorderColors()
	local frmFrame = "eCastingBarFlash"
	local intIndex = 0
	local strBorder = ""
  local Red, Green, Blue, Alpha
  
  for index, option in pairs(frameSuffixes) do
    Red, Green, Blue, Alpha = unpack(eCastingBar_Saved[option.."FlashBorderColor"])
    
    -- for each border in eCastingBar__FlashBorders set the color to gold.
    for intIndex, strBorder in pairs(eCastingBar__FlashBorders) do
      getglobal( "eCastingBar"..option.."Flash_"..strBorder ):SetVertexColor( Red, Green, Blue, Alpha )	
    end
  end
	
  for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
    Red, Green, Blue, Alpha = unpack(eCastingBar_Saved.MirrorFlashBorderColor)
    for intIndex, strBorder in pairs(eCastingBar__FlashBorders) do
      getglobal( "eCastingBarMirror"..index.."Flash_"..strBorder ):SetVertexColor( Red, Green, Blue, Alpha )	
    end
  end
end


-- Sets the width and height of the casting bar

function eCastingBar_SetSize()
  local width, height, bottom, left, bar
  for index, option in pairs(frameSuffixes) do
    -- check boundaries
    if (eCastingBar_Saved[option.."Width"] < CASTING_BAR_SLIDER_WIDTH_MIN) then
      width = CASTING_BAR_SLIDER_WIDTH_MIN
    elseif (eCastingBar_Saved[option.."Width"] > CASTING_BAR_SLIDER_WIDTH_MAX ) then
      width = CASTING_BAR_SLIDER_WIDTH_MAX
    else
      width = eCastingBar_Saved[option.."Width"]
    end
    
    if (eCastingBar_Saved[option.."Height"] > CASTING_BAR_SLIDER_HEIGHT_MAX) then
      height = CASTING_BAR_SLIDER_HEIGHT_MAX
    elseif (eCastingBar_Saved[option.."Height"] < CASTING_BAR_SLIDER_HEIGHT_MIN ) then
      height = CASTING_BAR_SLIDER_HEIGHT_MIN
    else
      height = eCastingBar_Saved[option.."Height"]
    end
    
    left = eCastingBar_Saved[option.."Left"]
    bottom = eCastingBar_Saved[option.."Bottom"]
    
    --[[
    if (eCastingBar_Saved[option.."Left"] < 0) then
      left = 0;
    else
      left = eCastingBar_Saved[option.."Left"];
    end
    
    if (eCastingBar_Saved[option.."Bottom"] < 0 ) then
      bottom = 0;;
    else
      bottom = eCastingBar_Saved[option.."Bottom"];
    end
    ]]--
    
    getglobal("eCastingBar"..option):SetWidth(width)
    getglobal("eCastingBar"..option):SetHeight(height)
    
    getglobal("eCastingBar"..option.."Background"):SetWidth(width - 9)
    getglobal("eCastingBar"..option.."Background"):SetHeight(height - 8)
    
    getglobal("eCastingBar"..option.."Flash"):SetWidth(width)
    getglobal("eCastingBar"..option.."Flash"):SetHeight(height)
    
    getglobal("eCastingBar"..option.."StatusBar"):SetWidth(width - 9)
    getglobal("eCastingBar"..option.."StatusBar"):SetHeight(height - 10)

    getglobal("eCastingBar"..option.."StatusBarIcon"):SetWidth(height - 6)
    getglobal("eCastingBar"..option.."StatusBarIcon"):SetHeight(height - 6)
    
    getglobal("eCastingBar"..option.."_Outline"):SetWidth(width)
    getglobal("eCastingBar"..option.."_Outline"):SetHeight(height)
    getglobal("eCastingBar"..option.."_Outline"):ClearAllPoints()
    getglobal("eCastingBar"..option.."_Outline"):SetPoint("BOTTOMLEFT", "UIParent", "BOTTOMLEFT", left, bottom )
    
    getglobal("eCastingBar"..option.."Flash_TOP"):SetWidth(width - 24)
    getglobal("eCastingBar"..option.."Flash_BOTTOM"):SetWidth(width - 24)
    getglobal("eCastingBar"..option.."Flash_LEFT"):SetHeight(height - 24)
    getglobal("eCastingBar"..option.."Flash_RIGHT"):SetHeight(height - 24)
    
    getglobal("eCastingBar"..option.."StatusBarSpark"):SetHeight(height + 13)
    
    getglobal("eCastingBar"..option.."StatusBarText"):SetWidth(width - 49)
    getglobal("eCastingBar"..option.."StatusBarText"):SetHeight(height + 13)
    
    -- set the font size
    local fontName, _, fontFlags = getglobal("eCastingBar"..option.."StatusBarText"):GetFont()
		getglobal("eCastingBar"..option.."StatusBarText"):SetFont(fontName, eCastingBar_Saved[option.."FontSize"], fontFlags)
		getglobal("eCastingBar"..option.."StatusBar_Time"):SetFont(fontName, eCastingBar_Saved[option.."FontSize"], fontFlags)
  end
  
  for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
    
    -- check boundaries
    if (eCastingBar_Saved.MirrorWidth < CASTING_BAR_SLIDER_WIDTH_MIN) then
      width = CASTING_BAR_SLIDER_WIDTH_MIN
    elseif (eCastingBar_Saved.MirrorWidth > CASTING_BAR_SLIDER_WIDTH_MAX ) then
      width = CASTING_BAR_SLIDER_WIDTH_MAX
    else
      width = eCastingBar_Saved.MirrorWidth
    end
    
    if (eCastingBar_Saved.MirrorHeight > CASTING_BAR_SLIDER_HEIGHT_MAX) then
      height = CASTING_BAR_SLIDER_HEIGHT_MAX
    elseif (eCastingBar_Saved.MirrorHeight < CASTING_BAR_SLIDER_HEIGHT_MIN ) then
      height = CASTING_BAR_SLIDER_HEIGHT_MIN
    else
      height = eCastingBar_Saved.MirrorHeight
    end
    
    left = eCastingBar_Saved.MirrorLeft
    bottom = eCastingBar_Saved.MirrorBottom
    
    --[[
    if (eCastingBar_Saved.MirrorLeft < 0) then
      left = 0
    else
      left = eCastingBar_Saved.MirrorLeft
    end
    
    if (eCastingBar_Saved.MirrorBottom < 0 ) then
      bottom = 0
    else
      bottom = eCastingBar_Saved.MirrorBottom
    end
    ]]--
    
    getglobal("eCastingBarMirror"..index):SetWidth(width)
    getglobal("eCastingBarMirror"..index):SetHeight(height)
    
    getglobal("eCastingBarMirror"..index.."Background"):SetWidth(width - 9)
    getglobal("eCastingBarMirror"..index.."Background"):SetHeight(height - 8)
    
    getglobal("eCastingBarMirror"..index.."Flash"):SetWidth(width)
    getglobal("eCastingBarMirror"..index.."Flash"):SetHeight(height)
    
    getglobal("eCastingBarMirror"..index.."StatusBar"):SetWidth(width - 9)
    getglobal("eCastingBarMirror"..index.."StatusBar"):SetHeight(height - 10)
    
    getglobal("eCastingBarMirror_Outline"):SetWidth(width)
    getglobal("eCastingBarMirror_Outline"):SetHeight(height)
    getglobal("eCastingBarMirror_Outline"):ClearAllPoints()
    getglobal("eCastingBarMirror_Outline"):SetPoint("BOTTOMLEFT", "UIParent", "BOTTOMLEFT", left, bottom )
    
    getglobal("eCastingBarMirror"..index.."Flash_TOP"):SetWidth(width - 24)
    getglobal("eCastingBarMirror"..index.."Flash_BOTTOM"):SetWidth(width - 24)
    getglobal("eCastingBarMirror"..index.."Flash_LEFT"):SetHeight(height - 24)
    getglobal("eCastingBarMirror"..index.."Flash_RIGHT"):SetHeight(height - 24)
    
    getglobal("eCastingBarMirror"..index.."StatusBarSpark"):SetHeight(height + 13)
    
    getglobal("eCastingBarMirror"..index.."StatusBarText"):SetWidth(width - 49)
    getglobal("eCastingBarMirror"..index.."StatusBarText"):SetHeight(height + 13)
    
    -- set the font size
    local fontName, _, fontFlags = getglobal("eCastingBarMirror"..index.."StatusBarText"):GetFont()
		getglobal("eCastingBarMirror"..index.."StatusBarText"):SetFont(fontName, eCastingBar_Saved.MirrorFontSize, fontFlags)
		getglobal("eCastingBarMirror"..index.."StatusBar_Time"):SetFont(fontName, eCastingBar_Saved.MirrorFontSize, fontFlags)
  end
end

function eCastingBar_Copy_Table(src, dest)
	for index, value in pairs(src) do
		if (type(value) == "table") then
			dest[index] = {};
			eCastingBar_Copy_Table(value, dest[index]);
		else
			dest[index] = value;
		end
	end
end
