-- Version : English
-- Last Update : 12/18/2006

-- Start Not Localized --
strTab = "	";
strWhite = "|cffffffff";
strYellow = "|cffffff00";
strGreen = "|cff00ff00";
-- End Not Localized --

CASTINGBAR_HEADER = strWhite.."eCastingBar v"..strGreen..CASTING_BAR_MAJOR_VERSION..strWhite.."."..strGreen..CASTING_BAR_MINOR_VERSION.."."..strGreen..CASTING_BAR_REVISION..strWhite;

CASTINGBAR_CHAT_C1				= "config";
CASTINGBAR_CHAT_C2				= "help";

-- Help Text
CASTINGBAR_LOADED = "Loaded.";
CASTINGBAR_DELETED = "Deleted.";
CASTINGBAR_SAVED = "Saved.";
CASTINGBAR_HELP = {

	strLine1 = strYellow.."--- "..CASTINGBAR_HEADER..strYellow.." --- ",
	strLine2 = strWhite..strTab..CASTINGBAR_CHAT_C1..strYellow.." - Shows the config window"..strWhite

};

-- Bindings
BINDING_HEADER_ECASTINGBAR = "eCastingBar"
BINDING_NAME_ECASTINGBARDLG = "Toggle Configuration Window";
ECASTINGBAR_TITLE = "Configure eCastingBar"

-- Bar Text
OUTLINE_TXT = "eCasting Bar Outline."
MIRROR_OUTLINE_TXT = "Mirror Bar Outline."
TARGET_OUTLINE_TXT = "Target Bar Outline."

-- general buttons
CASTINGBAR_CASTING_TAB      = "Casting Bar"
CASTINGBAR_MIRROR_TAB       = "Mirror Bar"
CASTINGBAR_TARGET_TAB       = "Target Bar"
CASTINGBAR_PROFILE_TAB      = "Profiles"
CASTINGBAR_DEFAULTS_BUTTON  = "Defaults"
CASTINGBAR_CLOSE_BUTTON     = "Close"
CASTINGBAR_SAVE_BUTTON      = "Save Settings"
CASTINGBAR_LOAD_BUTTON      = "Load"
CASTINGBAR_DELETE_BUTTON    = "Delete"

-- options
CASTING_BAR_BUTTONS = {
  ["Locked"] = "Hide Outline",
  ["Enabled"] = "Enabled",
  ["ShowTime"] = "Show Time",
  ["HideBorder"] = "Hide Border",
  ["ShowDelay"] = "Show Delay",
  ["ShowSpellName"] = "Show Spell Name",
	["ShowSpellRank"] = "Show Spell Rank",
  ["MirrorLocked"] = "Hide Outline",
  ["MirrorEnabled"] = "Enabled",
  ["MirrorShowTime"] = "Show Time",
  ["MirrorHideBorder"] = "Hide Border",
  ["MirrorShowTimerLabel"] = "Show Timer Label",
  ["TargetBarLocked"] = "Hide Outline",
  ["TargetBarEnabled"] = "Enabled",
  ["TargetBarShowTime"] = "Show Time",
  ["TargetBarHideBorder"] = "Hide Border",
  ["TargetBarShowDelay"] = "Show Delay",
  ["TargetBarShowSpellName"] = "Show Spell Name",
	["TargetBarShowSpellRank"] = "Show Spell Rank"
}

CASTINGBAR_SLIDER_WIDTH_TEXT            = "width"
CASTINGBAR_SLIDER_HEIGHT_TEXT           = "height"
CASTINGBAR_SLIDER_LEFT_TEXT             = "x"
CASTINGBAR_SLIDER_BOTTOM_TEXT           = "y"
CASTINGBAR_SLIDER_FONT_TEXT             = "font size"
CASTINGBAR_CASTINGBAR_TEXTURE_TEXT      = "Casting Bar Texture"
CASTINGBAR_MIRRORBAR_TEXTURE_TEXT       = "Mirror Bar Texture"
CASTINGBAR_TARGETBAR_TEXTURE_TEXT       = "Target Bar Texture"
CASTINGBAR_ICON_POSITION_TEXT           = "Spell Icon Position"
CASTINGBAR_LEFT_TEXT                    = "Left"
CASTINGBAR_RIGHT_TEXT                   = "Right"
CASTINGBAR_HIDDEN_TEXT                  = "Hidden"

-- color
CASTINGBAR_COLOR_LABEL = {
  ["SpellColor"] = "Spell",
  ["ChannelColor"] = "Channel",
  ["SuccessColor"] = "Success",
  ["FailedColor"] = "Failed",
  ["TimeColor"] = "Time",
  ["DelayColor"] = "Delay",
  ["FlashBorderColor"] = "Flash Border",
  ["FeignDeathColor"] = "Feign Death",
  ["ExhaustionColor"] = "Exhaustion",
  ["BreathColor"] = "Breath",
  ["MirrorTimeColor"] = "Mirror Time",
  ["MirrorFlashBorderColor"] = "Mirror Flash Border",
  ["TargetBarSpellColor"] = "Target Spell",
  ["TargetBarChannelColor"] = "Target Channel",
  ["TargetBarSuccessColor"] = "Target Success",
  ["TargetBarFailedColor"] = "Target Failed",
  ["TargetBarTimeColor"] = "Target Time",
  ["TargetBarDelayColor"] = "Target Delay",
  ["TargetBarFlashBorderColor"] = "Target Flash Border",
}



----------------------------------
-- Version : Korean
-- Korean text by Bitz
----------------------------------

if ( GetLocale() == "koKR" ) then

-- Help Text
CASTINGBAR_LOADED = "설정을 불러왔습니다.";
CASTINGBAR_SAVED = "설정이 저장되었습니다.";
CASTINGBAR_DELETED = "설정이 삭제되었습니다.";
CASTINGBAR_HELP = {
	strLine1 = strYellow.."--- "..CASTINGBAR_HEADER..strYellow.." --- ",
	strLine2 = strWhite..strTab..CASTINGBAR_CHAT_C1..strYellow.." - 설정창을 엽니다."..strWhite
};

-- Bindings
BINDING_HEADER_ECASTINGBAR  = "eCastingBar"
BINDING_NAME_ECASTINGBARDLG = "설정 창 열기/닫기";

-- Bar Text
OUTLINE_TXT         = "시전바 위치 조정"
MIRROR_OUTLINE_TXT  = "타이머바 위치 조정"
TARGET_OUTLINE_TXT  = "대상 시전바 위치 조정"

-- genral
ECASTINGBAR_TITLE           = "eCastingBar 설정"

CASTINGBAR_CASTING_TAB      = "시전바"
CASTINGBAR_MIRROR_TAB       = "타이머바"
CASTINGBAR_TARGET_TAB       = "대상 시전바"
CASTINGBAR_PROFILE_TAB      = "프로파일"
CASTINGBAR_DEFAULTS_BUTTON  = "초기화"
CASTINGBAR_CLOSE_BUTTON     = "닫기"
CASTINGBAR_SAVE_BUTTON      = "설정 저장"
CASTINGBAR_LOAD_BUTTON      = "불러오기"
CASTINGBAR_DELETE_BUTTON    = "지우기"

-- options
CASTING_BAR_BUTTONS = {
  ["Locked"]                  = " 시전바 위치 잠금",
  ["Enabled"]                 = " 시전바 사용",
  ["ShowTime"]                = " 시전 시간 표시",
  ["HideBorder"]              = " 외곽선 숨기기",
  ["ShowDelay"]               = " 시전 지연 시간 표시",
  ["ShowSpellName"]           = " 주문 이름 표시",
  ["ShowSpellRank"]           = " 주문 레벨 표시",
  ["MirrorLocked"]            = " 타이머바 위치 잠금",
  ["MirrorEnabled"]           = " 타이머바 사용",
  ["MirrorShowTime"]          = " 남은 시간 표시",
  ["MirrorHideBorder"]        = " 외곽선 숨기기",
  ["MirrorShowTimerLabel"]    = " 상태 이름 표시",
  ["TargetBarLocked"]         = " 대상 시전바 위치 잠금",
  ["TargetBarEnabled"]        = " 대상 시전바 사용",
  ["TargetBarShowTime"]       = " 시전 시간 표시",
  ["TargetBarHideBorder"]     = " 외곽선 숨기기",
  ["TargetBarShowDelay"]      = " 시전 지연 시간 표시",
  ["TargetBarShowSpellName"]  = " 주문 이름 표시",
  ["TargetBarShowSpellRank"]  = " 주문 레벨 표시"
}

CASTINGBAR_SLIDER_WIDTH_TEXT        = "넓이"
CASTINGBAR_SLIDER_HEIGHT_TEXT       = "높이"
CASTINGBAR_SLIDER_LEFT_TEXT         = "X 좌표"
CASTINGBAR_SLIDER_BOTTOM_TEXT       = "Y 좌표"
CASTINGBAR_SLIDER_FONT_TEXT         = "글자 크기"
CASTINGBAR_CASTINGBAR_TEXTURE_TEXT  = "시전바 텍스쳐"
CASTINGBAR_MIRRORBAR_TEXTURE_TEXT   = "타이머바 텍스쳐"
CASTINGBAR_TARGETBAR_TEXTURE_TEXT   = "시전바 텍스쳐"
CASTINGBAR_ICON_POSITION_TEXT       = "주문 아이콘 위치"
CASTINGBAR_LEFT_TEXT                = "왼쪽"
CASTINGBAR_RIGHT_TEXT               = "오른쪽"
CASTINGBAR_HIDDEN_TEXT              = "숨기기"

-- color
CASTINGBAR_COLOR_LABEL = {
  ["SpellColor"]                = "주문 시전",
  ["ChannelColor"]              = "정신 집중",
  ["SuccessColor"]              = "시전 성공",
  ["FailedColor"]               = "시전 실패",
  ["TimeColor"]                 = "시전 시간",
  ["DelayColor"]                = "시전 지연 시간",
  ["FlashBorderColor"]          = "외곽선 깜박임",
  ["FeignDeathColor"]           = "죽은 척 하기",
  ["ExhaustionColor"]           = "피로",
  ["BreathColor"]               = "호흡",
  ["MirrorTimeColor"]           = "남은 시간",
  ["MirrorFlashBorderColor"]    = "외곽선 깜박임",
  ["TargetBarSpellColor"]       = "주문 시전",
  ["TargetBarChannelColor"]     = "정신 집중",
  ["TargetBarSuccessColor"]     = "시전 성공",
  ["TargetBarFailedColor"]      = "시전 실패",
  ["TargetBarTimeColor"]        = "시전 시간",
  ["TargetBarDelayColor"]       = "시전 지연 시간",
  ["TargetBarFlashBorderColor"] = "외곽선 깜박임"
}

end
