--- MetaMapBKP (Help module for MetaMap)
--- Written by MetaHawk - aka Urshurak

HLP_PADDING = 5;
HLP_HEADERCOLOUR = "|cFFBFBFFF";
HLP_TEXTCOLOUR = "|cFFFFFFFF";

HLP_HelpData = {};
HLP_ButtonTotal = 0;

function HLP_OnEvent()
	if(event == "ADDON_LOADED" and arg1 == "MetaMapHLP") then
		UIDropDownMenu_Initialize(HLP_MenuSelectMenu, HLP_MenuSelectInit, "MENU");
		UIDropDownMenu_SetText("Main", HLP_MenuSelect)
	HLP_DisplayOption(HLP_HelpData["Main"], 1);
	end
end

function HLP_MenuSelectInit()
	local mText, mSection;
	for index, hTable in pairs(HLP_HelpData) do
		local info = {};
		info.checked = nil;
		info.text = index;
		info.value = hTable;
		info.func = HLP_MenuSelectOnClick;
		UIDropDownMenu_AddButton(info);
		if(index == "Main") then
			mSection = hTable; mText = index;
		end
	end
end

function HLP_MenuSelectOnClick()
	HLP_DisplayOption(this.value, 1);
  UIDropDownMenu_SetText(this:GetText(), HLP_MenuSelect);
end

function HLP_DisplayOption(section, item, title)
	local button, buttontext, value;
	local buttonID = 1;
	local ScrollHeight = 0;
	for index, hList in pairs(section) do
		if(item == 1 or index == 2) then
			button = HLP_CreateButton(buttonID);
			buttontext = getglobal("HLPButton"..buttonID.."Header");
			button.title = title;
			if(item == 1) then
				value = hList[item];
				title = index;
				if(strlen(section[index][2]) > 0) then
					button.item = 2;
					button.title = index;
					button.section = section[index];
				end
			elseif(index == 2) then
				value = hList;
			end
			if(buttonID == 1) then
				button:SetPoint("TOPLEFT", "HLP_ScrollChild", "TOPLEFT", 10, -10)
			else
				button:SetPoint("TOPLEFT", getglobal("HLPButton"..buttonID-1), "BOTTOMLEFT", 0, 0)
			end
			buttontext:SetText(format(HLP_HEADERCOLOUR.."%s|r", title).."\n");
			buttontext:SetWidth(HLP_ScrollChild:GetWidth()-50);
			button:SetHeight(buttontext:GetHeight() + HLP_PADDING);
			button:SetParent("HLP_ScrollChild");
			button:Show();
			ScrollHeight = ScrollHeight + button:GetHeight();
			buttonID = buttonID +1;
		end

		if(item == 1 or (item == 2 and index == 2)) then
			button = HLP_CreateButton(buttonID);
			buttontext = getglobal("HLPButton"..buttonID.."Text");
			buttontext:SetText(format(HLP_TEXTCOLOUR.."%s|r", value).."\n");
			if(buttonID == 1) then
				button:SetPoint("TOPLEFT", "HLP_ScrollChild", "TOPLEFT", 10, -10)
			else
				button:SetPoint("TOPLEFT", getglobal("HLPButton"..buttonID-1), "BOTTOMLEFT", 0, 0)
			end
			buttontext:SetWidth(HLP_ScrollChild:GetWidth()-65);
			button:SetHeight(buttontext:GetHeight() + HLP_PADDING);
			button:SetParent("HLP_ScrollChild");
			buttontext:Show();
			button:Show();
			buttonID = buttonID + 1;
			ScrollHeight = ScrollHeight + button:GetHeight();
		end
	end
	for i=buttonID, HLP_ButtonTotal, 1 do
		getglobal("HLPButton"..i):Hide()
	end
	HLP_ScrollChild:SetHeight(ScrollHeight+10);
	HLP_ScrollFrame:UpdateScrollChildRect()
end

function HLP_CreateButton(id)
	local button;
	if(getglobal("HLPButton"..id)) then
		button = getglobal("HLPButton"..id);
		getglobal("HLPButton"..id.."Text"):SetText("");
		getglobal("HLPButton"..id.."Header"):SetText("");
		button.item = nil;
		button.title = nil;
		button.section = nil;
	else
		button = CreateFrame("Button" ,"HLPButton"..id, HLP_ScrollChild, "HLP_ButtonTemplate");
		button:SetWidth(HLP_ScrollChild:GetWidth());
		button:SetID(id);
		HLP_ButtonTotal = HLP_ButtonTotal +1;
	end
	return button;
end

function HLPButton_OnClick()
	if(this.section and strlen(this.section[this.item]) > 0) then
		HLP_DisplayOption(this.section, this.item, this.title)
	  UIDropDownMenu_SetText(this.title, HLP_MenuSelect);
	end
end

HLP_HelpData = {
	["Main"] = {
		["Intro"] = {
			[1] = "MetaMap adds features to the WoW world map, keeping all mapping type features in a single place. Some features are:\n\nAdjust the map window size.\nMove the map anywhere on the screen.\nAdjust the opacity of the window & maps.\nSaved sets for toggling between 2 map modes.\nAllows full player movement, messaging, etc. with map open.\nAdds coords to the main map and the Minimap\nAdds Instance maps which open to the correct instance you enter.\nDefault data included for all bosses & locations etc.\nUser editable notes for all maps, including instance maps.\nNPC/Mob database collectable by mouseover or keypress.\nToggling on/off display of unexplored areas of the map.\nBoss Loot Tables displays all the loot dropped by bosses, and more.\nWaypoint system to guide you to any set point.\nQuestLog system to track your current quests, with optional history database\nInbuilt Import and export facilities for various data formats.\nInbuilt Backup and Restore facilities.\nButton on Minimap to open or close the World Map or display MetaMap options.\nKey bindings for various MetaMap functions.\nFull support for Titan Bar and FuBar.",
			[2] = "",
		},
	},
	["Credits"] = {
		["Credits"] = {
			[1] = "Author: Urshurak - aka MetaHawk - Realm: Aggramar\n\nMaps created by Niflheim.\n\nOriginal MapNotes code by Sir.Bender.\n\nOriginal WoWKB code by ciphersimian.\n\nOriginal FullWorldMap code by Mozz.\n\nOriginal MetaMapBLT code by Daviesh.\n\nOriginal MetaMapBWP code by Noraj.\n\nFrench localisation by Sparrows.\n\nGerman localisation by oneofamillion.\n\nSpanish localisation by Fili.",
			[2] = "",
		},
	},
	["Issues"] = {
		["Issues/Compatibilities"] = {
			[1] = "Some addons may reset the map to gather location data. If your map continuously jumps back to your current location when selecting another map, it will be due to another addon resetting it. In most cases the authors have made changes to correct this so, download the latest version of any conflicting addon.\n\n\n*****NOTE*****\nMapNotes, WoWKB, MozzFullWorldMap, and BetterWaypoints have been INTEGRATED into MetaMap.\nThis means the original addons are no longer required. Remove them to avoid conflicts!",
			[2] = "",
		},
	},
	["Map Notes"] = {
		["Map Notes"] = {
			[1] = "The MetaMap core adds a note system to the WorldMap helping you keep track of interesting locations. This offers two main functions:\n\n1. Marking notes on the WorldMap or Instance maps.\n2. Showing one of these notes on the MiniMap as a MiniNote.\n\nMap functions:\nCTRL+LeftClick: On the WorldMap opens the note creator menu.\nLeftClick: On a note opens the note editor menu.\nRightClick on a note gives the option to set the note as a Waypoint.\nShift+LeftClick on a note will insert details into open message box.\nCTRL+LeftClick brings up the Boss Loot Table (MetaMapBLT).\nALT+LeftClick opens the Note Book with note title inserted, and ready to edit. (MetaMapNBK).\nMouse-over: On a Note to see the tooltip with the information you entered.\n\nEdit Menu:\nWith this menu you can create new notes and edit existing notes.\n\n1. Select the icon style you want to use for your note.\n2. Title: Enter it in the editbox and select a color in which it will bedisplayed in the tooltip.\nNOTE: The title field is mandatory, you cannot create a note without a title - to prevent this the 'Save' button is disabled when the title field is empty.\n3. Infoline 1 and 2: Here you can insert additional information for your note and color it in one of the colors below the editbox.\n4. Creator: Enter the name of the player or AddOn that created the note.\n\nThe MiniNote:\nA MiniNote is a note placed on the MiniMap. Moving the mouse over the MiniNote shows the details of the note. To show one of your notes on the MiniMap go to the Worldmap, left click on a note and choose 'Set As MiniNote'. To hide the note on the MiniMap, you can go to the WorldMap, left click and choose 'Turn MiniNote Off'.\n\nThe MiniNote is turned off if the MapNote corresponding to it is deleted.\n\nSend Notes To Other Players:\nAfter clicking 'Send Note' in the notes Menu the Send Menu will show up.\n\n1. Enter the name of the player you want to send a note to.\n   NOTE: Targeting the player before opening the WorldMap will auto insert the name.\n\n2. Send To Player\n   Choose this option to send the note to the player entered above.\n\n3. Send To Party\n   This will send the note to the entire party. (No player name needs to be filled in).\n\n4. Change Mode\n   This toggles between Send To Player/Send To Party and Get Slash Command).\n\n5. Get Slash Command\n   Inserts a slash command in the editbox which can be highlighted and then copied to the clipboard.  After this you can post it on a forum or in chat and other MetaMap or MapNotes users can insert this note by copying the slash command to the chatline.\n\nSlash Commands:\n\n/nextmininote [on|off], /nmn [on|off]\nShows the next note created (using any method) as a MiniNote and also puts it on the WorldMap. If invoked with no parameters, it will toggle the current state.\n\n/nextmininoteonly [on|off], /nmno [on|off]\nLike the previous command, but doesn't put the note on the WorldMap.\n\n/mininoteoff, /mno\nTurns the MiniNote off.\n\n/quicknote [m] [xx,yy] [name], /qnote [m] [xx,yy] [name]\nSets a note on the map in your current zone. The optional [m] parameter will set a mode for the note.\n1 = Set as Note + Mininote\n2 = Set as Mininote only\n3 = Set as a vNote (Virtual Note)\n\nNo parameter or any other number for [m] will set as map note only. Coords and name are also optional. If no coords are entered, note is set at your current location.",
			[2] = "",
		},
	},
	["Menu Options"] = {
		["Menu Options"] = {
			[1] = "The additions to the main WoW WorldMap were intended to fit in as smoothly as possible, keeping the overall format the same. It adds not only Instance maps, but also extends user editable notes to the Instance maps.\n\nOptions Menu:\nAlso available in context from the Minimap button and TitanBar.\nMenu on Click:\nMenu is displayed by clicking the button or on mouse-over.\nWrap ToolTip:\nWill wrap tooltip displays to WoW defined limit.\nShow Main Coords:\nToggles the display of the WorldMap coords.\nShow MiniMap Coords:\nToggles the display of coords on the MiniMap.\nNotes Filter:\nShows a Submenu which allows you to filter out notes on the map.\nAllow clicks through map:\nSets map to a passive mode to allow all mouse action through the map. Setting stored for each Saveset.\nMap Mode:\nSwitches between 2 saved map modes. Each set stores its own settings for Opacity, Scale and Action Mode.\nInstance Backdrop Shade:\nToggles between 4 different backdrops.\nExtended Options:\nDisplays an additional options menu for further options.\nFlightMap Options:\nDisplays FlightMap options (Requires FlightMap Addon).\nGatherer Options:\nDisplaye Gatherer options (Requires Gatherer Addon).\nSet as Waypoint:\nToggles the BWP options (Requires MetaMapBWP module).\nCreate notes with MapMod:\nNew note creation is done with CT_MapMod rather than MetaMap's internal note creation. Both live quite happily with each other so, you can toggle between them at any time.\nKnowledge Base:\nDisplays the WKB database window.\nQuest Log:\nDisplays the QST database window.\nShow Unexplored Areas:\nToggles the display of unexplored areas on the map.\n\nShift+LeftClick on Main map coords will insert location details into open message box.\nShift+LeftClick on Minimap coords will insert location details into open message box.\nCTRL+LeftClick on Minimap coords will cycle through setable text colours.\nLeft button down to drag Minimap coords display to anywhere on the screen.\n\nMap List:\nLeft Clicking an item in the list will ping the location on the map.\nRight Clicking an item in the list will show the notes edit box.\nCTRL+Click an item in the list on an instance map will show the bossloot table.\n\nKeybindings set in the system keybindings section allow quick key toggles for:\nToggling the WorldMap.\nSwitching between the 2 Map modes.\nToggling Fullscreen setting.\nToggling Knowledge Base display.\nTargetting a unit for inclusion in the Knowledge Base.\nToggling the QuickNote display.\nRemoving a Waypoint.",
			[2] = "",
		},
	},
	["Modules"] = {
		["MetaMapBKP"] = {
			[1] = "Backup & Restore module - backs up all your data and allows a restore at any time, with ease. Available from Extended Options",
			[2] = "This module will backup or restore all data in a very quick and easy manner. Once loaded, you will have the option to backup data from the WKB database, the QST database, as well as Map notes and Lines. It is stored to a totally seperate file, so is not affected by any data changes within MetaMap or its Modules.\n\nSelected data can be restored at any time. Restoring will remove any current data to be replaced, by the backup data.",
		},
		["MetaMapBLT"] = {
			[1] = "Boss Loot Tables - Displays loot tables when CTRL-Clicking on any map note, or any item in the map SideList.",
			[2] = "This module adds Boss Loot Tables to all the instance bosses, and can be shown by a CTRL-Click on either the map note, or the listed item in the SideList. The standard Shift-Click to insert the item link into an open message box, and the CTRL-Click to view the item in the DressingRoom are also included.\n\nNote that the items can only be shown if they are present in the server cache. This cache is always cleared with a new patch so, you may find a lot of items unavailable until the server cache has rebuilt. There are a few addons available which get around this problem by building their own database of items, which are then viewable even if the server cache lacks the item. Compatibility is built in for two of those, namely LootLink and ItemSync.\n\nThe default loot data is regularly maintained as a data copy from AtlasLoot.",
		},
		["MetaMapBWP"] = {
			[1] = "Adds a Waypoint system. Shows direction to selected point, and distance remaining. Selected from the MetaMap menu. Option to always load on startup.",
			[2] = "MetaMapBWP module adds a Waypoint system to MetaMap. A Waypoint arrow is displayed, showing the direction of the point set.\n\nUSAGE:\nA waypoint can be set by a number of methods:\n\n1. Select a preset map note from the dropdown list displayed when clicking 'Set a Waypoint' on the main MetaMap menu.\n2. RightClick on any map note on the map.\n3. RightClick on any entry in the MetaMap KB display.\n4. By typing '/bwp xx,yy name' on the command line.\n\nBoth commandline parameters are optional. Results are as follows:\nCoords only: Sets a Waypoint at specified location with default name of 'QuickLoc'.\nCoords + Name: Sets a Waypoint at specified location with specified name.\nNo parameters: Sets a Waypoint at current location with default name of 'QuickLoc'.\nName only: Sets a Waypoint at current location with specified name.\n\nThe last two are useful if you need to mark your current location so you can easily return to it at a later time. Note that you will need to turn off the 'Clear Waypoint on arrival' option for this to prevent it from being cleared.\n\nThe dropdown options menu can be accessed either by selecting 'Options' from the\npreset Waypoints list, or by clicking on the main Waypoint display.\n\nThe Waypoints display can also be moved to any location on the screen by using the RightButton down to drag it.",
		},
		["MetaMapCVT"] = {
			[1] = "Main Import/Conversion module. Will import many different data files. ANY data file for import MUST be placed in the MetaMapCVT folder for import.",
			[2] = "MetaMapCVT will import data from various other addons, from a provided file placed in the MetaMapCVT folder.\n\nNOTE: Files for import MUST be placed in the MetaMapCVT folder before starting WoW!\n\nMapNotes:\nSavedVariables\\MapNotes.lua (If you were previously running the MapNotes addon).\nRename to MetaMapEXP.lua and place in the MetaMapCVT folder.\n\nMapMod:\nSavedVariables\\MapMod.lua (If you were previously running the MapMod addon)\nRename to MetaMapEXP.lua and place in the MetaMapCVT folder.\n\nQuestHistory:\nSavedVariables\\QuestHistory.lua (If you were previously running the QH addon)\nRename to MetaMapEXP.lua and place in the MetaMapCVT folder.\n\nUser File:\nCreated by User export or a correctly formatted file for download.\nNormally received as MetaMapEXP.lua and placed in the MetaMapCVT folder.\n\nInstanceData:\nIncluded as standard in the MetaMapCVT folder. No renaming required.\n\nBLT:\nDefault data included for import as standard. No renaming required.\n\n\nTo import any data, click the 'Load Import Module' button after selecting the 'Import' tab on the Extended Options Menu. This will load the required routines and data files. Then select the import option required.\n\nFor those wishing to export data to other users, simply click on the 'Export User File' option in the Imports section. WKB data, Notes data, or QSTdata can be exported. This will create a file in the SavedVariables folder called 'MetaMapEXP.lua'. Any MetaMap user can then place this file in their MetaMapCVT folder, ready for import.",
		},
		["MetaMapEXP"] = {
			[1] = "Export module for exporting User created data for others to import. Both Import and Export functions are available from Extended Options.",
			[2] = "This module will export user data from the WKB and QST modules, as well as Map notes and lines. The selected data is written to a file in the SavedVariables folder, called MetaMapEXP. This file can subsequently be placed in the MetaMapCVT folder by any other user for import into their system.",
		},
		["MetaMapFWM"] = {
			[1] = "FullWorldMap module. Shows unexplored areas of the map with custom colours. Option to load always on startup.",
			[2] = "This module will reveal any unexplored areas of any map. Options to use colours, as well as colour choices are available from the Modules section in Extended Options.",
		},
		["MetaMapHLP"] = {
			[1] = "Help module containing program information and guides on usage.",
			[2] = "You need help on help???",
		},
		["MetaMapWKB"] = {
			[1] = "WoW Knowledge Base. Stores NPC/MoB data on mouseover or keypress. Full integration with the Notes system. Option to load always on startup.",
			[2] = "MetaMapWKB database stores the name, description and location of all the NPCs/mobs you mouse over.  The location is stored as a range to allow for movement or various spawn points.  The range is updated every time you find the NPC in a different location.\n\nThe database is global - all your characters on the same computer and account can access it. The Auto tracking on mouse-over will only add information from NPC/MOB targets. Would get pretty cluttered otherwise. However, there is also a 'manual' mode via a Keybinding set in the system keybinding section. This method will also allow a targeted Player unit to be added to the database.\n\nYou can create Notes when you need them (i.e. hunting a particular mob or looking for a particular NPC) and then when things start to get cluttered you can remove the notes for a particular NPC/mob or all from the QuickMenu.\n\nLeftClicking on an item in the main KB window will pop up the QuickMenu with various options. RightClick gives the option to set the item as a Waypoint.",
		},
		["MetaMapQST"] = {
			[1] = "Adds a complete Quest logger with optional database for maintaining Quest history.",
			[2] = "This module will automatically pick up your current quests, and display them in a nice colour-coded way. Quests will be displayed according to the map currently displayed. Selecting a continent display, for example, will display all quests related to all the zones in that continent. Selecting the World map will display all quests, including those in instances.\n\nAdditionally, if you select the option to maintain a history database, it will store any completed or abandoned quests in the database. Bear in mind that this could soon cause the database to grow to a fair size so, some options to cut back the size are included in the options dialogue.\n\nThe pop-up menu on the display allows you to set certain criteria for display, such as filtering by character, by active quests etc, as well as sort orders. There is additionally a search filter which allows you to search on any characters you type in. The module also gives the ability for you to add your own personal notes to any quest at any time.\n\nEverything related to any quest is available from the display, and removes the need to pop up the standard quest window for information. Mouseover the button with the '?' to see all the key combinations for viewing various aspects of the quest information.\n\nA QuickMenu is also available by Right-Clicking any item in the display. The following options are available:\nEdit Notes: Brings up the Note editor for that specific quest.\nMap note NPC1: Sets the QuestGiver as a map note. (If recorded)\nMap note NPC2: Sets the QuestCompleter as a map note. (If recorded)\nInsert Title: Will insert the selected quest title into an open message box.\nInsert Items: Will insert the selected quest items into an open message box.\nShare Quest: Shares the selected quest with any party members.\nRemove Quest: If the quest is an item in the history database, a confirmation dialogue appears for removal. If it is a currently active quest, the standard 'Abandon Quest' dialogue will appear.\n\nSetting a map note will optionally open the map and display the exact location, if you have that option set in main options.",
		},
		["MetaMapNBK"] = {
			[1] = "Adds a Note Book where you can keep all your extended notes on anything.",
			[2] = "This module allows you to create extended notes on anything you like. Further options will let you display the extended information in related Tooltips, when it matches the note title with any item, mob, NPC, map note, or player you mouseover. Additionally, an ALT-Click on any of those targets will open the NoteBook with the target title inserted in the header, ready to add whatever notes you like.",
		},
	},
	["Version History"] = {
		["Version History"] = {
			[1] = "|cFFBFBFFF13 December 2006 - v20000-5|r\nAdded check for nil table index for MetaMapWKB zoneshift conversion.\nFixed MetaMapNBK attempting to show a GuildName in non-Unit Tooltips.\nRe-instated compatibility check for QuestLog call. QuestLog will display correctly again.\n...(Seems not all the TBC changes were included in the current patch. Parameters for this is one example).\n\n|cFFBFBFFF12 December 2006 - v20000-4|r\nAdded option to set font size in the menus.\nFixed the awkward submenu selection on the Instances dropdown.\n...(Caused by buggy button levels in the Blizzard templates).\nSwapped the menu colours for On/Off text by popular demand. :p\nCorrected a few missed French ZoneNames in the ZoneTable.\nAdded a check for incorrect zone data in the data conversion routines.\n...(Should addresses the errors some were getting when converting old data to the new format).\n\n|cFFBFBFFF10 December 2006 - v20000-3|r\nMetaMap now hides the Blizzard WorldMap icon from the Minimap on startup.\nFuBar no longer displays MetaMap on the Minimap when disabled on the bar.\nUpdated the ZoneTable to include the new French translated ZoneNames.\nAdded the French shifts to the ZoneShift matrix for those who missed upgrading before the patch.\n...(This will shift the zones to the correct index, before changing it to the new data format).\n...(If you have backups of the PRE-PATCH SavedVariables MetaMap.lua and MetaMapWKB.lua, simply place them in the SavedVariables folder, and run WoW.).\n\n|cFFBFBFFF09 December 2006|r - v20000-2\nFixed some map notes not displaying, even though they showed correctly in the SideList.\n..(Seems Blizz routines no longer save data in sequential order, resulting in skipped notes).\nTemporarily disabled the MetaMapNBK hook for clicking on bag items to avoid the blocked action error.\n...(Will look at the secure hooking nonsense when I get a bit more time).\n...(NOTE: It will still work for map notes though, as that doesn't touch any precious Blizz stuff).\nFixed error when attempting to link a MetaMapWKB item to message box.\nFixed occasional error when attempting to link some reward items in MetaMapQST.\nUpdated MetaMapBLT item links to new format. Fixes the disconnects on display.\n...(Found some nasty little Blizzard bugs lurking. The above link changes get around them).\nAdded ZoneTable conversions to import routines. Will now convert to the correct locale.\n...(This also means that any file available for download, such as a compiled MetaMapWKB, will be able to be imported correctly into a different locale. It won't translate the info for you, but at least will end up in the right place :p).\n\n|cFFBFBFFF09 December 2006 - v20000-2|r\nAdded ZoneTable conversions to import routines. Will now convert to the correct locale.\n...(This also means that any file available for download, such as a compiled MetaMapWKB, will\nbe able to be imported correctly into a different locale. It won't translate the info for you,\nbut at least will end up in the right place :p).\n\n|cFFBFBFFF08 December 2006 - v20000-1|r\nFixed Filter menu icons appearing in other secondary dropdown lists.\nUpdated the ZoneTable with the new Zone names for German clients.\nChanged pathing for MetaMapCVT. Imports module will find the import files again now.\n...(Blizz just loves slipping in these undocumented last minute changes...).\nUpdated the dual functionality routines to the current Lua version and current Blizzard calls.\nAdded a temporary indexed ZoneShift matrix for those who missed upgrading before the patch.\n...(This will shift the zones to the correct index, before changing it to the new format).\n...(If you have backups of the PRE-PATCH SavedVariables MetaMap.lua and MetaMapWKB.lua, simply place them in the SavedVariables folder, and run WoW. NOTE: This currently only applies to English and German clients, as no French or Spanish client offered to run a ZoneCheck for me).\n\n|cFFBFBFFF03 December 2006 - v11200-11|r\nMajor change to data formats for MetaMap and MetaMapWKB. No longer places reliance on indexing.\nFixed MetaMapBWP not displaying a Waypoint in Battlegrounds.\nFixed the occasional timelog and items errors in MetaMapQST.\nRemoved the MetaMapZSM module as this is now redundant with the new data format.\nAdded all the new HQ instance maps for Outlands. With big thanks to Nifl.\nReplaced the old ZSM section in Extended Options with a Zone Checker.\n...(Basically, whenever a new patch changes a ZoneName, simply run the checker to find the\nchanged zone, then match it to the new ZoneName to update it. No more needing to wait for a ZoneShift update).\nNumerous other fixes and changes have been made, too many to list.\n\n|cFFBFBFFF12 November 2006 - v11200-10|r\nAdded check for rare missing date/time field in the QST history data.\nIncreased the delay for QST verification routines on startup.\n...(Still seemed to run occasionally before the Blizz QuestLog had fully initialised).\nFixed error on items routine. TBC didn't show the same tolerance as current version did.\nFixed map note jumping to odd location when set on player arrow.\nChanged common zone routines to correctly handle BattleGrounds.\n...(Fixes the BWP corpse error, and fixes setting multiple notes in BGs).\nCorrected return value for WKB 'Infinite' setting. Captures correctly again.\nCTRL-RightClick on SideList now brings up the option to set a Waypoint.\nMetaMapNBK will now display itself when ALT-Clicking on any target or bag item.\nAdded ALT-Click to any map note or any SideList item for the same NBK functionality.\n...(Will add the target/item/note name to NBK header, ready for adding additional notes).\nFixed the Tabs on the Options display to work around the currently bugged TBC standard calls.\nWith various other changes, this now brings MetaMap to full compatibility with TBC.\n...(NOTE that there is currently a bug in the TBC quests, which adds a CR to quest text).\n...(This may result in an error for QST in TBC. Has been reported, and is awaiting a fix).\n\n|cFFBFBFFF04 November 2006 - v11200-9|r\nReplaced the buggy 'resizeTab' call with my own routine.\nAdded check for nil value return on quest level for quests that do not have a level set.\nCorrected variable name for Note Book to correctly initialise the database on first run.\nConverted the MetaMapNBK routines to a Load-on-Demand module.\nAdded Tooltips routines to MetaMapNBK. Enhances both game and map tooltips.\n...(Will add the NBK body text if the NBK header matches any item, mob, player, map note etc).\nAdded Guild name display option for player Tooltips.\nAdded an options display to MetaMapNBK.\nAdded various options, such as Tooltip, Guild, sound toggles, as well as text color options.\nAdded scaling option for resizing the main Note Book window.\nNBK index list is now sorted alphabetically on note title.\nUpdated the French localisation. With thanks to Corwin Whitehorn.\nThis should hopefully make MetaMap compatible with BC so far.\n\n|cFFBFBFFF01 November 2006 - v11200-8|r\nReworked messaging routines to be compatible with the upcoming BC release.\nThe new routines also fix the ancient return message error when sending a note to another player.\nSending to Party or Raid now makes use of the new Addon Channel.\n...(Net effect is that players without MetaMap will no longer receive the note info).\nPaired the tables in the 'for' routines. \nReworked the fetching of table size into a single routine, compatible with current and BC versions.\nReworked the Zone routines to a more dynamic approach, allowing for unlimited expansion.\n...(Means that MetaMap will automatically cope with any future Continent or Zone additions).\nMade some changes to the 'tabresize' call to hopefully avoid the buggy new changes in there.\nUpdated all the modules with all the above changes.\nFixed error with QST log verification routine always moving current quests to the history.\n...(Gets around the considerable delay before the QuestLog is updated after login).\nNEW Note Book feature added to the MetaMap menu. Currently a very lightweight note keeper.\n...(More features such as map note extensions, Tooltip links etc, will be added soon).\nUpdated the Spanish localisation. With thanks to Filli for translation.\nAlso, a special thanks to Devla for providing excellent feedback on the BC Beta.\n\n|cFFBFBFFF28 October 2006 - v11200-7|r\nCorrected the frame level for the SideList scrollbar.\n...(Missed seeing that hiding under parent frame after adjusting frame levels).\nImport for QuestHistory will now skip any entries which have key fields missing.\nImport for QuestHistory now includes the quest end time.\nClicking on Quest header will now display the correct instance map, if an Instance quest.\nAdded startup data verification routine to remove orphaned entries from the QuestLog.\n...(Will additionally move them to the history if option to maintain database is set).\nAdded additional checks for quest locations. Will mark them as unknown if no match found.\nReworked the time/date routines to give a totally accurate return on quest times.\nAdded quest date and time in a nice format to the quest Tooltips. Shift-onEnter to view.\nReplaced QST note editor on Right-Click with a QuickMenu.\nMoved some of the key combination clicks to the QST QuickMenu for less confusion.\nAdded option to QuickMenu for setting a QuestGiver/QuestCompleter note on the map.\nAdded option on QST main options to auto-locate note on the map when setting it.\nAdded a remove option to the QST QuickMenu. Will either remove from history or Abandon.\nAdded two new HQ maps by Niflheim for the Hellfire Peninsula.\n\n|cFFBFBFFF23 October 2006 - v11200-6|r\nCorrected a few typos in the Help display.\nFixed the 'Menu-on-Click' option not being saved correctly.\nFixed potential problem if multiple characters have the same quest.\nReplaced a rather nasty Blizzard call which didn't return correct values sometimes.\n...(Resulted in the wrong quest being moved into the history base).\nAdded routine to use FuBar 2 if FuBar 1.2 compatibility is missing.\nAdded QuestLog re-ordering after Quest completion/abandon to ensure correct indexing.\n...(Could otherwise possibly cause corruption to an existing entry).\nAdded MetaMapQST import routine for user exported quests.\n\n|cFFBFBFFF20 October 2006 - v11200-5|r\nOptimised BLT Class display. Localised names also no longer overlap with default English.\nOptimised many routines and converted some module routines to MetaMap global routines.\nRemoved the external KB window. Sorry, but it's getting too heavy going to fit it in.\nChanged WKB text display to common font routines for better readability when scaled down.\nReworked options routines for better efficiency. A couple of options may have been reset to default.\nLocalised the module specific options to the modules themselves.\nChanged MetaKB tab in Extended options to 'Modules'. This section now groups module specifics.\nThe toggle option and colour option for MetaMapFWM is relocated to the Modules section.\nChanged MetaFWM tab in Extended options to 'Help'.\nNEW MetaMapHLP module included. Loaded from the new Help tab, shows all information on the various of MetaMap and its Modules.\nNEW MetaMapQST module included. Shows current Quests and optional database for history.\nAdded import routines for MetaMapQST to import QuestHistory data.\nAdded Keybinding for toggling MetaMapQST.\nReworked the Backup/Restore module, and included option for MetaMapQST data.\n\n|cFFBFBFFF28 September 2006 - v11200-4|r\nFixed error on MetaMapBLT import due to missing data items.\n...(Didn't show up when testing because I totally forgot to disable AtlasLoot. Doh!).\n\n|cFFBFBFFF28 September 2006 - v11200-3|r\nCouple of Instance name fixes for the German client.\nFixed dynamic search function for MetaMapWKB.\nAdded detection/warning if libraries are missing for FuBar v2.\nDressing room now correctly shows on top when viewing class sets.\nChanged MetaMapBLT routines to handle the new AtlasLoot class set layouts.\nUpdated MetaMapBLT with latest data from AtlasLoot. Includes all class sets, as well as PvP.\n...(NOTE: Re-import the default Instance and BLT data to update the changes).\n\n|cFFBFBFFF28 August 2006 - v11200-2|r\nFixed error when deleting note set in Battlegrounds.\nNotes can now be created in Battlegrounds with the QuickNote option.\n\n|cFFBFBFFF24 August 2006 - v11200-1|r\nRemoved all AtlasLoot import options. Later versions of AtlasLoot are now totally incompatible.\n...(Default BLT import only for now, which I will keep updated).\nFixed map opening to full screen. Will again open to correct scale setting.\n..(Looks like Blizz screwed up on the 'OnShow' function somehow).\nFixed MetaMapBLT Dressing room not displaying character on opening.\nNo ZoneShifts required for German/French clients on this patch. :)\n..(Load ZoneShift module and select 'Update Version' to update the tracker).\nNOTE! The last version included a MetaMapEXP.lua in the MetaMapCVT folder in error.\n...(DO NOT import this file. DELETE it! It's a ZoneShifted TEST file).\n\n|cFFBFBFFF16 August 2006 - v11100-7|r\nUpdated routine that matches Mininote with existing map note to be totally unique.\n...(Previously took first name match, not taking into account multiples with same name).\nSlight change to the MiniCoords routine.\n...(Possible fix for the unexplainable 616 error a few were getting).\n\n|cFFBFBFFF11 August 2006 - v11100.6|r\nQuick fix for MetaMap menu not hiding on mouseout.\n...(Totally missed checking for non existance of FuBar. Apologies on that one).\n\n|cFFBFBFFF11 August 2006 - v11100.5|r\nAdded support for FuBar. Recommended - none of the TitanBar memory problems.\nFixed error on single note deletion for instance maps.\nFixed error on Player ping for Sidelist. Missed updating it to changed ping routine.\nAdded two keybindings. Each will toggle the WorldMap with a specific saved mode.\nMetaMapWKB will now display newly discovered target message, regardless of Updates option.\nOptimised coords display routines. Should fix the 618 error a few were getting randomly.\nExtended the MetaMapWKB startup verification routine down to zone level.\nNOTE! If this is a first time upgrade from v4.xx to v11100.xx, read the v11100.1 notes!!\n\n|cFFBFBFFF05 August 2006 - v11100.4|r\nUpdated the deletion checking routine and Ping routine for a more global approach.\n...(This fixes all MetaMapWKB bounded note problems, and single/bounded note deletion).\nBounding box is no longer created when central icon is rejected due to near note.\nTracked down MetaMapFWM error to incorrectly placed localised functions.\n...(Only manifested itself when there was actual data in the Errata table).\nRemoved the Blizzard Instance check, and reverted back to my own routine.\n...(Fixes the Battlegrounds error, which was attempting to load an Instance map).\nNOTE! If this is a first time upgrade from v4.xx to v11100.xx, read the v11100.1 notes!!\n\n|cFFBFBFFF03 August 2006 - v11100.3|r\nUpdated level ranges for instance maps.\nFixed Battlegrounds attempting to load an instance map instead of the BG map.\nFixed MetaMapWKB error when selecting 'Show on Map' for a zone other than the current.\nFixed typo for variable which was preventing BLT from showing when clicking on a note.\nDelayed the MetaMapFWM table initialisation routine to fix the problem a few were having.\nAdded routine to correctly distinguish between single note and Bounded note deletion.\nNOTE! If this is a first time upgrade from v4.xx to v11100.xx, read the v11100.1 notes!!\n\n|cFFBFBFFF01 August 2006 - v11100.2|r\nFixed MetaMap menu not hiding on mouseout when TitanBar icon was hidden.\nCorrected the timing on a couple of initialisation routines.\n...(Should correct the problem a few were having with scaling and FWM startup).\nNEW Text colour can now be set for Minimap coords display.\n...(CTRL+Click on coords to cycle through colours).\n\n|cFFBFBFFF31 July 2006 - v11100.1|r\nVersion numbering changed to include TOC prefix.\nMetaMapPOI will now correctly set a guard note without the need to open the WorldMap.\nNEW option for MetaMapBWP to auto set a Waypoint on Guard directions.\nMetaKB now displays related data when Continents or World are displayed on the map.\nRemoved fixed name tables for ZoneLevels and changed routines to use zone indexes.\n...(That solves any localisation problems, as it now gets the info from the server).\nStandardised module loading routines and improved the event handling for some modules.\n...(Hopefully the changes for FWM might solve the startup problem a few were having).\nNEW MetaKB is now a Load-on-Demand module named MetaMapWKB.\n...(IMPORTANT! If you have saved MetaKB data, ensure you carry out the following).\n1. BACKUP your data from Extended Options BEFORE installing this version.\n2. Install this version, log in to WoW, and load the MetaKB module in Extended Options.\n3. Use the RESTORE option to reload all your saved data.\n4. Reload the User Interface from the Import section to save the data and clear memory.\n...(MetaMapWKB will now load any time you select a related option for it).\n...(Alternatively, set the 'Always Load' option to always have it load on startup).\n\n|cFFBFBFFF26 July 2006 - v4.81|r\nFixed imports not importing all notes from MapMod. Due to a 'break' error.\nNon-boundingbox lines are now also hidden when connected note is filtered.\nBWP menu now correctly hidden on startup, and will no longer cover Player frame.\nChanged the German instance name for Stockades again to correctly select 'Das Verlies'.\nCompleted the MetaMapZSM module. Will now also ZoneShift Lines and MetaKB data.\nExtended startup data verification to verify Lines and MetaKB data as well.\nChanged the notes highlighting routine to use a single highlighter.\n...(This allowed the removal of 20 icons, which previously provided the highlighting).\n...(Recommend removing the previous installation before installing this).\n...(This will ensure any redundant files will not be loaded into memory).\nAdded routines to handle the new Class Set data format in AtlasLoot.\nUpdated the default instance data to match latest AtlasLoot data format.\nUpdated the default MetaMapBLT data to match the latest AtlasLoot data.\n...(Import BOTH default instance data and default BLT data to apply the changes).\n\n|cFFBFBFFF24 July 2006 - v4.80|r\nFixed Help Tooltip not hiding in Extended Options. Missed it out on last version's rework.\nDeleting a note with bounding box now removes the whole set, including lines.\nChanged icons for outer bounding box. Function as normal icons but, cannot be edited.\nAdded routines to hide the bounding box icons and lines when main note is filtered.\nDue to these changes, the SideList now shows only the main bounding box note.\n\n|cFFBFBFFF22 July 2006 - v4.79|r\nFixed ancient problem of non functioning notes when placed on a WorldMapPOI.\nRemoved MetaMapPOI delete routine from General tab in Extended Options.\n...(Batch delete option on MetaNotes tab does a better job, without zone restrictions).\nMinimap coords should now update correctly in Battlegrounds.\nMetaMapBWP no longer attempts to set a corpse Waypoint in Battlegrounds.\nRemoved the filter icons from Extended Options and moved creator option from MetaMap menu.\nChanged 'Show Notes' option on MetaMap menu to 'Notes Filter'.\nClicking on 'Notes Filter' shows a Filter Submenu, with options to filter map notes.\n\n|cFFBFBFFF20 July 2006 - v4.78|r\nTidied various bits of display stuff.\nAdded data verification routine for notes on startup.\nRightClick on InfoLine button now toggles the SideList.\nInstance backdrop now covers entire map when Sidelist is hidden.\nUser file export option now remains active for multiple export opportunities.\nRenamed User file for import to 'MetaMapEXP.lua'. Related folder now shown as MetaMapEXP.\n...(Note, as always, ANY file for import MUST be placed in the MetaMapCVT folder).\nIncluded Niflheim's new HQ maps for Stratholme & UBRS, and updated the note locations.\n...(Import updated Instance file from Extended Options to apply the changes).\n\n|cFFBFBFFF18 July 2006 - v4.77|r\nRemoved all dependancy on MapLibrary for MetaMapBWP.\n...(Yards/Metres is now handled by a simple conversion routine).\nAdded additional checks for initialisation completion.\nAdded check for data corruption for near notes routine.\nReplaced old note deletion routine for MetaKB with updated one which got missed out.\nUpdated French/English zone conversion matrix.\n...(World bosses now export to correct locations for French clients).\nAdded saved instance display to InfoLine button with ID and time remaining.\nExtended the InfoLine button to all other maps.\n...(Currently shows colour coded faction and range levels).\n\n|cFFBFBFFF16 July 2006 - v4.76|r\nCompleted Storylines for remaining instances.\nAdded Undercity, Orgrimmar, and Thunder Bluff to MapLibrary scaling.\n...(BWP Distance will now correctly update in those cities).\nFixed error when attempting to move the map when set to Fullscreen mode.\nIncreased Tooltip scaling range.\nTooltip scaling now checks for NotesUNeed and adjusts the scale accordingly.\n...(Previously NotesUNeed forced the MetaMap setting back to its own setting).\nFixed unlocalised 'button' variable interfering with another addon's Minimap button.\nMain map coords will now show 'Instance' or 'Dead Zone' instead of boring 0,0 coords.\n\n|cFFBFBFFF14 July 2006 - v4.75|r\nFixed MetaMapBWP distance display not updating correctly.\nChanged Instance import routine to direct inject into the database.\n...(Hopefully will resolve the German import issue for World bosses).\nFixed BWP_MenuFrame overlapping the Playerframe after a menu show.\n...(Original code didn't hide the menu frame. Correctly hides now after a menu show).\nNEW Backdrop Shade Slider added for Instance maps. Slider available on MetaMap menu.\n...(Will only be displayed on the menu when an Instance map is selected).\n...(Will save different setting for each SaveSet as well).\nNEW Shade colour option available on the MetaMap menu.\n...(Toggles the Instance backdrop between black, red, green, and blue).\n\n|cFFBFBFFF13 July 2006 - v4.74|r\nQuick fix for MetaMapBWP. Removed obsolete call and replaced with later MetaMap function.\n\n|cFFBFBFFF13 July 2006 - v4.73|r\nFixed startup error caused by QuestHistory. No, honest, really fixed this time. :p\nCorrected German Zoneshift matrix for imports. Adjusted routines in Zoneshift module.\n...(Import default Instance data to correct the German World Boss locations).\nRightClick on a KB display item will now handle ranged coords correctly.\n...(Original BWP code incorrectly parsed those as not being in current zone).\nMetaMapBWP menu now checks for Waypoint screen location and positions accordingly.\nSetting a Waypoint will now be retained, even when moving into another zone.\n...(Will display again when moving back into the zone where it was set).\nA Waypoint can now be preset for any note on the map.\n...(Will display when you move into the zone it was set for).\nBWP option added to always set a Waypoint to your corpse when loaded.\nBWP display frame will now remember screen position between sessions when 'Always Load' is used.\nRemoved Instance information lines from the Instance maps.\nNEW InfoLine button added to Instance maps. Mouseover shows Tooltip with Instance information.\n...(Clicking on InfoLine button brings up storyline for that Instance).\n...(May look at expanding that to World maps as well at some stage).\n\n|cFFBFBFFF10 July 2006 - v4.72|r\nHopefully tracked down and fixed startup error a few were getting.\n...(Caused by another addon somewhere, opening the map before all vars were initialised).\nNEW MetaMapBWP module out of Beta, and now included as standard.\n...(Recommend deleting the old MetaMapBWP folder first, to get rid of any obsolete files).\nUpdated remainder of MetaMapBWP variables to unique names.\nFixed occasional BWP nil library error on first run when 'Always On' was active.\nRemoved the old WoWKB import routines, as well as the old KB data conversion routine.\n...(The WoWKB conversion utility will do both old data types if anyone still needs it).\nReworked the Import/Export routines to give a nicer progression overall.\nNEW User notes export facilty will export map notes and lines to the Import.lua file.\n...(Choice to export KB, Notes & Lines, or both to the same Import.lua file).\n...(If both data sets are in the file, the importer will have the same choice on import).\nUpdated the MetaMapBLT localisation file with latest info.\nMetaMapBLT default data updated to match latest AtlasLoot data.\n...(Import Default BLT data to apply the changes).\nUpdated the Readme.\n\n|cFFBFBFFF04 July 2006 - v4.71|r\nUpdated KB and notes 'hook' routines to work correctly on RightClick.\nMenu now checks for Titan and Minimap screen locations.\n...(Will go upwards if Titan or Minimap are located at bottom of screen).\nUpdated some routines for better integration to MetaMapBWP.\nNEW MetaMapBWP load-on-demand module available as a Beta from Curse & Worldofwar.net.\n...(Noticed BetterWaypoints was no longer being updated and needed attention).\n...(Not sure if it will remain as such, as it all depends on the author returning to it).\nNEW option in Imports section, 'Export user KB file'.\n...(Creates an Import.lua in the SavedVariables folder, which any MetaMap user can import).\nMetaMapBLT default data updated to match latest AtlasLoot data.\n...(Import Default BLT data to apply the changes).\nUpdated the Readme.\n\n|cFFBFBFFF27 June 2006 - v4.70|r\nZoneShift check added when importing default World bosses and Battlegrounds.\n...(Notes should now appear in correct locations, assuming the ZoneShift info is correct).\nNEW MetaMapZSM load-on-demand ZoneShift module added for German and French clients.\n...(Tracker routines will keep track of which ZoneShift was last implemented).\nNEW MetaMapBKP load-on-demand Backup/Restore module added for easy backing up or restoring of data.\n...(Both new module options can be found on the Extended Options).\n\n|cFFBFBFFF23 June 2006 - v4.65|r\nReplaced the checking routine for Instance location that got missed when sorting the startup routines.\n...(Will again auto select the Instance you're currently in).\nCompleted the KB routine for level checks when targeting.\n...(Got missed off ages ago and no-one noticed. Thanks to Noja for spotting that at last).\nRemoved the routine to add the instance text to the dropdown display on startup.\n...(Still can't figure out why some were getting the nil error so, make do with a blank display on startup :p).\nNEW ZoneShift section added to Extended Options for German and French clients.\n...(MetaMapZSM load-on-demand module currently available as a Beta from http://ui.worldofwar.net).\n\n|cFFBFBFFF22 June 2006 - v4.64|r\nUpdated all text element names in XML to the new 'font' names, as they were not as\nbackwardly compatible as Blizzard might have thought.\nFixed nil error when targeting same critter twice in succession.\n...(Something strange with caching that seems to have crept in with the latest patch).\nMade some changes to a few routines which should eliminate any nil returns on startup.\nMerged MapMod import routine into MetaMapCVT. MapNotes import now gives MapNotes or MapMod option.\nNEW ItemSync compatibility. Will automatically use ItemSync if it is installed.\nUpdated MetaMapBLT German and French localisations.\nMetaMapBLT default data updated to match latest AtlasLoot data.\n...(Import Default BLT data to apply the changes).\n\n|cFFBFBFFF20 June 2006 - v4.63|r\nKeybinding for MetaKB display correctly toggles WorldMap now when embedded.\nFixed incorrect Tooltips showing when sorting the Sidelist.\nReworked deletion routines to now retain order of entry.\nNEW Batch delete option for MetaNotes in Extended Options.\n...(Allows note deletion by selected creator at Zone, Continent, and World levels).\nNEW LootLink compatibility. Will automatically use LootLink if it is installed.\nBLT import now gives option to import Default data or AtlasLoot data when selected.\nAdded default Battleground locations and Loot IDs to the World maps.\n...(Import updated Instance file from Extended Options to apply the changes).\nUpdated MetaMapBLT with the latest database procedures from Daviesh.\nCreated a new localisations file to handle the new BLT database format.\n...(*NOTE!!* - You MUST import the updated BLT default data file to upgrade).\n\n|cFFBFBFFF15 June 2006 - v4.62|r\nCorrected note sending routine to look at current map, not zone, when sending.\nCTR+Click on any mapnote will now query MetaMapBLT, in the same way as the Sidelist does.\nAdded and updated LootIDs for Naxxramas. Updated MetaMapBLT default data.\n...(Import the default BLT data, or the latest AtlasLoot localisation).\nIncluded Niflheim's new HQ map for Scholomance and updated the note locations.\n...(Import updated Instance file from Extended Options to apply the changes).\n\n|cFFBFBFFF13 June 2006 - v4.61|r\nCorrected the German localisation name for The Sunken Temple.\nCorrected string parsing that returned nil error on some Critters when KB targeting.\nAdded check for nil value return on Type or Class that are missing on the odd few creatures.\nAdded class colour coding to KB captured targets. Is now reflected in KB display.\n...(Name column will now show class colour. The location column still shows proximity colour).\nAdded greater flexibility to the /qnote command. See updated parameters in Readme.\n..(Additionally added whitespace/period check as suggested by Gorramit. :p);\nChanged import routine for Instance data. Now adds/updates default data only.\n...(Previously reset ALL instance data - will now keep any additional user added notes intact).\nAdded a 'Function Hooks' reference section to the readme for authors of other addons.\nIncluded Niflheim's new HQ map of Shadowfang Keep and updated the note locations.\nUpdated Instance data Loot IDs to match latest AtlasLoot release.\nAdded default World Boss locations and Loot IDs to the World maps.\n...(Import updated Instance file from Extended Options to apply the changes).\n\n|cFFBFBFFF10 June 2006 - v4.60|r\nCorrected KB nil value error when auto adding notes on targeting.\nAdded additionals checks for 'dead' zones. Will now show correct zone instead of instance map.\nCorrected typo for The Stockade. Map should show now when visiting the instance.\nAdded Shift+Click to Map Sidelist for inserting details into open message box.\nUpdated LootIDs for Naxxramas bosses. Import default Instance data to activate.\nNEW import routine for MetaMapBLT data. Will import default data, or convert AtlasLoot data.\n...(To import AtlasLoot data, simply place the AtlasLoot localisation file(s) into the MetaMapCVT folder).\n...(Updated AtlasLoot data file takes priority over the MetaMapBLTdata.lua default data file).\nNEW option in MetaKB section in Extended Options, 'Embed into WorldMap', shows KB display in WorldMap.\n...(Has the added advantage of having the KB display set in relation to the map viewed).\n\n|cFFBFBFFF06 June 2006 - v4.50|r\nMiniNotes now include author name on mouseover.\n...(Is also subject to the author on/off toggle).\nSetting a map note now includes a check for a related MiniNote, and links it as related.\n...(Also works in reverse. Setting a solo MiniNote will check for related map note).\nSlight change to MetaKB display's visual appearance.\nAdded check for incorrect data entry when selecting 'Show All Zones' in KB display.\nMetaKB reporting now correctly disables all targeting messages when 'Show Updates' is disabled.\nMetaKB display will now show zone name when in an instance or unknown zone, instead of 0,0.\nNEW option on MetaKB popup menu, 'Show on WorldMap' will open the map to the selected item's location.\n...(will additionally ping the related note on the map if it is set as a note).\nNEW option in MetaKB section in Extended Options, 'Set map note on map query'.\n...(This will automatically set a note on the map when 'Show on WorldMap is selected).\n...(Note, that this will not be set for an Instance map, as there are no coords to work on).\nNEW Option to sort Map SideList. Header button on top of list will sort/unsort list.\nUpdated MetaMapBLT Loot Tables with the latest information.\n...(*NOTE!!* - You MUST import the updated Instance data file to see the new information).\n\n|cFFBFBFFF03 June 2006 - v4.40|r\nAdded further checking routines for presence of MetaMap modules.\nAll old MapNotes routines now fully converted to the optimised MetaMap routines.\n...(That gets rid of over 800 lines of code).\nRemoved redundant variables in the localisations and added a few new ones.\nRemoved the /qtloc command and merged it into /qnote. See updated parameters in Readme.\nRemoved all dependency on Sky for PartyNotes, and added new PartyNote routines.\n...(PartyNote can now be sent anytime to all Party/Raid members without Sky).\nClicking on a pre-set PartyNote will now bring up the Send/Delete options.\nParty note can now be created on instance maps as well.\nNote edit and Send displays shown normal size and no longer scaled to WorldMap.\nQuickNote display now detects when Escape and Enter keys are pressed.\n...(Just for you speed freaks. Escape closes window, Enter sets QuickNote).\nEscape now correctly closes Note edit box instead of toggling WorldMap.\n...(Something that was in the original MapNotes code for some reason).\nIncluded German and French localisations for MetaMapBLT.\nUpdated MetaMapBLT Loot Tables with the latest information.\n...(*NOTE!!* - You MUST import the updated Instance data file to see the new information).\n\n|cFFBFBFFF29 May 2006 - v4.31|r\nNEW Dressing room added for MetaMapBLT. CTRL+Click on loot item to show.\n...(Window is moveable while displayed so, can drag it wherever you like).\nFixed error when mousing over a Mini PartyNote. Old MapNotes bug.\n...(Added additional delete box when clicking on Mini PartyNote).\nFixed truncation of name when adding QuickNote from command line.\n...(This also fixed error message for nil value).\n...(And why are peeps still using that? Try the hotkey QuickNote. MUCH better. :p )\nUpdated Spanish localisation. With thanks to Fili.\nUpdated MetaMapBLT Loot Tables And Instance data.\n...(*NOTE!!* - You MUST import the updated Instance data file to see the new information).\n\n|cFFBFBFFF27 May 2006 - v4.30|r\nNEW Option on Extended Options menu to set coloured Sidelist entries.\nNEW option on Extended Options menu to show Zone information in WorldMap header.\nTooltips now show a 'BLT' indicator if a Loot Table is available for that item.\nRemoved all Zoneshift routines. Based on feedback, this should work correctly for German clients.\n...(Retained default non-shifting table for other addons which may access this).\nUpdated MetaMapBLT Loot Tables with the latest information.\n...(*NOTE!!* - You MUST import the updated Instance data file to see the new information).\n\n|cFFBFBFFF25 May 2006 - v4.20|r\nNEW MetaMapBLT is now fully functional. With thanks to Daviesh for providing the core code.\n...(*NOTE!!* - You MUST import the updated Instance data file to ensure Boss keys are loaded).\n\n|cFFBFBFFF25 May 2006 - v4.13|r\nFixed old MapNotes bug where a frame under the Minimap was preventing mouse action in that area.\n...(Removed frame and related Thott coords display. MetaMap has it's own movable coords display).\nTweaked some of the zoning routines to give added reliability.\nRemoved old MapNotes ToggleWorldMap hooks. Replaced by new checking routines.\nReinstated the MetaMap WorldMap toggle in keybindings.\n...(Any who have delay problems with one, can switch to the other).\nNEW MetaMapPOI will now set a note whenever you ask a Guard for directions.\nIncluded updated Naxxramas map by Niflheim.\n...(*NOTE!!* - Updated map requires install BEFORE running WoW).\nUpdated the Loot keys in the Instance data file in preparation for Boss Loot Tables.\nAdded default note information for the Naxxramas map.\n...(*NOTE!!* - You MUST import the updated Instance data file to see the new information).\n\n|cFFBFBFFF22 May 2006 - v4.12|r\nDue to popular demand, MetaMapPOI now places its note center of POI again.\n...(Bit close to last update but, I guess many would like that change asap).\nNew Map of upcoming Naxxrama instance added. With thanks to Niflheim.\n\n|cFFBFBFFF22 May 2006 - v4.11|r\nCorrected BG error. Was trying to Zoneshift before actually checking for BG.\nNEW HQ maps added. Created and provided by Niflheim.\nUpdated the Instance data for the new map layouts.\n...(*NOTE!!* - You MUST import the new Instance data file to position the notes correctly).\n\n|cFFBFBFFF21 May 2006 - v4.10|r\nUpdated a few routines with checks & vars that went missing from the v4.00 post-tests.\n...(This version should now be how v4.00 was originally intended to be released).\nAdded additional Zoneshift checks to see if that resolves problems on German clients.\nWorldMapPOI no longer disables notes created by MetaMapPOI. Notes will now function correctly.\nMetaMapPOI no longer spams 'Note too near' messages when attempting to recreate existing notes.\nRemoved the KB data stats routine as this was causing massive delays to the display.\n...(Stats are now generated on the fly, resulting in virtually no delay at all).\nDue to the data change, KB will now correctly place a note to the correct instance map.\n...(Sadly no coords in instances so, note is placed bottom right on the map, ready for moving).\nRemoved the keybinding to toggle MetaMap. Not required and seems it caused problems to some.\n...(Rebind the M key to the worldmap again for full functionality).\nBoss Loot hooks are now in if the author of AtlasLoot wants to take advantage of them. :)\nFurther update to the Spanish localisation. With thanks to Fili.\n\n|cFFBFBFFF17 May 2006 - v4.03|r\nFixed the elusive '469' error some were having.\n...(Was finally able to replicate this myself by logging in and out on alternate characters.\n...(Would seem that under certain conditions the Worldmap isn't quite initialised on startup).\nFixed NotesUNeed compatibility. The 'MetaMapNotes_NotesPerZone' var was removed as it was obsolete.\n...(No longer needed as there is now no limit on the number of notes per zone).\n...(Temporarily re-instated it as a dummy variable with an arbitrarily high figure).\nFixed escape key by changing call to frame to a call to UIPanel.\n...(Never noticed this as escape has never worked for me on anything anyway).\n...(And would not have been noticed by anyone who still had the 'M' key bound to the original call).\nSideList scrollbar scrolls correctly and now displays correct Tooltips when scrolled.\nAdded updated French localisation by Sparrows.\n\n|cFFBFBFFF16 May 2006 - v4.02|r\nFixed BWP error by inserting a link routine until the author takes advantage of the new function\nFixed BG errors. All functioning correctly there now.\nReally not sure what happened on v4.00 release but, going over the code it would appear\na previous file somehow crept back in with some incomplete routines. :(\n\n|cFFBFBFFF15 May 2006 - v4.01|r\nFixed Minimap button call to open map. Missed updating that to new function.\nFixed KB updating error. Somehow the correct function went walkies after testing.\nApologies all round on that one :(\n\n|cFFBFBFFF15 May 2006 - v4.00|r\nMajor changes to many routines to unify/optimise them, including a number of fixes\nto some older MapNotes/WoWKB routines.\nMore reliable zone handling implemented. Will now determine correct zone locations\nfor unknown areas. Has added benefit of handling new areas correctly as well.\nMajor change to the KB routines, which will now handle zones from the common MetaMap\nroutines, instead of the unreliable fixed list found in the localisation files.\n...(Makes the KB compatible with any localisation).\n...(Fixed lists have been moved to the import section for backward compatible imports).\n...(Note, that this has required a change in data structure!).\nDropdown list table for instances replaced by a proper sort routine.\n...(Has the advantage of correctly sorting, regardless of language).\nImport routines and data are now loaded 'On Demand'.\n...(A new folder 'MetaMapCVT' is now dedicated to this - see revised import notes).\n...(A big memory save as the routines and data are now only loaded when importing).\nChanges to the MapNotes import routines means you can now import user MetaMap notes\nin a similar manner to KB user notes. See revised import notes).\nNEW Function added for new note creation. Mainly of interest to other mod authors.\n...(Using 'MetaMapNotes_AddNewNote(<parameters>)' will directly add a note to the map and/or Minimap).\n...(Will return a true or false value).\nNEW Option on note edit box 'Move Note' allows relocating any mapnote with a click.\n...(Will automatically adjust any connected lines and related Mininote).\nNEW MetaMapPOI feature adds all Points of Interest to the map on first visit to a zone.\n...(Basically a remake of Magellan. Options for this are on the Extended Options Menu).\nNEW Dynamic note creation removes note and line limits and hard-coded objects.\n...(Notes and lines are only created as and when needed, up to an unlimited amount).\nAdjusted the scaling of the Instance map display to show the map in correct proportion.\n...(Maps are no longer stretched along the x axis, or partly covered by the SideList).\n...(NOTE: This has required an update to the Instance data file!).\n...(Import the new Instance data file in Extended Options Menu on first run).\nReplaced map for Ruins of Ahn'Qiraj with new HQ map created by Niflheim.\n...(Will give you some idea of how things will look when he releases his HQ pack).\nAdded Spanish localisation with thanks to Fili.\nUpdated this Readme.\n\n|cFFBFBFFF20 April 2006 - v3.40|r\nReworked Minimap coords routines to correctly update when in flight.\n...(Seems the last patch also made some changes to map updates when on a bird).\nNEW Import options added to Extended Menu Options.\n...(Auto import has been removed. No need to run any other addon to import).\n...(See the Import section in the Readme for filenames etc).\nAdded new folder 'Extras' to the MetaMap folder, currently containing MetaMapData.lua.\n...(MetaMapData.lua contains all the default instance notes).\n...(Copy MetaMapData.lua to main MetaMap folder anytime you need to import it).\nRemoved search update routines when capturing targets with 'Show Updates' turned on.\n...(Removes all the long delays when you have an extremely large database).\nChanged the 'ShowOnlyLocalNPC' function to 'Show All Zones'.\n...(KB display will now default to your local zone each time you open it).\n...(Removes the long search delays if you have a very large database).\n\n|cFFBFBFFF14 April 2006 - v3.30|r\nFixed memory rate increase for Minimap Coords display.\nShift+LeftClick on Minimap icon will now correctly insert details into open message box.\nRemoved the inclusion of coords within the Mininote name field when set as QuickNote.\nLeftClick on MiniNote without relating map note will now pop up a delete dialogue.\n...(MiniNote with relating map note will still pop up the notes edit box).\nChanged Minimap routine to correctly detect which city a Mininote is set for.\n...(Seems Orgrimmar and Ironforge now have the same Zone ID. Possibly a bug in recent patch).\nReplaced key selection for KB items with a popup QuickMenu, shown by LeftClick.\nVarious new options added to QuickMenu, including set as Mininote only option.\nThe 'Set as map note' will now only set the note on the main map.\n...(To set for both map and Minimap, click on both options).\nNEW option to selectively delete items from the KB database via the QuickMenu.\n...(Items are deleted according to criteria set in the search box).\nChanged some routines in MetaFWM to allow global access for other addons.\n...(Requested by Telic so, how could I refuse? :p).\n\n|cFFBFBFFF12 April 2006 - v3.20|r\nMinimap coords will now always show true location, regardless of WorldMap selection.\nShift+LeftClick on Minimap coords will now insert location into open message box.\nShift+LeftClick on any map note will now insert details into open message box.\nShift+RightClick on any sidelist entry will now insert details into open message box.\nQuickNote menu will now accept a change to coords in the edit box.\n...(The current position in the box can be changed to place the icon anywhere on the map).\n...(Has same effect as the /quicktloc slash command).\nFixed the occasional error message popping up when clicking on Minimap icon.\n...(Only happened when Mininote was set without relating map icon).\n...(Effect is that the notes edit box will not pop up if there is no relating map note).\nMoved the 'Show Only Local NPCs' checkbox to the main KB display from extended options.\n\n|cFFBFBFFF07 April 2006 - v3.10|r\nMinimap coords can now be user placed. Simply drag to position required.\nUpdated German zoneshift. See Readme for usage.\nNEW extended options menu added with tabbed window. Select from main menu.\nUnified extended options for Notes, KB, and FWM onto the Extended Options Menu.\nAdded option to have FWM persist between sessions.\nAdded option to toggle dynamic search for Knowledge Base.\nAdded colour options for the FWM unexplored layers.\nAdded search stats to Knowledge Base display.\nUpdated the changed instance information for Scholo, Strat, BRD & Spire instances.\n\n|cFFBFBFFF30 March 2006 - v3.01|r\nQuick update to fix FWM not displaying explored areas under certain conditions.\n\n|cFFBFBFFF29 March 2006 - v3.0|r\nCorrected display of 'BlackOutWorld' added by Blizzard in latest patch.\nToggling Fullscreen mode now retains currently viewed map.\nMetaMap menu no longer affected by alpha settings in Fullscreen mode.\nNEW KB data import facility.\n...(Imports data from a modified SavedVariables file).\n...(READ the import notes in the Readme for usage!).\nNEW MozzFullWorld has now been integrated into MetaMap as a Load on Demand.\n...(This means it will take up no memory unless called by selecting the option).\n...(Now referred to as MetaMapFWM - REMOVE MozzFullWorld to avoid clashes!!).\nFixed overlay errors in FWM and added code to reflect changes in WoW's map routines.\nRemoved FWM tickbox from map and added the option to MetaMap pop-up menu.\nRenamed 'round' function to something more unique to prevent future 'hi-jacking'.\nUpdated French localisation. With thanks to 'Sparrows' for the translation.\n\n|cFFBFBFFF02 March 2006 - v2.83|r\nFixed problem with instance map not selecting from dropdown.\n...(was setting incorrect value on newly added variable).\nRemoved the double entry of real zone in debug display.\nNEW LeftClick on Minimap Mininote will now open edit options dialogue.\n...(Had already started to add some MiniNote changes so this bit not fully tested).\n\n|cFFBFBFFF28 February 2006 - v2.82|r\nCorrected the names for Ahn'Qiraj maps. Both will now display correctly.\n...(Managed to get into both tonight and discovered names were not quite right).\n\n|cFFBFBFFF27 February 2006 - v2.81|r\nNEW Map 'Ruins of Ahn'Qiraj' added.\nSide notelist now shows related Tooltips on MouseOver.\nRightClick on side notelist will now toggle the edit box for that entry.\n...(LeftClick will still ping the location for that entry).\nMininote Tooltip now shows full note information.\n...(Just the start. I shall be optimising and enhancing Mininote stuff next).\n\n|cFFBFBFFF26 February 2006 - v2.8|r\nNEW Option on Quicknote menu to include a MiniNote.\nNEW Option on QuickNote menu to set as MiniNote only.\nNEW Keybinding added for true fullscreen toggle mode.\nNEW A sample Tooltip is now displayed when adjusting Tooltip scale.\nNEW Search edit box is now dynamic. Display updates as you type.\n\n|cFFBFBFFF03 February 2006 - v2.74|r\nBattlegrounds well and truly fixed. Map notes and listings for there working.\n...(Was hard work - damn Horde kept creeping up on me and killing me).\nKB database now remembers sort order for the session.\nAdded a debug mode. Toggle via  slash command ( /mmdebug ).\n...(Should be useful for checking zone names etc.).\n\n|cFFBFBFFF31 January 2006 - v2.73|r\nHopefully fixes the BG issues some were having. Need feedback on this. :)\nNEW - Option to set the scale of Tooltips.\n...(Different Tooltip scales can be saved for each Saveset).\n\n|cFFBFBFFF30 January 2006 - v2.72|r\nFixed error with coloured text when sending notes to other players.\n...(Seems the WoW message system is a bit flaky when sending coloured text).\nReworked the status print routines to minimalise output to the Chatframe.\n...(Turning off 'Show Updates' in the KB options results in virtually no output).\n\n|cFFBFBFFF28 January 2006 - v2.71|r\nFixed Zoneshift error in the Notes List for German clients.\n\n|cFFBFBFFF28 January 2006 - v2.7|r\nFixed error when capturing NPC/Mob with no tooltip information.\nNo longer shows cursor coordinates when cursor is off the map.\nNEW - Target range now user definable in the KB options.\nNEW - Notes created on the Instance maps can now be sent to other players.\n...(Means you can now show other players your position in the instance).\nAdded check for empty note fields in the KB database.\n..(Will add any missing info when you capture that target again).\nReworked range calculations to give more accurate range colour code display.\n...(Will display green in the KB display if within 3 map units, otherwise yellow).\nChanged map coords display colours to be more user friendly.\n\n|cFFBFBFFF17 January 2006 - v2.6|r\nNEW - Sorting of columns in KB database now implemented.\n...(Clicking the headers will change the sort order for the selected column).\nKB Search will now include all other columns when searching.\nAdjusted alpha of notes icons to always be slightly higher than map alpha.\n...(Makes them easier to see when alpha is way down).\nAdded target distance checking to maintain location accuracy.\n...(Only adds targets within a 5yd distance. Suggested by Lindia).\nNEW - Keybinding pops up menu for setting a Quicknote or Virtual note(mntloc).\nNEW - Manual import facility added for MapNotes, WoWKB, and MetaMap data.\n...(This can then over-ride the auto import facilty if required for any reason).\n...(See reference notes for usage).\nMetaMap now correctly resets to the current zone when map is closed.\n...(Will set Minimap coords to the correct location instead of 0,0 for one).\nFixed bug that would sometimes not load an instance map when auto selected.\n...(Only happened when the map was already set from a previous selection).\nAdded sort routine to Instance dropdown to cover future additions or changes.\nNEW - Map of Temple of Ahn'Qiraj added. (Courtesy of WoWGuru.com).\n\n|cFFBFBFFF11 January 2006 - v2.5|r\nNEW menu option 'Map Action Mode' places the map in a passive mode.\n...(All mouse actions pass directly through map for movement etc.).\nAdded Action mode to Savesets so setting will be saved for each Saveset).\nChanged coords display routine to return accurate results.\nChanged map ping routine to place it more accurately on the icon.\nNotes editor now displays full alpha, regardless of alpha settings.\n...(Was a bit hard to see the options when transparent).\nMain coords display on the map now also display full alpha.\nParts of the KB sorting are in place but not active as yet.\n...(Will be in next version. Thought it best to get these fixes out first).\n\n|cFFBFBFFF08 January 2006 - v2.4|r\nAdded Zoneshift data for German clients. Read Zoneshift info below for usage.\nTracked down occasional startup errors to missing init routine.\n...(Was introduced in init reformat back in v1.7)\nRemoved map position saved variables & routines.\n...(Sorry, but the last patch totally changed the scaling behaviours and the\nsaving of scaled positions is no longer possible. The Savesets will however\nstill switch between different Alpha and Scaled modes.\n\n|cFFBFBFFF07 January 2006 - v2.3|r\nNEW option to show a list on the side of all notes on the map.\nClicking on an item in the list will ping its location on the map.\nAdded additional entry to ping your own location on the map.\nChanged level display of high level mobs from '-1' to '??'.\nCleaned up a few unwanted bits from the rushed out Beta 4.\nCorrected the TOC interface entry from 1900 to the correct 10900.\n\n|cFFBFBFFF04 January 2006 - v2.2b4|r\nEmergency release to fix the scaling problems created by the patch changes.\nNew notes are now created in the correct location.\nThere is still a slight problem when switching between map modes but, that will\ntake a little longer to sort out. More important to get this out quick to fix\nthe notes placements.\n\n|cFFBFBFFF03 January 2006 - v2.2b3|r\nNotes send menu now displayed on top.\nFixed longstanding & infrequent Minimap error (old MapNotes bug).\nChanged format of KB from string parsing to a more solid and reliable format.\n...(Will auto update to new format on first run).\nFormat of KB display is now in columns with better colour coding.\nKB notes are now created with a more logical colour coding.\nNEW option 'Add to Database' toggles on/off the database capture.\nNEW option 'Add new target note' toggles on/off auto adding of map notes.\n...(Can be over-ridden by <CTRL>+<Keybinding> combination).\nTightened code and removed excess functions.\nUpdated TOC to 1900 interface.\n\n|cFFBFBFFF30 December 2005 - v2.2b2|r\nAdded keybinding to manually target units for KB creation.\n...(This method also allows Player targeting. Active with AutoTrack on or off).\nAdded highlighter to KB display for easier selection.\nAdded solid background to KB options menu.\nRemoved the Gatherer icon function which crept back in. :p\nUpdated the Readme file to include description of all features and options.\n\n|cFFBFBFFF29 December 2005 - v2.2b1|r\nNEW: Integrated WoWKB code into MetaMap.\nRemoved redundant code as well as adding option to turn off auto tracking.\nAutomatice conversion of saved WoWKB data into MetaMap.\n...(Requires WoWKB to be run once alongside MetaMap to import).\nAdded missing init routine to map mode keybinding toggle.\n\n|cFFBFBFFF27 December 2005 - v2.1|r\nAdditional compatibility checks added for CT_MapMod.\nNew menu option to toggle between MapMod and MetaMap for note creation.\n...(Note creation for instances is still handled by MetaMap).\nAdjusted Minimap routines to handle left and right clicks correctly.\nFixed the ThottBott/mntloc note conversions.\n\n|cFFBFBFFF26 December 2005 - v2.01|r\nSmall correction for German and French users only. No need for others to download.\n...(Missed applying a data format change to the German and French localisations).\n\n|cFFBFBFFF26 December 2005 - v2.0|r\nNEW: MapNotes now integrated into MetaMap.\n...(All MapNotes features also extended to Instance maps).\nFixed problem where a MiniNote set would cause main map to jump back to player location.\nFixed Mininote not showing when entering a zone where it was set.\nFixed occasional error in WorldMapFrame when updating the map for notes changes.\nReworked notes menus for faster and easier access.\nCTRL + Left click on the map now opens the new note dialogue directly.\nLeft click on a note now opens the edit note dialogue directly.\n...(More logical - doesn't change maps if slightly off target or forget to press alt).\nOptions for notes are now enabled/disabled in the correct context.\nAdded option to hide the author field in notes.\nAuto select option removed from MetaMap options.\n...(Will now always auto display correct instance map if you are in an instance) \nAdded option to set auto sizing of Tooltips.\nMozzFull re-instated to original location due to freeing up more space.\nDefault POI option changed to 'Show Notes' option. Will show/hide all notes.\nAdded display to show total notes and lines used per zone.\nAutomatic conversion of default Instance POIs to user editable notes.\n...(MetaMapData.lua can be removed after first run)\nAutomatic conversion of saved MapNotes data to MetaMap data.\n...(Requires MapNotes to be run once only alongside MetaMap)\n\n|cFFBFBFFF18 December 2005 - v1.81|r\nOops. Removed the Gatherer button option but missed removing the actual routine.\nThis meant that the Gatherer button would hide if you previously had it set off.\nJust a quick little fix for this. Was removed as the option for that is in Gatherer anyway.\n\n|cFFBFBFFF16 December 2005 - v1.8|r\nCompletely recoded the options section.\nOptions are now available from context pop-up menus.\nOptimised all other sections of code.\nI shall now be looking at starting version 2, adding user notes to all maps.\n\n|cFFBFBFFF08 December 2005 - v1.7|r\nDue to popular demand, a quick fix to keep the map on top of everything.\nNot a bad thing, as it does actually solve a few layering problems. :)\n\n|cFFBFBFFF07 December 2005 - v1.6|r\nChanged routines so features work correctly regardless how map is opened.\nWill now work fully with original map binding or icon.\nNEW: Map can now be moved around the screen with position saved between sessions.\nEach SaveSet will also store the respective position of the map.\nNEW: All keybindings are now useable, as well as messaging while map is open.\nThis includes ability to open other windows while map is open.\nAdded option to show/hide Gatherer Minimap icon.\n\n|cFFBFBFFF01 December 2005 - v1.5|r\nNEW: Map is now completely resizeable\nRemoved full screen feature as this is now redundant\nNEW: Option sets now allow you to select between 2 saved mode settings\nSaved modes for Map opacity & Map size (set from options panel)\nReplaced the map 'Zoom' button with Option set toggle\nNew keybinding for toggling between option set modes\nEscape key added for closing map. Even though the key binding works fine now.\nAdded new menu options to TitanBar menu\n\n|cFFBFBFFF30 November 2005 - v1.4|r\nMetaMap keybinding will now correctly toggle map on/off\nFixed lockout of CT_MasterMod button when running MetaMapOptions from CT control panel\nPlayer location arrow no longer shows in instance maps\nFixed incorrect filename in xml for French localisation\nGerman localisation added (with thanks to oneofamillion)\nChanged scaling routine to hopefully fix an issue on fullscreen for some - need feedback on this one\n\n|cFFBFBFFF29 November 2005 - v1.3|r\nFixed error return in CT_MapMod when in Auto Gather mode by adjusting event handling.\nTidied up a few other bits of code\n\n|cFFBFBFFF28 November 2005 - v1.2|r\nMozzFullWorldMap now fully supported\nFrench localisation added ( with thanks to Halrik for the translation)\n\n|cFFBFBFFF27 November 2005 - v1.1|r\nAdded checks for existance of Titan Bar\nAdded ReadMe to MetaMap folder\nMoved a few variables to the localisation\nVersion number is now shown on the Options header\n\n|cFFBFBFFF26 November 2005 - v1.0|r\nInitial Release",
			[2] = "",
		},
	},
}
