
MetaMap_Locale = "en";

MetaMap_Colors = {}
MetaMap_Colors[0] = {r = 1.0, g = 0.82, b = 0.0}
MetaMap_Colors[1] = {r = 0.55, g = 0.46, b = 0.04}
MetaMap_Colors[2] = {r = 1.0, g = 0.0, b = 0.0}
MetaMap_Colors[3] = {r = 0.56, g = 0.0, b = 0.0}
MetaMap_Colors[4] = {r = 0.0, g = 1.0, b = 0.0}
MetaMap_Colors[5] = {r = 0.0, g = 0.39, b = 0.05}
MetaMap_Colors[6] = {r = 0.42, g = 0.47, b = 0.87}
MetaMap_Colors[7] = {r = 0.25, g = 0.35, b = 0.66}
MetaMap_Colors[8] = {r = 1.0, g = 1.0, b = 1.0}
MetaMap_Colors[9] = {r = 0.65, g = 0.65, b = 0.65}

MetaMap_MapScale = {};
MetaMap_MapScale.cityscale    = {};
MetaMap_MapScale.cityscale[0] = 1.565;
MetaMap_MapScale.cityscale[1] = 1.687;
MetaMap_MapScale.cityscale[2] = 1.882;
MetaMap_MapScale.cityscale[3] = 2.210;
MetaMap_MapScale.cityscale[4] = 2.575;
MetaMap_MapScale.cityscale[5] = 2.651;
MetaMap_MapScale[1]    = {};
MetaMap_MapScale[1][0] = {xscale = 11016.6, yscale = 7399.9};
MetaMap_MapScale[1][1] = {xscale = 12897.3, yscale = 8638.1};
MetaMap_MapScale[1][2] = {xscale = 15478.8, yscale = 10368.0};
MetaMap_MapScale[1][3] = {xscale = 19321.8, yscale = 12992.7};
MetaMap_MapScale[1][4] = {xscale = 25650.4, yscale = 17253.2};
MetaMap_MapScale[1][5] = {xscale = 38787.7, yscale = 26032.1};
MetaMap_MapScale[2]    = {};
MetaMap_MapScale[2][0] = {xscale = 10448.3, yscale = 7072.7};
MetaMap_MapScale[2][1] = {xscale = 12160.5, yscale = 8197.8};
MetaMap_MapScale[2][2] = {xscale = 14703.1, yscale = 9825.0};
MetaMap_MapScale[2][3] = {xscale = 18568.7, yscale = 12472.2};
MetaMap_MapScale[2][4] = {xscale = 24390.3, yscale = 15628.5};
MetaMap_MapScale[2][5] = {xscale = 37012.2, yscale = 25130.6};
MetaMap_MapScale[3]    = {};
MetaMap_MapScale[3][0] = {xscale = 10448.3, yscale = 7072.7};
MetaMap_MapScale[3][1] = {xscale = 12160.5, yscale = 8197.8};
MetaMap_MapScale[3][2] = {xscale = 14703.1, yscale = 9825.0};
MetaMap_MapScale[3][3] = {xscale = 18568.7, yscale = 12472.2};
MetaMap_MapScale[3][4] = {xscale = 24390.3, yscale = 15628.5};
MetaMap_MapScale[3][5] = {xscale = 37012.2, yscale = 25130.6};

MetaMap_MapScale[METAMAP_WARSONGGULCH]  = {xscale = 12897.3, yscale = 8638.1};
MetaMap_MapScale[METAMAP_ALTERACVALLEY] = {xscale = 12897.3, yscale = 8638.1};
MetaMap_MapScale[METAMAP_ARATHIBASIN]   = {xscale = 12897.3, yscale = 8638.1};

--- ZoneName matrix for English/German/French/Spanish exports/imports/data
MetaMap_ZoneTable = {
	[1]  = {en = "Ashenvale", de = "Eschental", fr = "Orneval", es = "Ashenvale", llvl = 18, hlvl = 30, faction = "Contested", scale = 0.15670371525706, xoffset = 0.41757282062541, yoffset = 0.33126468682991},
	[2]  = {en = "Azshara", de = "Azshara", fr = "Azshara", es = "Azshara", llvl = 45, hlvl = 55, faction = "Contested", scale = 0.13779501505279, xoffset = 0.55282036918049, yoffset = 0.30400571307545},
	[3]  = {en = "Darkshore", de = "Dunkelk\195\188ste", fr = "Sombrivage", es = "Darkshore", llvl = 10, hlvl = 20, faction = "Alliance", scale = 0.17799008894522, xoffset = 0.38383175154516, yoffset = 0.18206216123156},
	[4]  = {en = "Darnassus", de = "Darnassus", fr = "Darnassus", es = "Darnassus", llvl = 0, hlvl = 0, faction = "Alliance", scale = 0.02876626176374, xoffset = 0.38392150175204, yoffset = 0.10441296545475},
	[5]  = {en = "Desolace", de = "Desolace", fr = "D\195\169solace", es = "Desolace", llvl = 30, hlvl = 40, faction = "Contested", scale = 0.12219839120669, xoffset = 0.34873187115693, yoffset = 0.50331046935371},
	[6]  = {en = "Durotar", de = "Durotar", fr = "Durotar", es = "Durotar", llvl = 1, hlvl = 10, faction = "Horde", scale = 0.14368294970080, xoffset = 0.51709782709100, yoffset = 0.44802818134926},
	[7]  = {en = "Dustwallow Marsh", de = "D\195\188stermarschen", fr = "Mar\195\169cage d'\195\130prefange", es = "Dustwallow Marsh", llvl = 35, hlvl = 45, faction = "Contested", scale = 0.14266384095509, xoffset = 0.49026338351379, yoffset = 0.60461876174686},
	[8]  = {en = "Felwood", de = "Teufelswald", fr = "Gangrebois", es = "Felwood", llvl = 48, hlvl = 55, faction = "Contested", scale = 0.15625084006464, xoffset = 0.41995800144849, yoffset = 0.23097545880609},
	[9]  = {en = "Feralas", de = "Feralas", fr = "F\195\169ralas", es = "Feralas", llvl = 40, hlvl = 50, faction = "Contested", scale = 0.18885970960818, xoffset = 0.31589651244686, yoffset = 0.61820581746798},
	[10] = {en = "Moonglade", de = "Mondlichtung", fr = "Reflet-de-Lune", es = "Moonglade", llvl = 1, hlvl = 60, faction = "Contested", scale = 0.06292695969921, xoffset = 0.50130287793373, yoffset = 0.17560823085517},
	[11] = {en = "Mulgore", de = "Mulgore", fr = "Mulgore", es = "Mulgore", llvl = 1, hlvl = 10, faction = "Horde", scale = 0.13960673216274, xoffset = 0.40811854919226, yoffset = 0.53286226907346},
	[12] = {en = "Orgrimmar", de = "Orgrimmar", fr = "Orgrimmar", es = "Orgrimmar", llvl = 0, hlvl = 0, faction = "Horde", scale = 0.03811449638057, xoffset = 0.56378554142668, yoffset = 0.42905218646258},
	[13] = {en = "Silithus", de = "Silithus", fr = "Silithus", es = "Silithus", llvl = 55, hlvl = 60, faction = "Contested", scale = 0.09468465888932, xoffset = 0.39731975488374, yoffset = 0.76460608512626},
	[14] = {en = "Stonetalon Mountains", de = "Steinkrallengebirge", fr = "Les Serres-Rocheuses", es = "Stonetalon Mountains", 15, 27, faction = "Contested", scale = 0.13272833611061, xoffset = 0.37556627748617, yoffset = 0.40285135292988},
	[15] = {en = "Tanaris", de = "Tanaris", fr = "Tanaris", es = "Tanaris", llvl = 40, hlvl = 50, faction = "Contested", scale = 0.18750104661175, xoffset = 0.46971301480866, yoffset = 0.76120931364891},
	[16] = {en = "Teldrassil", de = "Teldrassil", fr = "Teldrassil", es = "Teldrassil", llvl = 1, hlvl = 10, faction = "Alliance", scale = 0.13836131003639, xoffset = 0.36011098024729, yoffset = 0.03948322979210},
	[17] = {en = "The Barrens", de = "Brachland", fr = "Les Tarides", es = "The Barrens", llvl = 10, hlvl = 25, faction = "Horde", scale = 0.27539211944292, xoffset = 0.39249347333450, yoffset = 0.45601063260257},
	[18] = {en = "Thousand Needles", de = "Tausend Nadeln", fr = "Mille pointes", es = "Thousand Needles", llvl = 25, hlvl = 35, faction = "Contested", scale = 0.11956582877920, xoffset = 0.47554411191734, yoffset = 0.68342356389650},
	[19] = {en = "Thunder Bluff", de = "Donnerfels (Thunder Bluff)", fr = "Les Pitons du Tonnerre (Thunder Bluff)", es = "Thunder Bluff", llvl = 0, hlvl = 0, faction = "Horde", scale = 0.02836291430658, xoffset = 0.44972878210917, yoffset = 0.55638479002362},
	[20] = {en = "Un'Goro Crater", de = "Un'Goro-Krater", fr = "Crat\195\168re d'Un'Goro", es = "Un'Goro Crater", llvl = 48, hlvl = 55, faction = "Contested", scale = 0.10054401185671, xoffset = 0.44927594451520, yoffset = 0.76494573629405},
	[21] = {en = "Winterspring", de = "Winterquell", fr = "Berceau-de-l'Hiver", es = "Winterspring", llvl = 55, hlvl = 60, faction = "Contested", scale = 0.19293573573141, xoffset = 0.47237382938446, yoffset = 0.17390990272233},
	[22] = {en = "Alterac Mountains", de = "Alteracgebirge", fr = "Montagnes d'Alterac", es = "Alterac Mountains", llvl = 30, hlvl = 40, faction = "Contested", scale = 0.07954563533736, xoffset = 0.43229874660542, yoffset = 0.25425926375262},
	[23] = {en = "Arathi Highlands", de = "Arathihochland", fr = "Hautes-terres d'Arathi", es = "Arathi Highlands", llvl = 30, hlvl = 40, faction = "Contested", scale = 0.10227310921644, xoffset = 0.47916793249546, yoffset = 0.32386170078419},
	[24] = {en = "Badlands", de = "\195\150dland", fr = "Terres ingrates", es = "Badlands", llvl = 35, hlvl = 45, faction = "Contested", scale = 0.07066771883566, xoffset = 0.51361415033147, yoffset = 0.56915717993261},
	[25] = {en = "Blasted Lands", de = "Verw\195\188stete Lande", fr = "Terres foudroy\195\169es", es = "Badlands", llvl = 45, hlvl = 55, faction = "Contested", scale = 0.09517074521836, xoffset = 0.48982154167011, yoffset = 0.76846519986510},
	[26] = {en = "Burning Steppes", de = "Brennende Steppe", fr = "Steppes ardentes", es = "Burning Steppes", llvl = 50, hlvl = 58, faction = "Contested", scale = 0.08321525646393, xoffset = 0.04621224670174, yoffset = 0.61780780524905},
	[27] = {en = "Deadwind Pass", de = "Gebirgspass der Totenwinde", fr = "D\195\169fil\195\169 de Deuillevent", es = "Deadwind Pass", llvl = 55, hlvl = 60, faction = "Contested", scale = 0.07102298961531, xoffset = 0.47822105868635, yoffset = 0.73863555048516},
	[28] = {en = "Dun Morogh", de = "Dun Morogh", fr = "Dun Morogh", es = "Dun Morogh", llvl = 1, hlvl = 10, faction = "Alliance", scale = 0.13991525534426, xoffset = 0.40335096278072, yoffset = 0.48339696712179},
	[29] = {en = "Duskwood", de = "D\195\164mmerwald", fr = "Bois de la P\195\169nombre", es = "Duskwood", llvl = 18, hlvl = 30, faction = "Contested", scale = 0.07670475476181, xoffset = 0.43087243362495, yoffset = 0.73224350550454},
	[30] = {en = "Eastern Plaguelands", de = "\195\150stliche Pestl\195\164nder", fr = "Maleterres de l'est", es = "Eastern Plaguelands", llvl = 53, hlvl = 60, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[31] = {en = "Elwynn Forest", de = "Wald von Elwynn", fr = "For\195\170t d'Elwynn", es = "Elwynn Forest", llvl = 1, hlvl = 10, faction = "Alliance", scale = 0.09860350595046, xoffset = 0.41092682316676, yoffset = 0.65651531970162},
	[32] = {en = "Hillsbrad Foothills", de = "Vorgebirge des H\195\188gellands", fr = "Contreforts de Hautebrande", es = "Hillsbrad Foothills", llvl = 20, hlvl = 30, faction = "Contested", scale = 0.09090931690055, xoffset = 0.42424361247460, yoffset = 0.30113436864162},
	[33] = {en = "Ironforge", de = "Eisenschmiede (Ironforge)", fr = "Forgefer (Ironforge)", es = "Ironforge", llvl = 0, hlvl = 0, faction = "Alliance", scale = 0.02248317426784, xoffset = 0.47481923366335, yoffset = 0.51289242617182},
	[34] = {en = "Loch Modan", de = "Loch Modan", fr = "Loch Modan", es = "Loch Modan", llvl = 10, hlvl = 20, faction = "Alliance", scale = 0.07839152145224, xoffset = 0.51118749188138, yoffset = 0.50940913489577},
	[35] = {en = "Redridge Mountains", de = "Rotkammgebirge", fr = "Les Carmines", es = "Redridge Mountains", llvl = 15, hlvl = 25, faction = "Contested", scale = 0.06170112311456, xoffset = 0.49917278340928, yoffset = 0.68359285304999},
	[36] = {en = "Searing Gorge", de = "Sengende Schlucht", fr = "Gorge des Vents br\195\187lants", es = "Searing Gorge", llvl = 43, hlvl = 50, faction = "Contested", scale = 0.06338794005823, xoffset = 0.46372051266487, yoffset = 0.57812379382509},
	[37] = {en = "Silverpine Forest", de = "Silberwald", fr = "For\195\170t des Pins argent\195\169s", es = "Silverpine Forest", llvl = 10, hlvl = 20, faction = "Horde", scale = 0.11931848806212, xoffset = 0.35653502290090, yoffset = 0.24715695496522},
	[38] = {en = "Stormwind City", de = "Sturmwind (Stormwind)", fr = "Hurlevent (Stormwind)", es = "Stormwind City", llvl = 0, hlvl = 0, faction = "Alliance", scale = 0.03819701270887, xoffset = 0.41531450060561, yoffset = 0.67097280492581},
	[39] = {en = "Stranglethorn Vale", de = "Schlingendorntal", fr = "Vall\195\169e de Strangleronce", es = "Stranglethorn Vale", llvl = 30, hlvl = 45, faction = "Contested", scale = 0.18128603034401, xoffset = 0.39145470225916, yoffset = 0.79412224886668},
	[40] = {en = "Swamp of Sorrows", de = "S\195\188mpfe des Elends", fr = "Marais des Chagrins", es = "Swamp of Sorrows", llvl = 35, hlvl = 45, faction = "Contested", scale = 0.06516347991404, xoffset = 0.51769795272070, yoffset = 0.72815974701615},
	[41] = {en = "The Hinterlands", de = "Hinterland", fr = "Les Hinterlands", es = "The Hinterlands", llvl = 40, hlvl = 50, faction = "Contested", scale = 0.10937523495111, xoffset = 0.49929119700867, yoffset = 0.25567971676068},
	[42] = {en = "Tirisfal Glades", de = "Tirisfal", fr = "Clairi\195\168res de Tirisfal", es = "Tirisfal Glades", llvl = 1, hlvl = 10, faction = "Horde", scale = 0.12837403412087, xoffset = 0.36837217317549, yoffset = 0.15464954319582},
	[43] = {en = "Undercity", de = "Unterstadt (Undercity)", fr = "Fossoyeuse (Undercity)", es = "Undercity", llvl = 0, hlvl = 0, faction = "Horde", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[44] = {en = "Western Plaguelands", de = "Westliche Pestl\195\164nder", fr = "Maleterres de l'ouest", es = "Western Plaguelands", llvl = 51, hlvl = 58, faction = "Contested", scale = 0.12215946583965, xoffset = 0.44270955019641, yoffset = 0.17471356786018},
	[45] = {en = "Westfall", de = "Westfall", fr = "Marche de l'Ouest", es = "Westfall", llvl = 10, hlvl = 20, faction = "Alliance", scale = 0.09943208435841, xoffset = 0.36884571674582, yoffset = 0.71874918595783},
	[46] = {en = "Wetlands", de = "Sumpfland", fr = "Les Paluns", es = "Wetlands", llvl = 20, hlvl = 30, faction = "Contested", scale = 0.11745423014662, xoffset = 0.46561438951659, yoffset = 0.40971063365152},
	[47] = {en = "Eversong Woods", de = "Immersangwald", fr = "Bois des Chants \195\169ternels", es = "Eversong Woods", llvl = 1, hlvl = 10, faction = "Horde", scale = 0.09517074521836, xoffset = 0.48982154167011, yoffset = 0.76846519986510},
	[48] = {en = "Ghostlands", de = "Geisterlande", fr = "Les Terres fant\195\180mes", es = "Ghostlands", llvl = 10, hlvl = 20, faction = "Horde", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[49] = {en = "Silvermoon City", de = "Silbermond", fr = "Lune-d'argent", es = "Silvermoon City", llvl = 0, hlvl = 0, faction = "Horde", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[50] = {en = "Azuremyst Isle", de = "Azurmythosinsel", fr = "Ile de Brume-azur", es = "Azuremyst Isle", llvl = 1, hlvl = 10, faction = "Alliance", scale = 0.09860350595046, xoffset = 0.41092682316676, yoffset = 0.65651531970162},
	[51] = {en = "Bloodmyst Isle", de = "Blutmythosinsel", fr = "Ile de Brume-sang", es = "Bloodmyst Isle", llvl = 10, hlvl = 20, faction = "Alliance", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[52] = {en = "The Exodar", de = "Die Exodar", fr = "L'Exodar", es = "The Exodar", llvl = 0, hlvl = 0, faction = "Alliance", scale = 0.02727719546939, xoffset = 0.42973999245660, yoffset = 0.23815358517831},
	[53] = {en = "Blade's Edge Mountains", de = "Schergrat", fr = "Les Tranchantes", es = "Blade's Edge Mountains", llvl = 65, hlvl = 68, faction = "Unknown", scale = 0.09517074521836, xoffset = 0.48982154167011, yoffset = 0.76846519986510},
	[54] = {en = "Hellfire Peninsula", de = "H\195\182llenfeuerhalbinsel", fr = "P\195\169ninsule des Flammes infernales", es = "Hellfire Peninsula", llvl = 58, hlvl = 63, faction = "Contested", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[55] = {en = "Nagrand", de = "Nagrand", fr = "Nagrand", es = "Nagrand", llvl = 64, hlvl = 67, faction = "Unknown", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[56] = {en = "Netherstorm", de = "Nethersturm", fr = "Raz-de-N\195\169ant", es = "Netherstorm", llvl = 67, hlvl = 70, faction = "Unknown", scale = 0.09468465888932, xoffset = 0.39731975488374, yoffset = 0.76460608512626},
	[57] = {en = "Shadowmoon Valley", de = "Schattenmondtal", fr = "Vall\195\169e d'Ombrelune", es = "Shadowmoon Valley", llvl = 67, hlvl = 70, faction = "Alliance", scale = 0.13779501505279, xoffset = 0.55282036918049, yoffset = 0.30400571307545},
	[58] = {en = "Shattrath City", de = "Shattrath", fr = "Shattrath", es = "Shattrath City", llvl = 0, hlvl = 0, faction = "Alliance", scale = 0.02836291430658, xoffset = 0.44972878210917, yoffset = 0.55638479002362},
	[59] = {en = "Terokkar Forest", de = "W\195\164lder von Terokkar", fr = "For\195\170t de Terokkar", es = "Terokkar Forest", llvl = 62, hlvl = 65, faction = "Unknown", scale = 0.10996723642661, xoffset = 0.51663255550387, yoffset = 0.15624753972085},
	[60] = {en = "Zangarmarsh", de = "Zangarmarschen", fr = "Mar\195\169cage de Zangar", es = "Zangarmarsh", llvl = 60, hlvl = 64, faction = "Unknown", scale = 0.15670371525706, xoffset = 0.41757282062541, yoffset = 0.33126468682991},
	[61] = {en = "Warsong Gulch", de = "Warsongschlucht", fr = "Goulet des Warsong", es = "Garganta Grito de Guerra", llvl = 60, hlvl = 64, faction = "Unknown", scale = 0.035, xoffset = 0.41757282062541, yoffset = 0.33126468682991},
	[62] = {en = "Alterac Valley", de = "Alteractal", fr = "Vall\195\169e d\226\128\153Alterac", es = "Valle de Alterac", llvl = 60, hlvl = 64, faction = "Unknown", scale = 0.13, xoffset = 0.41757282062541, yoffset = 0.33126468682991},
	[63] = {en = "Arathi Basin", de = "Arathibecken", fr = "Bassin d\226\128\153Arathi", es = "Cuenca de Arathi", llvl = 60, hlvl = 64, faction = "Unknown", scale = 0.045, xoffset = 0.41757282062541, yoffset = 0.33126468682991},
}

if(MetaMap_ZoneTable[1][strsub(GetLocale(), 1, 2)]) then
	MetaMap_Locale = strsub(GetLocale(), 1, 2);
end

MetaMap_BattleGrounds = {METAMAP_WARSONGGULCH, METAMAP_ARATHIBASIN, METAMAP_ALTERACVALLEY}

MetaMap_Instances = {
	[METAMAP_BFD_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[1][MetaMap_Locale],  LevelRange = "24-32", PlayerLimit = "10", infoline = METAMAP_BFD_INFO, texture = "BlackfathomDeeps"},
	[METAMAP_DMC_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[9][MetaMap_Locale],  LevelRange = "56-60", PlayerLimit = "5",  infoline = METAMAP_DMC_INFO, texture = "DireMaul"},
	[METAMAP_DME_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[9][MetaMap_Locale],  LevelRange = "56-60", PlayerLimit = "5",  infoline = METAMAP_DME_INFO, texture = "DireMaulEast"},
	[METAMAP_DMN_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[9][MetaMap_Locale],  LevelRange = "56-60", PlayerLimit = "5",  infoline = METAMAP_DMN_INFO, texture = "DireMaulNorth"},
	[METAMAP_DMW_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[9][MetaMap_Locale],  LevelRange = "56-60", PlayerLimit = "5",  infoline = METAMAP_DMW_INFO, texture = "DireMaulWest"},
	[METAMAP_MDN_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[5][MetaMap_Locale],  LevelRange = "46-55", PlayerLimit = "10", infoline = METAMAP_MDN_INFO, texture = "Maraudon"},
	[METAMAP_ONL_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[7][MetaMap_Locale],  LevelRange = "60+",   PlayerLimit = "40", infoline = METAMAP_ONL_INFO, texture = "OnyxiasLair"},
	[METAMAP_RFC_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[12][MetaMap_Locale], LevelRange = "13-15", PlayerLimit = "10", infoline = METAMAP_RFC_INFO, texture = "RagefireChasm"},
	[METAMAP_RFD_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[17][MetaMap_Locale], LevelRange = "33-40", PlayerLimit = "10", infoline = METAMAP_RFD_INFO, texture = "RazorfenDowns"},
	[METAMAP_RFK_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[17][MetaMap_Locale], LevelRange = "25-30", PlayerLimit = "10", infoline = METAMAP_RFK_INFO, texture = "RazorfenKraul"},
	[METAMAP_TWC_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[17][MetaMap_Locale], LevelRange = "17-24", PlayerLimit = "10", infoline = METAMAP_TWC_INFO, texture = "WailingCaverns"},
	[METAMAP_ZFK_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[15][MetaMap_Locale], LevelRange = "43-47", PlayerLimit = "10", infoline = METAMAP_ZFK_INFO, texture = "ZulFarrak"},
	[METAMAP_TAQ_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[13][MetaMap_Locale], LevelRange = "60+",   PlayerLimit = "40", infoline = METAMAP_TAQ_INFO, texture = "TempleofAhnQiraj"},
	[METAMAP_RAQ_NAME] = {Continent = 1, Location = MetaMap_ZoneTable[13][MetaMap_Locale], LevelRange = "60+",   PlayerLimit = "20", infoline = METAMAP_RAQ_INFO, texture = "RuinsofAhnQiraj"},
	[METAMAP_BRD_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[36][MetaMap_Locale], LevelRange = "52+",   PlayerLimit = "5",  infoline = METAMAP_BRD_INFO, texture = "BlackrockDepths"},
	[METAMAP_BRS_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[36][MetaMap_Locale], LevelRange = "55+",   PlayerLimit = "10", infoline = METAMAP_BRS_INFO, texture = "BlackrockSpireLower"},
	[METAMAP_BSU_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[36][MetaMap_Locale], LevelRange = "58+",   PlayerLimit = "10", infoline = METAMAP_BSU_INFO, texture = "BlackrockSpireUpper"},
	[METAMAP_BWL_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[36][MetaMap_Locale], LevelRange = "60+",   PlayerLimit = "40", infoline = METAMAP_BWL_INFO, texture = "BlackwingLair"},
	[METAMAP_GNM_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[28][MetaMap_Locale], LevelRange = "29-38", PlayerLimit = "10", infoline = METAMAP_GNM_INFO, texture = "Gnomeregan"},
	[METAMAP_TMC_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[36][MetaMap_Locale], LevelRange = "60+",   PlayerLimit = "40", infoline = METAMAP_TMC_INFO, texture = "MoltenCore"},
	[METAMAP_TSM_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[42][MetaMap_Locale], LevelRange = "34-45", PlayerLimit = "10", infoline = METAMAP_TSM_INFO, texture = "ScarletMonastery"},
	[METAMAP_SLM_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[44][MetaMap_Locale], LevelRange = "56-60", PlayerLimit = "5",  infoline = METAMAP_SLM_INFO, texture = "Scholomance"},
	[METAMAP_SFK_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[37][MetaMap_Locale], LevelRange = "22-30", PlayerLimit = "10", infoline = METAMAP_SFK_INFO, texture = "ShadowfangKeep"},
	[METAMAP_STR_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[30][MetaMap_Locale], LevelRange = "55-60", PlayerLimit = "5",  infoline = METAMAP_STR_INFO, texture = "Stratholme"},
	[METAMAP_TDM_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[45][MetaMap_Locale], LevelRange = "17-26", PlayerLimit = "10", infoline = METAMAP_TDM_INFO, texture = "TheDeadmines"},
	[METAMAP_TSK_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[38][MetaMap_Locale], LevelRange = "23-26", PlayerLimit = "10", infoline = METAMAP_TSK_INFO, texture = "TheStockades"},
	[METAMAP_TST_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[40][MetaMap_Locale], LevelRange = "45-55", PlayerLimit = "10", infoline = METAMAP_TST_INFO, texture = "TheSunkenTemple"},
	[METAMAP_ULD_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[24][MetaMap_Locale], LevelRange = "35-47", PlayerLimit = "10", infoline = METAMAP_ULD_INFO, texture = "Uldaman"},
	[METAMAP_ZGB_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[39][MetaMap_Locale], LevelRange = "60+",   PlayerLimit = "20", infoline = METAMAP_ZGB_INFO, texture = "ZulGurub"},
	[METAMAP_NAX_NAME] = {Continent = 2, Location = MetaMap_ZoneTable[30][MetaMap_Locale], LevelRange = "60+",   PlayerLimit = "40", infoline = METAMAP_NAX_INFO, texture = "Naxxramas"},
	[METAMAP_TBF_NAME] = {Continent = 3, Location = MetaMap_ZoneTable[54][MetaMap_Locale], LevelRange = "60-65", PlayerLimit = "5",  infoline = METAMAP_TBF_INFO, texture = "BloodFurnaces"},
	[METAMAP_TSH_NAME] = {Continent = 3, Location = MetaMap_ZoneTable[54][MetaMap_Locale], LevelRange = "70",    PlayerLimit = "5",  infoline = METAMAP_TSH_INFO, texture = "ShatteredHalls"},
	[METAMAP_TUB_NAME] = {Continent = 3, Location = MetaMap_ZoneTable[54][MetaMap_Locale], LevelRange = "??",    PlayerLimit = "?",  infoline = METAMAP_TUB_INFO, texture = "TheUnderbog"},
	[METAMAP_TSV_NAME] = {Continent = 3, Location = MetaMap_ZoneTable[54][MetaMap_Locale], LevelRange = "??",    PlayerLimit = "?",  infoline = METAMAP_TSV_INFO, texture = "TheSteamvault"},
	[METAMAP_TSP_NAME] = {Continent = 3, Location = MetaMap_ZoneTable[54][MetaMap_Locale], LevelRange = "??",    PlayerLimit = "?",  infoline = METAMAP_TSP_INFO, texture = "TheSlavePens"},
	[METAMAP_MAG_NAME] = {Continent = 3, Location = MetaMap_ZoneTable[54][MetaMap_Locale], LevelRange = "??",    PlayerLimit = "?",  infoline = METAMAP_MAG_INFO, texture = "MagtheridonsLair"},
	[METAMAP_HFR_NAME] = {Continent = 3, Location = MetaMap_ZoneTable[54][MetaMap_Locale], LevelRange = "??",    PlayerLimit = "?",  infoline = METAMAP_HFR_INFO, texture = "HellfireRampart"},
};

--- To be removed - reference for data format conversion only
MetaMap_Data = {
	[1] = METAMAP_BFD_NAME,
	[2] = METAMAP_BRD_NAME,
	[3] = METAMAP_BRS_NAME,
	[4] = METAMAP_BSU_NAME,
	[5] = METAMAP_BWL_NAME,
	[6] = METAMAP_DMC_NAME,
	[7] = METAMAP_DME_NAME,
	[8] = METAMAP_DMN_NAME,
	[9] = METAMAP_DMW_NAME,
	[10] = METAMAP_GNM_NAME,
	[11] = METAMAP_MDN_NAME,
	[12] = METAMAP_TMC_NAME,
	[13] = METAMAP_ONL_NAME,
	[14] = METAMAP_RFC_NAME,
	[15] = METAMAP_RFD_NAME,
	[16] = METAMAP_RFK_NAME,
	[17] = METAMAP_TSM_NAME,
	[18] = METAMAP_SLM_NAME,
	[19] = METAMAP_SFK_NAME,
	[20] = METAMAP_STR_NAME,
	[21] = METAMAP_TDM_NAME,
	[22] = METAMAP_TSK_NAME,
	[23] = METAMAP_TST_NAME,
	[24] = METAMAP_ULD_NAME,
	[25] = METAMAP_TWC_NAME,
	[26] = METAMAP_ZFK_NAME,
	[27] = METAMAP_ZGB_NAME,
	[28] = METAMAP_TAQ_NAME,
	[29] = METAMAP_RAQ_NAME,
	[30] = METAMAP_NAX_NAME,
	[31] = METAMAP_TBF_NAME,
	[32] = METAMAP_TSH_NAME,
};

MetaMap_ZSM = {
	["en"] = {
		[1] = { 1, 2, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24 },
		[2] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28 },
	}, 	
	["de"] = {
		[1] = { 12, 1, 4, 5, 6, 9, 10, 13, 11, 15, 16, 17, 18, 19, 20, 21, 22, 23, 8, 14, 24 },
		[2] = { 1, 2, 3, 4, 5, 7, 9, 6, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28 },
	}, 
	["fr"] = {
		[1] = { 19, 1, 2, 3, 4, 5, 6, 7, 8, 13, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 12 },
		[2] = { 1, 13, 3, 4, 5, 6, 8, 9, 11, 12, 7, 14, 15, 16, 18, 20, 21, 22, 23, 24, 25, 26, 27, 10, 28 },
	}, 	
	["es"] = {
		[1] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21 },
		[2] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 },
	}, 	
}

function MetaMap_UpdateShift()
	local temp = {}
	for continent=1, 2, 1 do
		for zone, value in pairs(MetaMapNotes_Data[continent]) do
			if(MetaMap_ZSM[MetaMap_Locale][continent][zone]) then
				temp[MetaMap_ZSM[MetaMap_Locale][continent][zone]] = value;
			end
		end
		MetaMapNotes_Data[continent] = {};
		for index, value in pairs(temp) do
			MetaMapNotes_Data[continent][index] = value;
		end
		temp = {};
	end
	temp = {};
	for continent=1, 2, 1 do
		for zone, value in pairs(MetaMapNotes_Lines[continent]) do
			if(MetaMap_ZSM[MetaMap_Locale][continent][zone]) then
				temp[MetaMap_ZSM[MetaMap_Locale][continent][zone]] = value;
			end
		end
		MetaMapNotes_Lines[continent] = {};
		for index, value in pairs(temp) do
			MetaMapNotes_Lines[continent][index] = value;
		end
		temp = {};
	end
end

function MetaMap_UpdateFormat()
	if(MetaMapNotes_Data == nil) then return; end
	if(not MetaMap_ZSM[MetaMap_Locale]) then
		MetaMap_Print("Unknown client locale: "..MetaMap_Locale, true);
		return;
	end
	MetaMap_UpdateShift();
	for cKey, cTable in pairs(MetaMapNotes_Data) do
		for zKey, zTable in pairs(cTable) do
			for index, value in pairs(zTable) do
				local mapName;
				if(cKey == "BG") then
					mapName = zKey;
				elseif(cKey == 0) then
					mapName = MetaMap_Data[zKey];
				else
					mapName = MetaMap_ZoneIDToName(cKey, zKey);
				end
				if(MetaMap_Notes[mapName]) then
					MetaMap_Notes[mapName][index] = value;
				end
			end
		end
	end
	for cKey, cTable in ipairs(MetaMapNotes_Lines) do
		for zKey, zTable in pairs(cTable) do
			for index, value in pairs(zTable) do
				local mapName;
				if(cKey == "BG") then
					mapName = zKey;
				elseif(cKey == 0) then
					mapName = MetaMap_Data[zKey];
				else
					mapName = MetaMap_ZoneIDToName(cKey, zKey);
				end
				if(MetaMap_Lines[mapName]) then
					MetaMap_Lines[mapName][index] = value;
				end
			end
		end
	end
	MetaMapNotes_Data = nil;
	MetaMapNotes_Lines = nil;
	MetaMap_Print("MetaMap data successfully converted to new format", true);
end
