function WeaponButtons_PopNUICallback(whichUI, isEnabled, xPos, yPos)
	if ( ( not WeaponButtons_Enabled ) or ( WeaponButtons_Enabled ~= 1 ) ) then
		if ( WeaponButtonsFrame:IsVisible() ) then
			WeaponButtonsFrame:Hide();
		end
	else
		PopNUI_CheckUI(whichUI, isEnabled, xPos, yPos);
	end
end


function WeaponButtons_Register_Eclipse()
	if ( Eclipse ) then
		--Set the ui section to be nil if we have Khaos
		local uisec = nil;
		--If we don't have Khaos, then use the Cosmos section
		if (not Khaos) then
			uisec = "COS_WEAPONBUTTONS";
		end
		--Register with VisibilityOptions
		Eclipse.registerForVisibility( {
			name = WEAPONBUTTONS_FRAMENAME;	--The name of the config, in this case also the name of the frame
			nototal = true;	--This addon has an option to hide the frame already, so we don't need to register with total
			uisec = uisec;	--This puts the options, in the Weapon Buttons section, it is not neccessary but helps to keep VisOpts section cleaner
			uiname = WEAPONBUTTONS_CONFIG_HEADER;	--This is the base name of this reg to display in the description and ui
			slashcom = WEAPONBUTTONS_CONFIG_ECLIPSE_SLASHCMDS;	--These are the slash commands
		}	);
		return true;
	end
end



-- Cosmos
-- Toggles the enabled/disabled state of an option and returns the new state
--  if toggle is 1, it's enabled
--  if toggle is 0, it's disabled
--   otherwise, it's toggled
function WeaponButtons_Generic_Toggle(toggle, variableName, enableMessage, disableMessage)
	local oldvalue = WeaponButtons_Options[variableName];
	if ( oldvalue ) then
		oldvalue = 1;
	else
		oldvalue = 0;
	end
	local newvalue = toggle;
	if ( ( toggle ~= 1 ) and ( toggle ~= 0 ) ) then
		if (oldvalue == 1) then
			newvalue = 0;
		elseif ( oldvalue == 0 ) then
			newvalue = 1;
		else
			newvalue = 0;
		end
	end
	if ( newvalue == 1 ) then
		WeaponButtons_Options[variableName] = true;
	else
		WeaponButtons_Options[variableName] = false;
	end
	if ( ( newvalue ~= oldvalue ) ) then
		local text = "";
		if ( newvalue == 1 ) then
			text = TEXT(getglobal(enableMessage));
		else
			text = TEXT(getglobal(disableMessage));
		end
		if ( ( text ) and ( strlen(text) > 0 ) ) then
			WeaponButtons_Print(text);
		end
	end
	return newvalue;
end

-- Toggles the enabled/disabled state of the WeaponButtons
--  if toggle is 1, it's enabled
--  if toggle is 0, it's disabled
--   otherwise, it's toggled
function WeaponButtons_DoToggle_Enabled(toggle, noChat)
	local newValue = 0;
	if ( noChat ) then
		newValue = WeaponButtons_Generic_Toggle(toggle, "enabled");
	else
		newValue = WeaponButtons_Generic_Toggle(toggle, "enabled", "WEAPONBUTTONS_CHAT_ENABLED", "WEAPONBUTTONS_CHAT_DISABLED");
	end
	if ( newValue == 1 ) then
		WeaponButtonsFrame:Show();
	else
		WeaponButtonsFrame:Hide();
	end
end

function WeaponButtons_Toggle_Enabled(toggle)
	WeaponButtons_DoToggle_Enabled(toggle);
end

function WeaponButtons_Toggle_Enabled_NoChat(toggle)
	WeaponButtons_DoToggle_Enabled(toggle, true);
end

-- Toggles whether tooltips are displayed on mousing over of the WeaponButtons
--  if toggle is 1, they are displayed
--  if toggle is 0, they are not displayed
--   otherwise, they are toggled
function WeaponButtons_DoToggle_DisplayTooltips(toggle, noChat)
	local newvalue = 0;
	if ( noChat ) then
		newValue = WeaponButtons_Generic_Toggle(toggle, "showTooltips");
	else
		newValue = WeaponButtons_Generic_Toggle(toggle, "showTooltips", "WEAPONBUTTONS_CHAT_DISPLAY_TOOLTIPS_ENABLED", "WEAPONBUTTONS_CHAT_DISPLAY_TOOLTIPS_DISABLED");
	end
end

function WeaponButtons_Toggle_DisplayTooltips(toggle)
	WeaponButtons_DoToggle_DisplayTooltips(toggle);
end

function WeaponButtons_Toggle_DisplayTooltips_NoChat(toggle)
	WeaponButtons_DoToggle_DisplayTooltips(toggle, true);
end

-- Toggles whether the window is locked to its current position or not.
--  if toggle is 1, they are displayed
--  if toggle is 0, they are not displayed
--   otherwise, they are toggled
function WeaponButtons_DoToggle_LockPosition(toggle, noChat)
	local newvalue = 0;
	if ( noChat ) then
		newValue = WeaponButtons_Generic_Toggle(toggle, "locked");
	else
		newValue = WeaponButtons_Generic_Toggle(toggle, "locked", "WEAPONBUTTONS_CHAT_LOCK_POSITION_ENABLED", "WEAPONBUTTONS_CHAT_LOCK_POSITION_DISABLED");
	end
end

function WeaponButtons_Toggle_LockPosition(toggle)
	WeaponButtons_DoToggle_LockPosition(toggle);
end

function WeaponButtons_Toggle_LockPosition_NoChat(toggle)
	WeaponButtons_DoToggle_LockPosition(toggle, true);
end

function WeaponButtons_Khaos_OptionSet_Toggle(toggle)
	-- do not know if this is necessary, but...
	WeaponButtons_Khaos_Toggle_Enabled(toggle);
end

function WeaponButtons_Khaos_Toggle_Enabled(checked)
	-- fix if we want to add on Cosmos config for backwards compatibility
	if ( checked == 0 ) then 
		checked = false; 
	end
	if ( checked ) then
		WeaponButtonsFrame:Show();
	else
		WeaponButtonsFrame:Hide();
	end
	WeaponButtons_Options.enabled = checked;
	if ( checked ) then 
		WeaponButtons_Toggle_Enabled_NoChat(1);
	else
		WeaponButtons_Toggle_Enabled_NoChat(0);
	end
end

function WeaponButtons_Config_Toggle_DisplayTooltips(checked)
	WeaponButtons_Options.showTooltips = checked;
	if ( checked ) then
		WeaponButtons_Toggle_DisplayTooltips_NoChat(1);
	else
		WeaponButtons_Toggle_DisplayTooltips_NoChat(0);
	end
end

function WeaponButtons_Config_Toggle_Locked(checked)
	WeaponButtons_Options.locked = checked;
	if ( checked ) then
		WeaponButtons_Toggle_LockPosition_NoChat(1);
	else
		WeaponButtons_Toggle_LockPosition_NoChat(0);
	end
end

function WeaponButtons_Config_Set_Mode(mode)
	WeaponButtons_SetDefaultMode(mode);
end

function WeaponButtons_Khaos_Register()
	-- iffy solution - slash commands will be overwritten by Khaos. Oh well...
	
	if ( not Khaos ) or ( not Khaos.registerOptionSet ) then
		return false;
	end

	Khaos.registerOptionSet (
		"other",
		{
			id = "WeaponButtonsOptionSet";
			text = WEAPONBUTTONS_CONFIG_HEADER;
			helptext = WEAPONBUTTONS_CONFIG_HEADER_INFO;
			difficulty = 1;
			callback = function(state) WeaponButtons_Khaos_Toggle_Enabled(state); end;
			feedback = function(state)
				if (state) then
					return WEAPONBUTTONS_CHAT_ENABLED;
				else
					return WEAPONBUTTONS_CHAT_DISABLED;
				end
			end;
			default = { checked = WEAPONBUTTONS_OPTIONS_DEFAULT.enabled; };
			disabled = { checked = false; };
			options = {
				{
					id = "WeaponButtonsOptionHeader";
					type = K_HEADER;
					difficulty = 1;
					text = WEAPONBUTTONS_CONFIG_HEADER;
					helptext = WEAPONBUTTONS_CONFIG_HEADER_INFO;
				},
				{
					id = "WeaponButtonsOptionShowTooltips";
					type = K_TEXT;
					difficulty = 1;
					text = WEAPONBUTTONS_DISPLAY_TOOLTIPS;
					helptext = WEAPONBUTTONS_DISPLAY_TOOLTIPS_INFO;
					callback = function(state) WeaponButtons_Config_Toggle_DisplayTooltips(state.checked); end;
					feedback = function(state)
						if (state.checked) then
							return WEAPONBUTTONS_CHAT_DISPLAY_TOOLTIPS_ENABLED;
						else
							return WEAPONBUTTONS_CHAT_DISPLAY_TOOLTIPS_DISABLED;
						end
					end;
					check = true;
					default = { checked = WEAPONBUTTONS_OPTIONS_DEFAULT.showTooltips; };
					disabled = { checked = false; };
				},
				{
					id = "WeaponButtonsOptionLocked";
					type = K_TEXT;
					difficulty = 1;
					text = WEAPONBUTTONS_LOCK_POSITION;
					helptext = WEAPONBUTTONS_LOCK_POSITION_INFO;
					callback = function(state) WeaponButtons_Config_Toggle_Locked(state.checked); end;
					feedback = function(state)
						if (state.checked) then
							return WEAPONBUTTONS_CHAT_LOCK_POSITION_ENABLED;
						else
							return WEAPONBUTTONS_CHAT_LOCK_POSITION_DISABLED;
						end
					end;
					check = true;
					default = { checked = WEAPONBUTTONS_OPTIONS_DEFAULT.locked; };
					disabled = { checked = false; };
				},
				{
					id = "WeaponButtonsOptionMode";
					type = K_SLIDER;
					difficulty = 3;
					text = WEAPONBUTTONS_CONFIG_MODE;
					helptext = WEAPONBUTTONS_CONFIG_MODE_INFO;
					setup = {
						sliderMin = WEAPONBUTTONS_MODE_MIN;
						sliderMax = WEAPONBUTTONS_MODE_MAX;
						sliderStep = 1;
						sliderSignificantDigits = 1;
						sliderLow = "";
						sliderHigh = "";
						sliderText = WEAPONBUTTONS_CONFIG_MODE_SLIDER_TEXT;
						sliderDisplayFunc = function (value) return WEAPONBUTTONS_CHAT_MODES[value]; end;
					};
					callback = function(state) WeaponButtons_Config_Set_Mode(state.slider); end;
					feedback = function(state)
						return string.format(WEAPONBUTTONS_CHAT_SETMODE, WEAPONBUTTONS_CHAT_MODES[state.slider]);
					end;
					default = { slider = WEAPONBUTTONS_OPTIONS_DEFAULT.mode; };
					disabled = { };
				}
			}
		}
	)
	
end

function WeaponButtons_Cosmos_Boolean(value)
	if ( value == true ) then
		return 1;
	else
		return 0;
	end
end

-- registers the mod with Cosmos
function WeaponButtons_Register_Cosmos()
	if ( ( Cosmos_RegisterConfiguration ) and ( WeaponButtons_Cosmos_Registered == 0 ) ) then
		Cosmos_RegisterConfiguration(
			"COS_WEAPONBUTTONS",
			"SECTION",
			TEXT(WEAPONBUTTONS_CONFIG_HEADER),
			TEXT(WEAPONBUTTONS_CONFIG_HEADER_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_WEAPONBUTTONS_HEADER",
			"SEPARATOR",
			TEXT(WEAPONBUTTONS_CONFIG_HEADER),
			TEXT(WEAPONBUTTONS_CONFIG_HEADER_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_WEAPONBUTTONS_ENABLED",
			"CHECKBOX",
			TEXT(WEAPONBUTTONS_ENABLED),
			TEXT(WEAPONBUTTONS_ENABLED_INFO),
			WeaponButtons_Toggle_Enabled_NoChat,
			WeaponButtons_Cosmos_Boolean(WeaponButtons_Options.enabled)
		);
		Cosmos_RegisterConfiguration(
			"COS_WEAPONBUTTONS_DISPLAY_TOOLTIPS",
			"CHECKBOX",
			TEXT(WEAPONBUTTONS_DISPLAY_TOOLTIPS),
			TEXT(WEAPONBUTTONS_DISPLAY_TOOLTIPS_INFO),
			WeaponButtons_Toggle_DisplayTooltips_NoChat,
			WeaponButtons_Cosmos_Boolean(WeaponButtons_Options.showTooltips)
		);
		Cosmos_RegisterConfiguration(
			"COS_WEAPONBUTTONS_LOCK_POSITION",
			"CHECKBOX",
			TEXT(WEAPONBUTTONS_LOCK_POSITION),
			TEXT(WEAPONBUTTONS_LOCK_POSITION_INFO),
			WeaponButtons_Toggle_LockPosition_NoChat,
			WeaponButtons_Cosmos_Boolean(WeaponButtons_Options.locked)
		);
		local defaultModeInfo = TEXT(WEAPONBUTTONS_DEFAULT_MODE_INFO);
		for k, v in WEAPONBUTTONS_CHAT_MODES do
			defaultModeInfo = defaultModeInfo..string.format(" %d = %s.", k, v);
		end
		Cosmos_RegisterConfiguration(
			"COS_WEAPONBUTTONS_DEFAULT_MODE",
			"SLIDER",
			TEXT(WEAPONBUTTONS_DEFAULT_MODE),
			defaultModeInfo,
			WeaponButtons_SetDefaultMode,
			1,
			WeaponButtons_Options.mode,
			WEAPONBUTTONS_MODE_MIN,
			WEAPONBUTTONS_MODE_MAX,
			"",
			1,
			1,
			TEXT(WEAPONBUTTONS_DEFAULT_MODE_APPEND)
		);
		if ( Cosmos_RegisterChatCommand ) then
			Cosmos_RegisterChatCommand (
				"WEAPONBUTTONS_MAIN_COMMANDS", -- Some Unique Group ID
				WEAPONBUTTONS_SLASHCMDS, -- The Commands
				WeaponButtons_Main_ChatCommandHandler,
				WEAPONBUTTONS_CHAT_COMMAND_INFO -- Description String
			);
		end
		WeaponButtons_Cosmos_Registered = 1;
	end
end

