-- Copyright 2004,2005,2006 by Thott

function Thottbot_Tloc(msg)
	if(Thottbot.Tloc) then
		Thottbot.Tloc = false;
		ThottbotText:Hide();
	else
		Thottbot.Tloc = true;
		ThottbotText:Show();
		ThottbotTextButton:Show();
		print1(T_CMD_LOC_MINIMAP);
	end
end
function Thottbot_GCInfo()
	if(Thottbot.GCInfo) then
		Thottbot.GCInfo = nil;
		ThottbotText:SetText("");
	else
		Thottbot.GCInfo = {};
		for i=1, 4 do
			Thottbot.GCInfo[i] = 0;
		end
		Thottbot.GCInfo_lasti = 0;
		Thottbot.GCInfo_last = gcinfo();
		ThottbotTextButton:Show();
	end
end
function Thottbot_ProfileLink()
	local server = GetRealmName();
	if (server) then
		return "http://www.thottbot.com/?profile="..UnitName("player").."."..server;
	else
		return T_SERVER_UNKNOWN;
	end
end
function Thottbot_KhaosInit()
	if(not Khaos) then
		return;
	end
	local Options = {
		{
			id="ThottbotHeader";
			text="Thottbot";
			helptext=T_HEADER_HELP;
			difficulty=1;
			type=K_HEADER;
		};
		{
			id="ThottbotProfileEnable";
			text=T_PROFILE_TEXT;
			helptext=T_PROFILE_HELP..Thottbot_ProfileLink();
			difficulty=1;
			key="tbprofile";
			check=true;
			type=K_TEXT;
			callback=Thottbot_PlayerProfileEnable;
			feedback=function(state)
				if(state.checked) then
					return T_PROFILE_ENABLED..Thottbot_ProfileLink();
				else
					return T_PROFILE_DISABLED;
				end
			end;
			default = {
				checked = true;
			};
			disabled = {
				checked = false;
			};
		};
		{
			id="ThottbotTargetProfileEnable";
			text=T_TARGET_PROFILE_TEXT;
			helptext=T_TARGET_PROFILE_HELP;
			difficulty=1;
			key="tbtarget";
			check=true;
			type=K_TEXT;
			callback=Thottbot_TargetProfileEnable;
			feedback=function(state)
				if(state.checked) then
					return T_TARGET_PROFILE_ENABLED;
				else
					return T_TARGET_PROFILE_DISABLED;
				end
			end;
			default = {
				checked = true;
			};
			disabled = {
				checked = false;
			};
		};
		{
			id="ThottbotDataEnable";
			text=T_DATA_TEXT;
			helptext=T_DATA_HELP;
			difficulty=1;
			key="tbdata";
			check=true;
			type=K_TEXT;
			callback=Thottbot_Enable;
			feedback=function(state)
				if(state.checked) then
					return T_DATA_ENABLED;
				else
					return T_DATA_DISABLED;
				end
			end;
			default = {
				checked = true;
			};
			disabled = {
				checked = false;
			};
		};
		{
			id="ThottbotHeavyEnable";
			text=T_HEAVY_TEXT;
			helptext=T_HEAVY_HELP;
			difficulty=1;
			key="tbheavy";
			check=true;
			type=K_TEXT;
			callback=Thottbot_HeavyEnable;
			feedback=function(state)
				if(state.checked) then
					return T_HEAVY_ENABLED;
				else
					return T_HEAVY_DISABLED;
				end
			end;
			default = {
				checked = false;
			};
			disabled = {
				checked = false;
			};
			dependencies = {
				tbdata={checked=true;match=true};
			};
		};
		{
			id="ThottbotStateEnable";
			text=T_STATE_TEXT;
			helptext=T_STATE_HELP;
			difficulty=1;
			key="tbstate";
			check=true;
			type=K_TEXT;
			callback=Thottbot_StateEnable;
			feedback=function(state)
				if(state.checked) then
					return T_STATE_ENABLED;
				else
					return T_STATE_DISABLED;
				end
			end;
			default = {
				checked = true;
			};
			disabled = {
				checked = true;
			};
			dependencies = {
				tbprofile={checked=true;match=true};
			};
		};
	};

	Khaos.registerOptionSet(
		"other",
		{
			id = "Thottbot";
			text = "Thottbot";
			helptext = T_SET_DESC;
			options = Options;
			difficulty = 1;
		}
	);
	dprint("Khaos initialized.");
end
function Thottbot_CosmosInit()
	if(not Cosmos_RegisterConfiguration) then
		return;
	end

	Cosmos_RegisterConfiguration(
		"COS_THOTTBOT",
		"SECTION",
		"Thottbot",
		T_HEADER_HELP
		);
	Cosmos_RegisterConfiguration(
		"COS_THOTTBOT_HEADER",
		"SEPARATOR",
		"Thottbot",
		T_SECTION_DESC
		);
	Cosmos_RegisterConfiguration(
		"COS_THOTTBOT_PP",
		"CHECKBOX",
		T_PROFILE_TEXT,
		T_PROFILE_HELP..Thottbot_ProfileLink(),
		Thottbot_PlayerProfileEnable,
		0,
		1
		);
	Cosmos_RegisterConfiguration("COS_THOTTBOT_PT",
		"CHECKBOX",
		T_TARGET_PROFILE_TEXT,
		T_TARGET_PROFILE_HELP,
		Thottbot_TargetProfileEnable,
		0,
		1
		);
	Cosmos_RegisterConfiguration("COS_THOTTBOT_ON",
		"CHECKBOX",
		T_DATA_TEXT,
		T_DATA_HELP,
		Thottbot_Enable,
		0,
		1
		);
	Cosmos_RegisterConfiguration("COS_THOTTBOT_HY",
		"CHECKBOX",
		T_HEAVY_TEXT,
		T_HEAVY_HELP,
		Thottbot_HeavyEnable,
		0,
		1
		);
	Cosmos_RegisterConfiguration("COS_THOTTBOT_ST",
		"CHECKBOX",
		T_STATE_TEXT,
		T_STATE_HELP,
		Thottbot_StateEnable,
		1,
		1
		);

	dprint("Cosmos initialized.");
end
function Thottbot_RegisterCommand(id,comlist,desc,func)
	if (Satellite) then
		Satellite.registerSlashCommand(
			{
				id = id;
				commands = comlist;
				onExecute = func;
				helpText = desc;
			}
		);
	else
		SlashCmdList[id] = func;
		for i=1, #comlist do setglobal("SLASH_"..id..i, comlist[i]); end;
	end
end
function Thottbot_RegisterCommands()
	local id	= "TSIZE";
	local comlist	= T_CMD_SIZE_COMLIST;
	local desc	= T_CMD_SIZE_HELP;
	local func = Thottbot_PrintSize;
	Thottbot_RegisterCommand(id,comlist,desc,func);

	id	= "TSTATE";
	comlist	= T_CMD_STATE_COMLIST;
	desc	= T_CMD_STATE_HELP;
	func = Thottbot_PrintState;
	Thottbot_RegisterCommand(id,comlist,desc,func);

	id	= "TRESET";
	comlist	= T_CMD_RESET_COMLIST;
	desc	= T_CMD_RESET_HELP;
	func = function()
		if(Thottbot.Loaded) then
			Thottbot_Reset();
			print1(T_RESET);
			Thottbot_PrintSize();
		else
			print1(T_DISABLED);
		end
	end
	Thottbot_RegisterCommand(id,comlist,desc,func);

	id	= "TLOC";
	comlist	= T_CMD_LOC_COMLIST;
	desc	= T_CMD_LOC_HELP;
	func = function(msg)
		Thottbot_Tloc(msg);
	end
	Thottbot_RegisterCommand(id,comlist,desc,func);

	id	= "TPROFILE";
	comlist	= T_CMD_PROFILE_COMLIST;
	desc	= T_CMD_PROFILE_HELP;
	func = function()
		Thottbot_Profile("player");
	end
	Thottbot_RegisterCommand(id,comlist,desc,func);

	id	= "GCINFO";
	comlist	= T_CMD_GCINFO_COMLIST;
	desc	= T_CMD_GCINFO_HELP;
	func = function()
		Thottbot_GCInfo();
	end
	Thottbot_RegisterCommand(id,comlist,desc,func);

	id	= "TVER";
	comlist	= T_CMD_VER_COMLIST;
	desc	= T_CMD_VER_HELP;
	func = function()
		print1(T_CMD_VER_VERSION, THOTTBOT_VERSION);
	end
	Thottbot_RegisterCommand(id,comlist,desc,func);

	id = "LANG";
	comlist	= T_LANGUAGE_COMM;
	desc	= T_LANGUAGE_COMM_INFO;
	-- this really should be in some other addon
	func = function(msg)
		local numLanguages = GetNumLaguages();
		local i;
		if(not msg or msg == "") then
			print1(T_LANGUAGE_HELP1);
			print1(T_LANGUAGE_HELP2);
			for i = 1, numLanguages, 1 do
				local language = GetLanguageByIndex(i);
				print1("- "..language);
			end
			return;
		end
		local numLanguages = GetNumLaguages();
		local i;
		for i = 1, numLanguages, 1 do
			local language = GetLanguageByIndex(i);
			if(strlower(language) == strlower(msg) or strlower(string.sub(language,1,string.len(msg))) == strlower(msg)) then
				ChatFrame1.editBox.language = language;
				print1(format(T_LANGUAGE_NOWSPEAK, language));
				return;
			end
		end
		print1(format(T_LANGUAGE_UNKNOWN, msg));
	end
	Thottbot_RegisterCommand(id,comlist,desc,func);

	dprint("Commands registered.");
end
--function Thottbot_GCInfo()
--	if(Thottbot.GCInfo) then
--		Thottbot.GCInfo = nil;
--		ThottbotText:SetText("");
--		ThottbotText:Hide();
--		return;
--	else
--		Thottbot.GCInfo = {};
--		for i=1, 4 do
--			Thottbot.GCInfo[i] = 0;
--		end
--		Thottbot.GCInfo_lasti = 0;
--		Thottbot.GCInfo_last = gcinfo();
--		Chronos.everyFrame(Thottbot_GCInfo_Update);
--	end
--end
--function Thottbot_GCInfo_Update()
--	if(not Thottbot.GCInfo) then
--		return true;
--	end
--	local current,threshold = gcinfo();
--	local diff = current - Thottbot.GCInfo_last;
--	if(diff < 0) then
--		Thottbot.GCInfo_last = current;
--		Thottbot.GCInfo_window = threshold - current;
--		return;
--	end
--	Thottbot.GCInfo_last = current;
--	local i = mod(floor(GetTime()),4)+1;
--	if(i ~= Thottbot.GCInfo_lasti) then
--		Thottbot.GCInfo[i] = 0;
--		Thottbot.GCInfo_lasti = i;
--	end
--	Thottbot.GCInfo[i] = Thottbot.GCInfo[i] + diff;
--	local avg = 0;
--	for j=1,4 do
--		if(j ~= i) then
--			avg = avg + Thottbot.GCInfo[j];
--		end
--	end
--	avg = avg / 3;
--
--	local f;
--	if(Thottbot.GCInfo_window and avg > 0) then
--		f = format(T_CMD_GCINFO_FORMAT_WINDOW,current,threshold,diff,avg,Thottbot.GCInfo_window/avg);
--	else
--		f = format(T_CMD_GCINFO_FORMAT,current,threshold,diff,avg);
--	end
--	ThottbotText:SetText(f);
--	ThottbotText:Show();
--	return;
--end
function TFixState(state)
	if(state) then
		if(state == 0) then
			return false;
		elseif(state == 1 or state.checked) then
			return true;
		end
	end
	return false;
end
function Thottbot_PlayerProfileEnable(state)
	state = TFixState(state);
	if(state and not Thottbot.PlayerProfile) then
		if(not Thottbot.Loaded) then
			-- basic Thottbot capability required to gather profile
			-- don't collect any other data until Thottbot.IsOn is 1
			Thottbot_Load();
		end
		Thottbot.PlayerProfile = true;
		if(Thottbot.Running) then
			Chronos.scheduleByName("TProfile",0,Thottbot_Profile,"player");
			print1(T_PROFILE_TEXT1);
			print1(T_PROFILE_TEXT2);
			print1(T_PROFILE_TEXT3);
			print1( Thottbot_ProfileLink());
			Thottbot_PrintState();
		end
	elseif(not state and Thottbot.PlayerProfile) then
		Thottbot.PlayerProfile = false;
		if(Thottbot.Running) then
			--print1(T_PROFILE_DISABLED);
			Thottbot_PrintState();
		end
	end
end
function Thottbot_TargetProfileEnable(state)
	state = TFixState(state);
	if(state and not Thottbot.TargetProfile) then
		if(not Thottbot.Loaded) then
			-- basic Thottbot capability required to gather profile
			-- no other data gets collected until Thottbot.IsOn is 1
			Thottbot_Load();
		end
		Thottbot.TargetProfile = true;
		if(Thottbot.Running) then
			--print1(T_TARGET_PROFILE_ENABLED);
			Thottbot_PrintState();
		end
	elseif(not state and Thottbot.TargetProfile) then
		Thottbot.TargetProfile = false;
		if(Thottbot.Running) then
			--print1(T_TARGET_PROFILE_DISABLED);
			Thottbot_PrintState();
		end
	end
end
function Thottbot_HeavyEnable(state)
	state = TFixState(state);
	if(Thottbot.BadVersion) then
		return;
	end
	if(state and not Thottbot.Heavy) then
		--Thottbot_Enable(state);
		if(not Thottbot.Loaded) then
			Thottbot_Load();
		end
		Thottbot.Heavy = true;
		if(Thottbot.Running) then
			--print1(T_HEAVY_TEXT1);
			--print1(T_HEAVY_TEXT2);
			--print1(T_HEAVY_TEXT3);
			--print1(T_HEAVY_TEXT4);
			--print1(T_HEAVY_TEXT5);
			Thottbot_PrintState();
		end
	elseif(not state and Thottbot.Heavy) then
		Thottbot.Heavy = false;
		if(Thottbot.Running) then
			Thottbot_PrintState();
		end
	end
end
function Thottbot_StateEnable(state)
	state = TFixState(state);
	if(state and Thottbot.NoState) then
		Thottbot.NoState = false;
		if(Thottbot.Running) then
			print1(T_STATE_ENABLED);
			Thottbot_PrintState();
		end
	elseif(not state and not Thottbot.NoState) then
		Thottbot.NoState = true;
		if(Thottbot.Running) then
			--print1(T_STATE_DISABLED);
		end
	end
end
function Thottbot_Enable(state)
	state = TFixState(state);
	if(Thottbot.BadVersion) then
		return;
	end
	if(state and not Thottbot.IsOn) then
		Thottbot.IsOn = true;
		if(not Thottbot.Loaded) then
			Thottbot_Load();
		end
		if(Thottbot.Running) then
			Thottbot_PrintState();
			--print1(T_ENABLED);
		end
	elseif(not state and Thottbot.IsOn) then
		Thottbot.IsOn = false;
		--if(Thottbot.Heavy) then
			--SetCVar("COS_THOTTBOT_HY","0","COS_THOTTBOT_HY");
			--CosmosMaster_HandleCVarUpdate("COS_THOTTBOT_HY",state);
			--CosmosMaster_UpdateValue("COS_THOTTBOT_HY",CSM_CHECKONOFF,state);
			--CosmosMaster_NotifyAll();
			--CosmosMaster_DrawData();
		--end
		if(Thottbot.Running) then
			--print1(T_DISABLED);
			Thottbot_PrintState();
		end
	end
end
function Thottbot_PrintState()
	Chronos.scheduleByName("TState",0.25,Thottbot_PrintStateCallback);
end
function Thottbot_PrintStateCallback()
	if(not Thottbot.NoState) then
	  local state = {};
	  push(state,Thottbot_State(T_STATE_PROFILE,Thottbot.PlayerProfile));
	  push(state,Thottbot_State(T_STATE_TARGET,Thottbot.TargetProfile));
	  push(state,Thottbot_State(T_STATE_DATA,Thottbot.IsOn));
	  push(state,Thottbot_State(T_STATE_HEAVY,Thottbot.Heavy));
	  --Sea.io.printc({r=1,g=1,b=1},"|cFF0000FFTHOTTB|r|cFFCFB53BO|r|cFF0000FFT|r: ",join(unpack(state),", "));
	  if(ChatFrame1) then
	    ChatFrame1:AddMessage("|cFF0000FFTHOTTB|r|cFFCFB53BO|r|cFF0000FFT|r: "..joinl(state,", "),1.0,1.0,1.0);
	  end
	end
end
function Thottbot_State(name,state)
	if(state) then
		return name.." [|cFF00FF00On|r]";
	else
		return name.." [|cFF000000Off|r]";
	end
end
function Thottbot_OnLoad()
	Thottbot_RegisterCommands();
	Thottbot_Engine_OnLoad();
	if (Khaos) then
		Thottbot_KhaosInit();
	elseif (Cosmos_RegisterConfiguration) then
		Thottbot_CosmosInit();
	else
		Thottbot_Enable(1);
		Thottbot_HeavyEnable(1);
		Thottbot_PlayerProfileEnable(1);
		Thottbot_TargetProfileEnable(1);
	end
	Chronos.afterInit(Thottbot_PrintState);
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("PLAYER_LEAVING_WORLD");
end
function Thottbot_OnUpdate()
	if(dprint_queue) then
		dprint_runqueue();
	end
end

function ThottbotTextButton_OnUpdate()
	if(Thottbot.GCInfo) then
		local current,threshold = gcinfo();
		local diff = current - Thottbot.GCInfo_last;
		if(diff < 0) then
			Thottbot.GCInfo_last = current;
			Thottbot.GCInfo_window = threshold - current;
			return;
		end
		Thottbot.GCInfo_last = current;
		local i = mod(floor(GetTime()),4)+1;
		if(i ~= Thottbot.GCInfo_lasti) then
			Thottbot.GCInfo[i] = 0;
			Thottbot.GCInfo_lasti = i;
		end
		Thottbot.GCInfo[i] = Thottbot.GCInfo[i] + diff;
		local avg = 0;
		for j=1,4 do
			if(j ~= i) then
				avg = avg + Thottbot.GCInfo[j];
			end
		end
		avg = avg / 3;
	
		local f;
		if(Thottbot.GCInfo_window and avg > 0) then
			f = format(T_CMD_GCINFO_FORMAT_WINDOW,current,threshold,diff,avg,Thottbot.GCInfo_window/avg);
		else
			f = format(T_CMD_GCINFO_FORMAT,current,threshold,diff,avg);
		end
		ThottbotText:SetText(f);
		ThottbotText:Show();
	end
	if(Thottbot.Tloc) then
		local x,y = GetPlayerMapPosition("player");
		x = round(x*100);
		y = round(y*100);
		ThottbotText:SetText(format("%2d,%2d",x,y));
	end
end


function racetype(race)
	if (race == T_RACE_HUMAN or
	    race == T_RACE_DWARF or
	    race == T_RACE_NELF or
	    race == T_RACE_GNOME) then
		return "A";
	elseif (race == T_RACE_UNDEAD or
		race == T_RACE_TAUREN or
		race == T_RACE_ORC or
		race == T_RACE_TROLL) then
		return "H";
	end

	-- Default Return Value
	return "?";
end
