--[[

TasteTheNaimbow
	Colors people's names individually

By Guillotine (Guillotine@cosmosui.org)

A big thanks to Elkano for his ColorWhispers which this is based on and to the whole #WoWI-Lounge group for helping with the hashing :)

Change Log:

v1.3
- Added support for mods using data externally
v1.2
- Will no longer use dark blue color (will go to a purple/pink color instead)
v1.1
- Updated for Lua 5.1
- TOC updated to 20000
v1.0
- Initial Release

	$Id: TasteTheNaimbow.lua 3705 2006-06-26 08:15:29Z karlkfi $
	$Rev: 3705 $
	$LastChangedBy: Guillotine $
	$Date: 2006-06-26 03:15:29 -0500 (Mon, 26 Jun 2006) $
	
--]]

local TasteTheNaimbow_original_ChatFrame_OnEvent = ChatFrame_OnEvent;
local TasteTheNaimbow_original_CHAT_PARTY_GET;
local TasteTheNaimbow_original_CHAT_RAID_GET;
local TasteTheNaimbow_original_CHAT_RAID_LEADER_GET;
local TasteTheNaimbow_original_CHAT_WHISPER_GET;
local TasteTheNaimbow_original_CHAT_WHISPER_INFORM_GET;
local TasteTheNaimbow_original_CHAT_BATTLEGROUND_GET;
local TasteTheNaimbow_original_CHAT_BATTLEGROUND_LEADER_GET;
local TasteTheNaimbow_original_CHAT_CHANNEL_GET;
local TasteTheNaimbow_original_CHAT_GUILD_GET;
local TasteTheNaimbow_original_CHAT_OFFICER_GET;

TasteTheNaimbow_NameColor = {};
TasteTheNaimbow_Loaded=1

function TasteTheNaimbow_OnLoad()
	if( DEFAULT_CHAT_FRAME ) then
		--DEFAULT_CHAT_FRAME:AddMessage("Guillotine - Taste The Naimbow v 1.3");
	end
end

function ChatFrame_OnEvent(event)
	if( event == "CHAT_MSG_PARTY" and arg1 ) then
		local NameHexColor = TasteTheNaimbowHash(arg2)
		TasteTheNaimbow_original_CHAT_PARTY_GET = CHAT_PARTY_GET;
		if ( TasteTheNaimbow_NameColor[arg2] == nil ) then
			TasteTheNaimbow_NameColor[arg2] = TasteTheNaimbowHash(arg2)
		end
		if ( TasteTheNaimbow_NameColor[arg2] ~= nil ) then
			CHAT_PARTY_GET = gsub(CHAT_PARTY_GET, "%%s", "|cff"..TasteTheNaimbow_NameColor[arg2].."%%s|r");
		end
	end
	if( event == "CHAT_MSG_RAID" and arg1 ) then
		TasteTheNaimbow_original_CHAT_RAID_GET = CHAT_RAID_GET;
		if ( TasteTheNaimbow_NameColor[arg2] == nil ) then
			TasteTheNaimbow_NameColor[arg2] = TasteTheNaimbowHash(arg2)
		end
		if ( TasteTheNaimbow_NameColor[arg2] ~= nil ) then
			CHAT_RAID_GET = gsub(CHAT_RAID_GET, "%%s", "|cff"..TasteTheNaimbow_NameColor[arg2].."%%s|r");
		end
	end
    if( event == "CHAT_MSG_RAID_LEADER" and arg1 ) then
		TasteTheNaimbow_original_CHAT_RAID_LEADER_GET = CHAT_RAID_LEADER_GET;
		if ( TasteTheNaimbow_NameColor[arg2] == nil ) then
			TasteTheNaimbow_NameColor[arg2] = TasteTheNaimbowHash(arg2);
		end
		CHAT_RAID_LEADER_GET = gsub(CHAT_RAID_LEADER_GET, "%%s", "|cff"..TasteTheNaimbow_NameColor[arg2].."%%s|r");
	end
	if( event == "CHAT_MSG_WHISPER" and arg1 ) then
		TasteTheNaimbow_original_CHAT_WHISPER_GET = CHAT_WHISPER_GET;
		if ( TasteTheNaimbow_NameColor[arg2] == nil ) then
			TasteTheNaimbow_NameColor[arg2] = TasteTheNaimbowHash(arg2);
		end
		CHAT_WHISPER_GET = gsub(CHAT_WHISPER_GET, "%%s", "|cff"..TasteTheNaimbow_NameColor[arg2].."%%s|r");
	end
	if( event == "CHAT_MSG_WHISPER_INFORM" and arg1 ) then
		TasteTheNaimbow_original_CHAT_WHISPER_INFORM_GET = CHAT_WHISPER_INFORM_GET;
		if ( TasteTheNaimbow_NameColor[arg2] == nil ) then
			TasteTheNaimbow_NameColor[arg2] = TasteTheNaimbowHash(arg2);
		end
		CHAT_WHISPER_INFORM_GET = gsub(CHAT_WHISPER_INFORM_GET, "%%s", "|cff"..TasteTheNaimbow_NameColor[arg2].."%%s|r");
	end
    if( event == "CHAT_MSG_BATTLEGROUND" and arg1 ) then
		TasteTheNaimbow_original_CHAT_BATTLEGROUND_GET = CHAT_BATTLEGROUND_GET;
		if ( TasteTheNaimbow_NameColor[arg2] == nil ) then
			TasteTheNaimbow_NameColor[arg2] = TasteTheNaimbowHash(arg2);
		end
		CHAT_BATTLEGROUND_GET = gsub(CHAT_BATTLEGROUND_GET, "%%s", "|cff"..TasteTheNaimbow_NameColor[arg2].."%%s|r");
	end
    if( event == "CHAT_MSG_BATTLEGROUND_LEADER" and arg1 ) then
		TasteTheNaimbow_original_CHAT_BATTLEGROUND_LEADER_GET = CHAT_BATTLEGROUND_LEADER_GET;
		if ( TasteTheNaimbow_NameColor[arg2] == nil ) then
			TasteTheNaimbow_NameColor[arg2] = TasteTheNaimbowHash(arg2);
		end
		CHAT_BATTLEGROUND_LEADER_GET = gsub(CHAT_BATTLEGROUND_LEADER_GET, "%%s", "|cff"..TasteTheNaimbow_NameColor[arg2].."%%s|r");
	end
    if( event == "CHAT_MSG_CHANNEL" and arg1 ) then
		TasteTheNaimbow_original_CHAT_CHANNEL_GET = CHAT_CHANNEL_GET;
		if ( TasteTheNaimbow_NameColor[arg2] == nil ) then
			TasteTheNaimbow_NameColor[arg2] = TasteTheNaimbowHash(arg2);
		end
		CHAT_CHANNEL_GET = gsub(CHAT_CHANNEL_GET, "%%s", "|cff"..TasteTheNaimbow_NameColor[arg2].."%%s|r");
	end
    if( event == "CHAT_MSG_GUILD" and arg1 ) then
		TasteTheNaimbow_original_CHAT_GUILD_GET = CHAT_GUILD_GET;
		if ( TasteTheNaimbow_NameColor[arg2] == nil ) then
			TasteTheNaimbow_NameColor[arg2] = TasteTheNaimbowHash(arg2);
		end
		CHAT_GUILD_GET = gsub(CHAT_GUILD_GET, "%%s", "|cff"..TasteTheNaimbow_NameColor[arg2].."%%s|r");
	end
    if( event == "CHAT_MSG_OFFICER" and arg1 ) then
		TasteTheNaimbow_original_CHAT_OFFICER_GET = CHAT_OFFICER_GET;
		if ( TasteTheNaimbow_NameColor[arg2] == nil ) then
			TasteTheNaimbow_NameColor[arg2] = TasteTheNaimbowHash(arg2);
		end
		CHAT_OFFICER_GET = gsub(CHAT_OFFICER_GET, "%%s", "|cff"..TasteTheNaimbow_NameColor[arg2].."%%s|r");
	end
	TasteTheNaimbow_original_ChatFrame_OnEvent(event);
	if( event == "CHAT_MSG_PARTY" and arg1 ) then
		CHAT_PARTY_GET = TasteTheNaimbow_original_CHAT_PARTY_GET;
	end
	if( event == "CHAT_MSG_RAID" and arg1 ) then
		CHAT_RAID_GET = TasteTheNaimbow_original_CHAT_RAID_GET;
	end
    if(event == "CHAT_MSG_RAID_LEADER" and arg1 ) then
        CHAT_RAID_LEADER_GET = TasteTheNaimbow_original_CHAT_RAID_LEADER_GET;
    end
	if( event == "CHAT_MSG_WHISPER" and arg1 ) then
		CHAT_WHISPER_GET = TasteTheNaimbow_original_CHAT_WHISPER_GET;
	end
	if( event == "CHAT_MSG_WHISPER_INFORM" and arg1 ) then
		CHAT_WHISPER_INFORM_GET = TasteTheNaimbow_original_CHAT_WHISPER_INFORM_GET;
	end
    if( event == "CHAT_MSG_BATTLEGROUND" and arg1 ) then
		CHAT_BATTLEGROUND_GET = TasteTheNaimbow_original_CHAT_BATTLEGROUND_GET;
	end
    if( event == "CHAT_MSG_BATTLEGROUND_LEADER" and arg1 ) then
		CHAT_BATTLEGROUND_LEADER_GET = TasteTheNaimbow_original_CHAT_BATTLEGROUND_LEADER_GET;
	end
    if( event == "CHAT_MSG_CHANNEL" and arg1 ) then
		CHAT_CHANNEL_GET = TasteTheNaimbow_original_CHAT_CHANNEL_GET;
	end
    if( event == "CHAT_MSG_GUILD" and arg1 ) then
		CHAT_GUILD_GET = TasteTheNaimbow_original_CHAT_GUILD_GET;
	end
    if( event == "CHAT_MSG_OFFICER" and arg1 ) then
		CHAT_OFFICER_GET = TasteTheNaimbow_original_CHAT_OFFICER_GET;
	end
end

-----------------------------------------Hash Part--------------------------
--djb2 hashing algorithm to LUA
function TasteTheNaimbowHash(name,debugging)
local currenthash=5381
local namelength = strlen(name)
for n = 1, namelength do
currenthash = 33*currenthash + strbyte(name, n)
end
--DEFAULT_CHAT_FRAME:AddMessage("currenthash: "..currenthash)
local Hcolor = math.fmod(currenthash, 360)
local Scolor = 1
local Vcolor = 1
if (Hcolor > 220) and (Hcolor < 270) then
    Hcolor = Hcolor + 60
end
if debugging then
DEFAULT_CHAT_FRAME:AddMessage(Hcolor)
end
--HSV -> RGB code
Rcolor, Gcolor, Bcolor = TTN_HSVtoRGB(Hcolor,Scolor,Vcolor)
--Done with HSV->RGB
--[[A better formula for HSV -> RGB :P
Rcolor = abs(Vcolor+Scolor*sqrt(2)*cos(Hcolor)))
Gcolor = abs(Vcolor+Scolor*sqrt(2)*cos(Hcolor+(4*math.pi)/3))
Bcolor = abs(Vcolor+Scolor*sqrt(2)*cos(Hcolor+(2*math.pi)/3))
--Done with HSV->RGB
--]]
local Rreadable,Greadable,Breadable = math.floor(Rcolor*256),math.floor(Gcolor*256),math.floor(Bcolor*256)
--DEFAULT_CHAT_FRAME:AddMessage("RGB = "..Rcolor..","..Gcolor..","..Bcolor)
--DEFAULT_CHAT_FRAME:AddMessage("RGB redable= "..Rreadable..","..Greadable..","..Breadable)
--This is to convert the RGB 0-1 to hex (what WoW uses)
local finalnamecolor = string.format("%02x%02x%02x", math.floor(Rcolor * 255), math.floor(Gcolor * 255), math.floor(Bcolor * 255))
finalnamecolor = string.sub(finalnamecolor,1,6)
return finalnamecolor
end

function TTN_Test(name)
DEFAULT_CHAT_FRAME:AddMessage("\124cff"..TasteTheNaimbowHash(name, 1)..name.."\124r")
end

function TTN_HSVtoRGB( Hcolor, Scolor, Vcolor)
	local formulai;
	local formulaf, formulap, formulaq, formulat;

	if( Scolor == 0 ) then
		-- achromatic (grey)
		Rcolor = Vcolor
		Gcolor = Vcolor
		Bcolor = Vcolor;
		if not Rcolor then Rcolor = 0 end
		if not Gcolor then Gcolor = 0 end
		if not Bcolor then Bcolor = 0 end
		return Rcolor, Gcolor, Bcolor;
	end

	Hcolor = Hcolor/60;			-- sector 0 to 5
	formulai = math.floor(Hcolor);
	formulaf = Hcolor - formulai;			-- factorial part of h
	formulap = Vcolor * ( 1 - Scolor );
	formulaq = Vcolor * ( 1 - Scolor * formulaf );
	formulat = Vcolor * ( 1 - Scolor * ( 1 - formulaf ) );

	if formulai == 0 then
			Rcolor = Vcolor;
			Gcolor = formulat;
			Bcolor = formulap;
	elseif formulai == 1 then
			Rcolor = formulaq;
			Gcolor = Vcolor;
			Bcolor = formulap;
	elseif formulai == 2 then
			Rcolor = formluap;
			Gcolor = Vcolor;
			Bcolor = formulat;
	elseif formulai == 3 then
			Rcolor = formulap;
			Gcolor = formulaq;
			Bcolor = Vcolor;
	elseif formulai == 4 then
			Rcolor = formulat;
			Gcolor = formulap;
			Bcolor = Vcolor;
	elseif formulai == 5 then
			Rcolor = Vcolor;
			Gcolor = formulap;
			Bcolor = formulaq;
	else
	DEFAULT_CHAT_FRAME:AddMessage("Error")
	end
	if not Rcolor then Rcolor = 0 end
	if not Gcolor then Gcolor = 0 end
	if not Bcolor then Bcolor = 0 end
	return Rcolor,Gcolor,Bcolor
end

function TasteTheNaimbowExternalColor(name)
    if ( TasteTheNaimbow_NameColor[name] == nil ) then
        TasteTheNaimbow_NameColor[name] = TasteTheNaimbowHash(name);
    end
    return TasteTheNaimbow_NameColor[name]
end