--[[
   ReloadUI
       Restart your world
   
   By: Alexander Brazie
   
   This allows you to reload your interface with /rl
   
   $Id: ReloadUI.lua 4159 2006-10-13 20:41:41Z geowar $
   $Rev: 4159 $
   $LastChangedBy: geowar $
   $Date: 2006-10-13 15:41:41 -0500 (Fri, 13 Oct 2006) $

   Small changes by Daun:
      Added a message for when the countdown completes and implemented it as RELOAD_MESSAGE.
      Changed a timer that was only half a second to a second for a more consistant looking countdown.
      Completely rewrote the Bindings.xml.  Initiates a countdown on the keypress that is cancelled if you
      let go of the binding before the countdown has completed.
]]--

function ReloadUIHandler(msg)
	-- Go to sleep while we reload
	if Chronos then
		if ReloadUI_Config.doEmote then
			DoEmote(ReloadUI_Config.preEmote)
			ReloadUI_Config.reload = true
		end

		if ReloadUI_Config.doDND then
			SendChatMessage(ReloadUI_Config.DNDtext, "DND")
		end
	end

	Sea.io.print(RELOAD_MESSAGE);
	ReloadUI()
end

function ReloadUIDNDHandler( msg )
	if msg == "" and ReloadUI_Config.doDND then
		ReloadUI_Config.doDND = nil
		Sea.io.print(RELOAD_DND_DISABLED)
	else
		ReloadUI_Config.doDND = true
		if msg == "" and not ReloadUI_Config.DNDtext then
			ReloadUI_Config.DNDtext = "Reloading... brb"
		end

		if msg ~= "" then
			ReloadUI_Config.DNDtext = msg
		end

		Sea.io.print( string.format(RELOAD_DND_ENABLED, ReloadUI_Config.DNDtext ) )
	end
end

function ReloadUIEmoteHandler(msg)
	-- Disable on command or toggle if just basic slash command
	if msg == RELOAD_EMOTE_DISABLE or 
		msg == "" and ReloadUI_Config.doEmote then

		ReloadUI_Config.doEmote = nil
		Sea.io.print(RELOAD_EMOTE_DISABLED)

	-- Enable on command or toggle or enable if emotes supplied
	else
		local _, _, msg1, msg2 = string.find(msg, "(%w+)%s(%w+)" )

		ReloadUI_Config.doEmote = true

		if not msg1 and not ReloadUI_Config.preEmote then
			ReloadUI_Config.preEmote = "sleep"
		end
		if not msg2 and not ReloadUI_Config.postEmote then
			ReloadUI_Config.postEmote = "sit"
		end

		if msg1 and msg2 then
			ReloadUI_Config.preEmote = msg1
			ReloadUI_Config.postEmote = msg2
		end

		Sea.io.print( string.format(RELOAD_EMOTE_ENABLED, ReloadUI_Config.preEmote, ReloadUI_Config.postEmote) )
	end
end

if ( Satellite ) then
	Satellite.registerSlashCommand(
				 {
					 id = "ReloadUI";
					 commands = RELOAD_COMMANDS;
					 onExecute = ReloadUIHandler;
					 helpText=RELOAD_COMMANDS_DESC;
				 }
			 );
	if Chronos then
		Satellite.registerSlashCommand(
				 {
					 id = "ReloadUIemote";
					 commands = RELOAD_EMOTE_COMMANDS;
					 onExecute = ReloadUIEmoteHandler;
					 helpText=RELOADUI_EMOTE_COMMANDS_DESC;
				 }
			 );
		Satellite.registerSlashCommand(
				 {
					 id = "ReloadUIDND";
					 commands = RELOAD_DND_COMMANDS;
					 onExecute = ReloadUIDNDHandler;
					 helpText=RELOADUI_DND_COMMANDS_DESC;
				 }
			 );
	end
else
	SlashCmdList["RELOADUI_SLASHENABLE"] = ReloadUIHandler
	for i = 1, #RELOAD_COMMANDS do
		setglobal("SLASH_RELOADUI_SLASHENABLE"..i, RELOAD_COMMANDS[i])
	end

	if Chronos then
		SlashCmdList["RELOADUI_SLASHEMOTE"] = ReloadUIEmoteHandler
		for i = 1, #RELOAD_EMOTE_COMMANDS do
			setglobal("SLASH_RELOADUI_SLASHEMOTE"..i, RELOAD_EMOTE_COMMANDS[i])
		end
		SlashCmdList["RELOADUI_SLASHDND"] = ReloadUIDNDHandler
		for i = 1, #RELOAD_DND_COMMANDS do
			setglobal("SLASH_RELOADUI_SLASHDND"..i, RELOAD_DND_COMMANDS[i])
		end
	end
end

if Chronos then
	Chronos.afterInit( function()
		if (not ReloadUI_Config) then
			ReloadUI_Config = {};
		end
		if ReloadUI_Config.reload then
			if ReloadUI_Config.doEmote then
				Chronos.schedule(5, DoEmote, ReloadUI_Config.postEmote)
			end
			if ReloadUI_Config.doDND then
				SendChatMessage("", "DND")
			end

			ReloadUI_Config.reload = nil
		end
	end )
end
