--[[

	QuestLog Level Patch
	
	by sarf
	
	Adds level of quest to the quest log, so that Smurf becomes [15] Smurf.
	
]]--

QuestLogLevelPatch_Options = {
	enabled = true;
};

function QuestLogLevelPatch_QuestLog_Update()
	if ( QuestLogLevelPatch_Options.enabled ) then
		local numEntries, numQuests = GetNumQuestLogEntries();
		local questIndex, questLogTitle, questTitleTag;
		local questLogTitleText, level, questTag, isHeader, isCollapsed, isComplete;
		local tempWidth, textWidth;
		for i=1, QUESTS_DISPLAYED do
			questIndex = i + FauxScrollFrame_GetOffset(QuestLogListScrollFrame);
			questLogTitle = getglobal("QuestLogTitle"..i);
			questTitleTag = getglobal("QuestLogTitle"..i.."Tag");
			questNormalText = getglobal("QuestLogTitle"..i.."NormalText");
			if ( questIndex <= numEntries ) then
				questLogTitleText, level, questTag, isHeader, isCollapsed, isComplete = GetQuestLogTitle(questIndex);
				if ( not isHeader ) then
					local text = "  "..format(QuestLogLevelPatch_Format, level, questLogTitleText)
					questLogTitle:SetText(text);
					QuestLogDummyText:SetText(text);
					if ( questTag ) then
						-- Shrink text to accomdate quest tags without wrapping
						tempWidth = 275 - 15 - questTitleTag:GetWidth();
						if ( QuestLogDummyText:GetWidth() > tempWidth ) then
							textWidth = tempWidth;
						else
							textWidth = QuestLogDummyText:GetWidth();
						end
						questNormalText:SetWidth(tempWidth);
					end
				end
			end
		end
	end
end

hooksecurefunc("QuestLog_Update", QuestLogLevelPatch_QuestLog_Update);

QuestLogLevelPatch_SetEnabled_Inside = false;

function QuestLogLevelPatch_Slash(msg)
	if ( not QuestLogLevelPatch_Options ) then
		QuestLogLevelPatch_Options = {};
	end
	if ( QuestLogLevelPatch_Options.enabled ) then
		QuestLogLevelPatch_Options.enabled = false;
	else
		QuestLogLevelPatch_Options.enabled = true;
	end
	QuestLogLevelPatch_SetEnabled(QuestLogLevelPatch_EnabledValue());
	ChatFrame1:AddMessage(QuestLogLevelPatch_GetEnabledTextState(QuestLogLevelPatch_Options.enabled));
end


function QuestLogLevelPatch_SetEnabled(toggle)
	if ( QuestLogLevelPatch_SetEnabled_Inside ) then
		return;
	end
	QuestLogLevelPatch_SetEnabled_Inside = true;
	if ( toggle == 1 ) then
		QuestLogLevelPatch_Options.enabled = true;
	else
		QuestLogLevelPatch_Options.enabled = false;
	end
	if ( Khaos ) then
		local setId = QUESTLEVEL_KHAOS_SET_EASY_ID;
		local key = "enabled";
		local khaosKey = Khaos.getSetKey(setId, key);
		if ( khaosKey ) then
			Khaos.setSetKeyParameter(setId, key, "checked", QuestLogLevelPatch_Options.enabled);
			if KhaosFrame:IsVisible() then
				Khaos.refresh(false, false, true);
			end
		end
	end
	QuestLogLevelPatch_SetEnabled_Inside = false;
end

function QuestLogLevelPatch_EnabledValue()
	if ( QuestLogLevelPatch_Options.enabled ) then
		return 1;
	else
		return 0;
	end
end

function QuestLogLevelPatch_GetEnabledTextState(enabled)
	local s = QUESTLEVEL_KHAOS_STATE_ENABLED; 
	if ( not enabled ) then 
		s = QUESTLEVEL_KHAOS_STATE_DISABLED; 
	end 
	return QUESTLEVEL_KHAOS_STATE_TEXT.." "..s;
end

function QuestLogLevelPatch_Register_Khaos()
	local optionSetEasy = {
		id = QUESTLEVEL_KHAOS_SET_EASY_ID;
		text = QUESTLEVEL_KHAOS_EASYSET_TEXT;
		helptext = QUESTLEVEL_KHAOS_EASYSET_HELP;
		difficulty = 1;
		options = {};
		default = true;
	};
	local optionEnabled = {
		id = "questLevelCheckBoxEnabled";
		key = "enabled";
		text = QUESTLEVEL_KHAOS_ENABLED_TEXT;
		helptext = QUESTLEVEL_KHAOS_ENABLED_HELPTEXT;
		check = true;
		callback = function(state) QuestLogLevelPatch_Options.enabled = state.checked; QuestLogLevelPatch_SetEnabled(QuestLogLevelPatch_EnabledValue()); end;
		type = K_TEXT;
		feedback = function(state) QuestLogLevelPatch_GetEnabledTextState(state.checked); end;
		default = {
			checked = true;
		};
		disabled = {
			checked = false;
		};
	};
	table.insert(optionSetEasy.options, optionEnabled);
	Khaos.registerOptionSet( "quest", optionSetEasy);
end

local slashCmd = "QUESTLOGLEVELPATCH";
SlashCmdList[slashCmd] = QuestLogLevelPatch_Slash;
for k, v in pairs( QUESTLEVEL_CMDS ) do 
	setglobal("SLASH_"..slashCmd..k, v);
end

if (Khaos) then
	QuestLogLevelPatch_Register_Khaos();
end


