-- Adds Item box to DELETE_ITEM and CONFIRM_LOOT_ROLL

PopupPower.PlugIns.ItemBoxes = {};

function PopupPower.PlugIns.ItemBoxes.Setup()
	-- clear saved item data after it's used on creation
	StaticPopupDialogs["DELETE_ITEM"].OnShow = function()
		StaticPopupDialogs["DELETE_ITEM"].itemTexture = texture;
		StaticPopupDialogs["DELETE_ITEM"].setItemTooltip = nil;
	end
	
	StaticPopupDialogs["CONFIRM_LOOT_ROLL"].OnShow = function()
		StaticPopupDialogs["CONFIRM_LOOT_ROLL"].itemTexture = texture;
		StaticPopupDialogs["CONFIRM_LOOT_ROLL"].setItemTooltip = nil;
	end
	
	--popups with items w/o alerts have to be extrawide
	StaticPopupDialogs["CONFIRM_LOOT_ROLL"].extraWide = 1;
	--StaticPopupDialogs["CONFIRM_LOOT_DISTRIBUTION"].extraWide = 1;
	
	PopupPower.PlugIns.ItemBoxes.PickupContainerItem_Orig = PickupContainerItem;
	PickupContainerItem = PopupPower.PlugIns.ItemBoxes.PickupContainerItem_Hook;
	
	PopupPower.PlugIns.ItemBoxes.RollOnLoot_Orig = RollOnLoot;
	RollOnLoot = PopupPower.PlugIns.ItemBoxes.RollOnLoot_Hook;
end

-- Before Hook
function PopupPower.PlugIns.ItemBoxes.PickupContainerItem_Hook(bag, slot)
	local texture = GetContainerItemInfo(bag, slot);
	if (texture) then
		StaticPopupDialogs["DELETE_ITEM"].itemTexture = texture;
		StaticPopupDialogs["DELETE_ITEM"].setItemTooltip = function()
			GameTooltip:SetBagItem(bag, slot);
		end
	end
	PopupPower.PlugIns.ItemBoxes.PickupContainerItem_Orig(bag, slot);
end

-- Before Hook
function PopupPower.PlugIns.ItemBoxes.RollOnLoot_Hook(id, roll)
	local texture, name = GetLootRollItemInfo(id);
	StaticPopupDialogs["CONFIRM_LOOT_ROLL"].itemTexture = texture;
	StaticPopupDialogs["CONFIRM_LOOT_ROLL"].setItemTooltip = function()
		GameTooltip:SetLootRollItem(id);
	end
	PopupPower.PlugIns.ItemBoxes.RollOnLoot_Orig(id, roll);
end
