--[[
 MonitorStatus v1.6
 Originally made by wharvey 2004-2-23
 Currently maintained by David Hedbor <david@hedbor.org>
 Update to v0.5-0.7 by Joe "JoeFaust" Hartford <joefaust@cosmosui.org>

 changes in version 1.8 (rudy): 2006/02/12
	* removed Chronos dependencies (now using OnUpdate Event)
	* made unitlist to be updated global and initialize it ONCE
	* now using UnitExists() instead of UnitName() to check if unit exists
	* removed local arrays in frequenctly used functions to avoid memory "leakages" 
               (lua does not clean up memory reserved for local arrays until garbage collection)
 changes in version 1.7 (rudy): 2005/11/14
	* fixed a bug with combo points now showing up for druids
	* now displaying if a player lost the link
	* Setting ShowTargetHealthCond now working as intended
 changes in version 1.6 (rudy): 2005/10/21
	* redid the alignment of the XML Frames
	* gaps between target -> player -> party for better visibility
	* new column for malaise info
	* now position of targets are fixed, meaning the display is not that "jumpy" anymore
	* Power Word: Shield and Weakened Soul added to buffs / debuffs
	* Fixed a bug with debuffs not showing up correctly
 changes in version 1.5 (rudy): 2005/09/23
	* added key bindings for enable/disable and onlyDuringCombat toggle
	* added difficulty levels (basic settings, advanced settings)
	* class of party members can now be toggled to be shown or not
	* added HealOverTime info (with config)
	* added Malaise info (poison,desease,...) (with config) thanx to MonitorStatusPlus for inspiration and code example
	* redid mana color scheme for better readability
 Changes in version 1.4 (rudy): 2005/09/11
	* removed * from pets
 Changes in version 1.3 (rudy): 2005/08/25
	* removed cosmos code, added khaos support. thanx to <zispri@mail.ru> for the original work
 Changes in version 1.2 (rudy): 2005/07/22
	* party pets also shown
	* Using same font(size) for all, added * at end of name to mark pets
 Changes in version 1.1 (rudy):
	* new function MonitorStatus_Toggle_GetNewValue( toggle, oldvalue ) to make code more modular/readable
	* new function MonitorStatus_Toggle_UpdateTexts( prefixList ) to make code more modular/generic
	* new config: ColorNames: Colors also names depending on the health
	* new config: ShowCombotPoints: Shows combo points for rogues
	* new config: ShowTargetHealthCond: Shows the verbose messages of health next to the target or not
	* new config: ShowRelativeTargetLevel: Shows the level of the target next to the name in brackets()
	* new config: FlashWhenHitDuration: How long the name should flash when damage was taken (0 not flash at all)
	* fixed a bug with health change not showing up (red "flashing" of name when lower health)  
	* SECONDS_TILL_REVERT removed (replaced by above config)
 Changes in version 1.0:
 	* now updates every .2 seconds with Chronos (by Arys 02-02-05)
 Changes in version 0.9:
  * fixes to show only during combat
 Changes in version 0.8:
  * Ability to show only during combat
  * Ability to hide mana
 Changes in version 0.7:
  * Ability to enable/disable Target, Player, Pet and/or Party stats
 Changes in version 0.6:
  * Ability to show stats as percentage or actual
 Changes in version 0.5:
	* Added Pet stats under the player's
 Updated to v0.4 by Anders "sarf" Kronquist <k@fukt.bth.se>
 Changes in version 0.4:
	* Added Cosmos compatibility
	* Added slash commands / toggle option
	* Refactored code to be slightly less redudant
 Changes in version 0.3:
	* Made into an addon, fixing one loading issue.
	* Fixed bug where info from removed targets / party members wasn't cleared
		correctly.
]]

MonitorStatus_PlayerLastHealth = 0;
MonitorStatus_PlayerTimeStamp = 0;
MonitorStatus_PetLastHealth = 0;
MonitorStatus_PetTimeStamp = 0;
MonitorStatus_TargetLastHealth = 0;
MonitorStatus_TargetTimeStamp = 0;
MonitorStatus_PartyOneLastHealth = 0;
MonitorStatus_PartyOneTimeStamp = 0;
MonitorStatus_PartyTwoLastHealth = 0;
MonitorStatus_PartyTwoTimeStamp = 0;
MonitorStatus_PartyThreeLastHealth = 0;
MonitorStatus_PartyThreeTimeStamp = 0;
MonitorStatus_PartyFourLastHealth = 0;
MonitorStatus_PartyFourTimeStamp = 0;
MonitorStatus_PartyPetOneLastHealth = 0;
MonitorStatus_PartyPetOneTimeStamp = 0;
MonitorStatus_PartyPetTwoLastHealth = 0;
MonitorStatus_PartyPetTwoTimeStamp = 0;
MonitorStatus_PartyPetThreeLastHealth = 0;
MonitorStatus_PartyPetThreeTimeStamp = 0;
MonitorStatus_PartyPetFourLastHealth = 0;
MonitorStatus_PartyPetFourTimeStamp = 0;

MonitorStatus_Enabled = false;
MonitorStatus_ShowPercent = true;
MonitorStatus_ShowTarget = true;
MonitorStatus_ShowPlayer = true;
MonitorStatus_ShowPet = true;
MonitorStatus_ShowParty = true;
MonitorStatus_ShowPartyPet = true;
MonitorStatus_OnlyDuringCombat = false;
MonitorStatus_AllUnitsCombat = false;
MontiorStatus_MobHealth = false;
MonitorStatus_ShowMana = true;
MonitorStatus_ShowInCombat = false;
MonitorStatus_ShowComboPoints = true;
MonitorStatus_ColorName = true;
MonitorStatus_ShowTargetHealthCond = false;
MonitorStatus_ShowRelativeTargetLevel = true;
MonitorStatus_FlashWhenHitDuration = 0.2;
MonitorStatus_ShowClass = true;
MonitorStatus_ShowHOT = true;
MonitorStatus_ShowMalaise = true;

local MonitorStatus_UnitList = {};			-- list with units to be updated/drawn

function MonitorStatus_OnLoad()

	local index = 0;

	this:RegisterEvent("VARIABLES_LOADED");

	this:RegisterEvent("PLAYER_TARGET_CHANGED");
	this:RegisterEvent("PARTY_MEMBERS_CHANGED");
	this:RegisterEvent("PLAYER_PET_CHANGED");

	MonitorStatus_UnitList = { { "target", "Target", "MonitorStatus_ShowTarget" },
	                           { "player", "Player", true },
	                           { "pet", "Pet", "MonitorStatus_ShowPet" },
	                           { "party1", "PartyOne", "MonitorStatus_ShowParty" },
	                           { "party2", "PartyTwo", "MonitorStatus_ShowParty" },
	                           { "party3", "PartyThree", "MonitorStatus_ShowParty" },
	                           { "party4", "PartyFour", "MonitorStatus_ShowParty" },
	                           { "partypet1", "PartyPetOne", "MonitorStatus_ShowPartyPet" },
	                           { "partypet2", "PartyPetTwo", "MonitorStatus_ShowPartyPet" },
	                           { "partypet3", "PartyPetThree", "MonitorStatus_ShowPartyPet" },
	                           { "partypet4", "PartyPetFour", "MonitorStatus_ShowPartyPet" },
				};

--	MonitorStatus_CalculateValues();

end

function MonitorStatus_OnUpdate()
	if ( MonitorStatus:IsVisible() ) then
		MonitorStatus_CalculateValues();
	end
end

function MonitorStatus_IsInCombat() 
        if UnitAffectingCombat("player")  or ( MonitorStatus_AllUnitsCombat and
	   ( MonitorStatus_ShowPet and UnitAffectingCombat("pet") ) or
	   ( MonitorStatus_ShowParty and MonitorStatus_IsPartyInCombat() ) or
	   ( MonitorStatus_ShowPartyPet and MonitorStatus_IsPartyPetInCombat() ) ) then
		return 1;
	else
		return nil;
	end
end

function MonitorStatus_IsPartyInCombat()
   local numPartyMembers = GetNumPartyMembers()
   if numPartyMembers > 0 then
      for i=1, numPartyMembers do
	 if UnitAffectingCombat("party"..i) then
	    return 1
	 end
      end
   end
   return nil
end

function MonitorStatus_IsPartyPetInCombat()
   local numPartyMembers = GetNumPartyMembers()
   if numPartyMembers > 0 then
      for i=1, numPartyMembers do
	 if UnitAffectingCombat("partypet"..i) then
	    return 1
	 end
      end
   end
   return nil
end

function MonitorStatus_CalculateValues()
	-- display all
	for k, v in MonitorStatus_UnitList do
		MonitorStatus_CalculateValuesSpecific( v[1], v[2], v[3] );
	end
end

function MonitorStatus_CalculateValuesSpecific( unitName, prefix, enabled )
	if type(enabled) == "string" then
		enabled = getglobal(enabled);
	end
	local literalHealth, literalMaxHealth, healthPct, manaPct, timeNow, malaiseInfo;
	local conditionLineName, conditionLineR, conditionLineG, conditionLineB;
	local healthColorR, healthColorG, healthColorB;
	local manaColorR, manaColorG, manaColorB;
	
	local conditionText = getglobal(prefix.."StatusConditionText");
	local healthText = getglobal(prefix.."StatusHealthText");
	local nameText = getglobal(prefix.."StatusNameText");
	local manaText = getglobal(prefix.."StatusManaText");
	local malaiseText = getglobal(prefix.."StatusMalaiseText");

	if ( (not enabled) or (not UnitExists(unitName)) or 
             (strsub(unitName,1,8) == 'partypet' and (not UnitExists('party'..strsub(unitName,9)))) or
             (MonitorStatus_OnlyDuringCombat and (not MonitorStatus_IsInCombat())) )
	then
		nameText:SetText("");
		healthText:SetText("");
		malaiseText:SetText("");
		manaText:SetText("");
		conditionText:SetText("");

		return;
	end
	
	timeNow = GetTime();

	-- Use MobHealth values if availble
	if unitName == "target" and MobHealthFrame and MonitorStatus_MobHealth then
		literalHealth = MobHealth_GetTargetCurHP()
		literalMaxHealth = MobHealth_GetTargetMaxHP()
	end

	-- Use UnitHealth otherwise
	if literalHealth == nil then
		literalHealth = UnitHealth(unitName)
	end

	-- Use good old UnitHealthMax otherwise.
	if literalMaxHealth == nil then
		literalMaxHealth = UnitHealthMax( unitName )
	end

	healthPct = (literalHealth * 100.0) / literalMaxHealth
	healthColorR,healthColorG,healthColorB = MonitorStatus_GetHealthColor(healthPct);

	uName = UnitName(unitName);
	if ( unitName == 'target' and MonitorStatus_ShowRelativeTargetLevel ) then
		local targetLevel = UnitLevel("target");
		local diff = '?';
		if ( targetLevel ~= nil and targetLevel > 0 ) then
			diff = targetLevel - UnitLevel( "player" );
			if ( diff > 0 ) then
				diff = '+' .. diff;
			end
		end
		uName = uName.." ("..diff..")";
	end
	if ( MonitorStatus_ShowClass and strsub(unitName,1,5) == 'party' and strsub(unitName,6,8) ~= 'pet' ) then
         	classInfo = UnitClass(unitName);
		if ( classInfo == 'Warlock' ) then
 			classInfo = 'Wlk';
		elseif ( classInfo ~= nil ) then
			classInfo = strsub(classInfo,1,3);
                else
			classInfo = "?";
		end
       		uName = uName .. "[" .. classInfo .. "]";
	end

	uName = MonitorStatus_ExtendedName( unitName, uName );

	nameText:SetText(uName);
	if ( MonitorStatus_ColorName ) then
 		nameText:SetTextColor(healthColorR, healthColorG, healthColorB);
	else
		nameText:SetTextColor( 1, 0.82, 0.0 );
	end

	conditionLineName,conditionLineR,conditionLineG,conditionLineB = MonitorStatus_GetConditionLine(healthPct,unitName);
	conditionText:SetText(conditionLineName);
	conditionText:SetTextColor(conditionLineR, conditionLineG, conditionLineB);

	if ( MonitorStatus_ShowPercent ) then 
		healthPct = string.format("%4.0f", healthPct);
	else
		healthPct = string.format("%d/%d", literalHealth, literalMaxHealth);
	end

	healthText:SetText(healthPct);
	healthText:SetTextColor(healthColorR, healthColorG, healthColorB);

        malaiseInfo = '';
	if ( MonitorStatus_ShowHOT ) then
		malaiseInfo = malaiseInfo .. MonitorStatus_HOT( unitName ) ;
        end
	if ( MonitorStatus_ShowMalaise ) then
		malaiseInfo = malaiseInfo .. MonitorStatus_Malaise( unitName );
        end
        if MonitorStatus_ShowInCombat then
	        malaiseInfo = malaiseInfo .. MonitorStatus_InCombat( unitName )
	end

        if ( malaiseInfo ~= '' ) then
          malaiseInfo = ' ' .. malaiseInfo;
        end

	malaiseText:SetText( malaiseInfo );
	malaiseText:SetTextColor( 1, 1, 1 );

	if ( MonitorStatus_FlashWhenHitDuration > 0 ) then
		if ( literalHealth < getglobal("MonitorStatus_"..prefix.."LastHealth") ) then
			nameText:SetTextColor(1, 0.1, 0.1);
			setglobal("MonitorStatus_"..prefix.."TimeStamp", GetTime());
		else
			local timeStamp = getglobal("MonitorStatus_"..prefix.."TimeStamp");
			if ( (not timeStamp) or (timeStamp == 0) or (timeNow - timeStamp) >= MonitorStatus_FlashWhenHitDuration ) then
				setglobal("MonitorStatus_"..prefix.."TimeStamp", 0);
			else
				nameText:SetTextColor( 1, 0.1, 0.1 );
			end
		end
		setglobal("MonitorStatus_"..prefix.."LastHealth", literalHealth);
	end
	
	if ( MonitorStatus_ShowMana ) then
		manaPct = (UnitMana(unitName) * 100.0) / UnitManaMax(unitName);
		manaColorR,manaColorG,manaColorB = MonitorStatus_GetManaColor(manaPct);

		if (MonitorStatus_ShowPercent ) then
			manaPct = string.format("%4.0f", manaPct);
		else
			manaPct = string.format("%d/%d", UnitMana(unitName), UnitManaMax(unitName));
		end

		if ( MonitorStatus_ShowComboPoints and unitName == 'player' ) then
			if ( UnitClass(unitName) == 'Rogue' or MonitorStatus_GetShapeshiftForm('player') == 'Cat Form' ) then
				manaPct = manaPct.."/"..GetComboPoints();
			end
		end

		manaText:SetText(manaPct);
		manaText:SetTextColor(manaColorR, manaColorG, manaColorB);
	else
		manaText:SetText("");		
	end
end

function MonitorStatus_ExtendedName( unit, name )

  return( name );

end

function MonitorStatus_GetConditionLine(health,unitName)
	local returnLineName,returnLineR,returnLineG,returnLineB = "",0,0,0;
--	local returnLine = {name = "", r = 0, g = 0, b = 0};

	if ( UnitIsPlayer(unitName) and (not UnitIsConnected(unitName)) ) then
		returnLineName = TEXT(MONITORSTATUS_CONDITION_LINKDEAD);
		returnLineR = 0.5;
		returnLineG = 0.5;
		returnLineB = 0.5;
	elseif ( UnitIsDeadOrGhost(unitName) ) then
		if ( UnitIsDead(unitName) ) then
			returnLineName = TEXT(MONITORSTATUS_CONDITION_SLAIN);
		else
			returnLineName = TEXT(MONITORSTATUS_CONDITION_GHOST);
		end
		returnLineR = 0.5;
		returnLineG = 0.5;
		returnLineB = 0.5;
	elseif (health > 60) then
		returnLineName = "";
	elseif (health > 40) then
		if ( unitName ~= 'target' or MonitorStatus_ShowTargetHealthCond == true ) then
			returnLineName = TEXT(MONITORSTATUS_CONDITION_FAIR);
		end
		returnLineR = 1;
		returnLineG = 1;
	elseif (health > 20) then
		if ( unitName ~= 'target' or MonitorStatus_ShowTargetHealthCond == true ) then
			returnLineName = TEXT(MONITORSTATUS_CONDITION_POOR);
		end
		returnLineR = 1;
		returnLineG = 0.45;
	elseif (health > 0) then
		if ( unitName ~= 'target' or MonitorStatus_ShowTargetHealthCond == true ) then
			returnLineName = TEXT(MONITORSTATUS_CONDITION_CRITICAL);
		end
		returnLineR = 1;
		returnLineG = 0.1;
		returnLineB = 0.1;
	else
		returnLineName = TEXT(MONITORSTATUS_CONDITION_SLAIN);
		returnLineR = 0.5;
		returnLineG = 0.5;
		returnLineB = 0.5;
	end
	
	return returnLineName,returnLineR,returnLineG,returnLineB;
end

function MonitorStatus_GetHealthColor(health)
	local returnColorR,returnColorG,returnColorB = 0,0,0;
--	local returnColor = { r = 0, g = 0, b = 0 };
	if (health >= 100) then			-- white
		returnColorR = 1;
		returnColorG = 1;
		returnColorB = 1;
	elseif (health > 80) then		-- green
		returnColorG = 1;
	elseif (health > 60) then		-- light green
		returnColorG = 0.75;
	elseif (health > 40) then		-- yellow
		returnColorR = 1;
		returnColorG = 1;
	elseif (health > 20) then		-- red
		returnColorR = 1;
		returnColorG = 0.45;
	elseif (health > 0) then		-- red
		returnColorR = 1;
		returnColorG = 0.1;
		returnColorB = 0.1;
	else					-- gray
		returnColorR = 0.5;
		returnColorG = 0.5;
		returnColorB = 0.5;
	end
	
	return returnColorR,returnColorG,returnColorB;
end

function MonitorStatus_GetManaColor(mana)
--	local returnColor = { r = 0, g = 0, b = 0 };
	local returnColorR,returnColorG,returnColorB = 0,0,0;

	if (mana >= 100) then			-- white
		returnColorR = 1;
		returnColorG = 1;
		returnColorB = 1;
	elseif (mana > 80) then			-- green
		returnColorG = 1;
	elseif (mana > 60) then			-- light green
		returnColorG = 0.75;
	elseif (mana > 40) then			-- dirty yellow
		returnColorR = 0.75;
		returnColorG = 0.75;
	elseif (mana > 20) then			-- light blue
		returnColorB = 1;
		returnColorG = 1;
	elseif (mana > 0) then			-- darker blue
		returnColorG = 0.75;
		returnColorB = 1;
	else					-- gray
		returnColorR = 0.5;
		returnColorG = 0.5;
		returnColorB = 0.5;
	end

	return returnColorR,returnColorG,returnColorB;
end

function MonitorStatus_HOT( unit )
	local buffTexture;
	local i = 1;
	local buffName;
	local tooltip = MonitorStatus_Tooltip;
	local tooltipLeft1 = MonitorStatus_TooltipTextLeft1;
	local buffString = '';

	-- For some reason I get an error during load time, like the tooltip component isn't there yet
	-- do this check to avoid the error
        if ( (tooltip == nil) or (tooltipLeft1 == nil) ) then
		return '';
	end

	buffTexture = UnitBuff( unit, i );
	while ( buffTexture ) do

		MonitorStatus_Tooltip:SetUnitBuff(unit, i);
		buffName = MonitorStatus_TooltipTextLeft1:GetText();

		if ( buffName == 'Regrowth' ) then
			buffString = buffString ..'G';
		elseif ( buffName == 'Rejuvenation' ) then
			buffString = buffString .. 'J';
		elseif ( buffName == 'Renew' ) then
			buffString = buffString .. 'N';
                elseif ( buffName == 'Power Word: Shield' ) then
			buffString = buffString .. 'S';
		end

		i = i + 1;
		buffTexture = UnitBuff( unit, i );
	end

	if ( buffString ~= '' ) then
		buffString = "|c0000FF00" .. buffString;
	end

	return( buffString );
end

function MonitorStatus_Malaise( unit )
	local debuffTexture;
	local i = 1;
	local debuffType;
	local debuffName;
	local foundPoison = false;
	local foundMagic = false;
	local foundDisease = false;
	local foundCurse = false;
	local tooltip = MonitorStatus_Tooltip;
	local tooltipLeft1 = MonitorStatus_TooltipTextLeft1;
	local tooltipRight1 = MonitorStatus_TooltipTextRight1;
	local debuffString = '';
	local weakenedSoul = false;

	-- For some reason I get an error during load time, like the tooltip component isn't there yet
	-- do this check to avoid the error
        if ( (tooltip == nil) or (tooltipLeft1 == nil) or (tooltipRight1 == nil) ) then
		return '';
	end;

	debuffTexture = UnitDebuff( unit, i );
	while ( debuffTexture ) do

		MonitorStatus_TooltipTextRight1:SetText(nil);
		MonitorStatus_Tooltip:SetUnitDebuff(unit, i);
		debuffType = MonitorStatus_TooltipTextRight1:GetText();
		debuffName = MonitorStatus_TooltipTextLeft1:GetText();

		if (debuffType) then
			if ( debuffType == MONITORSTATUS_MAGIC and (not foundMagic) ) then
				debuffString = debuffString .. 'm';
				foundMagic = true;
			elseif ( debuffType == MONITORSTATUS_DISEASE and (not foundDisease) ) then
				debuffString = debuffString .. 'd';
				foundDisease = true;
			elseif ( debuffType == MONITORSTATUS_POISON and (not foundPoison) ) then
				debuffString = debuffString .. 'p';
				foundPoison = true;
			elseif ( debuffType == MONITORSTATUS_CURSE and (not foundCurse) ) then
				debuffString = debuffString .. 'c';
				foundCurse = true;
			end
		elseif ( debuffName == 'Weakened Soul' ) then
			weakenedSoul = true;
		end

		i = i + 1;
		debuffTexture = UnitDebuff( unit, i );
	end

	if ( debuffString ~= '' ) then
		debuffString = "|c00FF0000" .. debuffString;
	end
	if ( weakenedSoul ) then
		debuffString = debuffString .. "|c00FFAA00" .. 's';
	end

	return( debuffString );
end

-- Check for UnitAffectingCombat and return a string
function MonitorStatus_InCombat( unit )
   if UnitAffectingCombat( unit ) then
      return 'C'
   end
   return ''
end

function MonitorStatus_GetShapeshiftForm( unit )

  if ( UnitClass(unit) == 'Druid' or UnitClass(unit) == 'Warrior' ) then
    local i = 1;
    local icon,name,active,castable = GetShapeshiftFormInfo( i );
    while ( icon and active == nil ) do
      i = i + 1;
      icon,name,active,castable = GetShapeshiftFormInfo( i );
    end
    if ( active == 1 ) then
      return( name );
    end
  end

  return( 'None' );
end

function MonitorStatus_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end

function MonitorStatus_Register_Khaos()
	local optionSet = {
		id="MonitorStatus";
		text=MONITORSTATUS_CONFIG_HEADER;
		helptext=MONITORSTATUS_CONFIG_HEADER_INFO;
		difficulty=1;
		options={
			{
				id="Header";
				text=MONITORSTATUS_CONFIG_HEADER;
				helptext=MONITORSTATUS_CONFIG_HEADER_INFO;
				type=K_HEADER;
				difficulty=1;
			};
			{
				id="Enable";
				type=K_TEXT;
				text=MONITORSTATUS_ENABLED;
				helptext=MONITORSTATUS_ENABLED_INFO;
				callback=MonitorStatus_Toggle_Enabled;
				feedback=function(state) return MONITORSTATUS_ENABLED_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=1;
			};
			{
				id="EnableCombatOnly";
				type=K_TEXT;
				text=MONITORSTATUS_ONLYDURINGCOMBAT;
				helptext=MONITORSTATUS_ONLYDURINGCOMBAT_INFO;
				callback=function(toggle) MonitorStatus_OnlyDuringCombat = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_ONLYDURINGCOMBAT_INFO end;
				check=true;
				default={checked=false};
				disabled={checked=false};
				difficulty=1;
			};
			{
				id="EnableAllUnitsCombat";
				type=K_TEXT;
				text=MONITORSTATUS_ALLUNITSCOMBAT;
				helptext=MONITORSTATUS_ALLUNITSCOMBAT_INFO;
				callback=function(toggle) MonitorStatus_AllUnitsCombat = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_ALLUNITSCOMBAT_INFO end;
				check=true;
				default={checked=false};
				disabled={checked=false};
				difficulty=1;
			};
			{
				id="MobHealth";
				type=K_TEXT;
				text=MONITORSTATUS_MOBHEALTH;
				helptext=MONITORSTATUS_MOBHEALTH_INFO;
				callback=function(toggle) MonitorStatus_MobHealth = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_MOBHEALTH_INFO end;
				check=true;
				default={checked=false};
				disabled={checked=false};
				difficulty=1;
			};
			{
				id="HeaderDifficulty2";
				text=MONITORSTATUS_CONFIG_DIFF2_HEADER;
				helptext=MONITORSTATUS_CONFIG_DIFF2_HEADER_INFO;
				type=K_HEADER;
				difficulty=2;
			};
			{
				id="EnableShowMana";
				type=K_TEXTShow;
				text=MONITORSTATUS_SHOWMANA;
				helptext=MONITORSTATUS_SHOWMANA_INFO;
				callback=function(toggle) MonitorStatus_ShowMana = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWMANA_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnableShowInCombat";
				type=K_TEXTShow;
				text=MONITORSTATUS_SHOWINCOMBAT;
				helptext=MONITORSTATUS_SHOWINCOMBAT_INFO;
				callback=function(toggle) MonitorStatus_ShowInCombat = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWINCOMBAT_INFO end;
				check=true;
				default={checked=false};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnablePercent";
				type=K_TEXT;
				text=MONITORSTATUS_SHOWPERCENT;
				helptext=MONITORSTATUS_SHOWPERCENT_INFO;
				callback=function(toggle) MonitorStatus_ShowPercent = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWPERCENT_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnableTarget";
				type=K_TEXT;
				text=MONITORSTATUS_SHOWTARGET;
				helptext=MONITORSTATUS_SHOWTARGET_INFO;
				callback=function(toggle) MonitorStatus_ShowTarget = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWTARGET_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnablePlayer";
				type=K_TEXT;
				text=MONITORSTATUS_SHOWPLAYER;
				helptext=MONITORSTATUS_SHOWPLAYER_INFO;
				callback=function(toggle) MonitorStatus_ShowPlayer = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWPLAYER_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnablePet";
				type=K_TEXT;
				text=MONITORSTATUS_SHOWPET;
				helptext=MONITORSTATUS_SHOWPET_INFO;
				callback=function(toggle) MonitorStatus_ShowPet = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWPET_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnableParty";
				type=K_TEXT;
				text=MONITORSTATUS_SHOWPARTY;
				helptext=MONITORSTATUS_SHOWPARTY_INFO;
				callback=function(toggle) MonitorStatus_ShowParty = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWPARTY_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnablePartyPet";
				type=K_TEXT;
				text=MONITORSTATUS_SHOWPARTYPET;
				helptext=MONITORSTATUS_SHOWPARTYPET_INFO;
				callback=function(toggle) MonitorStatus_ShowPartyPet = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWPARTYPET_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnableShowClass";
				type=K_TEXT;
				text=MONITORSTATUS_SHOWCLASS;
				helptext=MONITORSTATUS_SHOWCLASS_INFO;
				callback=function(toggle) MonitorStatus_ShowClass = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWCLASS_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnableTargetHealthCond";
				type=K_TEXT;
				text=MONITORSTATUS_SHOWTARGETHEALTHCOND;
				helptext=MONITORSTATUS_SHOWTARGETHEALTHCOND_INFO;
				callback=function(toggle) MonitorStatus_ShowTargetHealthCond = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWTARGETHEALTHCOND_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnableComboPoints";
				type=K_TEXT;
				text=MONITORSTATUS_SHOWCOMBOPOINTS;
				helptext=MONITORSTATUS_SHOWCOMBOPOINTS_INFO;
				callback=function(toggle) MonitorStatus_ShowComboPoints = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWCOMBOPOINTS_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="ShowHOT";
				type=K_TEXT;
				text=MONITORSTATUS_SHOWHOT;
				helptext=MONITORSTATUS_SHOWHOT_INFO;
				callback=function(toggle) MonitorStatus_ShowHOT = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWHOT_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="ShowMalaise";
				type=K_TEXT;
				text=MONITORSTATUS_SHOWMALAISE;
				helptext=MONITORSTATUS_SHOWMALAISE_INFO;
				callback=function(toggle) MonitorStatus_ShowMalaise = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWMALAISE_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnableColorName";
				type=K_TEXT;
				text=MONITORSTATUS_COLORNAME;
				helptext=MONITORSTATUS_COLORNAME_INFO;
				callback=function(toggle) MonitorStatus_ColorName = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_COLORNAME_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnableRelativeTargetLevel";
				type=K_TEXT;
				text=MONITORSTATUS_SHOWRELATIVETARGETLEVEL;
				helptext=MONITORSTATUS_SHOWRELATIVETARGETLEVEL_INFO;
				callback=function(toggle) MonitorStatus_ShowRelativeTargetLevel = (toggle.checked) end;
				feedback=function(state) return MONITORSTATUS_SHOWRELATIVETARGETLEVEL_INFO end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=2;
			};
			{
				id="EnableFlashDuration";
				type=K_SLIDER;
				text=MONITORSTATUS_FLASHWHENHITDURATION;
				helptext=MONITORSTATUS_FLASHWHENHITDURATION_INFO;
				callback=function(state) MonitorStatus_FlashWhenHitDuration = state.slider; end;
				feedback=function(state) return MONITORSTATUS_FLASHWHENHITDURATION_INFO; end;
				check=true;
				default={
			   		checked = true;
			   		slider = 0.2;
				};
				disabled={
			   		checked = false;
			   		slider = 0;
				};
				setup = {
			   		sliderMin = 0.2;
			   		sliderMax = 1;
			   		sliderStep = 0.2;
       					sliderText = MONITORSTATUS_FLASHWHENHITDURATION_TITLE;
			   		sliderDisplayFunc = function (val) return math.floor(val*100)/100; end;
				};
				difficulty=2;
			};
		};
	};
	Khaos.registerOptionSet(
		"combat",
		optionSet
	);
	MonitorStatus_KhaosRegistered = true;
end

function MonitorStatus_OnEvent( event )
	if ( event == "VARIABLES_LOADED" ) then
		MonitorStatus_Register_Khaos();
	elseif ( event == "PLAYER_TARGET_CHANGED" ) then
		targetLastHealth = 0;
		targetTimeStamp = 0;
	elseif ( event == "PLAYER_PET_CHANGED" ) then
		PetLastHealth = 0;
		PetTimestamp = 0;
	elseif ( event == "PARTY_MEMBERS_CHANGED" ) then
		PartyOneLastHealth = 0;
		PartyOneTimeStamp = 0;
		PartyTwoLastHealth = 0;
		PartyTwoTimeStamp = 0;
		PartyThreeLastHealth = 0;
		PartyThreeTimeStamp = 0;
		PartyFourLastHealth = 0;
		PartyFourTimeStamp = 0;
		PartyPetOneLastHealth = 0;
		PartyPetOneTimeStamp = 0;
		PartyPetTwoLastHealth = 0;
		PartyPetTwoTimeStamp = 0;
		PartyPetThreeLastHealth = 0;
		PartyPetThreeTimeStamp = 0;
		PartyPetFourLastHealth = 0;
		PartyPetFourTimeStamp = 0;
	end
end

function MonitorStatus_Update_Window_State(toggle)
	if ( toggle ) then
		MonitorStatus:Show();
	else
		MonitorStatus:Hide();
	end
end

function MonitorStatus_Toggle_Enabled(toggle)
	local state;

	if ( not toggle ) then
		if ( MonitorStatus_Enabled ) then
			state = false;
		else
			state = true;
		end
	else
		state = toggle.checked;
	end

	MonitorStatus_Enabled = state;
	MonitorStatus_Update_Window_State(state);
end

function MonitorStatus_Toggle_OnlyDuringCombat()
	if ( MonitorStatus_OnlyDuringCombat ) then
		MonitorStatus_OnlyDuringCombat = false;
	else
		MonitorStatus_OnlyDuringCombat = true;
	end
end
