--------------------------------------------------------------------------
--DurabilityStatus_Khaos.lua
--------------------------------------------------------------------------
--[[

-- Khaos registration support for DurabilityStatus.

author: <zespriwow@gmail.com>

--]]--

function DurabilityStatus_Register_Khaos()
	local optionSet = {
		id="DurabilityStatus";
		text=DURABILITYSTATUS_CONFIG_HEADER;
		helptext=DURABILITYSTATUS_CONFIG_HEADER_INFO;
		difficulty=1;
		default = true;
		feedback=function(state) return DURABILITYSTATUS_TOGGLE_INFO; end;
		options={
			{
				id="SpellMatsHeader";
				text=DURABILITYSTATUS_CONFIG_HEADER;
				helptext=DURABILITYSTATUS_CONFIG_HEADER_INFO;
				type=K_HEADER;
				difficulty=1;
				default = true;
			};
			{
				id="showMerchant";
				type=K_TEXT;
				text=DURABILITYSTATUS_CONFIG_MERCHANT;
				helptext=DURABILITYSTATUS_CONFIG_MERCHANT_INFO;
				callback=function(state) DurStatusOpt.showMerchant = state.checked; end;
				feedback=function(state) return DURABILITYSTATUS_CONFIG_MERCHANT_INFO; end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=1;
			};
			{
				id="showWindow";
				type=K_TEXT;
				text=DURABILITYSTATUS_CONFIG_WINDOW;
				helptext=DURABILITYSTATUS_CONFIG_WINDOW_INFO;
				callback=function(state) DurStatusOpt.showWindow = state.checked if (state.checked) then DS_Window:Show() else DS_Window:Hide() end; end;
				feedback=function(state) return DURABILITYSTATUS_CONFIG_WINDOW_INFO; end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=1;
			};
			{
				id="lockWindow";
				type=K_TEXT;
				text=DURABILITYSTATUS_CONFIG_LOCK;
				helptext=DURABILITYSTATUS_CONFIG_LOCK_INFO;
				callback=function(state) DurStatusOpt.lockWindow = state.checked end;
				feedback=function(state) return DURABILITYSTATUS_CONFIG_LOCK_INFO; end;
				check=true;
				default={checked=false};
				disabled={checked=false};
				difficulty=1;
			};
			{
				id="showReport";
				type=K_TEXT;
				text=DURABILITYSTATUS_CONFIG_REPORT;
				helptext=DURABILITYSTATUS_CONFIG_REPORT_INFO;
				callback=function(state) DurStatusOpt.showReport = state.checked; end;
				feedback=function(state) return DURABILITYSTATUS_CONFIG_REPORT_INFO; end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=1;
			};
			{
				id="showAverage";
				type=K_TEXT;
				text=DURABILITYSTATUS_CONFIG_AVERAGE;
				helptext=DURABILITYSTATUS_CONFIG_AVERAGE_INFO;
				callback=function(state) DurStatusOpt.showAverage = state.checked; DurabilityStatus_BagUpdate(); end;
				feedback=function(state) return DURABILITYSTATUS_CONFIG_AVERAGE_INFO; end;
				check=true;
				default={checked=true};
				disabled={checked=false};
				difficulty=1;
			};
		};
	};
	Khaos.registerOptionSet(
		"inventory",
		optionSet
	);
end
