----------------------------------------------------------------------------------------
--[[ NOTE FOR LOCALIZATION: Class names in all caps should *never* be localized,	]]-- 
--[[	as they correspond to the second return value from UnitClass()				]]--
--[[	This is also the case for the fake class names for pets -- BEAST, IMP,		]]--
--[[	VOIDWALKER, SUCCUBUS, and FELHUNTER.										]]--
----------------------------------------------------------------------------------------

-- Addon identification
DIVINEBLESSING_VERSION						= "3.2 [BC]"

-- Cosmos / Khaos registration
DIVINEBLESSING_KHAOS_ID						= "DivineBlessing"
DIVINEBLESSING_BUTTON_NAME					= "Divine Blessing"
DIVINEBLESSING_BUTTON_SUBTITLE				= "Blessing Sets"
DIVINEBLESSING_BUTTON_DESCRIPTION			= "Provides a simple way to organize\nspells to buff your party or raid"
DIVINEBLESSING_BUTTON_ICON					= "Interface\\Icons\\Spell_Holy_SealOfFury"

-- Slash commands
SLASH_BLESS1								= "/bless"
SLASH_DIVINEBLESSING1						= "/divineblessing"
SLASH_DIVINEBLESSING2						= "/db"

DIVINEBLESSING_CMD_RESET					= "reset"
DIVINEBLESSING_CMD_RESETALL					= "resetall"

-- Slash Command Regex
DIVINEBLESSING_REGEX_CHAT_COMMAND			= "^([^ ]+) (.+)$"

-- Usage text
DIVINEBLESSING_USAGE_MESSAGE = {
		[1]		= "|cffeeee66DivineBlessing Usage:|r (|cffeeee66/db|r can be used in place of |cffeeee66/divineblessing|r)",
		[2]		= " |cffeeee66/divineblessing|r : Toggle the Divine Blessing configuration window",
		[3]		= " |cffeeee66/divineblessing help|r : Display this help message",
		[4]		= " |cffeeee66/divineblessing reset <set>|r : Reset the specified set to the beginning",
		[5]		= " |cffeeee66/divineblessing resetall|r : Reset all sets to the beginning",
		[6]		= " |cffeeee66/bless <set>|r : Cast the next spell in the specified set",
		[7]		= " Valid set names are:",
		[8]		= "     |cffeeee66party1|r - |cffeeee66party6|r for party sets",
		[9]		= "     |cffeeee66class1|r for class-based party buffing",
		[10]	= "     |cffeeee66raid1|r or |cffeeee66raid2|r for class-based raid buffing",
	}

-- Messages
DIVINEBLESSING_LOADED_FORMAT_STRING			= "|cffffff00Divine Blessing "..DIVINEBLESSING_VERSION.."|r |cffeeeeaaloaded.|r  Type |cffeeeeaa/divineblessing help|r for more information."
DIVINEBLESSING_MESSAGE_PREFIX				= "|cffeeee66[DivineBlessing]|r "
DIVINEBLESSING_RESET_MESSAGE				= "%s reset to the beginning"
DIVINEBLESSING_RESETALL_MESSAGE				= "All sets reset to the beginning"
DIVINEBLESSING_FMT_MISSED_MESSAGE			= "%s missed the following targets:"

-- Key Bindings
BINDING_HEADER_DIVINEBLESSING 				= "Divine Blessing"
--BINDING_NAME_BLESSINGSET1 					= "Use Party Blessing Set 1"
--BINDING_NAME_BLESSINGSET2 					= "Use Party Blessing Set 2"
--BINDING_NAME_BLESSINGSET3 					= "Use Party Blessing Set 3"
--BINDING_NAME_BLESSINGSET4 					= "Use Party Blessing Set 4"
--BINDING_NAME_BLESSINGSET5 					= "Use Party Blessing Set 5"
--BINDING_NAME_BLESSINGSET6 					= "Use Party Blessing Set 6"
--BINDING_NAME_BLESSINGSETCLASS 				= "Use Class Blessing Set"
--BINDING_NAME_BLESSINGSETRAID				= "Use Raid Blessing Set 1"
--BINDING_NAME_BLESSINGSETRAID2				= "Use Raid Blessing Set 2"
BINDING_NAME_BLESSINGSHOW					= "Toggle Divine Blessing Config"

-- Creature types
DIVINEBLESSING_CREATURE_TYPE_BEAST			= "Beast"
DIVINEBLESSING_CREATURE_TYPE_DEMON			= "Demon"
DIVINEBLESSING_CREATURE_FAMILIES_DEMONS		= 
	{
		["Imp"]			= "IMP",
		["Voidwalker"]	= "VOIDWALKER",
		["Succubus"]	= "SUCCUBUS",
		["Felhunter"]	= "FELHUNTER",
	}

-- Spell name localization
DIVINEBLESSING_SPELL_BLESSING_OF_FREEDOM	= "Blessing of Freedom"
DIVINEBLESSING_SPELL_BLESSING_OF_KINGS		= "Blessing of Kings"
DIVINEBLESSING_SPELL_BLESSING_OF_LIGHT		= "Blessing of Light"
DIVINEBLESSING_SPELL_BLESSING_OF_MIGHT		= "Blessing of Might"
DIVINEBLESSING_SPELL_BLESSING_OF_PROTECTION	= "Blessing of Protection"
DIVINEBLESSING_SPELL_BLESSING_OF_SACRIFICE	= "Blessing of Sacrifice"
DIVINEBLESSING_SPELL_BLESSING_OF_SALVATION	= "Blessing of Salvation"
DIVINEBLESSING_SPELL_BLESSING_OF_SANCTUARY	= "Blessing of Sanctuary"
DIVINEBLESSING_SPELL_BLESSING_OF_WISDOM		= "Blessing of Wisdom"
DIVINEBLESSING_SPELL_GBLESSING_OF_KINGS		= "Greater Blessing of Kings"
DIVINEBLESSING_SPELL_GBLESSING_OF_LIGHT		= "Greater Blessing of Light"
DIVINEBLESSING_SPELL_GBLESSING_OF_MIGHT		= "Greater Blessing of Might"
DIVINEBLESSING_SPELL_GBLESSING_OF_SALVATION	= "Greater Blessing of Salvation"
DIVINEBLESSING_SPELL_GBLESSING_OF_SANCTUARY	= "Greater Blessing of Sanctuary"
DIVINEBLESSING_SPELL_GBLESSING_OF_WISDOM	= "Greater Blessing of Wisdom"
DIVINEBLESSING_SPELL_ARCANE_INTELLECT		= "Arcane Intellect"
DIVINEBLESSING_SPELL_ARCANE_BRILLIANCE		= "Arcane Brilliance"
DIVINEBLESSING_SPELL_AMPLIFY_MAGIC			= "Amplify Magic"
DIVINEBLESSING_SPELL_DAMPEN_MAGIC			= "Dampen Magic"
DIVINEBLESSING_SPELL_POWER_WORD_FORTITUDE	= "Power Word: Fortitude"
DIVINEBLESSING_SPELL_PRAYER_OF_FORTITUDE	= "Prayer of Fortitude"
DIVINEBLESSING_SPELL_DIVINE_SPIRIT			= "Divine Spirit"
DIVINEBLESSING_SPELL_PRAYER_OF_SPIRIT		= "Prayer of Spirit"
DIVINEBLESSING_SPELL_POWER_WORD_SHIELD		= "Power Word: Shield"
DIVINEBLESSING_SPELL_SHADOW_PROTECTION		= "Shadow Protection"
DIVINEBLESSING_SPELL_PRAYER_OF_SHADOW_PROTECTION	= "Prayer of Shadow Protection"
DIVINEBLESSING_SPELL_RENEW					= "Renew"
DIVINEBLESSING_SPELL_ABOLISH_DISEASE		= "Abolish Disease"
DIVINEBLESSING_SPELL_POWER_INFUSION			= "Power Infusion"
DIVINEBLESSING_SPELL_FEAR_WARD				= "Fear Ward"
DIVINEBLESSING_SPELL_MARK_OF_THE_WILD		= "Mark of the Wild"
DIVINEBLESSING_SPELL_GIFT_OF_THE_WILD		= "Gift of the Wild"
DIVINEBLESSING_SPELL_THORNS					= "Thorns"
DIVINEBLESSING_SPELL_REJUVENATION			= "Rejuvenation"
DIVINEBLESSING_SPELL_REGROWTH				= "Regrowth"
DIVINEBLESSING_SPELL_ABOLISH_POISON			= "Abolish Poison"
DIVINEBLESSING_SPELL_DETECT_LESSER_INVIS	= "Detect Lesser Invisibility"
DIVINEBLESSING_SPELL_DETECT_INVIS			= "Detect Invisibility"
DIVINEBLESSING_SPELL_DETECT_GREATER_INVIS	= "Detect Greater Invisibility"
DIVINEBLESSING_SPELL_UNENDING_BREATH		= "Unending Breath"

-- Message localization
DIVINEBLESSING_FMT_SETNAME_PARTY			= "Party Set %d"
DIVINEBLESSING_FMT_SETNAME_PARTY_ONE		= "Party Set"
DIVINEBLESSING_FMT_SETNAME_CLASS			= "Class Set %d"
DIVINEBLESSING_FMT_SETNAME_CLASS_ONE		= "Class Set"
DIVINEBLESSING_FMT_SETNAME_RAID				= "Raid Set %d"
DIVINEBLESSING_FMT_SETNAME_RAID_ONE			= "Raid Set"
DIVINEBLESSING_FMT_SETNAME_UNKNOWN			= "Unknown Set %d"
DIVINEBLESSING_FMT_SPELLRANK				= "Rank %d"
DIVINEBLESSING_FMT_GROUP					= "Group %d"
DIVINEBLESSING_FMT_PETNAME					= "%s (%s's pet)"
DIVINEBLESSING_UNKNOWN_SPELL				= "UNKNOWN SPELL"
DIVINEBLESSING_UNKNOWN_TARGET				= "UNKNOWN TARGET"
DIVINEBLESSING_CLASS_NAMES_PLURAL			=
	{
		["DRUID"]		= "Druids",
		["HUNTER"]		= "Hunters",
		["MAGE"]		= "Mages",
		["PALADIN"]		= "Paladins",
		["PRIEST"]		= "Priests",
		["ROGUE"]		= "Rogues",
		["SHAMAN"]		= "Shamans",
		["WARLOCK"]		= "Warlocks",
		["WARRIOR"]		= "Warriors",
		["BEAST"]		= "Beasts",
		["IMP"]			= "Imps",
		["VOIDWALKER"]	= "Voidwalkers",
		["SUCCUBUS"]	= "Succubi",
		["FELHUNTER"]	= "Felhunters",
	}

DIVINEBLESSING_FMT_CAST_SUCCESS				= "%s cast on %s"
DIVINEBLESSING_FMT_CAST_SUCCESS_REM			= "%s cast on %s (%d remaining)"
DIVINEBLESSING_FMR_CAST_SUCCESS_REM_0		= "%s cast on %s (Set Complete)"
DIVINEBLESSING_FMT_CAST_FAILURE				= "%s failed to cast on %s"
DIVINEBLESSING_FMT_CAST_FAILURE_REM			= "%s failed to cast on %s (%d remaining)"
DIVINEBLESSING_FMT_CAST_FAILURE_REM_0		= "%s failed to cast on %s (Set Complete)"
DIVINEBLESSING_FMT_SET_COMPLETED			= "%s Completed"

-- SYSMSG values to watch for casting failure
DIVINEBLESSING_SPELLFAIL_NOTENOUGHMANA		= "Not enough mana"
DIVINEBLESSING_SPELLFAIL_INVALIDTARGET		= "Invalid target"
DIVINEBLESSING_SPELLFAIL_LINEOFSIGHT		= "Target not in line of sight"
DIVINEBLESSING_SPELLFAIL_OUTOFRANGE			= "Out of range."

-- Dialog localization
DIVINEBLESSING_DIALOG_TITLE					= "|cffee9966Divine Blessing|r ("..DIVINEBLESSING_VERSION..")"
DIVINEBLESSING_DIALOG_TAB_PARTY				= "Party"
DIVINEBLESSING_DIALOG_TAB_CLASS				= "Class"
DIVINEBLESSING_DIALOG_TAB_RAID				= "Raid"
DIVINEBLESSING_DIALOG_TAB_OPTIONS			= "Options"
DIVINEBLESSING_DIALOG_TAB_HELP				= "Help"
DIVINEBLESSING_DIALOG_BUTTON_KEYBIND		= "Key Bindings"
DIVINEBLESSING_DIALOG_BUTTON_CLEAR			= "Clear"
DIVINEBLESSING_DIALOG_BUTTON_RESET			= "Reset Index"
DIVINEBLESSING_DIALOG_BUTTON_OVERRIDE		= "Override friendly target"
DIVINEBLESSING_DIALOG_BUTTON_WAIT			= "Wait"
DIVINEBLESSING_DIALOG_BUTTON_COMPLETION		= "Announce set completion"
DIVINEBLESSING_DIALOG_BUTTON_SUCCESS		= "Announce success"
DIVINEBLESSING_DIALOG_BUTTON_FAILURE		= "Announce failure"
DIVINEBLESSING_DIALOG_BUTTON_REMAINING		= "Announce remaining casts"
DIVINEBLESSING_DIALOG_BUTTON_BANNER			= "Banner announcements"
DIVINEBLESSING_DIALOG_BUTTON_MISSED			= "Announce missed targets"
DIVINEBLESSING_DIALOG_BUTTON_REBUFF_MISSED	= "Rebuff targets missed by multitarget spells"
DIVINEBLESSING_DIALOG_BUTTON_GROUPORDER		= "Buff raids in group order instead of id order"
DIVINEBLESSING_DIALOG_BUTTON_FIND_TARGET	= "Buff in-range class/group if current target is not"
DIVINEBLESSING_DIALOG_PET_BLESSING			= "Pet Blessing"
DIVINEBLESSING_DIALOG_CLASS_BLESSING		= "Class Blessing Set"
DIVINEBLESSING_DIALOG_RAID_BLESSING			= "Raid Blessing Set"
DIVINEBLESSING_DIALOG_RAID_GROUPS			= "Target Groups"
DIVINEBLESSING_DIALOG_FMT_GROUP				= "Group %d"
DIVINEBLESSING_MENU_CLOSE_MENU				= "Close Menu"
DIVINEBLESSING_MENU_NO_SPELL				= "No Spell"
DIVINEBLESSING_DIALOG_UNKNOWN_SPELL			= "[Unknown Spell]"
DIVINEBLESSING_DIALOG_TARGET_NAMES			=
	{
		["player"]		= "Player",
		["party1"]		= "Party1",
		["party2"]		= "Party2",
		["party3"]		= "Party3",
		["party4"]		= "Party4",
		["pet"]			= "Pet",
		["partypet1"]	= "Pet1",
		["partypet2"]	= "Pet2",
		["partypet3"]	= "Pet3",
		["partypet4"]	= "Pet4",
	}
DIVINEBLESSING_DIALOG_CLASS_BUTTON_LABELS	=
	{
		["DRUID"]		= "Druid",
		["HUNTER"]		= "Hunter",
		["MAGE"]		= "Mage",
		["PALADIN"]		= "Paladin",
		["PRIEST"]		= "Priest",
		["ROGUE"]		= "Rogue",
		["SHAMAN"]		= "Shaman",
		["WARLOCK"]		= "Warlock",
		["WARRIOR"]		= "Warrior",
		["IMP"]			= "Imp",
		["VOIDWALKER"]	= "Void",
		["SUCCUBUS"]	= "Succ",
		["FELHUNTER"]	= "Fel",
		["BEAST"]		= "Beast",
		["ALL"]			= "Set All",
	}

DIVINEBLESSING_DIALOG_HELP_TEXT				=
	"|cffee9966Divine Blessing|r lets you create sets of spells to simplify buffing a party or raid.\n"..
	"\n"..
	"|cffffffffSet Types:|r\n"..
	"    There are three types of sets:\n"..
	"\n"..
	"|cff4444ffParty|r sets let you assign spells to specific party slots by position in the party.\n"..
	"\n"..
	"|cff33ff33Class|r sets let you assign spells to cast based on the class (or pet type) of your target.\n"..
	"\n"..
	"|cffffff00Raid|r sets work like |cff33ff33Class|r sets, except they cycle through an entire raid instead of your party.  Additionally, |cffffff00Raid|r sets can be restricted to cast only on specific raid groups.\n"..
	"\n"..
	"|cffffffffPutting Spells Into Sets:|r\n"..
	"    To place spells in a set, you can either drag spells to them from the spellbook, or you can right-click on the spell icon to display a list of known buffs.  Choosing a buff from that menu will place it in the slot you clicked on.\n"..
	"\n"..
	"|cffffffffCasting Spells From Sets:|r\n"..
	"    Once you have configured a set, you can cast spells from it (one at a time) either by hitting the keybinding associated with that set (configurable in the Key Bindings menu), or by using a macro with the correct slash command for that set in it.\n"..
	"The slash command syntax is:\n"..
	"\n"..
	"/bless <set>\n"..
	"\n"..
	"where <set> can be party1 through party6 (for the six party sets), class (the class set), raid1 (the first raid set) or raid2 (the second raid set).  So, for example, to cast the second party set, the slash command would be:\n"..
	"\n"..
	"/bless party2\n"..
	"\n"..
	"You cannot use the /bless slash command simply by typing it in, it must be used in a macro, due to limitations set by Blizzard to prevent automated casting scripts.\n"..
	"\n"..
	"Only one spell will be cast for each time you press the keybinding or macro button.  To cast the next spell in sequence, you must press the keybinding or macro button again."
