if ( not DivineBlessing ) then DivineBlessing = {} end

--[[
--	NOTES: The buff information contains spell rank level information, and
--	target type information, used to cast more intelligently (currently used
--	for level restrictions and smart target removal based on spell target types)
--
--	The format of each table below is as follows:
--
--	DivineBlessing.Buffs[ raw_class_name ] = 
--		{
--			[ spell_name ] = 
--				{
--					target = "class" for spells that target all raidmembers of certain class,
--							 "group" for spells that target all in a single group,
--							 nil otherwise
--					ranks = { levels the ranks are learned, in order, separated by commas },
--				}
--		}
--
--		where:
--
--		raw_class_name	- the second return from UnitClass(), which should be the
--							same across all locales.  These are the enUS class names
--							in full uppercase.
--		spell_name		- the localized name for the spell.  Use a constant and then
--							localize the constant in the appropriate localization.lua
--]]

DivineBlessing.Buffs				= {}
DivineBlessing.Buffs["DRUID"] =
	{
		[ DIVINEBLESSING_SPELL_MARK_OF_THE_WILD ] = { ranks = { 1, 10, 20, 30, 40, 50, 60 } },
		[ DIVINEBLESSING_SPELL_GIFT_OF_THE_WILD ] = { ranks = { 50, 60 }, target = DivineBlessing.TARGET_GROUP },
		[ DIVINEBLESSING_SPELL_THORNS ] = { ranks = { 6, 14, 24, 34, 44, 54 } },
		[ DIVINEBLESSING_SPELL_REJUVENATION ] = { ranks = { 4, 10, 16, 22, 28, 34, 40, 46, 52, 58, 60 } },
		[ DIVINEBLESSING_SPELL_REGROWTH ] = { ranks = { 12, 18, 24, 30, 36, 42, 48, 54, 60 } }, 
		[ DIVINEBLESSING_SPELL_ABOLISH_POISON ] = { ranks = { 26 } },
	}
DivineBlessing.Buffs["MAGE"] =
	{
		[ DIVINEBLESSING_SPELL_ARCANE_INTELLECT ] = { ranks = { 1, 14, 28, 42, 56 } },
		[ DIVINEBLESSING_SPELL_ARCANE_BRILLIANCE ] = { ranks = { 56 }, target = DivineBlessing.TARGET_GROUP },
		[ DIVINEBLESSING_SPELL_AMPLIFY_MAGIC ] = { ranks = { 18, 30, 42, 54, 60 } },
		[ DIVINEBLESSING_SPELL_DAMPEN_MAGIC ] = { ranks = { 12, 24, 36, 48, 60 } },
	}
DivineBlessing.Buffs["PALADIN"]		=
	{
		[ DIVINEBLESSING_SPELL_BLESSING_OF_FREEDOM ] = { ranks = { 18 } },
		[ DIVINEBLESSING_SPELL_BLESSING_OF_KINGS ] = { ranks = { 40 } },
		[ DIVINEBLESSING_SPELL_BLESSING_OF_LIGHT ] = { ranks = { 40, 50, 60 } },
		[ DIVINEBLESSING_SPELL_BLESSING_OF_MIGHT ] = { ranks = { 4, 12, 22, 32, 42, 52, 60 } },
		[ DIVINEBLESSING_SPELL_BLESSING_OF_PROTECTION ] = { ranks = { 10, 24, 38 } },
		[ DIVINEBLESSING_SPELL_BLESSING_OF_SACRIFICE ] = { ranks = { 46, 54 } },
		[ DIVINEBLESSING_SPELL_BLESSING_OF_SALVATION ] = { ranks = { 26 } },
		[ DIVINEBLESSING_SPELL_BLESSING_OF_SANCTUARY ] = { ranks = { 30, 40, 50, 60 } },
		[ DIVINEBLESSING_SPELL_BLESSING_OF_WISDOM ] = { ranks = { 14, 24, 34, 44, 54, 60 } },
		[ DIVINEBLESSING_SPELL_GBLESSING_OF_KINGS ] = { ranks = { 60 }, target = DivineBlessing.TARGET_CLASS },
		[ DIVINEBLESSING_SPELL_GBLESSING_OF_LIGHT ] = { ranks = { 60 }, target = DivineBlessing.TARGET_CLASS },
		[ DIVINEBLESSING_SPELL_GBLESSING_OF_MIGHT ] = { ranks = { 60, 60 }, target = DivineBlessing.TARGET_CLASS },
		[ DIVINEBLESSING_SPELL_GBLESSING_OF_SALVATION ] = { ranks = { 60 }, target = DivineBlessing.TARGET_CLASS },
		[ DIVINEBLESSING_SPELL_GBLESSING_OF_SANCTUARY ] = { ranks = { 60 }, target = DivineBlessing.TARGET_CLASS },
		[ DIVINEBLESSING_SPELL_GBLESSING_OF_WISDOM ] = { ranks = { 60, 60 }, target = DivineBlessing.TARGET_CLASS },
	}
DivineBlessing.Buffs["PRIEST"] =
	{
		[ DIVINEBLESSING_SPELL_POWER_WORD_FORTITUDE ] = { ranks = { 1, 12, 24, 36, 48, 60 } },
		[ DIVINEBLESSING_SPELL_PRAYER_OF_FORTITUDE ] = { ranks = { 48, 60 }, target = DivineBlessing.TARGET_GROUP },
		[ DIVINEBLESSING_SPELL_DIVINE_SPIRIT ] = { ranks = { 30, 40, 50, 60 } },
		[ DIVINEBLESSING_SPELL_PRAYER_OF_SPIRIT ] = { ranks = { 60 }, target = DivineBlessing.TARGET_GROUP },
		[ DIVINEBLESSING_SPELL_POWER_WORD_SHIELD ] = { ranks = { 6, 12, 18, 24, 30, 36, 42, 48, 54, 60 } },
		[ DIVINEBLESSING_SPELL_SHADOW_PROTECTION ] = { ranks = { 30, 42, 56 } },
		[ DIVINEBLESSING_SPELL_PRAYER_OF_SHADOW_PROTECTION ] = { ranks = { 56 }, target = DivineBlessing.TARGET_GROUP },
		[ DIVINEBLESSING_SPELL_RENEW ] = { ranks = { 8, 14, 20, 26, 32, 38, 44, 50, 56, 60 } },
		[ DIVINEBLESSING_SPELL_ABOLISH_DISEASE ] = { ranks = { 32 } },
		[ DIVINEBLESSING_SPELL_POWER_INFUSION ] = { ranks = { 40 } },
		[ DIVINEBLESSING_SPELL_FEAR_WARD ] = { ranks = { 20 } },
	}
DivineBlessing.Buffs["WARLOCK"] =
	{
		[ DIVINEBLESSING_SPELL_DETECT_LESSER_INVIS ] = { ranks = { 26 } },
		[ DIVINEBLESSING_SPELL_DETECT_INVIS ] = { ranks = { 38 } },
		[ DIVINEBLESSING_SPELL_DETECT_GREATER_INVIS ] = { ranks = { 50 } },
		[ DIVINEBLESSING_SPELL_UNENDING_BREATH ] = { ranks = { 16 } },
	}
