--------------------------------------------------------------------------
-- ChatScroll.lua 
--------------------------------------------------------------------------
--[[
ChatScroll

author: AnduinLothar    <karlkfi@cosmosui.org>

-ChatFrame Mouse Wheel Scroll

Change List
v2.1
- Prepared for Lua 5.1
- Removed Localization usage
v2.0
- No longer uses hidden frames, now uses script element hooks
- No longer supports PopUI or TransUI, I recomend using VisibilityOptions to hide the buttons.
- Added Shift-MouseWheelUp to to to the top of the chat window
- Added Shift-MouseWheelDown to to to the bottom of the chat window
- Added Scroll to Top Binding
v1.1
- Fixed negative framelevel bug in new patch
- Updated the TOC to 1300.
v1.1
- Initial Release

]]--

-- <= == == == == == == == == == == == == =>
-- => Function Definition
-- <= == == == == == == == == == == == == =>

--local function TEXT(key) return Localization.GetString("ChatScroll", key) end
local function TEXT(key) return getglobal(key) end

function ChatFrame_OnMouseWheel(chatframe, value)
	if ( ChatScroll_Enabled ) then
		if ( IsShiftKeyDown() ) then
			if ( value > 0 ) then
				chatframe:ScrollToTop()
			elseif ( value < 0 ) then
				chatframe:ScrollToBottom();
			end
		else
			if ( value > 0 ) then
				chatframe:ScrollUp();
			elseif ( value < 0 ) then
				chatframe:ScrollDown();
			end
		end
	else
		if ( value > 0 ) then
			ActionBar_PageUp();
		elseif ( value < 0 ) then
			ActionBar_PageDown();
		end
	end
end

function ChatScroll_SetUpChatFrameScrollHooks()
	for i=1, 7 do
		local frame = getglobal("ChatFrame"..i);
		frame:EnableMouseWheel(1);
		local oldFunc = frame:GetScript("OnMouseWheel");
		if (type(oldFunc) == "function") then
			frame:SetScript("OnMouseWheel", function() oldFunc(); ChatFrame_OnMouseWheel(this, arg1); end);
		else
			frame:SetScript("OnMouseWheel", function() ChatFrame_OnMouseWheel(this, arg1); end);
		end
	end
end

function ChatScroll_ScrollToTop()
	SELECTED_DOCK_FRAME:ScrollToTop();
end

function ChatScroll_Register_Khaos()
	local optionSet = {
		id="ChatScroll";
		text=function() return TEXT("CHATSCROLL_CONFIG_HEADER") end;
		helptext=function() return TEXT("CHATSCROLL_CONFIG_HEADER_INFO") end;
		callback=function(state) if (state) then ChatScroll_Enabled = true; else ChatScroll_Enabled = nil; end end;
		feedback=function(state) if (state) then return TEXT("CHATSCROLL_CHAT_ENABLED"); else return TEXT("CHATSCROLL_CHAT_DISABLED"); end end;
		difficulty=1;
		default={checked=true};
		options={
			{
				id="Header";
				text=function() return TEXT("CHATSCROLL_CONFIG_HEADER") end;
				helptext=function() return TEXT("CHATSCROLL_CONFIG_HEADER_INFO") end;
				type=K_HEADER;
				difficulty=1;
			};
		};
	};
	Khaos.registerOptionSet(
		"chat",
		optionSet
	);
	ChatScroll_Khaos_Registered = true;
end

-- <= == == == == == == == == == == == == =>
-- => Execution
-- <= == == == == == == == == == == == == =>

ChatScroll_Enabled = true;

--Localization.SetAddonDefault("ChatScroll", "enUS");
--Localization.AssignAddonGlobalStrings("ChatScroll");

ChatScroll_SetUpChatFrameScrollHooks();

if (Khaos) then
	ChatScroll_Register_Khaos();
end
