--[[
	BuffOptionsConfig
	 	Configuration options for BuffOptions
	
	By: Mugendai
	Contact: mugekun@gmail.com
	
	This registers all of the configurations options with MCom to allow the user to
	modify the config options, either by slash commands, or a user interface.
	
	$Id: BuffOptionsConfig.lua 4176 2006-10-14 18:55:08Z geowar $
	$Rev: 4176 $
	$LastChangedBy: geowar $
	$Date: 2006-10-14 13:55:08 -0500 (Sat, 14 Oct 2006) $
]]--

--------------------------------------------------
--
-- Configuration Registration
--
--------------------------------------------------
BuffOptions.Register = function ()
	--Smart register all the options
	--Register a header
	MCom.registerSmart( {
		uifolder = "frames";																	--The Khaos folder to put the option in
		uisec = "BuffOptions";															--The section for the UI
		uiseclabel = BUFFOPTIONS_CONFIG_SECTION;						--The label for the section in the UI
		uisecdesc = BUFFOPTIONS_CONFIG_SECTION_INFO;				--The description for the section in the UI
		uisecdiff = 1;																			--The section's difficulty in Khaos
		uisecdef = false;																		--Whether the section should be default enabled or not in Khaos
		uiseccall = nil;																		--A callback to be called when the section is enabled/disabled in Khaos
		uidiff = 1;																					--The option's difficulty in Khaos
		uicat = MYADDONS_CATEGORY_OTHERS;										--The category to use for MyAddOns
		uiver = BuffOptions.VERSION;												--The version number to display in the UI
		uiframe = "BuffOptionsFrame";												--The frame to identify this addon by
		uioptionsframe = nil;																--The name of the frame to display when the MyAddOns option button is pushed
		supercom = {"/buffoptions", "/bfo"};								--The main slash command, and any aliases for it
		comaction = "before";																--See Sky for info on this
		comsticky = false;																	--See Sky for info on this
		comhelp = BUFFOPTIONS_CHAT_COMMAND_INFO;						--The help text to show for the slash command
		name = BUFFOPTIONS_CONFIG_SECTION;									--The name of the addon, for display in the info text
		infotext = BUFFOPTIONS_CONFIG_INFOTEXT;							--The text to show when the help function is called
		uiauthor = "Mugendai";
		uiwww = "http://www.curse-gaming.com/mod.php?addid=2130";
		uimail = "mugekun@gmail.com";
		mcomtable = {
			{
				uivar = "BuffOptionsSep";														--The option name for the UI
				uitype = K_HEADER;																	--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_MAIN_HEADER;						--The label to use for the seperator in the UI
				uidesc = BUFFOPTIONS_CONFIG_MAIN_HEADER_INFO;				--The description to use for the seperator in the UI
			};
			{
				hasbool = true;																			--True if the option has a boolean portion
				uitype = K_TEXT;																		--The option type for the UI
				uidiff = 2;																					--The option's difficulty in Khaos
				update = function ()	BuffOptions.ReOrient();				--A command to perform when the option is succesfully updated
															BuffOptions.SaveConfig(); end;
				mcomtable = {
					--Register a checkbox, and a boolean sub slash command for Reverse
					{
						uivar = "BuffOptionsReverse";												--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_REVERSE;								--The label to use for the checkbox in the UI
						uidesc = BUFFOPTIONS_CONFIG_REVERSE_INFO;						--The description to use for the checkbox in the UI
						varbool = "BuffOptions_Config.Reverse";							--The boolean variable associate with this option
						uicheck = BuffOptions_Config.Reverse;								--The default value for the checkbox in the UI
						subcom = {"reverse", "rev"};												--The sub slash command and any aliases for this option
					};
					--Register a checkbox, and a boolean sub slash command for Swap
					{
						uivar = "BuffOptionsSwap";													--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_SWAP;									--The label to use for the checkbox in the UI
						uidesc = BUFFOPTIONS_CONFIG_SWAP_INFO;							--The description to use for the checkbox in the UI
						varbool = "BuffOptions_Config.Swap";								--The boolean variable associate with this option
						uicheck = BuffOptions_Config.Swap;									--The default value for the checkbox in the UI
						subcom = {"swap", "sw"};														--The sub slash command and any aliases for this option
					};
					--Register a checkbox, and a boolean sub slash command for ByMap
					{
						uivar = "BuffOptionsByMap";													--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_BYMAP;									--The label to use for the checkbox in the UI
						uidesc = BUFFOPTIONS_CONFIG_BYMAP_INFO;							--The description to use for the checkbox in the UI
						varbool = "BuffOptions_Config.ByMap";								--The boolean variable associate with this option
						uicheck = BuffOptions_Config.ByMap;									--The default value for the checkbox in the UI
						subcom = {"bymap", "bm"};														--The sub slash command and any aliases for this option
					};
				};
			};
			--Register a slider, and a number sub slash command for Size
			{
				uivar = "BuffOptionsSize";													--The option name for the UI
				uitype = K_SLIDER;																	--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_SIZE;									--The label to use for the option in the UI
				uidesc = BUFFOPTIONS_CONFIG_SIZE_INFO;							--The description to use for the option in the UI
				uidiff = 2;																					--The option's difficulty in Khaos
				varnum = "BuffOptions_Config.Size";									--The number variable associate with this option
				update = function ()	BuffOptions.UpdateSize();			--A command to perform when the option is succesfully updated
															BuffOptions.UpdateText();
															BuffOptions.SaveConfig(); end;
				uislider = BuffOptions_Config.Size;									--The default value for the slider in the UI
				uimin = 0.5;																				--The minimum value for the slider in the UI
				uimax = 2;																					--The maximum value for the slider in the UI
				uitext = BUFFOPTIONS_CONFIG_SIZE_TEXT;							--The text to show above the slider in the UI
				uistep = 0.05;																			--The increment to increase the slider in the UI
				uitexton = 1;																				--Whether to show the exact value of the slider in the UI or not
				uisuffix = BUFFOPTIONS_CONFIG_SIZE_SUFFIX;					--The suffix to place after the slider value
				uimul = 100;																				--What to multiply the actual value of the slider by when showing the value in the UI
				subcom = {"size", "sz"};														--The sub slash command and any aliases for this option
			};
			
			--Register a seperator
			{
				uivar = "BuffOptionsVerticalSep";										--The option name for the UI
				uitype = "SEPARATOR";																--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_VERTICAL_HEADER;				--The label to use for the seperator in the UI
				uidesc = BUFFOPTIONS_CONFIG_VERTICAL_HEADER_INFO;		--The description to use for the seperator in the UI
			};
			{
				hasbool = true;																			--True if the option has a boolean portion
				uitype = K_TEXT;																		--The option type for the UI
				update = function ()	BuffOptions.ReOrient();				--A command to perform when the option is succesfully updated
															BuffOptions.UpdateText();
															BuffOptions.SaveConfig(); end;
				mcomtable = {
					--Register a checkbox, and a boolean sub slash command for Vertical
					{
						uivar = "BuffOptionsVertical";											--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_VERTICAL;							--The label to use for the checkbox in the UI
						uidesc = BUFFOPTIONS_CONFIG_VERTICAL_INFO;					--The description to use for the checkbox in the UI
						varbool = "BuffOptions_Config.Vertical";						--The boolean variable associate with this option
						uicheck = BuffOptions_Config.Vertical;							--The default value for the checkbox in the UI
						subcom = {"vertical", "vert"};											--The sub slash command and any aliases for this option
					};
					--Register a checkbox, and a boolean sub slash command for SideTime
					{
						uivar = "BuffOptionsSideTime";											--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_SIDETIME;							--The label to use for the checkbox in the UI
						uidesc = BUFFOPTIONS_CONFIG_SIDETIME_INFO;					--The description to use for the checkbox in the UI
						uidep = { ["BuffOptionsVertical"] = { checked = true } };
						varbool = "BuffOptions_Config.SideTime";						--The boolean variable associate with this option
						uicheck = BuffOptions_Config.SideTime;							--The default value for the checkbox in the UI
						supercom = "/buffoptions";													--The main(super) slash command associated with this subommand
						subcom = {"sidetime", "st"};												--The sub slash command and any aliases for this option
					};
					--Register a checkbox, and a boolean sub slash command for Text
					{
						uivar = "BuffOptionsText";													--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_TEXT;									--The label to use for the checkbox in the UI
						uidesc = BUFFOPTIONS_CONFIG_TEXT_INFO;							--The description to use for the checkbox in the UI
						uidep = { ["BuffOptionsVertical"] = { checked = true } };
						varbool = "BuffOptions_Config.Text";								--The boolean variable associate with this option
						uicheck = BuffOptions_Config.Text;									--The default value for the checkbox in the UI
						subcom = {"text", "tx"};														--The sub slash command and any aliases for this option
					};
					--Register a checkbox, and a boolean sub slash command for DebuffType
					{
						uivar = "BuffOptionsDebuffType";										--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_DEBUFFTYPE;						--The label to use for the checkbox in the UI
						uidesc = BUFFOPTIONS_CONFIG_DEBUFFTYPE_INFO;				--The description to use for the checkbox in the UI
						uidiff = 2;																					--The option's difficulty in Khaos
						uidep = {	["BuffOptionsVertical"] = { checked = true };
											["BuffOptionsText"] = { checked = true }; };
						varbool = "BuffOptions_Config.DebuffType";					--The boolean variable associate with this option
						uicheck = BuffOptions_Config.DebuffType;						--The default value for the checkbox in the UI
						subcom = {"debufftype", "dbt"};											--The sub slash command and any aliases for this option
					};
				};
			};
			--Register a checkbox, and a boolean sub slash command for NoRight
			{
				hasbool = true;																			--True if the option has a boolean portion
				uivar = "BuffOptionsNoRight";												--The option name for the UI
				uitype = K_TEXT;																		--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_NORIGHT;								--The label to use for the checkbox in the UI
				uidesc = BUFFOPTIONS_CONFIG_NORIGHT_INFO;						--The description to use for the checkbox in the UI
				uidiff = 3;																					--The option's difficulty in Khaos
				uidep = { ["BuffOptionsVertical"] = { checked = true } };
				varbool = "BuffOptions_Config.NoRight";							--The boolean variable associate with this option
				update = function ()	BuffOptions.ReOrient();				--A command to perform when the option is succesfully updated
															BuffOptions.SaveConfig(); end;
				uicheck = BuffOptions_Config.NoRight;								--The default value for the checkbox in the UI
				subcom = {"noright", "nr"};													--The sub slash command and any aliases for this option
			};
			
			--Register a seperator
			{
				uivar = "BuffOptionsTextSep";												--The option name for the UI
				uitype = "SEPARATOR";																--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_TEXT_HEADER;						--The label to use for the seperator in the UI
				uidesc = BUFFOPTIONS_CONFIG_TEXT_HEADER_INFO;				--The description to use for the seperator in the UI
			};
			{
				hasbool = true;																			--True if the option has a boolean portion
				uitype = K_TEXT;																		--The option type for the UI
				update = function ()	BuffOptions.ReOrient();				--A command to perform when the option is succesfully updated
															BuffOptions.UpdateText();
															BuffOptions.SaveConfig(); end;
				mcomtable = {
					--Register a checkbox, and a boolean sub slash command for LongTime
					{
						uivar = "BuffOptionsLongTime";										--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_LONGTIME;						--The label to use for the checkbox in the UI
						uidesc = BUFFOPTIONS_CONFIG_LONGTIME_INFO;				--The description to use for the checkbox in the UI
						uidep = { ["BuffOptionsVertical"] = { checked = true };
											["BuffOptionsShortTime"] = { checked = false }; };
						varbool = "BuffOptions_Config.LongTime";					--The boolean variable associate with this option
						uicheck = BuffOptions_Config.LongTime;						--The default value for the checkbox in the UI
						subcom = {"longtime", "lt"};											--The sub slash command and any aliases for this option
					};
					--Register a checkbox, and a boolean sub slash command for ShortTime
					{
						uivar = "BuffOptionsShortTime";										--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_SHORTTIME;						--The label to use for the checkbox in the UI
						uidesc = BUFFOPTIONS_CONFIG_SHORTTIME_INFO;				--The description to use for the checkbox in the UI
						varbool = "BuffOptions_Config.ShortTime";					--The boolean variable associate with this option
						uicheck = BuffOptions_Config.ShortTime;						--The default value for the checkbox in the UI
						subcom = {"shorttime", "st"};											--The sub slash command and any aliases for this option
					};
				};
			};
			--Register a checkbox, and a boolean sub slash command for FadeTime
			{
				hasbool = true;																		--True if the option has a boolean portion
				uivar = "BuffOptionsFadeTime";										--The option name for the UI
				uitype = K_TEXT;																	--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_FADETIME;						--The label to use for the checkbox in the UI
				uidesc = BUFFOPTIONS_CONFIG_FADETIME_INFO;				--The description to use for the checkbox in the UI
				varbool = "BuffOptions_Config.FadeTime";					--The boolean variable associate with this option
				uicheck = BuffOptions_Config.FadeTime;						--The default value for the checkbox in the UI
				subcom = {"fadetime", "ft"};											--The sub slash command and any aliases for this option
			};
			--Register a color sub slash command for TextColor
			{
				uivar = "BuffOptionsTextColor";											--The option name for the UI
				uitype = K_COLORPICKER;															--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_TEXTCOLOR;							--The label to use for the option in the UI
				uidesc = BUFFOPTIONS_CONFIG_TEXTCOLOR_INFO;					--The description to use for the option in the UI
				uidiff = 2;																					--The option's difficulty in Khaos
				varcolor = "BuffOptions_Config.TextColor";					--The color variable associated with this option
				uicolor = BuffOptions_Config.TextColor;							--The default value for the color in the UI
				subcom = {"textcolor", "tc"};												--The sub slash command and any aliases for this option
			};
			--Register a color sub slash command for TextShortColor
			{
				uivar = "BuffOptionsTextShortColor";								--The option name for the UI
				uitype = K_COLORPICKER;															--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_TEXTSHORTCOLOR;				--The label to use for the option in the UI
				uidesc = BUFFOPTIONS_CONFIG_TEXTSHORTCOLOR_INFO;		--The description to use for the option in the UI
				uidiff = 2;																					--The option's difficulty in Khaos
				varcolor = "BuffOptions_Config.TextShortColor";			--The color variable associated with this option
				uicolor = BuffOptions_Config.TextShortColor;				--The default value for the color in the UI
				subcom = {"textshortcolor", "tsc"};									--The sub slash command and any aliases for this option
			};
			--Register a slider, and a number sub slash command for TextSize
			{
				uivar = "BuffOptionsTextSize";											--The option name for the UI
				uitype = K_SLIDER;																	--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_TEXTSIZE;							--The label to use for the option in the UI
				uidesc = BUFFOPTIONS_CONFIG_TEXTSIZE_INFO;					--The description to use for the option in the UI
				uidiff = 2;																					--The option's difficulty in Khaos
				varnum = "BuffOptions_Config.TextSize";							--The number variable associate with this option
				update = function ()	BuffOptions.UpdateTextSize();	--A command to perform when the option is succesfully updated
															BuffOptions.UpdateText();
															BuffOptions.SaveConfig(); end;
				uislider = BuffOptions_Config.TextSize;							--The default value for the slider in the UI
				uimin = 0.5;																				--The minimum value for the slider in the UI
				uimax = 2;																				--The maximum value for the slider in the UI
				uitext = BUFFOPTIONS_CONFIG_TEXTSIZE_TEXT;					--The text to show above the slider in the UI
				uistep = 0.05;																			--The increment to increase the slider in the UI
				uitexton = 1;																				--Whether to show the exact value of the slider in the UI or not
				uisuffix = BUFFOPTIONS_CONFIG_SIZE_SUFFIX;					--The suffix to place after the slider value
				uimul = 100;																				--What to multiply the actual value of the slider by when showing the value in the UI
				subcom = {"textsize", "ts"};												--The sub slash command and any aliases for this option
			};
		
			--Register a seperator
			{
				uivar = "BuffOptionsBorderSep";											--The option name for the UI
				uitype = "SEPARATOR";																--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_BORDER_HEADER;					--The label to use for the seperator in the UI
				uidesc = BUFFOPTIONS_CONFIG_BORDER_HEADER_INFO;			--The description to use for the seperator in the UI
			};
			--Register a checkbox, and a boolean sub slash command for Border
			{
				hasbool = true;																			--True if the option has a boolean portion
				uivar = "BuffOptionsBorder";												--The option name for the UI
				uitype = K_TEXT;																		--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_BORDER;								--The label to use for the checkbox in the UI
				uidesc = BUFFOPTIONS_CONFIG_BORDER_INFO;						--The description to use for the checkbox in the UI
				varbool = "BuffOptions_Config.Border";							--The boolean variable associate with this option
				update = function ()	BuffOptions.ReOrient();				--A command to perform when the option is succesfully updated
															BuffOptions.SaveConfig(); end;
				uicheck = BuffOptions_Config.Border;								--The default value for the checkbox in the UI
				subcom = {"border", "bor"};													--The sub slash command and any aliases for this option
			};
			{
				hasopacity = true;																	--The option can have the opacity value set
				uitype = K_COLORPICKER;															--The option type for the UI
				uidiff = 2;																					--The option's difficulty in Khaos
				update = function ()	BuffOptions.UpdateBorder();		--A command to perform when the option is succesfully updated
															BuffOptions.SaveConfig(); end;
				mcomtable = {
					--Register a color sub slash command for BorderColor
					{
						uivar = "BuffOptionsBorderColor";										--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_BORDERCOLOR;						--The label to use for the option in the UI
						uidesc = BUFFOPTIONS_CONFIG_BORDERCOLOR_INFO;				--The description to use for the option in the UI
						varcolor = "BuffOptions_Config.BorderColor";				--The color variable associated with this option
						uicolor = BuffOptions_Config.BorderColor;						--The default value for the color in the UI
						subcom = {"bordercolor", "bc"};											--The sub slash command and any aliases for this option
					};
					--Register a color sub slash command for BackColor
					{
						uivar = "BuffOptionsBackColor";											--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_BACKCOLOR;							--The label to use for the option in the UI
						uidesc = BUFFOPTIONS_CONFIG_BACKCOLOR_INFO;					--The description to use for the option in the UI
						varcolor = "BuffOptions_Config.BackColor";					--The color variable associated with this option
						uicolor = BuffOptions_Config.BackColor;							--The default value for the color in the UI
						subcom = {"backcolor", "bgc"};											--The sub slash command and any aliases for this option
					};
					--Register a color sub slash command for DebuffBorderColor
					{
						uivar = "BuffOptionsDebuffBorderColor";							--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_DEBUFFBORDERCOLOR;			--The label to use for the option in the UI
						uidesc = BUFFOPTIONS_CONFIG_DEBUFFBORDERCOLOR_INFO;	--The description to use for the option in the UI
						varcolor = "BuffOptions_Config.DebuffBorderColor";	--The color variable associated with this option
						uicolor = BuffOptions_Config.DebuffBorderColor;			--The default value for the color in the UI
						subcom = {"debuffbordercolor", "dbc"};							--The sub slash command and any aliases for this option
					};
					--Register a color sub slash command for DebuffBackColor
					{
						uivar = "BuffOptionsDebuffBackColor";								--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_DEBUFFBACKCOLOR;				--The label to use for the option in the UI
						uidesc = BUFFOPTIONS_CONFIG_DEBUFFBACKCOLOR_INFO;		--The description to use for the option in the UI
						varcolor = "BuffOptions_Config.DebuffBackColor";		--The color variable associated with this option
						uicolor = BuffOptions_Config.DebuffBackColor;				--The default value for the color in the UI
						subcom = {"debuffbackcolor", "dbgc"};								--The sub slash command and any aliases for this option
					};
					--Register a color sub slash command for EquipBorderColor
					{
						uivar = "BuffOptionsEquipBorderColor";							--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_EQUIPBORDERCOLOR;			--The label to use for the option in the UI
						uidesc = BUFFOPTIONS_CONFIG_EQUIPBORDERCOLOR_INFO;	--The description to use for the option in the UI
						varcolor = "BuffOptions_Config.EquipBorderColor";		--The color variable associated with this option
						uicolor = BuffOptions_Config.EquipBorderColor;			--The default value for the color in the UI
						subcom = {"equipbordercolor", "ebc"};								--The sub slash command and any aliases for this option
					};
					--Register a color sub slash command for EquipBackColor
					{
						uivar = "BuffOptionsEquipBackColor";								--The option name for the UI
						uilabel = BUFFOPTIONS_CONFIG_EQUIPBACKCOLOR;				--The label to use for the option in the UI
						uidesc = BUFFOPTIONS_CONFIG_EQUIPBACKCOLOR_INFO;		--The description to use for the option in the UI
						varcolor = "BuffOptions_Config.EquipBackColor";			--The color variable associated with this option
						uicolor = BuffOptions_Config.EquipBackColor;				--The default value for the color in the UI
						subcom = {"equipbackcolor", "ebgc"};								--The sub slash command and any aliases for this option
					};
				};
			};

			--Register a seperator
			{
				uivar = "BuffOptionsReminderSep";										--The option name for the UI
				uitype = "SEPARATOR";																--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_REMINDER_HEADER;				--The label to use for the seperator in the UI
				uidesc = BUFFOPTIONS_CONFIG_REMINDER_HEADER_INFO;		--The description to use for the seperator in the UI
			};
			--Register a slider, and a number sub slash command for Reminder
			{
				hasbool = true;
				uivar = "BuffOptionsReminder";											--The option name for the UI
				uitype = K_SLIDER;																	--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_REMINDER;							--The label to use for the option in the UI
				uidesc = BUFFOPTIONS_CONFIG_REMINDER_INFO;					--The description to use for the option in the UI
				varbool = "BuffOptions_Config.Reminder";						--The number variable associate with this option
				varnum = "BuffOptions_Config.ReminderTime";					--The number variable associate with this option
				uicheck = BuffOptions_Config.Reminder;							--The default value for the checkbox in the UI
				uislider = BuffOptions_Config.ReminderTime;					--The default value for the slider in the UI
				uimin = 0;																					--The minimum value for the slider in the UI
				uimax = 300;																				--The maximum value for the slider in the UI
				uitext = BUFFOPTIONS_CONFIG_REMINDER_TEXT;					--The text to show above the slider in the UI
				uistep = 10;																				--The increment to increase the slider in the UI
				uitexton = 1;																				--Whether to show the exact value of the slider in the UI or not
				uisuffix = BUFFOPTIONS_CONFIG_REMINDER_SUFFIX;			--The suffix to place after the slider value
				uimul = 1;																					--What to multiply the actual value of the slider by when showing the value in the UI
				subcom = {"reminder", "rem"};												--The sub slash command and any aliases for this option
			};
			--Register a checkbox, and a boolean sub slash command for RemindGroup
			{
				hasbool = true;																			--True if the option has a boolean portion
				uivar = "BuffOptionsRemindGroup";										--The option name for the UI
				uitype = K_TEXT;																		--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_REMINDGROUP;						--The label to use for the checkbox in the UI
				uidesc = BUFFOPTIONS_CONFIG_REMINDGROUP_INFO;				--The description to use for the checkbox in the UI
				uidiff = 2;																					--The option's difficulty in Khaos
				uidep = { ["BuffOptionsReminder"] = { checked = true } };
				varbool = "BuffOptions_Config.RemindGroup";					--The boolean variable associate with this option
				uicheck = BuffOptions_Config.RemindGroup;						--The default value for the checkbox in the UI
				subcom = {"remindgroup", "rgroup", "rg"};						--The sub slash command and any aliases for this option
			};
			--Register a checkbox, and a boolean sub slash command for RemindGroupNotMine
			{
				hasbool = true;																			--True if the option has a boolean portion
				uivar = "BuffOptionsRemindGroupNotMine";						--The option name for the UI
				uitype = K_TEXT;																		--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_REMINDGROUPNOTMINE;		--The label to use for the checkbox in the UI
				uidesc = BUFFOPTIONS_CONFIG_REMINDGROUPNOTMINE_INFO;--The description to use for the checkbox in the UI
				uidiff = 2;																					--The option's difficulty in Khaos
				uidep = { ["BuffOptionsReminder"] = { checked = true };
									["BuffOptionsRemindGroup"] = { checked = true } };
				varbool = "BuffOptions_Config.RemindGroupNotMine";	--The boolean variable associate with this option
				update = BuffOptions.SaveConfig;										--A command to perform when the option is succesfully updated
				uicheck = BuffOptions_Config.RemindGroupNotMine;		--The default value for the checkbox in the UI
				subcom = {"notmine", "nm"};													--The sub slash command and any aliases for this option
			};
			--Register a checkbox, and a boolean sub slash command for ReminderSound
			{
				hasbool = true;																			--True if the option has a boolean portion
				uivar = "BuffOptionsReminderSound";									--The option name for the UI
				uitype = K_TEXT;																		--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_REMINDERSOUND;					--The label to use for the checkbox in the UI
				uidesc = BUFFOPTIONS_CONFIG_REMINDERSOUND_INFO;			--The description to use for the checkbox in the UI
				uidep = { ["BuffOptionsReminder"] = { checked = true } };
				varbool = "BuffOptions_Config.ReminderSound";				--The boolean variable associate with this option
				uicheck = BuffOptions_Config.ReminderSound;					--The default value for the checkbox in the UI
				subcom = {"remindersound", "rsound", "rs"};					--The sub slash command and any aliases for this option
			};
			--Register a color sub slash command for ReminderColor
			{
				uivar = "BuffOptionsReminderColor";									--The option name for the UI
				uitype = K_COLORPICKER;															--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_REMINDERCOLOR;					--The label to use for the option in the UI
				uidesc = BUFFOPTIONS_CONFIG_REMINDERCOLOR_INFO;			--The description to use for the option in the UI
				uidiff = 2;																					--The option's difficulty in Khaos
				uidep = { ["BuffOptionsReminder"] = { checked = true } };
				varcolor = "BuffOptions_Config.ReminderColor";			--The color variable associated with this option
				update = function ()	ChangeActionBarPage();				--A command to perform when the option is succesfully updated
															BuffOptions.SaveConfig(); end;
				uicolor = BuffOptions_Config.ReminderColor;					--The default value for the color in the UI
				subcom = {"remindercolor", "rc"};										--The sub slash command and any aliases for this option
			};
			--Register a checkbox, and a boolean sub slash command for ReminderOSD
			{
				hasbool = true;																			--True if the option has a boolean portion
				uivar = "BuffOptionsReminderOSD";										--The option name for the UI
				uitype = K_TEXT;																		--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_REMINDEROSD;						--The label to use for the checkbox in the UI
				uidesc = BUFFOPTIONS_CONFIG_REMINDEROSD_INFO;				--The description to use for the checkbox in the UI
				uidiff = 2;																					--The option's difficulty in Khaos
				uidep = { ["BuffOptionsReminder"] = { checked = true } };
				varbool = "BuffOptions_Config.ReminderOSD";					--The boolean variable associate with this option
				uicheck = BuffOptions_Config.ReminderOSD;						--The default value for the checkbox in the UI
				subcom = {"reminderosd", "rosd", "ro"};							--The sub slash command and any aliases for this option
			};
			--Register a checkbox, and a boolean sub slash command for EquipmentOnly
			{
				hasbool = true;																			--True if the option has a boolean portion
				uivar = "BuffOptionsEquipmentOnly";									--The option name for the UI
				uitype = K_TEXT;																		--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_EQUIPMENTONLY;					--The label to use for the checkbox in the UI
				uidesc = BUFFOPTIONS_CONFIG_EQUIPMENTONLY_INFO;			--The description to use for the checkbox in the UI
				uidiff = 2;																					--The option's difficulty in Khaos
				uidep = { ["BuffOptionsReminder"] = { checked = true } };
				varbool = "BuffOptions_Config.EquipmentOnly";				--The boolean variable associate with this option
				update = function ()	BuffOptions.ReOrient();				--A command to perform when the option is succesfully updated
															BuffOptions.SaveConfig(); end;
				uicheck = BuffOptions_Config.EquipmentOnly;					--The default value for the checkbox in the UI
				subcom = {"equipmentonly", "eo"};										--The sub slash command and any aliases for this option
			};
			--Register a slider, and a number sub slash command for NoShort
			{
				hasbool = true;
				uivar = "BuffOptionsNoShort";												--The option name for the UI
				uitype = K_SLIDER;																	--The option type for the UI
				uilabel = BUFFOPTIONS_CONFIG_NOSHORT;								--The label to use for the option in the UI
				uidesc = BUFFOPTIONS_CONFIG_NOSHORT_INFO;						--The description to use for the option in the UI
				uidiff = 2;																					--The option's difficulty in Khaos
				uidep = { ["BuffOptionsReminder"] = { checked = true } };
				varbool = "BuffOptions_Config.NoShort";							--The number variable associate with this option
				varnum = "BuffOptions_Config.ShortBuffTime";				--The number variable associate with this option
				uicheck = BuffOptions_Config.NoShort;								--The default value for the checkbox in the UI
				uislider = BuffOptions_Config.ShortBuffTime;						--The default value for the slider in the UI
				uimin = 1;																					--The minimum value for the slider in the UI
				uimax = 120;																				--The maximum value for the slider in the UI
				uitext = BUFFOPTIONS_CONFIG_NOSHORT_TEXT;						--The text to show above the slider in the UI
				uistep = 1;																					--The increment to increase the slider in the UI
				uitexton = 1;																				--Whether to show the exact value of the slider in the UI or not
				uisuffix = BUFFOPTIONS_CONFIG_NOSHORT_SUFFIX;				--The suffix to place after the slider value
				uimul = 1;																					--What to multiply the actual value of the slider by when showing the value in the UI
				subcom = {"noshort", "ns"};													--The sub slash command and any aliases for this option
			};
		};
	} );
end
