--[[
	BarOptionsConfig
	 	Configuration options for BarOptions
	
	By: Mugendai
	Contact: mugekun@gmail.com
	
	This registers all of the configurations options with MCom to allow the user to
	modify the config options, either by slash commands, or a user interface.
	
	$Id$
	$Rev$
	$LastChangedBy$
	$Date$
]]--

--------------------------------------------------
--
-- Configuration Registration
--
--------------------------------------------------
BarOptions.Register = function ()
	--Smart register all the options
	MCom.registerSmart( {
		uifolder = "bars";
		uisec = "BarOptions";
		uiseclabel = BAROPTIONS_CONFIG_SECTION;
		uisecdesc = BAROPTIONS_CONFIG_SECTION_INFO;
		uisecdiff = 1;
		uiver = BarOptions.VERSION;
		uiframe = "BarOptionsFrame";
		supercom = {"/baroptions", "/bo"};
		comaction = "before";
		comsticky = false;
		comhelp = BAROPTIONS_CHAT_COMMAND_INFO;
		name = BAROPTIONS_CONFIG_SECTION;
		infotext = BAROPTIONS_CONFIG_INFOTEXT;
		uiauthor = "Mugendai";
		uiwww = "http://www.curse-gaming.com/mod.php?addid=1486";
		uimail = "mugekun@gmail.com";
		uidiff = 1;
		update = BarOptions.SaveConfig;
		mcomtable = {
			{
				uivar = "BarOptionsBarSep";
				uitype = K_HEADER;
				uilabel = BAROPTIONS_CONFIG_BAR_HEADER;
				uidesc = BAROPTIONS_CONFIG_BAR_HEADER_INFO;
			};
			{
				uivar = "BarOptionsDefaultSetup";
				uitype = K_BUTTON;
				uilabel = BAROPTIONS_CONFIG_DEFAULTSETUP;
				uidesc = BAROPTIONS_CONFIG_DEFAULTSETUP_INFO;
				func = BarOptions.DefaultSetup;
				uitext = BAROPTIONS_CONFIG_DEFAULTSETUP_NAME;
				subcom = {"default"};
				subhelp = BAROPTIONS_CONFIG_DEFAULTSETUP_INFO;
			};
			{
				uivar = "BarOptionsSideBarSetup";
				uitype = K_BUTTON;
				uilabel = BAROPTIONS_CONFIG_SIDEBARSETUP;
				uidesc = BAROPTIONS_CONFIG_SIDEBARSETUP_INFO;
				func = BarOptions.SideBarSetup;
				uitext = BAROPTIONS_CONFIG_SIDEBARSETUP_NAME;
				subcom = {"sidebar"};
				subhelp = BAROPTIONS_CONFIG_SIDEBARSETUP_INFO;
			};
			{
				hasbool = true;
				uitype = K_TEXT;
				uidiff = 2;
				update = function ()	ChangeActionBarPage();
															BarOptions.SaveConfig(); end;
				mcomtable = {
					{
						uivar = "BarOptionsAlternateIDs";
						uilabel = BAROPTIONS_CONFIG_ALTERNATEIDS;
						uidesc = BAROPTIONS_CONFIG_ALTERNATEIDS_INFO;
						varbool = "BarOptions_Config.AlternateIDs";
						textname = BAROPTIONS_CHAT_ALTERNATEIDS;
						uicheck = BarOptions_Config.AlternateIDs;
						subcom = {"alternateids", "aid"};
						subhelp = BAROPTIONS_CONFIG_ALTERNATEIDS_INFO;
					};
					{
						uivar = "BarOptionsTurnPages";
						uilabel = BAROPTIONS_CONFIG_TURNPAGES;
						uidesc = BAROPTIONS_CONFIG_TURNPAGES_INFO;
						varbool = "BarOptions_Config.TurnPages";
						textname = BAROPTIONS_CHAT_TURNPAGES;
						uicheck = BarOptions_Config.TurnPages;
						subcom = {"turnpages", "tp"};
						subhelp = BAROPTIONS_CONFIG_TURNPAGES_INFO;
					};
					{
						uivar = "BarOptionsGroupPages";
						uilabel = BAROPTIONS_CONFIG_GROUPPAGES;
						uidesc = BAROPTIONS_CONFIG_GROUPPAGES_INFO;
						varbool = "BarOptions_Config.GroupPages";
						textname = BAROPTIONS_CHAT_GROUPPAGES;
						uicheck = BarOptions_Config.GroupPages;
						subcom = {"grouppages", "gp"};
						subhelp = BAROPTIONS_CONFIG_GROUPPAGES_INFO;
					};
					{
						uivar = "BarOptionsStanceBar";
						uilabel = BAROPTIONS_CONFIG_STANCEBAR;
						uidesc = BAROPTIONS_CONFIG_STANCEBAR_INFO;
						varbool = "BarOptions_Config.StanceBar";
						textname = BAROPTIONS_CHAT_STANCEBAR;
						uicheck = BarOptions_Config.StanceBar;
						subcom = {"stancebar", "sb"};
						subhelp = BAROPTIONS_CONFIG_STANCEBAR_INFO;
					};
					{
						uivar = "BarOptionsHideEmpty";
						uilabel = BAROPTIONS_CONFIG_HIDEEMPTY;
						uidesc = BAROPTIONS_CONFIG_HIDEEMPTY_INFO;
						varbool = "BarOptions_Config.HideEmpty";
						textname = BAROPTIONS_CHAT_HIDEEMPTY;
						uicheck = BarOptions_Config.HideEmpty;
						subcom = {"hideempty", "he"};
						subhelp = BAROPTIONS_CONFIG_HIDEEMPTY_INFO;
					};
				};
			};
			{
				uivar = "BarOptionsMoveMainBarSep";
				uitype = K_HEADER;
				uilabel = BAROPTIONS_CONFIG_MOVEMAINBAR_HEADER;
				uidesc = BAROPTIONS_CONFIG_MOVEMAINBAR_HEADER_INFO;
				uidiff = 2;
			};
			{
				hasbool = true;
				uitype = K_TEXT;
				uidiff = 2;
				update = function ()	BarOptions.MoveMainBar();
															BarOptions.SaveConfig(); end;
				mcomtable = {
					{
						uivar = "BarOptionsMainBarCenter";
						uilabel = BAROPTIONS_CONFIG_MAINBARCENTER;
						uidesc = BAROPTIONS_CONFIG_MAINBARCENTER_INFO;
						varbool = "BarOptions_Config.MainBarCenter";
						textname = BAROPTIONS_CHAT_MAINBARCENTER;
						uicheck = BarOptions_Config.MainBarCenter;
						subcom = {"mainbarcenter", "mbcenter", "mbc"};
						subhelp = BAROPTIONS_CONFIG_MAINBARCENTER_INFO;
					};
					{
						uivar = "BarOptionsMainBarLeft";
						uilabel = BAROPTIONS_CONFIG_MAINBARLEFT;
						uidesc = BAROPTIONS_CONFIG_MAINBARLEFT_INFO;
						varbool = "BarOptions_Config.MainBarLeft";
						textname = BAROPTIONS_CHAT_MAINBARLEFT;
						uicheck = BarOptions_Config.MainBarLeft;
						subcom = {"mainbarleft", "mbleft", "mbl"};
						subhelp = BAROPTIONS_CONFIG_MAINBARLEFT_INFO;
					};
					{
						uivar = "BarOptionsMainBarRight";
						uilabel = BAROPTIONS_CONFIG_MAINBARRIGHT;
						uidesc = BAROPTIONS_CONFIG_MAINBARRIGHT_INFO;
						varbool = "BarOptions_Config.MainBarRight";
						textname = BAROPTIONS_CHAT_MAINBARRIGHT;
						uicheck = BarOptions_Config.MainBarRight;
						subcom = {"mainbarright", "mbright", "mbr"};
						subhelp = BAROPTIONS_CONFIG_MAINBARRIGHT_INFO;
					};
				}
			};
			{
				uivar = "BarOptionsHotkeySep";
				uitype = K_HEADER;
				uilabel = BAROPTIONS_CONFIG_HOTKEY_HEADER;
				uidesc = BAROPTIONS_CONFIG_HOTKEY_HEADER_INFO;
				uidiff = 2;
			};
			{ 
				hasbool = true;
				uitype = K_TEXT;
				uidiff = 2;
				mcomtable = {
					{
						uivar = "BarOptionsHideKeys";
						uilabel = BAROPTIONS_CONFIG_HIDEKEYS;
						uidesc = BAROPTIONS_CONFIG_HIDEKEYS_INFO;
						varbool = "BarOptions_Config.HideKeys";
						update = function ()	BarOptions.UpdateHotkeys();
																	BarOptions.SaveConfig(); end;
						textname = BAROPTIONS_CHAT_HIDEKEYS;
						uicheck = BarOptions_Config.HideKeys;
						subcom = {"hidekeys", "hk"};
						subhelp = BAROPTIONS_CONFIG_HIDEKEYS_INFO;
					};
					{
						uivar = "BarOptionsMultiKeys";
						uilabel = BAROPTIONS_CONFIG_MULTIKEYS;
						uidesc = BAROPTIONS_CONFIG_MULTIKEYS_INFO;
						varbool = "BarOptions_Config.MultiKeys";
						update = function ()	BarOptions.ShowMultiHotkeys();
																	BarOptions.SaveConfig(); end;
						textname = BAROPTIONS_CHAT_MULTIKEYS;
						uicheck = BarOptions_Config.MultiKeys;
						subcom = {"multikeys", "mk"};
						subhelp = BAROPTIONS_CONFIG_MULTIKEYS_INFO;
					};
					{
						uivar = "BarOptionsShortKeys";
						uilabel = BAROPTIONS_CONFIG_SHORTKEYS;
						uidesc = BAROPTIONS_CONFIG_SHORTKEYS_INFO;
						varbool = "BarOptions_Config.ShortKeys";
						update = function ()	BarOptions.UpdateHotkeys();
																	BarOptions.SaveConfig(); end;
						textname = BAROPTIONS_CHAT_SHORTKEYS;
						uicheck = BarOptions_Config.ShortKeys;
						subcom = {"shortkeys", "sk"};
						subhelp = BAROPTIONS_CONFIG_SHORTKEYS_INFO;
					};
					{
						uivar = "BarOptionsHideKeyMod";
						uilabel = BAROPTIONS_CONFIG_HIDEKEYMOD;
						uidesc = BAROPTIONS_CONFIG_HIDEKEYMOD_INFO;
						varbool = "BarOptions_Config.HideKeyMod";
						update = function ()	BarOptions.UpdateHotkeys();
																	BarOptions.SaveConfig(); end;
						textname = BAROPTIONS_CHAT_HIDEKEYMOD;
						uicheck = BarOptions_Config.HideKeyMod;
						subcom = {"hidekeymod", "hkmod"};
						subhelp = BAROPTIONS_CONFIG_HIDEKEYMOD_INFO;
					};
				};
			};
			{
				uivar = "BarOptionsArtSep";
				uitype = K_HEADER;
				uilabel = BAROPTIONS_CONFIG_ART_HEADER;
				uidesc = BAROPTIONS_CONFIG_ART_HEADER_INFO;
				uidiff = 2;
			};
			{
				hasbool = true;
				uivar = "BarOptionsRangeColor";
				uitype = K_COLORPICKER;
				uilabel = BAROPTIONS_CONFIG_RANGECOLOR;
				uidesc = BAROPTIONS_CONFIG_RANGECOLOR_INFO;
				uidiff = 2;
				varbool = "BarOptions_Config.RangeColorOn";
				varcolor = "BarOptions_Config.RangeColor";
				update = function ()	ChangeActionBarPage();
															BarOptions.SaveConfig(); end;
				textname = BAROPTIONS_CHAT_RANGECOLOR;
				uicheck = BarOptions_Config.RangeColorOn;
				uicolor = BarOptions_Config.RangeColor;
				supercom = "/baroptions";
				subcom = {"rangecolor", "rc"};
				subhelp = BAROPTIONS_CONFIG_RANGECOLOR_INFO;
			};
			{
				hasbool = true;
				uitype = K_TEXT;
				uidiff = 2;
				update = function ()	BarOptions.UpdateArt();
															BarOptions.SaveConfig(); end;
				mcomtable = {
					{
						uivar = "BarOptionsMainArt";
						uilabel = BAROPTIONS_CONFIG_MAINART;
						uidesc = BAROPTIONS_CONFIG_MAINART_INFO;
						varbool = "BarOptions_Config.MainArt";
						textname = BAROPTIONS_CHAT_MAINART;
						uicheck = BarOptions_Config.MainArt;
						subcom = {"mainart", "ma"};
						subhelp = BAROPTIONS_CONFIG_MAINART_INFO;
					};
					{
						uivar = "BarOptionsBLArt";
						uilabel = BAROPTIONS_CONFIG_BLART;
						uidesc = BAROPTIONS_CONFIG_BLART_INFO;
						varbool = "BarOptions_Config.BLArt";
						textname = BAROPTIONS_CHAT_BLART;
						uicheck = BarOptions_Config.BLArt;
						subcom = {"blart", "bla"};
						subhelp = BAROPTIONS_CONFIG_BLART_INFO;
					};
					{
						uivar = "BarOptionsBRArt";
						uilabel = BAROPTIONS_CONFIG_BRART;
						uidesc = BAROPTIONS_CONFIG_BRART_INFO;
						varbool = "BarOptions_Config.BRArt";
						textname = BAROPTIONS_CHAT_BRART;
						uicheck = BarOptions_Config.BRArt;
						subcom = {"brart", "bra"};
						subhelp = BAROPTIONS_CONFIG_BRART_INFO;
					};
					{
						uivar = "BarOptionsRArt";
						uilabel = BAROPTIONS_CONFIG_RART;
						uidesc = BAROPTIONS_CONFIG_RART_INFO;
						varbool = "BarOptions_Config.RArt";
						textname = BAROPTIONS_CHAT_RART;
						uicheck = BarOptions_Config.RArt;
						subcom = {"rart", "ra"};
						subhelp = BAROPTIONS_CONFIG_RART_INFO;
					};
					{
						uivar = "BarOptionsLArt";
						uilabel = BAROPTIONS_CONFIG_LART;
						uidesc = BAROPTIONS_CONFIG_LART_INFO;
						varbool = "BarOptions_Config.LArt";
						textname = BAROPTIONS_CHAT_LART;
						uicheck = BarOptions_Config.LArt;
						subcom = {"lart", "la"};
						subhelp = BAROPTIONS_CONFIG_LART_INFO;
					};
				};
			};
			{
				uivar = "BarOptionsCountSep";
				uitype = K_HEADER;
				uilabel = BAROPTIONS_CONFIG_COUNT_HEADER;
				uidesc = BAROPTIONS_CONFIG_COUNT_HEADER_INFO;
				uidiff = 2;
			};
			{
				uitype = K_SLIDER;
				uidiff = 2;
				update = function ()	BarOptions.UpdateButtons();
															BarOptions.SaveConfig(); end;
				uimin = 1;
				uimax = 12;
				uitext = BAROPTIONS_CONFIG_COUNT_NAME;
				uistep = 1;
				uitexton = 1;
				uisuffix = BAROPTIONS_CONFIG_COUNT_SUFFIX;
				uimul = 1;
				mcomtable = {
					{
						uivar = "BarOptionsBLCount";
						uilabel = BAROPTIONS_CONFIG_BLCOUNT;
						uidesc = BAROPTIONS_CONFIG_BLCOUNT_INFO;
						varnum = "BarOptions_Config.BLCount";
						textname = BAROPTIONS_CHAT_BLCOUNT;
						uislider = BarOptions_Config.BLCount;
						subcom = {"blcount"};
						subhelp = BAROPTIONS_CONFIG_BLCOUNT_INFO;
					};
					{
						uivar = "BarOptionsBRCount";
						uilabel = BAROPTIONS_CONFIG_BRCOUNT;
						uidesc = BAROPTIONS_CONFIG_BRCOUNT_INFO;
						varnum = "BarOptions_Config.BRCount";
						textname = BAROPTIONS_CHAT_BRCOUNT;
						uislider = BarOptions_Config.BRCount;
						subcom = {"brcount"};
						subhelp = BAROPTIONS_CONFIG_BRCOUNT_INFO;
					};
					{
						uivar = "BarOptionsRCount";
						uilabel = BAROPTIONS_CONFIG_RCOUNT;
						uidesc = BAROPTIONS_CONFIG_RCOUNT_INFO;
						varnum = "BarOptions_Config.RCount";
						textname = BAROPTIONS_CHAT_RCOUNT;
						uislider = BarOptions_Config.RCount;
						subcom = {"rcount"};
						subhelp = BAROPTIONS_CONFIG_RCOUNT_INFO;
					};
					{
						uivar = "BarOptionsLCount";
						uitype = K_SLIDER;
						uilabel = BAROPTIONS_CONFIG_LCOUNT;
						uidesc = BAROPTIONS_CONFIG_LCOUNT_INFO;
						varnum = "BarOptions_Config.LCount";
						textname = BAROPTIONS_CHAT_LCOUNT;
						uislider = BarOptions_Config.LCount;
						subcom = {"lcount"};
						subhelp = BAROPTIONS_CONFIG_LCOUNT_INFO;
					};
				};
			};
		};
	} );
	if ( CosmosMaster_Init and (not Khaos) ) then
		MCom.registerSmart( {
			supercom = {"/baroptions", "/bo"};
			uidiff = 2;
			mcomtable = {
				{
					uivar = "BarOptionsRangeColorSep";
					uitype = K_HEADER;
					uilabel = BAROPTIONS_CONFIG_RANGECOLOR_HEADER;
					uidesc = BAROPTIONS_CONFIG_RANGECOLOR_HEADER_INFO;
				};
				{
					hasbool = true;
					uivar = "BarOptionsRangeColor";
					uitype = K_TEXT;
					uilabel = BAROPTIONS_CONFIG_RANGECOLOR;
					uidesc = BAROPTIONS_CONFIG_RANGECOLOR_INFO;
					varbool = "BarOptions_Config.RangeColorOn";
					update = function ()	ChangeActionBarPage();
																BarOptions.SaveConfig(); end;
					uicheck = BarOptions_Config.RangeColorOn;
				};
				{
					uitype = K_SLIDER;
					update = BarOptions.SaveConfig;
					uimin = 0;
					uimax = 1;
					uitext = BAROPTIONS_CONFIG_RANGECOLOR_NAME;
					uistep = 0.01;
					uitexton = 1;
					uisuffix = BAROPTIONS_CONFIG_RANGECOLOR_SUFFIX;
					uimul = 100;
					mcomtable = {
						{
							uivar = "BarOptionsRangeColorRed";
							uilabel = BAROPTIONS_CONFIG_RANGECOLORRED;
							uidesc = BAROPTIONS_CONFIG_RANGECOLORRED_INFO;
							varnum = "BarOptions_Config.RangeColor.r";
							uislider = BarOptions_Config.RangeColor.r;
						};
						{
							uivar = "BarOptionsRangeColorGreen";
							uilabel = BAROPTIONS_CONFIG_RANGECOLORGREEN;
							uidesc = BAROPTIONS_CONFIG_RANGECOLORGREEN_INFO;
							varnum = "BarOptions_Config.RangeColor.g";
							uislider = BarOptions_Config.RangeColor.g;
						};
						{
							uivar = "BarOptionsRangeColorBlue";
							uilabel = BAROPTIONS_CONFIG_RANGECOLORBLUE;
							uidesc = BAROPTIONS_CONFIG_RANGECOLORBLUE_INFO;
							varnum = "BarOptions_Config.RangeColor.b";
							uislider = BarOptions_Config.RangeColor.b;
						};
					};
				};
			};
		} );
	end
	MCom.registerSmart( {
		supercom = "/baroptions";
		uidiff = 3;
		mcomtable = {
			{
				uivar = "BarOptionsStanceSep";
				uitype = K_HEADER;
				uilabel = BAROPTIONS_CONFIG_STANCE_HEADER;
				uidesc = BAROPTIONS_CONFIG_STANCE_HEADER_INFO;
			};
			{
				hasbool = true;
				uivar = "BarOptionsCustomStances";
				uitype = K_TEXT;
				uilabel = BAROPTIONS_CONFIG_CUSTOMSTANCES;
				uidesc = BAROPTIONS_CONFIG_CUSTOMSTANCES_INFO;
				uidep = { ["BarOptionsStanceBar"] = { checked = true } };
				varbool = "BarOptions_Config.CustomStances";
				update = function ()	ChangeActionBarPage();
															BarOptions.SaveConfig(); end;
				textname = BAROPTIONS_CHAT_CUSTOMSTANCES;
				uicheck = BarOptions_Config.CustomStances;
				subcom = {"customstances", "cs"};
				subhelp = BAROPTIONS_CONFIG_CUSTOMSTANCES_INFO;
			};
			{
				uitype = K_SLIDER;
				uidiff = 3;
				uidep = { ["BarOptionsStanceBar"] = { checked = true } };
				uimin = 1;
				uimax = 10;
				uitext = BAROPTIONS_CONFIG_STANCE_NAME;
				uistep = 1;
				uitexton = 1;
				uisuffix = BAROPTIONS_CONFIG_STANCE_SUFFIX;
				uimul = 1;
				mcomtable = {
					{
						uivar = "BarOptionsStance0";
						uilabel = BAROPTIONS_CONFIG_STANCE0;
						uidesc = BAROPTIONS_CONFIG_STANCE0_INFO;
						varnum = "BarOptions_Config.Stance0";
						update = function ()	if ((BarOptions_Config.CustomStances == 1) and (GetBonusBarOffset() == 0)) then ChangeActionBarPage(); end;
																	BarOptions.SaveConfig(); end;
						textname = BAROPTIONS_CHAT_STANCE0;
						uislider = BarOptions_Config.Stance0;
						subcom = {"stance0", "s0"};
						subhelp = BAROPTIONS_CONFIG_STANCE0_INFO..BAROPTIONS_CHAT_STANCE_RANGE;
					};
					{
						uivar = "BarOptionsStance1";
						uilabel = BAROPTIONS_CONFIG_STANCE1;
						uidesc = BAROPTIONS_CONFIG_STANCE1_INFO;
						varnum = "BarOptions_Config.Stance1";
						update = function ()	if ((BarOptions_Config.CustomStances == 1) and (GetBonusBarOffset() == 1)) then ChangeActionBarPage(); end;
																	BarOptions.SaveConfig(); end;
						textname = BAROPTIONS_CHAT_STANCE1;
						uislider = BarOptions_Config.Stance1;
						subcom = {"stance1", "s1"};
						subhelp = BAROPTIONS_CONFIG_STANCE1_INFO..BAROPTIONS_CHAT_STANCE_RANGE;
					};
					{
						uivar = "BarOptionsStance2";
						uilabel = BAROPTIONS_CONFIG_STANCE2;
						uidesc = BAROPTIONS_CONFIG_STANCE2_INFO;
						varnum = "BarOptions_Config.Stance2";
						update = function ()	if ((BarOptions_Config.CustomStances == 1) and (GetBonusBarOffset() == 2)) then ChangeActionBarPage(); end;
																	BarOptions.SaveConfig(); end;
						textname = BAROPTIONS_CHAT_STANCE2;
						uislider = BarOptions_Config.Stance2;
						subcom = {"stance2", "s2"};
						subhelp = BAROPTIONS_CONFIG_STANCE2_INFO..BAROPTIONS_CHAT_STANCE_RANGE;
					};
					{
						uivar = "BarOptionsStance3";
						uilabel = BAROPTIONS_CONFIG_STANCE3;
						uidesc = BAROPTIONS_CONFIG_STANCE3_INFO;
						varnum = "BarOptions_Config.Stance3";
						update = function ()	if ((BarOptions_Config.CustomStances == 1) and (GetBonusBarOffset() == 3)) then ChangeActionBarPage(); end;
																	BarOptions.SaveConfig(); end;
						textname = BAROPTIONS_CHAT_STANCE3;
						uislider = BarOptions_Config.Stance3;
						subcom = {"stance3", "s3"};
						subhelp = BAROPTIONS_CONFIG_STANCE3_INFO..BAROPTIONS_CHAT_STANCE_RANGE;
					};
				};
			};
		};
	} );
end