--[[
	ArcaneBar
	 	Adds a second casting bar to the player frame.
	
	By: Zlixar
	
	Adds a second casting bar to the player frame.
	
	$Id: ArcaneBar.lua 4229 2006-10-28 19:35:40Z karlkfi $
	$Rev: 4229 $
	$LastChangedBy: karlkfi $
	$Date: 2006-10-28 14:35:40 -0500 (Sat, 28 Oct 2006) $
]]--

--------------------------------------------------
--
-- Globals
--
--------------------------------------------------
ArcaneBar_DefaultColors = {
	["MAIN"] = {
		r=1.0;
		g=0.7;
		b=0.0;		
	};
	["CHANNEL"] = {
		r=0.0;
		g=1.0;
		b=0.0;
	};
	["SUCCESS"] = {
		r=0.0;
		g=1.0;
		b=0.0;
	};
	["FAILURE"] = {
		r=1.0;
		g=0.0;
		b=0.0;
	};	
};

--------------------------------------------------
--
-- Configuration Functions
--
--------------------------------------------------
--[[ 
	Registers "frame" (passed as a string) to spellcast events.
]]--
function ArcaneBar_Register(frame)
	getglobal(frame).showCastbar = true;
end
--[[ 
	Unregisters "frame" (passed as a string) from spellcast events.
]]--
function ArcaneBar_Unregister(frame)
	getglobal(frame).showCastbar = false;
end
--[[ 
	These functions salvaged from old Cosmos config, now used for the expanded /command support.
]]--
function ArcaneBar_NilFunc(u,b,c)
	-- Zilch ATM
end
function ArcaneBar_MainColorSet()
	ColorPickerFrame.func = ArcaneBar_NilFunc;
	ColorPickerFrame.cancelFunc = ArcaneBar_NilFunc;
	ColorPickerFrame.hasOpacity = false;
	ColorPickerFrame:SetColorRGB(ArcaneBar_Colors["MAIN"].r, ArcaneBar_Colors["MAIN"].g, ArcaneBar_Colors["MAIN"].b);
	ColorPickerFrame.func = ArcaneBar_MainColorSetDo;
	ColorPickerFrame.previousValues = {r = ArcaneBar_Colors["MAIN"].r, g = ArcaneBar_Colors["MAIN"].g, b = ArcaneBar_Colors["MAIN"].b, opacity = 1};
	ColorPickerFrame:Show();
end
function ArcaneBar_MainColorReset()
	if ( not ArcaneBar_Colors["MAIN"] ) then ArcaneBar_Colors["MAIN"] = {}; end
	ArcaneBar_Colors["MAIN"] = ArcaneBar_DefaultColors["MAIN"];
	DEFAULT_CHAT_FRAME:AddMessage("ArcaneBar: Main Color Reset.", .8, 1.0, .8);
end
function ArcaneBar_ChannelColorSet()
	ColorPickerFrame.func = ArcaneBar_NilFunc;
	ColorPickerFrame.cancelFunc = ArcaneBar_NilFunc;
	ColorPickerFrame.hasOpacity = false;
	ColorPickerFrame:SetColorRGB(ArcaneBar_Colors["CHANNEL"].r, ArcaneBar_Colors["CHANNEL"].g, ArcaneBar_Colors["CHANNEL"].b);
	ColorPickerFrame.func = ArcaneBar_ChannelColorSetDo;
	ColorPickerFrame.previousValues = {r = ArcaneBar_Colors["CHANNEL"].r, g = ArcaneBar_Colors["CHANNEL"].g, b = ArcaneBar_Colors["CHANNEL"].b, opacity = 1};
	ColorPickerFrame:Show();
end
function ArcaneBar_ChannelColorReset()
	if ( not ArcaneBar_Colors["CHANNEL"] ) then ArcaneBar_Colors["CHANNEL"] = {}; end
	ArcaneBar_Colors["CHANNEL"] = ArcaneBar_DefaultColors["CHANNEL"];
	DEFAULT_CHAT_FRAME:AddMessage("ArcaneBar: Channel Color Reset.", .8, 1.0, .8);
end
function ArcaneBar_SuccessColorSet()
	ColorPickerFrame.func = ArcaneBar_NilFunc;
	ColorPickerFrame.cancelFunc = ArcaneBar_NilFunc;
	ColorPickerFrame.hasOpacity = false;
	ColorPickerFrame:SetColorRGB(ArcaneBar_Colors["SUCCESS"].r, ArcaneBar_Colors["SUCCESS"].g, ArcaneBar_Colors["SUCCESS"].b);
	ColorPickerFrame.func = ArcaneBar_SuccessColorSetDo;
	ColorPickerFrame.previousValues = {r = ArcaneBar_Colors["SUCCESS"].r, g = ArcaneBar_Colors["SUCCESS"].g, b = ArcaneBar_Colors["SUCCESS"].b, opacity = 1};
	ColorPickerFrame:Show();
end
function ArcaneBar_SuccessColorReset()
	if ( not ArcaneBar_Colors["SUCCESS"] ) then ArcaneBar_Colors["SUCCESS"] = {}; end
	ArcaneBar_Colors["SUCCESS"] = ArcaneBar_DefaultColors["SUCCESS"];
	DEFAULT_CHAT_FRAME:AddMessage("ArcaneBar: Success Color Reset.", .8, 1.0, .8);
end
function ArcaneBar_FailureColorSet()
	ColorPickerFrame.func = ArcaneBar_NilFunc;
	ColorPickerFrame.cancelFunc = ArcaneBar_NilFunc;
	ColorPickerFrame.hasOpacity = false;
	ColorPickerFrame:SetColorRGB(ArcaneBar_Colors["FAILURE"].r, ArcaneBar_Colors["FAILURE"].g, ArcaneBar_Colors["FAILURE"].b);
	ColorPickerFrame.func = ArcaneBar_FailureColorSetDo;
	ColorPickerFrame.previousValues = {r = ArcaneBar_Colors["FAILURE"].r, g = ArcaneBar_Colors["FAILURE"].g, b = ArcaneBar_Colors["FAILURE"].b, opacity = 1};
	ColorPickerFrame:Show();
end
function ArcaneBar_FailureColorReset()
	if ( not ArcaneBar_Colors["FAILURE"] ) then ArcaneBar_Colors["FAILURE"] = {}; end
	ArcaneBar_Colors["FAILURE"] = ArcaneBar_DefaultColors["FAILURE"];
	DEFAULT_CHAT_FRAME:AddMessage("ArcaneBar: Failure Color Reset.", .8, 1.0, .8);
end
function ArcaneBar_MainColorSetDo()
	local r,g,b = ColorPickerFrame:GetColorRGB();
	ArcaneBar_Colors["MAIN"].r = r;
	ArcaneBar_Colors["MAIN"].g = g;
	ArcaneBar_Colors["MAIN"].b = b;
	if (not ColorPickerFrame:IsShown()) then
		DEFAULT_CHAT_FRAME:AddMessage("Main bar color set!",r,g,b);
	end;
end
function ArcaneBar_ChannelColorSetDo()
	local r,g,b = ColorPickerFrame:GetColorRGB();
	ArcaneBar_Colors["CHANNEL"].r = r;
	ArcaneBar_Colors["CHANNEL"].g = g;
	ArcaneBar_Colors["CHANNEL"].b = b;
	if (not ColorPickerFrame:IsShown()) then
		DEFAULT_CHAT_FRAME:AddMessage("Channel color set!",r,g,b);
	end;
end
function ArcaneBar_SuccessColorSetDo()
	local r,g,b = ColorPickerFrame:GetColorRGB();
	ArcaneBar_Colors["SUCCESS"].r = r;
	ArcaneBar_Colors["SUCCESS"].g = g;
	ArcaneBar_Colors["SUCCESS"].b = b;
	if (not ColorPickerFrame:IsShown()) then
		DEFAULT_CHAT_FRAME:AddMessage("Success color set!",r,g,b);
	end;
end
function ArcaneBar_FailureColorSetDo()
	local r,g,b = ColorPickerFrame:GetColorRGB();
	ArcaneBar_Colors["FAILURE"].r = r;
	ArcaneBar_Colors["FAILURE"].g = g;
	ArcaneBar_Colors["FAILURE"].b = b;
	if (not ColorPickerFrame:IsShown()) then
		DEFAULT_CHAT_FRAME:AddMessage("Failure color set!",r,g,b);
	end;
end

-- END /Command Functions --
function ArcaneBar_EnableToggle(value)
	if (value == 1) then
		if (ArcaneBar_Enabled == 1) then
			--Do nothing
		else
			ArcaneBar_Register("ArcaneBarFrame");
			ArcaneBar_Enabled = 1;
		end
	else
		if (ArcaneBar_Enabled == 1) then
			ArcaneBar_Unregister("ArcaneBarFrame");
			ArcaneBar_Enabled = 0;
		else
			--Do nothing
		end
	end
end

function ArcaneBar_OverrideToggle(value)
	if (value == 1) then
		if (ArcaneBar_Override == 1) then
			--Do nothing
		else
			ArcaneBar_Unregister("CastingBarFrame");
			ArcaneBar_Override = 1;
		end
	else
		if (ArcaneBar_Override == 1) then
			ArcaneBar_Register("CastingBarFrame");
			ArcaneBar_Override = 0;
		else
			--Do nothing
		end
	end
end

function ArcaneBar_ShowIconToggle(value)
	if (value == 1) then
		if (ArcaneBar_ShowIcon == 1) then
			--Do nothing
		else
			ArcaneBarIcon:Show();
			CastingBarFrameIcon:Show();
			ArcaneBar_ShowIcon = 1;
		end
	else
		if (ArcaneBar_ShowIcon == 1) then
			ArcaneBarIcon:Hide();
			CastingBarFrameIcon:Hide();
			ArcaneBar_ShowIcon = 0;
		else
			--Do nothing
		end
	end
end
--------------------------------------------------
--
-- Frame Script Handlers
--
--------------------------------------------------
function ArcaneBarFrame_OnLoad()
	this:RegisterEvent("VARIABLES_LOADED");
	ArcaneBar:SetFrameLevel(ArcaneBar:GetFrameLevel() - 1);
	ArcaneBar_Resetting = {};
	CastingBarFrameIcon:SetPoint("RIGHT", CastingBarFrame, "LEFT", -10, 2);
end
function ArcaneBarFrame_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		if (not ArcaneBar_Colors) then
			ArcaneBar_Colors = ArcaneBar_DefaultColors;
		end
		ArcaneBar_RegisterConfig();
	end
end
function ArcaneBar_OnLoad()
	CastingBarFrame_OnLoad("player", true);
	this:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
	this:UnregisterEvent("UNIT_SPELLCAST_STOP");
	this.maxValue = 0;
end
function ArcaneBar_OnEvent(event, unit)
	if ( event == "UNIT_SPELLCAST_SUCCEEDED" ) then
		if ( this.color == "CHANNEL" ) then
			return;
		end
		CastingBarFrame_OnEvent("UNIT_SPELLCAST_STOP", unit);
	else
		CastingBarFrame_OnEvent(event, unit);
	end
	
	if ( unit ~= "player" ) then
		return;
	end
	
	-- Update with custom colors
	if ( event == "UNIT_SPELLCAST_START" ) then
		this:SetStatusBarColor(ArcaneBar_Colors["MAIN"].r, ArcaneBar_Colors["MAIN"].g, ArcaneBar_Colors["MAIN"].b);
		this.color = "MAIN";

	elseif ( event == "UNIT_SPELLCAST_SUCCEEDED" ) then
		if ( this:IsShown() ) then
			this:SetStatusBarColor(ArcaneBar_Colors["SUCCESS"].r, ArcaneBar_Colors["SUCCESS"].g, ArcaneBar_Colors["SUCCESS"].b);
			this.color = "SUCCESS";
		end
		
	elseif ( event == "UNIT_SPELLCAST_INTERRUPTED" ) then
		if ( this:IsShown() ) then
			this:SetStatusBarColor(ArcaneBar_Colors["FAILURE"].r, ArcaneBar_Colors["FAILURE"].g, ArcaneBar_Colors["FAILURE"].b);
			this.color = "FAILURE";
		end
		
	elseif ( event == "UNIT_SPELLCAST_CHANNEL_START" ) then
		this:SetStatusBarColor(ArcaneBar_Colors["CHANNEL"].r, ArcaneBar_Colors["CHANNEL"].g, ArcaneBar_Colors["CHANNEL"].b);
		this.color = "CHANNEL";
		ArcaneBarSpark:Hide(); -- fix silly blizz bug
		
	elseif ( event == "UNIT_SPELLCAST_CHANNEL_STOP" ) then
		if ( this:IsShown() ) then
			this:SetValue(this.endTime);
			this:SetStatusBarColor(ArcaneBar_Colors["SUCCESS"].r, ArcaneBar_Colors["SUCCESS"].g, ArcaneBar_Colors["SUCCESS"].b);
			this.color = "SUCCESS";
		end
	end
end
function ArcaneBar_OnUpdate()
	CastingBarFrame_OnUpdate();
	if ( this.fadeOut ) then
		if ( this.color == "SUCCESS" or this.color == "FAILURE" ) then
			local color = ArcaneBar_Colors[this.color]
			this:SetStatusBarColor(color.r, color.g, color.b);
			local min, max = this:GetMinMaxValues();
			this:SetValue(max);
			this.color = nil;
		end
	end
end
function ArcaneBar_RegisterConfig()
	if ( Khaos ) then 
		-- Khaos will save our vars, not the toc!
		ArcaneBar_Enabled = 0;
		ArcaneBar_Override = 0;
		-- W0000!
		local optionSet = {};
		local commandSet = {};
		local configurationSet = {
			id="ArcaneBar";
			text=ARCANE_SECTION_TEXT;
			helptext=ARCANE_SECTION_TIP;
			difficulty=2;
			options=optionSet;
			commands=commandSet;
			default=false;
			callback=function(enabled)
				if ( enabled ) then
					 ArcaneBar_EnableToggle(1);
				else
					 ArcaneBar_EnableToggle(0);
				end
			end;
		};
	
		-- Register Basics
		table.insert(
			optionSet,
			{
				id="Header";
				text=ARCANE_HEADER_TEXT;
				helptext=ARCANE_HEADER_TIP;
				difficulty=1;
				type=K_HEADER;
			}
		);
		table.insert(
			optionSet,
			{
				id="Message";
				text=ARCANEBAR_ACTIVE;
				helptext=ARCANEBAR_ACTIVE_TIP;
				type=K_TEXT;
				difficulty=1;
			}
		);
		table.insert(
			optionSet,
			{
				id="RemoveCastingBar";
				text=ARCANE_OVERRIDE_TEXT;
				helptext=ARCANE_OVERRIDE_TIP;
				difficulty=1;
				callback=function(state)
					if ( state.checked ) then
						ArcaneBar_OverrideToggle(1);
					else
						ArcaneBar_OverrideToggle(0);
					end
				end;
				feedback=function(state)
					if ( state.checked ) then
						return ARCANEBAR_SHOWNFEEDBACK_NEGATIVE;
					else
						return ARCANEBAR_SHOWNFEEDBACK_POSITIVE;
					end
				end;
				check=true;
				type=K_TEXT;
				setup= {						
				};
				default={
					checked=false;
				};
				disabled={
					disabled=false;
				};					
			}
		);
		table.insert(
			optionSet,
			{
				id="ShowSpellIcon";
				text=ARCANE_SHOW_ICON_TEXT;
				helptext=ARCANE_SHOW_ICON_TIP;
				difficulty=1;
				callback=function(state)
					if ( state.checked ) then
						ArcaneBar_ShowIconToggle(1);
					else
						ArcaneBar_ShowIconToggle(0);
					end
				end;
				feedback=function(state)
					if ( state.checked ) then
						return ARCANEBAR_SHOWNICONFEEDBACK_NEGATIVE;
					else
						return ARCANEBAR_SHOWNICONFEEDBACK_POSITIVE;
					end
				end;
				check=true;
				type=K_TEXT;
				setup= {						
				};
				default={
					checked=false;
				};
				disabled={
					disabled=false;
				};					
			}
		);
	
		-- Register for each type			
		local types = {"MAIN","CHANNEL","SUCCESS","FAILURE"};
		for i=1,4 do 
			local typeString = types[i];
			local niceType = Sea.string.capitalizeWords(types[i]);
			local colorChangeFeedback = function(state)
				return string.format(ARCANEBAR_COLOR_CHANGED, Sea.string.colorToString(state.color), niceType );
			end;
			local colorResetFeedback = function(state)
				return string.format(ARCANEBAR_COLOR_RESET, Sea.string.colorToString(state.color), niceType );
			end;
			table.insert(
				optionSet,
				{
					id=niceType.."ColorSetter";
					text=getglobal("ARCANEBAR_"..typeString.."COLOR_SET");
					helptext=getglobal("ARCANEBAR_"..typeString.."COLOR_SET_TIP");
					difficulty=3;
					callback=function(state)
						if (ArcaneBar_Resetting[typeString] == true) then
							state.color = ArcaneBar_DefaultColors[typeString];
							ArcaneBar_Resetting[typeString] = false;
						end
						ArcaneBar_Colors[typeString] = state.color;
					end;
					feedback=colorChangeFeedback;
					type=K_COLORPICKER;
					setup= {
						hasOpacity=false;
					};
					default={
						color=ArcaneBar_DefaultColors[typeString];
					};
					disabled={
						color=ArcaneBar_DefaultColors[typeString];
					};					
				}
			);
			table.insert(
				optionSet,
				{
					id=niceType.."Reset";
					text=getglobal("ARCANEBAR_"..typeString.."COLOR_RESET");
					helptext=getglobal("ARCANEBAR_"..typeString.."COLOR_RESET_TIP");
					difficulty=3;
					callback=function(state)
						ArcaneBar_Resetting[typeString] = true;
						-- The khaos config's color has to be reset too or else it will just get refreshed
						-- with its state and override any values of ArcaneBar_Colors we change here.
					end;
					feedback=colorResetFeedback;
					type=K_BUTTON;
					setup = {
						buttonText=ARCANEBAR_RESETTEXT;
					};
				}
			);
		end
		Khaos.registerOptionSet(
			"combat",
			configurationSet
		);			
	else
		-- Command System FTW
		if (ArcaneBar_Enabled == 1) then
			ArcaneBar_Enabled = 0;
			ArcaneBar_EnableToggle(1);
		else
			ArcaneBar_Enabled = 0;
		end
		if (ArcaneBar_Override == 1) then
			ArcaneBar_Override = 0;
			ArcaneBar_OverrideToggle(1);
		else
			ArcaneBar_Override = 0;
		end
	
		SlashCmdList["ARCANEBAR"] = function(msg) 
			if (string.lower(msg) == "enable") then
				ArcaneBar_EnableToggle(1);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_ENABLED,0,1,0);
			elseif (string.lower(msg) == "disable") then
				ArcaneBar_EnableToggle(0);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_DISABLED,1,0,0);
			elseif (string.lower(msg) == "override") then
				if (ArcaneBar_Override == 1) then
					ArcaneBar_OverrideToggle(0);
					DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_SHOWNFEEDBACK_NEGATIVE,1,1,0);
				else
					ArcaneBar_OverrideToggle(1);
					DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_SHOWNFEEDBACK_POSITIVE,0,1,1);
				end
			elseif (string.lower(msg) == "icon") then
				if (ArcaneBar_ShowIcon == 1) then
					ArcaneBar_ShowIconToggle(0);
					DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_SHOWNICONFEEDBACK_NEGATIVE,1,1,0);
				else
					ArcaneBar_ShowIconToggle(1);
					DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_SHOWNICONFEEDBACK_POSITIVE,0,1,1);
				end
			elseif (string.lower(msg) == "set failure") then
				ArcaneBar_FailureColorSet();
			elseif (string.lower(msg) == "set success") then
				ArcaneBar_SuccessColorSet();
			elseif (string.lower(msg) == "set channel") then
				ArcaneBar_ChannelColorSet();
			elseif (string.lower(msg) == "set main") then
				ArcaneBar_MainColorSet();
			elseif (string.lower(msg) == "reset failure") then
				ArcaneBar_FailureColorReset();
			elseif (string.lower(msg) == "reset success") then
				ArcaneBar_SuccessColorReset();
			elseif (string.lower(msg) == "reset channel") then
				ArcaneBar_ChannelColorReset();
			elseif (string.lower(msg) == "reset main") then
				ArcaneBar_MainColorReset();
			elseif (string.lower(msg) == "help") then
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP1);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP2);
				DEFAULT_CHAT_FRAME:AddMessage("|c00995555--------|r");
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP3);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP4);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP5);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP6);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP7);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP8);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP9);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP10);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP11);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP12);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP13);
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_HELP14);
			else
				DEFAULT_CHAT_FRAME:AddMessage(ARCANEBAR_INVALID_COMMAND,.5,.5,.5);
			end
		end;
	 			SLASH_ARCANEBAR1 = "/arcanebar";
	 			SLASH_ARCANEBAR2 = "/ab";
	 			
	end
end
