------------------------------------------------
--                  CT_Core                   --
--                                            --
-- Core addon for doing basic and popular     --
-- things in an intuitive way.                --
-- Please do not modify or otherwise          --
-- redistribute this without the consent of   --
-- the CTMod Team. Thank you.                 --
------------------------------------------------

--------------------------------------------
-- Initialization

local module = { };
local _G = getfenv(0);

local MODULE_NAME = "CT_Core";
local MODULE_VERSION = strmatch(GetAddOnMetadata(MODULE_NAME, "version"), "^([%d.]+)");

module.name = MODULE_NAME;
module.version = MODULE_VERSION;

_G[MODULE_NAME] = module;
CT_Library:registerModule(module);

--------------------------------------------
-- Minimap Handler

local sqrt, abs = sqrt, abs;
local function minimapMover(self)
	self:ClearAllPoints();
	
	local uiScale = UIParent:GetScale();
	local cX, cY = GetCursorPosition();
	local mX, mY = Minimap:GetCenter();
	cX, cY = cX/uiScale, cY/uiScale;
	
	local width, height = (cX-mX), (cY-mY);
	local dist = sqrt(width^2 + height^2);
	if ( dist < 85 ) then
		-- Get angle
		local a = atan(height/width);
		if ( width < 0 ) then
			a = a + 180;
		end
		self:SetClampedToScreen(false);
		self:SetPoint("CENTER", Minimap, "CENTER", 80*cos(a), 80*sin(a));
	else
		self:SetClampedToScreen(true);
		self:SetPoint("CENTER", nil, "BOTTOMLEFT", cX, cY);
	end
end

local function minimapFrameSkeleton()
	return "button#s:32:32#mid:bl:Minimap:15:15#st:LOW", {
		"texture#all#i:disabled#Interface\\AddOns\\CT_Core\\Images\\minimapIcon",
		"texture#all#i:enabled#hidden#Interface\\AddOns\\CT_Core\\Images\\minimapIconHighlight",
		
		["onclick"] = function(self)
			module:showControlPanel("toggle");
		end,
		
		["ondragstart"] = function(self)
			self:StartMoving();
			self:SetScript("OnUpdate", minimapMover);
		end,
		
		["ondragstop"] = function(self)
			self:StopMovingOrSizing();
			self:SetScript("OnUpdate", nil);
			
			local x, y = self:GetCenter();
			module:setOption("minimapX", x, true);
			module:setOption("minimapY", y, true);
		end,
		
		["onload"] = function(self)
			local highlight = self:CreateTexture(nil, "HIGHLIGHT");
			highlight:SetAllPoints(self);
			highlight:SetTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight");
			highlight:SetBlendMode("ADD");
			highlight:SetVertexColor(1, 1, 1, 0.5);
			
			self:RegisterForDrag("LeftButton");
			self:SetMovable(true);
			
			local x, y = module:getOption("minimapX"), module:getOption("minimapY");
			if ( x and y ) then
				self:ClearAllPoints();
				self:SetPoint("CENTER", nil, "BOTTOMLEFT", x, y);
				local mX, mY = Minimap:GetCenter();
				local width, height = (x-mX), (y-mY);
				local dist = sqrt(width^2 + height^2);
				if ( dist >= 85 ) then
					self:SetClampedToScreen(true);
				end
			end
		end
	}
end

local minimapFrame;
local function showMinimap(enable)
	if ( not enable ) then
		if ( minimapFrame ) then
			minimapFrame:Hide();
		end
		return;
	end
	
	if ( not minimapFrame ) then
		minimapFrame = module:getFrame(minimapFrameSkeleton);
	else
		minimapFrame:Show();
	end
end

module:regEvent("CONTROL_PANEL_VISIBILITY", function(event, enabled)
	if ( minimapFrame ) then
		if ( enabled ) then
			minimapFrame.enabled:Show();
			minimapFrame.disabled:Hide();
		else
			minimapFrame.enabled:Hide();
			minimapFrame.disabled:Show();
		end
	end
end);

--------------------------------------------
-- Options
module.update = function(self, type, value)
	self:modupdate(type, value);
	self:chatupdate(type, value);
	if ( type == "init" or type == "minimapIcon" ) then
		showMinimap(self:getOption("minimapIcon") ~= false);
	end
end

-- Options frame
module.frame = function()
	return "frame#all", {
		-- Generic Options
		"checkbutton#tl:10:0#o:minimapIcon:true#Display Minimap Icon",
		"texture#tl:5:-30#r:-5:0#s:0:1#1:1:1:0.25",
		
		"checkbutton#tl:10:-40#o:castingTimers#Display Casting Bar Timers",
		"texture#tl:5:-70#r:-5:0#s:0:1#1:1:1:0.25",
		
		"checkbutton#o:questLevels#tl:10:-80#Display Quest Levels in Quest Log",
		"texture#tl:5:-110#r:-5:0#s:0:1#1:1:1:0.25",
		
		"checkbutton#tl:10:-120#o:tickMod#Display Health/Mana Regeneration Rates",
		"font#tl:60:-145#v:ChatFontNormal#Format:",
		"dropdown#tl:100:-147#s:125:50#o:tickModFormat#n:CTCoreDropdown1#Health - Mana#HP/Tick - MP/Tick#HP - MP",
		"font#tl:25:-165#r:-5:0#(Formerly CT_TickMod)#0.5:0.5:0.5",
		"texture#tl:5:-180#r:-5:0#s:0:1#1:1:1:0.25",
		
		"checkbutton#tl:10:-190#o:blockBankTrades#Block Trades While Using the Bank",
		"texture#s:0:1#tl:5:-220#r:-5:0#1:1:1:0.25",
		
		-- Chat Options
		"font#tl:0:-230#v:GameFontNormalLarge#Chat Options",
		"checkbutton#tl:10:-250#o:chatTimestamp#Display Chat Timestamps",
		"font#tl:60:-275#v:ChatFontNormal#Format:",
		"dropdown#tl:100:-277#o:chatTimestampFormat#n:CTCoreDropdown2#s:100:50#12:00#12:00:00#24:00#24:00:00",
		"checkbutton#tl:10:-290#o:chatArrows#Hide Chat Arrows",
		"checkbutton#tl:10:-310#o:chatScrolling#Enable Chat Scrolling",
		"font#tl:0:-335#r#(Ctrl+Scroll: One Page, Shift+Scroll: Start/End)#0.5:0.5:0.5",
		
		-- Quest Tracker
		"font#tl:0:-360#v:GameFontNormalLarge#Quest Tracker",
		"checkbutton#tl:10:-380#o:questTracker#Unlock Quest Tracker",
		"font#tl:0:-400#r#s:0:30#(Unlocking the quest tracker makes it use the anchor, allowing you to move its screen position)#0.5:0.5:0.5",
		"checkbutton#tl:30:-427#o:questTrackerAnchor:true#Show Quest Tracker Anchor",
		"font#tl:0:-447#r#s:0:30#(Drag the anchor to move the quest tracker. Right click it to change expand direction)#0.5:0.5:0.5",
		
		-- Tooltip Relocation
		"font#tl:0:-495#v:GameFontNormalLarge#Tooltip Relocation",
		"font#tl:10:-515#v:ChatFontNormal#Tooltip Style:",
		"dropdown#tl:90:-517#o:tooltipRelocation#n:CTCoreDropdown3#s:125:50#Default#On Mouse#On Anchor",
		"font#tl:0:-530#r#s:0:30#(Selecting the anchor will allow you to choose the position tooltips display on screen)#0.5:0.5:0.5",
		"checkbutton#tl:30:-558#o:tooltipRelocationAnchor#Show Tooltip Anchor",
		"font#tl:0:-575#r#s:0:40#(Drag the anchor to change where tooltips will display. Right click it to change expand direction)#0.5:0.5:0.5"
	};
end