------------------------------------------------
--                CT_BuffMod                  --
--                                            --
-- Mod that allows you to heavily customize   --
-- the display of buffs to your liking.       --
-- Please do not modify or otherwise          --
-- redistribute this without the consent of   --
-- the CTMod Team. Thank you.                 --
------------------------------------------------

local _G = getfenv(0);
local module = _G.CT_BuffMod;
local buffObjectList = module.buffList;
local buffModFrame = module.buffFrame;

-- Options frame
local function updateSortType(frame, sortType)
	sortType = sortType or module:getOption("sortType");
	if ( sortType == 1 ) then
		-- Type
		frame.subSortTypeFont:Show();
		frame.subSortType:Show();
		
		local subSortType = module:getOption("subSortType");
		if ( subSortType == 2 ) then
			local keepRecastPosition = frame.keepRecastPosition;
			keepRecastPosition:Show();
			keepRecastPosition:SetPoint("TOPLEFT", 60, -235);
		else
			frame.keepRecastPosition:Hide();
		end
		
	elseif ( sortType == 3 ) then
		-- Order
		frame.subSortTypeFont:Hide();
		frame.subSortType:Hide();
		
		local keepRecastPosition = frame.keepRecastPosition;
		keepRecastPosition:Show();
		keepRecastPosition:SetPoint("TOPLEFT", 60, -215);
	else
		frame.subSortTypeFont:Hide();
		frame.subSortType:Hide();
		frame.keepRecastPosition:Hide();
	end
end

module.frame = function()
	local updateFunc = function(self, value)
		local timeLeft = floor( ( value or self:GetValue() )*10+0.5)/10;

		if ( timeLeft == 0 ) then
			self.title:SetText("Off");
		else
			self.title:SetText(module.humanizeTime(timeLeft));
		end
		local option = self.option;
		if ( option ) then
			self.object:setOption(option, value);
		end
	end;
	local buffExpirationSlider = {
		["onvaluechanged"] = updateFunc,
		["onload"] = updateFunc
	};
	return "frame#all", {
		
		-- Window Options
		"font#tl:0:-5#v:GameFontNormalLarge#Window Options",
		"checkbutton#tl:10:-20#o:showTitle:true#Show Title",
		"checkbutton#tl:10:-40#o:unlockWindow:true#Unlock Window",
		"font#tl:0:-57#r#s:0:40#(When unlocked, click to drag the frame. Use the lower right corner to resize the window)#0.5:0.5:0.5",
		"checkbutton#tl:10:-110#o:expandBuffs:true#Auto Expand Window",
		"font#tl:10:-92#v:ChatFontNormal#Background Color:",
		"colorswatch#tl:120:-92#o:backgroundColor:0,0,0,0.25#s:16:16#true",
		"checkbutton#tl:10:-130#o:showBorder#Show Window Border",
		"checkbutton#tl:10:-150#o:expandUpwards#Expand Buffs Upwards",
		"checkbutton#tl:10:-170#o:rightAlign#Display Icons on Right Side",
		"font#tl:35:-195#v:ChatFontNormal#Sort Type:",
		"dropdown#tl:85:-197#o:sortType:1#s:100:50#n:CTBuffModDropdown#Type#Time#Order#Name",
		"font#hidden#i:subSortTypeFont#tl:60:-215#v:ChatFontNormal#Sub-Sort Type:",
		"dropdown#hidden#i:subSortType#tl:135:-217#o:subSortType:1#s:100:50#n:CTBuffModDropdown2#Time#Order#Name",
		"checkbutton#hidden#i:keepRecastPosition#tl:60:-215#o:keepRecastPosition#Keep Recast Buff Position",
		
		-- Buff Options
		"font#tl:0:-260#v:GameFontNormalLarge#Buff Options",
		"slider#t:0:-280#s:170:17#o:buffSize:20#Buff Size - <value>#15:45:1",
		"slider#t:0:-310#s:170:17#o:buffSpacing:0#Buff Spacing - <value>#0:30:1",
		"checkbutton#tl:10:-330#o:showNames:true#Show Buff Names",
		"checkbutton#tl:10:-350#o:showTimers:true#Show Buff Duration",
		"font#tl:50:-375#v:ChatFontNormal#Format:",
		"dropdown#tl:95:-377#o:durationFormat#s:145:50#n:CTBuffModDropdown3#"
			.. "1 hour / 35 minutes#1 hour / 35 min#1h / 35m#1h 35m / 35m 15s#1:35h / 35:15",
		"font#tl:50:-395#v:ChatFontNormal#Location:",
		"dropdown#tl:95:-397#o:durationLocation#s:145:50#n:CTBuffModDropdown4#Side#Below",
		"checkbutton#tl:10:-420#o:colorCodeDebuffs#Color Code Debuff Names",
		"checkbutton#tl:10:-440#o:showItemBuffs:true#Show Item Buffs",
		"checkbutton#tl:10:-460#o:colorBuffs:true#Color Buffs",
		"checkbutton#tl:60:-480#o:showBuffTimer:true#Show Buff Timers",
		"checkbutton#tl:110:-500#o:showTimerBackground:true#Show Timer Background",
		
		-- Buff Expiration
		"font#tl:0:-530#v:GameFontNormalLarge#Buff Expiration",
		"checkbutton#tl:10:-550#o:flashIcons:true#Flash Icons on Buff Fade",
		"checkbutton#tl:10:-570#o:enableExpiration:true#Enable Buff Expiration Warning",
		"checkbutton#tl:60:-590#o:expirationCastOnly#Only for buffs you can cast",
		"checkbutton#tl:60:-610#o:expirationSound:true#Play Expiration Sound",
		
		-- Buff Expiration Timers
		"font#tl:0:-640#v:GameFontNormalLarge#Buff Expiration Timers",
		"font#t:-100:-660#v:ChatFontNormal#Buff Duration",
		"font#t:75:-660#v:ChatFontNormal#Expiration Warning Time",
		"font#t:-100:-685#2:00  -  10:00",
		"font#t:-100:-725#10:01  -  30:00",
		"font#t:-100:-765#30:01  - >",
		["slider#t:75:-685#o:expirationTime1:15#:Off:1 min.#0:60:5"] = buffExpirationSlider,
		["slider#t:75:-725#o:expirationTime2:60#:15 sec.:3 min.#15:180:5"] = buffExpirationSlider,
		["slider#t:75:-765#o:expirationTime3:180#:15 sec.:5 min.#15:300:5"] = buffExpirationSlider,
		
		["button#t:0:-795#s:170:30#v:GameMenuButtonTemplate#Reset Options to Default"] = {
			["onclick"] = function(self)
				CT_BuffModOptions = nil;
				ConsoleExec("RELOADUI");
			end
		},
		"font#t:0:-820#s:0:40#l#r#(Note: Resetting options to default will reload your UI)#0.5:0.5:0.5",
		
		["onload"] = updateSortType
	};
end

-- Show/Hide title
local options = {
	showTitle = function(self, value)
		if ( value ~= false ) then
			buffModFrame.title:Show();
		else
			buffModFrame.title:Hide();
		end
	end,
	
	unlockWindow = function(self, value)
		value = value ~= false;
		buffModFrame:EnableMouse(value);
		
		if ( value ) then
			buffModFrame.resize:Show();
		else
			buffModFrame.resize:Hide();
		end
	end,
	
	expandBuffs = function(self, value)
		module:expandBuffs(value ~= false);
	end,
	
	showBorder = function(self, value)
		buffModFrame:SetBackdropBorderColor(1, 1, 1, ( value and 1 ) or 0);
	end,
	
	expandUpwards = function(self, value)
		module.expandUpwards = value;
		buffObjectList:position();
	end,
	
	rightAlign = function(self, value)
		module.rightAlign = value;
		buffObjectList:display();
	end,
	
	showNames = function(self, value)
		module.showNames = value ~= false;
		buffObjectList:display();
	end,
	
	colorBuffs = function(self, value)
		module.colorBuffs = value ~= false;
		buffObjectList:display();
	end,
	
	showBuffTimer = function(self, value)
		module:showBuffTimers(value ~= false);
	end,
	
	buffSize = function(self, value)
		module:setBuffSize(value);
	end,
	
	showTimers = function(self, value)
		module.showTimers = value ~= false;
		buffObjectList:display();
	end,
	
	showTimerBackground = function(self, value)
		module.showTimerBackground = value ~= false;
		buffObjectList:display();
	end,
	
	showItemBuffs = function(self, value)
		module:showItemBuffs(value ~= false);
	end,
	
	flashIcons = function(self, value)
		module.flashIcons = value ~= false;
		buffObjectList:checkExpiration();
	end,
	
	enableExpiration = function(self, value)
		module.enableExpiration = value ~= false;
		buffObjectList:checkExpiration();
	end,
	
	expirationSound = function(self, value)
		module.expirationSound = value ~= false;
	end,
	
	expirationCastOnly = function(self, value)
		module.expirationCastOnly = value;
	end,
	
	sortType = function(self, value)
		module:setSortType(value or 1);
		
		local frame = module.frame;
		if ( type(frame) ~= "function" ) then
			updateSortType(frame, value or 1);
		end
	end,
	
	subSortType = function(self, value)
		module:setSubSortType(value or 1);
		local frame = module.frame;
		if ( type(frame) ~= "function" ) then
			updateSortType(frame);
		end
	end,
	
	keepRecastPosition = function(self, value)
		module.keepRecastPosition = value;
	end,
	
	expirationTime1 = function(self, value)
		module:setExpiration(1, value or 15);
	end,
	
	expirationTime2 = function(self, value)
		module:setExpiration(2, value or 60);
	end,
	
	expirationTime3 = function(self, value)
		module:setExpiration(3, value or 180);
	end,
	
	durationFormat = function(self, value)
		module:setTimeFormat(value or 1);
	end,
	
	durationLocation = function(self, value)
		module.durationBelow = value == 2;
		buffObjectList:display();
	end,
	
	backgroundColor = function(self, value)
		if ( value ) then
			buffModFrame:SetBackdropColor(unpack(value));
		else
			buffModFrame:SetBackdropColor(0, 0, 0, 0.25);
		end
	end,
	
	colorCodeDebuffs = function(self, value)
		module.colorCodeDebuffs = value;
		buffObjectList:display();
	end,
	
	buffSpacing = function(self, value)
		module:setSpacing(value or 0);
		buffObjectList:position();
	end
};

module.update = function(self, type, value)
	self:mainupdate(type, value);
	if ( type == "init" ) then
		for key, val in pairs(options) do
			val(self, self:getOption(key));
		end
	else
		local f = options[type];
		if ( f ) then
			f(self, value);
		end
	end
end