----------------------------------------------------------------------
-- Variables
----------------------------------------------------------------------

-- Basic Addon Variables
MYREP_NAME = "myReputation";
MYREP_VERSION = "20000 R.1 Beta3";
MYREP_MSG_FORMAT = "%s |cff00ff00%s|r%s"
MYREP_REGEXP_DECREASED = string.gsub( FACTION_STANDING_DECREASED, "'?%%[s|d]'?", "%(.+)" ); 
MYREP_REGEXP_INCREASED = string.gsub( FACTION_STANDING_INCREASED, "'?%%[s|d]'?", "%(.+)" ); 

-- Configuration Variables and their Standard Values
myReputation_Config = { };
myReputation_Config.Enabled = true;
myReputation_Config.More = true;
myReputation_Config.Blizz = false;
myReputation_Config.BlizzFrame = 1;
myReputation_Config.Splash = true;
myReputation_Config.Percent = true;
myReputation_Config.Debug = false;
myReputation_Config.Frame = 2;

-- Temp Variables and Arrays
myReputations = { };
mySessionReputations = { };
myReputation_Var = { };
myReputation_Var.InWorld = false;
myReputation_Var.Help = {
    MYREP_HELP_TEXT0,
    MYREP_HELP_TEXT1,
    MYREP_HELP_TEXT2,
    MYREP_HELP_TEXT3,
    MYREP_HELP_TEXT4,
    MYREP_HELP_TEXT5,
    MYREP_HELP_TEXT6,
    MYREP_HELP_TEXT7,
    MYREP_HELP_TEXT8,
    MYREP_HELP_TEXT9,
};

-- Function Hooks
local lOriginal_ReputationFrame_Update;
local lOriginal_CFAddMessage;

----------------------------------------------------------------------
-- OnFoo
----------------------------------------------------------------------

function myReputation_OnLoad()
    --Slash command
    SlashCmdList["REPUTATIONCOMMAND"] = myReputation_SlashHandler;
    SLASH_REPUTATIONCOMMAND1 = "/reputation";
    SLASH_REPUTATIONCOMMAND2 = "/rep";

    -- Register Default Events
    this:RegisterEvent("PLAYER_LOGIN");
    this:RegisterEvent("PLAYER_ENTERING_WORLD");
    this:RegisterEvent("PLAYER_TARGET_CHANGED");
    this:RegisterEvent("PLAYER_LEAVING_WORLD");

    if (DEFAULT_CHAT_FRAME) then
        myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_NAME,MYREP_VERSION," "..MYREP_MSG_LOADED.."."));
    end
end

function myReputation_OnEvent(event, arg1)
    -- Fired just before PLAYER_ENTERING_WORLD on login and UI Reload
    if (event == "PLAYER_LOGIN") then
        if (myReputation_Config.BlizzFrame == nil) then
            myReputation_Config.BlizzFrame = 1;
        end
        if (
            (myReputation_Config.Frame > 0) and
            (myReputation_Config.Frame <= FCF_GetNumActiveChatFrames())
        ) then
            REPUTATIONS_CHAT_FRAME = getglobal("ChatFrame"..myReputation_Config.Frame);
        else
            REPUTATIONS_CHAT_FRAME = DEFAULT_CHAT_FRAME;
        end
        myReputation_Toggle(myReputation_Config.Enabled,true);
	end

    -- Register Ingame Events
    if (event == "PLAYER_ENTERING_WORLD") then
        this:RegisterEvent("UPDATE_FACTION");
	end

    -- Event PLAYER_TARGET_CHANGED as I found nothing else which was usable to get numFactions > 0
    if (event == "PLAYER_TARGET_CHANGED") then

		-- Save Session StartRep
		if (not mySessionReputations["Darnassus"]) then
			
	        local numFactions = GetNumFactions();
			local factionIndex;
	        local name, standingID, barMin, barMax, barValue, isHeader;
	        
	        for factionIndex=1, numFactions, 1 do
	            name, _, standingID, barMin, barMax, barValue, _, _, isHeader, _, _ = GetFactionInfo(factionIndex);

	            if (not isHeader) then
	                barMax = barMax - barMin;
	                barValue = barValue - barMin;
	                barMin = 0;
	                mySessionReputations[name] = { };
	                mySessionReputations[name].standingID = standingID;
	                mySessionReputations[name].barValue = barValue;
	                mySessionReputations[name].barMax = barMax;
					
	            end
	        end
		end
	end

    -- Event UPDATE_FACTION
    if (
        (event == "UPDATE_FACTION") and
        (myReputation_Config.Enabled == true)
    ) then
        myReputation_Factions_Update();
    end

    -- Unregister Ingame Events
    if (event == "PLAYER_LEAVING_WORLD") then
        this:UnregisterEvent("UPDATE_FACTION");
    end

end

----------------------------------------------------------------------
-- Other Functions
----------------------------------------------------------------------

-- Send Message to Chat Frame
function myReputation_ChatMsg(message)
    DEFAULT_CHAT_FRAME:AddMessage(message);
end

-- Send Message to Reputation Chat Frame
function myReputation_RepMsg(message,r,g,b)
    REPUTATIONS_CHAT_FRAME:AddMessage(message,r,g,b);
end

-- Send Message to Splash Frame
function myReputation_SplashMessage(message,r,g,b)
    myReputation_SplashFrame:AddMessage(message, r,g,b, 1.0, UIERRORS_HOLD_TIME);
end

-- SlashHandler
function myReputation_SlashHandler(msg)
    local index, value;
    if (not msg or msg == "") then
        for index, value in pairs(myReputation_Var.Help) do
            myReputation_ChatMsg(value);
        end
    else
        local command=strlower(msg);
        if (command == MYREP_CMD_ON) then
            myReputation_Toggle(true,false);
        elseif (command == MYREP_CMD_OFF) then
            myReputation_Toggle(false,false);
        elseif (command == MYREP_CMD_MORE) then
            Reputation_Toggle_Options("More");
        elseif (command == MYREP_CMD_BLIZZ) then
            Reputation_Toggle_Options("Blizz");
        elseif (command == MYREP_CMD_SPLASH) then
            Reputation_Toggle_Options("Splash");
        elseif (command == MYREP_CMD_PERCENT) then
            Reputation_Toggle_Options("Percent");
        elseif (strfind(command,"^"..MYREP_CMD_BLIZZFRAME.." ")) then
            local blizzchannel;
            _,_,blizzchannel = strfind(command,"^"..MYREP_CMD_BLIZZFRAME.."%s+(%d+)%s*$");
            if (blizzchannel) then
                blizzchannel = tonumber(blizzchannel);
                myReputation_BlizzFrame_Change(0,blizzchannel);
            else
                _,_,blizzchannel = strfind(command,"^"..MYREP_CMD_BLIZZFRAME.."%s*(.+)%s*$");
                myReputation_ChatMsg(format(MYREP_MSG_INVALID_FRAME,blizzchannel));
                myReputation_ChatMsg(format(MYREP_MSG_VALID_FRAMES,FCF_GetNumActiveChatFrames()));
            end
        elseif (strfind(command,"^"..MYREP_CMD_FRAME.." ")) then
            local repchannel;
            _,_,repchannel = strfind(command,"^"..MYREP_CMD_FRAME.."%s+(%d+)%s*$");
            if (repchannel) then
                repchannel = tonumber(repchannel);
                myReputation_ChatFrame_Change(0,repchannel);
            else
                _,_,repchannel = strfind(command,"^"..MYREP_CMD_FRAME.."%s*(.+)%s*$");
                myReputation_ChatMsg(format(MYREP_MSG_INVALID_FRAME,repchannel));
                myReputation_ChatMsg(format(MYREP_MSG_VALID_FRAMES,FCF_GetNumActiveChatFrames()));
            end
        elseif (command == MYREP_CMD_STATUS) then
            if (myReputation_Config.Enabled == true) then
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_NAME,MYREP_MSG_ON,"."));
            else
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_NAME,MYREP_MSG_OFF,"."));
            end
            if (myReputation_Config.More == true) then
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_MORE,MYREP_MSG_ON,"."));
            else
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_MORE,MYREP_MSG_OFF,"."));
            end
            if (myReputation_Config.Blizz == true) then
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_BLIZZ,MYREP_MSG_ON,"."));
            else
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_BLIZZ,MYREP_MSG_OFF,"."));
            end
            myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_BLIZZFRAME,myReputation_Config.BlizzFrame,"."));
            if (myReputation_Config.Splash == true) then
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_SPLASH,MYREP_MSG_ON,"."));
            else
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_SPLASH,MYREP_MSG_OFF,"."));
            end
            if (myReputation_Config.Percent == true) then
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_PERCENT,MYREP_MSG_ON,"."));
            else
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_PERCENT,MYREP_MSG_OFF,"."));
            end
            if (myReputation_Config.Debug == true) then
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_DEBUG,MYREP_MSG_ON,"."));
            end
            myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_FRAME,myReputation_Config.Frame,"."));
        elseif (command == MYREP_CMD_DEBUG) then
            Reputation_Toggle_Options("Debug");
        elseif (strfind(command,"^"..MYREP_CMD_TEST.." @")) then
            local testvalue, factionnumber;
            _, _, testvalue, factionnumber = strfind(command,"^"..MYREP_CMD_TEST.." @".."%s*(%d+)%s+(%d+)%s*$");
            if (testvalue ~= nil) then
                myReputation_Testing("+", testvalue, factionnumber);
            end
        else
            for index, value in pairs(myReputation_Var.Help) do
                myReputation_ChatMsg(value);
            end
        end
    end
end

-- Testing
function myReputation_Testing(modifier,difference,factionIndex)

    myReputation_ChatMsg(format(MYREP_MSG_FORMAT,"Test",modifier..difference,"."));

    local name, standingID, barMin, barMax, barValue, isHeader;

    COMBAT_CHAT_FRAME = getglobal("ChatFrame2");

    _, _, _, _, _, _, _, _, isHeader, _, _ = GetFactionInfo(factionIndex);

	if ( isHeader ) then
        factionIndex = 2;
        myReputation_ChatMsg(format(MYREP_MSG_FORMAT,"Test Fraktion",factionIndex,"."));
    end

    name, _, standingID, barMin, barMax, barValue, atWarWith, _, isHeader, _, _ = GetFactionInfo(factionIndex);

    local tmpStandingID = standingID;
    local tmpBarMax = barMax - barMin;
    local tmpBarValue = barValue - barMin;
    local tmpBarMin = 0;

    difference = tonumber(difference);

    if (
        ((modifier == "+") and (difference > tmpBarValue)) or
        ((modifier == "-") and (difference > tmpBarMax - tmpBarValue))
    ) then
        if (modifier == "+") then
            tmpStandingID = tmpStandingID - 1;
        elseif (modifier == "-") then
            tmpStandingID = tmpStandingID + 1;
        end

        local Units = { };
        Units[1] = 36000; -- Hated
        Units[2] = 3000; -- Hostile
        Units[3] = 3000; -- Unfriendly
        Units[4] = 3000; -- Neutral
        Units[5] = 6000; -- Friendly
        Units[6] = 12000; -- Honored
        Units[7] = 21000; -- Revered
        Units[8] = 1000; -- Exalted

        if (modifier == "+") then
            tmpBarValue = Units[tmpStandingID] + tmpBarValue - difference;
        elseif (modifier == "-") then
            tmpBarValue = difference - Units[tmpStandingID-1] + tmpBarValue;
        end
        tmpBarMax = Units[tmpStandingID];
    else
        if (modifier == "+") then
            tmpBarValue = tmpBarValue - difference;
        elseif (modifier == "-") then
            tmpBarValue = tmpBarValue + difference;
        end
    end

    myReputations[name].standingID = tmpStandingID;
    myReputations[name].barValue = tmpBarValue;
    myReputations[name].barMax = tmpBarMax;
    myReputations[name].atWarWith = atWarWith;

    local msg_global;

    if (modifier == "+") then
        msg_global = "FACTION_STANDING_INCREASED";
    elseif (modifier == "-") then
        msg_global = "FACTION_STANDING_DECREASED";
    end

    msg = format(getglobal(msg_global), name, difference);
    COMBAT_CHAT_FRAME:AddMessage(msg);
    myReputation_Factions_Update();

end

-- Toggles
function myReputation_Toggle(toggle,init)
    myReputation_Config.Enabled = toggle;
    if (toggle == true) then

        --Hook
        if (not lOriginal_ReputationFrame_Update) then
            if (init ~= true) then
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_NAME,MYREP_MSG_ON,"."));
            end
            lOriginal_ReputationFrame_Update = ReputationFrame_Update;
            ReputationFrame_Update = myReputation_Frame_Update_New;
        end
        if (not lOriginal_CFAddMessage) then
            lOriginal_CFAddMessage = getglobal("ChatFrame"..myReputation_Config.BlizzFrame).AddMessage;
            getglobal("ChatFrame"..myReputation_Config.BlizzFrame).AddMessage = myReputation_CFAddMessage;
        end
    else

        --Unhook
        if (lOriginal_ReputationFrame_Update) then
            if (init ~= true) then
                myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_NAME,MYREP_MSG_OFF,"."));
            end
            ReputationFrame_Update = lOriginal_ReputationFrame_Update;
            lOriginal_ReputationFrame_Update = nil;
        end
        if (lOriginal_CFAddMessage) then
            getglobal("ChatFrame"..myReputation_Config.BlizzFrame).AddMessage = lOriginal_CFAddMessage;
            lOriginal_CFAddMessage = nil;
        end
    end
end

function Reputation_Toggle_Options(option)
    if (myReputation_Config[option] == true) then
        myReputation_Config[option] = false;
        myReputation_ChatMsg(format(MYREP_MSG_FORMAT,getglobal("MYREP_MSG_"..string.upper(option)),MYREP_MSG_OFF,"."));
    else
        myReputation_Config[option] = true;
        myReputation_ChatMsg(format(MYREP_MSG_FORMAT,getglobal("MYREP_MSG_"..string.upper(option)),MYREP_MSG_ON,"."));
    end
end

function myReputation_BlizzFrame_Change(checked,value)  --Checked will always be 0
    if (value) then
        if (value > 0 and value <= FCF_GetNumActiveChatFrames()) then
            myReputation_Config.BlizzFrame = value;
            myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_BLIZZFRAME,myReputation_Config.BlizzFrame,"."));
            ReloadUI();
        else
            myReputation_ChatMsg(format(MYREP_MSG_INVALID_FRAME,value));
            myReputation_ChatMsg(format(MYREP_MSG_VALID_FRAMES,FCF_GetNumActiveChatFrames()));
        end
    end
end

function myReputation_ChatFrame_Change(checked,value)  --Checked will always be 0
    if (value) then
        if (value > 0 and value <= FCF_GetNumActiveChatFrames()) then
            myReputation_Config.Frame = value;
            myReputation_ChatMsg(format(MYREP_MSG_FORMAT,MYREP_MSG_FRAME,myReputation_Config.Frame,"."));
            REPUTATIONS_CHAT_FRAME = getglobal("ChatFrame"..myReputation_Config.Frame);
            myReputation_RepMsg(MYREP_MSG_NOTIFY,1.0,1.0,0.0);
        else
            myReputation_ChatMsg(format(MYREP_MSG_INVALID_FRAME,value));
            myReputation_ChatMsg(format(MYREP_MSG_VALID_FRAMES,FCF_GetNumActiveChatFrames()));
        end
    end
end

-- Hooked Functions
function myReputation_CFAddMessage(self, msg, ...)
    if (
		(myReputation_Config.Blizz == false) and
        (msg ~= nil) and
        (
            string.find(msg, MYREP_REGEXP_DECREASED) or
            string.find(msg, MYREP_REGEXP_INCREASED)
        )
    ) then
		if (myReputation_Config.Debug == true) then
                	myReputation_RepMsg("Blizzard Meldung in Frame "..myReputation_Config.BlizzFrame.." abgefangen");
        end
    else
        lOriginal_CFAddMessage(self, msg, ...);
    end
end

function myReputation_Frame_Update_New()
    lOriginal_ReputationFrame_Update();
    local numFactions = GetNumFactions();
    local factionOffset = FauxScrollFrame_GetOffset(ReputationListScrollFrame);
    local factionIndex, factionStanding, factionBar, factionHeader, color, tooltipStanding;
    local name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed;
    local factionCompleteInfo;
    local difference;

    for i=1, NUM_FACTIONS_DISPLAYED, 1 do
        factionIndex = factionOffset + i;
        factionBar = getglobal("ReputationBar"..i);
        if ( factionIndex <= numFactions ) then
            name, description, standingID, barMin, barMax, barValue, _, _, isHeader, _, _ = GetFactionInfo(factionIndex);

            if ( not isHeader ) then
                barMax = barMax - barMin;
                barValue = barValue - barMin;
                barMin = 0;

                factionStanding = getglobal("FACTION_STANDING_LABEL"..standingID);

                if (myReputation_Config.Percent == true) then
                    factionCompleteInfo = factionStanding.." - "..format("%.2f%%",barValue/barMax*100);
                    factionTooltip = barValue.."/"..barMax;
                else
                    factionCompleteInfo = factionStanding.." - "..barValue.."/"..barMax;
                    factionTooltip = format("%.2f%%",barValue/barMax*100);
                end

                if (mySessionReputations[name]) then

                    -- No change in standing
                    if (mySessionReputations[name].standingID == standingID) then

                    difference = barValue - mySessionReputations[name].barValue;

                    -- Reputation went up and reached next standing
                    elseif (mySessionReputations[name].standingID < standingID) then
                    difference = barValue + mySessionReputations[name].barMax - mySessionReputations[name].barValue;

                    -- Reputation went down and reached next standing
                    else
                    difference = barMax - barValue + mySessionReputations[name].barValue;

                    end

                    factionTooltip = factionTooltip.." ("..difference..")";

                end

                getglobal("ReputationBar"..i.."FactionStanding"):SetText(factionCompleteInfo);
                factionBar.tooltip = HIGHLIGHT_FONT_COLOR_CODE..factionTooltip..FONT_COLOR_CODE_CLOSE;
                factionBar.standingText = factionCompleteInfo;
            end
        end
    end
end

-- Event UPDATE_FACTION
function myReputation_Factions_Update()
    local numFactions = GetNumFactions();
    local factionIndex, factionStanding, factionBar, factionHeader, color;
    local name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched;
    local barValue, RepRemains, RepRepeats;
    local RepBefore, RepActual, RepNext;

    for factionIndex=1, numFactions, 1 do
    name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, isWatched = GetFactionInfo(factionIndex);

    if (not isHeader) then

    barMax = barMax - barMin;
    barValue = barValue - barMin;
    barMin = 0;

    if (myReputations[name]) then

    if (standingID ~= 1) then
    RepBefore = getglobal("FACTION_STANDING_LABEL"..standingID-1);
    end
    RepActual = getglobal("FACTION_STANDING_LABEL"..standingID);
    if (standingID ~= 8) then
    RepNext = getglobal("FACTION_STANDING_LABEL"..standingID+1);
    end

    local RawTotal = 0;

    -- No change in standing
    if (myReputations[name].standingID == standingID) then

    local difference = barValue - myReputations[name].barValue;

    -- Reputation went up
    if ((difference > 0) and (myReputations[name].standingID == standingID)) then
    myReputation_RepMsg(format(MYREP_NOTIFICATION_GAINED,name,difference,barValue,barMax), 0.5, 0.5, 1.0);
    if (standingID ~= 8) then
    RepRemains = barMax - barValue;
    RepRepeats = RepRemains / difference;
    if (RepRepeats > floor(RepRepeats)) then
    RepRepeats = ceil(RepRepeats);
    end
    if (myReputation_Config.More == true) then
    myReputation_RepMsg(format(MYREP_NOTIFICATION_NEEDED,RepRemains,RepRepeats,RepNext), 1.0, 1.0, 0.0);
    end
    end

    -- Reputation went down
    elseif ((difference < 0) and (myReputations[name].standingID == standingID)) then
    difference = abs(difference);
    myReputation_RepMsg(format(MYREP_NOTIFICATION_LOST,name,difference,barValue,barMax), 0.5, 0.5, 1.0);
    if (standingID ~= 1) then
    RepRemains = barValue;
    RepRepeats = RepRemains / difference;
    if (RepRepeats > floor(RepRepeats)) then
    RepRepeats = ceil(RepRepeats);
    end
    if (myReputation_Config.More == true) then
    myReputation_RepMsg(format(MYREP_NOTIFICATION_LEFT,RepRemains,RepRepeats,RepBefore), 1.0, 1.0, 0.0);
    end
    end
    end

    -- Reputation went up and reached next standing
    elseif (myReputations[name].standingID < standingID) then
    RepRemains = barMax - barValue;
    RawTotal = barValue + myReputations[name].barMax - myReputations[name].barValue;
    myReputation_RepMsg(format(MYREP_NOTIFICATION_GAINED,name,RawTotal,barValue,barMax), 0.5, 0.5, 1.0);
    myReputation_RepMsg(format(MYREP_NOTIFICATION_REACHED,RepActual,name), 1.0, 1.0, 0.0);
    if (standingID ~= 8) then
    RepRepeats = RepRemains / RawTotal;
    if (RepRepeats > floor(RepRepeats)) then
    RepRepeats = ceil(RepRepeats);
    end
    if (myReputation_Config.More == true) then
    myReputation_RepMsg(format(MYREP_NOTIFICATION_NEEDED,RepRemains,RepRepeats,RepNext), 1.0, 1.0, 0.0);
    end
    if (myReputation_Config.Debug == true) then
    myReputation_RepMsg(format("%s - Old %s New %s", name, myReputations[name].barValue .. "/" .. myReputations[name]. barMax .. " (" .. RepBefore .. ")", barValue .. "/" .. barMax .. " (" .. RepActual .. ")"));
    end
    end

    if (myReputation_Config.Splash == true) then
    myReputation_SplashMessage(name.." - "..RepActual.."!", 1.0, 1.0, 0.0);
    end

    -- Reputation went down and reached next standing
    else
    RepRemains = barValue;
    RawTotal = barMax - barValue + myReputations[name].barValue;
    myReputation_RepMsg(format(MYREP_NOTIFICATION_LOST,name,RawTotal,barValue,barMax), 0.5, 0.5, 1.0);
    myReputation_RepMsg(format(MYREP_NOTIFICATION_REACHED,RepActual,name), 1.0, 1.0, 0.0);
    if (standingID ~= 1) then
    RepRepeats = RepRemains / RawTotal;
    if (RepRepeats > floor(RepRepeats)) then
    RepRepeats = ceil(RepRepeats);
    end
    if (myReputation_Config.More == true) then
    myReputation_RepMsg(format(MYREP_NOTIFICATION_LEFT,RepRemains,RepRepeats,RepBefore), 1.0, 1.0, 0.0);
    end
    if (myReputation_Config.Debug == true) then
    myReputation_RepMsg(format("%s - Old %s New %s", name, myReputations[name].barValue .. "/" .. myReputations[name]. barMax .. " (" .. RepNext .. ")", barValue .. "/" .. barMax .. " (" .. RepActual .. ")"));
    end
    end

    if (myReputation_Config.Splash == true) then
    myReputation_SplashMessage(name.." - "..RepActual.."!", 1.0, 1.0, 0.0);
    end

    end

    else
    myReputations[name] = { };
    end

    myReputations[name].standingID = standingID;
    myReputations[name].barValue = barValue;
    myReputations[name].barMax = barMax;
    myReputations[name].atWarWith = atWarWith;
    end
    end
end