function TitanUtils_CheckPlayerName()
	if (gotPlayerName) then
		return true;
	end
	local pName = UnitName("player");
	if ((pName ~= nil) and (pName ~= UNKNOWNOBJECT) and (pName ~= UNKNOWNBEING)) then
		TitanPlayerName = pName;
		gotPLayerName = true;
		return true;
	end
	return false;
end

function TitanUtils_GetPlayerSettings(id, key)
--	debug("Getting variable "..tostring(key).." in module "..tostring(id));
	return TitanGetVar(id, key);
end

function TitanUtils_SetPlayerSettings(id, key, val)
	TitanSetVar(id, key, val);
end

function TitanUtils_InitPlayerSettingsForPlugin(id, defaults)
	for k,v in pairs(defaults) do
		if (TitanGetVar(id, k) == TITAN_NIL) then
			-- debug(id..": "..k.." = "..v);
			TitanSetVar(id, k, v);
		end
	end
end

function TitanUtils_LoadSettings(event)
	if (event == "VARIABLES_LOADED") then
		gotVariable = true;
	
		if (TitanUtils_CheckPlayerName() and not TitanIsInited) then
			TitanDPS_InitVariables();
		end
	elseif (event == "PLAYER_ENTERING_WORLD" or event == "UNIT_NAME_UPDATE") then
		if (TitanUtils_CheckPlayerName() and not TitanIsInited) then
			TitanDPS_InitVariables();
		end
  	end
end

function TitanUtils_InitSettings()
	if (TitanIsInited) then
		return;
	end
	TitanIsInited = true;
end          