--[[ Unstored Variables
titanDPS_ravgDamageTable = {};
titanDPS_ravgPlayersTable = {};
titanDPS_ravgTimestampsTable = {};

titanDPS_ravgDamageTakenTable = {};
titanDPS_ravgPlayersTakenTable = {};
titanDPS_ravgTimestampsTakenTable = {};

titanDPS_ravgDamage = {};
titanDPS_ravgDamageTaken = {};
titanDPS_ravgCombatTime = 0.05;

titanDPS_sessionDamage = {};
titanDPS_sessionDamageTaken = {};
titanDPS_sessionCombatTime = 0.05;

-- Set these here...
titanDPS_ravgDamage["Your"] = 0;
titanDPS_ravgDamageTaken["Your"] = 0;
titanDPS_sessionDamage["Your"] = 0;
titanDPS_sessionDamageTaken["Your"] = 0;

titanDPS_petLevel = 0;
titanDPS_petLevel_old = 0;

titanDPS_InCombat = false;
]]--

-- TitanDPS Functions
function TitanDPS_IsPetClass()
    if (not titanDPS_class) then
        titanDPS_class = UnitClass("player");
   end;
   return ((titanDPS_class == "Hunter" or titanDPS_class == "Warlock"));
end

if (TitanDPS_IsPetClass()) then
    if (not titanDPS_runtimeStats) then
        titanDPS_runtimeStats = {};
    end;
    titanDPS_runtimeStats["ravgPetDPS"] = 0;
    titanDPS_runtimeStats["sessionPetDPS"] = 0;
end

function TitanDPS_InitVariables()
    if (TITAN_DPS_LOADED) then
        return;
    end
    --debug("DPS Init Variable");
    
    -- Unstored Variables
    titanDPS_ravgDamageTable = {};
    titanDPS_ravgPlayersTable = {};
    titanDPS_ravgTimestampsTable = {};
    
    titanDPS_ravgDamageTakenTable = {};
    titanDPS_ravgPlayersTakenTable = {};
    titanDPS_ravgTimestampsTakenTable = {};
    
    titanDPS_ravgDamage = {};
    titanDPS_ravgDamageTaken = {};
    titanDPS_ravgCombatTime = 0.05;

    titanDPS_sessionDamage = {};
    titanDPS_sessionDamageTaken = {};
    titanDPS_sessionCombatTime = 0.05;


    -- Set these here...
    titanDPS_ravgDamage["Your"] = 0;
    titanDPS_ravgDamageTaken["Your"] = 0;
    titanDPS_sessionDamage["Your"] = 0;
    titanDPS_sessionDamageTaken["Your"] = 0;

    titanDPS_runtimeStats = {};
    titanDPS_runtimeStats["ravgDPS"] = 0;
    titanDPS_runtimeStats["ravgDPSTaken"] = 0;

    titanDPS_runtimeStats["sessionDPS"] = 0;
    titanDPS_runtimeStats["sessionDPSTaken"] = 0;

    titanDPS_runtimeStats["levelDPS"] = 0;
    titanDPS_runtimeStats["levelDPSTaken"]  = 0;

    titanDPS_runtimeStats["globalDPS"] = 0;
    titanDPS_runtimeStats["globalDPSTaken"]  = 0;
    
    titanDPS_petLevel = 0;
    titanDPS_petLevel_old = 0;

    if (TitanDPS_IsPetClass()) then
        titanDPS_ravgDamage["Pet"] = 0;
        titanDPS_ravgDamageTaken["Pet"] = 0;
        titanDPS_sessionDamage["Pet"] = 0;
        titanDPS_sessionDamageTaken["Pet"] = 0;

        titanDPS_runtimeStats["ravgPetDPS"] = 0;
        titanDPS_runtimeStats["ravgPetDPSTaken"] = 0;
        titanDPS_runtimeStats["sessionPetDPS"] = 0;
        titanDPS_runtimeStats["sessionPetDPSTaken"] = 0;
        titanDPS_runtimeStats["levelPetDPS"] = 0;
        titanDPS_runtimeStats["levelPetDPSTaken"]  = 0;
        titanDPS_runtimeStats["globalPetDPS"] = 0;
        titanDPS_runtimeStats["globalPetDPSTaken"]  = 0;
    end

    titanDPS_lastUpdate = 0;

    -- Stored Variables 
    local defaults = {
        ShowDPS = "rAvg",
        Version = TITAN_DPS_VERSION,
        
        Stats_Damage = 0,
        Stats_Damage_Level = 0,
        Stats_DamageTaken = 0,
        Stats_DamageTaken_Level = 0,
        Stats_CombatTime = 0.05,
        Stats_CombatTime_Level = 0.05,
        ShowCombined = 0,
    }

    if (TitanDPS_IsPetClass()) then
        defaults.Stats_Pet_Level = 0;
        defaults.Stats_Pet_Damage = 0;
        defaults.Stats_Pet_Damage_Level = 0;
        defaults.Stats_Pet_DamageTaken = 0;
        defaults.Stats_Pet_DamageTaken_Level = 0;
        defaults.Stats_Pet_CombatTime_Level = 0.05;
    end

    if (TitanUtils_GetPlayerSettings(TITAN_DPS, "Version") ~= TITAN_DPS_VERSION) then
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Version", TITAN_DPS_VERSION);
        -- Insert new Variables for this version here...
    end
    TitanUtils_InitPlayerSettingsForPlugin(TITAN_DPS, defaults);
    -- make sure the version is current
    TitanUtils_SetPlayerSettings(TITAN_DPS, "Version", TITAN_DPS_VERSION);

    TITAN_DPS_LOADED = true; 
end

function TitanDPS_ResetVariables()
    titanDPS_ravgDamage["Your"] = 0;
    titanDPS_ravgDamageTaken["Your"] = 0;
    titanDPS_sessionDamage["Your"] = 0;
    titanDPS_sessionDamageTaken["Your"] = 0;

    -- Stored Variables 
    local defaults = {
        Stats_Damage = 0,
        Stats_DamageTaken = 0,
        Stats_Damage_Level = 0,
        Stats_DamageTaken_Level = 0,
        Stats_CombatTime = 0.05,
        Stats_CombatTime_Level = 0.05,
        ShowCombined = 0,
    }

    if (TitanDPS_IsPetClass()) then
        titanDPS_ravgDamage["Pet"] = 0;
        titanDPS_ravgDamageTaken["Pet"] = 0;
        titanDPS_sessionDamage["Pet"] = 0;
        titanDPS_sessionDamageTaken["Pet"] = 0;

        defaults.Stats_Pet_Level = 0;
        defaults.Stats_Pet_Damage = 0;
        defaults.Stats_Pet_DamageTaken = 0;
        defaults.Stats_Pet_Damage_Level = 0;
        defaults.Stats_Pet_DamageTaken_Level = 0;
        defaults.Stats_Pet_CombatTime_Level = 0.05;
    end

    for k,v in pairs(defaults) do
        -- debug(id..": "..k.." = "..v);
        TitanSetVar(TITAN_DPS, k, v);
    end
end

function TitanDPS_Reset()
    TITAN_DPS_LOADED = false;
    TitanDPS_ResetVariables();
end

function TitanDPS_AddDPSEntry(p, d)
    table.insert(titanDPS_ravgTimestampsTable, GetTime());
    table.insert(titanDPS_ravgPlayersTable, p);
    table.insert(titanDPS_ravgDamageTable, d);
    
    -- Update DPS Totals
    if (titanDPS_ravgDamage[p] == nil) then
        titanDPS_ravgDamage[p] = d;
    else
        titanDPS_ravgDamage[p] = titanDPS_ravgDamage[p] + d;
    end
    
    -- Update total for Session and Overall damage output
    if (titanDPS_sessionDamage[p] == nil) then
        titanDPS_sessionDamage[p] = d;
    else
        titanDPS_sessionDamage[p] = titanDPS_sessionDamage[p] + d;
    end

    if (p == "Your") then
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_Damage", (TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Damage") + d) );
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_Damage_Level", (TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Damage_Level") + d) );
    elseif (p == "Pet" and TitanDPS_IsPetClass() and UnitExists("pet")) then
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_Pet_Damage", (TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_Damage") + d) );
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_Pet_Damage_Level", (TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_Damage_Level") + d) );
    end
end

function TitanDPS_AddDefDPSEntry(p, d)
    table.insert(titanDPS_ravgTimestampsTakenTable, GetTime());
    table.insert(titanDPS_ravgPlayersTakenTable, p);
    table.insert(titanDPS_ravgDamageTakenTable, d);

    -- Update DPS Totals
    if (titanDPS_ravgDamageTaken[p] == nil) then
        titanDPS_ravgDamageTaken[p] = d;
    else
        titanDPS_ravgDamageTaken[p] = titanDPS_ravgDamageTaken[p] + d;
    end

    -- Update total for Session and Overall damage output
    if (titanDPS_sessionDamageTaken[p] == nil) then
        titanDPS_sessionDamageTaken[p] = d;
    else
        titanDPS_sessionDamageTaken[p] = titanDPS_sessionDamageTaken[p] + d;
    end
    
    if (p == "Your") then
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_DamageTaken", (TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_DamageTaken") + d) );
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_DamageTaken_Level", (TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_DamageTaken_Level") + d) );
    elseif (p == "Pet" and TitanDPS_IsPetClass() and UnitExists("pet")) then
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_Pet_DamageTaken", (TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_DamageTaken") + d) );
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_Pet_DamageTaken_Level", (TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_DamageTaken_Level") + d) );
    end
end

function TitanDPS_UpdateCurrentData(elapse)
    local currentTime = GetTime();
    local oldestTime = 0;
    
    if (titanDPS_InCombat) then
            -- Only change value if we're in combat...otherwise it'll keep counting down...
            local deleteIndex = 0;
    
        -- Damage We've Dealt...
        for k,v in pairs(titanDPS_ravgTimestampsTable) do
            -- Here we find the oldest timestamp we care about
            if ( (currentTime - TITAN_DPS_RAVG_LENGTH) > v ) then
                -- We should subtract the damage from our ravg totals;
                titanDPS_ravgDamage[titanDPS_ravgPlayersTable[k]] = titanDPS_ravgDamage[titanDPS_ravgPlayersTable[k]] - titanDPS_ravgDamageTable[k];

                -- We can't actually remove the entry yet.  table.remove will reindex and screw our loop.
                deleteIndex = k;
            else
                -- As soon as we find the first time that is within our running time...
                oldestTime = v;
                break;
            end
        end

        -- Clean up our tables by removing all the old entries
        while (deleteIndex > 0) do
            table.remove(titanDPS_ravgTimestampsTable, deleteIndex);
            table.remove(titanDPS_ravgPlayersTable, deleteIndex);
            table.remove(titanDPS_ravgDamageTable, deleteIndex);
            deleteIndex = deleteIndex - 1;
        end

        -- Damage We've Taken...
        for k,v in pairs(titanDPS_ravgTimestampsTakenTable) do
            -- Here we find the oldest timestamp we care about
            if ( (currentTime - TITAN_DPS_RAVG_LENGTH) > v ) then
                -- We should subtract the damage from our ravg totals;
                titanDPS_ravgDamageTaken[titanDPS_ravgPlayersTakenTable[k]] = titanDPS_ravgDamageTaken[titanDPS_ravgPlayersTakenTable[k]] - titanDPS_ravgDamageTakenTable[k];

                -- We can't actually remove the entry yet.  table.remove will reindex and screw our loop.
                deleteIndex = k;
            else
                -- As soon as we find the first time that is within our running time...
                    oldestTime = max(oldestTime, v);
                break;
            end
        end

        -- Clean up our tables by removing all the old entries
        while (deleteIndex > 0) do
            table.remove(titanDPS_ravgTimestampsTakenTable, deleteIndex);
            table.remove(titanDPS_ravgPlayersTakenTable, deleteIndex);
            table.remove(titanDPS_ravgDamageTakenTable, deleteIndex);
            deleteIndex = deleteIndex - 1;
        end

        -- Pet calcs on the same oldest time as you do...
        titanDPS_ravgCombatTime = currentTime - oldestTime;
        
        titanDPS_sessionCombatTime = titanDPS_sessionCombatTime + elapse;
        
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_CombatTime", (TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_CombatTime") + elapse));
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_CombatTime_Level", (TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_CombatTime_Level") + elapse));
        if (TitanDPS_IsPetClass() and UnitExists("pet")) then
            TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_Pet_CombatTime_Level", (TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_CombatTime_Level") + elapse));
        end
    end
end

function TitanDPS_RegisterEvents()
    localState = {};
    -- Basically make sure that our settings are loaded
    this:RegisterEvent("VARIABLES_LOADED");

    -- Standard Combat
    this:RegisterEvent("CHAT_MSG_COMBAT_SELF_HITS");
    this:RegisterEvent("CHAT_MSG_COMBAT_SELF_MISSES");
    this:RegisterEvent("CHAT_MSG_COMBAT_PET_HITS");
    this:RegisterEvent("CHAT_MSG_COMBAT_PET_MISSES");
    this:RegisterEvent("CHAT_MSG_SPELL_SELF_DAMAGE");
    this:RegisterEvent("CHAT_MSG_SPELL_PET_DAMAGE");

    -- Damage Taken
    this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE");
    this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE");
    this:RegisterEvent("CHAT_MSG_COMBAT_HOSTILEPLAYER_HITS");
    this:RegisterEvent("CHAT_MSG_COMBAT_HOSTILEPLAYER_MISSES");
    this:RegisterEvent("CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS");
    this:RegisterEvent("CHAT_MSG_COMBAT_CREATURE_VS_SELF_MISSES");

    this:RegisterEvent("CHAT_MSG_SPELL_HOSTILEPLAYER_DAMAGE");
    this:RegisterEvent("CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE");
    this:RegisterEvent("CHAT_MSG_SPELL_CREATURE_VS_SELF_BUFF");
    this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_BUFFS");
    this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE");

    this:RegisterEvent("CHAT_MSG_SYSTEM");
    this:RegisterEvent("PLAYER_REGEN_ENABLED");
    this:RegisterEvent("PLAYER_REGEN_DISABLED");
    this:RegisterEvent("PLAYER_LEAVE_COMBAT");
    this:RegisterEvent("PLAYER_LEVEL_UP");
    this:RegisterEvent("CHAT_MSG_COMBAT_XP_GAIN");  
    this:RegisterEvent("CHAT_MSG_COMBAT_LOG_ENEMY");
    this:RegisterEvent("CHAT_MSG_COMBAT_HOSTILE_DEATH");

    -- Heals
    this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_BUFFS");
    this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_PARTY_BUFFS");
    this:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS");

    this:RegisterEvent("CHAT_MSG_SPELL_SELF_BUFF");
    this:RegisterEvent("CHAT_MSG_SPELL_PARTY_BUFF");
    this:RegisterEvent("CHAT_MSG_SPELL_FRIENDLYPLAYER_BUFF");
end

function TitanDPSButton_OnEvent()
--  debug("On Event: "..event);
    -- This loads the variables...I wish this was part of TitanUtils...
    TitanUtils_LoadSettings(event);

    if (event == "PLAYER_REGEN_ENABLED") then
        titanDPS_regenEnabled = GetTime();
        titanDPS_InCombat = false;
    end
    
    if (event == "PLAYER_REGEN_DISABLED") then  
       titanDPS_InCombat = true;
    end

    local p, d;

    -- Your Damage
    if (event == "CHAT_MSG_COMBAT_SELF_HITS" 
        or event == "CHAT_MSG_COMBAT_SELF_MISSES"
        or event == "CHAT_MSG_SPELL_SELF_DAMAGE"
        or event == "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE"
        or event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE"
        ) then          

        for creatureName, damage,damageType, spell in string.gmatch(arg1, TITANDPS_001) do
            TitanDPS_AddDPSEntry("Your", damage);           
            return;
        end

        -- Damage You Do
        for spell, creatureName, damage in string.gmatch(arg1, TITANDPS_002) do
            TitanDPS_AddDPSEntry("Your", damage);           
            return;
        end
        for creatureName, damage in string.gmatch(arg1, TITANDPS_003) do
            TitanDPS_AddDPSEntry("Your", damage);           
            return;
        end
        for spell, creatureName, damage in string.gmatch(arg1, TITANDPS_004) do
            TitanDPS_AddDPSEntry("Your", damage);           
            return;
        end
        for creatureName, damage in string.gmatch(arg1, TITANDPS_005) do
            TitanDPS_AddDPSEntry("Your", damage);           
            return;
        end

        -- Misses (Don't Do Anything Just Yet)
        for creatureName in string.gmatch(arg1, TITANDPS_006) do
            return;
        end
        for creatureName in string.gmatch(arg1, TITANDPS_007) do
            return;
        end
        for creatureName in string.gmatch(arg1, TITANDPS_008) do
            return;
        end
        for creatureName in string.gmatch(arg1, TITANDPS_009) do
            return;
        end
        for creatureName in string.gmatch(arg1, TITANDPS_010) do
            return;
        end
        for creatureName in string.gmatch(arg1, TITANDPS_011) do
            return;
        end
        for spell, creatureName in string.gmatch(arg1, TITANDPS_012) do
            return;
        end
        for spell, creatureName in string.gmatch(arg1, TITANDPS_013) do
            return;
        end
        for spell, creatureName in string.gmatch(arg1, TITANDPS_014) do
            return;
        end
        for spell, creatureName in string.gmatch(arg1, TITANDPS_015) do
            return;
        end
        for spell, creatureName in string.gmatch(arg1, TITANDPS_016) do
            return;
        end
        for spell, creatureName in string.gmatch(arg1, TITANDPS_017) do
            return;
        end
        for spell, creatureName in string.gmatch(arg1, TITANDPS_018) do
            return;
        end
        for spell, creatureName in string.gmatch(arg1, TITANDPS_019) do
            return;
        end
    end

    -- Pet Damage (Your damage)
    if (event == "CHAT_MSG_COMBAT_PET_HITS" ) then
        
        titanDPS_InCombat = true;
        
        for petName, creatureName, damage in string.gmatch(arg1, TITANDPS_020) do
            TitanDPS_AddDPSEntry("Pet", damage);            
            return;
        end
        
        for petName, creatureName, damage in string.gmatch(arg1, TITANDPS_021) do
            TitanDPS_AddDPSEntry("Pet", damage);            
            return;
        end
    end

    if (event == "CHAT_MSG_SPELL_PET_DAMAGE") then

        for petName, spell, creatureName, damage in string.gmatch(arg1, TITANDPS_022) do         
            if (petName == UnitName('pet') or petName == 'your pet') then
                TitanDPS_AddDPSEntry("Pet", damage);
            end
            return;
        end
        
        for petName, spell, creatureName, damage in string.gmatch(arg1, TITANDPS_023) do
            if (petName == UnitName('pet') or petName == 'your pet') then
                TitanDPS_AddDPSEntry("Pet", damage);
            end
            return;
        end
        
        -- Pet Misses
        for petName, spell, creatureName in string.gmatch(arg1, TITANDPS_024) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end
            return;
        end
        for petName, spell, creatureName in string.gmatch(arg1, TITANDPS_025) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end         
            return;
        end
        for petName, spell, creatureName in string.gmatch(arg1, TITANDPS_026) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end         
            return;
        end
        for petName, spell, creatureName in string.gmatch(arg1, TITANDPS_027) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end                     
            return;
        end
        for petName, spell, creatureName in string.gmatch(arg1, TITANDPS_028) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end                     
            return;
        end
        for petName, spell, creatureName in string.gmatch(arg1, TITANDPS_029) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end                     
            return;
        end
        for petName, spell, creatureName in string.gmatch(arg1, TITANDPS_030) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end                     
            return;
        end
        for petName, spell, creatureName in string.gmatch(arg1, TITANDPS_031) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end
            return;
        end
        for petName, spell, creatureName in string.gmatch(arg1, TITANDPS_032) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end
            return;
        end
        for petName, spell, creatureName in string.gmatch(arg1, TITANDPS_033) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end
            return;
        end 
    end


    -- Pet Misses (registed with another event)
    if (event == "CHAT_MSG_COMBAT_PET_MISSES") then

        titanDPS_InCombat = true;

        for petName, creatureName in string.gmatch(arg1, TITANDPS_034) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end 
            return;
        end
        
        for petName, creatureName in string.gmatch(arg1, TITANDPS_035) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end
            return;
        end
        for petName, creatureName in string.gmatch(arg1, TITANDPS_036) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end
            return;
        end
        for petName, creatureName in string.gmatch(arg1, TITANDPS_037) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end
            return;
        end
        for petName, creatureName in string.gmatch(arg1, TITANDPS_038) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end
            return;
        end
        for petName, creatureName in string.gmatch(arg1, TITANDPS_039) do
            if (petName == UnitName('pet') or petName == 'your pet') then
            end
            return;
        end
    end

    -- Pet Damage Taken
    if(event == "CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS") then

        titanDPS_InCombat = true;

        for creatureName, petName, damage, tmpStr in string.gmatch(arg1, TITANDPS_064) do
            if (petName == UnitName('pet') or petName == 'your pet') then
                TitanDPS_AddDefDPSEntry("Pet",damage);
                return;
            end
        end
        for creatureName, petName, damage in string.gmatch(arg1, TITANDPS_065) do
            if (petName == UnitName('pet') or petName == 'your pet') then
                TitanDPS_AddDefDPSEntry("Pet",damage);
                return;
            end
        end
        for creatureName, petName, damage in string.gmatch(arg1, TITANDPS_066) do
            if (petName == UnitName('pet') or petName == 'your pet') then
                TitanDPS_AddDefDPSEntry("Pet",damage);
                return;
            end
        end
    end

    if (event == "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE") then
        for creatureName, spell, petName, damage in string.gmatch(arg1, TITANDPS_022) do
            if (petName == UnitName('pet') or petName == 'your pet') then
                TitanDPS_AddDefDPSEntry("Pet",damage);
                return;
            end
        end
        for creatureName, spell, petName, damage in string.gmatch(arg1, TITANDPS_023) do
            if (petName == UnitName('pet') or petName == 'your pet') then
                TitanDPS_AddDefDPSEntry("Pet",damage);
                return;
            end
        end
    end

    -- Self Damage Taken
    if(event == "CHAT_MSG_COMBAT_CREATURE_VS_SELF_HITS") then

        titanDPS_InCombat = true;

        for creatureName, damage,tmpStr in string.gmatch(arg1, TITANDPS_040) do
            TitanDPS_AddDefDPSEntry("Your",damage);
            return;
        end
        for creatureName, damage in string.gmatch(arg1, TITANDPS_041) do
            TitanDPS_AddDefDPSEntry("Your",damage);
            return;
        end
        for creatureName, damage in string.gmatch(arg1, TITANDPS_042) do
            TitanDPS_AddDefDPSEntry("Your",damage);
            return;
        end
    end

    if (event == "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE") then

        for creatureName, spell, damage in string.gmatch(arg1, TITANDPS_043) do
            TitanDPS_AddDefDPSEntry("Your",damage);
            return;
        end
        for creatureName, spell, damage in string.gmatch(arg1, TITANDPS_044) do
            TitanDPS_AddDefDPSEntry("Your",damage);
            return;
        end
        for creatureName, spell in string.gmatch(arg1, TITANDPS_045) do
            return;
        end
        for creatureName, spell in string.gmatch(arg1, TITANDPS_046) do
            return;
        end
        for creatureName, spell in string.gmatch(arg1, TITANDPS_047) do
            return;
        end
        for creatureName, spell in string.gmatch(arg1, TITANDPS_048) do
            return;
        end
        for creatureName, spell in string.gmatch(arg1, TITANDPS_049) do
            return;
        end
        for creatureName, spell in string.gmatch(arg1, TITANDPS_050) do
            return;
        end
        for creatureName, spell in string.gmatch(arg1, TITANDPS_051) do
            return;
        end
        for creatureName, spell in string.gmatch(arg1, TITANDPS_052) do
            return;
        end
    end

    -- They miss
    if (event == "CHAT_MSG_COMBAT_CREATURE_VS_SELF_MISSES") then

        for creatureName in string.gmatch(arg1, TITANDPS_053) do
            return;
        end
        for creatureName in string.gmatch(arg1, TITANDPS_054) do
            return;
        end
        for creatureName in string.gmatch(arg1, TITANDPS_055) do
            return;
        end
        for creatureName in string.gmatch(arg1, TITANDPS_056) do
            return;
        end
        for creatureName in string.gmatch(arg1, TITANDPS_057) do
            return;
        end
        for creatureName in string.gmatch(arg1, TITANDPS_058) do
            return;
        end
    end

    -- Heals
    if (event == "CHAT_MSG_SPELL_SELF_BUFF" or event == "CHAT_MSG_SPELL_PARTY_BUFF" or event == "CHAT_MSG_SPELL_FRIENDLYPLAYER_BUFF") then
        local useless, useless, spell, amount = string.find(arg1, TITANDPS_059);
        if ( spell and amount ) then
        elseif ( string.find(arg1, TITANDPS_060) ) then
            local useless, useless, spell, amount = string.find(arg1, TITANDPS_061);
            if ( spell and amount ) then
            end
        end
    end

    if (event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_BUFFS" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_BUFFS") then
        local useless, useless, amount, spell = string.find(arg1, TITANDPS_062);
        if ( spell and amount ) then
        end
    end
    if (event == "CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS") then
        local useless, useless, amount, spell = string.find(arg1, TITANDPS_063);
        if ( not string.find(arg1, "'s") and spell and amount ) then
        end
    end
    
    -- Pet Level Up
    if (UnitExists("pet")) then
        if (TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_Level") == nil) then
            titanDPS_petLevel = 0;
        else
            titanDPS_petLevel = TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_Level");
        end
        if (UnitLevel("pet") > titanDPS_petLevel) then
            TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_Pet_Damage_Level", 0);
            TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_Pet_DamageTaken_Level", 0);
            TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_Pet_CombatTime_Level", 0.05);
            TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_Pet_Level", UnitLevel("pet"));
        end
    end
    
    -- Player Level Up
    if (event == "PLAYER_LEVEL_UP") then
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_Damage_Level", 0);
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_DamageTaken_Level", 0);
        TitanUtils_SetPlayerSettings(TITAN_DPS, "Stats_CombatTime_Level", 0.05);
    end
end
                                   
function TitanDPSButton_ShowCombined()
    local showCombined = TitanUtils_GetPlayerSettings(TITAN_DPS, "ShowCombined");
    if (showCombined == 1) then
        showCombined = 0;
    else
        showCombined = 1;
    end
    TitanUtils_SetPlayerSettings(TITAN_DPS, "ShowCombined", showCombined);
end

function TitanDPSButton_ShowDPS_RAVG()
    TitanDPSButton_ShowDPSType(TITAN_RAVG);
end

function TitanDPSButton_ShowDPS_Session()
    TitanDPSButton_ShowDPSType(TITAN_RSESSION);
end

function TitanDPSButton_ShowDPS_Level()
    TitanDPSButton_ShowDPSType(TITAN_RLEVEL);
end

function TitanDPSButton_ShowDPS_Overall()
    TitanDPSButton_ShowDPSType(TITAN_RGLOBAL);
end

function TitanDPSButton_ShowDPSType(dpsShowType)
    TitanUtils_SetPlayerSettings(TITAN_DPS, "ShowDPS", dpsShowType);
end
