TITAN_DPS = "DPS";
TITAN_DPS_VERSION = "0.76.11000";
TITAN_DPS_FREQUENCY = 0.25;
TITAN_DPS_RAVG_LENGTH = 15;
TITAN_RAVG = "rAvg";
TITAN_RSESSION = "Session";
TITAN_RGLOBAL = "Global";
TITAN_RLEVEL = "Level";

function TitanDPSButton_OnLoad()
    TitanDPS_Localize();
    
    this.registry = { 
        id = TITAN_DPS,
        menuText = TITAN_DPS_MENU_TEXT, 
        buttonTextFunction = "TitanDPSButton_GetButtonText", 
        tooltipTitle = TITAN_DPS_TOOLTIP,
        tooltipTextFunction = "TitanDPSButton_GetTooltipText", 
        frequency = TITAN_DPS_FREQUENCY, 
        variableInit = "TitanDPS_InitVariables",
        category = "Combat",
        version = TITAN_DPS_VERSION,
        savedVariables = {
            Version = TITAN_DPS_VERSION,
            Stats_Damage = 0,
            Stats_DamageTaken = 0,
            Stats_Damage_Level = 0,
            Stats_DamageTaken_Level = 0,
            Stats_CombatTime = 0.05,
            Stats_CombatTime_Level = 0.05,
            Stats_Pet_Level = 0;
            Stats_Pet_Damage = 0,
            Stats_Pet_DamageTaken = 0,
            Stats_Pet_Damage_Level = 0,
            Stats_Pet_DamageTaken_Level = 0,
            Stats_Pet_CombatTime_Level = 0.05,
            ShowDPS = TITAN_RAVG,
            ShowCombined = 1;
        }
    };
    
    TitanDPS_RegisterEvents();
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("PLAYER_ENTERING_WORLD");
    this:RegisterEvent("UNIT_NAME_UPDATE");                 
end

function TitanDPSButton_UpdateDPSValues()        
    if (not titanDPS_lastUpdate) then
        titanDPS_lastUpdate = 0;
    end
        
    TitanDPS_UpdateCurrentData(GetTime() - titanDPS_lastUpdate);
    titanDPS_lastUpdate = GetTime();
    
    if (not titanDPS_runtimeStats or not titanDPS_ravgDamage or not titanDPS_ravgDamageTaken) then
        titanDPS_runtimeStats = {};
        titanDPS_sessionDamage = {
            Your = 0;
            Pet = 0;
        };
        titanDPS_ravgDamage = {
            Your = 0;
            Pet = 0;
        };
        titanDPS_ravgDamageTaken = {
            Your = 0;
            Pet = 0;
        };
        titanDPS_ravgCombatTime = 0.05;
    end
    
    -- these calculations are minimal, and won't affect CPU load.
    titanDPS_runtimeStats["ravgDPS"] = titanDPS_ravgDamage["Your"] / titanDPS_ravgCombatTime;
    titanDPS_runtimeStats["ravgDPSTaken"] = titanDPS_ravgDamageTaken["Your"] / titanDPS_ravgCombatTime;

    titanDPS_runtimeStats["sessionDPS"] = titanDPS_sessionDamage["Your"] / titanDPS_sessionCombatTime;
    titanDPS_runtimeStats["sessionDPSTaken"] = titanDPS_sessionDamageTaken["Your"] / titanDPS_sessionCombatTime;

--  debug("runTime[globalDPS]: "..tostring(titanDPS_runtimeStats["globalDPS"]));
--  debug("stored[Stats_Damage]: "..tostring(TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Damage")));
--  debug("stored[ComabatTime]: "..tostring(TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_CombatTime")));

    titanDPS_runtimeStats["levelDPS"] = TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Damage_Level") / TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_CombatTime_Level");
    titanDPS_runtimeStats["levelDPSTaken"] = TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_DamageTaken_Level") / TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_CombatTime_Level");

    titanDPS_runtimeStats["globalDPS"] = TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Damage") / TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_CombatTime");
    titanDPS_runtimeStats["globalDPSTaken"] = TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_DamageTaken") / TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_CombatTime");
    
    if (TitanDPS_IsPetClass() and UnitExists("pet")) then
        titanDPS_runtimeStats["ravgPetDPS"] = titanDPS_ravgDamage["Pet"] / titanDPS_ravgCombatTime;
        titanDPS_runtimeStats["ravgPetDPSTaken"] = titanDPS_ravgDamageTaken["Pet"] / titanDPS_ravgCombatTime;
        titanDPS_runtimeStats["sessionPetDPS"] = titanDPS_sessionDamage["Pet"] / titanDPS_sessionCombatTime;
        titanDPS_runtimeStats["sessionPetDPSTaken"] = titanDPS_sessionDamageTaken["Pet"] / titanDPS_sessionCombatTime;
        titanDPS_runtimeStats["levelPetDPS"] = TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_Damage_Level") / TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_CombatTime_Level");
        titanDPS_runtimeStats["levelPetDPSTaken"] = TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_DamageTaken_Level") / TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_CombatTime_Level");
        titanDPS_runtimeStats["globalPetDPS"] = TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_Damage") / TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_CombatTime");
        titanDPS_runtimeStats["globalPetDPSTaken"] = TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_Pet_DamageTaken") / TitanUtils_GetPlayerSettings(TITAN_DPS, "Stats_CombatTime");
    end
    
end

function TitanDPSButton_GetButtonText()
    -- Calculate some stuff here..We don't need to do this for Tooltip since this gets called all the time...
    TitanDPSButton_UpdateDPSValues();
    
    local showDPSType = TitanUtils_GetPlayerSettings(TITAN_DPS, "ShowDPS");
    local showCombined = TitanUtils_GetPlayerSettings(TITAN_DPS, "ShowCombined");
    if (not showDPSType or showDPSType == TITAN_RAVG or showDPSType == 0) then
        if (TitanDPS_IsPetClass() and UnitExists("pet")) then
            if (showCombined == 1) then
                return format(TITAN_DPS_BAR_FORMAT, titanDPS_runtimeStats["ravgDPSTaken"] + titanDPS_runtimeStats["ravgPetDPSTaken"], titanDPS_runtimeStats["ravgDPS"] + titanDPS_runtimeStats["ravgPetDPS"]);
            else
                return format(TITAN_DPS_PETBAR_FORMAT, titanDPS_runtimeStats["ravgDPSTaken"], titanDPS_runtimeStats["ravgDPS"], titanDPS_runtimeStats["ravgPetDPSTaken"], titanDPS_runtimeStats["ravgPetDPS"]);
            end
        else
            return format(TITAN_DPS_BAR_FORMAT, titanDPS_runtimeStats["ravgDPSTaken"], titanDPS_runtimeStats["ravgDPS"]);
        end
    end
    if (showDPSType == TITAN_RSESSION) then
        if (TitanDPS_IsPetClass() and UnitExists("pet")) then
            if (showCombined == 1) then
                return format(TITAN_DPS_BAR_FORMAT, titanDPS_runtimeStats["sessionDPSTaken"] + titanDPS_runtimeStats["sessionPetDPSTaken"], titanDPS_runtimeStats["sessionDPS"] + titanDPS_runtimeStats["sessionPetDPS"]);
            else
                return format(TITAN_DPS_PETBAR_FORMAT, titanDPS_runtimeStats["sessionDPSTaken"], titanDPS_runtimeStats["sessionDPS"], titanDPS_runtimeStats["sessionPetDPSTaken"], titanDPS_runtimeStats["sessionPetDPS"]);
            end
        else
            return format(TITAN_DPS_BAR_FORMAT, titanDPS_runtimeStats["sessionDPSTaken"], titanDPS_runtimeStats["sessionDPS"]);
        end
    end
    if (showDPSType == TITAN_RLEVEL) then
        if (TitanDPS_IsPetClass() and UnitExists("pet")) then
            if (showCombined == 1) then
                return format(TITAN_DPS_BAR_FORMAT, titanDPS_runtimeStats["levelDPSTaken"] + titanDPS_runtimeStats["levelPetDPSTaken"], titanDPS_runtimeStats["levelDPS"] + titanDPS_runtimeStats["levelPetDPS"]);
            else
                return format(TITAN_DPS_PETBAR_FORMAT, titanDPS_runtimeStats["levelDPSTaken"], titanDPS_runtimeStats["levelDPS"], titanDPS_runtimeStats["levelPetDPSTaken"], titanDPS_runtimeStats["levelPetDPS"]);
            end
        else
            return format(TITAN_DPS_BAR_FORMAT, titanDPS_runtimeStats["levelDPSTaken"], titanDPS_runtimeStats["levelDPS"]);
        end
    end
    if (showDPSType == TITAN_RGLOBAL) then
        if (TitanDPS_IsPetClass() and UnitExists("pet")) then
            if (showCombined == 1) then
                return format(TITAN_DPS_BAR_FORMAT, titanDPS_runtimeStats["globalDPSTaken"] + titanDPS_runtimeStats["globalPetDPSTaken"], titanDPS_runtimeStats["globalDPS"] + titanDPS_runtimeStats["globalPetDPS"]);
            else
                return format(TITAN_DPS_PETBAR_FORMAT, titanDPS_runtimeStats["globalDPSTaken"], titanDPS_runtimeStats["globalDPS"], titanDPS_runtimeStats["globalPetDPSTaken"], titanDPS_runtimeStats["globalPetDPS"]);
            end
        else
            return format(TITAN_DPS_BAR_FORMAT, titanDPS_runtimeStats["globalDPSTaken"], titanDPS_runtimeStats["globalDPS"]);
        end
    end
end

function TitanDPSButton_GetTooltipText()
    local tooltipText = "";
    TitanDPSButton_UpdateDPSValues();

    tooltipText = tooltipText.."\n"..format(TITAN_DPS_NAME_FORMAT, TitanPlayerName).."\n";
    tooltipText = tooltipText..format(TITAN_DPS_RAVG_FORMAT, titanDPS_runtimeStats["ravgDPSTaken"], titanDPS_runtimeStats["ravgDPS"]).."\n";
    tooltipText = tooltipText..format(TITAN_DPS_SESSION_FORMAT, titanDPS_runtimeStats["sessionDPSTaken"], titanDPS_runtimeStats["sessionDPS"]).."\n";
    tooltipText = tooltipText..format(TITAN_DPS_LEVEL_FORMAT, titanDPS_runtimeStats["levelDPSTaken"], titanDPS_runtimeStats["levelDPS"]).."\n";
    tooltipText = tooltipText..format(TITAN_DPS_OVERALL_FORMAT, titanDPS_runtimeStats["globalDPSTaken"], titanDPS_runtimeStats["globalDPS"]).."\n";
    if (TitanDPS_IsPetClass() and UnitExists("pet")) then
        tooltipText = tooltipText.."\n"..format(TITAN_DPS_NAME_FORMAT, UnitName('pet')).."\n";
        tooltipText = tooltipText..format(TITAN_DPS_RAVG_FORMAT, titanDPS_runtimeStats["ravgPetDPSTaken"], titanDPS_runtimeStats["ravgPetDPS"]).."\n";
        tooltipText = tooltipText..format(TITAN_DPS_SESSION_FORMAT, titanDPS_runtimeStats["sessionPetDPSTaken"], titanDPS_runtimeStats["sessionPetDPS"]).."\n";
        tooltipText = tooltipText..format(TITAN_DPS_LEVEL_FORMAT, titanDPS_runtimeStats["levelPetDPSTaken"], titanDPS_runtimeStats["levelPetDPS"]).."\n";
        tooltipText = tooltipText..format(TITAN_DPS_OVERALL_FORMAT, titanDPS_runtimeStats["globalPetDPSTaken"], titanDPS_runtimeStats["globalPetDPS"]).."\n";
    end

    tooltipText = tooltipText.."\nVersion: "..TITAN_DPS_VERSION;
    return tooltipText;
end

function TitanPanelRightClickMenu_PrepareDPSMenu()
    local id = TITAN_DPS;
    TitanPanelRightClickMenu_AddTitle(TITAN_DPS_MENU_TEXT.." "..TITAN_DPS_VERSION);
--  TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_CUSTOMIZE..TITAN_PANEL_MENU_POPUP_IND, id, TITAN_PANEL_MENU_FUNC_CUSTOMIZE);
    TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, id, TITAN_PANEL_MENU_FUNC_HIDE);
    TitanPanelRightClickMenu_AddCommand(TITAN_DPS_MENU_RESET, id, "TitanDPS_Reset");
    TitanPanelRightClickMenu_AddSpacer();
    
    if (TitanDPS_IsPetClass()) then
        TitanPanelRightClickMenu_AddTitle("Show");
        local showCombined = TitanUtils_GetPlayerSettings(TITAN_DPS, "ShowCombined");
        info = {};
        info.text = TITAN_DPS_SHOW_COMBINED;
        info.func = TitanDPSButton_ShowCombined;
        info.checked = (showCombined == 1);
        UIDropDownMenu_AddButton(info);
    end
        
    local showDPSType = TitanUtils_GetPlayerSettings(TITAN_DPS, "ShowDPS");
    info = {};
    info.text = TITAN_DPS_SHOW_RAVG_DPS;
    info.func = TitanDPSButton_ShowDPS_RAVG;
    info.checked = (showDPSType == TITAN_RAVG);
    UIDropDownMenu_AddButton(info);

    info = {};
    info.text = TITAN_DPS_SHOW_SESSION_DPS;
    info.func = TitanDPSButton_ShowDPS_Session;
    info.checked = (showDPSType == TITAN_RSESSION);
    UIDropDownMenu_AddButton(info);

    info = {};
    info.text = TITAN_DPS_SHOW_LEVEL_DPS;
    info.func = TitanDPSButton_ShowDPS_Level;
    info.checked = (showDPSType == TITAN_RLEVEL);
    UIDropDownMenu_AddButton(info);

    info = {};
    info.text = TITAN_DPS_SHOW_OVERALL_DPS;
    info.func = TitanDPSButton_ShowDPS_Overall;
    info.checked = (showDPSType == TITAN_RGLOBAL);
    UIDropDownMenu_AddButton(info);
end
