--[[

	TimerBuff: Changes Blizzard timers buff

		Blizzard timer buff -> 3 m , 48 s
		My timer buff -> 3:05 , 48
		Full timer buff -> 03:05 , 00:48
	
	Made by: Edswor
	
	Commands: /timerbuff  or  /tb
	
]]


--------------------------------------------------------------------------------------------------
-- OnLoad, Initialize
--------------------------------------------------------------------------------------------------

function TimerBuff_OnLoad()

	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("ADDON_LOADED");

	SLASH_TIMERBUFF1 = "/timerbuff";
	SLASH_TIMERBUFF2 = "/tb";
	SlashCmdList["TIMERBUFF"] = TimerBuff_ShowOptions;

	Old_SecondsToTimeAbbrev = SecondsToTimeAbbrev;
	SecondsToTimeAbbrev = TimerBuff_SecondsToTimeAbbrev;

end

function TimerBuff_Initialize()
	TimerBuff_Save = {
		["Version"] = TIMERBUFF_VERSION,
		["Mode"] = 2,
	};
end

--------------------------------------------------------------------------------------------------
-- ShowOptions, HideOptions, Toggle();
--------------------------------------------------------------------------------------------------

function TimerBuff_ShowOptions()
	ShowUIPanel(TimerBuffOptionsFrame);
end

function TimerBuff_HideOptions()
	HideUIPanel(TimerBuffOptionsFrame);
end

function TimerBuff_Toggle()
	if(TimerBuffOptionsFrame:IsVisible()) then
		HideUIPanel(TimerBuffOptionsFrame);
	else
		ShowUIPanel(TimerBuffOptionsFrame);
	end
end

--------------------------------------------------------------------------------------------------
-- Set, Get
--------------------------------------------------------------------------------------------------

function TimerBuff_Get(option)
	if (TimerBuff_Save[option] ~= nil) then
		return TimerBuff_Save[option];
	end
end

function TimerBuff_Set(option, val)
	if (TimerBuff_Save ~= nil) then
		if ( option ) then
			TimerBuff_Save[option] = val;
		end
	end
end

--------------------------------------------------------------------------------------------------
-- OnEvent
--------------------------------------------------------------------------------------------------

function TimerBuff_OnEvent()
	if( event == "VARIABLES_LOADED" ) then
		if ( TimerBuff_Save == nil ) then
			TimerBuff_Initialize();
		elseif( TimerBuff_Save["Version"] == nil or TimerBuff_Save["Version"] ~= TIMERBUFF_VERSION) then
			TimerBuff_Initialize();
		end
		if( DEFAULT_CHAT_FRAME ) then
			DEFAULT_CHAT_FRAME:AddMessage("|cff00ff00TimerBuff|r, made by: |cffff3300Edswor|r, Version: |cffffff00"..TIMERBUFF_VERSION.."|r, loaded.");
		end
		
		return;
	elseif( event == "ADDON_LOADED") then
		if(myAddOnsFrame_Register) then
			TimerBuffDetails = {
				name = "TimerBuff",
				version = TIMERBUFF_VERSION,
				releaseDate = TIMERBUFF_RELEASE,
				author = "Edswor",
				email = "edsowr@hotmail.com",
				website = "http://edswor.iespana.es",
				category = MYADDONS_CATEGORY_OTHERS,
				optionsframe = "TimerBuffOptionsFrame"
			};
			myAddOnsFrame_Register(TimerBuffDetails, TimerBuffHelp);
		end
		return;
	end
end

--------------------------------------------------------------------------------------------------
-- SecondsToTimeAbbrev
--------------------------------------------------------------------------------------------------

function TimerBuff_SecondsToTimeAbbrev(time)

	local m, s;
	local text;

	--Blizzard timer buff
	if ( TimerBuff_Get("Mode")==1 ) then
		
		text = Old_SecondsToTimeAbbrev(time);

	--My timer buff
	elseif ( TimerBuff_Get("Mode")==2 ) then
		if( time <= 0 ) then
			text = "";
		elseif( time < 3600 ) then
			m = floor(time / 60);
			s = mod(time, 60);
			if (m==0) then 
				text = format("%d", s);
			else
				text = format("%d:%02d", m, s);
			end
		else
			m = floor(time / 3600);
			s = floor(mod(time, 3600) / 60);
			text = format("%d:%02d h", m, s);
		end

	--Full timer buff
	elseif ( TimerBuff_Get("Mode")==3 ) then
		if( time <= 0 ) then
			text = "";
		elseif( time < 3600 ) then
			m = floor(time / 60);
			s = mod(time, 60);
			text = format("%02d:%02d", m, s);
		else
			m = floor(time / 3600);
			s = floor(mod(time, 3600) / 60);
			text = format("%02d:%02d h", m, s);
		end
	end

	return text;
		
end