-- MetaMap Export Module
-- Written by MetaHawk aka Urshurak

EXP_USERWKB = "UserWKB";
EXP_USERNOTES = "UserNotes";
EXP_USERQST = "UserQST";

local WKBcount = 0;
local Notecount = 0;
local QSTcount = 0;

function EXP_CheckData()
	MetaMap_OptionsInfo:SetText("MetaMap Exports module loaded");
	EXP_ConfirmationHeader:SetText(METAMAP_CONFIRM_EXPORT);
	EXP_SelectionButton1:SetText(EXP_USERWKB);
	EXP_SelectionButton2:SetText(EXP_USERNOTES);
	EXP_SelectionButton3:SetText(EXP_USERQST);
	if(not IsAddOnLoaded("MetaMapWKB")) then
		LoadAddOn("MetaMapWKB");
	end
	if(not IsAddOnLoaded("MetaMapWKB")) then
		EXP_SelectionButton1:Disable();
	end
	if(not IsAddOnLoaded("MetaMapQST")) then
		LoadAddOn("MetaMapQST");
	end
	if(not IsAddOnLoaded("MetaMapQST")) then
		EXP_SelectionButton3:Disable();
	end
	if(BKP_BackUpFrame) then BKP_BackUpFrame:Hide(); end
	if(CVT_ImportFrame) then CVT_ImportFrame:Hide(); end
	EXP_ExportFrame:Show();
end

function EXP_SelectedExport(mode)
	local msg = ""; WKBcount = 0; Notecount = 0;
	if(mode == EXP_USERWKB) then
		exp_MetaMap_Notes = nil;
		exp_MetaMap_Lines = nil;
		exp_QST_QuestBase = nil;
		EXP_ExportWKB();
		msg = format(METAMAPEXP_KB_EXPORTED, WKBcount);		
	elseif(mode == EXP_USERNOTES) then
		exp_WKB_Data = nil;
		exp_QST_QuestBase = nil;
		EXP_ExportMLN();
		msg = format(METAMAPEXP_NOTES_EXPORTED, Notecount);		
	elseif(mode == EXP_USERQST) then
		exp_MetaMap_Notes = nil;
		exp_MetaMap_Lines = nil;
		exp_WKB_Data = nil;
		EXP_ExportQST();
		msg = format(METAMAPEXP_QST_EXPORTED, QSTcount);		
	end
	EXP_ExportFrame:Hide();
	MetaMap_LoadExportsButton:Disable();
	MetaMap_OptionsInfo:SetText(msg);
end

function EXP_ExportWKB()
	exp_WKB_Data = {};
	for zone, unitTable in pairs(WKB_Data) do
		exp_WKB_Data[zone] = {};
		for unit, value in pairs(unitTable) do
			exp_WKB_Data[zone][unit] = value;
			WKBcount = WKBcount +1;
		end
	end
end

function EXP_ExportMLN()
	exp_MetaMap_Notes = {};
	exp_MetaMap_Lines = {};
	for zone, indexTable in pairs(MetaMap_Notes) do
		exp_MetaMap_Notes[zone] = {};
		for index, value in pairs(indexTable) do
			exp_MetaMap_Notes[zone][index] = value;
			Notecount = Notecount +1;
		end
	end
	exp_MetaMap_Lines = MetaMap_Lines;
end

function EXP_ExportQST()
	exp_QST_QuestBase = {};
	for index, quest in pairs(QST_QuestBase) do
		exp_QST_QuestBase[index] = quest;
		QSTcount = QSTcount +1;
	end
end

