function AutoDingConfig_OnLoad()
	UIPanelWindows["AutoDingConfigFrame"] = {area = "center", pushable = 0};
end

function AutoDingConfig_SetValues()
	cbxADEnable:SetChecked(AutoDingSaved[AD_Player].AutoDing == 1);
	cbxADPartyDing:SetChecked(AutoDingSaved[AD_Player].PartyDing == 1);
	cbxADScreenshot:SetChecked(AutoDingSaved[AD_Player].Screen == 1);
	AutoDing_EditBox:SetText(AutoDingSaved[AD_Player].DingString);
	AutoDing_EditBox3:SetText(AutoDingSaved[AD_Player].Interval);
	AutoDing_EditBox4:SetText(AutoDingSaved[AD_Player].Channel);
	txtADWhisperHeader:SetText(AUTODING_WHISPER_TITLE);
	txtADWhisperTips:SetText(AUTODING_WHISPER_HELP);
	txtADEditHeader:SetText(AUTODING_EDIT_TITLE);
	txtADEditTips:SetText(AUTODING_EDIT_HELP);
	txtADChannelHeader:SetText(AUTODING_CHANNEL_TITLE);
	txtADIntervalHeader:SetText(AUTODING_INTERVAL_TITLE);
	if (AutoDingSaved[AD_Player].Whisper and AutoDingSaved[AD_Player].Whisper ~= "off") then
		AutoDing_EditBox2:SetText(AutoDingSaved[AD_Player].Whisper);
	end
end

function AutoDingConfig_OnShow()
	txtADConfigTitle:SetText(AUTODING_CONFIG_TITLE);
	txtADConfigTitle:SetTextColor(1.0, 1.0, 1.0);
	txtADConfigTitle:Show();
	AD_ChatPrint(txtADConfigTitle:GetText().." opened");
	AutoDingConfig_SetValues();
end

function AutoDingConfig_OnHide()
	AD_ChatPrint(txtADConfigTitle:GetText().." closed");
end

function AutoDingConfig_OnMouseDown(arg1)
	if (arg1 == "LeftButton") then
		AutoDingConfigFrame:StartMoving();
	end
end

function AutoDingConfig_OnMouseUp(arg1)
	if (arg1 == "LeftButton") then
		AutoDingConfigFrame:StopMovingOrSizing();
	end
end

function AutoDingConfig_btnUTDone_OnClick()
	HideUIPanel(AutoDingConfigFrame);
end

function AutoDing_UpdateString()
	AutoDingSaved[AD_Player].DingString = this:GetText();
end

function AutoDing_UpdateWhisper()
	local Whispertxt = this:GetText();
	if not Whispertxt or Whispertxt == "" then
		AutoDingSaved[AD_Player].Whisper = "off"
	else
	AutoDingSaved[AD_Player].Whisper = Whispertxt;
	end
end

function AutoDing_UpdateInterval()
	local Int = this:GetText();
	local Int2 = AutoDingSaved[AD_Player].Interval; --Caching current setting
	if not Int or Int == "" then
		return;
	end
	Int = Int + 0; --Converts string to integer (if the test contains a number)
	if Int > ADMax then --Won't work if the number is too high
		AutoDing_EditBox3:SetText(Int2);
		AD_ChatPrint("Invalid entry, please try again")
	else
		AutoDingSaved[AD_Player].Interval = Int;
	end
end

function AutoDing_UpdateChannel()
	local Channeltxt = this:GetText();
	if not Channeltxt or Channeltxt == "" then
		AutoDingSaved[AD_Player].Channel = "SAY"
	else
	AutoDingSaved[AD_Player].Channel = strupper(Channeltxt);
	end
end

