function AutoDing_OnLoad()
	SlashCmdList["AUTODING"] = function(msg)
		AutoDing_Command(msg);
	end
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("PLAYER_LEVEL_UP");
end

function AutoDing_OnEvent(event)
	if (event == "VARIABLES_LOADED") then
		this:UnregisterEvent("VARIABLES_LOADED");
		-- Variable Setup Attempt
		AD_InitConfig();
		--If mod has been updated, reset vars to avoid errors
		if (AutoDingSaved[AD_Player].Version ~= AUTODINGVER) then
			--Don't want to reset the ding count, though
			local dcount = AutoDingSaved[AD_Player].DingCount;
			AD_ResetVars();
			AutoDingSaved[AD_Player].Version = AUTODINGVER;
			AutoDingSaved[AD_Player].DingCount = dcount;
		end
		if( DEFAULT_CHAT_FRAME ) then
			DEFAULT_CHAT_FRAME:AddMessage("AutoDing by Thorin has loaded. \'/ad\' for instructions.", 0.9, 1.0, 0.5);
		end
	end
	if (event == "PLAYER_LEVEL_UP") then
		if (AutoDingSaved[AD_Player].AutoDing == 1) then
			AD_FormatDing();
			AD_Count();
			AD_Interval();
			if (AutoDingSaved[AD_Player].Interval ~= 0) then
				if  DingNow == 1 then
					if AutoDingSaved[AD_Player].Channel == "GUILD" then
						-- Verify Player is in a Guild before attempting to Ding to Guild Channel
						if not IsInGuild() then
							-- If Player is not in a Guild and won't/can't Ding to Party Channel, Ding to Say Channel
							if (AutoDingSaved[AD_Player].PartyDing == 0) or not UnitExists("Party1") then
								ADChannel = "SAY";
							ADChatDelay1 = (GetTime() + 5);
							ADChatFrame:Show();
							end
						else
							ADChannel = AutoDingSaved[AD_Player].Channel;
							ADChatDelay1 = (GetTime() + 5);
							ADChatFrame:Show();
						end
					elseif AutoDingSaved[AD_Player].Channel == "RAID" then
						if UnitExists("Raid1") then
							ADChannel = AutoDingSaved[AD_Player].Channel;
							ADChatDelay1 = (GetTime() + 5);
							ADChatFrame:Show();
						else
							-- If Player is not in a Raid and won't/can't Ding to Party Channel, Ding to Say Channel
							if (AutoDingSaved[AD_Player].PartyDing == 0) or not UnitExists("Party1") then
							ADChannel = "SAY";
							ADChatDelay1 = (GetTime() + 5);
							ADChatFrame:Show();
							end
						end
					else 
						ADChannel = AutoDingSaved[AD_Player].Channel;
						ADChatDelay1 = (GetTime() + 5);
						ADChatFrame:Show();
					end
					if UnitExists("Party1") then
						if (AutoDingSaved[AD_Player].PartyDing == 1) then
							if AutoDingSaved[AD_Player].Channel ~= "PARTY" or AutoDingSaved[AD_Player].Channel ~= "RAID"then
								ADPartyDelay1 = (GetTime() + 5);
								ADPartyFrame:Show();
							end
						end
					end
					if (AutoDingSaved[AD_Player].Screen == 1) then
						RequestTimePlayed();
						if( DEFAULT_CHAT_FRAME ) then
							DEFAULT_CHAT_FRAME:AddMessage(ADmsg);
						end
						ADScrnDelay1 = (GetTime() + 0.5);
						ADScrnFrame:Show();
					end
					local WhisperName = AutoDingSaved[AD_Player].Whisper;
					if (WhisperName and WhisperName ~= "" and WhisperName ~= "off") then
						local WhisperLang = GetDefaultLanguage("player");
						SendChatMessage(ADmsg, "WHISPER", WhisperLang, WhisperName);
					end
				end
			else
				RequestTimePlayed();
				if( DEFAULT_CHAT_FRAME ) then
					DEFAULT_CHAT_FRAME:AddMessage(ADmsg);
				end
				ADScrnDelay1 = (GetTime() + 0.5);
				ADScrnFrame:Show();
			end
		end
	end
end

function AutoDing_Command(ADcommand)
	if (not ADcommand) then
		return;
	end
	local i,j, cmd, param = string.gmatch(ADcommand, "^([^ ]+) (.+)$");
	if (not cmd) then cmd = ADcommand; end
	if (not cmd) then cmd = ""; end
	if (not param) then param = ""; end
	if ( cmd and strlen(cmd) > 0 ) then
		cmd = strupper(cmd);
		param = strupper(param);
	end
	if (cmd == "STATUS") then
		if (param == "ON") then
			AutoDingSaved[AD_Player].AutoDing = 1;
			AD_ChatPrint("Ding will be sent to "..AutoDingSaved[AD_Player].Channel.." channel upon levelling up.");
		elseif (param == "OFF") then
			AutoDingSaved[AD_Player].AutoDing = 0;
			AD_ChatPrint("No Dings will be posted");
		else
			AD_ChatPrint("Type \'/ad status on/off\' to turn settings on or off.");
			if not (AutoDingSaved) then
				AD_ResetVars();
				AD_ChatPrint("Settings reset to default as settings not found.");
				return;
			else
				AD_Test();
			end
		end
	elseif (cmd == "TEST") then
		AD_Test();
	elseif (cmd == "CONFIG") then
		AutoDingConfigFrame:Show();
	elseif (cmd == "TOGGLE") then
		if (AutoDingSaved[AD_Player].AutoDing == 1) then
			AutoDingSaved[AD_Player].AutoDing = 0;
		else
			AutoDingSaved[AD_Player].AutoDing = 1;
		end
	elseif (cmd == "RESET") then
		AD_ResetVars();
		AD_ChatPrint("AutoDing settings reset to default values.");
	elseif (cmd == "SCREEN") then
		if (AutoDingSaved[AD_Player].Screen == 1) then
			AutoDingSaved[AD_Player].Screen = 0;
		else
			AutoDingSaved[AD_Player].Screen = 1;
		end
	elseif (cmd == "COUNT") then
		AD_Count();
		AD_Test();
	else
		AD_ChatPrint("AutoDing by Thorin of Eitrigg.");
		AD_ChatPrint("|cffffffffSlash Command Usage|r:");
		AD_ChatPrint("\'|cff66ccff/ad status|r\' - Displays current status/settings of the mod and how to switch it on/off.");
		AD_ChatPrint("\'|cff66ccff/ad config|r\' - Opens up Config Window where you can setup everything.");
		AD_ChatPrint("\'|cff66ccff/ad test|r\' - Displays the current status, what message will be posted, and to which channel.");
	end
end

function AD_InitConfig()
	if not AutoDingSaved or AutoDingSaved == nil then
		AutoDingSaved = {};
	end
	if not AutoDingSaved[AD_Player] or AutoDingSaved[AD_Player] == nil then	
		AutoDingSaved[AD_Player] = {};
	end
	if not AutoDingSaved[AD_Player].Channel or AutoDingSaved[AD_Player].Channel == nil then
		AutoDingSaved[AD_Player].Channel = "GUILD";
	end
	if not AutoDingSaved[AD_Player].AutoDing or AutoDingSaved[AD_Player].AutoDing == nil then
		AutoDingSaved[AD_Player].AutoDing = 1;
	end
	if not AutoDingSaved[AD_Player].Version or AutoDingSaved[AD_Player].Version == nil then
		AutoDingSaved[AD_Player].Version = AUTODINGVER;
	end
	if not AutoDingSaved[AD_Player].PartyDing or AutoDingSaved[AD_Player].PartyDing == nil then
		AutoDingSaved[AD_Player].PartyDing = 1;
	end
	if not AutoDingSaved[AD_Player].Screen or AutoDingSaved[AD_Player].Screen == nil then
		AutoDingSaved[AD_Player].Screen = 0;
	end
	if not AutoDingSaved[AD_Player].DingString or AutoDingSaved[AD_Player].DingString == nil then
		AutoDingSaved[AD_Player].DingString = "list";
	end
	if not AutoDingSaved[AD_Player].DingCount or AutoDingSaved[AD_Player].DingCount == nil then
		AutoDingSaved[AD_Player].DingCount = (random(1,15));
	end
	if not AutoDingSaved[AD_Player].Whisper or AutoDingSaved[AD_Player].Whisper == nil then
		AutoDingSaved[AD_Player].Whisper = "off";
	end
	if not AutoDingSaved[AD_Player].Interval or AutoDingSaved[AD_Player].Interval == nil then
		AutoDingSaved[AD_Player].Interval = 5;
	end
end

function AD_ResetVars()
	if not AutoDingSaved or AutoDingSaved == nil then
		AutoDingSaved = {};
	end
	if not AutoDingSaved[AD_Player] or AutoDingSaved[AD_Player] == nil then	
		AutoDingSaved[AD_Player] = {};	
		AutoDingSaved[AD_Player].Channel = "GUILD";
		AutoDingSaved[AD_Player].AutoDing = 1;
		AutoDingSaved[AD_Player].Version = AUTODINGVER;
		AutoDingSaved[AD_Player].PartyDing = 1;
		AutoDingSaved[AD_Player].Screen = 0;
		AutoDingSaved[AD_Player].DingString = "list";
		AutoDingSaved[AD_Player].DingCount = (random(1,15));
		AutoDingSaved[AD_Player].Whisper = "off";
		AutoDingSaved[AD_Player].Interval = 5;
	else
		AutoDingSaved[AD_Player].Channel = "GUILD";
		AutoDingSaved[AD_Player].AutoDing = 1;
		AutoDingSaved[AD_Player].Version = AUTODINGVER;
		AutoDingSaved[AD_Player].PartyDing = 1;
		AutoDingSaved[AD_Player].Screen = 0;
		AutoDingSaved[AD_Player].DingString = "list";
		AutoDingSaved[AD_Player].DingCount = (random(1,15));
		AutoDingSaved[AD_Player].Whisper = "off";
		AutoDingSaved[AD_Player].Interval = 5;
	end
end

function AD_ChatPrint(str)
	if ( DEFAULT_CHAT_FRAME ) then 
		DEFAULT_CHAT_FRAME:AddMessage(str, 1.0, 1.0, 0.0);
	end
end

function AD_ChannelMessage(message, channel)
	SendChatMessage(message, channel);
end

function AD_FormatDing()
	ADLevel = (UnitLevel("player") +1 );
	if strupper(AutoDingSaved[AD_Player].DingString) == "LIST" then
		AD_List();
	else
		DingString = AutoDingSaved[AD_Player].DingString;
	end
	ADmsg = DingString;
	ADmsg = string.gsub(ADmsg, "($L)", ADLevel);
	ADmsg = string.gsub(ADmsg, "($l)", (ADLevel - 1));
	ADmsg = string.gsub(ADmsg, "($D)", date("%m/%d/%y"));
	ADmsg = string.gsub(ADmsg, "($T)", date("%H:%M:%S"));
	ADmsg = string.gsub(ADmsg, "($R)", (ADMax - ADLevel));
	ADmsg = string.gsub(ADmsg, "($P)", AD_Player);
	return ADmsg;	
end

function AD_Test()
	local VerifyGuild2;
	local VerifyParty = UnitExists("Party1");
	AD_FormatDing();
	if not VerifyParty then VerifyParty = "NO" end;
	if IsInGuild() then VerifyGuild2 = GetGuildInfo("Player") else VerifyGuild2 = "NONE" end;
	AD_ChatPrint("Guild = "..VerifyGuild2.." PartyExists = "..VerifyParty);
	if AutoDingSaved[AD_Player].AutoDing == 1 then
		AD_ChatPrint("AutoDing is currently |cff66ccffon|r and will export the message \""..ADmsg.."\" to channel "..AutoDingSaved[AD_Player].Channel..".");
	elseif AutoDingSaved[AD_Player].AutoDing == 0 then
		AD_ChatPrint("AutoDing is currently |cff66ccffoff|r and won't export the message \""..ADmsg.."\" to channel "..AutoDingSaved[AD_Player].Channel..".");
	end
end

function AD_Count()
	local count = AutoDingSaved[AD_Player].DingCount;
	if 	 ADLevel == 40 then return;
	elseif ADLevel == 60 then return;
	elseif ADLevel == 65 then return;
	elseif ADLevel == 70 then return;
	else
		if (count + 1) < 16 then
			AutoDingSaved[AD_Player].DingCount = (count + 1);
		else
			AutoDingSaved[AD_Player].DingCount = 1;
		end
	end
end

function AD_Interval()
	DingNow = 0;
	ADInterval = AutoDingSaved[AD_Player].Interval
	if ADInterval == 0 then
		return;
	else
		local num = 0;
		while num <= ADMax do
			num = num + ADInterval;
			if 	num == ADLevel then
				DingNow = 1;
				num = 100;
			end
		end
	end
end

function ADChatOnUpdate()
	if not (ADChatFrame:IsVisible()) then return end
	ADChatDelay2 = GetTime();
	if (ADChatDelay1 - ADChatDelay2 > 0) then return end
	if ADChannel == "GUILD" or ADChannel == "SAY" or ADChannel == "YELL" or ADChannel == "GROUP" or ADChannel == "RAID" then
	SendChatMessage(ADmsg,ADChannel);
	else
	local id, name = GetChannelName(ADChannel);
	SendChatMessage(ADmsg,"CHANNEL", nil,id);
	end
	ADChatFrame:Hide();
end

function ADPartyOnUpdate()
	if not (ADPartyFrame:IsVisible()) then return end
	ADPartyDelay2 = GetTime();
	if (ADPartyDelay1 - ADPartyDelay2 > 0) then return end
	SendChatMessage(ADmsg, "PARTY");
	ADPartyFrame:Hide();
end

function ADScrnOnUpdate()
	if not (ADScrnFrame:IsVisible()) then return end
	ADScrnDelay2 = GetTime();
	if (ADScrnDelay1 - ADScrnDelay2 > 0) then return end
	TakeScreenshot();
	ADScrnFrame:Hide();
end

function AD_List()
	local count = AutoDingSaved[AD_Player].DingCount;
	local race = UnitRace("player");
	
	if count == 1 then DingString = General1;
	elseif count == 2 then DingString = General2;
	elseif count == 3 then DingString = General3;
	elseif count == 4 then DingString = General4;
	elseif count == 5 then DingString = General5;
	elseif count == 11 then DingString = General11;
	elseif count == 12 then DingString = General12;
	elseif count == 13 then DingString = General13;
	elseif count == 14 then DingString = General14;
	elseif count == 15 then DingString = General15;	
	
	elseif race == "Draenei" then
		if count == 6  then DingString = Draenei6;  end
		if count == 7  then DingString = Draenei7;  end
		if count == 8  then DingString = Draenei8;  end
		if count == 9  then DingString = Draenei9;  end
		if count == 10 then DingString = Draenei10; end	

	elseif race == "Human" then
		if count == 6  then DingString = Human6;  end
		if count == 7  then DingString = Human7;  end
		if count == 8  then DingString = Human8;  end
		if count == 9  then DingString = Human9;  end
		if count == 10 then DingString = Human10; end

	elseif race == "Night Elf" then
		if count == 6  then DingString = NightElf6;  end
		if count == 7  then DingString = NightElf7;  end
		if count == 8  then DingString = NightElf8;  end
		if count == 9  then DingString = NightElf9;  end
		if count == 10 then DingString = NightElf10; end

	elseif race == "Dwarf" then
		if count == 6  then DingString = Dwarf6;  end
		if count == 7  then DingString = Dwarf7;  end
		if count == 8  then DingString = Dwarf8;  end
		if count == 9  then DingString = Dwarf9;  end
		if count == 10 then DingString = Dwarf10; end

	elseif race == "Gnome" then
		if count == 6  then DingString = Gnome6;  end
		if count == 7  then DingString = Gnome7;  end
		if count == 8  then DingString = Gnome8;  end
		if count == 9  then DingString = Gnome9;  end
		if count == 10 then DingString = Gnome10; end
		
	elseif race == "Blood Elf" then
		if count == 6  then DingString = BloodElf6;  end
		if count == 7  then DingString = BloodElf7;  end
		if count == 8  then DingString = BloodElf8;  end
		if count == 9  then DingString = BloodElf9;  end
		if count == 10 then DingString = BloodElf10; end	
     
	elseif race == "Undead" then
		if count == 6  then DingString = Undead6;  end
		if count == 7  then DingString = Undead7;  end
		if count == 8  then DingString = Undead8;  end
		if count == 9  then DingString = Undead9;  end
		if count == 10 then DingString = Undead10; end
	
	elseif race == "Troll" then
		if count == 6  then DingString = Troll6;  end
		if count == 7  then DingString = Troll7;  end
		if count == 8  then DingString = Troll8;  end
		if count == 9  then DingString = Troll9;  end
		if count == 10 then DingString = Troll10; end

	elseif race == "Tauren" then
		if count == 6  then DingString = Tauren6;  end
		if count == 7  then DingString = Tauren7;  end
		if count == 8  then DingString = Tauren8;  end
		if count == 9  then DingString = Tauren9;  end
		if count == 10 then DingString = Tauren10; end

	elseif race == "Orc" then
		if count == 6  then DingString = Orc6;  end
		if count == 7  then DingString = Orc7;  end
		if count == 8  then DingString = Orc8;  end
		if count == 9  then DingString = Orc9;  end
		if count == 10 then DingString = Orc10; end

	else DingString = DefaultDing;
	end

	if ADLevel == 40 then DingString = Level40; end
	if ADLevel == 60 then DingString = Level60; end
	if ADLevel == 65 then DingString = Level65; end
	if ADLevel == 70 then DingString = Level70; end
end
