function AtlasLoot_SetMenu(setname)
    if(setname=="AQ40SET") then
        AtlasLootAQ40SetMenu();
    elseif(setname=="AQ20SET") then
        AtlasLootAQ20SetMenu();
    elseif(setname=="ZGSET") then
        AtlasLootZGSetMenu();
    elseif(setname=="ARENASET") then
        AtlasLootARENASetMenu();
    elseif(setname=="T5SET") then
        AtlasLootT5SetMenu();
    elseif(setname=="T4SET") then
        AtlasLootT4SetMenu();
    elseif(setname=="T3SET") then
        AtlasLootT3SetMenu();
    elseif(setname=="T2SET") then
        AtlasLootT2SetMenu();
    elseif(setname=="T1SET") then
        AtlasLootT1SetMenu();
    elseif(setname=="T0SET") then
        AtlasLootT0SetMenu();
    elseif(setname=="PVPSET") then
        AtlasLootPVPSetMenu();
    elseif(setname=="PVP70SET") then
        AtlasLootPVP70SetMenu();
    elseif(setname=="DS3SET") then
        AtlasLootDS3SetMenu();
    end
    for i=1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
end

--------------------------------------------------------------------------------
-- Deal with items sets
--------------------------------------------------------------------------------
function AtlasLoot_Set(setname)
    if(setname~=nil) then
        AtlasLoot_SetMenu(setname);
    elseif(this:GetName()=="AtlasLootItemsFrame_BACK") then
        AtlasLoot_SetMenu(this.setname);
    elseif(this:GetName()=="AtlasLootItemsFrame_PREV" and AtlasLoot_BossName:GetText()==ATLASLOOT_PVP_WEAPONS) then
        getglobal("AtlasLootItemsFrame_PREV"):Hide();
        AtlasLoot_ShowBossLoot(this.lootpage, ATLASLOOT_PVP_WEAPONS, AtlasLoot_AnchorFrame);
        getglobal("AtlasLootItemsFrame_NEXT"):Show();
        if this.lootpage=="PVPWeapons1" then
            getglobal("AtlasLootItemsFrame_NEXT").lootpage="PVPWeapons2";
        elseif this.lootpage=="PVP70Weapons1" then
            getglobal("AtlasLootItemsFrame_NEXT").lootpage="PVP70Weapons2";
        end
    elseif(this:GetName()=="AtlasLootItemsFrame_NEXT" and AtlasLoot_BossName:GetText()==ATLASLOOT_PVP_WEAPONS) then
        getglobal("AtlasLootItemsFrame_NEXT"):Hide();
        AtlasLoot_ShowBossLoot(this.lootpage, ATLASLOOT_PVP_WEAPONS, AtlasLoot_AnchorFrame);
        getglobal("AtlasLootItemsFrame_PREV"):Show();
        if this.lootpage=="PVPWeapons2" then
            getglobal("AtlasLootItemsFrame_PREV").lootpage="PVPWeapons1";
        elseif this.lootpage=="PVP70Weapons2" then
            getglobal("AtlasLootItemsFrame_PREV").lootpage="PVP70Weapons1";
        end
    elseif(this:GetName()=="AtlasLootItemsFrame_PREV" and AtlasLoot_BossName:GetText()==ATLASLOOT_PVP_NONSET) then
        AtlasLoot_ShowBossLoot(this.lootpage, ATLASLOOT_PVP_NONSET, AtlasLoot_AnchorFrame);
        if this.lootpage=="PvP70NonSet1" then
            getglobal("AtlasLootItemsFrame_NEXT").lootpage="PvP70NonSet2";
            getglobal("AtlasLootItemsFrame_NEXT"):Show();
            getglobal("AtlasLootItemsFrame_PREV"):Hide();
        elseif this.lootpage=="PvP70NonSet2" then
            getglobal("AtlasLootItemsFrame_NEXT").lootpage="PvP70NonSet3";
            getglobal("AtlasLootItemsFrame_NEXT"):Show();
            getglobal("AtlasLootItemsFrame_PREV").lootpage="PvP70NonSet1";
            getglobal("AtlasLootItemsFrame_PREV"):Show();
        end
    elseif(this:GetName()=="AtlasLootItemsFrame_NEXT" and AtlasLoot_BossName:GetText()==ATLASLOOT_PVP_NONSET) then
        AtlasLoot_ShowBossLoot(this.lootpage, ATLASLOOT_PVP_NONSET, AtlasLoot_AnchorFrame);
        if this.lootpage=="PvP70NonSet2" then
            getglobal("AtlasLootItemsFrame_NEXT").lootpage="PvP70NonSet3";
            getglobal("AtlasLootItemsFrame_NEXT"):Show();
            getglobal("AtlasLootItemsFrame_PREV").lootpage="PvP70NonSet1";
            getglobal("AtlasLootItemsFrame_PREV"):Show();
        elseif this.lootpage=="PvP70NonSet3" then
            getglobal("AtlasLootItemsFrame_PREV").lootpage="PvP70NonSet2";
            getglobal("AtlasLootItemsFrame_PREV"):Show();
            getglobal("AtlasLootItemsFrame_NEXT"):Hide();
        end
    elseif(this:GetName()=="AtlasLootItemsFrame_NEXT" or this:GetName()=="AtlasLootItemsFrame_PREV") then
        AtlasLoot_Rep(this.lootpage, AtlasLoot_BossName:GetText());
    else
        getglobal("AtlasLootItemsFrame_NEXT"):Hide();
        getglobal("AtlasLootItemsFrame_PREV"):Hide();
        AtlasLoot_ShowBossLoot(this.lootpage, this:GetText(), AtlasLoot_AnchorFrame);
        getglobal("AtlasLootItemsFrame_BACK"):Show();
    end
end

function AtlasLootSetButton_OnClick(setid)
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    if (setid=="PVPWeapons1") then
        AtlasLoot_ShowBossLoot(setid, getglobal(this:GetName().."_Name"):GetText(), AtlasLoot_AnchorFrame);
        getglobal("AtlasLootItemsFrame_NEXT").lootpage="PVPWeapons2";
        getglobal("AtlasLootItemsFrame_NEXT"):Show();
    elseif (setid=="PVPWeapons2") then
        AtlasLoot_ShowBossLoot(setid, getglobal(this:GetName().."_Name"):GetText(), AtlasLoot_AnchorFrame);
        getglobal("AtlasLootItemsFrame_PREV").lootpage="PVPWeapons1";
        getglobal("AtlasLootItemsFrame_PREV"):Show();
    elseif (setid=="PVP70Weapons1") then
        AtlasLoot_ShowBossLoot(setid, getglobal(this:GetName().."_Name"):GetText(), AtlasLoot_AnchorFrame);
        getglobal("AtlasLootItemsFrame_NEXT").lootpage="PVP70Weapons2";
        getglobal("AtlasLootItemsFrame_NEXT"):Show();
    elseif (setid=="PVP70Weapons2") then
        AtlasLoot_ShowBossLoot(setid, getglobal(this:GetName().."_Name"):GetText(), AtlasLoot_AnchorFrame);
        getglobal("AtlasLootItemsFrame_PREV").lootpage="PVP70Weapons1";
        getglobal("AtlasLootItemsFrame_PREV"):Show();
    elseif (setid=="PvP70NonSet1") then
        AtlasLoot_ShowBossLoot(setid, getglobal(this:GetName().."_Name"):GetText(), AtlasLoot_AnchorFrame);
        getglobal("AtlasLootItemsFrame_NEXT").lootpage="PvP70NonSet2";
        getglobal("AtlasLootItemsFrame_NEXT"):Show();
    elseif (setid=="PvP70NonSet2") then
        AtlasLoot_ShowBossLoot(setid, getglobal(this:GetName().."_Name"):GetText(), AtlasLoot_AnchorFrame);
        getglobal("AtlasLootItemsFrame_PREV").lootpage="PvP70NonSet1";
        getglobal("AtlasLootItemsFrame_PREV"):Show();
        getglobal("AtlasLootItemsFrame_NEXT").lootpage="PvP70NonSet3";
        getglobal("AtlasLootItemsFrame_NEXT"):Show();
    elseif (setid=="PvP70NonSet3") then
        AtlasLoot_ShowBossLoot(setid, getglobal(this:GetName().."_Name"):GetText(), AtlasLoot_AnchorFrame);
        getglobal("AtlasLootItemsFrame_PREV").lootpage="PvP70NonSet2";
        getglobal("AtlasLootItemsFrame_PREV"):Show();
    else
        AtlasLoot_ShowBossLoot(setid, getglobal(this:GetName().."_Name"):GetText(), AtlasLoot_AnchorFrame);
    end
end

function AtlasLootSubSetButton_OnClick(setid)
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    AtlasLoot_ShowBossLoot(setid, getglobal(this:GetName().."_Name"):GetText(), AtlasLoot_AnchorFrame);
    getglobal("AtlasLootItemsFrame_BACK"):Show();
end

function AtlasLootSetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --ZG
    AtlasLootMenuItem_2_Name:SetText(ATLASLOOT_ZG_SETS);
    AtlasLootMenuItem_2_Extra:SetText("");
    AtlasLootMenuItem_2_Icon:SetTexture("Interface\\Icons\\INV_Jewelry_Necklace_19");
    AtlasLootMenuItem_2.type="Sets";
    AtlasLootMenuItem_2.lootpage="ZGSET";
    AtlasLootMenuItem_2:Show();
    --AQ20
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_AQ20_SETS);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\INV_Jewelry_Ring_AhnQiraj_03");
    AtlasLootMenuItem_3.type="Sets";
    AtlasLootMenuItem_3.lootpage="AQ20SET";
    AtlasLootMenuItem_3:Show();
    --AQ40
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_AQ40_SETS);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\INV_Sword_59");
    AtlasLootMenuItem_4.type="Sets";
    AtlasLootMenuItem_4.lootpage="AQ40SET";
    AtlasLootMenuItem_4:Show();
    --Legendaries
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_LEGENDARIES);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\INV_Staff_Medivh");
    AtlasLootMenuItem_6.type="Sets";
    AtlasLootMenuItem_6.lootpage="Legendaries";
    AtlasLootMenuItem_6:Show();
    --Hard Mode Tokens
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_HARDMODE);
    AtlasLootMenuItem_7_Extra:SetText("|cffFF8400"..ATLASLOOT_HARDMODE_SUB1);
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\Spell_Holy_ChampionsBond");
    AtlasLootMenuItem_7.type="Sets";
    AtlasLootMenuItem_7.lootpage="HardModeToken";
    AtlasLootMenuItem_7:Show();
    --Hard Mode Tokens: FR Gear
    AtlasLootMenuItem_8_Name:SetText(ATLASLOOT_HARDMODE);
    AtlasLootMenuItem_8_Extra:SetText("|cffFF8400"..ATLASLOOT_HARDMODE_SUB2);
    AtlasLootMenuItem_8_Icon:SetTexture("Interface\\Icons\\Spell_Holy_ChampionsBond");
    AtlasLootMenuItem_8.type="Sets";
    AtlasLootMenuItem_8.lootpage="HardModeToken2";
    AtlasLootMenuItem_8:Show();
    --PvP
    AtlasLootMenuItem_10_Name:SetText(ATLASLOOT_PVP_SETS);
    AtlasLootMenuItem_10_Extra:SetText("|cffFF8400"..ATLASLOOT_LEVEL_60);
    AtlasLootMenuItem_10_Icon:SetTexture("Interface\\Icons\\INV_Axe_02");
    AtlasLootMenuItem_10.type="Sets";
    AtlasLootMenuItem_10.lootpage="PVPSET";
    AtlasLootMenuItem_10:Show();
    --PvP
    AtlasLootMenuItem_11_Name:SetText(ATLASLOOT_PVP_SETS);
    AtlasLootMenuItem_11_Extra:SetText("|cffFF8400"..ATLASLOOT_LEVEL_70);
    AtlasLootMenuItem_11_Icon:SetTexture("Interface\\Icons\\INV_Axe_02");
    AtlasLootMenuItem_11.type="Sets";
    AtlasLootMenuItem_11.lootpage="PVP70SET";
    AtlasLootMenuItem_11:Show();
    --Arena PvP
    AtlasLootMenuItem_12_Name:SetText(ATLASLOOT_ARENA_SETS);
    AtlasLootMenuItem_12_Extra:SetText("");
    AtlasLootMenuItem_12_Icon:SetTexture("Interface\\Icons\\INV_Mace_36");
    AtlasLootMenuItem_12.type="Sets";
    AtlasLootMenuItem_12.lootpage="ARENASET";
    AtlasLootMenuItem_12:Show();
    --Dungeon Set 1/2
    AtlasLootMenuItem_17_Name:SetText(ATLASLOOT_TIER0_SETS);
    AtlasLootMenuItem_17_Extra:SetText("");
    AtlasLootMenuItem_17_Icon:SetTexture("Interface\\Icons\\INV_Chest_Chain_03");
    AtlasLootMenuItem_17.type="Sets";
    AtlasLootMenuItem_17.lootpage="T0SET";
    AtlasLootMenuItem_17:Show();
    --Dungeon Set 3
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_DS3_SETS);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\INV_Helmet_15");
    AtlasLootMenuItem_18.type="Sets";
    AtlasLootMenuItem_18.lootpage="DS3SET";
    AtlasLootMenuItem_18:Show();
    --Tier 1
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_TIER1_SETS);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\INV_Pants_Mail_03");
    AtlasLootMenuItem_19.type="Sets";
    AtlasLootMenuItem_19.lootpage="T1SET";
    AtlasLootMenuItem_19:Show();
    --Tier 2
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_TIER2_SETS);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\INV_Shoulder_32");
    AtlasLootMenuItem_20.type="Sets";
    AtlasLootMenuItem_20.lootpage="T2SET";
    AtlasLootMenuItem_20:Show();
    --Tier 3
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_TIER3_SETS);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Sets";
    AtlasLootMenuItem_21.lootpage="T3SET";
    AtlasLootMenuItem_21:Show();
    --Tier 4
    AtlasLootMenuItem_22_Name:SetText(ATLASLOOT_TIER4_SETS);
    AtlasLootMenuItem_22_Extra:SetText("");
    AtlasLootMenuItem_22_Icon:SetTexture("Interface\\Icons\\INV_Shoulder_14");
    AtlasLootMenuItem_22.type="Sets";
    AtlasLootMenuItem_22.lootpage="T4SET";
    AtlasLootMenuItem_22:Show();
    --Tier 5
    AtlasLootMenuItem_23_Name:SetText(ATLASLOOT_TIER5_SETS);
    AtlasLootMenuItem_23_Extra:SetText("");
    AtlasLootMenuItem_23_Icon:SetTexture("Interface\\Icons\\INV_Crown_01");
    AtlasLootMenuItem_23.type="Sets";
    AtlasLootMenuItem_23.lootpage="T5SET";
    AtlasLootMenuItem_23:Show();
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_PANEL_BUTTON_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootAQ40SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DRUID);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="AQ40Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_MAGE);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="AQ40Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_PRIEST);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="AQ40Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_SHAMAN);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="AQ40Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_WARRIOR);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="AQ40Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_HUNTER);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="AQ40Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_PALADIN);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="AQ40Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_ROGUE);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="AQ40Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_WARLOCK);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="AQ40Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="AQ40SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_AQ40_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootAQ20SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DRUID);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="AQ20Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_MAGE);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="AQ20Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_PRIEST);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="AQ20Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_SHAMAN);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="AQ20Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_WARRIOR);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="AQ20Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_HUNTER);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="AQ20Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_PALADIN);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="AQ20Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_ROGUE);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="AQ20Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_WARLOCK);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="AQ20Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="AQ20SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_AQ20_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootZGSetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DRUID);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="ZGDruid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_MAGE);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="ZGMage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_PRIEST);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="ZGPriest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_SHAMAN);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="ZGShaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_WARRIOR);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="ZGWarrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_HUNTER);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="ZGHunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_PALADIN);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="ZGPaladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_ROGUE);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="ZGRogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_WARLOCK);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="ZGWarlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="ZGSET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_ZG_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootARENASetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DRUID);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="ArenaDruid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_MAGE);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="ArenaMage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_PRIEST);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="ArenaPriest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_SHAMAN);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="ArenaShaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_WARRIOR);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="ArenaWarrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_HUNTER);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="ArenaHunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_PALADIN);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="ArenaPaladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_ROGUE);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="ArenaRogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_WARLOCK);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="ArenaWarlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="ARENASET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_ARENA_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT0SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DRUID);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T0Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_MAGE);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T0Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_PRIEST);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T0Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_SHAMAN);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T0Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_WARRIOR);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T0Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_HUNTER);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T0Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_PALADIN);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T0Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_ROGUE);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T0Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_WARLOCK);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T0Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T0SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_TIER0_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT1SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DRUID);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T1Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_MAGE);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T1Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_PRIEST);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T1Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_SHAMAN);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T1Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_WARRIOR);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T1Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_HUNTER);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T1Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_PALADIN);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T1Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_ROGUE);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T1Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_WARLOCK);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T1Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T1SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_TIER1_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT2SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DRUID);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T2Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_MAGE);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T2Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_PRIEST);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T2Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_SHAMAN);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T2Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_WARRIOR);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T2Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_HUNTER);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T2Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_PALADIN);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T2Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_ROGUE);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T2Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_WARLOCK);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T2Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T2SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_TIER2_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT3SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DRUID);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T3Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_MAGE);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T3Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_PRIEST);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T3Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_SHAMAN);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T3Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_WARRIOR);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T3Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_HUNTER);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T3Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_PALADIN);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T3Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_ROGUE);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T3Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_WARLOCK);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T3Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T3SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_TIER3_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT4SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DRUID);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T4Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_MAGE);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T4Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_PRIEST);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T4Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_SHAMAN);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T4Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_WARRIOR);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T4Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_HUNTER);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T4Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_PALADIN);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T4Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_ROGUE);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T4Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_WARLOCK);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T4Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T4SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_TIER4_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootPVPSetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DRUID);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="PVPDruid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_MAGE);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="PVPMage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_PRIEST);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="PVPPriest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_SHAMAN);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="PVPShaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_WARRIOR);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="PVPWarrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_HUNTER);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="PVPHunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_PALADIN);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="PVPPaladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_ROGUE);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="PVPRogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_WARLOCK);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="PVPWarlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="PVPSET";
    getglobal("AtlasLootItemsFrame_NEXT").lootpage="PVPWeapons2";
    getglobal("AtlasLootItemsFrame_PREV").lootpage="PVPWeapons1";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_PVP_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootDS3SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Hallowed Set
    AtlasLootMenuItem_2_Name:SetText(ATLASLOOT_DS3_HALLOWED);
    AtlasLootMenuItem_2_Extra:SetText("|cffFF8400"..ATLASLOOT_CLOTH);
    AtlasLootMenuItem_2_Icon:SetTexture("Interface\\Icons\\Spell_Holy_InnerFire");
    AtlasLootMenuItem_2.type="Subset";
    AtlasLootMenuItem_2.lootpage="DS3Hallowed";
    AtlasLootMenuItem_2:Show();
    --Incanter Set
    AtlasLootMenuItem_17_Name:SetText(ATLASLOOT_DS3_INCANTER);
    AtlasLootMenuItem_17_Extra:SetText("|cffFF8400"..ATLASLOOT_CLOTH);
    AtlasLootMenuItem_17_Icon:SetTexture("Interface\\Icons\\Ability_Creature_Cursed_04");
    AtlasLootMenuItem_17.type="Subset";
    AtlasLootMenuItem_17.lootpage="DS3Incanter";
    AtlasLootMenuItem_17:Show();
    --Mana-Etched Set
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DS3_MANA);
    AtlasLootMenuItem_3_Extra:SetText("|cffFF8400"..ATLASLOOT_CLOTH);
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\INV_Elemental_Mote_Nether");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="DS3Mana";
    AtlasLootMenuItem_3:Show();
    --Oblivion Set
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_DS3_OBLIVION);
    AtlasLootMenuItem_18_Extra:SetText("|cffFF8400"..ATLASLOOT_CLOTH);
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Creature_Cursed_03");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="DS3Oblivion";
    AtlasLootMenuItem_18:Show();
    --Assassination Set
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_DS3_ASSASSIN);
    AtlasLootMenuItem_5_Extra:SetText("|cffFF8400"..ATLASLOOT_LEATHER);
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Ability_Rogue_SinisterCalling");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="DS3Assassin";
    AtlasLootMenuItem_5:Show();
    --Moonglade Set
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_DS3_MOONGLADE);
    AtlasLootMenuItem_20_Extra:SetText("|cffFF8400"..ATLASLOOT_LEATHER);
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfRighteousness");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="DS3Moonglade";
    AtlasLootMenuItem_20:Show();
    --Wastewalker Set
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_DS3_WASTEWALKER);
    AtlasLootMenuItem_6_Extra:SetText("|cffFF8400"..ATLASLOOT_LEATHER);
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RapidKilling");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="DS3Wastewalker";
    AtlasLootMenuItem_6:Show();
    --Beast Lord Set
    AtlasLootMenuItem_8_Name:SetText(ATLASLOOT_DS3_BEAST);
    AtlasLootMenuItem_8_Extra:SetText("|cffFF8400"..ATLASLOOT_MAIL);
    AtlasLootMenuItem_8_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_Pet_Wolf");
    AtlasLootMenuItem_8.type="Subset";
    AtlasLootMenuItem_8.lootpage="DS3Beast";
    AtlasLootMenuItem_8:Show();
    --Desolation Set
    AtlasLootMenuItem_23_Name:SetText(ATLASLOOT_DS3_DESOLATION);
    AtlasLootMenuItem_23_Extra:SetText("|cffFF8400"..ATLASLOOT_MAIL);
    AtlasLootMenuItem_23_Icon:SetTexture("Interface\\Icons\\Ability_FiegnDead");
    AtlasLootMenuItem_23.type="Subset";
    AtlasLootMenuItem_23.lootpage="DS3Desolation";
    AtlasLootMenuItem_23:Show();
    --Tidefury Set
    AtlasLootMenuItem_9_Name:SetText(ATLASLOOT_DS3_TIDEFURY);
    AtlasLootMenuItem_9_Extra:SetText("|cffFF8400"..ATLASLOOT_MAIL);
    AtlasLootMenuItem_9_Icon:SetTexture("Interface\\Icons\\INV_Helmet_70");
    AtlasLootMenuItem_9.type="Subset";
    AtlasLootMenuItem_9.lootpage="DS3Tidefury";
    AtlasLootMenuItem_9:Show();
    --Bold Set
    AtlasLootMenuItem_11_Name:SetText(ATLASLOOT_DS3_BOLD);
    AtlasLootMenuItem_11_Extra:SetText("|cffFF8400"..ATLASLOOT_PLATE);
    AtlasLootMenuItem_11_Icon:SetTexture("Interface\\Icons\\Spell_Fire_EnchantWeapon");
    AtlasLootMenuItem_11.type="Subset";
    AtlasLootMenuItem_11.lootpage="DS3Bold";
    AtlasLootMenuItem_11:Show();
    --Doomplate Set
    AtlasLootMenuItem_26_Name:SetText(ATLASLOOT_DS3_DOOM);
    AtlasLootMenuItem_26_Extra:SetText("|cffFF8400"..ATLASLOOT_PLATE);
    AtlasLootMenuItem_26_Icon:SetTexture("Interface\\Icons\\INV_Helmet_08");
    AtlasLootMenuItem_26.type="Subset";
    AtlasLootMenuItem_26.lootpage="DS3Doom";
    AtlasLootMenuItem_26:Show();
    --Righteous Set
    AtlasLootMenuItem_12_Name:SetText(ATLASLOOT_DS3_RIGHT);
    AtlasLootMenuItem_12_Extra:SetText("|cffFF8400"..ATLASLOOT_PLATE);
    AtlasLootMenuItem_12_Icon:SetTexture("Interface\\Icons\\INV_Hammer_02");
    AtlasLootMenuItem_12.type="Subset";
    AtlasLootMenuItem_12.lootpage="DS3Right";
    AtlasLootMenuItem_12:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="DS3SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_DS3_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootT5SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DRUID);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="T5Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_MAGE);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="T5Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_PRIEST);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="T5Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_SHAMAN);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="T5Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_WARRIOR);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="T5Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_HUNTER);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="T5Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_PALADIN);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="T5Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_ROGUE);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="T5Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_WARLOCK);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="T5Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="T5SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_TIER5_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end

function AtlasLootPVP70SetMenu()
    for i = 1, 30, 1 do
        getglobal("AtlasLootItem_"..i):Hide();
    end
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i):Hide();
    end
    getglobal("AtlasLootItemsFrame_NEXT"):Hide();
    getglobal("AtlasLootItemsFrame_PREV"):Hide();
    --Druid
    AtlasLootMenuItem_3_Name:SetText(ATLASLOOT_DRUID);
    AtlasLootMenuItem_3_Extra:SetText("");
    AtlasLootMenuItem_3_Icon:SetTexture("Interface\\Icons\\Spell_Nature_Regeneration");
    AtlasLootMenuItem_3.type="Subset";
    AtlasLootMenuItem_3.lootpage="PVP70Druid";
    AtlasLootMenuItem_3:Show();
    --Mage
    AtlasLootMenuItem_4_Name:SetText(ATLASLOOT_MAGE);
    AtlasLootMenuItem_4_Extra:SetText("");
    AtlasLootMenuItem_4_Icon:SetTexture("Interface\\Icons\\Spell_Frost_IceStorm");
    AtlasLootMenuItem_4.type="Subset";
    AtlasLootMenuItem_4.lootpage="PVP70Mage";
    AtlasLootMenuItem_4:Show();
    --Priest
    AtlasLootMenuItem_5_Name:SetText(ATLASLOOT_PRIEST);
    AtlasLootMenuItem_5_Extra:SetText("");
    AtlasLootMenuItem_5_Icon:SetTexture("Interface\\Icons\\Spell_Holy_PowerWordShield");
    AtlasLootMenuItem_5.type="Subset";
    AtlasLootMenuItem_5.lootpage="PVP70Priest";
    AtlasLootMenuItem_5:Show();
    --Shaman
    AtlasLootMenuItem_6_Name:SetText(ATLASLOOT_SHAMAN);
    AtlasLootMenuItem_6_Extra:SetText("");
    AtlasLootMenuItem_6_Icon:SetTexture("Interface\\Icons\\Spell_FireResistanceTotem_01");
    AtlasLootMenuItem_6.type="Subset";
    AtlasLootMenuItem_6.lootpage="PVP70Shaman";
    AtlasLootMenuItem_6:Show();
    --Warrior
    AtlasLootMenuItem_7_Name:SetText(ATLASLOOT_WARRIOR);
    AtlasLootMenuItem_7_Extra:SetText("");
    AtlasLootMenuItem_7_Icon:SetTexture("Interface\\Icons\\INV_Shield_05");
    AtlasLootMenuItem_7.type="Subset";
    AtlasLootMenuItem_7.lootpage="PVP70Warrior";
    AtlasLootMenuItem_7:Show();
    --Hunter
    AtlasLootMenuItem_18_Name:SetText(ATLASLOOT_HUNTER);
    AtlasLootMenuItem_18_Extra:SetText("");
    AtlasLootMenuItem_18_Icon:SetTexture("Interface\\Icons\\Ability_Hunter_RunningShot");
    AtlasLootMenuItem_18.type="Subset";
    AtlasLootMenuItem_18.lootpage="PVP70Hunter";
    AtlasLootMenuItem_18:Show();
    --Paladin
    AtlasLootMenuItem_19_Name:SetText(ATLASLOOT_PALADIN);
    AtlasLootMenuItem_19_Extra:SetText("");
    AtlasLootMenuItem_19_Icon:SetTexture("Interface\\Icons\\Spell_Holy_SealOfMight");
    AtlasLootMenuItem_19.type="Subset";
    AtlasLootMenuItem_19.lootpage="PVP70Paladin";
    AtlasLootMenuItem_19:Show();
    --Rogue
    AtlasLootMenuItem_20_Name:SetText(ATLASLOOT_ROGUE);
    AtlasLootMenuItem_20_Extra:SetText("");
    AtlasLootMenuItem_20_Icon:SetTexture("Interface\\Icons\\Ability_BackStab");
    AtlasLootMenuItem_20.type="Subset";
    AtlasLootMenuItem_20.lootpage="PVP70Rogue";
    AtlasLootMenuItem_20:Show();
    --Warlock
    AtlasLootMenuItem_21_Name:SetText(ATLASLOOT_WARLOCK);
    AtlasLootMenuItem_21_Extra:SetText("");
    AtlasLootMenuItem_21_Icon:SetTexture("Interface\\Icons\\INV_Pants_Cloth_05");
    AtlasLootMenuItem_21.type="Subset";
    AtlasLootMenuItem_21.lootpage="PVP70Warlock";
    AtlasLootMenuItem_21:Show();
    getglobal("AtlasLootItemsFrame_BACK"):Hide();
    getglobal("AtlasLootItemsFrame_BACK").setname="PVP70SET";
    for i = 1, 30, 1 do
        getglobal("AtlasLootMenuItem_"..i.."_Extra"):Show();
    end
    AtlasLoot_BossName:SetText("|cffFFFFFF"..ATLASLOOT_PVP_SETS);
    AtlasLoot_SetItemInfoFrame(AtlasLoot_AnchorFrame);
end
