--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005, 2006 Dan Gilbert
	Email me at loglow@gmail.com

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]

if ( GetLocale() == "deDE" ) then

	local BLUE = "|cff6666ff";
	local GREY = "|cff999999";
	local GREN = "|cff66cc33";
	local _RED = "|cffcc6666";
	local ORNG = "|cffcc9933";
	local PURP = "|cff9900ff";
	local INDENT = "   ";

	local myCategory = "Fluglinienkarten";

	local myData = {
		FPAllianceEast = {
			ZoneName = "Allianz (Osten)";
			Location = "\195\150stliche K\195\182nigreiche";
			GREY.."1) Kapelle des hoffnungsvollen Lichts,";
				_RED.."      \195\150stliche Pestl\195\164nder";
			GREY.."2) Chillwind-Spitze,";
				_RED.."      Westliche Pestl\195\164nder";
			GREY.."3) Aerie Peak, ".._RED.."Hinterland";
			GREY.."4) Southshore, ".._RED.."Vorgebirge von Hillsbrad";
			GREY.."5) Die Zuflucht, ".._RED.."Arathihochland";
			GREY.."6) Hafen von Menethil, ".._RED.."Sumpfland";
			GREY.."7) Ironforge, ".._RED.."Dun Morogh";
			GREY.."8) Thelsamar, ".._RED.."Loch Modan";
			GREY.."9) Thoriumspitze, ".._RED.."Sengende Schlucht";
			GREY.."10) Morgans Wacht, ".._RED.."Brennende Steppe";
			GREY.."11) Stormwind, ".._RED.."Der Wald von Elwynn";
			GREY.."12) Seenhain, ".._RED.."Rotkammgebirge";
			GREY.."13) Sp\195\164herkuppe, ".._RED.."Westfall";
			GREY.."14) Dunkelhain, ".._RED.."D\195\164mmerwald";
			GREY.."15) Burg Nethergarde,";
				_RED.."       Verw\195\188stete Lande";
			GREY.."16) Booty Bay, ".._RED.."Schlingendorntal";
		};
		FPAllianceWest = {
			ZoneName = "Allianz (Westen)";
			Location = "Kalimdor";
			GREY.."1) Rut'Theran, ".._RED.."Teldrassil";
			GREY.."2) Schrein von Remulos, ".._RED.."Moonglade";
			GREY.."3) Everlook, ".._RED.."Winterspring";
			GREY.."4) Auberdine, ".._RED.."Dunkelk\195\188ste";
			GREY.."5) Nachtlaublichtung, ".._RED.."Teufelswald";
			GREY.."6) Steinkrallengipfel, ".._RED.."Steinkrallengebirge";
			GREY.."7) Astranaar, ".._RED.."Ashenvale";
			GREY.."8) Talrendisspitze, ".._RED.."Azshara";
			GREY.."9) Nijelspitze, ".._RED.."Desolace";
			GREY.."10) Ratchet, ".._RED.."Brachland";
			GREY.."11) Insel Theramore,";
			_RED.."     Marschen von Dustwallow";
			GREY.."12) Festung Feathermoon, ".._RED.."Feralas";
			GREY.."13) Thalanaar, ".._RED.."Feralas";
			GREY.."14) Marshals Zuflucht, ".._RED.."Un'Goro-Krater";
			GREY.."15) Burg Cenarius, ".._RED.."Silithus";
			GREY.."16) Gadgetzan, ".._RED.."Tanaris";
			"";
			GREN.."Gr\195\188n: Nur Druiden";
		};
		FPHordeEast = {
			ZoneName = "Horde (Osten)";
			Location = "\195\150stliche K\195\182nigreiche";
			GREY.."1) Kapelle des hoffnungsvollen Lichts,";
				_RED.."      \195\150stliche Pestl\195\164nder";
			GREY.."2) Undercity, ".._RED.."Tirisfal";
			GREY.."3) Das Grabmal, ".._RED.."Silberwald";
			GREY.."4) Tarrens M\195\188hle, ".._RED.."Vorgebirge von Hillsbrad";
			GREY.."5) Revantusk, ".._RED.."Hinterland";
			GREY.."6) Hammerfall, ".._RED.."Arathihochland";
			GREY.."7) Thoriumspitze, ".._RED.."Sengende Schlucht";
			GREY.."8) Kargath, ".._RED.."\195\150dland";
			GREY.."9) Flammenkamm, ".._RED.."Brennende Steppe";
			GREY.."10) Stonard, ".._RED.."S\195\188mpfe des Elends";
			GREY.."11) Das Basislager von Grom'Gol,";
			_RED.."      Schlingendorntal";
			GREY.."12) Booty Bay, ".._RED.."Schlingendorntal";
		};
		FPHordeWest = {
			ZoneName = "Horde (Westen)";
			Location = "Kalimdor";
			GREY.."1) Schrein von Remulos, ".._RED.."Moonglade";
			GREY.."2) Everlook, ".._RED.."Winterspring";
			GREY.."3) Blutgiftposten, ".._RED.."Teufelswald";
			GREY.."4) Zoram'gar-Au\195\159enposten, ".._RED.."Ashenvale";
			GREY.."5) Valormok, ".._RED.."Azshara";
			GREY.."6) Splintertreeposten, ".._RED.."Ashenvale";
			GREY.."7) Orgrimmar, ".._RED.."Durotar";
			GREY.."8) Sonnenfels, ".._RED.."Steinkrallengebirge";
			GREY.."9) Crossroads, ".._RED.."Brachland";
			GREY.."10) Ratchet, ".._RED.."Brachland";
			GREY.."11) Shadowprey, ".._RED.."Desolace";
			GREY.."12) Thunder Bluff, ".._RED.."Mulgore";
			GREY.."13) Camp Taurajo, ".._RED.."Brachland";
			GREY.."14) Brackenwall, ".._RED.."Marschen von Dustwallow";
			GREY.."15) Camp Mojache, ".._RED.."Feralas";
			GREY.."16) Freiwindposten, ".._RED.."Tausend Nadeln";
			GREY.."17) Marshals Zuflucht, ".._RED.."Un'Goro-Krater";
			GREY.."18) Burg Cenarius, ".._RED.."Silithus";
			GREY.."19) Gadgetzan, ".._RED.."Tanaris";
			"";
			GREN.."Gr\195\188n: Nur Druiden";
		};
	};

	Atlas_RegisterPlugin("AtlasFlightPaths", myCategory, myData);

end
