-- Natur EnemyCastBar PvE Module LUA


NECB_PvE_Module_loaded = true;
NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r PvE Module loaded into memory!", 1, 0.5, 0, 1, UIERRORS_HOLD_TIME);


function NECB_PvE_Control(mob, spell, special, bcasted, event)

	if (CEnemyCastBar.bPvE) then

		-- Network BC TempBCaster
		local clientlang = GetLocale();
		
		-- stop Boss CDs from beeing updated by fault when player enters combat
		if (special == "engage") then
			if (CEnemyCastBar_EngageProtection() ) then
				necbengagecd = GetTime();
				return;
			end
			necbengagecd = GetTime();
			NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r EngageProtection enabled!", 1, 1, 0, 1, UIERRORS_HOLD_TIME);
			PlaySoundFile("Sound\\interface\\AuctionWindowOpen.wav");
		else
			if (CEnemyCastBar_EngageProtection() ) then
				necbengagecd = GetTime();
				-- if more than necbEPTime secs have passed without a countdown restart it will be nil'ed in enter combat function later!
			end
		end

		-- logical barrier (+if clause at beginning!):
		if (
					-- only allow instant casts with a flag pass to avoid spell mirroring
				(special == "instcast" and not CEnemyCastBar_Raids[spell].icasted)
					-- stop mirroring spells! only if casted actively
			or	(CEnemyCastBar_Raids[spell].active and not (special == "casts" or special == "performs" or special == "engage") )
					-- check if previously disabled with shift + rightclick;
			or	(CEnemyCastBar_Raids[spell].disabled)
					-- only show bar if player has this target (if defined)
			or	(CEnemyCastBar_Raids[spell].checktarget and UnitName("target") ~= mob and UnitName("focus") ~= mob)
			or	(CEnemyCastBar_Raids[spell].checkengage and not CEnemyCastBar_EngageProtection() )

			) then
			return;
		end

		local icontex = CEnemyCastBar_Raids[spell].icontex; -- > get icon texture
		local globalspell = CEnemyCastBar_Raids[spell].global; -- > This castbar won't be updated if already active!
		local castime = CEnemyCastBar_Raids[spell].t;
		local ctype = CEnemyCastBar_Raids[spell].c;
		
		-- Spell might have the same name but a different cast time on another mob, ie. Onyxia/Nefarian on Bellowing Roar
		if (CEnemyCastBar_Raids[spell].r) then
		
			if ( string.find(CEnemyCastBar_Raids[spell].r, mob) ) then
			
				castime = CEnemyCastBar_Raids[spell].a;
			
			end
		
		end

		if (CEnemyCastBar_Raids[spell].m) then

			mobbuffer = mob;
			mob = CEnemyCastBar_Raids[spell].m;
		
		end

		alreadyshowing = CEnemyCastBar_UniqueCheck(spell,castime,mob,globalspell);

		if (alreadyshowing == 0) then

			CEnemyCastBar_Show(mob, spell, castime, ctype, nil, icontex);
		
		end
		
		if (CEnemyCastBar_Raids[spell].i) then

			castime = CEnemyCastBar_Raids[spell].i;

			alreadyshowing = CEnemyCastBar_UniqueCheck(spell.." (D)",castime,mob,globalspell);
	
			if (alreadyshowing == 0) then

				CEnemyCastBar_Show(mob, spell.." (D)", castime, "hostile", nil, icontex);
			
			end
		
		end

		-- delete bar if defined
		if (CEnemyCastBar_Raids[spell].delBar) then
			CEnemyCastBar_DelBar(CEnemyCastBar_Raids[spell].delBar);
		end

		-- trigger next bars if defined
		if (CEnemyCastBar_Raids[spell].pBar) then
			CEnemyCastBar_Control(mob, CEnemyCastBar_Raids[spell].pBar, "casts", "true"); -- won't be broadcasted!
		end

		-- Network BCasting
		-- restore unchanged mobname
		if (mobbuffer) then
			mob = mobbuffer;
			mobbuffer = nil;
		end

		if (special == "afflicted" and mob ~= CEnemyCastBar_Raids[spell].mcheck) then
			mob = "CECBName"; -- so no channel spam appears after the raid got feared etc.
		end

		BCPacket = {mob, spell, special};
		local freetosend, latency = CEnemyCastBar_BCast_Control(bcasted);
		if ( freetosend ) then
			NECB_SendMessage(".cecbspell "..mob..", "..spell..", "..special..", "..clientlang..", "..latency);
			LastSentBCPacket = {mob, spell, special, GetTime()};
			LastGotBCPacket = {mob, spell, special, GetTime()};
			numspellcast = 0;
		end

		-- recall control function for mobs dying (Obsidian Destroyer) to clear all bars
		if (special == "died") then
			if (mobbuffer) then
				CEnemyCastBar_Control(mobbuffer, "dummy_xyz", "died");
			else
				CEnemyCastBar_Control(mob, "dummy_xyz", "died");
			end
		end

	end

end