--[[

Natur EnemyCastBar
.
. This mod was originally coded by "Limited" - I, Naturfreund, added all codes after Limited's version Carnival Enemy Cast Bar 1.5c
.
=================================
Read Changelog.txt for more info!
=================================
]]--

CECB_status_version_txt = "6.1.0";

function CEnemyCastBar_DefaultVars()

		CEnemyCastBar = { };
		CEnemyCastBar.bStatus = true;
		CEnemyCastBar.bPvP = true;
		CEnemyCastBar.bPvE = true;
		CEnemyCastBar.bLocked = true;
		CEnemyCastBar.bTimer = true;
		CEnemyCastBar.bScale = 1.1;
		CEnemyCastBar.bAlpha = 0.8;
		CEnemyCastBar.bShowafflict = true;
		CEnemyCastBar.bCDown = true;
		CEnemyCastBar.bNumBars = 15;
		-- new variables for new versions (check onload variables!)
		CEnemyCastBar.bParseC = true;
		CEnemyCastBar.bGains = true;
		CEnemyCastBar.bFlipB = false;
		CEnemyCastBar.bSmallTSize = true; -- not an option any longer
		CEnemyCastBar.bFlashit = true; -- not an option any longer
		CEnemyCastBar.bGlobalFrag = true;
		CEnemyCastBar.bBCaster = false;
		CEnemyCastBar.bSoloD = true;
		CEnemyCastBar.bSpace = 15;
		CEnemyCastBar.bDRTimer = true;
		CEnemyCastBar.bMageC = false;
		CEnemyCastBar.bMiniMap = true;
		CECBMiniMapButton:SetPoint("TOPLEFT", "Minimap", "TOPLEFT", 52 - (80 * cos(356)), (80 * sin(356)) - 52);
		CEnemyCastBar.bClassDR = true;
		CEnemyCastBar.bShowIcon = true;
		CEnemyCastBar.bSDoTs = true;
		CEnemyCastBar_SetBarColors();
		CEnemyCastBar.bGlobalPvP = false;
		CEnemyCastBar.bnecbCBLBias = 20;
		CEnemyCastBar.bPvEWarn = true;
		CEnemyCastBar.bGainsOnly = false;
		CEnemyCastBar.bTempFPSBar = false;
		CEnemyCastBar.bFPSBarLocked = false;
		CEnemyCastBar.bThrottle = 0.00;
		CEnemyCastBar.bSpellBreaks = true;
		CEnemyCastBar.bMouseBar = true;
		CEnemyCastBar.bDisBorder = true;
		CEnemyCastBar.bBarTexture = 0;
		CEnemyCastBar.bHostileOnly = false;
		CEnemyCastBar.bBossAfflict = true;

end

function CEnemyCastBar_SetBarColors(msg)

		--initialize colors
		cecbcolors = {"Hostile", "Friendly", "Cooldown", "Gains", "Grey", "Afflict", "Stuns", "Cursetype"};

		if (msg == "SetColors") then
			local i = 1
			while (CEnemyCastBar.tColor[i]) do
				getglobal("CECBPickColorOptions_"..cecbcolors[i].."NormalTexture"):SetVertexColor(CEnemyCastBar.tColor[i][1], CEnemyCastBar.tColor[i][2], CEnemyCastBar.tColor[i][3]);

				for j=1, 3 do
					getglobal("CECBPickColorOptions_"..cecbcolors[i])[j] = CEnemyCastBar.tColor[i][j];
				end
			i = i + 1;
			end

		else
			--default colors
			CEnemyCastBar.tColor = {
				{ 1, 0 ,0 },		--Hostile
				{ 0, 1 ,0 },		--Friendly
				{ 0, 0 ,1 },		--Cooldown
	 			{ 1, 0 ,1 },		--Gains
				{ 0.8, 0.8, 0.8 },	--Grey
				{ 0.8, 0.8, 0 },   	--Afflict						
				{ 0.5, 0.2, 0.1 },	--Stuns, also in 'Variables Loaded'!
				{ 0, 0.8, 0.8 },	--DoTs
			}
		end
end

function CEnemyCastBar_RegisterEvents(command)

	local events_sc = {	"UNIT_SPELLCAST_START", "UNIT_SPELLCAST_DELAYED", "UNIT_SPELLCAST_STOP",
				"CHAT_MSG_SPELL_HOSTILEPLAYER_DAMAGE", "CHAT_MSG_SPELL_FRIENDLYPLAYER_DAMAGE", "CHAT_MSG_SPELL_PARTY_DAMAGE" };

	local events_pve = {	"CHAT_MSG_MONSTER_YELL", "CHAT_MSG_MONSTER_EMOTE", "PLAYER_REGEN_DISABLED" };

	local events_chat = {	"CHAT_MSG_RAID", "CHAT_MSG_PARTY", "CHAT_MSG_RAID_LEADER" };

	local events_gains = {	"CHAT_MSG_SPELL_HOSTILEPLAYER_BUFF", "CHAT_MSG_SPELL_FRIENDLYPLAYER_BUFF", "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_BUFFS",
				"CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_BUFFS", "CHAT_MSG_SPELL_PARTY_BUFF", "CHAT_MSG_SPELL_PERIODIC_PARTY_BUFFS",
				"CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" };

	local events_afflicted = {
				"CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE",
				"CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE",	"CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE",
				"CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE",
				"CHAT_MSG_SPELL_SELF_DAMAGE", "PLAYER_COMBO_POINTS" };

	local eventpacket = {	"CHAT_MSG_SPELL_BREAK_AURA", "CHAT_MSG_SPELL_AURA_GONE_OTHER", "CHAT_MSG_SPELL_AURA_GONE_SELF", "CHAT_MSG_SPELL_AURA_GONE_PARTY",
				"PLAYER_TARGET_CHANGED",
				"CHAT_MSG_ADDON",
				"CHAT_MSG_COMBAT_HOSTILE_DEATH", "CHAT_MSG_COMBAT_FRIENDLY_DEATH", "CHAT_MSG_COMBAT_XP_GAIN",
				"CHAT_MSG_SPELL_FAILED_LOCALPLAYER"};
			--	"CHAT_MSG_SPELL_SELF_BUFF", "CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS", "CHAT_MSG_COMBAT_SELF_HITS" -- for testing self buffs etc.
				--CarniEnemyCastBarFrame:RegisterEvent("CHAT_MSG_CHANNEL"); -- (register for debugging)

	for k,v in pairs (eventpacket) do
		if (command == "unreg_main") then
				CarniEnemyCastBarFrame:UnregisterEvent(eventpacket[k]);
		elseif (command == "reg_main") then
				CarniEnemyCastBarFrame:RegisterEvent(eventpacket[k]);
		end
	end

	local pvpfailed; --prevents that a lod failure of pvp is printed to screen twice
	for k,v in pairs (events_sc) do
		if (CEnemyCastBar.bStatus and CEnemyCastBar.bPvP and not CEnemyCastBar.bGainsOnly and command ~= "unreg_main") then
			-- load pvp module
			if (not NECB_PvP_Module_loaded) then

				local loaded, reason = LoadAddOn("CECB_PvPModule");
				if (loaded) then
					-- what to do
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00'CECB_PvPModule' |rAddOn |cffff9999can not be loaded! |rReason: |cffff0000"..reason)
					CEnemyCastBar.bPvP = false;
					pvpfailed = true;
					break;
				end
			end
			CarniEnemyCastBarFrame:RegisterEvent(events_sc[k]);
		else
			CarniEnemyCastBarFrame:UnregisterEvent(events_sc[k]);
		end
	end

	for k,v in pairs (events_pve) do
		if (CEnemyCastBar.bStatus and CEnemyCastBar.bPvE and IsInInstance() and command ~= "unreg_main") then

			-- load pve module
			if (not NECB_PvE_Module_loaded) then

				local loaded, reason = LoadAddOn("CECB_PvEModule");
				if (loaded) then
					-- what to do
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00'CECB_PvEModule' |rAddOn |cffff9999can not be loaded! |rReason: |cffff0000"..reason)
					CEnemyCastBar.bPvE = false;
					break;
				end
			end
			CarniEnemyCastBarFrame:RegisterEvent(events_pve[k]);
		else
			CarniEnemyCastBarFrame:UnregisterEvent(events_pve[k]);
		end
	end

	for k,v in pairs (events_chat) do
		if (CEnemyCastBar.bStatus and CEnemyCastBar.bParseC and command ~= "unreg_main") then
			CarniEnemyCastBarFrame:RegisterEvent(events_chat[k]);
		else
			CarniEnemyCastBarFrame:UnregisterEvent(events_chat[k]);
		end
	end

	for k,v in pairs (events_gains) do
		if (CEnemyCastBar.bStatus and ((CEnemyCastBar.bPvP and CEnemyCastBar.bGains) or CEnemyCastBar.bPvE) and command ~= "unreg_main") then

			-- load pvp module
			if (not NECB_PvP_Module_loaded) then

				local loaded, reason = LoadAddOn("CECB_PvPModule");
				if (loaded or pvpfailed) then
					-- what to do
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00'CECB_PvPModule' |rAddOn |cffff9999can not be loaded! |rReason: |cffff0000"..reason)
					CEnemyCastBar.bPvP = false;
					break;
				end
			end
			CarniEnemyCastBarFrame:RegisterEvent(events_gains[k]);
		else
			CarniEnemyCastBarFrame:UnregisterEvent(events_gains[k]);
		end
	end

	for k,v in pairs (events_afflicted) do
		if (CEnemyCastBar.bStatus and (CEnemyCastBar.bShowafflict or CEnemyCastBar.bPvE) and command ~= "unreg_main") then

			-- load Debuff module
			if (not NECB_Debuffs_Module_loaded) then

				local loaded, reason = LoadAddOn("CECB_Debuffs");
				if (loaded) then
					-- what to do
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00'CECB_Debuffs' |rAddOn |cffff9999can not be loaded! |rReason: |cffff0000"..reason)
					CEnemyCastBar.bPvE = false;
					CEnemyCastBar.bShowafflict = false;
					break;
				end
			end
			CarniEnemyCastBarFrame:RegisterEvent(events_afflicted[k]);
		else
			CarniEnemyCastBarFrame:UnregisterEvent(events_afflicted[k]);
		end
	end

	--CarniEnemyCastBarFrame:RegisterAllEvents(); --for debug purposes

	if (CEnemyCastBar.bDebug) then
		if (command == "unreg_main") then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Debug, |cffff0000Events UNRegistered!");
		else
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Debug, |cff00ff00Events Registered!");
		end
	end

end

function CEnemyCastBar_OnLoad()

	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("PLAYER_LEAVING_WORLD");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	
	SLASH_CARNIVALENEMYCASTBAR1 = "/necb";  
	SlashCmdList["CARNIVALENEMYCASTBAR"] = function(msg)
		CEnemyCastBar_Handler(msg);
	end

end

function CEnemyCastBar_OnEvent(event) --onevent

	-- for debug purposes
	if (CEnemyCastBar and CEnemyCastBar.bDebug) then
		if (not arg1) then
			arg1 = "";
		end
		--if (event == "CHAT_MSG_SPELL_SELF_DAMAGE") then
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Debug, OnEvent: "..arg1.." (event: |cffffff00"..event.."|r)");
		--end
	end
	
	if (event == "PLAYER_COMBO_POINTS") then

		if(CECBownCPsLast and GetComboPoints() < CECBownCPsLast) then

			CECBownCPsHit = CECBownCPsLast;
			CECBownCPsHitTime = GetTime();

			-- check if there was a finishing move right before you lost all CPs (the server might create a difference up to 500ms between those two events!)
			--CECBownCPsHitBuffer = {mob, spell, GetTime(), DRTimer }; -- just to understand what 1,2,3,4 stands for; defined in 'control' function (affliction)^
			if (CECBownCPsHitBuffer and (CECBownCPsHitTime - CECBownCPsHitBuffer[3]) < 1) then

				local CPSpell = CECBownCPsHitBuffer[2];
				castime = CEnemyCastBar_Afflictions[CPSpell].t - (CEnemyCastBar_Afflictions[CPSpell].cpinterval * (5 - CECBownCPsHit));

				local CPDRTimer = CECBownCPsHitBuffer[4];
				if (CPDRTimer == 4 or CPDRTimer == 6) then
					castime = castime / (CPDRTimer - 2);
				end

				CEnemyCastBar_UniqueCheck(CPSpell, castime - (CECBownCPsHitTime - CECBownCPsHitBuffer[3]), CECBownCPsHitBuffer[1], "trueupdate"); --update bar duration
				CECBownCPsHitTime = nil; -- spell already updated no need to wait 3 secs for new afflictions
			end
		end
		CECBownCPsLast = GetComboPoints();
		CECBownCPsHitBuffer = nil;

	elseif (event == "CHAT_MSG_SPELL_FAILED_LOCALPLAYER") then

		if (NECBCustomCasted) then 
			NECBCustomCasted = nil;
		end

	--BC detects casts out of combat range and adjusts casttime duration, even detects and displays unknown spells now!
 	--Events deregistered if PvP disabled or Onlygains enabled
	elseif (event == "UNIT_SPELLCAST_START") then
		if ((arg1 == "target" or arg1 == "focus") and UnitName(arg1) ~= UnitName("player") ) then
			local UCI_spell, _, _, UCI_icon, UCI_startTime, UCI_endTime = UnitCastingInfo(arg1);
			local TargetName = UnitName(arg1);

 			-- check if spell has brackets in its name; REMOVE if color makes no difference (not red colored if unknown)!
			local fbracket,_,spellstacks = string.find(UCI_spell, "(%(.+%))" );
			if (fbracket) then
				UCI_spell = string.sub(UCI_spell, 1, fbracket - 2);
			end

			if (CEnemyCastBar_Spells[UCI_spell]) then
				-- rebuild original spellname for casts
				if (spellstacks) then
					UCI_spell = UCI_spell.." "..spellstacks;
				end

				local castime = (UCI_endTime - UCI_startTime)/1000;
				local alreadyshowing = CEnemyCastBar_UniqueCheck(UCI_spell, castime, TargetName, "trueupdate");
				if (alreadyshowing == 0) then
					CEnemyCastBar_Control(TargetName, UCI_spell, "casts", castime, event);
					--calls control, because of cooldown database!
				end
				--DEFAULT_CHAT_FRAME:AddMessage("Duration: "..castime.." - Mob: "..TargetName);

			elseif (CEnemyCastBar_Raids[UCI_spell] == nil or CEnemyCastBar_Raids[UCI_spell].mcheck ~= TargetName) then
				UCI_icon = string.sub(UCI_icon, 17, string.len(UCI_icon) );
				local castime = (UCI_endTime - UCI_startTime)/1000;
				local alreadyshowing = CEnemyCastBar_UniqueCheck(UCI_spell, castime, TargetName, "trueupdate");
				if (alreadyshowing == 0) then
					local ctype;
					if (UnitIsEnemy("player", arg1) ) then
						ctype = "hostile";
					else
						ctype = "friendly";
					end
					CEnemyCastBar_Show(TargetName, UCI_spell, castime, ctype, turnlabel_, UCI_icon, "unkown spell") -- "unkown spell" colors the text red to know about it
				end
				--DEFAULT_CHAT_FRAME:AddMessage("Duration: "..castime.." - Mob: "..TargetName.." - Icon: "..UCI_icon);
			end
		end

	--BC add this to detect casttime delays
	elseif (event == "UNIT_SPELLCAST_DELAYED") then
		if (arg1 == "target" or arg1 == "focus") then
			local UCI_spell, _, _, _, UCI_startTime, UCI_endTime = UnitCastingInfo(arg1);
			CEnemyCastBar_UniqueCheck(UCI_spell, UCI_startTime/1000, UnitName(arg1), "trueupdate", "delay", UCI_endTime/1000);
			--DEFAULT_CHAT_FRAME:AddMessage("Time: "..GetTime().." - Start: "..UCI_startTime.." - End: "..UCI_endTime);
			--BC changes made to unique function to support this
		end

	elseif (event == "UNIT_SPELLCAST_STOP") then
		if (arg1 == "target" or arg1 == "focus") then
			CEnemyCastBar_Control(UnitName(arg1), UnitName(arg1), "interrupt");
		end

	elseif (event == "CHAT_MSG_MONSTER_YELL" and NECB_PvE_Module_loaded) then
	
		CEnemyCastBar_Yells(arg1, arg2);

	elseif (event == "CHAT_MSG_MONSTER_EMOTE" and NECB_PvE_Module_loaded) then
	
		CEnemyCastBar_Emotes(arg1, arg2);

	elseif (event == "PLAYER_LEAVING_WORLD" and CEnemyCastBar.bStatus) then

		CEnemyCastBar_RegisterEvents("unreg_main");

	elseif (event == "PLAYER_ENTERING_WORLD" and CEnemyCastBar.bStatus) then

		CEnemyCastBar_RegisterEvents("reg_main");
		if ( not necbdisabledyell and CEnemyCastBar.tNECBDisabledSpells and #CEnemyCastBar.tNECBDisabledSpells > 0 ) then
			CEnemyCastBar_Handler("disabled");
			necbdisabledyell = true;
		end

		-- check for loaded localized code and warn if unknown client language
		if (NECB_client_unknown) then
			UIErrorsFrame:AddMessage("Your client language is not beeing supported by NECB!", 1, 1, 1, 1, 5);
			PlaySoundFile("Sound\\Spells\\PVPFlagTakenHorde.wav");
			NECB_client_unknown = nil;
		else
			NECB_client_known = nil;
		end

		-- can't be warned by VARIABLES_LOADED, because the event is fired before cvars are loaded
		if (not NECB_CombatRange_warned) then
			if (tonumber(GetCVar("CombatLogRangeCreature")) > 30 ) then
				NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r Increased Combatlog Range for Creatures detected!", 1, 1, 0, 1, UIERRORS_HOLD_TIME);
			end
			if (tonumber(GetCVar("CombatLogRangeFriendlyPlayers")) > 50 ) then
				NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r Increased Combatlog Range for Players detected!", 1, 1, 0, 1, UIERRORS_HOLD_TIME);
			end
			NECB_CombatRange_warned = true;
		end

	elseif (event == "PLAYER_REGEN_DISABLED" and NECB_PvE_Module_loaded) then

		CEnemyCastBar_Player_Enter_Combat();

	elseif (event == "PLAYER_TARGET_CHANGED" and CEnemyCastBar.bCDown) then

		CEnemyCastBar_Player_Target_Changed();

	elseif (event == "CHAT_MSG_RAID" or event == "CHAT_MSG_RAID_LEADER") then

		CEnemyCastBar_Parse_RaidChat(arg1, arg2, "Raid");

	elseif (event == "CHAT_MSG_PARTY") then

		CEnemyCastBar_Parse_RaidChat(arg1, arg2, "Party");

	elseif (event == "CHAT_MSG_ADDON") then
	
		if (string.sub(arg1, 1, 4) == "NECB") then

			-- necb network infos + calls the parse function: CEnemyCastBar_Parse_RaidChat(arg2, arg4, arg1="NECB, NECBCHAT, NECBCTRA");

			local msg = arg2;
			local msgsender = arg4;

			local necbcmdcheck, necbtcolor = CEnemyCastBar_Parse_RaidChat(msg, msgsender, arg1); -- calls the parse function!
			if (not necbtcolor) then
				necbtcolor = "|cffcccccc";
			end
			if (necbcmdcheck) then

				if ( NECBParserCollect[100] ) then
					table.remove (NECBParserCollect, 1);
				end

				local startpos;
				if (string.sub (msg, 1, 11) == ".cecbspell ") then
					startpos = 12;
					if (numspellcast == 99) then
						numspellcast = 0;
						numsender = " (|cffffffffS|cffffaaaa):";
					elseif (wrongclient) then
						numsender = " (|cffccccccC|cffffaaaa):";
					elseif (numspellcast > 0 and msgsender ~= UnitName("player")) then
						numsender = " (|cffffff00"..numspellcast.."|cffffaaaa):";
					else
						numsender = ":";
					end

				elseif (string.sub (msg, 1, 7) == "<NECB> ") then
					startpos = 8;
					numsender = ":";
					
				else
					startpos = 1;
					numsender = ":";
				end

				-- reduce length of line
				local i, cropped = 0, "";
				CECBParserFauxText:SetText("|cffffaaaa"..msgsender..numsender.." |cffcccccc"..string.sub (msg, startpos, string.len (msg)));
				if(necbprint2combat and ChatFrame2) then
					ChatFrame2:AddMessage("|cffaaaaaaNECB: [ |cffffaaaa"..msgsender..numsender.." "..necbtcolor..string.sub (msg, startpos, string.len (msg)) .."|cffaaaaaa ]");
				end
				while (CECBParserFauxText:GetStringWidth() > 410) do
					i = i + 1;
					CECBParserFauxText:SetText("|cffffaaaa"..msgsender..numsender.." |cffcccccc"..string.sub (msg, startpos, string.len (msg) -i));
				end

				if (i ~= 0) then
					cropped = "|cffffaaaa...";
				else
					cropped = "";
				end

				table.insert (NECBParserCollect, "|cffffaaaa"..msgsender..numsender.." "..necbtcolor..string.sub (msg, startpos, string.len (msg) -i)..cropped);

				if (CECBParser) then
					if (parserline == 0) then
						CEnemyCastBar_ParserOnClick();
					else
						CECBCTRAParserFrameBOTTOMArrowFlash:Show();
						CEnemyCastBar_ParserOnClick("up");
					end
				end

			end
		end

	elseif ( event == "VARIABLES_LOADED" ) then

		DEFAULT_CHAT_FRAME:AddMessage("|cffffff00Natur EnemyCastBar |cffcccc00("..CECB_status_version_txt..")|cffffff00:|cffffffff AddOn loaded. Use |cff00ff00/necb|cffffffff to configure.");
		NECBVersionDB = { };
		NECBVersionNames = { };
		NECBParserCollect = { };
		NECBtchangeSource = { };
		NECBDisabledSpells = { };
		NECB_CD_DB = { };
		NECB_DR_DB = { }; --DR

		if ( not CEnemyCastBar ) then
			CEnemyCastBar_DefaultVars();
		end

		if (CEnemyCastBar.tNECBDisabledSpells and #CEnemyCastBar.tNECBDisabledSpells > 0) then
			NECB_InfoFrame:AddMessage("|cffaaaaaaNECB:|r Manually disabled Spells detected!\n|cffffffffSee ChatWindow for more info.", 1, 1, 0, 1, UIERRORS_HOLD_TIME);
		end

		-- my addons support, used for helpframe, too!

			CEnemyCastBarHelp = {}; 
			CEnemyCastBarHelp[1] = "|cff00ff00/necb |cffffffff- Toggles the options window.";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000clear |cffffffff- Removes all castbars from screen";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000gcinfo |cffffffff- Display memory usage of all addons";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000versions |cffffffffor |cff00ff00gversions |cffffffff- Show Group/GuildMembers NECB versions.";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000parser |cffffffff- Opens the NECB - AddOn Channel parser.";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000chat |cffffff99Text |cffffffff- Sends '|cffffff99Text|cffffffff' to other NECB's in your group. Happy Chatting...";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000cooldowns |cffffffff- Displays all Cooldowns currently in Database.";
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000wipe |cffffffff- Plays the Benny Hill sound for the Raid's joy."
			CEnemyCastBarHelp[1] = CEnemyCastBarHelp[1].."\n".."|cff00ff00/necb |cffff0000setrange |cff00ff00allmax |cffffffffor |cff00ff00cmax |cffffffff- Adjusts the CombatLogRange! |cff00ff00allmax|cffffffff = set all Ranges to max, |cff00ff00cmax|cffffffff = only creature messages maxed, |cff00ff00leave blank|cffffffff = defaults.\n\n";

			CEnemyCastBarHelp[2] = "|cff00ff00/necb |cffff0000cast|cffffff99 Spell |cffffffff- Use in macros to show a CastBar without waiting for any combatlog message! Same as 'showbar' but this one does not trigger a Bar on most errors (if you are out of range/mana...) Use this macro: \n|cff99ffff /script NECBCustomCasted = true; \n /cast |cffffff99Spell|cff99ffff \n /necb cast |cffffff99Spell\n|cffffffff It renews DoTs/HoTs w/o combatlog messages and halts on errors!";
			CEnemyCastBarHelp[2] = CEnemyCastBarHelp[2].."\n".."|cff00ff00/necb deletebar |cffffff99Label |cffffffff- Deletes ALL CBs which inherit '|cffffff99Label|cffffffff' |cffccccccand|cffffffff match your targets name! Useful before |cff00ff00/cast |cffffff99DoT-HoT-Name|cffffffff in some cases.";
			CEnemyCastBarHelp[2] = CEnemyCastBarHelp[2].."\n".."|cff00ff00/necb showbar |cffffff99Spell |cfffffffftriggers a bar for your current target. It |cffccccccincludes a check|cffffffff: HoTs are only triggered on friendly targets, DoTs only on hostile targets!\n\n";

			CEnemyCastBarHelp[3] = "|cff00ff00/necb |cffff0000countsec|cffffff99 sss Label |cffffffff- Starts a countdown of |cffffff99sss|cffffffff seconds. |cffffff99Label|cffffffff is optional.";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n".."|cff00ff00/necb countmin |cffffff99mmm Label |cffffffff- Starts a countdown of |cffffff99mmm|cffffffff minutes";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n".."|cff00ff00/necb repeat |cffffff99sss Label |cffffffff- Repeated countdown of |cffffff99sss|cffffffff seconds";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n".."|cff00ff00/necb stopcount |cffffff99Label |cffffffff- Stops all grey CastBars which inherit '|cffffff99Label|cffffffff'";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n".."|cffffffffYou may also try |cffff0000.|cff00ff00countsec|cffffffff, |cff00ff00.countmin|cffffffff, |cff00ff00.stopcount|cffffffff.";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n".."|cffffff99Example: |cffffffffType |cff00ff00.countsec |cffffff9910 Ten Seconds|cffffffff into the raid-channel. Everyone in your Raid with NECB and enabled Channel-Parsing will see the bar!";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n".."|cffff0000/script NECB_SendMessage(\"|cffffff99.countmin 15 Nefe respawn|cffff0000\"); |cffffffffwill trigger a bar for all your group members in a '|cffccccccsilent|cffffffff' way!";
			CEnemyCastBarHelp[3] = CEnemyCastBarHelp[3].."\n\n".."|cffff0000SHIFT + LeftClick |cffffffffdeletes the bar, |cffff0000ALT + LeftClick |cffffffffdeletes all bars\n";

			CEnemyCastBarHelp[4] = "|cffff0000SHIFT + RightClick |cffffffffdisables the Spell for the rest of your session!";
			CEnemyCastBarHelp[4] = CEnemyCastBarHelp[4].."\n".."|cff00ff00/necb disabled |cfffffffflists disabled spells.";
			CEnemyCastBarHelp[4] = CEnemyCastBarHelp[4].."\n".."|cff00ff00/necb restore |cffffffffrestores ALL disabled spells!";
			CEnemyCastBarHelp[4] = CEnemyCastBarHelp[4].."\n".."|cff00ff00/necb load |cffffffffloads disabled spells.";
			CEnemyCastBarHelp[4] = CEnemyCastBarHelp[4].."\n".."|cff00ff00/necb save |cffffffffsaves disabled spells. Settings reloaded after every login!";
			CEnemyCastBarHelp[4] = CEnemyCastBarHelp[4].."\n".."|cff00ff00/necb remove xyz or No. |cffffffffremoves xyz from the list of disabled spells!";
			CEnemyCastBarHelp[4] = CEnemyCastBarHelp[4].."\n".."|cff00ff00/necb add xyz |cffffffffadds spell xyz to the list of disabled spells!";
			CEnemyCastBarHelp[4] = CEnemyCastBarHelp[4].."\n\n".."|cff00ff00/necb |cffff0000forcebc|cffffff99 Raidmember |cffffffffwill force '|cffffff99Raidmember|cffffffff' to broadcast CastBars by changing his/her settings!";
			CEnemyCastBarHelp[4] = CEnemyCastBarHelp[4].."\n".."|cff00ff00/necb stopbc |cffffff99Raidmember |cffffffffstops broadcasting Bars!\n|cffffff99Hint:|cffffffff Instead of using '|cffffff99Raidmember|cffffffff' you may simply target the player.\nBoth, force and stop, require 'leader' or 'promoted'!";

		if (myAddOnsFrame_Register) then

			CEnemyCastBarDetails = { 
				name = "CEnemyCastBar", 
				version = CECB_status_version_txt, 
				releaseDate = "2006", 
				author = "Naturfreund", 
				email = "Use my forum or curse-gaming.com", 
				website = "http://www.digital-joker.de/forum", 
				category = MYADDONS_CATEGORY_COMBAT
				};

			myAddOnsFrame_Register(CEnemyCastBarDetails, CEnemyCastBarHelp); 
		end 
                
		-- new variables for new versions
		if (CEnemyCastBar.bParseC == nil) then CEnemyCastBar.bParseC = true; end
		if (CEnemyCastBar.bGains == nil) then CEnemyCastBar.bGains = true; end
		if (CEnemyCastBar.bFlashit == nil) then CEnemyCastBar.bFlashit = true; end
		if (CEnemyCastBar.bGlobalFrag == nil) then CEnemyCastBar.bGlobalFrag = true; end
		if (CEnemyCastBar.bSpace == nil) then CEnemyCastBar.bSpace = 15; end
		if (CEnemyCastBar.bMiniMap == nil or (CEnemyCastBar.bMiniMap ~= false and CEnemyCastBar.bMiniMap ~= 0) ) then
			CEnemyCastBar.bMiniMap = true;
		else 	CEnemyCastBar.bMiniMap = false;
		end
		if (CEnemyCastBar.bShowIcon == nil) then CEnemyCastBar.bShowIcon = true; end
		if (CEnemyCastBar.bnecbCBLBias == nil) then CEnemyCastBar.bnecbCBLBias = 20; end
		if (CEnemyCastBar.bThrottle == nil) then CEnemyCastBar.bThrottle = 0.00; end
		if (CEnemyCastBar.bSpellBreaks == nil) then CEnemyCastBar.bSpellBreaks = true; end
		if (CEnemyCastBar.bCDown == nil) then CEnemyCastBar.bCDown = true; end
		if (CEnemyCastBar.bSmallTSize == nil) then CEnemyCastBar.bSmallTSize = true; end
		if (CEnemyCastBar.bSoloD == nil) then CEnemyCastBar.bSoloD = true; end
		if (CEnemyCastBar.bDRTimer == nil) then CEnemyCastBar.bDRTimer = true; end
		if (CEnemyCastBar.bClassDR == nil) then CEnemyCastBar.bClassDR = true; end
		if (CEnemyCastBar.bSDoTs == nil) then CEnemyCastBar.bSDoTs = true; end
		if (CEnemyCastBar.bPvEWarn == nil) then CEnemyCastBar.bPvEWarn = true; end
		if (CEnemyCastBar.bMouseBar == nil) then -- settings for upgrade to 5.7.0
			CEnemyCastBar.bMouseBar = true; CEnemyCastBar.bDisBorder = true; CEnemyCastBar.bBarTexture = 0;
			CEnemyCastBar.bSpace = 15; CEnemyCastBar.bAlpha = 0.8; CEnemyCastBar.bnecbCBLBias = 20;
		end
		if (CEnemyCastBar.bBossDebuff == nil) then CEnemyCastBar.bBossDebuff = true; end

		if ( CEnemyCastBar.tNECBDisabledSpells and #CEnemyCastBar.tNECBDisabledSpells > 0 ) then
			CEnemyCastBar_LoadNECBDisabledSpells("mute");
		else
			CEnemyCastBar.tNECBDisabledSpells = { };
		end

		if (CEnemyCastBar.tColor == nil) then
			CEnemyCastBar_SetBarColors();
		elseif (CEnemyCastBar.tColor[8] == nil) then
			table.insert(CEnemyCastBar.tColor, 7, { 0.5, 0.2, 0.1 } );
		end

		if (CEnemyCastBar.bTempFPSBar) then
			CECB_FPSBarFree:Show();
		end
		if (CEnemyCastBar.bFPSBarLocked) then
			CECB_FPSBarFree:EnableMouse(0);
		end

		CEnemyCastBar.bLocked = true; -- remove if lock-option is inserted again
		CEnemyCastBar.bDebug = false; -- same here
		CEnemyCastBar_FlipBars();
		CEnemyCastBar_SetTextSize();
		CEnemyCastBar_SetBorder();
		CEnemyCastBar_SetTexture(CEnemyCastBar.bBarTexture);
		CECBownCPsHit = 5; -- Set Combopoints to max for all classes, Rogue/DruidClass will fire an event to change this dynamically

		-- show/hide Minimap button and set localized tooltip
		if (CEnemyCastBar.bMiniMap) then
			CECBMiniMapButton:Show();
		else
			CECBMiniMapButton:Hide();
		end
		CECBMiniMapButton.tooltip = NECB_Minimap_Tooltip;

 		-- variables for the addon channel parser
		numspellcast = 0; parserline = 0;
		for i=1, 85 do
			table.insert (NECBParserCollect, "|cffcccccc- |cff666666"..i.."|cffcccccc -");
		end
		table.insert (NECBParserCollect, " ");
		table.insert (NECBParserCollect, "|r==================================");
		table.insert (NECBParserCollect, "|cffffff00Welcome to the NECB AddOn Channel Parser!");
		table.insert (NECBParserCollect, "This parser displays all NECB commands/broadcasts received by your client.");
		table.insert (NECBParserCollect, " ");
		table.insert (NECBParserCollect, "It follows this pattern:");
		table.insert (NECBParserCollect, "|cffffaaaaBroadcaster: |cffccccccDetected AddOn Message [, ClientLanguage, Latency]|cffffff00");
		table.insert (NECBParserCollect, "|cffccccccgrey|cffffff00 = automatic message; |cffffffccbright yellow|cffffff00 = triggered by user input");
		table.insert (NECBParserCollect, "|cffffaaaa(|cffffffffS|cffffaaaa)|cffffff00 = Sender who triggered a castbar for you. |cffffaaaa(|cffccccccC|cffffaaaa)|cffffff00 = Wrong client!");
		table.insert (NECBParserCollect, "|cffffaaaa(|cffffff00n|cffffaaaa)|cffffff00 = n useless broadcasts of this spell event.|cffffff00");
		table.insert (NECBParserCollect, " ");
		table.insert (NECBParserCollect, "100 lines are buffered. Use up/down at topright to scroll the lines.");
		table.insert (NECBParserCollect, "I tried to make it work like the default chatframe :D");
		table.insert (NECBParserCollect, "|r==================================");
		table.insert (NECBParserCollect, " ");
		-- ctra parser finished

		necbEPTime = 180; -- Duration (in s) until the Engage Protection is shut off

	else

		CEnemyCastBar_Gfind(arg1, event);
	
	end
	
end

function CEnemyCastBar_FauxUpdater()

	if (necbengagedelay and GetTime() - necbengagedelay[2] > necbengagedelay[4]) then

		CEnemyCastBar_Player_Enter_Combat();
	end
end

function CEnemyCastBar_ParserOnClick(msg)

	if (msg) then
		if ((msg == "down" or msg == -1) and parserline < 0) then
			parserline = parserline + 1;
	
		elseif ((msg == "up"  or msg == 1) and parserline > -80) then
			parserline = parserline - 1;
	
		elseif (msg == 0) then
			parserline = 0;
			CECBCTRAParserFrameUPArrow:Enable();
		end

		if (parserline == -80) then
			CECBCTRAParserFrameUPArrow:Disable();
		elseif (parserline == 0) then
			CECBCTRAParserFrameDOWNArrow:Disable();
			CECBCTRAParserFrameBOTTOMArrow:Disable();
			CECBCTRAParserFrameBOTTOMArrowFlash:Hide();
		else
			CECBCTRAParserFrameUPArrow:Enable();
			CECBCTRAParserFrameDOWNArrow:Enable();
			CECBCTRAParserFrameBOTTOMArrow:Enable();
		end
	end

	CECBCTRAParserFrameLineText:SetText(parserline);
	local parserstring = table.concat (NECBParserCollect, "\n", 81 + parserline, 100 + parserline);
	CECBCTRAParserFrameBGText:SetText(parserstring);
	
end

function CEnemyCastBar_ParserButton_OnUpdate(elapsed)
	if (this:GetButtonState() == "PUSHED") then
		this.clickDelay = this.clickDelay - elapsed;
		if ( this.clickDelay < 0 ) then
			local name = this:GetName();
			if ( name == this:GetParent():GetName().."DOWNArrow" ) then
				CEnemyCastBar_ParserOnClick("down");
			elseif ( name == this:GetParent():GetName().."UPArrow" ) then
				CEnemyCastBar_ParserOnClick("up");
			end
			this.clickDelay = MESSAGE_SCROLLBUTTON_SCROLL_DELAY;
		end
	end
end

function CEnemyCastBar_DelBar(msg, type) --delete castbar by label

	for i=1, CEnemyCastBar.bNumBars do
		local label = getglobal("Carni_ECB_"..i).label;
		local ctype = getglobal("Carni_ECB_"..i).ctype;
		if (label and string.find(label, msg) and not (type and not (ctype == "friendly" or ctype == "hostile")) ) then
				CEnemyCastBar_HideBar(i);
		end
	end
end

function CEnemyCastBar_HideBar(num, shiftright, useradd) --hide + disable spells

	local button, fauxbutton;

	if (num) then
		button = getglobal("Carni_ECB_"..num);
		fauxbutton = getglobal("FauxTargetBtn"..num);
	end

	if (shiftright or useradd) then
		local disabled = false;
		local spell;

		if (useradd) then
			spell = useradd;
		else
			spell = button.spell;
			spell = string.gsub(spell, " %(D%)", "");
			if (spell ~= CECB_SPELL_FRENZY_CD) then
				spell = string.gsub(spell, " %(CD%)", "");
			end
		end

		if (spell ~= CECB_SPELL_STUN_DR and not string.find(spell, "DR:") ) then

			if (CEnemyCastBar_Raids[spell]) then
				CEnemyCastBar_Raids[spell].disabled = true;
				disabled = true;
			end
	
			if (CEnemyCastBar_Spells[spell]) then
				CEnemyCastBar_Spells[spell].disabled = true;
				disabled = true;
			end
	
			if (CEnemyCastBar_Afflictions[spell]) then
				CEnemyCastBar_Afflictions[spell].disabled = true;
				disabled = true;
			end
		end

		if (disabled) then
			local spellexists = false;
			for i=1, #NECBDisabledSpells do
				if (NECBDisabledSpells[i] and NECBDisabledSpells[i] == spell) then
					spellexists = true;
					break;
				end
			end

			if (spellexists) then
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffaaaa Spell is already disabled!");
			else
				table.insert (NECBDisabledSpells, spell);
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Disabled \"|cffffff00"..spell.."|r\" (|cffffff00".. #NECBDisabledSpells .."|r total) for this session.");
				if (not necbdisabledyell) then
					necbdisabledyell = true;
				end
			end
		else
			if (num and button.ctype == "grey" ) then
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |rManual timers are not allowed to disable spells!");
			else
				if (useradd) then
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffaaaa Entered Spell not found! |r(Spellname is case sensitive.)");
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffaaaa Spell not found! |rMaybe it was a DR of some spell?");
				end
			end
		end
	end

	if (num) then
		fauxbutton:Hide();
		button:Hide();
		--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Deleted \""..button.label.."\"");
		button.spell = "";
		button.mob = "";
		button.ctype = "";
		button.label = "";
	end
	
end

function CEnemyCastBar_LockPos() --lockpos
	
	CEnemyCastBar.bLocked = not CEnemyCastBar.bLocked;
	
	if (CEnemyCastBar.bLocked) then
	
		for i=1, 20 do
	
			local frame = getglobal("Carni_ECB_"..i);
			local fauxframe = getglobal("FauxTargetBtn"..i);
			frame:StopMovingOrSizing();
			frame:EnableMouse(0);
			if (CEnemyCastBar.bMouseBar) then
				fauxframe:EnableMouse(1);
			else
				fauxframe:EnableMouse(0);
			end
		end

	else
	
		for i=1, 20 do
	
			local frame = getglobal("Carni_ECB_"..i);
			local fauxframe = getglobal("FauxTargetBtn"..i);
			frame:EnableMouse(1);
			fauxframe:EnableMouse(0);
			
		end	

	end
	
end

function CEnemyCastBar_ResetPos() --resetpos

	local frame = getglobal("Carni_ECB_1");
	local fauxframe = getglobal("FauxTargetBtn1");
	frame:Hide();
	fauxframe:Hide();
	frame:ClearAllPoints();
	frame:SetPoint("TOPLEFT", "UIParent", 50, -500);

	CEnemyCastBar_FlipBars();
end

function CEnemyCastBar_FlipBars() --flipbars; sets the SPACE, ICONSIZE and BarLength, too! Called when variables loaded

	for i=2, 21 do
	
		local o = i - 1;
		if (i <= 20) then
			local frame = getglobal("Carni_ECB_"..i);
			local fauxframe = getglobal("FauxTargetBtn"..i);
	
			if (CEnemyCastBar.bFlipB) then
				frame:SetPoint("TOPLEFT", "Carni_ECB_"..o, "TOPLEFT", 0, -CEnemyCastBar.bSpace);
			else
				frame:SetPoint("TOPLEFT", "Carni_ECB_"..o, "TOPLEFT", 0, CEnemyCastBar.bSpace);
			end
		end
		local buttonicon = getglobal("Carni_ECB_"..o.."_Icon");
		buttonicon:SetHeight(CEnemyCastBar.bSpace);
		buttonicon:SetWidth(CEnemyCastBar.bSpace);
		buttonicon:SetPoint("LEFT", "Carni_ECB_"..o, "LEFT", -CEnemyCastBar.bSpace + 4, 5);

		-- set bar length
		getglobal("Carni_ECB_"..o):SetWidth(206 + CEnemyCastBar.bnecbCBLBias);
		getglobal("Carni_ECB_"..o.."_Text"):SetWidth(185 + CEnemyCastBar.bnecbCBLBias);
		getglobal("Carni_ECB_"..o.."_Border"):SetWidth(205 + CEnemyCastBar.bnecbCBLBias);
		getglobal("Carni_ECB_"..o.."_StatusBar"):SetWidth(195 + CEnemyCastBar.bnecbCBLBias);
		getglobal("FauxTargetBtn"..o):SetWidth(205 + CEnemyCastBar.bnecbCBLBias);
		getglobal("Carni_ECB_"..o.."_CastTimeText"):SetPoint("LEFT", getglobal("Carni_ECB_"..o), "LEFT", 202 + CEnemyCastBar.bnecbCBLBias, 6);
		
	end

end

function CEnemyCastBar_SetTextSize() --settextsize, called when variables loaded

	for i=1, 20 do
		local buttontext = getglobal("Carni_ECB_"..i.."_Text");
		local buttonttext = getglobal("Carni_ECB_"..i.."_CastTimeText");
		if (CEnemyCastBar.bSmallTSize) then
			buttontext:SetFontObject(GameFontHighlightSmall);
			buttonttext:SetFontObject(GameFontHighlightSmall);
		else
			buttontext:SetFontObject(GameFontHighlight);
			buttonttext:SetFontObject(GameFontHighlight);
		end
	end
end

function CEnemyCastBar_SetBorder() --called when variables loaded

	for i=1, 20 do
		local border = getglobal("Carni_ECB_"..i.."_Border");
		if (CEnemyCastBar.bDisBorder) then
			border:Hide();
			CECB_FPSBarFree_Border:Hide(); --fps bar
		else
			border:Show();
			CECB_FPSBarFree_Border:Show(); --fps bar
		end
	end
end

function CEnemyCastBar_SetIcon() --called when variables loaded

	for i=1, 20 do
		local icon = getglobal("Carni_ECB_"..i.."_Icon");
		if (CEnemyCastBar.bShowIcon) then
			icon:Show();
		else
			icon:Hide();
		end
	end
end

function CEnemyCastBar_SetTexture(value) --called when variables loaded

	for i=1, 20 do
		local statusbar = getglobal("Carni_ECB_"..i.."_StatusBar");
			statusbar:SetStatusBarTexture("Interface\\AddOns\\CEnemyCastBar\\Images\\bartex"..value);
	end
	CECB_FPSBarFree_StatusBar:SetStatusBarTexture("Interface\\AddOns\\CEnemyCastBar\\Images\\bartex"..value); --fps bar
end

function CEnemyCastBar_Boolean(var)

	if (var) then
		return "on";	
	else
		return "off";
	end
end

function CEnemyCastBar_Handler(msg) --Handler

	if (msg == "help" or msg == "?") then

		if (CECBHELPFrame:IsVisible() and CECBHELPFrameText:GetText() == "NECB - HELP" ) then
			CECBHELPFrame:Hide();
		else
			CECBHELPFrameScrollFrameBGText:SetText("|cffffff00Natur EnemyCastBar |cffcccc00("..CECB_status_version_txt..")|cffffff00:|cffff0000 /necb help\n\n" .. table.concat (CEnemyCastBarHelp, "") );
			CECBHELPFrame:SetHeight(465);
			CECBHELPFrameScrollFrame:SetHeight(CECBHELPFrame:GetHeight() - 45);
			CECBHELPFrameScrollFrameBorder:SetHeight(CECBHELPFrameScrollFrame:GetHeight() - 28);
			CECBHELPFrameScrollFrameBG:SetHeight(550);
			CECBHELPFrameScrollFrameBGText:SetHeight(CECBHELPFrameScrollFrameBG:GetHeight() - 10);
			CECBHELPFrameScrollFrame:UpdateScrollChildRect();

			if (GetCurrentResolution() == 1) then
				CECBHELPFrameScrollFrameBG:SetHeight(CECBHELPFrameScrollFrameBG:GetHeight() + 50);
				CECBHELPFrameScrollFrameBGText:SetHeight(CECBHELPFrameScrollFrameBGText:GetHeight() + 50);
			end

			CECBHELPFrameText:SetText("NECB - HELP");
			CECBHELPFrame:Show();
			CECBHELPFrameWhisper:Hide();
		end


	elseif (msg == "" or msg == nil) then

		local loaded, reason = LoadAddOn("CECB_Options");
		if (loaded) then

			if (CECBOptionsFrame:IsVisible()) then
				necbfademenue = 1;
			else
				CECBOptionsFrame:SetAlpha(0);
				necbfademenue = 2;
				CECB_ShowHideOptionsUI();
			end
		else
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00'CECB_Options' |rAddOn |cffff9999can not be loaded! |rReason: |cffff0000"..reason)
		end

	elseif (msg == "gcinfo") then

		if (CECBGCFrame:IsVisible()) then
			CECBGCFrame:Hide();
			cecbgc_last = nil;
		else
			CECBGCFrame:Show();
			collectgarbage("collect"); --BC
		end

	-- see "printversions" in OPTIONS part!
	elseif (msg == "versions") then

		if (CEnemyCastBar.bStatus) then

			if (CEnemyCastBar.bParseC and (GetNumRaidMembers() ~= 0 or GetNumPartyMembers() ~= 0 or GetNumBattlefieldStats() > 1) ) then
				CECBHELPFrameScrollFrameBGText:SetText("|cffffff00Natur EnemyCastBar |cffcccc00("..CECB_status_version_txt..")|cffffff00:|cffff0000 /necb versions\n\n|cffaaaaaaNECB: |cffffff00Requesting Versions from Raidmembers! |cffff0000Please wait...");
				
				CECBHELPFrameText:SetText("NECB - VERSIONS");

				CECBHELPFrame:SetHeight(165);
				CECBHELPFrameScrollFrame:SetHeight(CECBHELPFrame:GetHeight() - 45);
				CECBHELPFrameScrollFrameBorder:SetHeight(CECBHELPFrameScrollFrame:GetHeight() - 28);
				CECBHELPFrameScrollFrameBG:SetHeight(120);
				CECBHELPFrameScrollFrameBGText:SetHeight(CECBHELPFrameScrollFrameBG:GetHeight() - 10);
				CECBHELPFrameScrollFrame:UpdateScrollChildRect();
				CECBHELPFrame:Show();
	
				NECB_SendMessage("<NECB> Force version collection.");
	
			else
				if (not CEnemyCastBar.bParseC) then
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to enable NECB's channel parsing to use this!")
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a Group to use this command!")
				end
			end

		else
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Enable NECB to use this feature!")

		end

	-- see "printversions" in OPTIONS part!
	elseif (msg == "gversions") then

		if (CEnemyCastBar.bStatus) then

			if (CEnemyCastBar.bParseC and IsInGuild() ) then
				CECBHELPFrameScrollFrameBGText:SetText("|cffffff00Natur EnemyCastBar |cffcccc00("..CECB_status_version_txt..")|cffffff00:|cffff0000 /necb gversions\n\n|cffaaaaaaNECB: |cffffff00Requesting Versions from Guildmembers! |cffff0000Please wait...");
				
				CECBHELPFrameText:SetText("NECB - GVERSIONS");
				CECBHELPFrame:SetHeight(165);
				CECBHELPFrameScrollFrame:SetHeight(CECBHELPFrame:GetHeight() - 45);
				CECBHELPFrameScrollFrameBorder:SetHeight(CECBHELPFrameScrollFrame:GetHeight() - 28);
				CECBHELPFrameScrollFrameBG:SetHeight(120);
				CECBHELPFrameScrollFrameBGText:SetHeight(CECBHELPFrameScrollFrameBG:GetHeight() - 10);
				CECBHELPFrameScrollFrame:UpdateScrollChildRect();
				CECBHELPFrame:Show();
	
				NECB_SendMessage("<NECB> Force gversion collection.", nil, "toguild");
	
			else
				if (not CEnemyCastBar.bParseC) then
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to enable NECB's channel parsing to use this!")
				else
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a Guild to use this command!")
				end
			end

		else
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Enable NECB to use this feature!")

		end

	elseif (msg == "parser") then

		if (CECBParser) then
	
			CECBParser = false;
			CECBCTRAParserFrame:Hide();
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Broadcast Parser |cffff9999disabled")
	
		else
		
			CECBParser = true;
				CEnemyCastBar_ParserOnClick(0);
			CECBCTRAParserFrame:Show();
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Broadcast Parser |cff99ff99temporary enabled")
		
		end

	elseif (msg == "clear") then		

		lockshow = 0;

			if (not CEnemyCastBar.bLocked) then

				CEnemyCastBar_LockPos();
				
			end

		for i=1, 20 do
	
			CEnemyCastBar_HideBar(i);
			
		end

	elseif (msg == "restore") then		

		local i = 1;
		while (i <= #NECBDisabledSpells) do
			local spell = NECBDisabledSpells[i];

			if (CEnemyCastBar_Raids[spell]) then
				CEnemyCastBar_Raids[spell].disabled = nil;
			end
	
			if (CEnemyCastBar_Spells[spell]) then
				CEnemyCastBar_Spells[spell].disabled = nil;
			end
	
			if (CEnemyCastBar_Afflictions[spell]) then
				CEnemyCastBar_Afflictions[spell].disabled = nil;
			end

			i = i + 1;
		end			

		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Restored (|cffffff00".. #NECBDisabledSpells .."|r) spells which were disabled by Shift + RightClick");
		NECBDisabledSpells = { };

	elseif (msg == "disabled") then

		local DSpells = "";
		local SpellsTotal = #NECBDisabledSpells;
		
		if (SpellsTotal == 0) then
			DSpells = "-.-";
		else
			for i=1, SpellsTotal do
				DSpells = DSpells .. table.concat (NECBDisabledSpells, "", i, i) .. " |cffffffff(|r" .. i .. "|cffffffff)";
				if (i < SpellsTotal ) then
					DSpells = DSpells .. "|cffff0000 | |r";
				end
			end
		end
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffffff Disabled Spells: |r"..DSpells, 1, 1, 0);

	elseif (msg == "cooldowns") then

		local DSpells = "";
		local SpellsTotal = #NECB_CD_DB;
		
		if (SpellsTotal == 0) then
			DSpells = "-.-";
		else
			for i=1, SpellsTotal do
				local CDLeft = floor (NECB_CD_DB[i][3] + NECB_CD_DB[i][4] - GetTime() );
				if ( CDLeft < 0 ) then
					CDLeft = 0;
				end
				DSpells = DSpells .. NECB_CD_DB[i][1] .. "|cffffffff - |r" .. NECB_CD_DB[i][2] .. " |cffffffff(|r" .. CDLeft .. "|cffffffff)|r";
				if (i < SpellsTotal ) then
					DSpells = DSpells .. "|cffff0000 | |r";
				end
			end
		end
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffffff Cooldowns: |r"..DSpells, 1, 1, 0);

	elseif (string.sub (msg, 1, 4) == "add " and CEnemyCastBar.bStatus) then

		local msg1 = string.sub (msg, 5, string.len(msg) );
		CEnemyCastBar_HideBar(nil, nil, msg1); -- Hidebar also used for disabled spell commands! Shift + Rightclick...

	elseif (msg == "save") then

		CEnemyCastBar.tNECBDisabledSpells = { };

		local i = 1;
		while (NECBDisabledSpells[i]) do
			table.insert (CEnemyCastBar.tNECBDisabledSpells, NECBDisabledSpells[i]);
			i = i + 1;
		end

		if (#NECBDisabledSpells == 0) then
			DSpells = "Nothing disabled! |rEmpty table saved.";
		else
			i = i - 1;
			DSpells = i.." |rDisabled Spells saved.";
		end
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffff00 "..DSpells);

	elseif (msg == "load") then

		CEnemyCastBar_LoadNECBDisabledSpells();

	elseif (string.sub (msg, 1, 7) == "remove " and CEnemyCastBar.bStatus) then

		local msg1 = string.sub (msg, 8, string.len(msg) );
		local spellfound = false;

		local i = 1;
		while NECBDisabledSpells[i] do

			if (string.lower(NECBDisabledSpells[i]) == string.lower(msg1) or ( tonumber(msg1) and NECBDisabledSpells[tonumber(msg1)] ) ) then

					local spell;
					if (tonumber(msg1) and NECBDisabledSpells[tonumber(msg1)] ) then
						i = tonumber(msg1);
					end

					spell = NECBDisabledSpells[i];

					if (CEnemyCastBar_Raids[spell]) then
						CEnemyCastBar_Raids[spell].disabled = nil;
					end
			
					if (CEnemyCastBar_Spells[spell]) then
						CEnemyCastBar_Spells[spell].disabled = nil;
					end
			
					if (CEnemyCastBar_Afflictions[spell]) then
						CEnemyCastBar_Afflictions[spell].disabled = nil;
					end

				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffffff Restored Spell: |r".. table.concat (NECBDisabledSpells, "", i, i), 1, 1, 0);
				table.remove (NECBDisabledSpells, i);
				spellfound = true;
				break;
			end
			i = i + 1;
		end

		if (not spellfound) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffaaaa Spell not found!");
		end

	elseif (string.sub (msg, 1, 7) == "forcebc" and CEnemyCastBar.bStatus) then

		local msg1 = string.sub (msg, 9, string.len(msg) );

		if (msg1 == "") then
			msg1 = UnitName("target");
		end

		if (msg1 == nil) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999No name specified and no target selected!")

		elseif (CEnemyCastBar_CheckRaidStatus( UnitName("player") ) == false ) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be leader or promoted to do this!")

		elseif (CEnemyCastBar_CheckRaidStatus( msg1 ) == nil ) then
			if (UnitInRaid("player") ) then
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999The name/target you selected is not found in your raid!")
			else
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a RaidGroup!")
			end

		else
			NECB_SendMessage("<NECB> FORCE "..msg1.." to Broadcast! Change Settings!");
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |rForced |cffffff00"..msg1.." |rto broadcast!")
		end

	elseif (string.sub (msg, 1, 6) == "stopbc" and CEnemyCastBar.bStatus) then

		local msg1 = string.sub (msg, 8, string.len(msg) );

		if (msg1 == "") then
			msg1 = UnitName("target");
		end

		if (msg1 == nil) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999No name specified and no target selected!")

		elseif (CEnemyCastBar_CheckRaidStatus( UnitName("player") ) == false ) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be leader or promoted to do this!")

		elseif (CEnemyCastBar_CheckRaidStatus( msg1 ) == nil ) then
			if (UnitInRaid("player") ) then
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999The name/target you selected is not found in your raid!")
			else
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a RaidGroup!")
			end

		else
			NECB_SendMessage("<NECB> STOP "..msg1.." to Broadcast! Change Settings!");
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |rStopped broadcasts of |cffffff00"..msg1.." |r!")
		end

	elseif (string.sub (msg, 1, 9) == "countsec " and CEnemyCastBar.bStatus) then

		local msg1 = tonumber (string.sub (msg, 10, 12));

		local textlen = string.len (msg);
		local textinput = string.sub (msg, 10, textlen);
		local firstspace = string.find (textinput, " ");
		local msg2;
		if (firstspace and textlen >= (firstspace + 10)) then
			msg2 = string.sub (msg, firstspace + 10, textlen);
			if ((firstspace +8) <= 12) then
				msg1 = tonumber (string.sub (msg, 10, firstspace + 8));
			end
		end

		if (msg1) then

			if (msg1 < 0) then
	
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Invalid value to start the countdown!")
		
			else
		
				if (msg2 == nil) then msg2 = "Countdown";
				end
	
				if ( CEnemyCastBar_UniqueCheck(msg2, msg1, "("..msg1.." Seconds)") == 0 ) then
					CEnemyCastBar_Show("("..msg1.." Seconds)", msg2, msg1, "grey", nil, "INV_Misc_Bomb_03.blp");
				end

			end

		end

	elseif (string.sub (msg, 1, 9) == "countmin " and CEnemyCastBar.bStatus) then

		local msg1 = tonumber (string.sub (msg, 10, 12));

		local textlen = string.len (msg);
		local textinput = string.sub (msg, 10, textlen);
		local firstspace = string.find (textinput, " ");
		local msg2;
		if (firstspace and textlen >= (firstspace + 10)) then
			msg2 = string.sub (msg, firstspace + 10, textlen);
			if ((firstspace +8) <= 12) then
				msg1 = tonumber (string.sub (msg, 10, firstspace + 8));
			end
		end

		if (msg1) then

			if (msg1 * 60 < 0) then
	
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Invalid value to start the countdown!")
	
			else
			
				if (msg2 == nil) then msg2 = "Countdown";
				end
	
				if ( CEnemyCastBar_UniqueCheck(msg2, msg1 * 60, "("..msg1.." Minutes)") == 0 ) then
					CEnemyCastBar_Show("("..msg1.." Minutes)", msg2, msg1 * 60, "grey", nil, "INV_Misc_Bomb_03.blp");
				end
				
	
			end

		end
		
	elseif (string.sub (msg, 1, 7) == "repeat " and CEnemyCastBar.bStatus) then

		local msg1 = tonumber (string.sub (msg, 8, 10));

		local textlen = string.len (msg);
		local textinput = string.sub (msg, 8, textlen);
		local firstspace = string.find (textinput, " ");
		local msg2;
		if (firstspace and textlen >= (firstspace + 8)) then
			msg2 = string.sub (msg, firstspace + 8, textlen);
			if ((firstspace +6) <= 10) then
				msg1 = tonumber (string.sub (msg, 8, firstspace + 6));
			end
		end

		if (msg1) then

			if (msg1 < 0) then
	
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Invalid value to start the repeater!")

			else

				if (msg2 == nil) then msg2 = "Repeater";
				else msg2 = "Repeater: "..msg2;
				end
				if ( CEnemyCastBar_UniqueCheck(msg2, msg1, "("..msg1.." Seconds)") == 0 ) then
					CEnemyCastBar_Show("("..msg1.." Seconds)", msg2, msg1, "grey", nil, "INV_Misc_Bomb_04.blp");
				end
					
			end

		end
		
	elseif (string.sub (msg, 1, 10) == "stopcount " and CEnemyCastBar.bStatus) then

		local msg1;
		local textlen = string.len (msg);
		if (textlen >= 11) then
			msg1 = string.sub (msg, 11, textlen);
		end

		if (msg1) then

			if (msg1 == "all") then msg1 = " ";
			end

			for i=1, CEnemyCastBar.bNumBars do
			
				local label = getglobal("Carni_ECB_"..i).label;

				if (label and string.find (label, msg1) and getglobal("Carni_ECB_"..i).ctype == "grey" ) then
						CEnemyCastBar_HideBar(i);
				end
			end
		end

	elseif (string.sub (msg, 1, 10) == "deletebar " and CEnemyCastBar.bStatus) then

		local msg1;
		local textlen = string.len (msg);
		if (textlen >= 11) then
			msg1 = string.sub (msg, 11, textlen);
		end

		if (msg1) then

			if (msg1 == "all") then msg1 = " ";
			end

			for i=1, CEnemyCastBar.bNumBars do
			
				local label = getglobal("Carni_ECB_"..i).label;
				local mob = getglobal("Carni_ECB_"..i).mob;
				--local r,g,b = getglobal("Carni_ECB_"..i.."_StatusBar"):GetStatusBarColor(); -- to delete specific colored bar
				--and ceil(r*10) == ceil(CEnemyCastBar.tColor[8][1]*10) and ceil(g*10) == ceil(CEnemyCastBar.tColor[8][2]*10) and ceil(b*10) == ceil(CEnemyCastBar.tColor[8][3]*10)

				if (label and string.find(label, msg1) and mob == UnitName("target") ) then
						CEnemyCastBar_HideBar(i);
				end
			end

		end

	elseif (string.sub (msg, 1, 8) == "showbar " and CEnemyCastBar.bStatus) then
	
		local spell;
		local textlen = string.len (msg);
		if (textlen >= 9) then
			spell = string.sub (msg, 9, textlen);
		end

		local mob = UnitName("target");
		if (not mob) then
			return;
		end

		if (CEnemyCastBar_Afflictions[spell]) then
			if (not UnitIsFriend("player", "target") ) then
				if (CEnemyCastBar_Afflictions[spell].periodicdmg) then
					CEnemyCastBar_Control(mob, spell, "periodicdmg", nil, "customdot");
				else
					CEnemyCastBar_Control(mob, spell, "afflicted");
				end
			end

		elseif (CEnemyCastBar_Spells[spell]) then
			if (UnitIsFriend("player", "target") ) then
				CEnemyCastBar_Control(mob, spell, "gains");
			end

		end

	elseif (string.sub (msg, 1, 5) == "cast " and CEnemyCastBar.bStatus) then
	
		local spell;
		local textlen = string.len (msg);
		if (textlen >= 6) then
			spell = string.sub (msg, 6, textlen);
		end

		--NECBCustomCasted = true;
		--CastSpellByName(spell); -- fires "CHAT_MSG_SPELL_FAILED_LOCALPLAYER" very fast on most errors which will set NECBCustomCasted = nil;
		-- for BC use this macro and comment out two lines above!:
		-- /script NECBCustomCasted = true;
		-- /cast SpellName
		-- /necb cast SpellName
		if (NECBCustomCasted) then
			CEnemyCastBar_Handler("showbar "..spell);
		end

	elseif (msg == "combatlog") then

		if (necbprint2combat) then
	
			necbprint2combat = nil;
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Also write parser messages to combatlog |cffff9999disabled")
		
		else
		
			necbprint2combat = true;
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Also write parser messages to combatlog |cff99ff99enabled")

		end
	
	elseif (string.sub (msg, 1, 5) == "chat " and CEnemyCastBar.bStatus) then

		if (GetNumPartyMembers() ~= 0 or GetNumRaidMembers() ~= 0 ) then
			local text;
			local textlen = string.len (msg);
			if (textlen >= 6) then
				text = string.sub (msg, 6, textlen);
			end
			
			NECB_SendMessage(text, "CHAT");

		else 
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a Group to use NECB's Chat!")
		end

	elseif ((string.sub (msg, 1, 9) == "setrange " or msg == "setrange") and CEnemyCastBar.bStatus) then

		local text;
		local textlen = string.len (msg);
		if (textlen >= 10) then
			text = string.sub (msg, 10, textlen);
		end
		-- "allmax", "cmax", nil for defaults
		CEnemyCastBar_SetRange(text);

	elseif (msg == "wipe") then

		if (GetNumRaidMembers() ~= 0) then
			if (CEnemyCastBar_CheckRaidStatus( UnitName("player") ) == false ) then
				DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be leader or promoted to do this!")
			else
				CEnemyCastBar_BHWipe();
				NECB_SendMessage("<NECB> Play Benny Hill for us!");
			end

		else
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999You have to be in a RaidGroup!")
		end

	elseif (msg == "debug") then

		if (CEnemyCastBar.bDebug) then
	
			CEnemyCastBar.bDebug = false;
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r DebugMode |cffffff99disabled")
		
		else
		
			CEnemyCastBar.bDebug = true;
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r DebugMode |cffffff99enabled")

		end

	end
end


-- Internal Handler -----------------------
function CEnemyCastBar_InternalHandler(msg) --Internal

	if (msg == "printversions") then

		local NECBVersionDBTemp = { };

		if (NECBVersionDB and NECBVersionDB[1]) then
			for i=1, #NECBVersionDB do
				NECBVersionDB[i] = string.gsub (NECBVersionDB[i], "BC5.6.0", "5.6.0"); -- fix for old BC5.6.0 version transmits
				table.insert (NECBVersionDBTemp, "|cffaaaaaaNECB: |rVersion |cff00ff00"..NECBVersionDB[i].."|r is used by "..NECBVersionNames[i]..".");
				NECBVersionDBTemp[i] = string.gsub (NECBVersionDBTemp[i], ", BCASTER", "");
			end


			table.sort (NECBVersionDBTemp);
			local counter, vcounter = 1, 1;
			while NECBVersionDBTemp[counter] do

				local o = counter + 1;
				if (NECBVersionDBTemp[o]) then
					local nextversion = string.match (NECBVersionDBTemp[o], "Version (.+) is used")
					local thisversion = string.match (NECBVersionDBTemp[counter], "Version (.+) is used")
	
					if (nextversion and thisversion and nextversion == thisversion) then
						local nextname = string.match (NECBVersionDBTemp[o], "is used by (.+).")
						table.remove (NECBVersionDBTemp, o);
						NECBVersionDBTemp[counter] = string.sub (NECBVersionDBTemp[counter], 1, string.len( NECBVersionDBTemp[counter] ) - 1 ) .. ", " ..nextname ..".";
						--DEFAULT_CHAT_FRAME:AddMessage("1)"..counter.." - "..NECBVersionDBTemp[counter]);
						counter = counter - 1;
						vcounter = vcounter + 1;

					else
						if (vcounter > 1) then
							NECBVersionDBTemp[counter] = NECBVersionDBTemp[counter] .. " (|cff00ff00" ..vcounter.. "|r Users)";
						end
						vcounter = 1;
						--DEFAULT_CHAT_FRAME:AddMessage("2)"..counter.." - "..NECBVersionDBTemp[counter]);
					end
	
				else
					if (vcounter > 1 and NECBVersionDBTemp[counter]) then
						NECBVersionDBTemp[counter] = NECBVersionDBTemp[counter] .. " (|cff00ff00" ..vcounter.. "|r Users)";
					end
						--DEFAULT_CHAT_FRAME:AddMessage("3)"..counter);
	
				end
				counter = counter + 1;	
			end
	
			CECBHELPFrameScrollFrameBGText:SetText("|cffffff00Natur EnemyCastBar |cffcccc00("..CECB_status_version_txt..")|cffffff00:|cffff0000 /necb (g)versions\n\n|cffaaaaaaNECB: |cffffff00Client versions which answered (|cff9999ffblue|cffffff00 = broadcaster):\n\n");
			local necblinebreak = 0;

			for i=#NECBVersionDBTemp, 1, -1 do
				CECBHELPFrameScrollFrameBGText:SetText(CECBHELPFrameScrollFrameBGText:GetText()..NECBVersionDBTemp[i].."\n" );
				CECBParserFauxText:SetText(NECBVersionDBTemp[i]);
				if (CECBParserFauxText:GetStringWidth() > 420) then
					--DEFAULT_CHAT_FRAME:AddMessage(i.." "..CECBParserFauxText:GetStringWidth());
					necblinebreak = necblinebreak + floor(CECBParserFauxText:GetStringWidth() / 420);
				end

			end

			-- recolor
			for i=1, #NECBVersionDB do
				local necbbccolor = "|cffcccc00";
				if (string.find(NECBVersionDB[i], ", BCASTER") ) then
					necbbccolor = "|cff9999ff";
				end
				CECBHELPFrameScrollFrameBGText:SetText(string.gsub(CECBHELPFrameScrollFrameBGText:GetText(), NECBVersionNames[i].."", necbbccolor..NECBVersionNames[i].."|r") );
			end

			local necbpixellines = (#NECBVersionDBTemp + necblinebreak ) *10;
			--CECBHELPFrameText:SetText("NECB - VERSIONS");
			if (necbpixellines > 60) then
				necbpixellines = necbpixellines - 60;
				CECBHELPFrameScrollFrameBG:SetHeight(110 + necbpixellines);
				CECBHELPFrameScrollFrameBGText:SetHeight(CECBHELPFrameScrollFrameBG:GetHeight() - 10);
				CECBHELPFrameScrollFrame:UpdateScrollChildRect();
			end
			--CECBHELPFrame:Show();
			if (#NECBVersionDBTemp > 1) then
				CECBHELPFrameWhisper:Show();
			end

		else
			CECBHELPFrameScrollFrameBGText:SetText("|cffffff00Natur EnemyCastBar |cffcccc00("..CECB_status_version_txt..")|cffffff00:|cffff0000 /necb (g)versions\n\n|cffaaaaaaNECB: |cffff0000Unknown error! No data found :/");
		end

	elseif (msg == "WhisperToObsolete") then

		local NECBVersionDBTemp = { };
		for i=1, #NECBVersionDB do
			table.insert (NECBVersionDBTemp, NECBVersionDB[i]);
			NECBVersionDBTemp[i] = string.gsub (NECBVersionDBTemp[i], ", BCASTER", "");
		end

		local necb_newest = " ";
		local necb_whispered;
		for i=1, #NECBVersionDBTemp do
			local necb_checked = string.sub( NECBVersionDBTemp[i], 1, string.len(NECBVersionDBTemp[i]) - 6 );
			if ( necb_checked > necb_newest) then
				necb_newest = necb_checked;
			end
		end

		for i=1, #NECBVersionDBTemp do
			local necb_checked = string.sub( NECBVersionDBTemp[i], 1, string.len(NECBVersionDBTemp[i]) - 6 );
			if ( necb_checked < necb_newest and NECBVersionNames[i] ~= UnitName("player") ) then
				if (not necb_whispered) then
					NECB_SendMessage("<NECB> Whisper old versions of NECB to update!");
				end
				SendChatMessage("*** NECB: Your version ("..necb_checked..") is outdated! Update to the newest detected version ("..necb_newest..") please! ***", "WHISPER", nil, NECBVersionNames[i]);
				necb_whispered = true;
			end
		end

		if (CECB_status_version_txt < necb_newest) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00Your own version is out of date!")

		elseif (not necb_whispered) then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Noone is using an outdated version!")
		end

	end
end

function CEnemyCastBar_CheckRaidStatus(checkplayer) -- check players raidstatus, leader or promoted -> 1,2 else false or nil

	local plrank, plfileName;
	for i = 1, GetNumRaidMembers() do
		if ( UnitName("raid" .. i) == checkplayer ) then
			_, plrank, _, _, _, plfileName = GetRaidRosterInfo(i);
			break;
		end
	end

	if (plrank == 0) then
		plrank = false;
	end

	return plrank, plfileName;

end

function CEnemyCastBar_BHWipe(author) --wipe sound

	if (not author or (author ~= UnitName("player") and CEnemyCastBar_CheckRaidStatus(author)) ) then
		PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\BennyHill.wav");
	end

end

function CEnemyCastBar_Show(mob, spell, castime, ctype, turnlabel, icontexture, starttime, DRText) --Show

 if (lockshow ~= 1) then

	-- new magic sorting routine, don't ask me how it works ;P coded while in delirium
	local findctype, foundspace, firstused;
	for i=CEnemyCastBar.bNumBars, 1, -1 do
		if (not getglobal("Carni_ECB_"..i):IsVisible() ) then
			foundspace = true;
		elseif (not firstused) then
			firstused = i;
		end
		if (foundspace and getglobal("Carni_ECB_"..i).ctype == ctype) then
			findctype = i;
			break;
		end
	end

	-- lets push the bars up to insert a new one
	if (foundspace and findctype) then

		for i=CEnemyCastBar.bNumBars-1, findctype+1, -1 do
	
			local CECname = getglobal("Carni_ECB_"..i);
			local CECno = i;
			local fauxbtn = getglobal("FauxTargetBtn"..CECno);
		
			local CECpre = CECno + 1;
			local cecbuttonpre = getglobal("Carni_ECB_"..CECpre);
		
			if (not cecbuttonpre:IsShown() and CECname:IsShown() ) then
		
				cecbuttonpre.startTime = CECname.startTime
				cecbuttonpre.label = CECname.label;
		
				local r,g,b = getglobal("Carni_ECB_"..CECno.."_Text"):GetShadowColor();
				getglobal("Carni_ECB_"..CECpre.."_Text"):SetShadowColor(r,g,b);
		
				if (getglobal("Carni_ECB_"..CECno.."_Icon"):IsShown()) then
					getglobal("Carni_ECB_"..CECpre.."_Icon"):SetTexture(getglobal("Carni_ECB_"..CECno.."_Icon"):GetTexture());
					getglobal("Carni_ECB_"..CECpre.."_Icon"):Show();
				end
		
				cecbuttonpre.spell = CECname.spell;
				cecbuttonpre.mob = CECname.mob;
				cecbuttonpre.ctype = CECname.ctype;
				cecbuttonpre.endTime = CECname.endTime;
				getglobal("Carni_ECB_"..CECpre.."_StatusBar"):SetMinMaxValues(getglobal("Carni_ECB_"..CECno.."_StatusBar"):GetMinMaxValues());
				getglobal("Carni_ECB_"..CECpre.."_StatusBar"):SetValue(getglobal("Carni_ECB_"..CECno.."_StatusBar"):GetValue());
				getglobal("Carni_ECB_"..CECpre.."_StatusBar"):SetStatusBarColor(getglobal("Carni_ECB_"..CECno.."_StatusBar"):GetStatusBarColor());
				getglobal("FauxTargetBtn"..CECpre):Show();
				cecbuttonpre:SetAlpha(CEnemyCastBar.bAlpha);
				cecbuttonpre:Show();
		
				CEnemyCastBar_HideBar(CECno);
			end
		end

	end

	-- prepare to fire the bar into the right position
	local i;
	if (findctype) then
		i = findctype+1;
	elseif (firstused and firstused < CEnemyCastBar.bNumBars) then
		i = firstused+1;
	elseif (firstused and firstused == CEnemyCastBar.bNumBars) then
		i = CEnemyCastBar.bNumBars; -- will call the red barrier (is a visible button)
	else
		i = 1;
	end

	--for i=1, CEnemyCastBar.bNumBars do --old code, unsorted
	
		local button = getglobal("Carni_ECB_"..i);
		local fauxbutton = getglobal("FauxTargetBtn"..i);
		local red, green, blue = 0, 0, 0;
	
		if (not button:IsVisible()) then
		
			if (ctype == "hostile") then
			
				red = CEnemyCastBar.tColor[1][1];
				green = CEnemyCastBar.tColor[1][2];
				blue = CEnemyCastBar.tColor[1][3];					
			
			elseif (ctype == "friendly") then
			
				red = CEnemyCastBar.tColor[2][1];
				green = CEnemyCastBar.tColor[2][2];
				blue = CEnemyCastBar.tColor[2][3];
				
			elseif (ctype == "cooldown") then
			
				red = CEnemyCastBar.tColor[3][1];
				green = CEnemyCastBar.tColor[3][2];
				blue = CEnemyCastBar.tColor[3][3];	
			
			elseif (ctype == "gains") then
				red = CEnemyCastBar.tColor[4][1];
				green = CEnemyCastBar.tColor[4][2];
				blue = CEnemyCastBar.tColor[4][3];

			elseif (ctype == "grey") then
				red = CEnemyCastBar.tColor[5][1];
				green = CEnemyCastBar.tColor[5][2];
				blue = CEnemyCastBar.tColor[5][3];

			elseif (ctype == "afflict") then

				red = CEnemyCastBar.tColor[6][1];
				green = CEnemyCastBar.tColor[6][2];
				blue = CEnemyCastBar.tColor[6][3];

			elseif (ctype == "stuns") then

				red = CEnemyCastBar.tColor[7][1];
				green = CEnemyCastBar.tColor[7][2];
				blue = CEnemyCastBar.tColor[7][3];

			elseif (ctype == "cursetype") then

				red = CEnemyCastBar.tColor[8][1];
				green = CEnemyCastBar.tColor[8][2];
				blue = CEnemyCastBar.tColor[8][3];
			
			end

			if (tonumber(starttime)) then
				getglobal("Carni_ECB_"..i).startTime = starttime;
			else
				getglobal("Carni_ECB_"..i).startTime = GetTime();
			end

			if (turnlabel) then
				if (DRText) then
					getglobal("Carni_ECB_"..i).label = mob.." - "..spell .." "..DRText;
				else
					getglobal("Carni_ECB_"..i).label = mob .." - ".. spell;
				end
			else
				if (DRText) then
					getglobal("Carni_ECB_"..i).label = spell .." "..DRText.." - ".. mob;
				else
					getglobal("Carni_ECB_"..i).label = spell .." - ".. mob;
				end
			end

			if (mob == UnitName("player") ) then
				getglobal("Carni_ECB_"..i.."_Text"):SetShadowColor(1,0,0);
			elseif (starttime == "unkown spell") then
				getglobal("Carni_ECB_"..i.."_Text"):SetShadowColor(0, 0.5, 0);
			elseif (turnlabel) then
				getglobal("Carni_ECB_"..i.."_Text"):SetShadowColor(0,0,1);
			else
				getglobal("Carni_ECB_"..i.."_Text"):SetShadowColor(0,0,0);
			end

			if (CEnemyCastBar.bShowIcon) then
				if (not icontexture or icontexture == "") then
					icontexture = "INV_Misc_QuestionMark";
				end
				getglobal("Carni_ECB_"..i.."_Icon"):SetTexture("Interface\\Icons\\"..icontexture);
				getglobal("Carni_ECB_"..i.."_Icon"):Show();
			else
				getglobal("Carni_ECB_"..i.."_Icon"):Hide();
			end

			getglobal("Carni_ECB_"..i).spell = spell;
			getglobal("Carni_ECB_"..i).mob = mob;
			getglobal("Carni_ECB_"..i).ctype = ctype;
			getglobal("Carni_ECB_"..i).endTime = getglobal("Carni_ECB_"..i).startTime + castime;
			getglobal("Carni_ECB_"..i.."_StatusBar"):SetMinMaxValues(button.startTime,button.endTime);
			getglobal("Carni_ECB_"..i.."_StatusBar"):SetValue(button.startTime);
			getglobal("Carni_ECB_"..i.."_StatusBar"):SetStatusBarColor(red, green, blue);
			fauxbutton:SetScale(CEnemyCastBar.bScale);
			fauxbutton:Show();				
			button:SetAlpha(0);
			button:SetScale(CEnemyCastBar.bScale);
			button:Show();

			--break;

		else	--if (i == CEnemyCastBar.bNumBars) then --only needed for old 'unsorted' code
			-- the limit has been reached if we got here
			NECB_BarrierShown = GetTime();
			CECBBarrierFrame:SetScale(CEnemyCastBar.bScale);
			if (CEnemyCastBar.bFlipB) then
				CECBBarrierFrame:SetPoint("TOP", "Carni_ECB_"..CEnemyCastBar.bNumBars, 0, -13);
			else
				CECBBarrierFrame:SetPoint("TOP", "Carni_ECB_"..CEnemyCastBar.bNumBars, 0, 8);
			end
			CECBBarrierFrame:Show();
			
		end
		
	--end
	
 end  

end

function CEnemyCastBar_BarrierUpdater() --barrier updater

	if (GetTime() > NECB_BarrierShown + 5) then 
		CECBBarrierFrame:Hide();
	end
end

function CEnemyCastBar_UniqueCheck(spellname, castime, mob, gspell, DRText, turnit) --Unique

	local ashowing, drstate = 0, 0;

	-- check only, no update
	if (gspell == "true") then

		for i=1, CEnemyCastBar.bNumBars do
		
			local spell = getglobal("Carni_ECB_"..i).spell;
			
			if (spell == spellname and mob == getglobal("Carni_ECB_"..i).mob) then

				ashowing = 1;

				break; -- there can be only one :D
			end
		end

	-- check + update if mob AND spell are the same
	elseif (gspell == "trueupdate") then

		for i=1, CEnemyCastBar.bNumBars do
		
			local spell = getglobal("Carni_ECB_"..i).spell;
			
			if (spell == spellname and mob == getglobal("Carni_ECB_"..i).mob) then

				ashowing = 1;

					local button = getglobal("Carni_ECB_"..i); --START unique updater

					if (DRText == "delay") then
						-- only allow real casts to be delayed
						local ctype = getglobal("Carni_ECB_"..i).ctype;
						if (ctype == "friendly" or ctype == "hostile") then
							getglobal("Carni_ECB_"..i).startTime = castime;
							getglobal("Carni_ECB_"..i).endTime = turnit;
							getglobal("Carni_ECB_"..i.."_StatusBar"):SetMinMaxValues(button.startTime,button.endTime);
							getglobal("Carni_ECB_"..i.."_StatusBar"):SetValue(GetTime());
						end
					else
						getglobal("Carni_ECB_"..i).startTime = GetTime();
						getglobal("Carni_ECB_"..i).endTime = getglobal("Carni_ECB_"..i).startTime + castime;
						getglobal("Carni_ECB_"..i.."_StatusBar"):SetMinMaxValues(button.startTime,button.endTime);
						getglobal("Carni_ECB_"..i.."_StatusBar"):SetValue(button.startTime);
					end


					if (DRText and DRText ~= "delay") then
						if (DRText == "HoT") then
							local HoTLabel = getglobal("Carni_ECB_"..i).label;
							local HoTStack = string.match(HoTLabel, "(%(%d+%))" );
							if (HoTStack) then
								HoTStack = tonumber( string.sub(HoTStack, 2, string.len (HoTStack) - 1) );
								HoTStack = HoTStack + 1;
								DRText = "("..HoTStack..")";
							else
								DRText = "(2)";
							end
						end

						if (turnit) then
							getglobal("Carni_ECB_"..i).label = mob.." - "..spell .." "..DRText;
						else
							getglobal("Carni_ECB_"..i).label = spell .." "..DRText.." - "..mob;
						end
					end

				break; -- there can be only one :D
			end
		end

	-- check + update if spell is the same
	else

		for i=1, CEnemyCastBar.bNumBars do
		
			local spell = getglobal("Carni_ECB_"..i).spell;
			
			if (spell == spellname) then
	
				ashowing = 1;

					local button = getglobal("Carni_ECB_"..i); --START unique updater

					if (mob == UnitName("player")) then
						getglobal("Carni_ECB_"..i.."_Text"):SetShadowColor(1,0,0);
					else
						getglobal("Carni_ECB_"..i.."_Text"):SetShadowColor(0,0,0);
					end

					if (DRText) then
						if (string.find(button.label, "1/2")) then
							drstate = 4; DRText = "(|cffff00001/4|r)"; castime = castime/2 + 15;
						elseif (string.find(button.label, "1/4")) then
							drstate = 6; DRText = "(|cffff0000"..CECB_MISC_IMMUNE.."|r)"; castime = castime/4 + 15;
						elseif (string.find(button.label, CECB_MISC_IMMUNE)) then
							drstate = 2; DRText = "(|cffff00001/2|r)"; castime = castime + 15;
						end
						getglobal("Carni_ECB_"..i).label = spell .." "..DRText.." - "..mob;
					else
						getglobal("Carni_ECB_"..i).label = spell .." - ".. mob;
					end

					getglobal("Carni_ECB_"..i).startTime = GetTime();
					getglobal("Carni_ECB_"..i).endTime = getglobal("Carni_ECB_"..i).startTime + castime;
					getglobal("Carni_ECB_"..i.."_StatusBar"):SetMinMaxValues(button.startTime,button.endTime);
					getglobal("Carni_ECB_"..i.."_StatusBar"):SetValue(button.startTime);

					getglobal("Carni_ECB_"..i).mob = mob; --END unique updater
					
				break; -- there can be only one :D
			end
		end
	end

	return ashowing, drstate;
end

function CEnemyCastBar_DR_DBCheck(mob, spell, castime, msg, realspell) --DR Check

	local i = 1;

	-- update on spellfade
	if (msg) then -- "fadeupdate"
		while i <= #NECB_DR_DB do
	
			if ( NECB_DR_DB[i][1] == mob and NECB_DR_DB[i][2] == spell ) then
	
				NECB_DR_DB[i][3] = GetTime();
				NECB_DR_DB[i][4] = castime;
				--DEFAULT_CHAT_FRAME:AddMessage("FadeUpdate Mob: "..mob.." |Spell: "..spell);
			end
			i = i + 1;
		end
		return;
	end

	local ashowing, drstate = 0, 0;
	local DRText;
	local DRDBUpdated = false;
	-- add DR to database
	while i <= #NECB_DR_DB do
		if ( GetTime() > ( NECB_DR_DB[i][3] + NECB_DR_DB[i][4] ) ) then
			table.remove(NECB_DR_DB, i);
			i = i - 1;
			--DEFAULT_CHAT_FRAME:AddMessage("Removed Mob: "..mob.." |Spell: "..spell);

		elseif ( NECB_DR_DB[i][1] == mob and NECB_DR_DB[i][2] == spell ) then

			DRText = NECB_DR_DB[i][5];
			if (string.match(DRText, "1/2")) then
				drstate = 4; DRText = "(|cffff00001/4|r)"; castime = castime/2 + 15;
			elseif (string.match(DRText, "1/4")) then
				drstate = 6; DRText = "(|cffff0000"..CECB_MISC_IMMUNE.."|r)"; castime = castime/4 + 15;
			elseif (string.match(DRText, CECB_MISC_IMMUNE)) then
				drstate = 2; DRText = "(|cffff00001/2|r)"; castime = castime + 15;
			end

			NECB_DR_DB[i][3] = GetTime();
			NECB_DR_DB[i][4] = castime;
			NECB_DR_DB[i][5] = DRText;
			DRDBUpdated = true;
			--DEFAULT_CHAT_FRAME:AddMessage("Updated Mob: "..mob.." |Spell: "..spell.." dr: "..drstate);
		end
		i = i + 1;
	end

	if ( not DRDBUpdated and #NECB_DR_DB < 15) then
		drstate = 2; DRText = "(|cffff00001/2|r)"; castime = castime + 15;
		table.insert(NECB_DR_DB, { mob, spell, GetTime(), castime, DRText, realspell } );
		--DEFAULT_CHAT_FRAME:AddMessage("Added Mob: "..mob.." |Spell: "..spell.." Nr.:"..#NECB_DR_DB);
	end
	return DRDBUpdated, drstate;

end

function CEnemyCastBar_BCast_Control(bcasted) --BCast Control

	local down, up, latency = GetNetStats();

	if (not bcasted and latency < 750 and CEnemyCastBar.bBCaster and CEnemyCastBar.bParseC and (GetNumRaidMembers() ~= 0 or GetNumPartyMembers() ~= 0 or GetNumBattlefieldStats() > 1 ) ) then
		if (LastSentBCPacket) then
			if (BCPacket[1] == LastSentBCPacket[1] and BCPacket[2] == LastSentBCPacket[2] and BCPacket[3] == LastSentBCPacket[3] and (GetTime() - LastSentBCPacket[4]) < 5) then
				return false, latency;
			end
		end
		return true, latency;
	end
	return false, latency;
end

function NECB_interrupt_casting(spell, mob) --INTERRUPTING Function, idea by Lazarus

	if (	not CEnemyCastBar.bSpellBreaks
		or not CEnemyCastBar.bGlobalPvP
		or CEnemyCastBar.bGainsOnly
		or not CEnemyCastBar.bPvP
		or (UnitName("target") == mob or UnitName("focus") == mob)
		--will be catched by new spellcastSTOP event (WoW2.0)
		) then
		return;


	elseif ( string.find(NECB_Interruptions, spell) ) then
		CEnemyCastBar_Control(mob, mob, "interrupt");
	end
end

function CEnemyCastBar_Player_Target_Changed() --Target changed

	-- remove other Player CD Bars first
	for i=1, CEnemyCastBar.bNumBars do
		local spell = getglobal("Carni_ECB_"..i).spell;

		if (spell and string.find(spell, " %(CD%)") ) then

			spell = string.gsub(spell, " %(CD%)", "");
			if (CEnemyCastBar_Spells[spell]) then
				CEnemyCastBar_HideBar(i);
			end
		--DR, remove as well
		elseif (spell and string.match(spell, "DR: ") ) then
			CEnemyCastBar_HideBar(i);

		end
	end

	-- display CDs from Database for new target and remove obsolete CDs
	local i = 1;
	while i <= #NECB_CD_DB do
		if ( GetTime() > ( NECB_CD_DB[i][3] + NECB_CD_DB[i][4] ) ) then
			table.remove(NECB_CD_DB, i);
			i = i - 1;
		else
			if (NECB_CD_DB[i][1] == UnitName("target") ) then
				if (UnitIsPlayer("target") and not CEnemyCastBar_Spells[NECB_CD_DB[i][2]].disabled) then
					CEnemyCastBar_Show(NECB_CD_DB[i][1], NECB_CD_DB[i][2].." (CD)", NECB_CD_DB[i][4], "cooldown", nil, CEnemyCastBar_Spells[NECB_CD_DB[i][2]].icontex, NECB_CD_DB[i][3]);
				else
					table.remove(NECB_CD_DB, i);
					i = i - 1;
				end
			end
		end
		i = i + 1;
	end

	--DR display DRs from Database for new target and remove obsolete DRs
	local i = 1;
	local _, playersclass = UnitClass("player");
	while i <= #NECB_DR_DB do
		if ( GetTime() > ( NECB_DR_DB[i][3] + NECB_DR_DB[i][4] ) ) then
			table.remove(NECB_DR_DB, i);
			i = i - 1;
		else
			if (NECB_DR_DB[i][1] == UnitName("target") and playersclass == CEnemyCastBar_Afflictions[ NECB_DR_DB[i][6] ].sclass) then
				CEnemyCastBar_Show(NECB_DR_DB[i][1], NECB_DR_DB[i][2], NECB_DR_DB[i][4], "cooldown", nil, CEnemyCastBar_Afflictions[ NECB_DR_DB[i][6] ].icontex, NECB_DR_DB[i][3], NECB_DR_DB[i][5]);
			end
		end
		i = i + 1;
	end

end

function CEnemyCastBar_IsHostile(event) --ishostile?

	if (event == "CHAT_MSG_SPELL_HOSTILEPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE"
		or event == "CHAT_MSG_SPELL_HOSTILEPLAYER_BUFF" or event == "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_BUFFS"
		or event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" or event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS"
		) then
		return true;
	else
		return false;
	end
end

function CEnemyCastBar_Control(mob, spell, special, bcasted, event) --Control

	if (not CEnemyCastBar.bStatus) then
		return;
	end

	-- Convert "You" into Playername, important for broadcasts
	if (mob == CECB_SELF1 or mob == CECB_SELF2) then
		mob = UnitName("player");
	end

	local spelllength = string.len (spell);
	-- crop the german aposthrophes from some spells (')
	local spell_de = string.sub(spell, 2, spelllength - 1);
	if (CEnemyCastBar_Raids[spell_de]) then spell = spell_de;
	end

		-- stop mirroring spells! only specified Mob, Zone, Event produces castbars else check pvp, debuff section
	if (	NECB_PvE_Module_loaded
		and special ~= "fades"
		and CEnemyCastBar_Raids[spell]
		and not (CEnemyCastBar_Raids[spell].mcheck and not string.find(CEnemyCastBar_Raids[spell].mcheck, mob))
		and not (CEnemyCastBar_Raids[spell].aZone and GetRealZoneText() ~= CEnemyCastBar_Raids[spell].aZone)
		and (bcasted or not (CEnemyCastBar_Raids[spell].checkevent and (not event or not string.find(CEnemyCastBar_Raids[spell].checkevent, event) ) ) )
		) then

		NECB_PvE_Control(mob, spell, special, bcasted, event); -- load on demand addon
		
	else
	
		-- Network BC TempBCaster
		local clientlang = GetLocale();
	
		-- initialize vars
		local ctype, castime;

		if (NECB_PvP_Module_loaded) then
			NECB_PvP_Control(mob, spell, special, bcasted, event); -- load on demand addon
		end
	-- new block
	-- other than PvE, independent of PvP
		-- now check everytime, since some gains shall be removed, too (see REMOVALS in afflictions section of localization.lua)
		if (special == "fades") then -- spells fading earlier than bar, not very important since most spells can't end earlier and aren't listed in c-log after recast and still afflicted

			spell = string.gsub(spell, " %(.+%)", ""); -- remove suffix brackets
			-- crop the german aposthrophes from some spells (')
			local spell_de = string.sub(spell, 2, spelllength - 1);
			if (CEnemyCastBar_Afflictions[spell_de] or CEnemyCastBar_Spells[spell_de]) then spell = spell_de;
			end

			local NECBAfflictSpell = false;
			if (CEnemyCastBar_Afflictions[spell]) then
				NECBAfflictSpell = true;
			end

			-- don't remove 'multi' on fade
			-- don't hide dmg debuffs, can be other player's fade!
			if (NECBAfflictSpell and not (CEnemyCastBar_Afflictions[spell].multi or CEnemyCastBar_Afflictions[spell].periodicdmg)
				or CEnemyCastBar_Spells[spell] ) then


				-- some spells ('Inner Focus') start their CD on fade
				if (CEnemyCastBar.bCDown and CEnemyCastBar_Spells[spell] and CEnemyCastBar_Spells[spell].onfade and mob ~= UnitName("player") ) then
					-- update CD in database
					local i = 1;
					while i <= #NECB_CD_DB do
						if ( NECB_CD_DB[i][1] == mob and NECB_CD_DB[i][2] == spell ) then
							NECB_CD_DB[i][3] = GetTime();
							if (mob == UnitName("target") ) then
								CEnemyCastBar_UniqueCheck(spell.." (CD)", CEnemyCastBar_Spells[spell].d, mob, "trueupdate");
							end
						elseif ( GetTime() > ( NECB_CD_DB[i][3] + NECB_CD_DB[i][4] ) ) then -- remove 'old' cooldowns
							table.remove(NECB_CD_DB, i);
							i = i - 1;
						end
						i = i + 1;
					end
				end

				-- correct DR if a DR Spell fades earlier
				if (CEnemyCastBar.bClassDR and NECBAfflictSpell and CEnemyCastBar_Afflictions[spell].spellDR) then
					local drshare = CEnemyCastBar_Afflictions[spell].drshare;
					local drspell;
					if (drshare) then
						drspell = "DR: "..drshare;
					else
						drspell = "DR: "..spell;
					end
					CEnemyCastBar_UniqueCheck(drspell, 15, mob, "trueupdate"); -- update screen
					CEnemyCastBar_DR_DBCheck(mob, drspell, 15, "fadeupdate"); -- update DR DB
				end

				for i=1, CEnemyCastBar.bNumBars do
	
					local spellrunning = getglobal("Carni_ECB_"..i).spell;
					if (spellrunning) then

						local mobrunning = getglobal("Carni_ECB_"..i).mob;
						if (mob == mobrunning and spell == spellrunning and getglobal("Carni_ECB_"..i).ctype ~= "cooldown") then

							--BC stacking HoT counter
							local NECBNoDel;
							if (CEnemyCastBar_Spells[spell] and CEnemyCastBar_Spells[spell].HoT) then
								local HoTLabel = getglobal("Carni_ECB_"..i).label;
								local HoTStack = string.match(HoTLabel, "(%(%d+%))" );
								if (HoTStack) then
									HoTStack = tonumber( string.sub(HoTStack, 2, string.len (HoTStack) - 1) );
									HoTStack = HoTStack - 1;
									if (HoTStack > 1) then
										getglobal("Carni_ECB_"..i).label = spell .." ("..HoTStack..") - "..mob;
										NECBNoDel = true;
									else
										getglobal("Carni_ECB_"..i).label = spell .." - "..mob;
										NECBNoDel = true;
									end				
								end	
							end

							if (not NECBNoDel) then
								CEnemyCastBar_HideBar(i);
							end

							if (NECBAfflictSpell and (CEnemyCastBar_Afflictions[spell].global or CEnemyCastBar_Afflictions[spell].fragile) ) then
							-- Network BCasting
								BCPacket = {mob, spell, special};
								local freetosend, latency = CEnemyCastBar_BCast_Control(bcasted);
								if ( freetosend ) then
									NECB_SendMessage(".cecbspell "..mob..", "..spell..", "..special..", "..clientlang..", "..latency);
									LastSentBCPacket = {mob, spell, special, GetTime()};
									LastGotBCPacket = {mob, spell, special, GetTime()};
									numspellcast = 0;
								end
							end

							break; -- there can be only one :D
					
						end
					end
				end
			end

		-- LAZARUS Interrupt effect, modified by Natur
		elseif (special == "interrupt") then

			for i=1, CEnemyCastBar.bNumBars do

				local spellrunning = getglobal("Carni_ECB_"..i).spell;
				if (spellrunning) then

					if (CEnemyCastBar_Spells[spellrunning]) then
						local mobrunning = getglobal("Carni_ECB_"..i).mob;

						if (mob == mobrunning and ( getglobal("Carni_ECB_"..i).ctype == "hostile" or getglobal("Carni_ECB_"..i).ctype == "friendly" ) ) then
							CEnemyCastBar_HideBar(i);

							-- Clear Spell in CD Buffer
							if (CEnemyCastBar.bCDown and CEnemyCastBar_Spells[spellrunning].d ) then
								local cdi = 1;
								while cdi <= #NECB_CD_DB do
									if ( NECB_CD_DB[cdi][1] == mobrunning and NECB_CD_DB[cdi][2] == spellrunning ) then
										table.remove(NECB_CD_DB, cdi);
										-- clear visible bar now
										for i=1, CEnemyCastBar.bNumBars do
											local cdspell = getglobal("Carni_ECB_"..i).spell;
											if (cdspell and string.find(cdspell, " %(CD%)") ) then

												cdspell = string.gsub(cdspell, " %(CD%)", "");
												if (CEnemyCastBar_Spells[cdspell] and cdspell == spellrunning) then
													CEnemyCastBar_HideBar(i);
												end
											end
										end
										break;
									end
									cdi = cdi + 1;
								end
							end
							-- Clear Spell in CD Buffer finished

							return; -- no one is able to cast more than one spell at once
						end
					end
				end
			end

		-- clear on mob died; to save some CPU time breackit it out
		elseif (special == "died") then

			for i=1, CEnemyCastBar.bNumBars do

				local spellrunning = getglobal("Carni_ECB_"..i).spell;
				if (spellrunning) then

					-- remove DR Timers upon death
					if (string.find(spellrunning, "DR:")) then
						spellrunning = CECB_SPELL_STUN_DR;
					end

					local mobrunning = getglobal("Carni_ECB_"..i).mob;
					if (CEnemyCastBar_Afflictions[spellrunning]) then

						-- "if" mob can't die without removing the debuff, so this wasn't the 'afflicted' mob
						-- "death" negates the above
						local fragile = CEnemyCastBar_Afflictions[spellrunning].fragile;
						local death = CEnemyCastBar_Afflictions[spellrunning].death;

						if (mob == mobrunning and (not fragile or death)) then
							
							CEnemyCastBar_HideBar(i);

							if (CEnemyCastBar_Afflictions[spellrunning].global or CEnemyCastBar_Afflictions[spellrunning].fragile) then
							-- Network BCasting
								BCPacket = {mob, spell, special};
								local freetosend, latency = CEnemyCastBar_BCast_Control(bcasted);
								if ( freetosend ) then
									NECB_SendMessage(".cecbspell "..mob..", "..spell..", "..special..", "..clientlang..", "..latency);
									LastSentBCPacket = {mob, spell, special, GetTime()};
									LastGotBCPacket = {mob, spell, special, GetTime()};
									numspellcast = 0;
								end
							end
						
						end

					-- to clear all but CD bars if mob dies
					elseif (CEnemyCastBar_Spells[spellrunning]) then

						if (mob == mobrunning and not string.find(getglobal("Carni_ECB_"..i).label, "(CD)") ) then
							CEnemyCastBar_HideBar(i);
						end --
					end
				end
			end

		-- other than faded/died
		elseif (NECB_Debuffs_Module_loaded) then
			NECB_Debuffs_Control(mob, spell, special, bcasted, event) -- load on demand addon
		end

	end -- finishes pve 'else' pvp, died if afflictions/fades
		
end

function CEnemyCastBar_EngageProtection()

	if (necbengagecd and (GetTime() - necbengagecd) < necbEPTime) then
		return true;
	else
		return false;
	end
end

function CEnemyCastBar_Player_Enter_Combat() --enter combat (Aggro etc., not only melee autoattack -> "regen. disabled" event)

	if (CEnemyCastBar.bStatus and necbengagecd and (GetTime() - necbengagecd) > necbEPTime) then
		-- unregister additional Events used for Bosses (fight seems to be over)
		CarniEnemyCastBarFrame:UnregisterEvent("CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE");
		CarniEnemyCastBarFrame:UnregisterEvent("CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE");
		necbengagecd = nil;

		-- reset modified 't' to default
		while (NECBtchangeSource[1]) do
			CEnemyCastBar_Raids[CEnemyCastBar_Raids[ NECBtchangeSource[1] ].tchange[1]].t = CEnemyCastBar_Raids[ NECBtchangeSource[1] ].tchange[2];
			table.remove (NECBtchangeSource, 1);
		end

	end

	local targetmob;
	-- do not check the following with TargetOfTarget and ActiveCombat
	if (CEnemyCastBar.bStatus and not CEnemyCastBar_EngageProtection() ) then

		CEnemyCastBar_Player_Enter_Combat_Exception(); -- localized exceptions (C'Thun)

		if (UnitIsPlusMob("focus") and (UnitName("focustarget") or UnitAffectingCombat("focus")) ) then
			targetmob = UnitName("focus");
		elseif (UnitIsPlusMob("target") and (UnitName("targettarget") or UnitAffectingCombat("target")) ) then
			targetmob = UnitName("target");
			--DEFAULT_CHAT_FRAME:AddMessage("NECB: |cffffff00-= GO GO GO GO GO =-")
		else
			-- recharge the above check, because this event mostly is fired too fast for following checks or Warrior used Bloodrage right before engaging
			if (not necbengagedelay) then
				necbengagedelay = { GetTime(), GetTime(), 10, 0.5 }; -- 1) fixed, 2) resetted every check, 3) time checked, 4) check intervall
				CECBFauxFrameButton:Show();
			--DEFAULT_CHAT_FRAME:AddMessage("NECB: REDOING")
				return;
	
			elseif (GetTime() - necbengagedelay[1] < necbengagedelay[3]) then
				necbengagedelay[2] = GetTime();
			--DEFAULT_CHAT_FRAME:AddMessage("NECB: REDOING - "..GetTime() - necbengagedelay[1])
				return;
			end
		end

	end

	necbengagedelay = nil;
	CECBFauxFrameButton:Hide();

	if (CEnemyCastBar.bStatus and targetmob and not CEnemyCastBar_EngageProtection() ) then
		--DEFAULT_CHAT_FRAME:AddMessage("NECB: ENGAGE - |cffffff00Name Check: "..targetmob)
		CEnemyCastBar_Player_Enter_Combat_Execute(targetmob); --calls the localized part of 'enter combat'
	end

end

function CEnemyCastBar_Parse_RaidChat(msg, author, origin) --parse Raid/PartyChat for commands

	local detectedCECBcommand = true;

	if (CEnemyCastBar.bParseC and origin ~= "NECBCHAT") then

		if (
			string.sub (msg, 1, 10) == ".countsec "
			or string.sub (msg, 1, 10) == ".countmin "
			or string.sub (msg, 1, 8) == ".repeat "
			or string.sub (msg, 1, 11) == ".stopcount "
			or string.sub (msg, 1, 11) == ".cecbspell "
			or string.sub (msg, 1, 32) == "<NECB> version request detected."
			or string.sub (msg, 1, 33) == "<NECB> gversion request detected."
			) then


			--Network BC
			if (string.sub (msg, 1, 11) == ".cecbspell ") then

				wrongclient = false;
				if (UnitName("player") == author and origin ~= "NECBCTRA") then return detectedCECBcommand;
				end
				--/script NECB_SendMessage(".cecbspell Genesarumia, Verbannen, afflicted, deDE, 250");
				for bcmob, bcspell, bcspecial, bcclientlang, bclatency in string.gmatch (msg, ".cecbspell (.+), (.+), (.+), (.+), (.+)") do

					if (bcclientlang ~= GetLocale()) then
						wrongclient = true;
						return detectedCECBcommand;
					end

					-- Check if last receive was the same packet within 5 seconds -> then break!
					if (LastGotBCPacket) then
						if (bcmob == LastGotBCPacket[1] and bcspell == LastGotBCPacket[2] and bcspecial == LastGotBCPacket[3] and (GetTime() - LastGotBCPacket[4]) < 5) then
							numspellcast = numspellcast + 1; 
							return detectedCECBcommand;
						end
					end

				--DEFAULT_CHAT_FRAME:AddMessage("m:"..bcmob.." s:"..bcspell.." t:"..bcspecial)
				numspellcast = 99;
				LastGotBCPacket = {bcmob, bcspell, bcspecial, GetTime()};
				CEnemyCastBar_Control(bcmob, bcspell, bcspecial, "true");
				return detectedCECBcommand;
				end

			else

				-- version harvester
				if (CECBHELPFrame:IsVisible() and CECBHELPFrameText:GetText() == "NECB - VERSIONS" ) then
					for version in string.gmatch(msg, "<NECB> version request detected. (.+)") do
							version = string.sub(version, 2, string.len (version) - 1); -- remove brackets
							table.insert (NECBVersionDB, version);
							table.insert (NECBVersionNames, author);
							CEnemyCastBar_InternalHandler("printversions");
						return detectedCECBcommand;
					end

				-- gversion harvester
				elseif (CECBHELPFrame:IsVisible() and CECBHELPFrameText:GetText() == "NECB - GVERSIONS" ) then
					for version in string.gmatch(msg, "<NECB> gversion request detected. (.+)") do
							version = string.sub(version, 2, string.len (version) - 1); -- remove brackets
							table.insert (NECBVersionDB, version);
							table.insert (NECBVersionNames, author);
							CEnemyCastBar_InternalHandler("printversions");
						return detectedCECBcommand;
					end
				end

				local msg1 = string.sub (msg, 2, string.len(msg));
				CEnemyCastBar_Handler(msg1);
				return detectedCECBcommand, "|cffffffcc";
			end

		elseif (string.sub (msg, 1, 30) == "<NECB> Play Benny Hill for us!") then
			CEnemyCastBar_BHWipe(author);
			return detectedCECBcommand, "|cffffffcc";

		end

	end

	if (origin == "NECB") then

		if string.find(msg, "<NECB> Force version collection.") then
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Version request detected. Sending data.", 1, 0.5, 0);
			NECBVersionDB = { };
			NECBVersionNames = { };
			local playerbcaster = "";
			if (CEnemyCastBar.bBCaster and CEnemyCastBar.bParseC) then
				playerbcaster = ", BCASTER";
			end
			NECB_SendMessage("<NECB> version request detected. ("..CECB_status_version_txt..", "..GetLocale()..playerbcaster..")");
			return detectedCECBcommand, "|cffffffcc";

		elseif string.find(msg, "<NECB> Force gversion collection.") then
			--DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r GVersion request detected. Sending data.", 1, 0.5, 0);
			NECBVersionDB = { };
			NECBVersionNames = { };
			local playerbcaster = "";
			if (CEnemyCastBar.bBCaster and CEnemyCastBar.bParseC) then
				playerbcaster = ", BCASTER";
			end
			NECB_SendMessage("<NECB> gversion request detected. ("..CECB_status_version_txt..", "..GetLocale()..playerbcaster..")", nil, "toguild");
			return detectedCECBcommand, "|cffffffcc";

		elseif string.find(msg, "<NECB> Whisper old versions of NECB to update!") then
			DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00"..author.."|r notified some users!");
			return detectedCECBcommand, "|cffffffcc";

		elseif string.find(msg, "<NECB> FORCE (.+) to Broadcast! Change Settings!") then

			for forceplayer in string.gmatch(msg, "<NECB> FORCE (.+) to Broadcast! Change Settings!") do

				if (forceplayer == UnitName("player") and CEnemyCastBar_CheckRaidStatus(author) ) then
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00"..author.."|r has FORCED your NECB client to broadcast!");
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Settings have been changed.");

					CEnemyCastBar.bPvE = true;
					CEnemyCastBar.bShowafflict = true;
					CEnemyCastBar.bGlobalFrag = true;
					CEnemyCastBar.bParseC = true;
					CEnemyCastBar.bBCaster = true;

 					-- load on demand PvE/Debuffs if not done already
					CEnemyCastBar_RegisterEvents();

					if (CECBOptionsFrame and CECBOptionsFrame:IsVisible()) then
						CECB_ReloadOptionsUI();
					end
				end
			end
			return detectedCECBcommand, "|cffffffcc";

		elseif string.find(msg, "<NECB> STOP (.+) to Broadcast! Change Settings!") then

			for forceplayer in string.gmatch(msg, "<NECB> STOP (.+) to Broadcast! Change Settings!") do

				if (forceplayer == UnitName("player") and CEnemyCastBar_CheckRaidStatus(author) ) then
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffffff00"..author.."|r has STOPPED your NECB client to broadcast!");
					DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB: |cffff9999Settings have been changed.");

					CEnemyCastBar.bBCaster = false;

					if (CECBOptionsFrame and CECBOptionsFrame:IsVisible()) then
						CECB_ReloadOptionsUI();
					end
				end
			end
			return detectedCECBcommand, "|cffffffcc";

		end

	elseif (origin == "NECBCHAT") then

		local rank, fileName = CEnemyCastBar_CheckRaidStatus(author);
		local color = { };
		if ( not fileName ) then
			color.r, color.g, color.b = 1, 1, 1;
		else
			color = RAID_CLASS_COLORS[fileName];
		end

		DEFAULT_CHAT_FRAME:AddMessage("|cffcc99ff\[NECB\] \[|r"..author.."|cffcc99ff\]: "..msg, color.r, color.g, color.b);
	end
end

function NECB_SendMessage(msgs, prefixadd, toguild) --send

	-- patch 1.12
	if (not prefixadd) then
		prefixadd = "";
	end

	if (GetNumBattlefieldStats() > 1 ) then
		SendAddonMessage("NECB"..prefixadd, msgs, "BATTLEGROUND");
	elseif (GetNumRaidMembers() ~= 0) then
		SendAddonMessage("NECB"..prefixadd, msgs, "RAID");
	elseif (GetNumPartyMembers() ~= 0 ) then
		SendAddonMessage("NECB"..prefixadd, msgs, "PARTY");
	elseif (toguild) then
		SendAddonMessage("NECB"..prefixadd, msgs, "GUILD");
	end

end

function CEnemyCastBar_OnUpdate() --Update

	local CECname=this:GetName();
	local CECno=this:GetID();
	local fauxbtn=getglobal("FauxTargetBtn"..CECno);

	local BarupTime = GetTime();
	if (not getglobal(CECname).updated or BarupTime - getglobal(CECname).updated > CEnemyCastBar.bThrottle) then
		getglobal(CECname).updated = BarupTime;

		if (this.endTime) then

			local now = GetTime();
			-- Update the spark, status bar and label
			local remains = this.endTime - now;
			local sparkPos = ((now - this.startTime) / (this.endTime - this.startTime)) * (195 + CEnemyCastBar.bnecbCBLBias);
			
			getglobal(CECname .. "_StatusBar"):SetValue(now);
			getglobal(CECname .. "_Text"):SetText( this.label );	
			getglobal(CECname .. "_StatusBar_Spark"):SetPoint("CENTER", getglobal(CECname .. "_StatusBar"), "LEFT", sparkPos, 0);

			local cbtext = "";
			if (CEnemyCastBar.bTimer) then
				cbtext = CEnemyCastBar_NiceTime(remains);
			end

			if (getglobal(CECname).mob == UnitName("focus") ) then
				cbtext = cbtext.." |cffff0000(F)|r";
			end
			getglobal(CECname .. "_CastTimeText"):SetText( cbtext );
			


			-- fantastic fading routine + flashing, fps independent :D
			local framerate = GetFramerate();
			local stepping = 2/framerate;
			if (stepping > 0.4 ) then stepping = 0.4; -- security for very low fps (< 5fps)
			elseif (stepping < CEnemyCastBar.bThrottle*2 ) then stepping = CEnemyCastBar.bThrottle*2; -- if fps is higher than barupdate
			end

			local baralpha = this:GetAlpha();
			local totalTime = this.endTime - this.startTime;
			if (CEnemyCastBar.bFlashit and (remains/totalTime) < 0.20 and remains < 10 and totalTime >= 20) then

				stepping2 = stepping/1.2 -- manipulate flashing-speed
				if ((baralpha - stepping2) >= 0.1) then
					baralpha = baralpha - stepping2;
					this:SetAlpha(baralpha);
				else
					this:SetAlpha(1);
				end

				-- Raidwarning /rw
				if (CEnemyCastBar.bPvEWarn and not this.warned and CEnemyCastBar_Raids[this.spell] ) then
					PlaySoundFile("Interface\\AddOns\\CEnemyCastBar\\Sounds\\bottleopen2.wav");
					this.warned = true;
				end

			else

				-- Raidwarning, reset to allow new warnings for this spell
				if (this.warned) then
					this.warned = nil;
				end

				if (baralpha + stepping <= CEnemyCastBar.bAlpha) then
					baralpha = baralpha + stepping;
					this:SetAlpha(baralpha);
				else
					if (baralpha ~= CEnemyCastBar.bAlpha) then
						this:SetAlpha(CEnemyCastBar.bAlpha);
					end
				end
			end
			-- fading routine finished

			if (remains < 0) then

				if (string.find (getglobal(CECname).label, "Repeater") ) then

					local castime = getglobal(CECname).endTime - getglobal(CECname).startTime;
					getglobal(CECname).startTime = GetTime();
					getglobal(CECname).endTime = getglobal(CECname).startTime + castime;
					getglobal(CECname.."_StatusBar"):SetMinMaxValues(getglobal(CECname).startTime,getglobal(CECname).endTime);
					getglobal(CECname.."_StatusBar"):SetValue(getglobal(CECname).startTime);

					if (castime == 0) then
						getglobal(CECname).label = "delete me!";
					end

				else

					local tmpmob = getglobal(CECname).mob;
					local tmpspell = getglobal(CECname).spell;
					if (tmpspell == "Move this bar!" and lockshow == 1) then
						lockshow = 0;
						if (CEnemyCastBar.bLocked == false) then
							CEnemyCastBar_LockPos();
						end

					-- check special flags for bars running out
					elseif ( UnitAffectingCombat("player") or UnitIsDead("player") ) then

	 					-- check for tchange flag; changes the 't' of castbars if current bar runs out
						if (CEnemyCastBar_Raids[tmpspell] and CEnemyCastBar_Raids[tmpspell].tchange) then
							CEnemyCastBar_Raids[CEnemyCastBar_Raids[tmpspell].tchange[1]].t = CEnemyCastBar_Raids[tmpspell].tchange[3];
							table.insert (NECBtchangeSource, tmpspell);
							necbengagecd = GetTime(); -- starts the EngageProtection to reset 't' to default for next combat
						end

						-- check for aBar flag; Fires 'aBar' if current bar runs out
						if (CEnemyCastBar_Raids[tmpspell] and CEnemyCastBar_Raids[tmpspell].aBar ) then
							CEnemyCastBar_HideBar(CECno);
							CEnemyCastBar_Control(tmpmob, CEnemyCastBar_Raids[tmpspell].aBar, "casts", "true"); -- won't be broadcasted!
							return;
						end

					end

					-- trigger cooldown bar at the end of the cast
					if ( CEnemyCastBar.bCDown and CEnemyCastBar_Spells[tmpspell] and ( getglobal(CECname).ctype == "hostile" or getglobal(CECname).ctype == "friendly" ) ) then

						if ( CEnemyCastBar_Spells[tmpspell].d and CEnemyCastBar_Spells[tmpspell].t and UnitName("target") == tmpmob and UnitIsPlayer("target") ) then
		
							local castime = CEnemyCastBar_Spells[tmpspell].d;
							if (CEnemyCastBar_UniqueCheck(tmpspell.." (CD)", castime, tmpmob, "trueupdate") == 0) then
								CEnemyCastBar_HideBar(CECno);
								CEnemyCastBar_Show(tmpmob, tmpspell.." (CD)", castime, "cooldown", nil, CEnemyCastBar_Spells[tmpspell].icontex);
								return;
							end

						end
					end

					CEnemyCastBar_HideBar(CECno);

				end


				-- pull the bars together
			elseif (remains >= 1 ) then

				local CECpre = CECno - 1;
				local cecbuttonpre = getglobal("Carni_ECB_"..CECpre);

				if (CECpre > 0 and not cecbuttonpre:IsShown()) then

					cecbuttonpre.startTime = this.startTime
					cecbuttonpre.label = this.label;
		
					local r,g,b = getglobal("Carni_ECB_"..CECno.."_Text"):GetShadowColor();
					getglobal("Carni_ECB_"..CECpre.."_Text"):SetShadowColor(r,g,b);
		
					if (getglobal("Carni_ECB_"..CECno.."_Icon"):IsShown()) then
						getglobal("Carni_ECB_"..CECpre.."_Icon"):SetTexture(getglobal("Carni_ECB_"..CECno.."_Icon"):GetTexture());
						getglobal("Carni_ECB_"..CECpre.."_Icon"):Show();
					end
		
					cecbuttonpre.spell = this.spell;
					cecbuttonpre.mob = this.mob;
					cecbuttonpre.ctype = this.ctype;
					cecbuttonpre.endTime = this.endTime;
					getglobal("Carni_ECB_"..CECpre.."_StatusBar"):SetMinMaxValues(getglobal("Carni_ECB_"..CECno.."_StatusBar"):GetMinMaxValues());
					getglobal("Carni_ECB_"..CECpre.."_StatusBar"):SetValue(getglobal("Carni_ECB_"..CECno.."_StatusBar"):GetValue());
					getglobal("Carni_ECB_"..CECpre.."_StatusBar"):SetStatusBarColor(getglobal("Carni_ECB_"..CECno.."_StatusBar"):GetStatusBarColor());
					getglobal("FauxTargetBtn"..CECpre):Show();
					cecbuttonpre:SetAlpha(CEnemyCastBar.bAlpha);
					cecbuttonpre:Show();
		
					CEnemyCastBar_HideBar(CECno);
				end
			end
		
		end
	end
end

-- Movable window
function CEnemyCastBar_OnDragStart()
    CarniEnemyCastBarFrame:StartMoving();
end

function CEnemyCastBar_OnDragStop()
    CarniEnemyCastBarFrame:StopMovingOrSizing();
end

-- Format seconds into m:ss
function CEnemyCastBar_NiceTime(secs)
	if (secs > 60) then
		secs = ceil(secs);
		return string.format("%d:%02d", secs / 60, math.fmod(secs, 60));
	elseif (secs > 10) then
		secs = ceil(secs);
		return string.format("%.f", secs); -- I noticed sometimes the ceil command does not work, so it is formatted for that case as well
	else
		return string.format("%.1f", secs);
	end
end


function CEnemyCastBar_FPSBar_OnUpdate() --FPSBar

	local BarupTime = GetTime();
	if (not CECB_FPSBarFree_StatusBar.updated or BarupTime - CECB_FPSBarFree_StatusBar.updated > CEnemyCastBar.bThrottle) then
		CECB_FPSBarFree_StatusBar.updated = BarupTime;

		local framerate = GetFramerate();
		local g = framerate/30;
		local r = 30/framerate;
	
		if (g > 1) then g = 1;	end
		if (r > 1) then r = 1;	end
	
		if (framerate > 60) then frameratesafe = 60;
		else frameratesafe = framerate;
		end
	
		CECB_FPSBarFree_StatusBar:SetMinMaxValues(1,60);
		CECB_FPSBarFree_StatusBar:SetValue(frameratesafe);
		CECB_FPSBarFree_StatusBar_Spark:SetPoint("CENTER", "CECB_FPSBarFree_StatusBar", "LEFT", frameratesafe*1.95, 0);
		CECB_FPSBarFree_Text:SetText("|cffffffaaFPS: |cffffcc00"..ceil(framerate));
		CECB_FPSBarFree_StatusBar:SetStatusBarColor(r,g,0);

	end

end

function CECB_GCInfo_OnUpdate() --gcinfo

	local GCTime = GetTime();

	if (not lastgcupdate or GCTime - lastgcupdate > 0.5) then
		lastgcupdate = GCTime;

		local cecbgc_now = collectgarbage("count"); --BC after BC, delete above!
		if (cecbgc_max and cecbgc_now > cecbgc_max) then
			collectgarbage("collect");
		end

		if (not cecbgc_last or cecbgc_last > cecbgc_now) then
			cecbgc_last = cecbgc_now;
			cecbgc_min = cecbgc_now;
			if (cecbgc_now*2 > tonumber(GetCVar("scriptMemory")) ) then
				cecbgc_max = GetCVar("scriptMemory");
			else
				cecbgc_max = cecbgc_now*2; --BC after BC and use global
			end
			cecbgc_minupdate = GCTime;
			lastgcdiffupdate = nil;
			cecbgc_purge30 = 0;
		end

		if (not lastgcdiffupdate or GCTime - lastgcdiffupdate > 5) then
			lastgcdiffupdate = GCTime;
	
			cecbgcdiff = (cecbgc_now - cecbgc_last) / 5;
			cecbgc_last = cecbgc_now;

			--BC, clear from here downwards, remove time presumption; BUT possibly not necessary!!! Might still work
			local GCPurgeCalcLength = 30;
			if ((GCTime - cecbgc_minupdate) > GCPurgeCalcLength) then
				if (cecbgc_min == cecbgc_now) then
					cecbgc_purge30 = 0;
				else
					cecbgc_purge30 = (cecbgc_max - cecbgc_now) * (GCTime - cecbgc_minupdate) / (cecbgc_now - cecbgc_min);
				end
				cecbgc_min = cecbgc_now;
				cecbgc_minupdate = GCTime;
			end

			if (cecbgc_min == cecbgc_now and cecbgc_purge30 == 0) then
				--cecbgcpurge = "waiting...";
				cecbgcpurge = "collecting!"; --BC after BC
			else
				if (cecbgc_min == cecbgc_now) then
					cecbgcpurge = cecbgc_purge30;
				else
					if (GCTime - cecbgc_minupdate > GCPurgeCalcLength or cecbgc_purge30 == 0) then
						cecbgcpurge = (cecbgc_max - cecbgc_now) * (GCTime - cecbgc_minupdate) / (cecbgc_now - cecbgc_min);
					else
						cecbgcpurge = (cecbgc_purge30 * (GCPurgeCalcLength - (GCTime - cecbgc_minupdate)) / GCPurgeCalcLength) + (cecbgc_max - cecbgc_now) * (GCTime - cecbgc_minupdate) / (cecbgc_now - cecbgc_min) * (GCTime - cecbgc_minupdate) / GCPurgeCalcLength;
					end
				end

				if (cecbgcpurge >= 3600) then
					cecbgcpurge = string.format("%d:%02d (|cffffccccHour|r:|cffccffccMin|r)", cecbgcpurge / 3600, math.fmod(cecbgcpurge / 60, 60));
				elseif (cecbgcpurge >= 60) then
					cecbgcpurge = string.format("%d:%02d (|cffccffccMin|r:|cffccccffSec|r)", cecbgcpurge / 60, math.fmod(cecbgcpurge, 60));
				else
					if (cecbgcpurge < 0) then
						cecbgcpurge = 0;
					end
					cecbgcpurge = string.format("%d (|cffccccffSeconds|r)", cecbgcpurge);
				end
			end

		end

		local gctext1 = "|cffffff00This displays the memory usage of all addons!\n\n";
		local gctext2 = "|cffcccc00Estimated time until purge: |r"..cecbgcpurge.."\n\n";
		local gctext3 = "|cffccccffUsed Memory |r- |cffffccccGainRate |r- |cffccffccMaximum\n";
		cecbgcdiff = floor(cecbgcdiff * 10) / 10;
		local gctext4 = "|cff9999ff"..floor(cecbgc_now).."|rkb - |cffff9999"..cecbgcdiff.."|rkb/s - |cff99ff99"..floor(cecbgc_max).."|rkb";
		CECBGCFrameBGText:SetText(gctext1..gctext2..gctext3..gctext4, 0.8, 0.8, 0.8);

	end

end

function CEnemyCastBar_Validchar(msg) --validchar

	value = true;

	for i = 1, string.len(msg) do

		local ctable = string.byte(string.sub(msg,i,i));
		if ( not ( (ctable >= 48 and ctable <= 57) or (ctable >= 65 and ctable <= 90) or (ctable >= 97 and ctable <= 122) ) ) then
			value = false;
		end
	end

	return value;
end

function CEnemyCastBar_LoadNECBDisabledSpells(msg) --loaddisabled

	NECBDisabledSpells = { };

	local i = 1;
	while (CEnemyCastBar.tNECBDisabledSpells[i]) do

			local spell = CEnemyCastBar.tNECBDisabledSpells[i];
			if (CEnemyCastBar_Raids[spell]) then
				CEnemyCastBar_Raids[spell].disabled = true;
			end
	
			if (CEnemyCastBar_Spells[spell]) then
				CEnemyCastBar_Spells[spell].disabled = true;
			end
	
			if (CEnemyCastBar_Afflictions[spell]) then
				CEnemyCastBar_Afflictions[spell].disabled = true;
			end

		table.insert (NECBDisabledSpells, CEnemyCastBar.tNECBDisabledSpells[i]);
		i = i + 1;
	end

	if (not msg) then
		if (#NECBDisabledSpells == 0) then
			DSpells = "Nothing disabled found! |rEmpty table loaded.";
		else
			i = i - 1;
			DSpells = i.." |rDisabled Spells loaded. (see |cff00ff00/necb disabled|r)";
		end
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|cffffff00 "..DSpells);
	end

end

function CEnemyCastBar_SetRange(param) --setrange

	local RangeValues = { };

	if (param == "allmax") then
		RangeValues = {"150", "150", "150", "150", "150", "150", "150", "150"};
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r All CombatLogRanges set to |cffffff00maximum|r!");
	elseif (param == "cmax") then
		RangeValues = {"150", "150", "50", "50", "50", "50", "50", "50"};
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r Creature CombatLogRanges set to |cffffff00maximum|r others set to defaults!");
	else
		RangeValues = {"60", "30", "50", "50", "50", "50", "50", "50"};
		DEFAULT_CHAT_FRAME:AddMessage("|cffaaaaaaNECB:|r All CombatLogRanges set to |cffffff00defaults|r!");
	end

	SetCVar("CombatDeathLogRange" , RangeValues[1]);
	SetCVar("CombatLogRangeCreature" , RangeValues[2]); 
	SetCVar("CombatLogRangeFriendlyPlayers" , RangeValues[3]);
	SetCVar("CombatLogRangeFriendlyPlayersPets" , RangeValues[4]);
	SetCVar("CombatLogRangeHostilePlayers" , RangeValues[5]);
	SetCVar("CombatLogRangeHostilePlayersPets" , RangeValues[6]);
	SetCVar("CombatLogRangeParty" , RangeValues[7]);
	SetCVar("CombatLogRangePartyPet" , RangeValues[8]);
end