﻿
-- module setup
local me = { name = "raidtable"}
local mod = thismod
mod[me.name] = me

--[[
Gui\RaidTable.lua

This class draws the threat table for the raid.
]]

--[[
------------------------------------------------------------------------
						Shared Data
------------------------------------------------------------------------
]]

me.numframes = 4

me.save = 
{
	scale = 1.0,
	[1] = 
	{
		anchor = "topleft",
		colour = 
		{
			r = 0.4,
			g = 0.4,
			b = 1.0,
		},
		length = 10,
		position = 
		{
			x = 340,
			y = -340,
		},
	},
	[2] = 
	{
		anchor = "topright",
		colour = 
		{
			r = 0.4,
			g = 1.0,
			b = 0.4,
		},
		length = 10,
		position = 
		{
			x = 500,
			y = -340,
		},
	},
	[3] = 
	{
		anchor = "bottomleft",
		colour = 
		{
			r = 1.0,
			g = 0.4,
			b = 0.4,
		},
		length = 10,
		position = 
		{
			x = 340,
			y = -370,
		},
	},
	[4] = 
	{
		anchor = "bottomright",
		colour = 
		{
			r = 0.8,
			g = 0.8,
			b = 0.8,
		},
		length = 10,
		position = 
		{
			x = 500,
			y = -370,
		},
	},
}	

-- Special OnLoad method called by Core.lua
me.onload = function()
	
	-- disabled for the moment
	if true then return end
	
	local x, item, anchor
		
	for x = 1, me.numframes do
		
		-- create
		item = me.createinstance()
		
		-- apply saved colour scheme
		item:setcolour(me.save[x].colour.r, me.save[x].colour.g, me.save[x].colour.b)
		
		-- apply saved position
		anchor = string.upper(me.save[x].anchor)
		item.gui.header:ClearAllPoints()
		item.gui.header:SetPoint("TOPLEFT", nil, "TOPLEFT", me.save[x].position.x, me.save[x].position.y)
		
		--mod.print(string.format("frame %s loaded to (%s, %s)", x, me.save[x].position.x, me.save[x].position.y))
		
	end
	
end

me.oppositepoint = 
{
	TOPLEFT = "BOTTOMRIGHT",
	TOPRIGHT = "BOTTOMLEFT",
	BOTTOMLEFT = "TOPRIGHT",
	BOTTOMRIGHT = "TOPLEFT",
	LEFT = "RIGHT",
	RIGHT = "RIGHT",
	BOTTOM = "TOP",
	TOP = "BOTTOM",
	CENTER = "CENTER",
}

--[[
------------------------------------------------------------------------
					Instance Setup
------------------------------------------------------------------------
]]

me.instances = { }  -- numbered list

me.createinstance = function()
	
	local id = 1 + table.getn(me.instances)
	
	local this = 
	{
		["id"] = id,
		
		-- methods
		creategui = me.creategui,
		setcolour = me.setcolour,
		maximise = me.maximise,
		minimise = me.minimise,
	}
	
	table.insert(me.instances, this)
	
	this:creategui()
		
	return this
	
end

--[[
------------------------------------------------------------------------
						Instance Methods
------------------------------------------------------------------------
]]


me.creategui = function(this)

	-- wrapper frame
	this.gui = CreateFrame("Frame", nil, mod.frame)
	this.gui:SetWidth(1)
	this.gui:SetHeight(1)
	this.gui:SetPoint("CENTER", UIParent)
	
	-- header
	this.gui.header = mod.gui.createframe(this.gui, 160, 36, true)
	this.gui.header:SetPoint("CENTER", this.gui)
	
	-- identifier string
	this.gui.header.identifier = mod.gui.createframe(this.gui.header, 20, 20, nil)	
	this.gui.header.identifier.text = mod.gui.createfontstring(this.gui.header.identifier, 14, true)
	this.gui.header.identifier.text:SetPoint("CENTER", -1, 0)
	this.gui.header.identifier.text:SetText(this.id)
	this.gui.header.identifier:SetPoint("BOTTOMLEFT", 2, 2)
	
	-- master target string
	this.gui.header.target = mod.gui.createfontstring(this.gui.header, 12, true)
	this.gui.header.target:SetText("Vaelastrasz The Corrupt")
	this.gui.header.target:SetTextColor(1, 1, 0)
	this.gui.header.target:SetPoint("TOPLEFT", 3, -3)
	this.gui.header.target:SetPoint("TOPRIGHT", -3, -3)
	
	-- position string
	this.gui.header.position = mod.gui.createfontstring(this.gui.header, 14, true)
	this.gui.header.position:SetText("15/25")
	this.gui.header.position:SetPoint("LEFT", this.gui.header.identifier, "RIGHT", 0, 0)
	
	-- close button
	this.gui.header.close = mod.gui.createframe(this.gui.header, 20, 20, nil)
	this.gui.header.close.button = mod.gui.createbutton(this.gui.header.close, 12, 12, true)
	this.gui.header.close.button:SetPoint("CENTER", this.gui.header.close)
	this.gui.header.close:SetPoint("BOTTOMRIGHT", this.gui.header, "BOTTOMRIGHT", -3, 2)

	this.gui.header.close.button:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up")
	this.gui.header.close.button:GetNormalTexture():SetTexCoord(0.25, 0.70, 0.25, 0.75)
	this.gui.header.close.button:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Down")
	this.gui.header.close.button:GetPushedTexture():SetTexCoord(0.25, 0.70, 0.25, 0.75)
	this.gui.header.close.button:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	this.gui.header.close.button:GetHighlightTexture():SetBlendMode("ADD")
	this.gui.header.close.button:GetHighlightTexture():SetTexCoord(0, 1.0, -0.1, 1.1)
	
	-- event handlers
	me.createframeeventhandler("OnClick", this.id, this.gui.header.close.button, "close")
	me.createframeeventhandler("OnEnter", this.id, this.gui.header.close.button, "close")
	me.createframeeventhandler("OnLeave", this.id, this.gui.header.close.button, "close")
	
	-- minimise button
	this.gui.header.minimise = mod.gui.createframe(this.gui.header, 20, 20, nil)
	this.gui.header.minimise.button = mod.gui.createbutton(this.gui.header.minimise, 12, 12, true)
	this.gui.header.minimise.button:SetPoint("CENTER", this.gui.header.minimise)
	this.gui.header.minimise:SetPoint("RIGHT", this.gui.header.close, "LEFT", 3, 0)
	
	-- textures
	this.gui.header.minimise.button:SetNormalTexture("Interface\\Buttons\\UI-MinusButton-UP")
	this.gui.header.minimise.button:GetNormalTexture():SetTexCoord(0.2, 0.8, 0.25, 0.8)
	this.gui.header.minimise.button:SetPushedTexture("Interface\\Buttons\\UI-MinusButton-DOWN")
	this.gui.header.minimise.button:GetPushedTexture():SetTexCoord(0.2, 0.8, 0.25, 0.8)
	this.gui.header.minimise.button:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	this.gui.header.minimise.button:GetHighlightTexture():SetBlendMode("ADD")
	this.gui.header.minimise.button:GetHighlightTexture():SetTexCoord(0, 1.0, -0.1, 1.1)
	
	-- event handlers
	me.createframeeventhandler("OnClick", this.id, this.gui.header.minimise.button, "minimise")
	me.createframeeventhandler("OnEnter", this.id, this.gui.header.minimise.button, "minimise")
	me.createframeeventhandler("OnLeave", this.id, this.gui.header.minimise.button, "minimise")
	
	-- options button
	this.gui.header.options = mod.gui.createframe(this.gui.header, 20, 20, nil)
	this.gui.header.options.button = mod.gui.createbutton(this.gui.header.options, 12, 12, true)
	this.gui.header.options.button:SetPoint("CENTER", this.gui.header.options)
	this.gui.header.options:SetPoint("RIGHT", this.gui.header.minimise, "LEFT", 3, 0)
	
	-- textures
	this.gui.header.options.button:SetNormalTexture("Interface\\ChatFrame\\UI-ChatIcon-Chat-Up")
	this.gui.header.options.button:GetNormalTexture():SetTexCoord(0.2, 0.8, 0.2, 0.8)
	this.gui.header.options.button:SetPushedTexture("Interface\\ChatFrame\\UI-ChatIcon-Chat-Down")
	this.gui.header.options.button:GetPushedTexture():SetTexCoord(0.2, 0.8, 0.2, 0.8)
	this.gui.header.options.button:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight")
	this.gui.header.options.button:GetHighlightTexture():SetBlendMode("ADD")
	this.gui.header.options.button:GetHighlightTexture():SetTexCoord(0.2, 0.8, 0.2, 0.8)
	
	-- enable dragging of header
	this.gui.header:SetMovable("true")
	this.gui.header:RegisterForDrag("LeftButton")
	this.gui.header:EnableMouse()
	me.createframeeventhandler("OnDragStart", this.id, this.gui.header, "header")
	me.createframeeventhandler("OnDragStop", this.id, this.gui.header, "header")
	
	-- event handlers
	me.createframeeventhandler("OnClick", this.id, this.gui.header.options.button, "options")
	me.createframeeventhandler("OnEnter", this.id, this.gui.header.options.button, "options")
	me.createframeeventhandler("OnLeave", this.id, this.gui.header.options.button, "options")
	
end

--[[
me.createframeeventhandler(script, tableid, frame, framename)
Extension of the SetScript method for a RaidTable frame. The event will be sent to the <me.frameevent> method.

<script> is the first argument to SetScript, e.g. "OnLeave", "OnClick" etc
<tableid> is the id of the table that the frame belongs to, it should be <this.id> in the calling scope
<frame> is the operand of SetScript, a reference
<framename> is a string which identifies the frame, e.g. "close" for your close button

]]
me.createframeeventhandler = function(script, tableid, frame, framename)
	
	local methodtext = string.format("%s.%s.frameevent(%s, \"%s\", \"%s\")", mod.namespace, me.name, tableid, framename, script)
	
	local method = loadstring(methodtext)
		
	frame:SetScript(script, method)
	
end

--[[
me.frameevent(index, name, script)
This is our handler for frame events.

<index> identifies which RaidTable instance generated the event (namely, <me.instances[index]>)
<name> is the name of the Frame that fired
<script> is the event handler, e.g. "OnClick", "OnEnter"
]]
me.frameevent = function(index, name, script)
	
	--mod.print(string.format("%s event fired! name = %s, index = %s.", script, name, index))
	
	if script == "OnEnter" then
		
		-- make a tooltip
		local header, body
		
		header = mod.string.tryget("raidtable", "tooltip", name)
		
		if header == nil then
			header = name
			body = "???"
			
		else
			body = mod.string.get("raidtable", "tooltip", name .. "text")
		end
		
		mod.gui.tooltip(this, header, body)
	
	elseif script == "OnLeave" then
		GameTooltip:Hide()
		
	elseif script == "OnClick" then	
		mod.print(string.format("onclick event fired! name = %s, index = %s.", name, index))
	
	elseif script == "OnDragStart" then
		this:StartMoving()
		
	elseif script == "OnDragStop" then
		this:StopMovingOrSizing()
	
		local _, _, _, x, y = this:GetPoint(1)
		
		me.save[index].position.x = x
		me.save[index].position.y = y
		
		--mod.print(string.format("frame %s saved for (%s, %s)", index, x, y))
		
	end
	
end

--[[
myraidtable:setcolour(red, green, blue)
	Changes the colour scheme of the window. We change the colour of all the backdrop borders.
]]
me.setcolour = function(this, red, green, blue)
	
	this.gui.header:SetBackdropBorderColor(red, green, blue)
	
	me.setframeborder(this.gui.header.identifier, red, green, blue)
	me.setframeborder(this.gui.header.close, red, green, blue)
	me.setframeborder(this.gui.header.options, red, green, blue)
	me.setframeborder(this.gui.header.minimise, red, green, blue)
		
end

me.setframeborder = function(frame, red, green, blue)
	
	frame:SetBackdropBorderColor(red, green, blue)
	frame:SetBackdropColor(red, green, blue)
	
end