local CommChannel = CommChannel("1.0")
local IFrameFactory = IFrameFactory("1.0")

local HealSyncDock = { }
local HealSyncUnit = { }

HEALSYNCMODEUNIT = true
HEALSYNCMODECLIENT = false
HEALSYNCPLAYER = true
HEALSYNCTARGET = true
HEALSYNCFOCUS = false

local iface = IFrameManager:Interface()

local function CreateDock(unitID, label)
	this = CreateFrame("Frame", "HealSync__"..label, UIParent)
	this:SetWidth(256)
	this:SetHeight(20)
	this:SetPoint("CENTER", UIParent)
	this:SetMovable(true)
	this:SetUserPlaced(true)
	
	HealSyncDock[unitID] = this	
	IFrameManager:Register(this, iface)
end

CreateDock("player", "Player")
CreateDock("target", "Target")
CreateDock("focus", "Focus")

local function getUnitID(name)
	local numRaidMembers = GetNumRaidMembers()
	for raidID=1,numRaidMembers do
		local unitName = GetRaidRosterInfo(raidID)
		if (unitName == name) then
			return "raid"..raidID
		end
	end
	
	local numPartyMembers = GetNumPartyMembers()
	for partyID=1,numPartyMembers do
		local unitName = UnitName("party"..partyID)
		if (unitName == name) then
			return "party"..partyID
		end
	end
	
	if (name == UnitName("player")) then
		return "player"
	end

	if (focus and name == UnitName("focus")) then
		return "focus"
	end
	
	return nil
end

local function UpdateDock(unitID)		
	local parent = HealSyncDock[unitID]
	local now = GetTime()
	if ((HEALSYNCPLAYER and unitID=="player") or (HEALSYNCTARGET and unitID=="target") or (HEALSYNCFOCUS and unitID=="focus")) then
	for name, info in pairs(HealSyncUnit) do
		if (info[1] == UnitName(unitID) and ((not HEALSYNCMODEUNIT) or getUnitID(info[1])) and info[2] and ((not HEALSYNCMODECLIENT) or info[3])) then
			local spell, rank, display, icon, startTime, endTime = UnitCastingInfo(info[2])
			if (endTime) then castingTime=(endTime/1000)-now else castingTime=0 end
			if (spell and castingTime>0) then
				local frame = IFrameFactory:Create("HealSync", "Button")
				frame.unitID = info[2]
				frame.caster:SetText(name)
				frame.spell:SetText(display)
				frame.bar:SetMinMaxValues(startTime, endTime)
				if (name == UnitName("player")) then
					frame.bar:SetStatusBarColor(1.0, 0.0, 0.0, 0.8)
				else
					local _, class = UnitClass(info[2])
					local color = RAID_CLASS_COLORS[class or "PRIEST"]
					frame.bar:SetStatusBarColor(color.r, color.g, color.b, 0.8)
				end
				frame:ClearAllPoints()
				if (parent == HealSyncDock[unitID]) then
					frame:SetPoint("TOP", parent, "TOP", 0, 0)
				else
					frame:SetPoint("TOP", parent, "BOTTOM", 0, 2)
				end
		
				parent = frame
			else
				info[2] = nil
			end
		end
	end
	end
end

function HealSyncUpdate(name)
	if (name == UnitName("player") or name == UnitName("target")) then
		IFrameFactory:Clear("HealSync", "Button")
	
		UpdateDock("player")
		UpdateDock("target")
		UpdateDock("focus")
	end
end

function ForceUpdate()
	HealSyncUpdate(UnitName("player"))
end

local iface = { }
local module = CommChannel:Create("RAID", "HSC", iface)
--local module = CommChannel:Create("GUILD", "HSC", iface)
--local module = CommChannel:Create("PARTY","HSC", iface)

function iface:T(targetName)
	if ((not (arg4==UnitName("player")))) then
		HealSyncSetTarget(arg4, targetName, true)
	end
end

function HealSyncSetTarget(casterName, targetName, targetAccurate)
	HealSyncUnit[casterName] = HealSyncUnit[casterName] or { }
	if (targetAccurate) then HealSyncUnit[casterName][3] = true end
	HealSyncUnit[casterName][1] = targetName
	HealSyncUpdate(targetName)
end

local function onEvent(self, event, ...)
	if (event == "PLAYER_ENTERING_WORLD") then
	elseif (event == "PLAYER_TARGET_CHANGED") then
		HealSyncUpdate(UnitName("target"))
	elseif (event == "UNIT_SPELLCAST_SENT") then
		local targetName = select(4, ...)
		local casterName = UnitName(select(1, ...))
		HealSyncSetTarget(casterName, targetName, true)
		module:Call("T", targetName)
	elseif (event == "UNIT_SPELLCAST_START" and not (arg1=="target")) then
		local casterID = select(1, ...)
		local casterName = UnitName(casterID)
		casterTarget = casterID.."target"
		local targetName = nil
		if (casterTarget=="npctarget") then targetName=nil; else targetName = UnitName(casterTarget) or nil; end
		local unit = HealSyncUnit[casterName]
		if ( targetName and ((not unit) or (unit  and (not unit[3])))) then
			HealSyncSetTarget(casterName, targetName, false)
		elseif ((not targetName) and unit and (not unit[3])) then
			unit[2] = nil
			HealSyncUpdate(unit[1])
			return
		end
		unit = HealSyncUnit[UnitName(casterID)]
		if (unit) then
			unit[2] = casterID
			HealSyncUpdate(unit[1])
		end
	elseif (event == "UNIT_SPELLCAST_DELAYED" and not (arg1=="target")) then
		local casterID = select(1, ...)
		local unit = HealSyncUnit[UnitName(casterID)]
		if (unit and unit[2]) then
			--unit[2] = casterID
			HealSyncUpdate(unit[1])
		end
	elseif (event == "UNIT_SPELLCAST_STOP" and not (arg1=="target")) then
		local casterID = select(1, ...)
		local unit = HealSyncUnit[UnitName(casterID)]
		if (unit and unit[2]) then
			unit[2] = nil
			HealSyncUpdate(unit[1])
		end
	end
end

local function HealSyncToggle(msg)
	lmsg = string.lower(msg)
	local errorflag = false
	if (lmsg == "unit") then
		HEALSYNCMODEUNIT = true
		HEALSYNCMODEOFF = false
		HealSyncUpdate(UnitName("player"))
	elseif (lmsg == "all") then
		HEALSYNCMODEUNIT = false
		HEALSYNCMODEOFF = false
		HealSyncUpdate(UnitName("player"))
	elseif (lmsg == "off") then
		HEALSYNCPLAYER = false
		HEALSYNCTARGET = false
		HEALSYNCFOCUS = false
		HealSyncUpdate(UnitName("player"))
	elseif (lmsg == "on") then
		HEALSYNCPLAYER = true
		HEALSYNCTARGET = true
		HEALSYNCFOCUS = true
		HealSyncUpdate(UnitName("player"))
	elseif (lmsg == "player off") then
		HEALSYNCPLAYER = false
		HealSyncUpdate(UnitName("player"))
	elseif (lmsg == "target off") then
		HEALSYNCTARGET = false
		HealSyncUpdate(UnitName("player"))
	elseif (lmsg == "focus off") then
		HEALSYNCFOCUS = false
		HealSyncUpdate(UnitName("player"))
	elseif (lmsg == "player on") then
		HEALSYNCPLAYER = true
		HealSyncUpdate(UnitName("player"))
	elseif (lmsg == "target on") then
		HEALSYNCTARGET = true
		HealSyncUpdate(UnitName("player"))
	elseif (lmsg == "focus on") then
		HEALSYNCFOCUS = true
		HealSyncUpdate(UnitName("player"))
	elseif (lmsg == "client") then
		HEALSYNCMODECLIENT = true
		HealSyncUpdate(UnitName("player"))
	elseif (lmsg == "scan") then
		HEALSYNCMODECLIENT = false
		HealSyncUpdate(UnitName("player"))
	else
		errorflag = true
	end
	local HEALSYNCTARGET 
	local HEALSYNCCASTER
	local HEALSYNCVIEW = ""
	if (HEALSYNCMODEUNIT) then
		HEALSYNCTARGET = "UNIT"
	else
		HEALSYNCTARGET = "ALL"
	end
	if (HEALSYNCPLAYER) then
		HEALSYNCVIEW = "PLAYER"
	end
	if (HEALSYNCTARGET and HEALSYNCVIEW=="") then
		HEALSYNCVIEW = "TARGET"
	elseif (HEALSYNCTARGET) then
		HEALSYNCVIEW = HEALSYNCVIEW..", TARGET"
	end
	if (HEALSYNCFOCUS and HEALSYNCVIEW=="") then
		HEALSYNCVIEW = "FOCUS"
	elseif (HEALSYNCFOCUS) then
		HEALSYNCVIEW = HEALSYNCVIEW..", FOCUS"
	end
	if (HEALSYNCVIEW=="") then
		HEALSYNCVIEW = "OFF"
	end
	if (HEALSYNCMODECLIENT) then
		HEALSYNCCASTER = "CLIENT"
	else
		HEALSYNCCASTER = "SCAN"
	end
	
	DEFAULT_CHAT_FRAME:AddMessage("HealSync Target: "..HEALSYNCTARGET)
	DEFAULT_CHAT_FRAME:AddMessage("HealSync Caster: "..HEALSYNCCASTER)
	DEFAULT_CHAT_FRAME:AddMessage("HealSync View: "..HEALSYNCVIEW)
	if (errorflag) then
		DEFAULT_CHAT_FRAME:AddMessage("/hs [UNIT|ALL] - Show cast bars on UNITs (player, target, raid, party) or Everything")
		DEFAULT_CHAT_FRAME:AddMessage("/hs [CLIENT|SCAN] - Show cast bars of those with/without Healsync")
		DEFAULT_CHAT_FRAME:AddMessage("/hs [ON/OFF] - Turns all heal bars ON or OFF.")
		DEFAULT_CHAT_FRAME:AddMessage("/hs [PLAYER|TARGET|FOCUS] [ON/OFF] - Turn PLAYER, TARGET, and FOCUS frames ON or OFF.")
	end
end

this = CreateFrame("Frame")
this:RegisterEvent("PLAYER_ENTERING_WORLD")
this:RegisterEvent("PLAYER_TARGET_CHANGED")
this:RegisterEvent("UNIT_SPELLCAST_SENT")
this:RegisterEvent("UNIT_SPELLCAST_START")
this:RegisterEvent("UNIT_SPELLCAST_DELAYED")
this:RegisterEvent("UNIT_SPELLCAST_STOP")
this:SetScript("OnEvent", onEvent)
DEFAULT_CHAT_FRAME:AddMessage("Addon: HealSync (/hs)");

SLASH_HS1 = "/hs"
SlashCmdList["HS"] = function(msg)
 HealSyncToggle(msg);
end
