
---------------------------------------------------------------------------
local root = CreateFrame("Frame", nil, Minimap, "SecureStateHeaderTemplate");
root:SetAllPoints(MiniMapTrackingFrame);
root:SetWidth(33);
root:SetHeight(33);
root:SetFrameStrata("DIALOG");
root:Show();

--root:SetAttribute("statemap-anchor", "$input");
--root:SetAttribute("delaystatemap-anchor", "1");
--root:SetAttribute("delaytimemap-anchor", "0.5");
--root:SetAttribute("delayhovermap-anchor", "true");
root:SetAttribute("statemap-anchor-enter", "1:2");
root:SetAttribute("statemap-anchor-leave",      ";"); -- Non-empty
root:SetAttribute("delaystatemap-anchor-leave", "2:1");
root:SetAttribute("delaytimemap-anchor-leave",  "2:0.5");
root:SetAttribute("delayhovermap-anchor-leave", "2:true");

FTM_Root = root;

local headerButton = CreateFrame("Button", nil, nil, "FTM_HeaderTemplate,SecureAnchorEnterTemplate");
headerButton:SetWidth(33);
headerButton:SetHeight(33);
--headerButton.texture = headerButton:CreateTexture(nil, "OVERLAY");
--headerButton.texture:SetAllPoints(headerButton);
--headerButton.texture:SetTexture("Interface\\Icons\\INV_Misc_Map_01");
--headerButton.texture:Show();

root:SetAttribute("addchild", headerButton);
headerButton:SetAttribute("showstates", "!0,*");
headerButton:SetAttribute("ofsx", 0);
headerButton:SetAttribute("ofsy", 0);

headerButton:SetAttribute("anchorchild", root);
headerButton:SetAttribute("childstate", 2);
headerButton:SetAttribute("*childraise-OnEnter", true);
headerButton:SetAttribute("*childstate-OnEnter", "enter");
headerButton:SetAttribute("*childstate-OnLeave", "leave");

local SPELL_BUTTONS = {};
local function FTM_GetSpellButton(index)
    local b = SPELL_BUTTONS[index];
    if (not b) then
	b = CreateFrame("Button", nil, nil, "FTM_ButtonTemplate");
	--b:SetWidth(150);
	--b:SetHeight(26);
	b:SetFrameStrata("DIALOG");
	b.texture = b:CreateTexture(nil, "OVERLAY");
	b.texture:SetWidth(24);
	b.texture:SetHeight(24);
	b.texture:SetPoint("LEFT", 4, 0);
	b.texture:Show();
	
	SPELL_BUTTONS[index] = b;
	root:SetAttribute("addchild", b);
    end
    return b;
end

FTM_TrackingAbilities = {
	{ tab=1, icon="INV_Misc_Flower_02" },                               -- Find Herbs	
	{ tab=1, icon="Spell_Nature_Earthquake" },                          -- Find Minerals
	{ tab=1, icon="Racial_Dwarf_FindTreasure" },                        -- Find Treasure

	{ class="HUNTER", tab=4, icon="Ability_Tracking" },                 -- Track Beasts	
	{ class="HUNTER", tab=4, icon="Spell_Shadow_SummonFelHunter" },     -- Track Demons	
	{ class="HUNTER", tab=4, icon="INV_Misc_Head_Dragon_01" },          -- Track Dragonkin
	{ class="HUNTER", tab=4, icon="Spell_Frost_SummonWaterElemental" },	-- Track Elementals
	{ class="HUNTER", tab=4, icon="Ability_Racial_Avatar" },            -- Track Giants	
	{ class="HUNTER", tab=4, icon="Ability_Stealth" },                  -- Track Hidden	
	{ class="HUNTER", tab=4, icon="Spell_Holy_PrayerOfHealing" },       -- Track Humanoids
	{ class="HUNTER", tab=4, icon="Spell_Shadow_DarkSummoning" },       -- Track Undead	

	{ class="WARLOCK", tab=3, icon="Spell_Shadow_Metamorphosis" },      -- Sense Demons	
	{ class="PALADIN", tab=2, icon="Spell_Holy_SenseUndead" },	        -- Sense Undead	
};
FTM_SpellPrefix = "Interface\\Icons\\";

function FTM_BuildFrames()

	FTM_MyTrackSpells = {};
	local spellIcons = {};
	local _, myClass = UnitClass("player");
	for _, spellInfo in ipairs(FTM_TrackingAbilities) do
		--DevTools_Dump(spellInfo)
		if (spellInfo.class == myClass or not spellInfo.class) then
			local name, _, offset, numSpells = GetSpellTabInfo(spellInfo.tab);
			--DevTools_Dump({name=name})
			for i = offset + 1, offset + numSpells do
				local icon = GetSpellTexture(i, BOOKTYPE_SPELL);
				--DevTools_Dump(icon)
				if (icon == FTM_SpellPrefix..spellInfo.icon) then
					local name = GetSpellName(i, BOOKTYPE_SPELL);
					table.insert(FTM_MyTrackSpells, name);
					spellIcons[name] = icon;
				end
			end
		end
	end
	--DevTools_Dump({FTM_MyTrackSpells, spellIcons})
	
	local maxSpells = #FTM_MyTrackSpells;
    local spellCount = math.max(#SPELL_BUTTONS, maxSpells);
    for i = 1, spellCount do
		local spellButton = FTM_GetSpellButton(i);
		if (i > maxSpells) then
		    spellButton:SetAttribute("showstates", nil);
		    spellButton:SetAttribute("hidetates", "*");
		else
			local spellname = FTM_MyTrackSpells[i];
		    spellButton:SetAttribute("spell", spellname);
		    spellButton:SetAttribute("showstates", "2");
		    spellButton:SetAttribute("ofsx", 3);
		    spellButton:SetAttribute("ofsy", i * -28);
		    spellButton:SetAttribute("ofspoint", "LEFT");			
		    spellButton:SetAttribute("ofsrelpoint", "LEFT");			
		    spellButton:SetAttribute("type", "spell");
		    spellButton:SetAttribute("newstate", "1");
			
			spellButton.texture:SetTexture(spellIcons[spellname]);
			spellButton.texture:Show();
			spellButton.title:SetText(spellname);
			
		end 
    end
    
	if (#FTM_MyTrackSpells > 0) then
		root:SetAttribute("state", 1);
	end
end

function FTM_OnEvent(self, event)
	if ((event == "SPELLS_CHANGED") or (event == "PLAYER_ENTERING_WORLD") and (not InCombatLockdown())) then
		FTM_BuildFrames();
	elseif (event == "PLAYER_AURAS_CHANGED") then
		if (#FTM_MyTrackSpells == 0) then return; end
		local icon = GetTrackingTexture();
		if (icon) then
			FTM_NoTrackingFrame:Hide();
		else
			FTM_NoTrackingFrame:Show();
		end
	end
end

local evframe = CreateFrame("Frame", nil, nil);
evframe:SetScript("OnEvent", FTM_OnEvent);
evframe:RegisterEvent("SPELLS_CHANGED");
evframe:RegisterEvent("PLAYER_ENTERING_WORLD");
evframe:RegisterEvent("PLAYER_AURAS_CHANGED");

local version = GetAddOnMetadata("GFW_TrackMenu", "Version");
GFWUtils.Print("Fizzwidget TrackMenu "..version.." initialized!");
