﻿--[[
Name: Babble-Boss-2.2
Revision: $Rev: 23490 $
Author(s): ckknight (ckknight@gmail.com)
Credits: Funkydude
Website: http://ckknight.wowinterface.com/
Documentation: http://wiki.wowace.com/index.php/Babble-Boss-2.2
SVN: http://svn.wowace.com/root/trunk/Babble-2.2/Babble-Boss-2.2
Description: A library to provide localizations for bosses.
Dependencies: AceLibrary, AceLocale-2.2
License: MIT
]]

local MAJOR_VERSION = "Babble-Boss-2.2"
local MINOR_VERSION = tonumber(string.sub("$Revision: 23490 $", 12, -3))

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end

if not AceLibrary:HasInstance("AceLocale-2.2") then error(MAJOR_VERSION .. " requires AceLocale-2.2") end

local _, x = AceLibrary("AceLocale-2.2"):GetLibraryVersion()
MINOR_VERSION = MINOR_VERSION * 100000 + x

if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local BabbleBoss = AceLibrary("AceLocale-2.2"):new(MAJOR_VERSION)

-- uncomment below for debug information
-- BabbleBoss:EnableDebugging()

BabbleBoss:RegisterTranslations("enUS", function() return {
		["Avalanchion"] = true,
		["The Windreaver"] = true,
		["Baron Charr"] = true,
		["Princess Tempestria"] = true,
		["Onyxia"] = true,
		["Azuregos"] = true,
		["Lord Kazzak"] = true,
		["Ysondre"] = true,
		["Emeriss"] = true,
		["Taerar"] = true,
		["Lethon"] = true,
		["Ayamiss the Hunter"] = true,
		["Buru the Gorger"] = true,
		["General Rajaxx"] = true,
		["Lieutenant General Andorov"] = true,
		["Moam"] = true,
		["Anubisath Guardian"] = true,
		["Ossirian the Unscarred"] = true,
		["Alzzin the Wildshaper"] = true,
		["Ambassador Flamelash"] = true,
		["Anger'rel"] = true,
		["Archivist Galford"] = true,
		["Bael'Gar"] = true,
		["Balnazzar"] = true,
		["Baroness Anastari"] = true,
		["Baron Rivendare"] = true,
		["Cannon Master Willey"] = true,
		["Captain Kromcrush"] = true,
		["Crystal Fang"] = true,
		["Darkmaster Gandling"] = true,
		["Doctor Theolen Krastinov"] = true,
		["Doom'rel"] = true,
		["Dope'rel"] = true,
		["Emperor Dagran Thaurissan"] = true,
		["Fineous Darkvire"] = true,
		["Gasher"] = true,
		["General Angerforge"] = true,
		["General Drakkisath"] = true,
		["Gloom'rel"] = true,
		["Golem Lord Argelmach"] = true,
		["Goraluk Anvilcrack"] = true,
		["Guard Fengus"] = true,
		["Guard Mol'dar"] = true,
		["Guard Slip'kik"] = true,
		["Gyth"] = true,
		["Halycon"] = true,
		["Hate'rel"] = true,
		["Hearthsinger Forresten"] = true,
		["High Interrogator Gerstahn"] = true,
		["Highlord Omokk"] = true,
		["Hukku"] = true,
		["Hurley Blackbreath"] = true,
		["Hydrospawn"] = true,
		["Illyanna Ravenoak"] = true,
		["Immol'thar"] = true,
		["Instructor Malicia"] = true,
		["Jandice Barov"] = true,
		["King Gordok"] = true,
		["Kirtonos the Herald"] = true,
		["Lady Illucia Barov"] = true,
		["Lethtendris"] = true,
		["Lord Alexei Barov"] = true,
		["Lord Incendius"] = true,
		["Lorekeeper Polkelt"] = true,
		["Loro"] = true,
		["Magister Kalendris"] = true,
		["Magistrate Barthilas"] = true,
		["Magmus"] = true,
		["Maleki the Pallid"] = true,
		["Marduk Blackpool"] = true,
		["Mijan"] = true,
		["Mother Smolderweb"] = true,
		["Nerub'enkan"] = true,
		["Overlord Wyrmthalak"] = true,
		["Phalanx"] = true,
		["Plugger Spazzring"] = true,
		["Postmaster Malown"] = true,
		["Princess Moira Bronzebeard"] = true,
		["Prince Tortheldrin"] = true,
		["Pusillin"] = true,
		["Pyroguard Emberseer"] = true,
		["Ramstein the Gorger"] = true,
		["Ras Frostwhisper"] = true,
		["Rattlegore"] = true,
		["Warchief Rend Blackhand"] = true,
		["Ribbly Screwspigot"] = true,
		["Seeth'rel"] = true,
		["Shadow Hunter Vosh'gajin"] = true,
		["Solakar Flamewreath"] = true,
		["Stomper Kreeg"] = true,
		["Tendris Warpwood"] = true,
		["The Beast"] = true,
		["The Ravenian"] = true,
		["Timmy the Cruel"] = true,
		["Tsu'zee"] = true,
		["Vectus"] = true,
		["Vile'rel"] = true,
		["War Master Voone"] = true,
		["Zevrim Thornhoof"] = true,
		["Zolo"] = true,
		["Zul'Lor"] = true,

		-- From Mendeleev
		["Cho'Rush the Observer"] = true,
		["Lord Hel'nurath"] = true,
		["Pimgib"] = true,
		["Knot Thimblejack's Cache"] = true,
		["Cannonmaster Willey"] = true,
		["Emperor Dagran Thaurissian"] = true,
		["Archmage Arugal"] = true,
		["Archmage Arugal's Voidwalker"] = true,
		["Baron Silverlaine"] = true,
		["Commander Springvale"] = true,
		["Deathsworn Captain"] = true,
		["Fenrus the Devourer"] = true,
		["Odo the Blindwatcher"] = true,
		["Razorclaw the Butcher"] = true,
		["Wolf Master Nandos"] = true,
		["Rend Blackhand"] = true,
		["Kurinnaxx"] = true,

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct.
		["Doom Lord Kazzak"] = true,
		["Doomwalker"] = true,

		-- Karazhan
		["Prince Malchezaar"] = true,
		["Attumen the Huntsman"] = true,
		["Midnight"] = true,
		["Hyakiss the Lurker"] = true,
		["Rokad the Ravager"] = true,
		["Shadikith the Glider"] = true,
		["Moroes"] = true,
		["Maiden of Virtue"] = true,
		["Dorothee"] = true,
		["Tito"] = true,
		["Tinhead"] = true,
		["Strawman"] = true,
		["Roar"] = true,
		["The Crone"] = true,
		["Romulo"] = true,
		["Julianne"] = true,
		["The Big Bad Wolf"] = true,
		["The Curator"] = true,
		["Shade of Aran"] = true,
		["Terestian Illhoof"] = true,
		["Netherspite"] = true,
		["Nightbane"] = true,
		["King Llane Piece"] = true,
		["Warchief Blackhand Piece"] = true,
		-- Caverns of Time
		--   Durnholde Keep
		["Lieutenant Drake"] = true,
		["Captain Skarloc"] = true,
		["Epoch Hunter"] = true,
		--   The Black Morass
		["Medivh"] = true,
		["Chrono Lord Deja"] = true,
		["Temporus"] = true,
		["Aeonus"] = true,
		--   XX
		["Archimonde"] = true,
		-- Hellfire Ramparts
		["Watchkeeper Gargolmar"] = true,
		["Vazruden the Herald"] = true,
		["Vazruden"] = true,
		["Nazan"] = true,
		["Omor the Unscarred"] = true,
		-- The Blood Furnace
		["The Maker"] = true,
		["Broggok"] = true,
		["Keli'dan the Breaker"] = true,
		-- The Shattered Halls
		["Kargath Bladefist"] = true,
		["Grand Warlock Nethekurse"] = true,
		["Warbringer O'mrogg"] = true,
		-- Magtheridon's Lair
		["Magtheridon"] = true,
		-- The Slave Pens
		["Mennu the Betrayer"] = true,
		["Rokmar the Crackler"] = true,
		["Quagmirran"] = true,
		-- The Underbog
		["Hungarfen"] = true,
		["Ghaz'an"] = true,
		["Overseer Tidewrath"] = true,
		["Claw"] = true,
		["Swamplord Musel'ek"] = true,
		["The Black Stalker"] = true,
		-- The Steamvault
		["Hydromancer Thespia"] = true,
		["Mekgineer Steamrigger"] = true,
		["Warlord Kalithresh"] = true,
		-- Serpentshrine Cavern
		["Lady Vashj"] = true,
		-- Mana Tombs
		["Pandemonius"] = true,
		["Tavarok"] = true,
		["Nexus-Prince Shaffar"] = true,
		-- Auchenai Crypts
		["Shirrak the Dead Watcher"] = true,
		["Exarch Maladaar"] = true,
		-- Sethekk Halls
		["Talon King Ikiss"] = true,
		["Darkweaver Syth"] = true,
		-- Shadow Labyrinth
		["Ambassador Hellmaw"] = true,
		["Blackheart the Inciter"] = true,
		-- The Mechanar
		["Gatekeeper Gyro-Kill"] = true,
		["Nethermancer Sepethrea"] = true,
		["Gatewatcher Iron-Hand"] = true,
		["Mechano-Lord Capacitus"] = true,
		["Pathaleon the Calculator"] = true,
		-- The Botanica
		["Commander Sarannis"] = true,
		["High Botanist Freywinn"] = true,
		["Thorngrin the Tender"] = true,
		["Laj"] = true,
		["Warp Splinter"] = true,
		-- The Arcatraz
		-- The Eye
		["Prince Kael'thas Sunstrider"] = true,
		-- Gruul's Lair
		["Gruul"] = true,
		-- Black Temple
		["Illidan Stormrage"] = true,
		-- Ring of Blood
		["Brokentoe"] = true,
		["Murkblood Twin"] = true,
		["Murkblood Twins"] = true,
		["The Blue Brothers"] = true,
		["Rokdar the Sundered Lord"] = true,
		["Skra'gath"] = true,
		["Warmaul Champion"] = true,
		["Mogor"] = true,

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = true,
		["Battleguard Sartura"] = true,
		["C'Thun"] = true,
		["Emperor Vek'lor"] = true,
		["Emperor Vek'nilash"] = true,
		["Eye of C'Thun"] = true,
		["Fankriss the Unyielding"] = true,
		["Lord Kri"] = true,
		["Ouro"] = true,
		["Princess Huhuran"] = true,
		["Princess Yauj"] = true,
		["The Bug Family"] = true,
		["The Prophet Skeram"] = true,
		["The Twin Emperors"] = true,
		["Vem"] = true,
		["Viscidus"] = true,

--Blackwing Lair
		["Broodlord Lashlayer"] = true,
		["Chromaggus"] = true,
		["Ebonroc"] = true,
		["Firemaw"] = true,
		["Flamegor"] = true,
		["Grethok the Controller"] = true,
		["Lord Victor Nefarius"] = true,
		["Nefarian"] = true,
		["Razorgore the Untamed"] = true,
		["Vaelastrasz the Corrupt"] = true,

--Maraudon
		["Celebras the Cursed"] = true,
		["Landslide"] = true,
		["Lord Vyletongue"] = true,
		["Meshlok the Harvester"] = true,
		["Noxxion"] = true,
		["Princess Theradras"] = true,
		["Razorlash"] = true,
		["Rotgrip"] = true,
		["Tinkerer Gizlock"] = true,

--Molten Core
		["Baron Geddon"] = true,
		["Garr"] = true,
		["Gehennas"] = true,
		["Golemagg the Incinerator"] = true,
		["Lucifron"] = true,
		["Magmadar"] = true,
		["Majordomo Executus"] = true,
		["Ragnaros"] = true,
		["Shazzrah"] = true,
		["Sulfuron Harbinger"] = true,

--Naxxramas
		["Anub'Rekhan"] = true,
		["Deathknight Understudy"] = true,
		["Feugen"] = true,
		["Gluth"] = true,
		["Gothik the Harvester"] = true,
		["Grand Widow Faerlina"] = true,
		["Grobbulus"] = true,
		["Heigan the Unclean"] = true,
		["Highlord Mograine"] = true,
		["Instructor Razuvious"] = true,
		["Kel'Thuzad"] = true,
		["Lady Blaumeux"] = true,
		["Loatheb"] = true,
		["Maexxna"] = true,
		["Noth the Plaguebringer"] = true,
		["Patchwerk"] = true,
		["Sapphiron"] = true,
		["Sir Zeliek"] = true,
		["Stalagg"] = true,
		["Thaddius"] = true,
		["Thane Korth'azz"] = true,
		["The Four Horsemen"] = true,

--Ragefire Chasm
		["Bazzalan"] = true,
		["Jergosh the Invoker"] = true,
		["Maur Grimtotem"] = true,
		["Taragaman the Hungerer"] = true,

--Scarlet Monastery
		["Arcanist Doan"] = true,
		["Azshir the Sleepless"] = true,
		["Bloodmage Thalnos"] = true,
		["Fallen Champion"] = true,
		["Herod"] = true,
		["High Inquisitor Fairbanks"] = true,
		["High Inquisitor Whitemane"] = true,
		["Houndmaster Loksey"] = true,
		["Ironspine"] = true,
		["Scarlet Commander Mograine"] = true,

--The Deadmines
		["Captain Greenskin"] = true,
		["Cookie"] = true,
		["Edwin VanCleef"] = true,
		["Gilnid"] = true,
		["Miner Johnson"] = true,
		["Mr. Smite"] = true,
		["Rhahk'Zor"] = true,
		["Sneed"] = true,

--The Stockade
		["Bazil Thredd"] = true,
		["Bruegal Ironknuckle"] = true,
		["Dextren Ward"] = true,
		["Hamhock"] = true,
		["Kam Deepfury"] = true,
		["Targorr the Dread"] = true,

--The Temple of Atal'Hakkar
		["Atal'alarion"] = true,
		["Avatar of Hakkar"] = true,
		["Dreamscythe"] = true,
		["Hazzas"] = true,
		["Jammal'an the Prophet"] = true,
		["Morphaz"] = true,
		["Ogom the Wretched"] = true,
		["Shade of Eranikus"] = true,
		["Weaver"] = true,

--Uldaman
		["Ancient Stone Keeper"] = true,
		["Archaedas"] = true,
		["Baelog"] = true,
		["Galgann Firehammer"] = true,
		["Grimlok"] = true,
		["Ironaya"] = true,
		["Obsidian Sentinel"] = true,
		["Revelosh"] = true,

--Zul'Farrak
		["Antu'sul"] = true,
		["Chief Ukorz Sandscalp"] = true,
		["Gahz'rilla"] = true,
		["Hydromancer Velratha"] = true,
		["Nekrum Gutchewer"] = true,
		["Ruuzlu"] = true,
		["Sandfury Executioner"] = true,
		["Sergeant Bly"] = true,
		["Theka the Martyr"] = true,
		["Witch Doctor Zum'rah"] = true,
		["Zerillis"] = true,
		["Zul'Farrak Dead Hero"] = true,

--Zul'Gurub
		["Bloodlord Mandokir"] = true,
		["Gahz'ranka"] = true,
		["Gri'lek"] = true,
		["Hakkar"] = true,
		["Hazza'rah"] = true,
		["High Priestess Arlokk"] = true,
		["High Priestess Jeklik"] = true,
		["High Priestess Mar'li"] = true,
		["High Priest Thekal"] = true,
		["High Priest Venoxis"] = true,
		["Jin'do the Hexxer"] = true,
		["Renataki"] = true,
		["Wushoolay"] = true,
	} end)

BabbleBoss:RegisterTranslations("deDE", function() return {
		["Avalanchion"] = "Avalanchion",
		["The Windreaver"] = "Der Windh\195\164scher",
		["Baron Charr"] = "Baron Glutarr",
		["Princess Tempestria"] = "Prinzessin Tempestria",
		["Onyxia"] = "Onyxia",
		["Azuregos"] = "Azuregos",
		["Emeriss"] = "Smariss",
		["Taerar"] = "Taerar",
		["Lethon"] = "Lethon",
		["Lord Kazzak"] = "Lord Kazzak",
		["Ysondre"] = "Ysondre",
		["Ayamiss the Hunter"] = "Ayamiss der J\195\164ger",
		["Buru the Gorger"] = "Buru der Verschlinger",
		["General Rajaxx"] = "General Rajaxx",
		["Lieutenant General Andorov"] = "Generallieutenant Andorov",
		["Moam"] = "Moam",
		["Anubisath Guardian"] = "Besch\195\188tzer des Anubisath",
		["Ossirian the Unscarred"] = "Ossirian der Narbenlose",
		["Alzzin the Wildshaper"] = "Alzzin der Wildformer",
		["Ambassador Flamelash"] = "Botschafter Flammenschlag",
		["Anger'rel"] = "Anger'rel",
		["Archivist Galford"] = "Archivar Galford",
		["Bael'Gar"] = "Bael'Gar",
		["Balnazzar"] = "Balnazzar",
		["Baroness Anastari"] = "Baroness Anastari",
		["Baron Rivendare"] = "Baron Rivendare",
		["Captain Kromcrush"] = "Captain Kromcrush",
		["Crystal Fang"] = "Kristallfangzahn",
		["Darkmaster Gandling"] = "Dunkelmeister Gandling",
		["Doctor Theolen Krastinov"] = "Doktor Theolen Krastinov",
		["Doom'rel"] = "Un'rel",
		["Dope'rel"] = "Trott'rel",
		["Fineous Darkvire"] = "Fineous Dunkelader",
		["Gasher"] = "Gasher",
		["General Angerforge"] = "General Zornesschmied",
		["General Drakkisath"] = "General Drakkisath",
		["Gloom'rel"] = "Dunk'rel",
		["Golem Lord Argelmach"] = "Golemlord Argelmach",
		["Goraluk Anvilcrack"] = "Goraluk Hammerbruch",
		["Gyth"] = "Gyth",
		["Halycon"] = "Halycon",
		["Hate'rel"] = "Hass'rel",
		["Hearthsinger Forresten"] = "Herdsinger Forresten",
		["Highlord Omokk"] = "Hochlord Omokk",
		["Hukku"] = "Hukku",
		["Hurley Blackbreath"] = "Hurley Pestatem",
		["Hydrospawn"] = "Hydrobrut",
		["Illyanna Ravenoak"] = "Illyanna Ravenoak",
		["Immol'thar"] = "Immol'thar",
		["Instructor Malicia"] = "Instrukteurin Malicia",
		["Jandice Barov"] = "Jandice Barov",
		["Kirtonos the Herald"] = "Kirtonos der Herold",
		["Lady Illucia Barov"] = "Lady Illucia Barov",
		["Lethtendris"] = "Lethtendris",
		["Lorekeeper Polkelt"] = "H\195\188ter des Wissens Polkelt",
		["Loro"] = "Loro",
		["Magister Kalendris"] = "Magister Kalendris",
		["Magistrate Barthilas"] = "Magistrat Barthilas",
		["Magmus"] = "Magmus",
		["Maleki the Pallid"] = "Maleki der Leichenblasse",
		["Marduk Blackpool"] = "Marduk Blackpool",
		["Mijan"] = "Mijan",
		["Mother Smolderweb"] = "Mutter Glimmernetz",
		["Nerub'enkan"] = "Nerub'enkan",
		["Overlord Wyrmthalak"] = "Oberanf\195\188hrer Wyrmthalak",
		["Phalanx"] = "Phalanx",
		["Plugger Spazzring"] = "Plugger Spazzring",
		["Postmaster Malown"] = "Postmeister Malown",
		["Princess Moira Bronzebeard"] = "Prinzessin Moira Bronzebeard",
		["Prince Tortheldrin"] = "Prinz Tortheldrin",
		["Pusillin"] = "Pusillin",
		["Pyroguard Emberseer"] = "Feuerwache Glutseher",
		["Ramstein the Gorger"] = "Ramstein der Verschlinger",
		["Rattlegore"] = "Blutrippe",
		["Ribbly Screwspigot"] = "Ribbly Screwspigot",
		["Seeth'rel"] = "Wut'rel",
		["Solakar Flamewreath"] = "Solakar Feuerkrone",
		["Stomper Kreeg"] = "Stampfer Kreeg",
		["Tendris Warpwood"] = "Tendris Wucherborke",
		["Timmy the Cruel"] = "Timmy der Grausame",
		["Tsu'zee"] = "Tsu'zee",
		["Vectus"] = "Vectus",
		["Vile'rel"] = "B\195\182s'rel",
		["Zevrim Thornhoof"] = "Zevrim Dornhuf",
		["Zolo"] = "Zolo",
		["Zul'Lor"] = "Zul'Lor",
		["Cannon Master Willey"] = "Kanonenmeister Willey",
		["Emperor Dagran Thaurissan"] = "Imperator Dagran Thaurissan",
		["Guard Fengus"] = "Wache Fengus",
		["Guard Mol'dar"] = "Wache Mol'dar",
		["Guard Slip'kik"] = "Wache Slip'kik",
		["High Interrogator Gerstahn"] = "Verh\195\182rmeisterin Gerstahn",
		["King Gordok"] = "K\195\182nig Gordok",
		["Lord Alexei Barov"] = "Lord Alexei Barov",
		["Lord Incendius"] = "Lord Incendius",
		["Ras Frostwhisper"] = "Ras Frostraunen",
		["Warchief Rend Blackhand"] = "Kriegsh\195\164uptling Rend Schwarzfaust",
		["Shadow Hunter Vosh'gajin"] = "Schattenj\195\164gerin Vosh'gajin",
		["The Beast"] = "Die Bestie",
		["The Ravenian"] = "Der Ravenier",
		["War Master Voone"] = "Kriegsmeister Voone",

		-- From Mendeleev
		["Cho'Rush the Observer"] = "Cho'Rush der Beobachter",
		["Lord Hel'nurath"] = "Lord Hel'nurath",
		["Pimgib"] = "Pimgib",
		["Knot Thimblejack's Cache"] = "Knot Thimblejacks Truhe",
		["Archmage Arugal"] = "Erzmagier Arugal",
		["Archmage Arugal's Voidwalker"] = "Arugals Leerwandler",
		["Baron Silverlaine"] = "Baron Silverlane",
		["Commander Springvale"] = "Kommandant Springvale",
		["Deathsworn Captain"] = "Todesh\195\182riger Captain",
		["Fenrus the Devourer"] = "Fenrus der Verschlinger",
		["Odo the Blindwatcher"] = "Odo der Blindseher",
		["Razorclaw the Butcher"] = "Klingenklaue der Metzger",
		["Wolf Master Nandos"] = "Wolfmeister Nados",
		["Rend Blackhand"] = "Rend Schwarzfaust",
		["Kurinnaxx"] = "Kurinnaxx",

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct. 
		["Doom Lord Kazzak"] = "Verdammnislord Kazzak",
		["Doomwalker"] = "Doomwalker",

		-- Karazhan
		["Prince Malchezaar"] = "Prinz Malchezaar",
		["Attumen the Huntsman"] = "Attumen der J\195\164ger",
		["Midnight"] = "Mitternacht",
		["Hyakiss the Lurker"] = "Hyakiss the Lurker", --check
		["Rokad the Ravager"] = "Rokad the Ravager",
		["Shadikith the Glider"] = "Shadikith the Glider",
		["Moroes"] = "Moroes",
		["Maiden of Virtue"] = "Maiden of Virtue",
		["Dorothee"] = "Dorothee",
		["Tito"] = "Tito",
		["Tinhead"] = "Tinhead",
		["Strawman"] = "Strawman",
		["Roar"] = "Roar",
		["The Crone"] = "The Crone",
		["Romulo"] = "Romulo",
		["Julianne"] = "Julianne",
		["The Big Bad Wolf"] = "Der gro\195\159e b\195\182se Wolf",
		["The Curator"] = "The Curator", --check
		["Shade of Aran"] = "Shade of Aran", --check
		["Terestian Illhoof"] = "Terestian Illhoof",
		["Netherspite"] = "Netherspite",
		["Nightbane"] = "Nightbane",
		["King Llane Piece"] = "King Llane Piece",
		["Warchief Blackhand Piece"] = "Warchief Blackhand Piece",
		-- Caverns of Time
		--   Durnholde Keep
		["Lieutenant Drake"] = "Lieutenant Drake",
		["Captain Skarloc"] = "Captain Skarloc",
		["Epoch Hunter"] = "Epoch Hunter",
		--   The Black Morass
		["Medivh"] = "Medivh",
		["Chrono Lord Deja"] = "Chrono Lord Deja",
		["Temporus"] = "Temporus",
		["Aeonus"] = "Aeonus",
		--   XX
		["Archimonde"] = "Archimonde",
		-- Hellfire Ramparts
		["Watchkeeper Gargolmar"] = "Wachhabender Gargolmar",
		["Vazruden the Herald"] = "Vazruden der Herold",
		["Vazruden"] = "Vazruden",
		["Nazan"] ="Nazan",
		["Omor the Unscarred"] = "Omor der Narbenlose",
		-- The Blood Furnace
		["The Maker"] = "The Maker",
		["Broggok"] = "Broggok",
		["Keli'dan the Breaker"] = "Keli'dan der Zerst\195\182rer",
		-- The Shattered Halls
		["Kargath Bladefist"] = "Kargath Bladefist",
		["Grand Warlock Nethekurse"] = "Grand Warlock Nethekurse",
		["Warbringer O'mrogg"] = "Warbringer O'mrogg",
		-- Magtheridon's Lair
		["Magtheridon"] = "Magtheridon",
		-- The Slave Pens
		["Mennu the Betrayer"] = "Mennu the Betrayer",
		["Rokmar the Crackler"] = "Rokmar the Crackler",
		["Quagmirran"] = "Quagmirran",
		-- The Underbog
		["Hungarfen"] = "Hungarfen",
		["Ghaz'an"] = "Ghaz'an",
		["Overseer Tidewrath"] = "Overseer Tidewrath",
		["Claw"] = "Claw",
		["Swamplord Musel'ek"] = "Swamplord Musel'ek",
		["The Black Stalker"] = "The Black Stalker",
		-- The Steamvault
		["Hydromancer Thespia"] = "Hydromancer Thespia",
		["Mekgineer Steamrigger"] = "Mekgineer Steamrigger",
		["Warlord Kalithresh"] = "Warlord Kalithresh",
		-- Serpentshrine Cavern
		["Lady Vashj"] = "Lady Vashj",
		-- Mana Tombs
		["Pandemonius"] = "Pandemonius",
		["Tavarok"] = "Tavarok",
		["Nexus-Prince Shaffar"] = "Nexus-Prince Shaffar",
		-- Auchenai Crypts
		["Shirrak the Dead Watcher"] = "Shirrak the Dead Watcher",
		["Exarch Maladaar"] = "Exarch Maladaar",
		-- Sethekk Halls
		["Talon King Ikiss"] = "Talon King Ikiss",
		["Darkweaver Syth"] = "Darkweaver Syth",
		-- Shadow Labyrinth
		["Ambassador Hellmaw"] = "Ambassador Hellmaw",
		["Blackheart the Inciter"] = "Blackheart the Inciter",
		-- The Mechanar
		["Gatekeeper Gyro-Kill"] = "Gatekeeper Gyro-Kill",
		["Nethermancer Sepethrea"] = "Nethermancer Sepethrea",
		["Gatewatcher Iron-Hand"] = "Gatewatcher Iron-Hand",
		["Mechano-Lord Capacitus"] = "Mechano-Lord Capacitus",
		["Pathaleon the Calculator"] = "Pathaleon the Calculator",
		-- The Botanica
		["Commander Sarannis"] = "Commander Sarannis",
		["High Botanist Freywinn"] = "High Botanist Freywinn",
		["Thorngrin the Tender"] = "Thorngrin the Tender",
		["Laj"] = "Laj",
		["Warp Splinter"] = "Warp Splinter",
		-- The Arcatraz
		-- The Eye
		["Prince Kael'thas Sunstrider"] = "Prinz Kael'thas Sunstrider",
		-- Gruul's Lair
		["Gruul"] = "Gruul",
		-- Black Temple
		["Illidan Stormrage"] = "Illidan Stormrage",
		-- Ring of Blood
		["Brokentoe"] = "Brokentoe",
		["Murkblood Twin"] = "Murkblood Twin",
		["Murkblood Twins"] = "Murkblood Twins",
		["The Blue Brothers"] = "The Blue Brothers",
		["Rokdar the Sundered Lord"] = "Rokdar the Sundered Lord",
		["Skra'gath"] = "Skra'gath",
		["Warmaul Champion"] = "Warmaul Champion",
		["Mogor"] = "Mogor",

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = "Verteidiger des Anubisath",
		["Battleguard Sartura"] = "Schlachtwache Sartura",
		["C'Thun"] = "C'Thun",
		["Emperor Vek'lor"] = "Imperator Vek'lor",
		["Emperor Vek'nilash"] = "Imperator Vek'nilash",
		["Eye of C'Thun"] = "Auge von C'Thun",
		["Fankriss the Unyielding"] = "Fankriss der Unnachgiebige",
		["Lord Kri"] = "Lord Kri",
		["Ouro"] = "Ouro",
		["Princess Huhuran"] = "Prinzessin Huhuran",
		["Princess Yauj"] = "Prinzessin Yauj",
		["The Bug Family"] = "Die K\195\164ferfamilie",
		["The Prophet Skeram"] = "Der Prophet Skeram",
		["The Twin Emperors"] = "Die Zwillings-Imperatoren",
		["Vem"] = "Vem",
		["Viscidus"] = "Viscidus",

--Blackwing Lair
		["Broodlord Lashlayer"] = "Brutw\195\164chter Dreschbringer",
		["Chromaggus"] = "Chromaggus",
		["Ebonroc"] = "Schattenschwinge",
		["Firemaw"] = "Feuerschwinge",
		["Flamegor"] = "Flammenmaul",
		["Grethok the Controller"] = "Grethok der Aufseher",
		["Lord Victor Nefarius"] = "Lord Victor Nefarius",
		["Nefarian"] = "Nefarian",
		["Razorgore the Untamed"] = "Razorgore der Ungez\195\164hmte",
		["Vaelastrasz the Corrupt"] = "Vaelastrasz der Verdorbene",

--Maraudon
		["Celebras the Cursed"] = "Celebras der Verfluchte",
		["Landslide"] = "Erdrutsch",
		["Lord Vyletongue"] = "Lord Schlangenzunge",
		["Meshlok the Harvester"] = "Meshlok der Ernter",
		["Noxxion"] = "Noxxion",
		["Princess Theradras"] = "Prinzessin Theradras",
		["Razorlash"] = "Schlingwurzler",
		["Rotgrip"] = "Faulschnapper",
		["Tinkerer Gizlock"] = "T\195\188ftler Gizlock",

--Molten Core
		["Baron Geddon"] = "Baron Geddon",
		["Garr"] = "Garr",
		["Gehennas"] = "Gehennas",
		["Golemagg the Incinerator"] = "Golemagg der Verbrenner",
		["Lucifron"] = "Lucifron",
		["Magmadar"] = "Magmadar",
		["Majordomo Executus"] = "Majordomus Exekutus",
		["Ragnaros"] = "Ragnaros",
		["Shazzrah"] = "Shazzrah",
		["Sulfuron Harbinger"] = "Sulfuronherold",

--Naxxramas
		["Anub'Rekhan"] = "Anub'Rekhan",
		["Deathknight Understudy"] = "Reservist der Todesritter",
		["Feugen"] = "Feugen",
		["Gluth"] = "Gluth",
		["Gothik the Harvester"] = "Gothik der Seelenj\195\164ger",
		["Grand Widow Faerlina"] = "Gro\195\159witwe Faerlina",
		["Grobbulus"] = "Grobbulus",
		["Heigan the Unclean"] = "Heigan der Unreine",
		["Highlord Mograine"] = "Hochlord Mograine",
		["Instructor Razuvious"] = "Instrukteur Razuvious",
		["Kel'Thuzad"] = "Kel'Thuzad",
		["Lady Blaumeux"] = "Lady Blaumeux",
		["Loatheb"] = "Loatheb",
		["Maexxna"] = "Maexxna",
		["Noth the Plaguebringer"] = "Noth der Seuchenf\195\188rst",
		["Patchwerk"] = "Flickwerk",
		["Sapphiron"] = "Saphiron",
		["Sir Zeliek"] = "Sire Zeliek",
		["Stalagg"] = "Stalagg",
		["Thaddius"] = "Thaddius",
		["Thane Korth'azz"] = "Thane Korth'azz",
		["The Four Horsemen"]= "Die Vier Reiter",

--Ragefire Chasm
		["Bazzalan"] = "Bazzalan",
		["Jergosh the Invoker"] = "Jergosh der Herbeirufer",
		["Maur Grimtotem"] = "Maur Grimmtotem",
		["Taragaman the Hungerer"] = "Taragaman der Hungerleider",

--Scarlet Monastery
		["Arcanist Doan"] = "Arkanist Doan",
		["Azshir the Sleepless"] = "Azshir der Schlaflose",
		["Bloodmage Thalnos"] = "Blutmagier Thalnos",
		["Fallen Champion"] = "Gest\195\188rzter Held",
		["Herod"] = "Herod",
		["High Inquisitor Fairbanks"] = "Hochinquisitor Fairbanks",
		["High Inquisitor Whitemane"] = "Hochinquisitor Wei\195\159str\195\164hne",
		["Houndmaster Loksey"] = "Hundemeister Loksey",
		["Ironspine"] = "Eisenr\195\188cken",
		["Scarlet Commander Mograine"] = "Scarlet Commander Mograine",

--The Deadmines
		["Captain Greenskin"] = "Kapit\195\164n Gr\195\188nhaut",
		["Cookie"] = "Cookie",
		["Edwin VanCleef"] = "Edwin VanCleef",
		["Gilnid"] = "Gilnid",
		["Miner Johnson"] = "Minenarbeiter Johnson",
		["Mr. Smite"] = "Handlanger Pein",
		["Rhahk'Zor"] = "Rhahk'Zor",
		["Sneed"] = "Sneed",

--The Stockade
		["Bazil Thredd"] = "Bazil Thredd",
		["Bruegal Ironknuckle"] = "Bruegal Eisenfaust",
		["Dextren Ward"] = "Dextren Ward",
		["Hamhock"] = "Hamhock",
		["Kam Deepfury"] = "Kam Deepfury",
		["Targorr the Dread"] = "Targorr der Schreckliche",

--The Temple of Atal'Hakkar
		["Atal'alarion"] = "Atal'alarion",
		["Avatar of Hakkar"] = "Avatar von Hakkar",
		["Dreamscythe"] = "Traumsense",
		["Hazzas"] = "Hazzas",
		["Jammal'an the Prophet"] = "Jammal'an der Prophet",
		["Morphaz"] = "Morphaz",
		["Ogom the Wretched"] = "Ogom der Elende",
		["Shade of Eranikus"] = "Eranikus' Schemen",
		["Weaver"] = "Wirker",

--Uldaman
		["Ancient Stone Keeper"] = "Uralter Steinbewahrer",
		["Archaedas"] = "Archaedas",
		["Baelog"] = "Baelog",
		["Galgann Firehammer"] = "Galgann Feuerhammer",
		["Grimlok"] = "Grimlok",
		["Ironaya"] = "Ironaya",
		["Obsidian Sentinel"] = "Obsidianschildwache",
		["Revelosh"] = "Revelosh",

--Zul'Farrak
		["Antu'sul"] = "Antu'sul",
		["Chief Ukorz Sandscalp"] = "H\195\164uptling Ukorz Sandw\195\188ter",
		["Gahz'rilla"] = "Gahz'rilla",
		["Hydromancer Velratha"] = "Wasserbeschw\195\182rerin Velratha",
		["Nekrum Gutchewer"] = "Nekrum der Ausweider",
		["Ruuzlu"] = "Ruuzlu",
		["Sandfury Executioner"] = "Henker der Sandw\195\188ter",
		["Sergeant Bly"] = "Sergeant Bly",
		["Theka the Martyr"] = "Theka der M\195\164rtyrer",
		["Witch Doctor Zum'rah"] = "Hexendoktor Zum'rah" ,
		["Zerillis"] = "Zerillis",
		["Zul'Farrak Dead Hero"] = "Untoter Held aus Zul'Farrak",

--Zul'Gurub
		["Bloodlord Mandokir"] = "Blutf\195\188rst Mandokir",
		["Gahz'ranka"] = "Gahz'ranka",
		["Gri'lek"] = "Gri'lek",
		["Hakkar"] = "Hakkar",
		["Hazza'rah"] = "Hazza'rah",
		["High Priestess Arlokk"] = "Hohepriesterin Arlokk",
		["High Priestess Jeklik"] = "Hohepriesterin Jeklik",
		["High Priestess Mar'li"] = "Hohepriesterin Mar'li",
		["High Priest Thekal"] = "Hohepriester Thekal",
		["High Priest Venoxis"] = "Hohepriester Venoxis",
		["Jin'do the Hexxer"] = "Jin'do der Verhexer",
		["Renataki"] = "Renataki",
		["Wushoolay"] = "Wushoolay",
	} end)

BabbleBoss:RegisterTranslations("frFR", function() return {
		["Avalanchion"] = "Avalanchion",
		["The Windreaver"] = "Ouraganien",
		["Baron Charr"] = "Baron Charr",
		["Princess Tempestria"] = "Princesse Tempestria",
		["Onyxia"] = "Onyxia",
		["Azuregos"] = "Azuregos",
		["Lord Kazzak"] = "Seigneur Kazzak",
		["Ysondre"] = "Ysondre",
		["Emeriss"] = "Emeriss",
		["Taerar"] = "Taerar",
		["Lethon"] = "L\195\169thon",
		["Ayamiss the Hunter"] = "Ayamiss le Chasseur",
		["Buru the Gorger"] = "Buru Grandgosier",
		["General Rajaxx"] = "G\195\169n\195\169ral Rajaxx",
		["Lieutenant General Andorov"] = "G\195\169n\195\169ral de division Andorov",
		["Moam"] = "Moam",
		["Anubisath Guardian"] = "Gardien Anubisath",
		["Ossirian the Unscarred"] = "Ossirian l'Intouch\195\169",
		["Alzzin the Wildshaper"] = "Alzzin le Modeleur",
		["Ambassador Flamelash"] = "Ambassadeur Cinglefouet",
		["Anger'rel"] = "Col\195\169'rel",
		["Archivist Galford"] = "Archiviste Galford",
		["Bael'Gar"] = "Bael'Gar",
		["Balnazzar"] = "Balnazzar",
		["Baroness Anastari"] = "Baronne Anastari",
		["Baron Rivendare"] = "Baron Rivendare",
		["Cannon Master Willey"] = "Ma\195\174tre canonnier Willey",
		["Captain Kromcrush"] = "Capitaine Kromcrush",
		["Crystal Fang"] = "Croc cristallin",
		["Darkmaster Gandling"] = "Sombre Ma\195\174tre Gandling",
		["Doctor Theolen Krastinov"] = "Docteur Theolen Krastinov",
		["Doom'rel"] = "Tragi'rel",
		["Dope'rel"] = "Demeu'rel",
		["Emperor Dagran Thaurissan"] = "Empereur Dagran Thaurissan",
		["Fineous Darkvire"] = "Fineous Darkvire",
		["Gasher"] = "Gasher",
		["General Angerforge"] = "G\195\169n\195\169ral Forgehargne",
		["General Drakkisath"] = "G\195\169n\195\169ral Drakkisath",
		["Gloom'rel"] = "Fun\195\169b'rel",
		["Golem Lord Argelmach"] = "Seigneur golem Argelmach",
		["Goraluk Anvilcrack"] = "Goraluk Anvilcrack",
		["Guard Fengus"] = "Garde Fengus",
		["Guard Mol'dar"] = "Garde Mol'dar",
		["Guard Slip'kik"] = "Garde Slip'kik",
		["Gyth"] = "Gyth",
		["Halycon"] = "Halycon",
		["Hate'rel"] = "Haine'rel",
		["Hearthsinger Forresten"] = "Chanteloge Forrestin",
		["High Interrogator Gerstahn"] = "Grand Interrogateur Gerstahn",
		["Highlord Omokk"] = "G\195\169n\195\169ralissime Omokk",
		["Hukku"] = "Hukku",
		["Hurley Blackbreath"] = "Hurley Blackbreath",
		["Hydrospawn"] = "Hydrog\195\169nos",
		["Illyanna Ravenoak"] = "Illyanna Ravenoak",
		["Immol'thar"] = "Immol'thar",
		["Instructor Malicia"] = "Instructeur Malicia",
		["Jandice Barov"] = "Jandice Barov",
		["King Gordok"] = "Roi Gordok",
		["Kirtonos the Herald"] = "Kirtonos le H\195\169raut",
		["Lady Illucia Barov"] = "Dame Illucia Barov",
		["Lethtendris"] = "Lethtendris",
		["Lord Alexei Barov"] = "Seigneur Alexei Barov",
		["Lord Incendius"] = "Seigneur Incendius",
		["Lorekeeper Polkelt"] = "Gardien du savoir Polkelt",
		["Loro"] = "Loro",
		["Magister Kalendris"] = "Magist\195\168re Kalendris",
		["Magistrate Barthilas"] = "Magistrat Barthilas",
		["Magmus"] = "Magmus",
		["Maleki the Pallid"] = "Maleki le Blafard",
		["Marduk Blackpool"] = "Marduk Noir\195\169tang",
		["Mijan"] = "Mijan",
		["Mother Smolderweb"] = "Matriarche Couveuse",
		["Nerub'enkan"] = "Nerub'enkan",
		["Overlord Wyrmthalak"] = "Seigneur Wyrmthalak",
		["Phalanx"] = "Phalange",
		["Plugger Spazzring"] = "Plugger Spazzring",
		["Postmaster Malown"] = "Postier Malown",
		["Princess Moira Bronzebeard"] = "Princesse Moira Barbe-de-bronze",
		["Prince Tortheldrin"] = "Prince Tortheldrin",
		["Pusillin"] = "Pusillin",
		["Pyroguard Emberseer"] = "Pyrogarde Proph\195\168te ardent",
		["Ramstein the Gorger"] = "Ramstein Grandgosier",
		["Ras Frostwhisper"] = "Ras Murmegivre",
		["Rattlegore"] = "Cliquettripes",
		["Warchief Rend Blackhand"] = "Chef de guerre Rend Main-noire",
		["Ribbly Screwspigot"] = "Ribbly Screwspigot",
		["Seeth'rel"] = "Fulmi'rel",
		["Shadow Hunter Vosh'gajin"] = "Chasseresse des ombres Vosh'gajin",
		["Solakar Flamewreath"] = "Solakar Voluteflamme",
		["Stomper Kreeg"] = "Kreeg le Marteleur",
		["Tendris Warpwood"] = "Tendris Crochebois",
		["The Beast"] = "La B\195\170te",
		["The Ravenian"] = "Le Voracien",
		["Timmy the Cruel"] = "Timmy le Cruel",
		["Tsu'zee"] = "Tsu'zee",
		["Vectus"] = "Vectus",
		["Vile'rel"] = "Ignobl'rel",
		["War Master Voone"] = "Ma\195\174tre de guerre Voone",
		["Zevrim Thornhoof"] = "Zevrim Sabot-de-ronce",
		["Zolo"] = "Zolo",
		["Zul'Lor"] = "Zul'Lor",

		-- From Mendeleev
		["Cho'Rush the Observer"] = "Cho'Rush l'Observateur",
		["Lord Hel'nurath"] = "Seigneur Hel'nurath",
		["Pimgib"] = "Pimgib",
		["Knot Thimblejack's Cache"] = "R\195\169serve de Knot Thimblejack",
		["Archmage Arugal"] = "Archimage Arugal",
		["Archmage Arugal's Voidwalker"] = "Marcheur du Vide d'Arugal",
		["Baron Silverlaine"] = "Baron d'Argelaine",
		["Commander Springvale"] = "Commandant Springvale",
		["Deathsworn Captain"] = "Capitaine Ligemort",
		["Fenrus the Devourer"] = "Fenrus le D\195\169voreur",
		["Odo the Blindwatcher"] = "Odo l'Aveugle",
		["Razorclaw the Butcher"] = "Tranchegriffe le Boucher",
		["Wolf Master Nandos"] = "Ma\195\174tre-loup Nandos",
		["Kurinnaxx"] = "Kurinnaxx",

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct.
--		["Doom Lord Kazzak"] = true,
--		["Doomwalker"] = true,

		-- Karazhan
		["Prince Malchezaar"] = "Prince Malchezaar", --check
--		["Attumen the Huntsman"] = true,
--		["Midnight"] = true,
		["Hyakiss the Lurker"] = "Hyakiss the Lurker", --check
--		["Rokad the Ravager"] = true,
--		["Shadikith the Glider"] = true,
--		["Moroes"] = true,
--		["Maiden of Virtue"] = true,
--		["Dorothee"] = true,
--		["Tito"] = true,
--		["Tinhead"] = true,
--		["Strawman"] = true,
--		["Roar"] = true,
--		["The Crone"] = true,
--		["Romulo"] = true,
--		["Julianne"] = true,
--		["The Big Bad Wolf"] = true,
		["The Curator"] = "The Curator", --check
		["Shade of Aran"] = "Shade of Aran", --check
--		["Terestian Illhoof"] = true,
--		["Netherspite"] = true,
--		["Nightbane"] = true,
--		["King Llane Piece"] = true,
--		["Warchief Blackhand Piece"] = true,
		-- Caverns of Time
		--   Durnholde Keep
--		["Lieutenant Drake"] = true,
--		["Captain Skarloc"] = true,
--		["Epoch Hunter"] = true,
		--   The Black Morass
		["Medivh"] = "Medivh",
--		["Chrono Lord Deja"] = true,
--		["Temporus"] = true,
--		["Aeonus"] = true,
		--   XX
		["Archimonde"] = "Archimonde",
		-- Hellfire Ramparts (Remparts des Flammes infernales)
		["Watchkeeper Gargolmar"] = "Gardien des guetteurs Gargolmar",
		["Vazruden the Herald"] = "Vazruden le H\195\169raut",
		["Vazruden"] = "Vazruden",
		["Nazan"] = "Nazan",
		["Omor the Unscarred"] = "Omor l'Intouch\195\169",
		-- The Blood Furnace (La Fournaise du sang)
		["The Maker"] = "Le Faiseur",
		["Broggok"] = "Broggok",
		["Keli'dan the Breaker"] = "Keli'dan le Briseur",
		-- The Shattered Halls
--		["Kargath Bladefist"] = true,
--		["Grand Warlock Nethekurse"] = true,
--		["Warbringer O'mrogg"] = true,
		-- Magtheridon's Lair (Le repaire de Magtheridon)
		["Magtheridon"] = "Magtheridon",
		-- The Slave Pens (Les enclos aux esclaves)
		["Mennu the Betrayer"] = "Mennu le Tra\195\174tre",
		["Rokmar the Crackler"] = "Rokmar le Cr\195\169pitant",
		["Quagmirran"] = "Bourbierreux",
		-- The Underbog (La Basse-tourbière)
		["Hungarfen"] = "Hungarfen",
		["Ghaz'an"] = "Ghaz'an",
--		["Overseer Tidewrath"] = true,
		["Claw"] = "Griffe",
		["Swamplord Musel'ek"] = "Seigneur des marais Musel'ek",
		["The Black Stalker"] = "La Traqueuse noire",
		-- The Steamvault
--		["Hydromancer Thespia"] = true,
--		["Mekgineer Steamrigger"] = true,
--		["Warlord Kalithresh"] = true,
		-- Serpentshrine Cavern
--		["Lady Vashj"] = true,
		-- Mana Tombs (Tombes-mana)
		["Pandemonius"] = "Pandemonius",
		["Tavarok"] = "Tavarok",
		["Nexus-Prince Shaffar"] = "Prince-nexus Shaffar",
		-- Auchenai Crypts (Cryptes Auchenaï)
		["Shirrak the Dead Watcher"] = "Shirrak le Veillemort",
--		["Exarch Maladaar"] = true,
		-- Sethekk Halls
--		["Talon King Ikiss"] = true,
--		["Darkweaver Syth"] = true,
		-- Shadow Labyrinth
--		["Ambassador Hellmaw"] = true,
--		["Blackheart the Inciter"] = true,
		-- The Mechanar
--		["Gatekeeper Gyro-Kill"] = true,
--		["Nethermancer Sepethrea"] = true,
--		["Gatewatcher Iron-Hand"] = true,
--		["Mechano-Lord Capacitus"] = true,
--		["Pathaleon the Calculator"] = true,
		-- The Botanica
--		["Commander Sarannis"] = true,
--		["High Botanist Freywinn"] = true,
--		["Thorngrin the Tender"] = true,
--		["Laj"] = true,
--		["Warp Splinter"] = true,
		-- The Arcatraz
		-- The Eye
		["Prince Kael'thas Sunstrider"] = "Prince Kael'thas Haut-soleil",
		-- Gruul's Lair (Le repaire de Gruul)
		["Gruul"] = "Gruul",
		-- Black Temple (Temple noir)
		["Illidan Stormrage"] = "Illidan Hurlorage",
		-- Ring of Blood
--		["Brokentoe"] = true,
--		["Murkblood Twin"] = true,
--		["Murkblood Twins"] = true,
--		["The Blue Brothers"] = true,
--		["Rokdar the Sundered Lord"] = true,
--		["Skra'gath"] = true,
--		["Warmaul Champion"] = true,
--		["Mogor"] = true,

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = "D\195\169fenseur Anubisath",
		["Battleguard Sartura"] = "Garde de guerre Sartura",
		["C'Thun"] = "C'Thun",
		["Emperor Vek'lor"] = "Empereur Vek'lor",
		["Emperor Vek'nilash"] = "Empereur Vek'nilash",
		["Eye of C'Thun"] = "\197\146il de C'Thun",
		["Fankriss the Unyielding"] = "Fankriss l'Inflexible",
		["Lord Kri"] = "Seigneur Kri",
		["Ouro"] = "Ouro",
		["Princess Huhuran"] = "Princesse Huhuran",
		["Princess Yauj"] = "Princesse Yauj",
		["The Bug Family"] = "La famille insecte",
		["The Prophet Skeram"] = "Le Proph\195\168te Skeram",
		["The Twin Emperors"] = "Les Empereurs jumeaux",
		["Vem"] = "Vem",
		["Viscidus"] = "Viscidus",

--Blackwing Lair
		["Broodlord Lashlayer"] = "Seigneur des couv\195\169es Lanistaire",
		["Chromaggus"] = "Chromaggus",
		["Ebonroc"] = "Roch\195\169b\195\168ne",
		["Firemaw"] = "Gueule-de-feu",
		["Flamegor"] = "Flamegor",
		["Grethok the Controller"] = "Grethok le Contr\195\180leur",
		["Lord Victor Nefarius"] = "Seigneur Victor Nefarius",
		["Nefarian"] = "Nefarian",
		["Razorgore the Untamed"] = "Tranchetripe l'Indompt\195\169",
		["Vaelastrasz the Corrupt"] = "Vaelastrasz le Corrompu",

--Maraudon
		["Celebras the Cursed"] = "Celebras le Maudit",
		["Landslide"] = "Glissement de terrain",
		["Lord Vyletongue"] = "Seigneur Vylelangue",
		["Meshlok the Harvester"] = "Meshlok le Moissonneur",
		["Noxxion"] = "Noxxion",
		["Princess Theradras"] = "Princesse Theradras",
		["Razorlash"] = "Tranchefouet",
		["Rotgrip"] = "Grippe-charogne",
		["Tinkerer Gizlock"] = "Artisan Gizlock",

--Molten Core
		["Baron Geddon"] = "Baron Geddon",
		["Garr"] = "Garr",
		["Gehennas"] = "Gehennas",
		["Golemagg the Incinerator"] = "Golemagg l'Incin\195\169rateur",
		["Lucifron"] = "Lucifron",
		["Magmadar"] = "Magmadar",
		["Majordomo Executus"] = "Chambellan Executus",
		["Ragnaros"] = "Ragnaros",
		["Shazzrah"] = "Shazzrah",
		["Sulfuron Harbinger"] = "Messager de Sulfuron",

--Naxxramas
		["Anub'Rekhan"] = "Anub'Rekhan",
		["Deathknight Understudy"] = "Doublure de chevalier de la mort",
		["Feugen"] = "Feugen",
		["Gluth"] = "Gluth",
		["Gothik the Harvester"] = "Gothik le Moissonneur",
		["Grand Widow Faerlina"] = "Grande veuve Faerlina",
		["Grobbulus"] = "Grobbulus",
		["Heigan the Unclean"] = "Heigan l'Impur",
		["Highlord Mograine"] = "G\195\169n\195\169ralissime Mograine",
		["Instructor Razuvious"] = "Instructeur Razuvious",
		["Kel'Thuzad"] = "Kel'Thuzad",
		["Lady Blaumeux"] = "Dame Blaumeux",
		["Loatheb"] = "Horreb",
		["Maexxna"] = "Maexxna",
		["Noth the Plaguebringer"] ="Noth le Porte-peste",
		["Patchwerk"] = "Le Recousu",
		["Sapphiron"] = "Sapphiron",
		["Sir Zeliek"] = "Sire Zeliek ",
		["Stalagg"] = "Stalagg",
		["Thaddius"] = "Thaddius",
		["Thane Korth'azz"] = "Thane Korth'azz",
		["The Four Horsemen"] = "Les 4 Cavaliers",

--Ragefire Chasm
		["Bazzalan"] = "Bazzalan",
		["Jergosh the Invoker"] = "Jergosh l'Invocateur",
		["Maur Grimtotem"] = "Maur Totem-sinistre",
		["Taragaman the Hungerer"] = "Taragaman l'Affameur",

--Scarlet Monastery
		["Arcanist Doan"] = "Arcaniste Doan",
		["Azshir the Sleepless"] = "Azshir le Sans-sommeil",
		["Bloodmage Thalnos"] = "Mage de sang Thalnos",
		["Fallen Champion"] = "Champion mort",
		["Herod"] = "Herod",
		["High Inquisitor Fairbanks"] = "Grand Inquisiteur Fairbanks",
		["High Inquisitor Whitemane"] = "Grand Inquisiteur Whitemane",
		["Houndmaster Loksey"] = "Maître-chien Loksey",
		["Ironspine"] = "Echine-de-fer",
		["Scarlet Commander Mograine"] = "Commandant écarlate Mograine",

--The Deadmines
		["Captain Greenskin"] = "Capitaine Vertepeau",
		["Cookie"] = "Macaron",
		["Edwin VanCleef"] = "Edwin VanCleef",
		["Gilnid"] = "Gilnid",
		["Miner Johnson"] = "Mineur Johnson",
		["Mr. Smite"] = "M. Châtiment",
		["Rhahk'Zor"] = "Rhahk'Zor",
		["Sneed"] = "Sneed",

--The Stockade
		["Bazil Thredd"] = "Bazil Thredd",
		["Bruegal Ironknuckle"] = "Bruegal Ironknuckle",
		["Dextren Ward"] = "Dextren Ward",
		["Hamhock"] = "Hamhock",
		["Kam Deepfury"] = "Kam Deepfury",
		["Targorr the Dread"] = "Targorr le Terrifiant",

--The Temple of Atal'Hakkar
		["Atal'alarion"] = "Atal'alarion",
		["Avatar of Hakkar"] = "Avatar d'Hakkar",
		["Dreamscythe"] = "Fauche-r\195\170ve",
		["Hazzas"] = "Hazzas",
		["Jammal'an the Prophet"] = "Jammal'an le proph\195\168te",
		["Morphaz"] = "Morphaz",
		["Ogom the Wretched"] = "Ogom le Mis\195\169rable",
		["Shade of Eranikus"] = "Ombre d'Eranikus",
		["Weaver"] = "Tisserand",

--Uldaman
		["Ancient Stone Keeper"] = "Ancien Gardien des pierres",
		["Archaedas"] = "Archaedas",
		["Baelog"] = "Baelog",
		["Galgann Firehammer"] = "Galgann Firehammer",
		["Grimlok"] = "Grimlok",
		["Ironaya"] = "Ironaya",
		["Obsidian Sentinel"] = "Sentinelle d'obsidienne",
		["Revelosh"] = "Revelosh",

--Zul'Farrak
		["Antu'sul"] = "Antu'sul",
		["Chief Ukorz Sandscalp"] = "Chef Ukorz Scalpessable",
		["Gahz'rilla"] = "Gahz'rilla",
		["Hydromancer Velratha"] = "Hydromancienne Velratha",
		["Nekrum Gutchewer"] = "Nekrum Mâchetripes",
		["Ruuzlu"] = "Ruuzlu",
		["Sandfury Executioner"] = "Sandfury Executioner", 
		["Sergeant Bly"] = "Sergent Bly",
		["Theka the Martyr"] = "Theka le Martyr",
		["Witch Doctor Zum'rah"] = "Sorcier-docteur Zum'rah",
		["Zerillis"] = "Zerillis",
		["Zul'Farrak Dead Hero"] = "Héros mort de Zul'Farrak",

--Zul'Gurub
		["Bloodlord Mandokir"] = "Seigneur sanglant Mandokir",
		["Gahz'ranka"] = "Gahz'ranka",
		["Gri'lek"] = "Gri'lek",
		["Hakkar"] = "Hakkar",
		["Hazza'rah"] = "Hazza'rah",
		["High Priestess Arlokk"] = "Grande pr\195\170tresse Arlokk",
		["High Priestess Jeklik"] = "Grande pr\195\170tresse Jeklik",
		["High Priestess Mar'li"] = "Grande pr\195\170tresse Mar'li",
		["High Priest Thekal"] = "Grand pr\195\170tre Thekal",
		["High Priest Venoxis"] = "Grand pr\195\170tre Venoxis",
		["Jin'do the Hexxer"] = "Jin'do le Mal\195\169ficieur",
		["Renataki"] = "Renataki",
		["Wushoolay"] = "Wushoolay",
	} end)


BabbleBoss:RegisterTranslations("zhCN", function() return {
		["Avalanchion"] = "阿瓦兰奇奥",
		["The Windreaver"] = "烈风掠夺者",
		["Baron Charr"] = "火焰男爵查尔",
		["Princess Tempestria"] = "泰比斯蒂亚公主",
		["Onyxia"] = "奥妮克希亚",
		["Azuregos"] = "艾索雷葛斯",
		["Lord Kazzak"] = "卡扎克",
		["Ysondre"] = "伊森德雷",
		["Emeriss"] = "艾莫莉丝",
		["Taerar"] = "泰拉尔",
		["Lethon"] = "莱索恩",
		["Ayamiss the Hunter"] = "狩猎者阿亚米斯",
		["Buru the Gorger"] = "吞咽者布鲁",
		["General Rajaxx"] = "拉贾克斯将军",
		["Lieutenant General Andorov"] = "安多洛夫中将",
		["Moam"] = "莫阿姆",
		["Anubisath Guardian"] = "阿努比萨斯守卫者",
		["Ossirian the Unscarred"] = "无疤者奥斯里安",
		["Alzzin the Wildshaper"] = "奥兹恩",
		["Ambassador Flamelash"] = "弗莱拉斯大使",
		["Anger'rel"] = "安格雷尔",
		["Archivist Galford"] = "案管理员加尔福特",
		["Bael'Gar"] = "贝尔加",
		["Balnazzar"] = "巴纳扎尔",
		["Baroness Anastari"] = "安娜丝塔丽男爵夫人",
		["Baron Rivendare"] = "瑞文戴尔男爵",
		["Cannon Master Willey"] = "炮手威利",
		["Captain Kromcrush"] = "克罗卡斯",
		["Crystal Fang"] = "水晶之牙",
		["Darkmaster Gandling"] = "黑暗院长加丁",
		["Doctor Theolen Krastinov"] = "瑟尔林·卡斯迪诺夫教授",
		["Doom'rel"] = "杜姆雷尔",
		["Dope'rel"] = "多普雷尔",
		["Emperor Dagran Thaurissan"] = "达格兰·索瑞森大帝",
		["Fineous Darkvire"] = "弗诺斯·达克维尔",
		["Gasher"] = "加什尔",
		["General Angerforge"] = "安格弗将军",
		["General Drakkisath"] = "达基萨斯将军",
		["Gloom'rel"] = "格鲁雷尔",
		["Golem Lord Argelmach"] = "傀儡统帅阿格曼奇",
		["Goraluk Anvilcrack"] = "古拉鲁克",
		["Guard Fengus"] = "卫兵芬古斯",
		["Guard Mol'dar"] = "卫兵摩尔达",
		["Guard Slip'kik"] = "卫兵斯里基克",
		["Gyth"] = "盖斯",
		["Halycon"] = "哈雷肯",
		["Hate'rel"] = "黑特雷尔",
		["Hearthsinger Forresten"] = "弗雷斯特恩",
		["High Interrogator Gerstahn"] = "审讯官格斯塔恩",
		["Highlord Omokk"] = "欧莫克大王",
		["Hukku"] = "胡库",
		["Hurley Blackbreath"] = "霍尔雷·黑须",
		["Hydrospawn"] = "海多斯博恩",
		["Illyanna Ravenoak"] = "伊琳娜·暗木",
		["Immol'thar"] = "伊莫塔尔",
		["Instructor Malicia"] = "讲师玛丽希亚",
		["Jandice Barov"] = "詹迪斯·巴罗夫",
		["King Gordok"] = "戈多克大王",
		["Kirtonos the Herald"] = "传令官基尔图诺斯",
		["Lady Illucia Barov"] = "伊露希亚·巴罗夫",
		["Lethtendris"] = "蕾瑟塔蒂丝",
		["Lord Alexei Barov"] = "阿雷克斯·巴罗夫",
		["Lord Incendius"] = "伊森迪奥斯",
		["Lorekeeper Polkelt"] = "博学者普克尔特",
		["Loro"] = "洛若尔",
		["Magister Kalendris"] = "卡雷迪斯镇长",
		["Magistrate Barthilas"] = "巴瑟拉斯镇长",
		["Magmus"] = "玛格姆斯",
		["Maleki the Pallid"] = "苍白的玛勒基",
		["Marduk Blackpool"] = "马杜克·布莱克波尔",
		["Mijan"] = "米杉",
		["Mother Smolderweb"] = "烟网蛛后",
		["Nerub'enkan"] = "奈鲁布恩坎",
		["Overlord Wyrmthalak"] = "维姆萨拉克",
		["Phalanx"] = "法拉克斯",
		["Plugger Spazzring"] = "普拉格",
		["Postmaster Malown"] = "邮差马龙",
		["Princess Moira Bronzebeard"] = "铁炉堡公主茉艾拉·铜须",
		["Prince Tortheldrin"] = "托塞德林王子",
		["Pusillin"] = "普希林",
		["Pyroguard Emberseer"] = "烈焰卫士艾博希尔",
		["Ramstein the Gorger"] = "吞咽者拉姆斯登",
		["Ras Frostwhisper"] = "莱斯·霜语",
		["Rattlegore"] = "血骨傀儡",
		["Warchief Rend Blackhand"] = "雷德·黑手",
		["Ribbly Screwspigot"] = "雷布里·斯库比格特",
		["Seeth'rel"] = "西斯雷尔",
		["Shadow Hunter Vosh'gajin"] = "暗影猎手沃什加斯",
		["Solakar Flamewreath"] = "索拉卡·火冠",
		["Stomper Kreeg"] = "践踏者克雷格",
		["Tendris Warpwood"] = "特迪斯·扭木",
		["The Beast"] = "比斯巨兽",
		["The Ravenian"] = "拉文尼亚",
		["Timmy the Cruel"] = "悲惨的提米",
		["Tsu'zee"] = "苏斯",
		["Vectus"] = "维克图斯",
		["Vile'rel"] = "瓦勒雷尔",
		["War Master Voone"] = "指挥官沃恩",
		["Zevrim Thornhoof"] = "塔罗·刺蹄",
		["Zolo"] = "祖罗",
		["Zul'Lor"] = "祖罗尔",

		-- From Mendeleev 
		["Cho'Rush the Observer"] = "观察者克鲁什", 
		["Lord Hel'nurath"] = "赫尔努拉斯", 
		["Pimgib"] = "匹姆吉布", 
		["Knot Thimblejack's Cache"] = "诺特·希姆加克的储物箱", 
		["Cannonmaster Willey"] = "炮手威利", 
		["Emperor Dagran Thaurissian"] = "达格兰·索瑞森大帝", 
		["Archmage Arugal"] = "大法师阿鲁高", 
		["Archmage Arugal's Voidwalker"] = "阿鲁高的虚空行者", 
		["Baron Silverlaine"] = "席瓦莱恩男爵", 
		["Commander Springvale"] = "指挥官斯普林瓦尔", 
		["Deathsworn Captain"] = "死亡之誓", 
		["Fenrus the Devourer"] = "吞噬者芬鲁斯", 
		["Odo the Blindwatcher"] = "盲眼守卫奥杜", 
		["Razorclaw the Butcher"] = "屠夫拉佐克劳", 
		["Wolf Master Nandos"] = "狼王南杜斯", 
		["Rend Blackhand"] = "雷德·黑手", 
		["Kurinnaxx"] = "库林纳克斯",

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct.
--		["Doom Lord Kazzak"] = true,
--		["Doomwalker"] = true,
		-- Karazhan
		["Prince Malchezaar"] = "Prince Malchezaar", --check
--		["Attumen the Huntsman"] = true,
--		["Midnight"] = true,
		["Hyakiss the Lurker"] = "Hyakiss the Lurker", --check
--		["Rokad the Ravager"] = true,
--		["Shadikith the Glider"] = true,
--		["Moroes"] = true,
--		["Maiden of Virtue"] = true,
--		["Dorothee"] = true,
--		["Tito"] = true,
--		["Tinhead"] = true,
--		["Strawman"] = true,
--		["Roar"] = true,
--		["The Crone"] = true,
--		["Romulo"] = true,
--		["Julianne"] = true,
--		["The Big Bad Wolf"] = true,
		["The Curator"] = "The Curator", --check
		["Shade of Aran"] = "Shade of Aran", --check
--		["Terestian Illhoof"] = true,
--		["Netherspite"] = true,
--		["Nightbane"] = true,
--		["King Llane Piece"] = true,
--		["Warchief Blackhand Piece"] = true,
		-- Caverns of Time
		--   Durnholde Keep
--		["Lieutenant Drake"] = true,
--		["Captain Skarloc"] = true,
--		["Epoch Hunter"] = true,
		--   The Black Morass
--		["Medivh"] = true,
--		["Chrono Lord Deja"] = true,
--		["Temporus"] = true,
--		["Aeonus"] = true,
		--   XX
--		["Archimonde"] = true,
		-- Hellfire Ramparts
--		["Watchkeeper Gargolmar"] = true,
--		["Vazruden the Herald"] = true,
--		["Vazruden"] = true,
--		["Nazan"] = true,
--		["Omor the Unscarred"] = true,
		-- The Blood Furnace
--		["The Maker"] = true,
--		["Broggok"] = true,
--		["Keli'dan the Breaker"] = true,
		-- The Shattered Halls
--		["Kargath Bladefist"] = true,
--		["Grand Warlock Nethekurse"] = true,
--		["Warbringer O'mrogg"] = true,
		-- Magtheridon's Lair
--		["Magtheridon"] = true,
		-- The Slave Pens
--		["Mennu the Betrayer"] = true,
--		["Rokmar the Crackler"] = true,
--		["Quagmirran"] = true,
		-- The Underbog
--		["Hungarfen"] = true,
--		["Ghaz'an"] = true,
--		["Overseer Tidewrath"] = true,
--		["Claw"] = true,
--		["Swamplord Musel'ek"] = true,
--		["The Black Stalker"] = true,
		-- The Steamvault
--		["Hydromancer Thespia"] = true,
--		["Mekgineer Steamrigger"] = true,
--		["Warlord Kalithresh"] = true,
		-- Serpentshrine Cavern
--		["Lady Vashj"] = true,
		-- Mana Tombs
--		["Pandemonius"] = true,
--		["Tavarok"] = true,
--		["Nexus-Prince Shaffar"] = true,
		-- Auchenai Crypts
--		["Shirrak the Dead Watcher"] = true,
--		["Exarch Maladaar"] = true,
		-- Sethekk Halls
--		["Talon King Ikiss"] = true,
--		["Darkweaver Syth"] = true,
		-- Shadow Labyrinth
--		["Ambassador Hellmaw"] = true,
--		["Blackheart the Inciter"] = true,
		-- The Mechanar
--		["Gatekeeper Gyro-Kill"] = true,
--		["Nethermancer Sepethrea"] = true,
--		["Gatewatcher Iron-Hand"] = true,
--		["Mechano-Lord Capacitus"] = true,
--		["Pathaleon the Calculator"] = true,
		-- The Botanica
--		["Commander Sarannis"] = true,
--		["High Botanist Freywinn"] = true,
--		["Thorngrin the Tender"] = true,
--		["Laj"] = true,
--		["Warp Splinter"] = true,
		-- The Arcatraz
		-- The Eye
--		["Prince Kael'thas Sunstrider"] = true,
		-- Gruul's Lair
--		["Gruul"] = true,
		-- Black Temple
--		["Illidan Stormrage"] = true,
		-- Ring of Blood
--		["Brokentoe"] = true,
--		["Murkblood Twin"] = true,
--		["Murkblood Twins"] = true,
--		["The Blue Brothers"] = true,
--		["Rokdar the Sundered Lord"] = true,
--		["Skra'gath"] = true,
--		["Warmaul Champion"] = true,
--		["Mogor"] = true,

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = "阿努比萨斯防御者",
		["Battleguard Sartura"] = "沙尔图拉",
		["C'Thun"] = "克苏恩",
		["Emperor Vek'lor"] = "维克洛尔大帝",
		["Emperor Vek'nilash"] = "维克尼拉斯大帝",
		["Eye of C'Thun"] = "克苏恩之眼",
		["Fankriss the Unyielding"] = "顽强的范克瑞斯",
		["Lord Kri"] = "克里勋爵",
		["Ouro"] = "奥罗",
		["Princess Huhuran"] = "哈霍兰公主",
		["Princess Yauj"] = "亚尔基公主",
		["The Bug Family"] = "虫子一家",
		["The Prophet Skeram"] = "预言者斯克拉姆",
		["The Twin Emperors"] = "双子皇帝",
		["Vem"] = "维姆",
		["Viscidus"] = "维希度斯",

--Blackwing Lair
		["Broodlord Lashlayer"] = "勒什雷尔",
		["Chromaggus"] = "克洛玛古斯",
		["Ebonroc"] = "埃博诺克",
		["Firemaw"] = "费尔默",
		["Flamegor"] = "弗莱格尔",
		["Grethok the Controller"] = "黑翼控制者",
		["Lord Victor Nefarius"] = "维克多·奈法里奥斯",
		["Nefarian"] = "奈法利安",
		["Razorgore the Untamed"] = "狂野的拉佐格尔",
		["Vaelastrasz the Corrupt"] = "堕落的瓦拉斯塔兹",

--Maraudon
		["Celebras the Cursed"] = "被诅咒的塞雷布拉斯",
		["Landslide"] = "兰斯利德",
		["Lord Vyletongue"] = "维利塔恩",
		["Meshlok the Harvester"] = "收割者麦什洛克",
		["Noxxion"] = "诺克赛恩",
		["Princess Theradras"] = "瑟莱德丝公主",
		["Razorlash"] = "锐刺鞭笞者",
		["Rotgrip"] = "洛特格里普",
		["Tinkerer Gizlock"] = "工匠吉兹洛克",

--Molten Core
		["Baron Geddon"] = "迦顿男爵",
		["Garr"] = "加尔",
		["Gehennas"] = "基赫纳斯",
		["Golemagg the Incinerator"] = "焚化者古雷曼格",
		["Lucifron"] = "鲁西弗隆",
		["Magmadar"] = "玛格曼达",
		["Majordomo Executus"] = "管理者埃克索图斯",
		["Ragnaros"] = "拉格纳罗斯",
		["Shazzrah"] = "沙斯拉尔",
		["Sulfuron Harbinger"] = "萨弗隆先驱者",

--Naxxramas
		["Anub'Rekhan"] = "阿努布雷坎",
		["Deathknight Understudy"] = "见习死亡骑士",
		["Feugen"] = "费尔根",
		["Gluth"] = "格拉斯",
		["Gothik the Harvester"] = "收割者戈提克",
		["Grand Widow Faerlina"] = "黑女巫法琳娜",
		["Grobbulus"] = "格罗布鲁斯",
		["Heigan the Unclean"] = "肮脏的希尔盖",
		["Highlord Mograine"] = "大领主莫格莱尼",
		["Instructor Razuvious"] = "教官拉苏维奥斯",
		["Kel'Thuzad"] = "克尔苏加德",
		["Lady Blaumeux"] = "女公爵布劳缪克丝",
		["Loatheb"] = "洛欧塞布",
		["Maexxna"] = "迈克斯纳",
		["Noth the Plaguebringer"] ="瘟疫使者诺斯",
		["Patchwerk"] = "帕奇维克",
		["Sapphiron"] = "萨菲隆",
		["Sir Zeliek"] = "瑟里耶克爵士",
		["Stalagg"] = "斯塔拉格",
		["Thaddius"] = "塔迪乌斯",
		["Thane Korth'azz"] = "库尔塔兹领主",
		["The Four Horsemen"] = "四骑士",

--Ragefire Chasm
		["Bazzalan"] = "Bazzalan",
		["Jergosh the Invoker"] = "Jergosh the Invoker",
		["Maur Grimtotem"] = "Maur Grimtotem",
		["Taragaman the Hungerer"] = "Taragaman the Hungerer",

--Scarlet Monastery
		["Arcanist Doan"] = "Arcanist Doan",
		["Azshir the Sleepless"] = "Azshir the Sleepless",
		["Bloodmage Thalnos"] = "Bloodmage Thalnos",
		["Fallen Champion"] = "Fallen Champion",
		["Herod"] = "Herod",
		["High Inquisitor Fairbanks"] = "High Inquisitor Fairbanks",
		["High Inquisitor Whitemane"] = "High Inquisitor Whitemane",
		["Houndmaster Loksey"] = "Houndmaster Loksey",
		["Ironspine"] = "Ironspine",
		["Scarlet Commander Mograine"] = "Scarlet Commander Mograine",

--The Deadmines
		["Captain Greenskin"] = "Captain Greenskin",
		["Cookie"] = "Cookie",
		["Edwin VanCleef"] = "Edwin VanCleef",
		["Gilnid"] = "Gilnid",
		["Miner Johnson"] = "Miner Johnson",
		["Mr. Smite"] = "Mr. Smite",
		["Rhahk'Zor"] = "Rhahk'Zor",
		["Sneed"] = "Sneed",

--The Stockade
		["Bazil Thredd"] = "Bazil Thredd",
		["Bruegal Ironknuckle"] = "Bruegal Ironknuckle",
		["Dextren Ward"] = "Dextren Ward",
		["Hamhock"] = "Hamhock",
		["Kam Deepfury"] = "Kam Deepfury",
		["Targorr the Dread"] = "Targorr the Dread",

--The Temple of Atal'Hakkar
		["Atal'alarion"] = "阿塔拉利恩",
		["Avatar of Hakkar"] = "哈卡的化身",
		["Dreamscythe"] = "德姆塞卡尔",
		["Hazzas"] = "哈扎斯",
		["Jammal'an the Prophet"] = "预言者迦玛兰",
		["Morphaz"] = "摩弗拉斯",
		["Ogom the Wretched"] = "可悲的奥戈姆",
		["Shade of Eranikus"] = "伊兰尼库斯的阴影",
		["Weaver"] = "德拉维沃尔",

--Uldaman
		["Ancient Stone Keeper"] = "Ancient Stone Keeper",
		["Archaedas"] = "Archaedas",
		["Baelog"] = "Baelog",
		["Galgann Firehammer"] = "Galgann Firehammer",
		["Grimlok"] = "Grimlok",
		["Ironaya"] = "Ironaya",
		["Obsidian Sentinel"] = "Obsidian Sentinel",
		["Revelosh"] = "Revelosh",

--Zul'Farrak
		["Antu'sul"] = "Antu'sul",
		["Chief Ukorz Sandscalp"] = "Chief Ukorz Sandscalp",
		["Gahz'rilla"] = "Gahz'rilla",
		["Hydromancer Velratha"] = "Hydromancer Velratha",
		["Nekrum Gutchewer"] = "Nekrum Gutchewer",
		["Ruuzlu"] = "Ruuzlu",
		["Sandfury Executioner"] = "Sandfury Executioner",
		["Sergeant Bly"] = "Sergeant Bly",
		["Theka the Martyr"] = "Theka the Martyr",
		["Witch Doctor Zum'rah"] = "Hexendoktor Zum'rah" ,
		["Zerillis"] = "Zerillis",
		["Zul'Farrak Dead Hero"] = "Zul'Farrak Dead Hero",

--Zul'Gurub
		["Bloodlord Mandokir"] = "血领主曼多基尔",
		["Gahz'ranka"] = "加兹兰卡",
		["Gri'lek"] = "格里雷克",
		["Hakkar"] = "哈卡",
		["Hazza'rah"] = "哈扎拉尔",
		["High Priestess Arlokk"] = "高阶祭司娅尔罗",
		["High Priestess Jeklik"] = "高阶祭司耶克里克",
		["High Priestess Mar'li"] = "高阶祭司玛尔里",
		["High Priest Thekal"] = "高阶祭司塞卡尔",
		["High Priest Venoxis"] = "高阶祭司温诺希斯",
		["Jin'do the Hexxer"] = "妖术师金度",
		["Renataki"] = "雷纳塔基",
		["Wushoolay"] = "乌苏雷",
	} end)

BabbleBoss:RegisterTranslations("zhTW", function() return {
		["Avalanchion"] = "阿瓦蘭奇奧",
		["The Windreaver"] = "烈風掠奪者",
		["Baron Charr"] = "火焰男爵查爾",
		["Princess Tempestria"] = "泰比斯蒂亞公主",
		["Onyxia"] = "奧妮克希亞",
		["Azuregos"] = "艾索雷葛斯",
		["Lord Kazzak"] = "卡札克",
		["Ysondre"] = "伊索德雷",
		["Emeriss"] = "艾莫莉絲",
		["Taerar"] = "泰拉爾",
		["Lethon"] = "雷索",
		["Ayamiss the Hunter"] = "狩獵者阿亞米斯",
		["Buru the Gorger"] = "吞咽者布魯",
		["General Rajaxx"] = "拉賈克斯將軍",
		["Lieutenant General Andorov"] = "安多洛夫中將",
		["Moam"] = "莫阿姆",
		["Anubisath Guardian"] = "阿努比薩斯守衛者",
		["Ossirian the Unscarred"] = "無疤者奧斯里安",
		["Alzzin the Wildshaper"] = "奧茲恩",
		["Ambassador Flamelash"] = "弗萊拉斯大使",
		["Anger'rel"] = "安格雷爾",
		["Archivist Galford"] = "檔案管理員加爾福特",
		["Bael'Gar"] = "貝爾加",
		["Balnazzar"] = "巴納札爾",
		["Baroness Anastari"] = "安娜絲塔麗男爵夫人",
		["Baron Rivendare"] = "瑞文戴爾男爵",
		["Cannon Master Willey"] = "炮手威利",
		["Captain Kromcrush"] = "克羅卡斯",
		["Crystal Fang"] = "水晶之牙",
		["Darkmaster Gandling"] = "黑暗院長加丁",
		["Doctor Theolen Krastinov"] = "瑟爾林‧卡斯迪諾夫教授",
		["Doom'rel"] = "杜姆雷爾",
		["Dope'rel"] = "多普雷爾",
		["Emperor Dagran Thaurissan"] = "達格蘭‧索瑞森大帝",
		["Fineous Darkvire"] = "弗諾斯‧達克維爾",
		["Gasher"] = "加什爾",
		["General Angerforge"] = "安格弗將軍",
		["General Drakkisath"] = "達基薩斯將軍",
		["Gloom'rel"] = "格魯雷爾",
		["Golem Lord Argelmach"] = "傀儡統帥阿格曼奇",
		["Goraluk Anvilcrack"] = "古拉魯克",
		["Guard Fengus"] = "衛兵芬古斯",
		["Guard Mol'dar"] = "衛兵摩爾達",
		["Guard Slip'kik"] = "衛兵斯里基克",
		["Gyth"] = "蓋斯",
		["Halycon"] = "哈雷肯",
		["Hate'rel"] = "黑特雷爾",
		["Hearthsinger Forresten"] = "弗雷斯特恩",
		["High Interrogator Gerstahn"] = "審訊官格斯塔恩",
		["Highlord Omokk"] = "歐莫克大王",
		["Hukku"] = "胡庫",
		["Hurley Blackbreath"] = "霍爾雷‧黑鬚",
		["Hydrospawn"] = "海多斯博恩",
		["Illyanna Ravenoak"] = "伊琳娜‧暗木",
		["Immol'thar"] = "伊莫塔爾",
		["Instructor Malicia"] = "講師瑪麗希亞",
		["Jandice Barov"] = "詹迪斯‧巴羅夫",
		["King Gordok"] = "戈多克大王",
		["Kirtonos the Herald"] = "傳令官基爾圖諾斯",
		["Lady Illucia Barov"] = "伊露希亞‧巴羅夫",
		["Lethtendris"] = "蕾瑟塔蒂絲",
		["Lord Alexei Barov"] = "阿萊克斯‧巴羅夫",
		["Lord Incendius"] = "伊森迪奥斯",
		["Lorekeeper Polkelt"] = "博學者普克爾特",
		["Loro"] = "洛若爾",
		["Magister Kalendris"] = "卡雷迪斯鎮長",
		["Magistrate Barthilas"] = "巴瑟拉斯鎮長",
		["Magmus"] = "瑪格姆斯",
		["Maleki the Pallid"] = "蒼白的瑪勒基",
		["Marduk Blackpool"] = "馬杜克‧布萊克波爾",
		["Mijan"] = "米杉",
		["Mother Smolderweb"] = "煙網蛛后",
		["Nerub'enkan"] = "奈魯布恩坎",
		["Overlord Wyrmthalak"] = "維姆薩拉克",
		["Phalanx"] = "法拉克斯",
		["Plugger Spazzring"] = "普拉格",
		["Postmaster Malown"] = "郵差瑪羅恩",
		["Princess Moira Bronzebeard"] = "鐵爐堡公主茉艾拉‧銅鬚 ",
		["Prince Tortheldrin"] = "托塞德林王子",
		["Pusillin"] = "普希林",
		["Pyroguard Emberseer"] = "烈焰衛士艾博希爾",
		["Ramstein the Gorger"] = "吞咽者拉姆斯登",
		["Ras Frostwhisper"] = "萊斯‧霜語",
		["Rattlegore"] = "血骨傀儡",
		["Warchief Rend Blackhand"] = "大酋長雷德‧黑手",
		["Ribbly Screwspigot"] = "雷布里‧斯庫比格特",
		["Seeth'rel"] = "西斯雷爾",
		["Shadow Hunter Vosh'gajin"] = "暗影獵手沃許加斯",
		["Solakar Flamewreath"] = "索拉卡‧火冠",
		["Stomper Kreeg"] = "踐踏者克雷格",
		["Tendris Warpwood"] = "特迪斯‧扭木",
		["The Beast"] = "比斯巨獸",
		["The Ravenian"] = "拉文尼亞",
		["Timmy the Cruel"] = "悲慘的提米",
		["Tsu'zee"] = "蘇斯",
		["Vectus"] = "維克圖斯",
		["Vile'rel"] = "瓦勒雷爾",
		["War Master Voone"] = "指揮官沃恩",
		["Zevrim Thornhoof"] = "瑟雷姆‧刺蹄",
		["Zolo"] = "祖羅",
		["Zul'Lor"] = "祖羅爾",

		-- From Mendeleev
		["Cho'Rush the Observer"] = "觀察者克魯什",
		["Lord Hel'nurath"] = "赫爾努拉斯",
		["Pimgib"] = "匹姆吉布",
		["Knot Thimblejack's Cache"] = "諾特‧希姆加克的箱子",
		["Cannonmaster Willey"] = "炮手威利",
		["Archmage Arugal"] = "大法師阿魯高",
		["Archmage Arugal's Voidwalker"] = "大法師阿魯高的虛空行者",
		["Baron Silverlaine"] = "席瓦萊恩男爵",
		["Commander Springvale"] = "指揮官斯普林瓦爾",
		["Deathsworn Captain"] = "Deathsworn Captain",
		["Fenrus the Devourer"] = "吞噬者芬魯斯",
		["Odo the Blindwatcher"] = "盲眼守衛奧杜",
		["Razorclaw the Butcher"] = "屠夫拉佐克勞",
		["Wolf Master Nandos"] = "狼王南杜斯",
		["Rend Blackhand"] = "大酋長雷德‧黑手",
		["Kurinnaxx"] = "庫林納克斯",

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct.
--		["Doom Lord Kazzak"] = true,
--		["Doomwalker"] = true,

		-- Karazhan
		["Prince Malchezaar"] = "Prince Malchezaar", --check
--		["Attumen the Huntsman"] = true,
--		["Midnight"] = true,
		["Hyakiss the Lurker"] = "Hyakiss the Lurker", --check
--		["Rokad the Ravager"] = true,
--		["Shadikith the Glider"] = true,
--		["Moroes"] = true,
--		["Maiden of Virtue"] = true,
--		["Dorothee"] = true,
--		["Tito"] = true,
--		["Tinhead"] = true,
--		["Strawman"] = true,
--		["Roar"] = true,
--		["The Crone"] = true,
--		["Romulo"] = true,
--		["Julianne"] = true,
--		["The Big Bad Wolf"] = true,
		["The Curator"] = "The Curator", --check
		["Shade of Aran"] = "Shade of Aran", --check
--		["Terestian Illhoof"] = true,
--		["Netherspite"] = true,
--		["Nightbane"] = true,
--		["King Llane Piece"] = true,
--		["Warchief Blackhand Piece"] = true,
		-- Caverns of Time
		--   Durnholde Keep
--		["Lieutenant Drake"] = true,
--		["Captain Skarloc"] = true,
--		["Epoch Hunter"] = true,
		--   The Black Morass
--		["Medivh"] = true,
--		["Chrono Lord Deja"] = true,
--		["Temporus"] = true,
--		["Aeonus"] = true,
		--   XX
--		["Archimonde"] = true,
		-- Hellfire Ramparts
--		["Watchkeeper Gargolmar"] = true,
--		["Vazruden the Herald"] = true,
--		["Vazruden"] = true,
--		["Nazan"] = true,
--		["Omor the Unscarred"] = true,
		-- The Blood Furnace
--		["The Maker"] = true,
--		["Broggok"] = true,
--		["Keli'dan the Breaker"] = true,
		-- The Shattered Halls
--		["Kargath Bladefist"] = true,
--		["Grand Warlock Nethekurse"] = true,
--		["Warbringer O'mrogg"] = true,
		-- Magtheridon's Lair
--		["Magtheridon"] = true,
		-- The Slave Pens
--		["Mennu the Betrayer"] = true,
--		["Rokmar the Crackler"] = true,
--		["Quagmirran"] = true,
		-- The Underbog
--		["Hungarfen"] = true,
--		["Ghaz'an"] = true,
--		["Overseer Tidewrath"] = true,
--		["Claw"] = true,
--		["Swamplord Musel'ek"] = true,
--		["The Black Stalker"] = true,
		-- The Steamvault
--		["Hydromancer Thespia"] = true,
--		["Mekgineer Steamrigger"] = true,
--		["Warlord Kalithresh"] = true,
		-- Serpentshrine Cavern
--		["Lady Vashj"] = true,
		-- Mana Tombs
--		["Pandemonius"] = true,
--		["Tavarok"] = true,
--		["Nexus-Prince Shaffar"] = true,
		-- Auchenai Crypts
--		["Shirrak the Dead Watcher"] = true,
--		["Exarch Maladaar"] = true,
		-- Sethekk Halls
--		["Talon King Ikiss"] = true,
--		["Darkweaver Syth"] = true,
		-- Shadow Labyrinth
--		["Ambassador Hellmaw"] = true,
--		["Blackheart the Inciter"] = true,
		-- The Mechanar
--		["Gatekeeper Gyro-Kill"] = true,
--		["Nethermancer Sepethrea"] = true,
--		["Gatewatcher Iron-Hand"] = true,
--		["Mechano-Lord Capacitus"] = true,
--		["Pathaleon the Calculator"] = true,
		-- The Botanica
--		["Commander Sarannis"] = true,
--		["High Botanist Freywinn"] = true,
--		["Thorngrin the Tender"] = true,
--		["Laj"] = true,
--		["Warp Splinter"] = true,
		-- The Arcatraz
		-- The Eye
--		["Prince Kael'thas Sunstrider"] = true,
		-- Gruul's Lair
--		["Gruul"] = true,
		-- Black Temple
--		["Illidan Stormrage"] = true,
		-- Ring of Blood
--		["Brokentoe"] = true,
--		["Murkblood Twin"] = true,
--		["Murkblood Twins"] = true,
--		["The Blue Brothers"] = true,
--		["Rokdar the Sundered Lord"] = true,
--		["Skra'gath"] = true,
--		["Warmaul Champion"] = true,
--		["Mogor"] = true,

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = "阿努比薩斯防禦者",
		["Battleguard Sartura"] = "沙爾圖拉",
		["C'Thun"] = "克蘇恩",
		["Emperor Vek'lor"] = "維克洛爾大帝",
		["Emperor Vek'nilash"] = "維克尼拉斯大帝",
		["Eye of C'Thun"] = "克蘇恩之眼",
		["Fankriss the Unyielding"] = "頑強的范克里斯",
		["Lord Kri"] = "克里勳爵",
		["Ouro"] = "奧羅",
		["Princess Huhuran"] = "哈霍蘭公主",
		["Princess Yauj"] = "亞爾基公主",
		["The Bug Family"] = "蟲蟲家族",
		["The Prophet Skeram"] = "預言者斯克拉姆",
		["The Twin Emperors"] = "雙子皇帝",
		["Vem"] = "維姆",
		["Viscidus"] = "維希度斯",

--Blackwing Lair
		["Broodlord Lashlayer"] = "勒西雷爾",
		["Chromaggus"] = "克洛瑪古斯",
		["Ebonroc"] = "埃博諾克",
		["Firemaw"] = "費爾默",
		["Flamegor"] = "弗萊格爾",
		["Grethok the Controller"] = "黑翼控制者",
		["Lord Victor Nefarius"] = "奈法利斯",
		["Nefarian"] = "奈法利安",
		["Razorgore the Untamed"] = "狂野的拉佐格爾",
		["Vaelastrasz the Corrupt"] = "墮落的瓦拉斯塔茲",

--Maraudon
		["Celebras the Cursed"] = "被詛咒的塞雷布拉斯",
		["Landslide"] = "蘭斯利德",
		["Lord Vyletongue"] = "維利塔恩",
		["Meshlok the Harvester"] = "收割者麥什洛克",
		["Noxxion"] = "諾克賽恩",
		["Princess Theradras"] = "瑟萊德絲公主",
		["Razorlash"] = "銳刺鞭笞者",
		["Rotgrip"] = "洛特格里普",
		["Tinkerer Gizlock"] = "工匠吉茲洛克",

--Molten Core
		["Baron Geddon"] = "迦頓男爵",
		["Garr"] = "加爾",
		["Gehennas"] = "基赫納斯",
		["Golemagg the Incinerator"] = "焚化者古雷曼格",
		["Lucifron"] = "魯西弗隆",
		["Magmadar"] = "瑪格曼達",
		["Majordomo Executus"] = "管理者埃克索圖斯",
		["Ragnaros"] = "拉格納羅斯",
		["Shazzrah"] = "沙斯拉爾",
		["Sulfuron Harbinger"] = "薩弗隆先驅者",

--Naxxramas
		["Anub'Rekhan"] = "阿努比瑞克漢",
		["Deathknight Understudy"] = "死亡騎士實習者",
		["Feugen"] = "費爾根",
		["Gluth"] = "古魯斯",
		["Gothik the Harvester"] = "收割者高希",
		["Grand Widow Faerlina"] = "大寡婦費琳娜",
		["Grobbulus"] = "葛羅巴斯",
		["Heigan the Unclean"] = "骯髒者海根",
		["Highlord Mograine"] = "莫格萊尼公爵",
		["Instructor Razuvious"] = "講師拉祖維斯",
		["Kel'Thuzad"] = "科爾蘇加德",
		["Lady Blaumeux"] = "布洛莫斯爵士",
		["Loatheb"] = "洛斯伯",
		["Maexxna"] = "梅克絲娜",
		["Noth the Plaguebringer"] ="瘟疫者諾斯",
		["Patchwerk"] = "縫補者",
		["Sapphiron"] = "薩菲隆",
		["Sir Zeliek"] = "札里克爵士",
		["Stalagg"] = "斯塔拉格",
		["Thaddius"] = "泰迪斯",
		["Thane Korth'azz"] = "寇斯艾茲族長",
		["The Four Horsemen"] = "四騎士",

--Ragefire Chasm
		["Bazzalan"] = "巴紮蘭",
		["Jergosh the Invoker"] = "祈求者耶戈什",
		["Maur Grimtotem"] = "瑪爾·恐怖圖騰",
		["Taragaman the Hungerer"] = "饑餓者塔拉加曼",

--Scarlet Monastery
		["Arcanist Doan"] = "祕法師杜安",
		["Azshir the Sleepless"] = "永醒的艾希爾",
		["Bloodmage Thalnos"] = "血法師薩爾諾斯",
		["Fallen Champion"] = "死靈勇士",
		["Herod"] = "赫洛德",
		["High Inquisitor Fairbanks"] = "大檢察官法爾班克斯",
		["High Inquisitor Whitemane"] = "大檢察官懷特邁恩",
		["Houndmaster Loksey"] = "馴犬者洛克希",
		["Ironspine"] = "鐵脊死靈",
		["Scarlet Commander Mograine"] = "血色十字軍指揮官莫格萊尼",

--The Deadmines
		["Captain Greenskin"] = "綠皮隊長",
		["Cookie"] = "曲奇",
		["Edwin VanCleef"] = "艾德溫·范克里夫",
		["Gilnid"] = "基爾尼格",
		["Miner Johnson"] = "礦工約翰森",
		["Mr. Smite"] = "重拳先生",
		["Rhahk'Zor"] = "拉克佐",
		["Sneed"] = "斯尼德",

--The Stockade
		["Bazil Thredd"] = "巴基爾·斯瑞德",
		["Bruegal Ironknuckle"] = "布魯戈·艾爾克納寇",
		["Dextren Ward"] = "迪克斯特·瓦德",
		["Hamhock"] = "哈姆霍克",
		["Kam Deepfury"] = "卡姆·深怒",
		["Targorr the Dread"] = "可怕的塔高爾",

--The Temple of Atal'Hakkar
		["Atal'alarion"] = "阿塔拉利恩",
		["Avatar of Hakkar"] = "哈卡的化身",
		["Dreamscythe"] = "德姆塞卡爾",
		["Hazzas"] = "哈扎斯",
		["Jammal'an the Prophet"] = "預言者迦瑪蘭",
		["Morphaz"] = "摩弗拉斯",
		["Ogom the Wretched"] = "可悲的奧戈姆",
		["Shade of Eranikus"] = "伊蘭尼庫斯的陰影",
		["Weaver"] = "德拉維沃爾",

--Uldaman
		["Ancient Stone Keeper"] = "古代的石頭看守者",
		["Archaedas"] = "阿札達斯",
		["Baelog"] = "巴爾洛戈",
		["Galgann Firehammer"] = "加加恩·火錘",
		["Grimlok"] = "格瑞姆洛克",
		["Ironaya"] = "艾隆納亞",
		["Obsidian Sentinel"] = "黑曜石哨兵",
		["Revelosh"] = "魯維羅什",

--Zul'Farrak
		["Antu'sul"] = "安圖蘇爾",
		["Chief Ukorz Sandscalp"] = "烏克茲·沙頂",
		["Gahz'rilla"] = "加茲瑞拉",
		["Hydromancer Velratha"] = "水占師維蕾薩",
		["Nekrum Gutchewer"] = "耐克魯姆",
		["Ruuzlu"] = "盧茲魯",
		["Sandfury Executioner"] = "沙怒劊子手",
		["Sergeant Bly"] = "布萊中士",
		["Theka the Martyr"] = "殉教者塞卡",
		["Witch Doctor Zum'rah"] = "巫醫祖穆拉恩" ,
		["Zerillis"] = "澤雷利斯",
		["Zul'Farrak Dead Hero"] = "祖爾法拉克陣亡英雄",

--Zul'Gurub
		["Bloodlord Mandokir"] = "血領主曼多基爾",
		["Gahz'ranka"] = "加茲蘭卡",
		["Gri'lek"] = "格里雷克",
		["Hakkar"] = "哈卡",
		["Hazza'rah"] = "哈札拉爾",
		["High Priestess Arlokk"] = "哈卡萊先知",
		["High Priestess Jeklik"] = "高階祭司耶克里克",
		["High Priestess Mar'li"] = "哈卡萊安魂者",
		["High Priest Thekal"] = "古拉巴什食腐者",
		["High Priest Venoxis"] = "高階祭司溫諾希斯",
		["Jin'do the Hexxer"] = "妖術師金度",
		["Renataki"] = "雷納塔基",
		["Wushoolay"] = "烏蘇雷",
	} end)

BabbleBoss:RegisterTranslations("koKR", function() return {
		["Avalanchion"] = "아발란치온",
		["The Windreaver"] = "칼날바람",
		["Baron Charr"] = "남작 차르",
		["Princess Tempestria"] = "공주 템페스트리아",
		["Onyxia"] = "오닉시아",
		["Azuregos"] = "아주어고스",
		["Lord Kazzak"] = "군주 카자크",
		["Ysondre"] = "이손드레",
		["Emeriss"] = "에메리스",
		["Taerar"] = "타에라",
		["Lethon"] = "레손",
		["Ayamiss the Hunter"] = "사냥꾼 아야미스",
		["Buru the Gorger"] = "먹보 부루",
		["General Rajaxx"] = "장군 라작스",
		["Lieutenant General Andorov"] = "사령관 안도로브",
		["Moam"] = "모암",
		["Anubisath Guardian"] = "아누비사스 감시자",
		["Ossirian the Unscarred"] = "무적의 오시리안",
		["Alzzin the Wildshaper"] = "칼날바람 알진",
		["Ambassador Flamelash"] = "사자 화염채찍",
		["Anger'rel"] = "Anger'rel",
		["Archivist Galford"] = "기록관 갈포드",
		["Bael'Gar"] = "벨가르",
		["Balnazzar"] = "발나자르",
		["Baroness Anastari"] = "남작부인 아나스타리",
		["Baron Rivendare"] = "남작 리븐데어",
		["Cannon Master Willey"] = "포병대장 윌리",
		["Captain Kromcrush"] = "대장 크롬크러쉬",
		["Crystal Fang"] = "수정 맹독 거미",
		["Darkmaster Gandling"] = "암흑스승 간틀링",
		["Doctor Theolen Krastinov"] = "학자 테올린 크라스티노브",
		["Doom'rel"] = "운명의 문지기",
		["Dope'rel"] = "최면의 문지기",
		["Emperor Dagran Thaurissan"] = "제왕 다그란 타우릿산",
		["Fineous Darkvire"] = "파이너스 다크바이어",
		["Gasher"] = "게이셔",
		["General Angerforge"] = "사령관 앵거포지",
		["General Drakkisath"] = "사령관 드라키사스",
		["Gloom'rel"] = "그늘의 문지기",
		["Golem Lord Argelmach"] = "골렘군주 아젤마크",
		["Goraluk Anvilcrack"] = "고랄루크 앤빌크랙",
		["Guard Fengus"] = "경비병 펜구스",
		["Guard Mol'dar"] = "경비병 몰다르",
		["Guard Slip'kik"] = "경기병 슬립킥",
		["Gyth"] = "기스",
		["Halycon"] = "할리콘",
		["Hate'rel"] = "증오의 문지기",
		["Hearthsinger Forresten"] = "하스싱어 포레스턴",
		["High Interrogator Gerstahn"] = "대심문관 게르스탄",
		["Highlord Omokk"] = "대군주 오모크",
		["Hukku"] = "후쿠",
		["Hurley Blackbreath"] = "헐레이 블랙브레스",
		["Hydrospawn"] = "히드로스폰",
		["Illyanna Ravenoak"] = "일샨나 레이븐호크",
		["Immol'thar"] = "이몰타르",
		["Instructor Malicia"] = "조교 말리시아",
		["Jandice Barov"] = "잔다이스 바로브",
		["King Gordok"] = "왕 고르독",
		["Kirtonos the Herald"] = "사자 키르토노스",
		["Lady Illucia Barov"] = "여군주 일루시아 바로브",
		["Lethtendris"] = "레스텐드리스",
		["Lord Alexei Barov"] = "군주 알렉세이 바로브",
		["Lord Incendius"] = "군주 인센디우스",
		["Lorekeeper Polkelt"] = "현자 폴켈트",
		["Loro"] = "로로",
		["Magister Kalendris"] = "마법사 칼렌드리스",
		["Magistrate Barthilas"] = "집정관 바실라스",
		["Magmus"] = "마그무스",
		["Maleki the Pallid"] = "냉혈한 말레키",
		["Marduk Blackpool"] = "마르두크 블랙풀",
		["Mijan"] = "마이잔",
		["Mother Smolderweb"] = "여왕 불그물거미",
		["Nerub'enkan"] = "네룹엔칸",
		["Overlord Wyrmthalak"] = "대군주 윔타라크",
		["Phalanx"] = "팔란스",
		["Plugger Spazzring"] = "플러거스파즈링",
		["Postmaster Malown"] = "우체국장 말로운",
		["Princess Moira Bronzebeard"] = "공주 모이라 브론즈비어드",
		["Prince Tortheldrin"] = "왕자 토르텔드린",
		["Pusillin"] = "푸실린",
		["Pyroguard Emberseer"] = "불의 수호자 엠버시어",
		["Ramstein the Gorger"] = "먹보 람스타인",
		["Ras Frostwhisper"] = "라스 프로스트위스퍼",
		["Rattlegore"] = "들창어금니",
		["Warchief Rend Blackhand"] = "대족장 랜드 블랜핸드",
		["Ribbly Screwspigot"] = "리블리 스크류스피곳",
		["Seeth'rel"] = "불안의 문지기",
		["Shadow Hunter Vosh'gajin"] = "어둠사냥꾼 보쉬가진",
		["Solakar Flamewreath"] = "화염고리 솔라카르",
		["Stomper Kreeg"] = "천둥발 크리그",
		["Tendris Warpwood"] = "굽이나무 텐드리스",
		["The Beast"] = "괴수",
		["The Ravenian"] = "라베니안",
		["Timmy the Cruel"] = "잔혹한 티미",
		["Tsu'zee"] = "츄지",
		["Vectus"] = "벡투스",
		["Vile'rel"] = "타락의 문지기",
		["War Master Voone"] = "대장군 부네",
		["Zevrim Thornhoof"] = "제브림 쏜후프",
		["Zolo"] = "졸로",
		["Zul'Lor"] = "줄로",

		-- From Mendeleev
		["Cho'Rush the Observer"] = "정찰병 초루쉬",
		["Lord Hel'nurath"] = "군주 헬누라스",
		["Pimgib"] = "핌기브",
		["Knot Thimblejack's Cache"] = "노트 팀블젝의 Cache", -- check
		["Cannonmaster Willey"] = "포병대장 윌리",
		["Emperor Dagran Thaurissian"] = "제왕 다그란 타우릿산",
		["Archmage Arugal"] = "대마법사 아루갈",
		["Archmage Arugal's Voidwalker"] = "아루갈의 보이드워커",
		["Baron Silverlaine"] = "남작 실버레인",
		["Commander Springvale"] = "사령관 스프링베일",
		["Deathsworn Captain"] = "Deathsworn Captain", -- check
		["Fenrus the Devourer"] = "파멸의 펜루스",
		["Odo the Blindwatcher"] = "눈먼감시자 오도",
		["Razorclaw the Butcher"] = "도살자 칼날발톱", -- check
		["Wolf Master Nandos"] = "늑대왕 난도스",
		["Rend Blackhand"] = "대족장 렌드 블랙핸드",
		["Kurinnaxx"] = "쿠린낙스",

		-- OUTLANDS
		-- XXX: These are subject to change and may not be correct.
--		["Doom Lord Kazzak"] = true,
--		["Doomwalker"] = true,
		-- Karazhan
		["Prince Malchezaar"] = "Prince Malchezaar", -- check
		["Attumen the Huntsman"] = "Attumen the Huntsman", -- check
		["Midnight"] = "Midnight", -- check
		["Hyakiss the Lurker"] = "Hyakiss the Lurker", -- check
		["Rokad the Ravager"] = "Rokad the Ravager", -- check
		["Shadikith the Glider"] = "Shadikith the Glider", -- check
		["Moroes"] = "Moroes", -- check
		["Maiden of Virtue"] = "Maiden of Virtue", -- check
		["Dorothee"] = "Dorothee", -- check
		["Tito"] = "Tito", -- check
		["Tinhead"] = "Tinhead", -- check
		["Strawman"] = "Strawman", -- check
		["Roar"] = "Roar", -- check
		["The Crone"] = "The Crone", -- check
		["Romulo"] = "Romulo", -- check
		["Julianne"] = "Julianne", -- check
		["The Big Bad Wolf"] = "The Big Bad Wolf", -- check
		["The Curator"] = "The Curator", -- check
		["Shade of Aran"] = "Shade of Aran", -- check
		["Terestian Illhoof"] = "Terestian Illhoof", -- check
		["Netherspite"] = "Netherspite", -- check
		["Nightbane"] = "Nightbane", -- check
		["King Llane Piece"] = "King Llane Piece", -- check
		["Warchief Blackhand Piece"] = "Warchief Blackhand Piece", -- check
		-- Caverns of Time
		["Lieutenant Drake"] = "부관 드레이크",
		["Captain Skarloc"] = "경비대장 스칼록",
		["Epoch Hunter"] = "시대의 사냥꾼",
		--   The Black Morass
--		["Medivh"] = true,
--		["Chrono Lord Deja"] = true,
--		["Temporus"] = true,
--		["Aeonus"] = true,
		--   XX
		["Archimonde"] = "아키몬드",
		-- Hellfire Ramparts
		["Watchkeeper Gargolmar"] = "감시자 가르골마르",
--		["Vazruden the Herald"] = true,
		["Vazruden"] = "바즈루덴",
--		["Nazan"] = true,
		["Omor the Unscarred"] = "무적의 오모르",
		-- The Blood Furnace
		["The Maker"] = "재앙의 창조자",
		["Broggok"] = "브로고크",
		["Keli'dan the Breaker"] = "파괴자 켈리단",
		-- The Shattered Halls
--		["Kargath Bladefist"] = true,
--		["Grand Warlock Nethekurse"] = true,
--		["Warbringer O'mrogg"] = true,
		-- Magtheridon's Lair
		["Magtheridon"] = "마그테리돈",
		-- The Slave Pens
		["Mennu the Betrayer"] = "배반자 멘누",
		["Rokmar the Crackler"] = "딱딱이 로크마르",
		["Quagmirran"] = "쿠아그미란",
		-- The Underbog
		["Hungarfen"] = "헝가르펜",
		["Ghaz'an"] = "가즈안",
		["Overseer Tidewrath"] = "우두머리 성난파도",
		["Claw"] = "클로",
		["Swamplord Musel'ek"] = "늪군주 뮤즐레크",
		["The Black Stalker"] = "검은 추적자",
		-- The Steamvault
--		["Hydromancer Thespia"] = true,
--		["Mekgineer Steamrigger"] = true,
--		["Warlord Kalithresh"] = true,
		-- Serpentshrine Cavern
		["Lady Vashj"] = "여군주 바쉬",
		-- Mana Tombs
		["Pandemonius"] = "팬더모니우스",
		["Tavarok"] = "타바로크",
--		["Nexus-Prince Shaffar"] = true,
		-- Auchenai Crypts
--		["Shirrak the Dead Watcher"] = true,
		["Exarch Maladaar"] = "총독 말라다르",
		-- Sethekk Halls
		["Talon King Ikiss"] = "갈퀴대왕 이키스",
		["Darkweaver Syth"] = "흑마술사 시스",
		-- Shadow Labyrinth
--		["Ambassador Hellmaw"] = true,
--		["Blackheart the Inciter"] = true,
		-- The Mechanar
--		["Gatekeeper Gyro-Kill"] = true,
--		["Nethermancer Sepethrea"] = true,
--		["Gatewatcher Iron-Hand"] = true,
--		["Mechano-Lord Capacitus"] = true,
--		["Pathaleon the Calculator"] = true,
		-- The Botanica
--		["Commander Sarannis"] = true,
--		["High Botanist Freywinn"] = true,
--		["Thorngrin the Tender"] = true,
--		["Laj"] = true,
--		["Warp Splinter"] = true,
		-- The Arcatraz
		-- The Eye
--		["Prince Kael'thas Sunstrider"] = true,
		-- Gruul's Lair
		["Gruul"] = "그룰",
		-- Black Temple
		["Illidan Stormrage"] = "일리단 스톰레이지",
		-- Ring of Blood
--		["Brokentoe"] = true,
		["Murkblood Twin"] = "수렁피일족 쌍둥이",
		["Murkblood Twins"] = "수렁피일족 쌍둥이",
--		["The Blue Brothers"] = true,
		["Rokdar the Sundered Lord"] = "파괴의 군주 로크다르",
		["Skra'gath"] = "스크라가스",
		["Warmaul Champion"] = "전쟁망치일족 용사",
		["Mogor"] = "모고르",

--[[    New Format Separator    ]]

--Ahn'Qiraj
		["Anubisath Defender"] = "아누비사스 문지기",
		["Battleguard Sartura"] = "전투감시병 살투라",
		["C'Thun"] = "쑨",
		["Emperor Vek'lor"] = "제왕 베클로어",
		["Emperor Vek'nilash"] = "제왕 베크닐라쉬",
		["Eye of C'Thun"] = "쑨의 눈",
		["Fankriss the Unyielding"] = "불굴의 판크리스",
		["Lord Kri"] = "군주 크리",
		["Ouro"] = "아우로",
		["Princess Huhuran"] = "공주 후후란",
		["Princess Yauj"] = "공주 야우즈",
		["The Bug Family"] = "벌레 무리",
		["The Prophet Skeram"] = "예언자 스케람",
		["The Twin Emperors"] = "쌍둥이 제왕",
		["Vem"] = "벰",
		["Viscidus"] = "비시디우스",

--Blackwing Lair
		["Broodlord Lashlayer"] = "용기대장 래쉬레이어",
		["Chromaggus"] = "크로마구스",
		["Ebonroc"] = "에본로크",
		["Firemaw"] = "화염아귀",
		["Flamegor"] = "플레임고르",
		["Grethok the Controller"] = "감시자 그레토크",
		["Lord Victor Nefarius"] = "군주 빅터 네파리우스",
		["Nefarian"] = "네파리안",
		["Razorgore the Untamed"] = "폭군 서슬송곳니",
		["Vaelastrasz the Corrupt"] = "타락한 밸라스트라즈",

--Maraudon
		["Celebras the Cursed"] = "저주받은 셀레브라스",
		["Landslide"] = "산사태",
		["Lord Vyletongue"] = "군주 바일텅",
		["Meshlok the Harvester"] = "정원사 메슬로크",
		["Noxxion"] = "녹시온",
		["Princess Theradras"] = "공주 테라드라스",
		["Razorlash"] = "칼날채찍",
		["Rotgrip"] = "썩은 아귀",
		["Tinkerer Gizlock"] = "땜장이 기즐록",

--Molten Core
		["Baron Geddon"] = "남작 게돈",
		["Garr"] = "가르",
		["Gehennas"] = "게헨나스",
		["Golemagg the Incinerator"] = "초열의 골레마그",
		["Lucifron"] = "루시프론",
		["Magmadar"] = "마그마다르",
		["Majordomo Executus"] = "청지기 이그젝큐투스",
		["Ragnaros"] = "라그나로스",
		["Shazzrah"] = "샤즈라",
		["Sulfuron Harbinger"] = "설퍼론 사자",

--Naxxramas
		["Anub'Rekhan"] = "아눕레칸",
		["Deathknight Understudy"] = "죽음의 기사 수습생",
		["Feugen"] = "퓨진",
		["Gluth"] = "글루스",
		["Gothik the Harvester"] = "영혼의 착취자 고딕",
		["Grand Widow Faerlina"] = "귀부인 팰리나",
		["Grobbulus"] = "그라불루스",
		["Heigan the Unclean"] = "부정의 헤이건",
		["Highlord Mograine"] = "대영주 모그레인",
		["Instructor Razuvious"] = "훈련교관 라주비어스",
		["Kel'Thuzad"] = "켈투자드",
		["Lady Blaumeux"] = "여군주 블라미우스",
		["Loatheb"] = "로데브",
		["Maexxna"] = "맥스나",
		["Noth the Plaguebringer"] ="역병술사 노스",
		["Patchwerk"] = "패치워크",
		["Sapphiron"] = "사피론",
		["Sir Zeliek"] = "젤리에크 경",
		["Stalagg"] = "스탈라그",
		["Thaddius"] = "타디우스",
		["Thane Korth'azz"] = "영주 코스아즈",
		["The Four Horsemen"] = "4인의 기병대",

--Ragefire Chasm
		["Bazzalan"] = "바잘란",
		["Jergosh the Invoker"] = "기원사 제로쉬",
		["Maur Grimtotem"] = "마우르 그림토템",
		["Taragaman the Hungerer"] = "욕망의 타라가만",

--Scarlet Monastery
		["Arcanist Doan"] = "신비술사 도안",
		["Azshir the Sleepless"] = "잠들지 않는 아즈시르",
		["Bloodmage Thalnos"] = "혈법사 탈노스",
		["Fallen Champion"] = "타락한 용사",
		["Herod"] = "헤로드",
		["High Inquisitor Fairbanks"] = "종교재판관 페어뱅크스",
		["High Inquisitor Whitemane"] = "종교재판관 화이트메인",
		["Houndmaster Loksey"] = "사냥개 조련사 록시",
		["Ironspine"] = "무쇠해골",
		["Scarlet Commander Mograine"] = "붉은십자군 사령관 모그레인",

--The Deadmines
		["Captain Greenskin"] = "선장 그린스킨",
		["Cookie"] = "쿠키",
		["Edwin VanCleef"] = "에드윈 벤클리프",
		["Gilnid"] = "길니드",
		["Miner Johnson"] = "광부 존슨",
		["Mr. Smite"] = "미스터 스마이트",
		["Rhahk'Zor"] = "라크조르",
		["Sneed"] = "스니드",

--The Stockade
		["Bazil Thredd"] = "바질 스레드",
		["Bruegal Ironknuckle"] = "무쇠주먹 브루갈",
		["Dextren Ward"] = "덱스트렌 워드",
		["Hamhock"] = "햄혹",
		["Kam Deepfury"] = "캄 딥퓨리",
		["Targorr the Dread"] = "흉악범 타고르",

--The Temple of Atal'Hakkar
		["Atal'alarion"] = "아탈알라리온",
		["Avatar of Hakkar"] = "학카르의 화신",
		["Dreamscythe"] = "드림사이드",
		["Hazzas"] = "하자스",
		["Jammal'an the Prophet"] = "예언자 잠말란",
		["Morphaz"] = "몰파즈",
		["Ogom the Wretched"] = "비운의 오그옴",
		["Shade of Eranikus"] = "에라니쿠스의 사령",
		["Weaver"] = "위버",

--Uldaman
		["Ancient Stone Keeper"] = "고대 바위 문지기",
		["Archaedas"] = "아카에다스",
		["Baelog"] = "밸로그",
		["Galgann Firehammer"] = "갈간 파이어해머",
		["Grimlok"] = "그림로크",
		["Ironaya"] = "아이로나야",
		["Obsidian Sentinel"] = "흑요석 파수꾼",
		["Revelosh"] = "레벨로쉬",

--Zul'Farrak
		["Antu'sul"] = "안투술",
		["Chief Ukorz Sandscalp"] = "족장 우코르즈 샌드스칼프",
		["Gahz'rilla"] = "가즈릴라",
		["Hydromancer Velratha"] = "유체술사 벨라타",
		["Nekrum Gutchewer"] = "네크룸 거트츄어",
		["Ruuzlu"] = "루즐루",
		["Sandfury Executioner"] = "성난모래부족 사형집행인",
		["Sergeant Bly"] = "하사관 블라이",
		["Theka the Martyr"] = "순교자 데카",
		["Witch Doctor Zum'rah"] = "의술사 줌라",
		["Zerillis"] = "제릴리스",
		["Zul'Farrak Dead Hero"] = "줄파락 죽음의 영웅",

--Zul'Gurub
		["Bloodlord Mandokir"] = "혈군주 만도키르",
		["Gahz'ranka"] = "가즈란카",
		["Gri'lek"] = "그리렉",
		["Hakkar"] = "학카르",
		["Hazza'rah"] = "하자라",
		["High Priestess Arlokk"] = "대여사제 알로크",
		["High Priestess Jeklik"] = "대여사제 제클릭",
		["High Priestess Mar'li"] = "대여사제 말리",
		["High Priest Thekal"] = "대사제 데칼",
		["High Priest Venoxis"] = "대사제 베녹시스",
		["Jin'do the Hexxer"] = "주술사 진도",
		["Renataki"] = "레나타키",
		["Wushoolay"] = "우슬레이",
	} end)

BabbleBoss:RegisterTranslations("esES", function() return {
--you know you want to add it ;)
	} end)

BabbleBoss:Debug()
BabbleBoss:SetStrictness(true)

AceLibrary:Register(BabbleBoss, MAJOR_VERSION, MINOR_VERSION)
BabbleBoss = nil
