--
-- ZubanLib Library Functions
-- Version: 20000.r1
-- Author: Zuban (chumpnet@hotmail.com)
--

ZubanLib = {};

--
-- class Object
--

ZubanLib.Object = {};

function ZubanLib.Object:New(object)
	object = object or {};
	setmetatable(object, self);
	self.__index = self;
	return object;
end

function ZubanLib.Object:ToString()
	return tostring(self);
end

function ZubanLib.Object:Clone()
	return ZubanLib.Clone(self);
end

function ZubanLib.Object:GetType()
	return type(self);
end

function ZubanLib.Object:Write()
	ZubanLib.IO:WriteTable(self);
end

--
-- Util functions
--

-- 
-- http://lua-users.org/wiki/RetiredLuaFaq
--
function ZubanLib.Clone(t)	-- return a copy of the table t
	local new = {};		-- create a new table
	local i, v = next(t, nil);	-- i is an index of t, v = t[i]

	while i do
		if (type(v) == "table") then
			v = ZubanLib.Clone(v);
		end
	
		new[i] = v;
		i, v = next(t, i);	-- get next index
	end
	
	return new;
end

--
-- class Events
--

ZubanLib.Events = ZubanLib.Object:New{
	OnToggleBackpack = {};
	OnPickupContainerItem = {};
	OnPickupInventoryItem = {};
	OnPickupAction = {};
	OnPickupSpell = {};
	OnPickupPetAction = {}; -- warning: this event fires both on pickup and when dropped onto action bar
};

function ZubanLib.Events:Add(event, delegate)
	table.insert(self[event], delegate);
	return self[event];
end

function ZubanLib.Events:Fire(event, sender, args)
	local key, value;
	
	for key, value in next, self[event] do
		if (type(value) == "function") then
			value(sender, args);
		end
	end
end

--[[
function ZubanLib.Events.OnInit.Test1(sender, args)
	ZubanLib.IO.Chat:Write("event test 1".." "..tostring(sender));
end

function ZubanLib.Events.OnInit.Test2(sender, args)
	ZubanLib.IO.Chat:Write("event test 2".." "..tostring(sender));
end
]]

--
-- Frame XML functions
--

ZubanLib.Frame = ZubanLib.Object:New{
};

function ZubanLib.Frame:OnLoad()
	--[[
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("PLAYER_LOGIN");
	this:SetScript("OnEvent",
		function()
			if (event == "VARIABLES_LOADED") then
				self:OnVariablesLoaded();
				return;
			end
			if (event == "PLAYER_LOGIN") then
				self:OnPlayerLogin();
				return;
			end
		end
	);
	]]
	
	-- hookup cursor events
	
	hooksecurefunc("PickupContainerItem",
		function(bag, slot)
			if (CursorHasItem()) then
				ZubanLib.Events:Fire("OnPickupContainerItem", ZubanLib.Cursor, {Bag=bag, Slot=slot});
			end
		end
	);

	hooksecurefunc("PickupInventoryItem",
		function(slot)
			if (CursorHasItem()) then
				ZubanLib.Events:Fire("OnPickupInventoryItem", ZubanLib.Cursor, {Slot=slot});
			end
		end
	);

	hooksecurefunc("PickupSpell",
		function(id, bookType)
			if (CursorHasSpell()) then
				ZubanLib.Events:Fire("OnPickupSpell", ZubanLib.Cursor, {ID=id, BookType=bookType});
			end
		end
	);

	hooksecurefunc("PickupSpell",
		function()
			ZubanLib.Events:Fire("OnToggleBackpack", ZubanLib.Container);
		end
	);

	--[[
	hooksecurefunc("PickupAction",
		function(slot)
			ZubanLib.Events:Fire("OnPickupAction", ZubanLib.Cursor, {Slot=slot});
		end
	);

	hooksecurefunc("PickupPetAction",
		function(slot)
			ZubanLib.Events:Fire("OnPickupPetAction", ZubanLib.Cursor, {Slot=slot});
		end
	);
	]]
	
	-- setup slash command
	SLASH_ZUBANLIB1 = "/zubanlib";
	SLASH_ZUBANLIB2 = "/zl";
	SlashCmdList["ZUBANLIB"] = function(command)
		self:OnCommand(command);
	end
end

--[[
function ZubanLib.Frame:OnVariablesLoaded()
end

function ZubanLib.Frame:OnPlayerLogin()
end
]]

function ZubanLib.Frame:OnCommand(command)
	ZubanLib.IO.Chat:Write("ZubanLib: Stub: command="..tostring(command));
end
