--
-- ZubanLib Library Functions
-- Author: Zuban (chumpnet@hotmail.com)
--

-- 
-- class IO
--

ZubanLib.IO = ZubanLib.Object:New{
	Frame = DEFAULT_CHAT_FRAME;
	HoldTime = nil;
}

-- aliases for the lazy people like me
function ZubanLib.W(message)
	return ZubanLib.IO.Chat:Write(message);
end

-- write table
function ZubanLib.WT(t)
	return ZubanLib.IO:WriteTable(t);
end

function ZubanLib.IO:Warn(message)
	self:Write(message, 1, 0.2, 0.2);
end

function ZubanLib.IO:Write(message, red, green, blue, alpha)
	if (not red) then
		red = 1;
	end
    
	if (not green) then
		green = 1;
	end

	if (not blue) then
		blue = 1;
	end

	if (not alpha) then
		alpha = 1;
	end
	
	self.Frame:AddMessage(tostring(message), red, green, blue, alpha, self.HoldTime);	
end

function ZubanLib.IO.WritePair(key, value)
	ZubanLib.IO.Chat:Write("["..tostring(key).."] = "..tostring(value));
end

function ZubanLib.IO.WriteTablePair(key, value)
	ZubanLib.IO.WritePair(key, value);
	
	if (type(value) == "table") then
		ZubanLib.IO:WriteTable(value);
	end
end

function ZubanLib.IO:WriteTable(t)
	if (t ~= nil and type(t) == "table") then
		table.foreach(t, ZubanLib.IO.WriteTablePair);
	end
end

function ZubanLib.IO:WriteAttributes(t)
	if (t ~= nil and t.Attributes ~= nil) then
		self:WriteTable(t.Attributes);
	end
end

ZubanLib.IO.Chat = ZubanLib.IO:New{
	Frame = DEFAULT_CHAT_FRAME;
	HoldTime = nil;
};

ZubanLib.IO.Combat = ZubanLib.IO:New{
	Frame = ChatFrame2;
	HoldTime = nil;
};

ZubanLib.IO.Screen = ZubanLib.IO:New{
	Frame = UIErrorsFrame;
	HoldTime = UIERRORS_HOLD_TIME;
};
