--
-- ZubanLib Library Functions
-- Author: Zuban (chumpnet@hotmail.com)
--

-- 
-- class Cursor
--

-- stores extra cursor values
ZubanLib.Cursor = ZubanLib.Object:New{
	Attributes = {};
};

function ZubanLib.Cursor:Write()
	ZubanLib.IO:Write("Attributes:");
	ZubanLib.IO:WriteAttributes(self);
end

function ZubanLib.Cursor:Clear()
	self.Attributes = {};
end

--[[
-- fire OnPickupAction

local BasePickupAction = PickupAction;

function PickupAction(slot)
	ZubanLib.Events:Fire("OnPickupAction", ZubanLib.Cursor, {Slot=slot});
	return BasePickupAction(slot);
end

-- fire OnPickupPetAction

local BasePickupPetAction = PickupPetAction;

function PickupPetAction(slot)
	ZubanLib.Events:Fire("OnPickupPetAction", ZubanLib.Cursor, {Slot=slot});
	return BasePickupPetAction(slot);
end
]]

--
-- Event Handlers
--

function ZubanLib.Events.OnPickupContainerItem.Pickup(sender, args)
	local bag = args.Bag;
	local slot = args.Slot;
	local link = GetContainerItemLink(bag, slot);
	local texture, itemcount, locked, quality, readable = GetContainerItemInfo(bag, slot);
	local name, _, rarity, level, minLevel, type, subType, stackCount, equipLoc, _ = GetItemInfo(link);

	sender:Clear();
	sender.Attributes.Location = "Container";
	sender.Attributes.Link = link;
	sender.Attributes.Bag = bag;
	sender.Attributes.Slot = slot;
	sender.Attributes.Texture = texture;
	sender.Attributes.Count = itemcount;
	sender.Attributes.Locked = locked;
	sender.Attributes.Quality = quality;
	sender.Attributes.Readable = readable;

	sender.Attributes.Name = name;
	sender.Attributes.Rarity = rarity;
	sender.Attributes.Level = level;
	sender.Attributes.MinLevel = minLevel;
	sender.Attributes.Type = type;
	sender.Attributes.SubType = subType;
	sender.Attributes.StackCount = stackCount;
	sender.Attributes.EquipLoc = equipLoc;
	
	--sender:Write();
end

function ZubanLib.Events.OnPickupInventoryItem.Pickup(sender, args)
	local slot = args.Slot;
	local link = GetInventoryItemLink("player", slot);
	local name, link, rarity, level, minLevel, type, subType, stackCount, equipLoc, texture = GetItemInfo(link);
	local itemcount = GetInventoryItemCount("player", slot);
	local quality = GetInventoryItemQuality("player", slot);
	local locked = IsInventoryItemLocked(slot);
	local broken = GetInventoryItemBroken("player", slot)
	
	sender:Clear();
	sender.Attributes.Location = "Inventory";
	sender.Attributes.Link = link;
	sender.Attributes.Slot = slot;
	sender.Attributes.Texture = texture;
	sender.Attributes.Count = itemcount;
	sender.Attributes.Locked = locked;
	sender.Attributes.Quality = quality;
	sender.Attributes.Broken = broken;

	sender.Attributes.Name = name;
	sender.Attributes.Rarity = rarity;
	sender.Attributes.Level = level;
	sender.Attributes.MinLevel = minLevel;
	sender.Attributes.Type = type;
	sender.Attributes.SubType = subType;
	sender.Attributes.StackCount = stackCount;
	sender.Attributes.EquipLoc = equipLoc;
	sender.Attributes.Texture = texture;
	
	--sender:Write();
end

function ZubanLib.Events.OnPickupAction.Pickup(sender, args)
	local slot = args.Slot;
	local count = GetActionCount(slot);
	local text = GetActionText(slot);
	local texture = GetActionTexture(slot);

	sender:Clear();
	sender.Attributes.Location = "Action";
	sender.Attributes.Slot = slot;
	sender.Attributes.Count = count;
	sender.Attributes.Text = text;
	sender.Attributes.Texture = texture;

	if (GameTooltip ~= nil) then
		ZubanLibActionTip:SetOwner(WorldFrame,"ANCHOR_NONE");
		ZubanLibActionTipTextLeft1:SetText("");
		ZubanLibActionTipTextRight1:SetText(""); -- clear the rank
		ZubanLibActionTip:SetAction(slot);

		local name = ZubanLibActionTipTextLeft1:GetText();
		local rank = ZubanLibActionTipTextRight1:GetText();
	
		sender.Attributes.Name = name;
		sender.Attributes.Rank = rank;
	
		--[[
		local lines = GameTooltip:NumLines();
		sender.Attributes.Lines = lines;

		for i = 1, lines do
			textLeft = getglobal("GameTooltipTextLeft"..i);
			if (textLeft ~= nil) then
				sender.Attributes["Left"..i] = textLeft:GetText();
			end
			
			textRight = getglobal("GameTooltipTextRight"..i);
			if (textRight ~= nil) then
				sender.Attributes["Right"..i] = textRight:GetText();
			end
		end
		]]
	end
	
	--sender:Write();
end

function ZubanLib.Events.OnPickupSpell.Pickup(sender, args)
	local id = args.ID;
	local bookType = args.BookType;
	local name, rank = GetSpellName(id, bookType);
	local texture = GetSpellTexture(id, bookType);
	--local start, duration, enable = GetSpellCooldown (id, bookType);
	--local passive = IsSpellPassive(id, bookType);
	
	sender:Clear();
	sender.Attributes.Location = "Spell";
	sender.Attributes.ID = id;
	sender.Attributes.BookType = bookType;
	sender.Attributes.Name = name;
	sender.Attributes.Rank = rank;
	sender.Attributes.Texture = texture;
	--sender.Attributes.Start = start;
	--sender.Attributes.Duration = duration;
	--sender.Attributes.Enable = enable;
	--sender.Attributes.Passive = passive;

	--sender:Write();
end

-- warning: this event fires both on pickup and when dropped onto action bar

function ZubanLib.Events.OnPickupPetAction.Pickup(sender, args)
	local slot = args.Slot;
	local name, rank, texture, isToken, isActive, autoCastAllowed, autoCastEnabled = GetPetActionInfo(slot);
	
	sender:Clear();
	sender.Attributes.Location = "PetAction";
	sender.Attributes.Slot = slot;
	sender.Attributes.Name = name;
	sender.Attributes.Rank = rank;
	sender.Attributes.Texture = texture;
	sender.Attributes.IsToken = isToken;
	sender.Attributes.IsActive = isActive;
	sender.Attributes.AutoCastEnabled = autoCastEnabled;
	sender.Attributes.AutoCastAllowed = autoCastAllowed;
	
	--sender:Write();
end