﻿-- declard color codes for console messages
local RED     = "|cffff0000";
local GREEN   = "|cff00ff00";
local BLUE    = "|cff0000ff";
local MAGENTA = "|cffff00ff";
local YELLOW  = "|cffffff00";
local CYAN    = "|cff00ffff";
local WHITE   = "|cffffffff";
local ORANGE  = "|cffffba00";

-- global variables
known_times = {};
activeTransitName = "";
activeSelect = 1;
activeTransit = -1;
zsm_lowestNameTime = "--";
zsm_Icon = "ZeppelinMasterLogo";
zsm_activeData = { [0] = 0, [1] = 0 };
zsm_tempText = "";
zsm_tempTextCount = 0;
zsm_doNow = false;

-- local variables
local vars_loaded = false;
local update_int = 0.8;
local ctime_elapse = 0;
local oldx, oldy = 0, 0;
local lastcheck = 0;
local lastcheck_timeout = 10;
local dataChannel = "ZeppelinMaster";
local Pre_ChatFrame_OnEvent;
local ZSM_version = "1.93";
local protoVersion = "1.7";
local varsVersion = 1.0;
local newVerAvail = false;
local req_timeout;
local known_times_req = {};
local dropdownvalues = {};
local dropdownindex = {};

local prox = 1;
local debug = false;

local alarmSet = false;
local alarmDinged = false;
local alarmOffset = 20;
local alarmCountdown = 0;


function ZSM_OnLoad()

	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("CHAT_MSG_CHANNEL");
	this:RegisterEvent("ZONE_CHANGED_NEW_AREA");
	this:RegisterEvent("CHAT_MSG_SYSTEM");
	this:RegisterEvent("CHAT_MSG_CHANNEL_JOIN");
	this:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE");

	-- register slash command
	SLASH_ZSM1 = "/zsm";
	SLASH_ZSM2 = "/zm";

	SlashCmdList["ZSM"] = function(msg)
	ZSM_SlashCommandHandler(msg);
	end

	Pre_ChatFrame_OnEvent = ChatFrame_OnEvent;
	ChatFrame_OnEvent = ZSM_ChatFrame_OnEvent;

end

function ZSM_ChatFrame_OnEvent(event)
	if ((event == "CHAT_MSG_CHANNEL") and (string.lower(arg9) == string.lower(dataChannel))) then
		-- silence
		if (debug) then
			return Pre_ChatFrame_OnEvent(event);
		end
	else
		return Pre_ChatFrame_OnEvent(event);
	end
end

function ZSM_OnUpdate(elapse)

	if (req_timeout ~= nil) then
		req_timeout = req_timeout - elapse;
		if (req_timeout <= 0) then
			local highPlayer = {};
			local highTimestamp = {};
			local highTime = {};
			local tmpTransTimestamps = {};

			for playerName,data in pairs(known_times_req) do
				for transport,transData in pairs(data) do
					--DEFAULT_CHAT_FRAME:AddMessage(playerName..":"..transport);
					--DEFAULT_CHAT_FRAME:AddMessage(highTimestamp);

					if (tmpTransTimestamps[transport] == nil) then
						highPlayer[transport] = playerName;
						highTimestamp[transport] = transData['timestamp'];
						highTime[transport] = transData['time'];
					elseif (tmpTransTimestamps[transport] > highTimestamp[transport]) then
						highPlayer[transport] = playerName;
						highTimestamp[transport] = transData['timestamp'];
						highTime[transport] = transData['time'];
					end
				end
			end

			-- highest Timestamp wins
			for transport, timestamp in pairs(highTimestamp) do
				ZSM_Data[transport] = {};
				ZSM_Data[transport]['timestamp'] = highTimestamp[transport];
				known_times[transport] = highTime[transport];
				req_timeout = nil;
				known_times_req = {};

				if (debug) then
					ZSM_DebugMessage("["..highPlayer[transport].."] has most recent transport time:"..highTime[transport]..", with timestamp:".. highTimestamp[transport].." for ".. transport);
				end
			end
		end
	end

	if alarmDinged then
		alarmCountdown = alarmCountdown - elapse;
		if (0 > alarmCountdown) then
			alarmSet = false;
			alarmDinged = false;
			PlaySound("AuctionWindowClose");
		end
	end

	ctime_elapse = ctime_elapse + elapse;
	if (ctime_elapse > update_int or zsm_doNow) then
		ctime_elapse = 0;

		if ((activeTransit ~= -1) and (known_times[activeTransit] ~= nil)) then
			local transit = activeTransit;
			local cycle = ZSM_CalcTripCycle(transit);
			local coord_data_x, coord_data_y = ZSM_GetZepCoords(transit, cycle);

			local lowestTime = 500;

			for index, data in pairs(zsm_data[transit..'_plats']) do
				local platname;

				if (ZSM_Data['Opts']['CityAlias']) then
					platname = data['alias'];
				else
					platname = data['name'];
				end

				getglobal("ZSMFramePlat"..(index+1).."Name"):SetText(platname);

				--local coord_data = ZSM_GetZepCoords(transit, cycle);
				local depart_time = ZSM_CalcTripCycleTime(transit, cycle) - cycle - data['adj'];

				if ((data['x'] == coord_data_x) and (data['y'] == coord_data_y) and (depart_time > 0)) then
					if (alarmSet and not alarmDinged and depart_time < alarmOffset) then
						alarmDinged = true;
						alarmCountdown = depart_time;
						PlaySoundFile("Sound\\Spells\\PVPFlagTakenHorde.wav");
					end

					local formatted_depart_time;
	
					if (depart_time > 59) then
						formatted_depart_time = format("%0.0f", math.floor(depart_time/60)).."m "
							..format("%0.0f", depart_time-(math.floor(depart_time/60)*60)).."s";
					else
						formatted_depart_time = format("%0.0f", depart_time).."s";
					end

					local color;

					if (depart_time > 30) then
						color = YELLOW;
					else
						color = RED;
					end

					getglobal("ZSMFramePlat"..(index+1).."ArrivalDepature"):SetText(color.."Dep: ".. formatted_depart_time);
					zsm_activeData[index] = -depart_time;

					lowestTime = -500;
					zsm_lowestNameTime = data['ebv']..color.." "..formatted_depart_time;
					zsm_Icon = "Departing";
				else
					local arrival_time;
					local cycleTime = ZSM_CalcTripCycleTimeByIndex(transit,data['index']-1);

					if (cycleTime > cycle) then
						arrival_time = cycleTime - cycle;
					else
						arrival_time = zsm_data[transit..'_time'] - cycle;
						arrival_time = arrival_time + cycleTime;
					end

					local formatted_arrival_time;
	
					if (arrival_time > 59) then
						formatted_arrival_time = format("%0.0f", math.floor(arrival_time/60)).."m "
							..format("%0.0f", arrival_time-(math.floor(arrival_time/60)*60)).."s";
					else
						formatted_arrival_time = format("%0.0f",arrival_time).."s";
					end

					getglobal("ZSMFramePlat"..(index+1).."ArrivalDepature"):SetText(GREEN.."Arr: ".. formatted_arrival_time);
					zsm_activeData[index] = arrival_time;

					if (arrival_time < lowestTime) then
						lowestTime = arrival_time;
						zsm_lowestNameTime = data['ebv'].." "..GREEN..formatted_arrival_time;
						zsm_Icon = "Transit";
					end

				end

			end

			if (zsm_doNow and ZepShipMasterFu ~= nil) then
				ZepShipMasterFu:Update();
			end

		end

		zsm_doNow = false;
	end

	lastcheck = lastcheck + elapse;
	if (0.2 > lastcheck) then return; end
	lastcheck = 0;

	lastcheck_timeout = lastcheck_timeout + elapse;
	if (lastcheck_timeout <= 10.0) then return; end

	if (MapLibrary and MapLibrary.Ready) then
		if MapLibrary.InInstance() then return; end
		x, y = MapLibrary.GetWorldPosition("player", nil, 1);
		if not x then
			if ( WorldMapFrame:IsVisible() ) then return; end
			x, y = MapLibrary.GetWorldPosition("player", nil, nil);
			if not x then return; end
		end
	else
		if ( WorldMapFrame:IsVisible() ) then return; end
		SetMapZoom(0);
		x, y = GetPlayerMapPosition("player");
		SetMapToCurrentZone();
	end

	if (not ZSM_ProxyCheck(x,y,oldx,oldy,prox/2)) then
		--[[if (debug) then
			ZSM_DebugMessage("Moved: "..x..","..y.." ; old: "..oldx..","..oldy);
		end]]

		oldx = x; oldy = y;

		if (ZSM_ProxyCheck(x,y,0.315,0.450,prox)) then
			ZSM_SetKnownTime(25, 'org2uc');
		elseif (ZSM_ProxyCheck(x,y,0.725,0.227,prox)) then
			ZSM_SetKnownTime(131, 'org2uc');
		elseif (ZSM_ProxyCheck(x,y,0.311,0.443,prox)) then
			ZSM_SetKnownTime(16, 'org2gg');
		elseif (ZSM_ProxyCheck(x,y,0.717,0.759,prox)) then
			ZSM_SetKnownTime(63, 'org2gg');
		elseif (ZSM_ProxyCheck(x,y,0.741,0.723,prox)) then
			ZSM_SetKnownTime(42, 'grom2uc');
		elseif (ZSM_ProxyCheck(x,y,0.711,0.747,prox)) then
			ZSM_SetKnownTime(118, 'grom2uc');
		elseif (ZSM_ProxyCheck(x,y,0.712,0.811,prox)) then
			ZSM_SetKnownTime(93, 'ratch2bb');
		elseif (ZSM_ProxyCheck(x,y,0.285,0.532,prox)) then
			ZSM_SetKnownTime(162, 'ratch2bb');
		elseif (ZSM_ProxyCheck(x,y,0.740,0.436,prox)) then
			ZSM_SetKnownTime(30, 'mh2aub');
		elseif (ZSM_ProxyCheck(x,y,0.170,0.288,prox)) then
			ZSM_SetKnownTime(84, 'mh2aub');
		elseif (ZSM_ProxyCheck(x,y,0.734,0.464,prox)) then
			ZSM_SetKnownTime(21, 'mh2thera');
		elseif (ZSM_ProxyCheck(x,y,0.312,0.620,prox)) then
			ZSM_SetKnownTime(83, 'mh2thera');
		elseif (ZSM_ProxyCheck(x,y,0.171,0.252,prox)) then
			ZSM_SetKnownTime(28, 'rtv2ds');
		elseif (ZSM_ProxyCheck(x,y,0.180,0.221,prox)) then
			ZSM_SetKnownTime(94, 'rtv2ds');
		end
	end

end

function ZSM_ProxyCheck(curposx, curposy, checkposx, checkposy, prox)
	return ( ( abs(checkposx - curposx) <= (prox*0.001) ) and ( abs(checkposy - curposy) <= (prox*0.001) ) );
end

function ZSM_CalcTripCycleTimeByIndex(transit, index)
	local sum_time = 0;
	for i = 1, index do
		--local Args = ZSM_GetArgs(zsm_data[transit..'_data'][i], ":");
		sum_time = sum_time + zsm_data[transit..'_data']['delta'][i];
	end
	return sum_time;
end

function ZSM_CalcTripCycle(transit)
	local div_time = (GetTime() - known_times[transit]) / zsm_data[transit..'_time'];
	return (div_time - floor(div_time)) * zsm_data[transit..'_time'];
end

function ZSM_CalcTripCycleTime(transit, cycle)
	local sum_time = 0;
	for i = 1, #(zsm_data[transit..'_data']['delta']) do
		--local Args = ZSM_GetArgs(zsm_data[transit..'_data'][i], ":");
		sum_time = sum_time + zsm_data[transit..'_data']['delta'][i];
		if (cycle <= sum_time) then
			 return sum_time;
		end
	end
end

function ZSM_GetZepCoords(transit, cycle)
	local sum_time = 0;
	for i = 1, #(zsm_data[transit..'_data']['delta']) do
		--local Args = ZSM_GetArgs(zsm_data[transit..'_data'][i], ":");
		sum_time = sum_time + zsm_data[transit..'_data']['delta'][i];
		if (cycle <= sum_time) then
			return zsm_data[transit..'_data']['x'][i], zsm_data[transit..'_data']['y'][i];
		end
	end
end

function ZSM_SetKnownTime(value, transit)

	lastcheck_timeout = 0;

	local sum_time = 0;
	for i = 1, value do
		--local Args = ZSM_GetArgs(zsm_data[transit..'_data'][i], ":");
		sum_time = sum_time + zsm_data[transit..'_data']['delta'][i];
	end
	known_times[transit] = GetTime() - sum_time;
	known_times['uptime'] = GetTime();

	if (debug) then
		ZSM_DebugMessage(transit .." Zep Time Set :"..known_times[transit]);
	end

	ZSM_Data[transit] = {};
	ZSM_Data[transit]['timestamp'] = time();
	local id, name = GetChannelName(dataChannel);
	SendChatMessage('KNOW:'..protoVersion..":"..transit..":"..(math.floor(sum_time*1000)/1000)..":"
		..ZSM_Data[transit]['timestamp'], "CHANNEL", nil, id);

end

function ZSM_TransportSelect_Initialize()
	local info;
	dropdownvalues = {};

	for i = 0, #(zsm_data['transports']), 1 do
		dropdownindex[zsm_data['transports'][i]['label']] = i;

		local textdesc;
		if (ZSM_Data['Opts']['CityAlias']) then
			if (known_times[zsm_data['transports'][i]['label']]) then
				textdesc = GREEN..zsm_data['transports'][i]['namealias'];
			else
				textdesc = zsm_data['transports'][i]['namealias'];
			end
		else
			if (known_times[zsm_data['transports'][i]['label']]) then
				textdesc = GREEN..zsm_data['transports'][i]['name'];
			else
				textdesc = zsm_data['transports'][i]['name'];
			end
		end

		info = {
			text = textdesc;
			func = ZSM_TransportSelect_OnClick;
		};

		local addtrans = false;
		if (ZSM_Data['Opts']['FactionSpecific']) then
			local faction = UnitFactionGroup("player");

			if ((zsm_data['transports'][i]['faction'] == faction) or (zsm_data['transports'][i]['faction'] == "Neutral")) then
				addtrans = true;
			end
		else
			addtrans = true;
		end

		if (ZSM_Data['Opts']['ZoneSpecific'] and (addtrans)) then
			local zonestr = string.lower(zsm_data['transports'][i]['name']);
			local czonestr = string.lower(GetRealZoneText());
			if (not string.find(zonestr, czonestr)) then
				addtrans = false;
			end
		end

		if ((addtrans) or (zsm_data['transports'][i]['faction'] == -1)) then
			UIDropDownMenu_AddButton(info);
			table.insert(dropdownvalues, zsm_data['transports'][i]['label']);
		end
	end

end

function ZSM_TransportSelect_PreInitialize()
	local info;

	info = {
		text = 'loading variables';
		func = ZSM_TransportSelect_OnClick;
	};
	UIDropDownMenu_AddButton(info);
end

function ZSM_TransportSelect_OnShow()

	if (vars_loaded) then
		ZSM_TransportSelect_OnLoaded();
		UIDropDownMenu_SetWidth(150);
		return;
	end

	UIDropDownMenu_ClearAll(ZSMFrameTransportSelect);
	UIDropDownMenu_Initialize(ZSMFrameTransportSelect, ZSM_TransportSelect_PreInitialize);
	UIDropDownMenu_SetSelectedID(ZSMFrameTransportSelect, 1);
	UIDropDownMenu_SetWidth(150);
end

function ZSM_TransportSelect_OnLoaded()
	UIDropDownMenu_ClearAll(ZSMFrameTransportSelect);
	UIDropDownMenu_Initialize(ZSMFrameTransportSelect, ZSM_TransportSelect_Initialize);
	UIDropDownMenu_SetSelectedID(ZSMFrameTransportSelect, activeSelect);
end

function ZSM_TransportSelect_OnClick()
	if (req_timeout ~= nil) then
		-- cannot change selection while data request is in process
		return;
	end

	local i = this:GetID();
	UIDropDownMenu_SetSelectedID(ZSMFrameTransportSelect, i);
	activeTransit = dropdownvalues[i];
	activeSelect = i;

	if (ZSM_Data['Opts']['CityAlias']) then
		activeTransitName = zsm_data['transports'][dropdownindex[activeTransit]]['namealias'];
	else
		activeTransitName = zsm_data['transports'][dropdownindex[activeTransit]]['name'];
	end

	if (known_times[activeTransit] == nil) then
		local id, name = GetChannelName(dataChannel);
		SendChatMessage('REQ:'..protoVersion..":"..activeTransit, "CHANNEL", nil, id);
	end

	ZSM_TransportSelect_SetNone();
end

function ZSM_TransportSelect_SetNone()

	if (activeTransit == -1) then
		if (debug) then
			ZSM_DebugMessage("_OnClick - no transit");
		end

		for index = 1, 2 do
			getglobal("ZSMFramePlat"..(index).."Name"):SetText(ZSM_STR_NONESELECT);
			getglobal("ZSMFramePlat"..(index).."ArrivalDepature"):SetText("-- N/A --");
		end

		zsm_lowestNameTime = "--";
		zsm_Icon = "ZeppelinMasterLogo";

	elseif (known_times[activeTransit] == nil) then
		local transit = activeTransit;

		if (debug) then
			ZSM_DebugMessage("_OnClick - unknown transit: "..transit);
		end

		for index, data in pairs(zsm_data[transit..'_plats']) do
			local platname;

			if (ZSM_Data['Opts']['CityAlias']) then
				platname = data['alias'];
			else
				platname = data['name'];
			end

			getglobal("ZSMFramePlat"..(index+1).."Name"):SetText(platname);
			getglobal("ZSMFramePlat"..(index+1).."ArrivalDepature"):SetText("-- N/A --");
		end

		zsm_lowestNameTime = "N/A";
		zsm_Icon = "ZeppelinMasterLogo";

	end

end

function ZSM_TransportRequestData(transport)

	local id, name = GetChannelName(dataChannel);
	SendChatMessage('REQ:'..protoVersion..":"..transport, "CHANNEL", nil, id);

	if (debug) then
		ZSM_DebugMessage("Data requested for transport ".. transport);
	end

end

-----------------

function ZSM_Minimize_OnClick ()

	if( not ZSMFrame:IsVisible() )then
		ZSMFrame:Show();
		ZSMHeaderFrameMinimizeButton:SetText("v");
		ZSM_Data['Opts']['ShowLowerGUI'] = true;
	else
		ZSMFrame:Hide();
		ZSMHeaderFrameMinimizeButton:SetText("^");
		ZSM_Data['Opts']['ShowLowerGUI'] = false;
	end

end

function ZSM_Close_OnClick ()
	ZSMHeaderFrame:Hide();
	ZSM_Data['Opts']['ShowGUI'] = false;
	DEFAULT_CHAT_FRAME:AddMessage(YELLOW.. "ZeppelinMaster -- GUI Closed! ("..GREEN.."Type /zm to show again"..YELLOW..")");
end

function ZSM_Options_OnClick ()

	if ( not ZSMOptionsFrame:IsVisible() ) then
		ZSMOptionsFrame:Show();
	else
		ZSMOptionsFrame:Hide();
	end

end

function ZSM_OptionsSave_OnClick()

	ZSM_Data['Opts']['ZoneGUI'] = ZSMOptionsFrameOptZoneGUI:GetChecked();
	ZSM_Data['Opts']['FactionSpecific'] = ZSMOptionsFrameOptFactionSpecific:GetChecked();
	ZSM_Data['Opts']['ZoneSpecific'] = ZSMOptionsFrameOptZoneSpecific:GetChecked();
	ZSM_Data['Opts']['CityAlias'] = ZSMOptionsFrameOptCityAlias:GetChecked();

	-- refresh dropdown with current options applied
	ZSM_TransportSelect_OnLoaded();
	ZSMOptionsFrame:Hide();

end

function ZSM_OptionsClose_OnClick()

	if (ZSM_Data['Opts']['ZoneGUI']) then
		ZSMOptionsFrameOptZoneGUI:SetChecked();
	end
	if (ZSM_Data['Opts']['FactionSpecific']) then
		ZSMOptionsFrameOptFactionSpecific:SetChecked();
	end
	if (ZSM_Data['Opts']['ZoneSpecific']) then
		ZSMOptionsFrameOptZoneSpecific:SetChecked();
	end
	if (ZSM_Data['Opts']['CityAlias']) then
		ZSMOptionsFrameOptCityAlias:SetChecked();
	end
	ZSMOptionsFrame:Hide();

end

function ZSM_InitialiseConfig()

	vars_loaded = true;

	-- initialize saved variables
	if (ZSM_Opts == nil) then
		ZSM_Opts = {};
	end

	if (ZSM_Opts['dataChannel'] == nil) then
		ZSM_Opts['dataChannel'] = dataChannel;
	end
	if (ZSM_Data == nil) then
		ZSM_Data = {};
		known_times = {};
	end
	if (ZSM_Data['protoVersion'] == nil) then
			ZSM_Data['protoVersion'] = protoVersion;
	end
	if (ZSM_Data['protoVersion'] ~= protoVersion) then
		-- if protocol is different, reset data
		known_times = {};
		ZSM_Data['protoVersion'] = protoVersion;

		if (debug) then
			ZSM_DebugMessage(YELLOW.. "ZeppelinMaster - DEBUG - ".. RED .."Protocol changed, data reset!!");
		end
	end
	if (ZSM_Data['Opts'] == nil) then
		ZSM_Data['Opts'] = {};
		ZSM_Data['Opts']['ZoneGUI'] = false;
		ZSM_Data['Opts']['FactionSpecific'] = true;
		ZSM_Data['Opts']['ZoneSpecific'] = false;
		ZSM_Data['Opts']['CityAlias'] = true;
	end

	if ((ZSM_Data['Opts']['version'] == nil) or (ZSM_Data['Opts']['version'] < varsVersion)) then
		ZSM_Data['Opts']['version'] = varsVersion;
		ZSM_Data['Opts']['ZoneGUI'] = false;
	end

	if (ZSM_Data['Opts']['ShowGUI'] == nil) then
		ZSM_Data['Opts']['ShowGUI'] = true;
	end

	if (ZSM_Data['Opts']['ShowLowerGUI'] == nil) then
		ZSM_Data['Opts']['ShowLowerGUI'] = true;
	end

	-- set GUI options
	if (ZSM_Data['Opts']['ZoneGUI']) then
		ZSMOptionsFrameOptZoneGUI:SetChecked();
	end
	if (ZSM_Data['Opts']['FactionSpecific']) then
		ZSMOptionsFrameOptFactionSpecific:SetChecked();
	end
	if (ZSM_Data['Opts']['ZoneSpecific']) then
		ZSMOptionsFrameOptZoneSpecific:SetChecked();
	end
	if (ZSM_Data['Opts']['CityAlias']) then
		ZSMOptionsFrameOptCityAlias:SetChecked();
	end

	ZSM_TransportSelect_OnLoaded();

	dataChannel = ZSM_Opts['dataChannel'];

	if (ZSM_Data['Opts']['ShowLowerGUI']) then
		ZSMFrame:Show();
	else
		ZSMFrame:Hide();
	end

	if (ZSM_Data['Opts']['ShowGUI']) then
		ZSMHeaderFrame:Show();
	else
		ZSMHeaderFrame:Hide();
	end

	if ((ZSM_Data['agedTimestamp'] ~= nil) and (ZSM_Data['agedTimestamp'] > time())) then
		ZSM_Data['agedTimestamp'] = time();
		DEFAULT_CHAT_FRAME:AddMessage("ZeppelinMaster: Aged timestamp was too old, setting oldest timestamp to current system time.");
	end

	--ZSMHeaderFrameAddonName:SetText("ZeppelinMaster "..ZSM_version);
	ZSMOptionsFrameOptionsTitle:SetText("ZeppelinMaster Options (v"..ZSM_version..")");
	DEFAULT_CHAT_FRAME:AddMessage(YELLOW.. "ZeppelinMaster v"..ZSM_version.." -- Loaded. (type /zsm to toggle interface)");
	if ((known_times['uptime'] ~= nil) and (known_times['uptime'] > GetTime())) then
		-- since uptime is less than last known zep time, reset must have occured
		-- clear known times
		known_times = {};
		known_times['uptime'] = GetTime();

		DEFAULT_CHAT_FRAME:AddMessage(YELLOW.. "ZeppelinMaster -- ".. RED .."Sync Data Out-Of-Date ... Data Reset!");
	end

end

function ZSM_ParseMessage(arg1, arg2)

	local Args = ZSM_GetArgs(arg1, ":");
	local numArgs = #(Args);

	if (numArgs <= 2) then
		return;
	end

	local command = Args[1];
	local version = Args[2];

	--DEFAULT_CHAT_FRAME:AddMessage(arg4..":"..arg2..":"..arg1);

	if ((tonumber(protoVersion) < tonumber(version)) and (not newVerAvail)) then
		newVerAvail = true;
		DEFAULT_CHAT_FRAME:AddMessage(YELLOW.."ZeppelinMaster ::"..RED.." "..ZSM_STR_NEWVERSION);
		return;
	end

	if (command == "REQVER") then
		-- if our client was around for a server shutdown or restart,
		-- let other clients know data before this date is out-of-date
		if (ZSM_Data['agedTimestamp'] ~= nil) then
			local id, name = GetChannelName(dataChannel);
			SendChatMessage('DATED:'..protoVersion..":"..ZSM_Data['agedTimestamp'], "CHANNEL", nil, id);
		end

		local id, name = GetChannelName(dataChannel);
		SendChatMessage('VER:'..protoVersion..":"..ZSM_version, "CHANNEL", nil, id);

	elseif (command == "VER") then
		local clientversion = Args[3];

		if ((tonumber(ZSM_version) < tonumber(clientversion)) and (not newVerAvail)) then
			newVerAvail = true;
			DEFAULT_CHAT_FRAME:AddMessage(YELLOW.."ZeppelinMaster ::"..RED.." "..ZSM_STR_NEWVERSION);
			return;
		end

	-- DATED:ver:timestamp
	elseif ((command == "DATED") and (protoVersion == version)) then
		local dated_timestamp = tonumber(Args[3]);
		if ((ZSM_Data['agedTimestamp'] ~= nil) and (ZSM_Data['agedTimestamp'] < dated_timestamp) and (dated_timestamp < time()))  then
			ZSM_Data['agedTimestamp'] = dated_timestamp;
		elseif ((ZSM_Data['agedTimestamp'] == nil) and (dated_timestamp < time())) then
			ZSM_Data['agedTimestamp'] = dated_timestamp;
		end

		-- check to see any of this clients data is older than last aged timestamp
		-- if so clear it
		for transport, time in pairs(known_times) do
			if ((ZSM_Data[transport] ~= nil) and (ZSM_Data[transport]['timestamp'] ~= nil) and (ZSM_Data['agedTimestamp'] ~= nil) and (ZSM_Data[transport]['timestamp'] < ZSM_Data['agedTimestamp'])) then
				known_times[transport] = nil;
				ZSM_Data[transport] = nil;

				if (debug) then
					ZSM_DebugMessage(transport.." timestamp is too old, removing.");
				end
			end
		end

	-- KNOWN:ver:transit:index
	elseif ((command == "KNOW") and (protoVersion == version)) then
		local transit = Args[3];
		local value = tonumber(Args[4]);
		local timestamp = tonumber(Args[5]);

		--[[local sum_time = 0;
		for i = 1, value do
			--local Args = ZSM_GetArgs(zsm_data[transit..'_data'][i], ":");
			sum_time = sum_time + zsm_data[transit..'_data']['delta'][i];
		end]]

		known_times[transit] = GetTime() - value; --sum_time;
		ZSM_Data[transit] = {};
		ZSM_Data[transit]['timestamp'] = timestamp; --time();

		if (debug) then
			ZSM_DebugMessage(RED.."Zep Time Broadcast Received from ".. arg2 .." -- ".. transit .." Zep Time Set :"..known_times[transit]);
		end

	-- REQ:ver:transit
	elseif ((command == "REQ") and (protoVersion == version)) then
		local transit = Args[3];

		if (debug) then
			ZSM_DebugMessage(arg2.." requested ".. transit);
		end

		if (known_times[transit] ~= nil) then
			local cycle = ZSM_CalcTripCycle(transit);
			--local time = cycle*zsm_data[transit..'_time'];
			local id, name = GetChannelName(dataChannel);
			SendChatMessage('RESP:'..protoVersion..":"..transit..":"..(math.floor(cycle*1000)/1000)..":"..ZSM_Data[transit]['timestamp'], "CHANNEL", nil, id);

			--[[if (debug) then
				ZSM_DebugMessage(dataChannel.." -- ".. id);
			end]]
		end

	-- RESP:ver:transit:time:timestamp
	elseif ((command == "RESP") and (protoVersion == version)) then
		local transit = Args[3];
		local time = tonumber(Args[4]);
		local timestamp = tonumber(Args[5]);

		if (known_times[transit] == nil) then
			req_timeout = 1;
			if (known_times_req[arg2] == nil) then
				known_times_req[arg2] = {};
			end
			known_times_req[arg2][transit] = {};
			known_times_req[arg2][transit]['timestamp'] = timestamp;
			known_times_req[arg2][transit]['time'] = GetTime() - time;

			if (debug) then
				ZSM_DebugMessage(RED.."Zep Time Broadcast Received from ".. arg2 .." -- ".. transit .." Zep Time Set :"..known_times_req[arg2][transit]['time']);
			end
		end

		zsm_tempText = RED.."Receiving Data..";
		zsm_tempTextCount = 2;
	end

end

function ZSM_OnEvent(event)

	if (event == "VARIABLES_LOADED") then
		ZSM_InitialiseConfig();

	elseif (event == "CHAT_MSG_SYSTEM") then
		-- server is going down. clear zep times, also record down time server went down so we can inform
		-- other clients that their data is out of date if their data timestamp is less than server reset
		if (string.find(string.lower(arg1), "restart in") or string.find(string.lower(arg1), "shutdown in")) then

			known_times = {};
			ZSM_Data['agedTimestamp'] = time();
		end

	-- if we joined a channel
	elseif (event == "CHAT_MSG_CHANNEL_NOTICE") then
		--joinedch = true;
		-- automatically join data channel
		JoinChannelByName(dataChannel);

		if (arg9 == dataChannel) then
			local id, name = GetChannelName(dataChannel);
			SendChatMessage('REQVER:1:1', "CHANNEL", nil, id);

			-- transmit all our known data when someone joins a channel
			for index, data in pairs(zsm_data['transports']) do
				if ( (data.label ~= -1) and (known_times[data.label] == nil) ) then
					ZSM_TransportRequestData(data['label']);
				end
			end
		end

	--[[elseif (event == "CHAT_MSG_CHANNEL_JOIN") then
		-- if our client was around for a server shutdown or restart, let other clients know data before this date is out-of-date
		if ((ZSM_Data['agedTimestamp'] ~= nil) and (string.lower(arg9) == string.lower(dataChannel))) then
			local id, name = GetChannelName(dataChannel);
			SendChatMessage('DATED:'..protoVersion..":"..ZSM_Data['agedTimestamp'], "CHANNEL", nil, id);
		end]]

	elseif ((event == "CHAT_MSG_CHANNEL") and (arg9 == dataChannel) and (arg2 ~= UnitName("player"))) then
		ZSM_ParseMessage(arg1, arg2);

	elseif (event == "ZONE_CHANGED_NEW_AREA") then

		if (not ZSM_Data['Opts']['ZoneGUI']) then
			-- Opts: show GUI when zone change contains a transport
			return;
		end
		-- open GUI if entering zone with transport
		for index, zone_data in pairs(zsm_data['transports']) do
			if (zone_data['label'] ~= -1) then
				local plat_data = zsm_data[zone_data['label']..'_plats'];
				if (plat_data ~= nil) then
					for index, trans_data in pairs(plat_data) do
						--DEFAULT_CHAT_FRAME:AddMessage(trans_data['name'] );
						if (trans_data['name'] == GetRealZoneText()) then
							ZSMHeaderFrame:Show();
							ZSMFrame:Show();
						end
					end
				end
			end
		end

	end

end

function ZSM_ToggleAlarm()
	alarmSet = not alarmSet;
	if not alarmSet then alarmDinged = false; end
	local is; if alarmSet then is = "ON" else is = "OFF" end
	DEFAULT_CHAT_FRAME:AddMessage(RED.."ZeppelinMaster - Alarm is now: "..is);
	PlaySound("AuctionWindowOpen");
end

function ZSM_IsAlarmSet()
	return alarmSet or alarmDinged;
end

function ZSM_SlashCommandHandler(msg)

	local msgArgs;
	local numArgs;

	msg = string.lower(msg);
	msgArgs = ZSM_GetArgs(msg, " ");

	numArgs = #(msgArgs);

	if (numArgs == 0) then
		DEFAULT_CHAT_FRAME:AddMessage(YELLOW.."ZeppelinMaster - Display GUI");
		ZSMHeaderFrame:Show();
		ZSM_Data['Opts']['ShowGUI'] = true;

	elseif (numArgs == 1) then

		if (msgArgs[1] == "reset") then
			DEFAULT_CHAT_FRAME:AddMessage(RED.."ZeppelinMaster - Session Reset!");
			known_times = {};
		end

	elseif (numArgs == 2) then

		if (msgArgs[1] == "channel") then
			LeaveChannelByName(dataChannel);
			ZSM_Opts['dataChannel'] = msgArgs[2];
			dataChannel = ZSM_Opts['dataChannel'];
			JoinChannelByName(dataChannel);
			DEFAULT_CHAT_FRAME:AddMessage(YELLOW.."ZeppelinMaster - Data Channel set to [".. msgArgs[2] .."]");
		end
	end

end

-- extract key/value from message
function ZSM_GetArgs(message, separator)

	local args = {};
	local i = 0;

	-- search for seperators in the string and return the separated data
	for value in string.gmatch(message, "[^"..separator.."]+") do
		i = i + 1;
		args[i] = value;
	end

	return args;
end

function ZSM_DebugMessage(msg)
	ChatFrame4:AddMessage("[ZSM]: "..msg);
end
