﻿-- declard color codes for console messages
local RED     = "|cffff0000";
local GREEN   = "|cff00ff00";
local BLUE    = "|cff0000ff";
local MAGENTA = "|cffff00ff";
local YELLOW  = "|cffffff00";
local CYAN    = "|cff00ffff";
local WHITE   = "|cffffffff";
local ORANGE  = "|cffffba00";

local ZSM_ARTWORKPATH = "Interface\\AddOns\\ZepShipMaster\\Artwork\\";

activeTransitName = "";
activeSelect = -1;
activeTransit = -1;

-- local variables
local dropdownvalues = {};
local dropdownindexes = {};

ZepShipMasterFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0", "AceDB-2.0")

ZepShipMasterFu:RegisterDB("ZepMasterDB", "ZepMasterDBPC");
ZepShipMasterFu:RegisterDefaults("profile", {
	factionSpecific = true,
	zoneSpecific = false,
	cityAlias = true;
} );

function ZepShipMasterFu:OnInitialize()
	self.hasIcon = true;
	self.title = "ZeppelinMaster";
	self:SetIcon(ZSM_ARTWORKPATH.."ZeppelinMasterLogo");
end

function ZepShipMasterFu:IsFactionSpecific()
    return self.db.profile.factionSpecific;
end

function ZepShipMasterFu:ToggleFaction()
    self.db.profile.factionSpecific = not self.db.profile.factionSpecific;
    self:Update();
end

function ZepShipMasterFu:IsZoneSpecific()
    return self.db.profile.zoneSpecific;
end

function ZepShipMasterFu:ToggleZone()
    self.db.profile.zoneSpecific = not self.db.profile.zoneSpecific;
    self:Update();
end

function ZepShipMasterFu:IsAlias()
    return self.db.profile.cityAlias;
end

function ZepShipMasterFu:ToggleAlias()
    self.db.profile.cityAlias = not self.db.profile.cityAlias;
    self:Update();
end

local tablet = AceLibrary("Tablet-2.0")
function ZepShipMasterFu:OnTooltipUpdate()
	local cat = tablet:AddCategory(
		'columns', 2,
		'child_textR', 1,
		'child_textG', 1,
		'child_textB', 0
	)

	if ((activeTransit ~= -1) and (known_times[activeTransit] ~= nil)) then
		local transit = activeTransit;

		cat:AddLine('text', activeTransitName);

		for index, data in pairs(zsm_data[transit..'_plats']) do
			local platname;

			if ( self:IsAlias() ) then
				platname = data['alias'];
			else
				platname = data['name'];
			end

			local cat = tablet:AddCategory(
				'text', platname,
				'columns', 2,
				'child_textR', 1,
				'child_textG', 1,
				'child_textB', 0
			)

			local the_time = zsm_activeData[index];
			local depOrArr;
			local r,g,b;

			if (the_time <= 0) then
				the_time = -the_time;

				if (the_time > 30) then
					r,g,b = 1,1,0;
				else
					r,g,b = 1,0,0;
				end

				depOrArr = "Departure";
			else
				r,g,b = 0,1,0;
				depOrArr = "Arrival";
			end

			local formatted_time;
			if (the_time > 59) then
				formatted_time = format("%0.0f", math.floor(the_time/60)).."m "
					..format("%0.0f", the_time-(math.floor(the_time/60)*60)).."s";
			else
				formatted_time = format("%0.0f", the_time).."s";
			end

			cat:AddLine('text', depOrArr..":",
				'text2', formatted_time,
				'text2R', r, 'text2G', g, 'text2B', b);

		end
	elseif ((activeTransit ~= -1) and (known_times[activeTransit] == nil)) then
		local transit = activeTransit;

		cat:AddLine('text', activeTransitName);

		for index, data in pairs(zsm_data[transit..'_plats']) do
			local platname;

			if ( self:IsAlias() ) then
				platname = data['alias'];
			else
				platname = data['name'];
			end

			local cat = tablet:AddCategory(
				'text', platname,
				'columns', 2,
				'child_textR', 1,
				'child_textG', 1,
				'child_textB', 0
			)

			cat:AddLine('text', "Not Available");
		end
	elseif (activeTransit == -1) then
		cat:AddLine('text', "No Transit Selected");
	end

    tablet:SetHint(ZSM_STR_HINT);
end

-- NOT using an AceOptions data table
local dewdrop = AceLibrary("Dewdrop-2.0");
function ZepShipMasterFu:OnMenuRequest(level, value, inTooltip)

	if inTooltip then return; end

	dropdownvalues = {};
	dropdownindexes = {};

	dewdrop:AddLine(
		'text', ZSM_STR_OPT_FACTION,
		'arg1', self,
		'func', "ToggleFaction",
		'checked', self:IsFactionSpecific(),
		'tooltipTitle', ZSM_STR_OPT_FACTION,
		'tooltipText', ZSM_STR_OPT_FACTION_DESC
	);
	dewdrop:AddLine(
		'text', ZSM_STR_OPT_ZONE,
		'arg1', self,
		'func', "ToggleZone",
		'checked', self:IsZoneSpecific(),
		'tooltipTitle', ZSM_STR_OPT_ZONE,
		'tooltipText', ZSM_STR_OPT_ZONE_DESC
	);
	dewdrop:AddLine(
		'text', ZSM_STR_OPT_ALIAS,
		'arg1', self,
		'func', "ToggleAlias",
		'checked', self:IsAlias(),
		'tooltipTitle', ZSM_STR_OPT_ALIAS,
		'tooltipText', ZSM_STR_OPT_ALIAS_DESC
	);
	dewdrop:AddLine(
		'text', ""
	);
	dewdrop:AddLine(
		'text', YELLOW.."Select None",
		'func', function() self:SetTransport(-1) end
	);

	local count = 1;
	for index, data in pairs(zsm_data['transports']) do

		local tmplabel = data['label'];
		dropdownindexes[tmplabel] = index;

		local textdesc;
		if ( self:IsAlias() ) then
			textdesc = zsm_data['transports'][index]['namealias'];
		else
			textdesc = zsm_data['transports'][index]['name'];
		end

		local addtrans = false;
		if ( self:IsFactionSpecific() ) then
			local faction = UnitFactionGroup("player");
			if ((zsm_data['transports'][index]['faction'] == faction) or (zsm_data['transports'][index]['faction'] == "Neutral")) then
				addtrans = true;
			end
		else
			addtrans = true;
		end

		if ( self:IsZoneSpecific() and (addtrans)) then
			local zonestr = string.lower(zsm_data['transports'][index]['name']);
			local czonestr = string.lower(GetRealZoneText());
			if (not string.find(zonestr, czonestr)) then
				addtrans = false;
			end
		end

		if ((addtrans) and (zsm_data['transports'][index]['faction'] ~= -1)) then
			table.insert(dropdownvalues, zsm_data['transports'][index]['label']);

			label = zsm_data['transports'][index]['label'];

			if (known_times[label] ~= nil) then
				textdesc = GREEN..textdesc;
			end

			dewdrop:AddLine(
				'text', textdesc,
				'arg1', count,
				'func', function(count) self:SetTransport(count) end
			);

			count = count + 1;
		end
	end

	dewdrop:AddLine(
		'text', ""
	);

end

function ZepShipMasterFu:OnEnable()
	self:ScheduleRepeatingEvent(self.OnUpdate, 1, self);
end

function ZepShipMasterFu:OnUpdate()
	self:Update();
end

function ZepShipMasterFu:OnTextUpdate()
	if ZSM_IsAlarmSet() then
		self:SetIcon("Interface\\Icons\\INV_Misc_PocketWatch_02");
	else
		self:SetIcon(ZSM_ARTWORKPATH..zsm_Icon);
	end

	if (zsm_tempTextCount > 0) then
		zsm_tempTextCount = zsm_tempTextCount -1;
		return;
	end

	self:SetText(zsm_lowestNameTime);
end

function ZepShipMasterFu:OnClick()

	if IsAltKeyDown() then
		if (activeTransit ~= -1) then
			ZSM_ToggleAlarm();
	
			-- set tempory button text so you know which one is currently selected
			if ZSM_IsAlarmSet() then
				zsm_tempText = "Alarm "..RED.."ON";
			else
				zsm_tempText = "Alarm OFF";
			end
	
			zsm_tempTextCount = 2;
			self:SetText(zsm_tempText);
			zsm_doNow = true;
		end

		return;
	end

	if ( #(dropdownvalues) == 0 ) then
		dropdownvalues = {};
		dropdownindexes = {};
	
		local count = 1;
		for index, data in pairs(zsm_data['transports']) do
	
			local tmplabel = data['label'];
			dropdownindexes[tmplabel] = index;
	
			local addtrans = false;
			if ( self:IsFactionSpecific() ) then
				local faction = UnitFactionGroup("player");
				if ((zsm_data['transports'][index]['faction'] == faction)
					or (zsm_data['transports'][index]['faction'] == "Neutral")) then
	
					addtrans = true;
				end
			else
				addtrans = true;
			end
	
			if ( self:IsZoneSpecific() and (addtrans)) then
				local zonestr = string.lower(zsm_data['transports'][index]['name']);
				local czonestr = string.lower(GetRealZoneText());
				if (not string.find(zonestr, czonestr)) then
					addtrans = false;
				end
			end
	
			if ((addtrans) and (zsm_data['transports'][index]['faction'] ~= -1)) then
				table.insert(dropdownvalues, zsm_data['transports'][index]['label']);
				label = zsm_data['transports'][index]['label'];
				count = count + 1;
			end
		end
	end

	if ( #(dropdownvalues) == 0 ) then
		activeSelect = -1;
		activeTransit = -1;
		return;
	elseif (activeSelect == -1) then
		activeSelect = 1;
	else
		activeSelect = activeSelect + 1;
	end

	if (activeSelect > #(dropdownvalues)) then
		activeSelect = 1;
		activeTransit = dropdownvalues[activeSelect];
	else
		activeTransit = dropdownvalues[activeSelect];
	end

	if ( self:IsAlias() ) then
		activeTransitName = zsm_data['transports'][dropdownindexes[activeTransit] ]['namealias'];
	else
		activeTransitName = zsm_data['transports'][dropdownindexes[activeTransit] ]['name'];
	end

	local color;

	if (known_times[activeTransit] ~= nil) then
		color = GREEN;
	else
		color = RED;
	end

	-- set tempory button text so you know which one is currently selected
	zsm_tempText = color..activeTransitName;
	zsm_tempTextCount = 2;
	self:SetText(zsm_tempText);
	zsm_doNow = true;

	if (known_times[activeTransit] == nil) then
		ZSM_TransportRequestData(activeTransit);
	end

	ZSM_TransportSelect_SetNone();

end

function ZepShipMasterFu:SetTransport(id)

	if (id == -1) then
		activeSelect = -1;
		activeTransit = -1;
		activeTransitName = ZSM_STR_NONESELECT;
	else
		activeSelect = id;
		activeTransit = dropdownvalues[id];

		if ( self:IsAlias() ) then
			activeTransitName = zsm_data['transports'][dropdownindexes[activeTransit] ]['namealias'];
		else
			activeTransitName = zsm_data['transports'][dropdownindexes[activeTransit] ]['name'];
		end

		if (known_times[activeTransit] == nil) then
			ZSM_TransportRequestData(activeTransit);
		end

		zsm_tempText = activeTransitName;
		zsm_tempTextCount = 2;
		self:SetText(zsm_tempText);
		zsm_doNow = true;
	end

	ZSM_TransportSelect_SetNone();

end
