VisualHeal.Shaman = {};

VisualHeal.Shaman.HealingSpells = {};
VisualHeal.Shaman.HealingSpells[VISUALHEAL_SPELL_LESSER_HEALING_WAVE] = {27, 35, 43, 51, 59, 65, 70};
VisualHeal.Shaman.HealingSpells[VISUALHEAL_SPELL_HEALING_WAVE] = {5, 11, 17, 23, 31, 39, 47, 55, 59, 62, 69, 70};
VisualHeal.Shaman.HealingSpells[VISUALHEAL_SPELL_CHAIN_HEAL] = {45, 53, 60, 67, 70};

VisualHeal.Shaman.Totems = {
    [22396] = 80, -- TotemOfLife
    [23200] = 53  -- TotemOfSustaining
}

function VisualHeal.Shaman:GetSpellInfo(name, rank, target)
    local i, powerInfusion;

    -- Get static spell info (cached by main module)
    local spellInfo = VisualHeal:GetSpellInfo(name)[rank];

    if (not spellInfo) then
        return nil;
    end

    -- Get +healing bonus
    local bonus = GetSpellBonusHealing();

    -- Purification Talent (increases healing by 2% per rank)
    local _, _, _, _, talentPurification = GetTalentInfo(3,15); 
    talentPurification = 2 * talentPurification / 100 + 1;

    -- Detect Power Infusion
    if (VisualHeal:DetectBuff('player', "Spell_Holy_PowerInfusion")) then
        powerInfusion = 1.2;
    else
        powerInfusion = 1.0;
    end

    local spellTab = self.HealingSpells[name];

    -- Process individual spells
    if (name == VISUALHEAL_SPELL_LESSER_HEALING_WAVE) then
        local totemBonus = self.Totems[VisualHeal:GetEquippedRelicID()];
        spellInfo.EffectiveHeal = powerInfusion * talentPurification * (spellInfo.Heal + ((1.5 / 3.5) * (bonus + (totemBonus or 0))) * VisualHeal:GetSpellBonusHealingPenalty(spellTab[rank], UnitLevel('player')));
    elseif (name == VISUALHEAL_SPELL_HEALING_WAVE) then
        local nBonus;

        -- Determine normalisation 
        if (rank < 5) then
            if (rank == 1) then
                nBonus = (1.5 / 3.5) * bonus * 0.2875;
            elseif (rank == 2) then
                nBonus = (2.0 / 3.5) * bonus * 0.475;
            elseif (rank == 3) then
                nBonus = (2.5 / 3.5) * bonus * 0.7;
            elseif (rank == 4) then
                nBonus = (3.0 / 3.5) * bonus * 0.925;
            end
        else
            nBonus = (3.0 / 3.5) * bonus;
        end

        -- Detect healing way on target
        local hwMod = VisualHeal:DetectBuff(target, "Spell_Nature_HealingWay");
        if (hwMod) then 
            hwMod = 1.0 + 0.06 * hwMod;
        else 
            hwMod = 1.0;
        end;

        spellInfo.EffectiveHeal = hwMod * powerInfusion * talentPurification * (spellInfo.Heal + nBonus * VisualHeal:GetSpellBonusHealingPenalty(spellTab[rank], UnitLevel('player'))); 
    elseif (name == VISUALHEAL_SPELL_CHAIN_HEAL) then
        -- Improved Chain Heal Talent (increases healing by 10% per rank)
        local _, _, _, _, talentImprovedChainHeal = GetTalentInfo(3,19); 
        talentImprovedChainHeal = 10 * talentImprovedChainHeal / 100 + 1;

        spellInfo.EffectiveHeal = talentImprovedChainHeal * powerInfusion * talentPurification * (spellInfo.Heal + ((2.5 / 3.5) * bonus) * VisualHeal:GetSpellBonusHealingPenalty(spellTab[rank], UnitLevel('player')));
    end

    return spellInfo;
end
