VisualHeal.Priest = {};

VisualHeal.Priest.HealingSpells = {};
VisualHeal.Priest.HealingSpells[VISUALHEAL_SPELL_LESSER_HEAL] = {3, 9, 15};
VisualHeal.Priest.HealingSpells[VISUALHEAL_SPELL_HEAL] = {21, 27, 33, 39};
VisualHeal.Priest.HealingSpells[VISUALHEAL_SPELL_GREATER_HEAL] = {45, 51, 57, 59, 62, 67, 70};
VisualHeal.Priest.HealingSpells[VISUALHEAL_SPELL_FLASH_HEAL] = {25, 31, 37, 43, 49, 55, 60, 66, 70};

function VisualHeal.Priest:GetSpellInfo(name, rank, target)
    local i, powerInfusion;

    -- Get static spell info (cached by main module)
    local spellInfo = VisualHeal:GetSpellInfo(name)[rank];

    if (not spellInfo) then
        return nil;
    end

    -- Get +healing bonus
    local bonus = GetSpellBonusHealing();

    local spellTab = self.HealingSpells[name];

    -- Detect Power Infusion
    if (VisualHeal:DetectBuff('player', "Spell_Holy_PowerInfusion")) then
        powerInfusion = 1.2;
    else
        powerInfusion = 1.0;
    end

    -- Spiritual Healing - Increases healing by 2% per rank on all spells
    local _, _, _, _, talentSpiritualHealing = GetTalentInfo(2, 16);
    local talentSpiritualHealing = 2 * talentSpiritualHealing / 100 + 1;

    -- Process individual spells
    if (name == VISUALHEAL_SPELL_LESSER_HEAL) then
        local nBonus;
        if (rank == 1) then
            nBonus = (1.5 / 3.5) * bonus * 0.2875;
        elseif (rank == 2) then
            nBonus = (2.0 / 3.5) * bonus * 0.4;
        elseif (rank == 3) then
            nBonus = (2.5 / 3.5) * bonus * 0.625;
        end
        spellInfo.EffectiveHeal = talentSpiritualHealing * powerInfusion * (spellInfo.Heal + nBonus * VisualHeal:GetSpellBonusHealingPenalty(spellTab[rank], UnitLevel('player')));
    elseif (name == VISUALHEAL_SPELL_HEAL) then
        spellInfo.EffectiveHeal = talentSpiritualHealing * powerInfusion * (spellInfo.Heal + ((3.0 / 3.5) * bonus) * VisualHeal:GetSpellBonusHealingPenalty(spellTab[rank], UnitLevel('player')));
    elseif (name == VISUALHEAL_SPELL_GREATER_HEAL) then
        -- Empowered Healing
        local _, _, _, _, talentEmpoweredHealing = GetTalentInfo(2, 20);
        local nBonus = (3.0 / 3.5) * bonus * (4 * talentEmpoweredHealing / 100 + 1);
        spellInfo.EffectiveHeal = talentSpiritualHealing * powerInfusion * (spellInfo.Heal + nBonus * VisualHeal:GetSpellBonusHealingPenalty(spellTab[rank], UnitLevel('player')));
    elseif (name == VISUALHEAL_SPELL_FLASH_HEAL) then
        -- Empowered Healing
        local _, _, _, _, talentEmpoweredHealing = GetTalentInfo(2, 20);
        local nBonus = (1.5 / 3.5) * bonus * (2 * talentEmpoweredHealing / 100 + 1);
        spellInfo.EffectiveHeal = talentSpiritualHealing * powerInfusion * (spellInfo.Heal + nBonus * VisualHeal:GetSpellBonusHealingPenalty(spellTab[rank], UnitLevel('player')));
    end

    return spellInfo;
end


