VisualHeal.Paladin = {};

VisualHeal.Paladin.HealingSpells = {};
VisualHeal.Paladin.HealingSpells[VISUALHEAL_SPELL_HOLY_LIGHT] = {5, 13, 21, 29, 37, 45, 53, 59, 61, 69, 70};
VisualHeal.Paladin.HealingSpells[VISUALHEAL_SPELL_FLASH_OF_LIGHT] = {25, 33, 41, 49, 57, 65, 70};

VisualHeal.Paladin.Librams = {
    [23006] = 83, -- LibramOfLight
    [23201] = 53  -- LibramOfDivinity
}

function VisualHeal.Paladin:GetSpellInfo(name, rank, target)
    local i, powerInfusion;

    -- Get static spell info (cached by main module)
    local spellInfo = VisualHeal:GetSpellInfo(name)[rank];

    if (not spellInfo) then
        return nil;
    end

    -- Get +healing bonus
    local bonus = GetSpellBonusHealing();

    local spellTab = self.HealingSpells[name];

    -- Detect Power Infusion
    if (VisualHeal:DetectBuff('player', "Spell_Holy_PowerInfusion")) then
        powerInfusion = 1.2;
    else
        powerInfusion = 1.0;
    end

    -- Healing Light - Increases healing by 4% per rank on all spells
    local _, _, _, _, talentHealingLight = GetTalentInfo(1, 5);
    local talentHealingLight = 4 * talentHealingLight / 100 + 1;

    -- Process individual spells
    if (name == VISUALHEAL_SPELL_FLASH_OF_LIGHT) then
        local libramBonus = self.Librams[VisualHeal:GetEquippedRelicID()];
        spellInfo.EffectiveHeal = talentHealingLight * powerInfusion * (spellInfo.Heal + ((1.5 / 3.5) * (bonus + (libramBonus or 0))) * VisualHeal:GetSpellBonusHealingPenalty(spellTab[rank], UnitLevel('player')));
    elseif (name == VISUALHEAL_SPELL_HOLY_LIGHT) then
        local nBonus;
        if (rank == 1) then
            nBonus = (2.5 / 3.5) * bonus * 0.2875;
        elseif (rank == 2) then
            nBonus = (2.5 / 3.5) * bonus * 0.475;
        elseif (rank == 3) then
            nBonus = (2.5 / 3.5) * bonus * 0.775;
        else
            nBonus = (2.5 / 3.5) * bonus;
        end
        spellInfo.EffectiveHeal = talentHealingLight * powerInfusion * (spellInfo.Heal + nBonus * VisualHeal:GetSpellBonusHealingPenalty(spellTab[rank], UnitLevel('player')));
    end

    return spellInfo;
end

